from AppliDef import *


class FrmAffichData(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, RatioY2, IndexFile, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.RatioY2 = RatioY2
        self.IndexFile = IndexFile

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmDetails/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmDetails/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift(container)

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmDetails/BtnClose/', self.RatioX, self.RatioY2, self.CanvasFrmFond,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmDataSketch)

        coefY = float(ConfigResolution(self.MainAppli.Nconfig, 'MD'))
        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, 'Données du Sketch', '#E0E0E0', FontLabel(10),
                                      int(self.SX * 0.005), int(self.SY * coefY))

        self.LabelCircuit = LabelInCanvas(self.CanvasFrmFond, 'Circuit:', 'white', FontLabelTitre(12),
                                          int(self.SX * 0.015), int(self.SY * 0.05))
        self.CanvasImgCircuit = CanvasApp(self.CanvasFrmFond, width=self.MainAppli.imghsize,
                                          height=self.MainAppli.imgwsize, bg='grey')
        self.CanvasImgCircuit.config(bd=3)
        self.CanvasFrmFond.create_window(int(self.SX * 0.015), int(self.SY * 0.085), anchor=tk.NW,
                                         window=self.CanvasImgCircuit)
        self.ImgCanvasImgCircuit = self.CanvasImgCircuit.create_image(int(self.MainAppli.imghsize / 2),
                                                                      int(self.MainAppli.imgwsize / 2),
                                                                      anchor=tk.CENTER,
                                                                      image=self.MainAppli.ImgCircuit[
                                                                          self.IndexFile])

        self.LabelCat = LabelInCanvas(self.CanvasFrmFond, 'Catégorie:', 'white', FontLabelTitre(12),
                                      int(self.SX * 0.015), int(self.SY * 0.85))
        self.DataCat = tk.StringVar()
        self.DataCat.set('')
        self.EntryCat = tk.Entry(self.CanvasFrmFond, width=int(self.SX * 0.021), font=FontLabel2(12),
                                 textvariable=self.DataCat, state='disabled')
        self.CanvasFrmFond.create_window(int(self.SX * 0.015), int(self.SY * 0.885), anchor=tk.NW,
                                         window=self.EntryCat)
        if self.MainAppli.ListSketchs[self.IndexFile][6] is not None:
            self.DataCat.set(self.MainAppli.ListSketchs[self.IndexFile][6])

        self.LabelTitre = LabelInCanvas(self.CanvasFrmFond, 'Titre:', 'white', FontLabelTitre(12),
                                        int(self.SX * 0.282), int(self.SY * 0.050))
        self.DataTitre = tk.StringVar()
        self.DataTitre.set(self.MainAppli.ListTitreSketchs[self.IndexFile])
        self.EntryTitre = tk.Entry(self.CanvasFrmFond, width=int(self.SX * 0.03), font=FontLabel2(14),
                                   textvariable=self.DataTitre, state='disabled')
        self.CanvasFrmFond.create_window(int(self.SX * 0.282), int(self.SY * 0.085), anchor=tk.NW,
                                         window=self.EntryTitre)

        self.LabelComp = LabelInCanvas(self.CanvasFrmFond, 'Liste des composants:', 'white', FontLabelTitre(12),
                                       int(self.SX * 0.282), int(self.SY * 0.15))
        self.ZoneTextComp = ZoneScrolledText(self.CanvasFrmFond, width=int(self.SX * 0.043),
                                             height=int(self.SY * 0.008), font=FontText(10))
        self.CanvasFrmFond.create_window(int(self.SX * 0.282), int(self.SY * 0.185), anchor=tk.NW,
                                         window=self.ZoneTextComp)

        if self.MainAppli.ListSketchs[self.IndexFile][2] is not None:
            fichier = open(self.MainAppli.ListSketchs[self.IndexFile][2], 'r', encoding="utf-8")
            for ligne in fichier:
                self.ZoneTextComp.insert(tk.INSERT, ligne)
        else:
            self.ZoneTextComp.insert(tk.INSERT, '')
        self.ZoneTextComp.config(state='disabled')

        self.LabelObj = LabelInCanvas(self.CanvasFrmFond, 'Objectifs:', 'white', FontLabelTitre(12),
                                      int(self.SX * 0.282), int(self.SY * 0.365))
        self.ZoneTextObjectif = ZoneScrolledText(self.CanvasFrmFond, width=int(self.SX * 0.043),
                                                 height=int(self.SY * 0.01), font=FontText(10))
        self.CanvasFrmFond.create_window(int(self.SX * 0.282), int(self.SY * 0.4), anchor=tk.NW,
                                         window=self.ZoneTextObjectif)

        if self.MainAppli.ListSketchs[self.IndexFile][3] is not None:
            fichier = open(self.MainAppli.ListSketchs[self.IndexFile][3], 'r', encoding="utf-8")
            for ligne in fichier:
                self.ZoneTextObjectif.insert(tk.INSERT, ligne)
        else:
            self.ZoneTextObjectif.insert(tk.INSERT, '')

        self.ZoneTextObjectif.config(state='disabled')

        self.LabelCode = LabelInCanvas(self.CanvasFrmFond, 'Code:', 'white', FontLabelTitre(12),
                                       int(self.SX * 0.282), int(self.SY * 0.615))
        self.ZoneTextCode = ZoneScrolledText(self.CanvasFrmFond, width=int(self.SX * 0.043),
                                             height=int(self.SY * 0.021), font=FontText2(10))
        self.CanvasFrmFond.create_window(int(self.SX * 0.282), int(self.SY * 0.65), anchor=tk.NW,
                                         window=self.ZoneTextCode)

        if self.MainAppli.ListSketchs[self.IndexFile][4] is not None:
            fichier = open(self.MainAppli.ListSketchs[self.IndexFile][4], 'r', encoding="utf-8")
            for ligne in fichier:
                self.ZoneTextCode.insert(tk.INSERT, ligne)
        else:
            self.ZoneTextCode.insert(tk.INSERT, '')

        self.ZoneTextCode.config(state='disabled')

        self.LabelDoc = LabelInCanvas(self.CanvasFrmFond, 'Documentation:', 'white', FontLabelTitre(12),
                                      int(self.SX * 0.65), int(self.SY * 0.05))

        if self.MainAppli.ListSketchs[self.IndexFile][5] is not None:
            self.PathFilePDF = self.MainAppli.ListSketchs[self.IndexFile][5]
            self.FrmPDF = FrmPDF(self.CanvasFrmFond, self.PathFilePDF, 1, int(self.SX * 0.82), int(self.SY * 0.5),
                                 int(self.SX * 0.32), int(self.SY * 0.78), self.RatioX, self.RatioY2, 0.5, 0.54)
        else:
            self.NoPDF = NoPDF(self.CanvasFrmFond, int(self.SX * 0.81), int(self.SY / 2),
                               self.MainAppli.RatioImgPhotoCircuitsX, self.MainAppli.RatioImgPhotoCircuitsY)

        self.BtnModif = BtnAction(self.CanvasFrmFond, int(self.SX * 0.8), int(self.SY * 0.955), self.RatioX,
                                  self.RatioY2, 'Media/FrmDetails/BtnModif/')
        self.BtnModif.CanvasBtn.bind('<ButtonRelease-1>', self.ModifData)
        self.BtnModif.CanvasBtn.bind('<Motion>', self.MoveOnBtn1)

        self.BtnQuit = BtnAction(self.CanvasFrmFond, int(self.SX * 0.85), int(self.SY * 0.955), self.RatioX,
                                 self.RatioY2,
                                 'Media/FrmDetails/BtnAnnul/')
        self.BtnQuit.CanvasBtn.bind('<ButtonRelease-1>', self.CacheFrmDataSketch)
        self.BtnQuit.CanvasBtn.bind('<Motion>', self.MoveOnBtn2)

        self.LabelAction = self.CanvasFrmFond.create_text(int(self.SX * 0.88), int(self.SY * 0.96),
                                                          text='', font=FontLabel(10), anchor=tk.W)
        self.CanvasFrmFond.addtag_withtag('LabelAction', self.LabelAction)

        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

    def ModifData(self, evt):
        self.BtnModif.CanvasBtn.itemconfig(self.BtnModif.ImgCanvasBtn, image=self.BtnModif.ImgBtn[0])
        self.CanvasFrmFond.itemconfigure('LabelAction', text='')
        self.lower()
        self.MainAppli.ModifDataSketch(evt)

    def MoveOnCanvas(self, _):
        self.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.ImgCanvasBtnQuit, image=self.MainAppli.ImgBtnQuit[0])
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.CanvasFrmFond.itemconfigure('LabelAction', text='')

    def CacheFrmDataSketch(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.BtnQuit.CanvasBtn.itemconfig(self.BtnQuit.ImgCanvasBtn, image=self.BtnQuit.ImgBtn[0])
        self.CanvasFrmFond.itemconfigure('LabelAction', text='')
        self.destroy()
        self.MainAppli.parent.lift()
        self.MainAppli.AffichData = False
        self.MainAppli.MAJInfo()
        self.MainAppli.FrmLift()

    def MoveOnBtn1(self, _):
        self.CanvasFrmFond.itemconfigure('LabelAction', text="Modifier les données")

    def MoveOnBtn2(self, _):
        self.CanvasFrmFond.itemconfigure('LabelAction', text="Fermer la fenêtre des données")


