from AppliDef import *


class FrmEtagCircuits(tk.Toplevel):
    def __init__(self, container, NEtag, RatioX, RatioY, ListCircuitSketchs, ListTitreSketchs, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.NEtag = NEtag
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.ListCircuitSketchs = ListCircuitSketchs
        self.ListTitreSketchs = ListTitreSketchs

        screen = ctypes.windll.user32
        self.RatioImgPhotoCircuits = 0
        self.ImgCircuit = []
        self.CanvasImgCircuit = []
        self.CanvasBarreSelect = []
        self.BarreSelect = []
        self.ImgBarreSelect = []
        self.TxtBarreSelect = []
        self.Ncircuit = 0
        self.MenuClicDroit = []

        FrmFond = Image.open('Media/FrmEtagCircuits/Etag/Etag.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmEtagCircuits/Etag/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.176)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.083)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift(container)

        self.CanvasFrmFond.bind('<MouseWheel>', self.MainAppli.MouseWheelDefil)

        if len(self.ListCircuitSketchs) > 0:
            self.AffichCircuits()

        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

        if self.MainAppli.IndexFile >= 0:
            self.SelectCircuits(self.MainAppli.IndexFile)

    def AffichCircuits(self):
        WidthPhotoCircuits = self.SX * 0.48
        PhotoCircuit = Image.open(self.ListCircuitSketchs[0])
        HeightPhotoCircuits = WidthPhotoCircuits * float(PhotoCircuit.size[1]) / float(PhotoCircuit.size[0])
        RatioImgPhotoCircuitsX = WidthPhotoCircuits / float(PhotoCircuit.size[0])
        RatioImgPhotoCircuitsY = HeightPhotoCircuits / float(PhotoCircuit.size[1])

        wsize = 0
        hsize = 0
        for i in range(len(self.ListCircuitSketchs)):
            img = Image.open(self.ListCircuitSketchs[i])
            wsize = int((float(img.size[0]) * float(RatioImgPhotoCircuitsX)))
            hsize = int((float(img.size[1]) * float(RatioImgPhotoCircuitsY)))
            img = img.resize((wsize, hsize), Image.ANTIALIAS)
            self.ImgCircuit.append(ImageTk.PhotoImage(img))

        self.BarreSelect, bwsize, bhsize = ChargeDossierImg('Media/FrmEtagCircuits/Select/', self.RatioX, self.RatioY)

        l = 0
        self.Ncircuit = 0
        if len(self.ListTitreSketchs) > 4:
            imax = (self.NEtag + 1) * 4
            if imax > len(self.ListTitreSketchs):
                imax = len(self.ListTitreSketchs)
            imin = self.NEtag * 4
        else:
            imax = len(self.ListTitreSketchs)
            imin = 0

        for i in range(imin, imax):
            if i > imin + 1:
                l = 1
            if i == imin + 1 or i == imin + 3:
                c = 1
            else:
                c = 0
            self.CanvasImgCircuit.append(CanvasApp(self.CanvasFrmFond, width=wsize, height=hsize, bg='grey'))
            self.CanvasFrmFond.create_window(int(self.SX * 0.255) + c * (self.SX * 0.014 + wsize),
                                             int(self.SY * 0.45 + l * (self.SY * 0.483)), anchor=tk.S,
                                             window=self.CanvasImgCircuit[self.Ncircuit])
            self.CanvasImgCircuit[self.Ncircuit].create_image(0, 0, anchor=tk.NW, image=self.ImgCircuit[i])
            self.CanvasImgCircuit[self.Ncircuit].config(bd=2)
            ChangeCursor(self.CanvasImgCircuit[self.Ncircuit])

            self.MenuClicDroit.append(tk.Menu(self.CanvasImgCircuit[self.Ncircuit], tearoff=0))

            def GestEvt(evt, j=i):
                return self.AffichSketch(evt, j)

            def GestEvt2(evt):
                return self.AffichDataSketch(evt)

            def GestEvt3(evt, j=self.Ncircuit):
                return self.AffichMenuClicDroit(evt, j)

            self.CanvasImgCircuit[self.Ncircuit].bind('<Button-1>', GestEvt)
            self.CanvasImgCircuit[self.Ncircuit].bind('<Double-1>', GestEvt2)
            self.CanvasImgCircuit[self.Ncircuit].bind("<Button-3>", GestEvt3)

            self.MenuClicDroit[self.Ncircuit].add_command(label="Afficher les données",
                                                          command=self.ActionAffichDataSketch)
            self.MenuClicDroit[self.Ncircuit].add_command(label="Modifier les données",
                                                          command=self.ActionModifDataSketch)
            self.MenuClicDroit[self.Ncircuit].add_separator()
            self.MenuClicDroit[self.Ncircuit].add_command(label="Voir le code", command=self.ActionAffichIno)
            self.MenuClicDroit[self.Ncircuit].add_command(label="Téléverser le code", command=self.ActionSendIno)

            self.CanvasBarreSelect.append(CanvasApp(self.CanvasFrmFond, width=bwsize, height=bhsize))
            self.CanvasFrmFond.create_window(int(self.SX * 0.255) + c * (self.SX * 0.014 + wsize),
                                             int(self.SY * 0.510 + l * (self.SY * 0.483)), anchor=tk.S,
                                             window=self.CanvasBarreSelect[self.Ncircuit])
            self.ImgBarreSelect.append(self.CanvasBarreSelect[self.Ncircuit].create_image(0, 0, anchor=tk.NW,
                                                                                          image=self.BarreSelect[c]))
            self.TxtBarreSelect.append(
                self.CanvasBarreSelect[self.Ncircuit].create_text(int(bwsize / 2), int(bhsize / 2), anchor=tk.CENTER,
                                                                  text=self.ListTitreSketchs[i], fill='white',
                                                                  font=FontLabel2(10)))
            self.Ncircuit = self.Ncircuit + 1

    def AffichSketch(self, _, j):
        if not self.MainAppli.FrmFindVisible and not self.MainAppli.ActionCat:
            self.MainAppli.Init = False
            self.MainAppli.IndexFile = j
            if self.MainAppli.ActionFind:
                self.MainAppli.IndexFileFind = self.MainAppli.ListTitreSketchs.index(self.MainAppli.ListRecherch[j][0])
            if self.MainAppli.SelectCat:
                self.MainAppli.IndexFileFind = self.MainAppli.ListTitreSketchs.index(
                    self.MainAppli.ListSketchsCat[j][0])
            self.MainAppli.AffichSketch(j)
            self.MainAppli.ListBoxFichiers.selection_clear(0, tk.END)
            self.MainAppli.ListBoxFichiers.selection_set(self.MainAppli.IndexFile)

    def SelectCircuits(self, j):
        if len(self.ListTitreSketchs) > 0:
            if j > 3:
                j = j % 4
            for i in range(self.Ncircuit):
                if i < 2:
                    n = i
                else:
                    n = i - 2
                self.CanvasBarreSelect[i].itemconfig(self.ImgBarreSelect[i], image=self.BarreSelect[n])
            if j == 0 or j == 2:
                n = 2
            else:
                n = 3
            self.CanvasBarreSelect[j].itemconfig(self.ImgBarreSelect[j], image=self.BarreSelect[n])
            self.lift(self.parent)

    def ModifCircuit(self, evt):
        self.MainAppli.Init = False
        self.MainAppli.ModifDataSketch(evt)

    def AffichDataSketch(self, _):
        self.ActionAffichDataSketch()

    def ActionAffichDataSketch(self):
        self.MainAppli.Init = False
        self.MainAppli.AffichDataSketch()

    def ActionModifDataSketch(self):
        self.MainAppli.Init = False
        self.MainAppli.ActionModifDataSketch()

    def ActionAffichIno(self):
        self.MainAppli.Init = False
        self.MainAppli.ActionAffichIno()
        self.MainAppli.parent.lift()
        self.MainAppli.FrmLift()

    def ActionSendIno(self):
        self.MainAppli.Init = False
        self.MainAppli.ActionAffichIno()
        self.MainAppli.FrmINO.ActionTeleverser()

    def MoveOnCanvas(self, _):
        self.MainAppli.InitOnglets()

    def AffichMenuClicDroit(self, event, j):
        self.MenuClicDroit[j].post(event.x_root, event.y_root)
        self.AffichSketch(event, j+self.NEtag*4)
