import tkinter as tk
import tkinter.font as tkFont
import tkinter.scrolledtext as tkst
import tkinter.filedialog as tkfiledialog
import tkinter.messagebox as tkMB
import tkinter.ttk as ttk


class FrmMainApp(tk.Tk):
    def __init__(self, titre):
        tk.Tk.__init__(self, titre)

        self.wm_title(titre)
        self.frmwidth = self.winfo_screenwidth()
        self.frmheight = self.winfo_screenheight()
        self.geometry(str(self.frmwidth) + "x" + str(self.frmheight) + "+0+0")
        self.resizable(width=False, height=False)
        self.overrideredirect(True)


class CanvasApp(tk.Canvas):
    def __init__(self, container, **kwargs):
        kwargs['bd'] = 0
        kwargs['highlightthickness'] = 0

        tk.Canvas.__init__(self, container, **kwargs)


class FontLabel(tkFont.Font):
    def __init__(self, size, **kwargs):
        kwargs['family'] = 'Helvetica'
        kwargs['size'] = size
        kwargs['weight'] = 'normal'
        kwargs['slant'] = 'roman'
        kwargs['underline'] = 0
        kwargs['overstrike'] = 0

        tkFont.Font.__init__(self, **kwargs)


class FontLabelTitre(tkFont.Font):
    def __init__(self, size, **kwargs):
        kwargs['family'] = 'Helvetica'
        kwargs['size'] = size
        kwargs['weight'] = 'bold'
        kwargs['slant'] = 'roman'
        kwargs['underline'] = 1
        kwargs['overstrike'] = 0

        tkFont.Font.__init__(self, **kwargs)


class FontLabel2(tkFont.Font):
    def __init__(self, size, **kwargs):
        kwargs['family'] = 'Helvetica'
        kwargs['size'] = size
        kwargs['weight'] = 'bold'
        kwargs['slant'] = 'roman'
        kwargs['underline'] = 0
        kwargs['overstrike'] = 0

        tkFont.Font.__init__(self, **kwargs)


class LabelText(tk.Label):
    def __init__(self, container, Txt, Color, **kwargs):
        kwargs['text'] = Txt
        kwargs['bg'] = Color
        kwargs['padx'] = 0
        kwargs['pady'] = 0
        kwargs['highlightthickness'] = 0

        tk.Label.__init__(self, container, **kwargs)


class ZoneScrolledText(tkst.ScrolledText):
    def __init__(self, container, **kwargs):
        kwargs['wrap'] = 'word'
        kwargs['highlightthickness'] = 0
        kwargs['borderwidth'] = 2
        kwargs['padx'] = 20
        kwargs['pady'] = 10
        tkst.ScrolledText.__init__(self, container, **kwargs)


class FontText(tkFont.Font):
    def __init__(self, size, **kwargs):
        kwargs['family'] = 'Monospaced'
        kwargs['size'] = size
        kwargs['weight'] = 'normal'
        kwargs['slant'] = 'roman'
        kwargs['underline'] = 0
        kwargs['overstrike'] = 0

        tkFont.Font.__init__(self, **kwargs)


class FontText2(tkFont.Font):
    def __init__(self, size, **kwargs):
        kwargs['family'] = 'Calibri'
        kwargs['size'] = size
        kwargs['weight'] = 'normal'
        kwargs['slant'] = 'roman'
        kwargs['underline'] = 0
        kwargs['overstrike'] = 0

        tkFont.Font.__init__(self, **kwargs)


class LabelInCanvas:
    def __init__(self, container, Txt, Color, Font, X, Y):
        self.Label = LabelText(container, Txt, Color, font=Font)
        container.create_window(X, Y, anchor=tk.NW, window=self.Label)


class LabelInCanvasE:
    def __init__(self, container, Txt, Color, Font, X, Y):
        self.Label = LabelText(container, Txt, Color, font=Font)
        container.create_window(X, Y, anchor=tk.E, window=self.Label)


class LabelInCanvasC:
    def __init__(self, container, Txt, Color, Font, X, Y):
        self.Label = LabelText(container, Txt, Color, font=Font)
        container.create_window(X, Y, anchor=tk.CENTER, window=self.Label)


class ListeDeroulante(ttk.Combobox):
    def __init__(self, container, Width, **kwargs):
        kwargs['width'] = Width
        kwargs['state'] = 'readonly'
        ttk.Combobox.__init__(self, container, **kwargs)


class LabelVar(tk.Label):
    def __init__(self, container, Var, Color, **kwargs):
        kwargs['textvariable'] = Var
        kwargs['bg'] = Color
        kwargs['padx'] = 0
        kwargs['pady'] = 0
        kwargs['highlightthickness'] = 0

        tk.Label.__init__(self, container, **kwargs)


class CaseACocher(tk.Checkbutton):
    def __init__(self, container, Txt, **kwargs):
        kwargs['bd'] = 0
        kwargs['highlightthickness'] = 0
        kwargs['text'] = Txt
        kwargs['relief'] = 'solid'

        tk.Checkbutton.__init__(self, container, **kwargs)
