from AppliDef import *
from ModifCircuit import *
import shutil


class FrmModifData(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, RatioY2, IndexFile, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.RatioY2 = RatioY2
        self.MainAppli.ModifData = True
        self.IndexFile = IndexFile
        self.ModifComp = False
        self.ModifObj = False
        self.ZonesText = []
        self.TypModif = ['Composants', 'Descript', 'Codes']
        self.TypRequet = ['composants', 'descript', 'code']
        self.Modif = [False, False, False]
        self.PathFilePDFToOpen = ''
        self.PathFilePDF = ''
        self.PathFileTXTToOpen = ''
        self.FrmModifCircuit = None
        self.ImgCircuitModif = []
        self.ModifImgCircuit = False

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmDetails/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmDetails/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift(container)

        coefY = float(ConfigResolution(self.MainAppli.Nconfig, 'MD'))
        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, 'Modifier les données du Sketch', '#E0E0E0', FontLabel(10),
                                      int(self.SX * 0.005), int(self.SY * coefY))

        self.LabelCircuit = LabelInCanvas(self.CanvasFrmFond, 'Circuit:', 'white', FontLabelTitre(12),
                                          int(self.SX * 0.015), int(self.SY * 0.05))
        self.CanvasImgCircuit = CanvasApp(self.CanvasFrmFond, width=self.MainAppli.imghsize,
                                          height=self.MainAppli.imgwsize, bg='grey')
        self.CanvasImgCircuit.config(bd=3)
        self.CanvasFrmFond.create_window(int(self.SX * 0.015), int(self.SY * 0.085), anchor=tk.NW,
                                         window=self.CanvasImgCircuit)
        self.ImgCanvasImgCircuit = self.CanvasImgCircuit.create_image(int(self.MainAppli.imghsize / 2),
                                                                      int(self.MainAppli.imgwsize / 2),
                                                                      anchor=tk.CENTER,
                                                                      image=self.MainAppli.ImgCircuit[
                                                                          self.IndexFile])
        ChangeCursor(self.CanvasImgCircuit)
        self.CanvasImgCircuit.bind("<Button-1>", self.ModifCircuit)

        self.LabelCat = LabelInCanvas(self.CanvasFrmFond, 'Catégorie:', 'white', FontLabelTitre(12),
                                      int(self.SX * 0.015), int(self.SY * 0.85))
        self.DataCat = tk.StringVar()
        self.DataCat.set('')
        self.EntryCat = tk.Entry(self.CanvasFrmFond, width=int(self.SX * 0.021), font=FontLabel2(12),
                                 textvariable=self.DataCat)
        self.CanvasFrmFond.create_window(int(self.SX * 0.015), int(self.SY * 0.885), anchor=tk.NW,
                                         window=self.EntryCat)
        if self.MainAppli.ListSketchs[self.IndexFile][6] is not None:
            self.DataCat.set(self.MainAppli.ListSketchs[self.IndexFile][6])

        self.LabelTitre = LabelInCanvas(self.CanvasFrmFond, 'Titre:', 'white', FontLabelTitre(12),
                                        int(self.SX * 0.282), int(self.SY * 0.050))
        self.DataTitre = tk.StringVar()
        self.DataTitre.set(self.MainAppli.ListTitreSketchs[self.IndexFile])
        self.EntryTitre = tk.Entry(self.CanvasFrmFond, width=int(self.SX * 0.03), font=FontLabel2(14),
                                   textvariable=self.DataTitre)
        self.CanvasFrmFond.create_window(int(self.SX * 0.282), int(self.SY * 0.085), anchor=tk.NW,
                                         window=self.EntryTitre)

        self.LabelComp = LabelInCanvas(self.CanvasFrmFond, 'Liste des composants:', 'white', FontLabelTitre(12),
                                       int(self.SX * 0.282), int(self.SY * 0.15))
        self.ZoneTextComp = ZoneScrolledText(self.CanvasFrmFond, width=int(self.SX * 0.043),
                                             height=int(self.SY * 0.008), font=FontText(10))
        self.CanvasFrmFond.create_window(int(self.SX * 0.282), int(self.SY * 0.185), anchor=tk.NW,
                                         window=self.ZoneTextComp)

        if self.MainAppli.ListSketchs[self.IndexFile][2] is not None:
            fichier = open(self.MainAppli.ListSketchs[self.IndexFile][2], 'r', encoding="utf-8")
            for ligne in fichier:
                self.ZoneTextComp.insert(tk.INSERT, ligne)
        else:
            self.ZoneTextComp.insert(tk.INSERT, '')
        self.ZoneTextComp.tag_add('ZoneTextCompTag', 0.0, tk.END)
        self.ZoneTextComp.tag_bind('ZoneTextCompTag', '<KeyPress>', self.ModifCompEnCours)
        self.ZonesText.append(self.ZoneTextComp)

        self.LabelObj = LabelInCanvas(self.CanvasFrmFond, 'Objectifs:', 'white', FontLabelTitre(12),
                                      int(self.SX * 0.282), int(self.SY * 0.365))
        self.ZoneTextObjectif = ZoneScrolledText(self.CanvasFrmFond, width=int(self.SX * 0.043),
                                                 height=int(self.SY * 0.01), font=FontText(10))
        self.CanvasFrmFond.create_window(int(self.SX * 0.282), int(self.SY * 0.4), anchor=tk.NW,
                                         window=self.ZoneTextObjectif)

        if self.MainAppli.ListSketchs[self.IndexFile][3] is not None:
            fichier = open(self.MainAppli.ListSketchs[self.IndexFile][3], 'r', encoding="utf-8")
            for ligne in fichier:
                self.ZoneTextObjectif.insert(tk.INSERT, ligne)
        else:
            self.ZoneTextObjectif.insert(tk.INSERT, '')
        self.ZoneTextObjectif.tag_add('ZoneTextObjectifTag', 0.0, tk.END)
        self.ZoneTextObjectif.tag_bind('ZoneTextObjectifTag', '<KeyPress>', self.ModifObjEnCours)
        self.ZonesText.append(self.ZoneTextObjectif)

        self.LabelCode = LabelInCanvas(self.CanvasFrmFond, 'Code:', 'white', FontLabelTitre(12),
                                       int(self.SX * 0.282), int(self.SY * 0.615))
        self.ZoneTextCode = ZoneScrolledText(self.CanvasFrmFond, width=int(self.SX * 0.043),
                                             height=int(self.SY * 0.021), font=FontText2(10))
        self.CanvasFrmFond.create_window(int(self.SX * 0.282), int(self.SY * 0.65), anchor=tk.NW,
                                         window=self.ZoneTextCode)

        if self.MainAppli.ListSketchs[self.IndexFile][4] is not None:
            fichier = open(self.MainAppli.ListSketchs[self.IndexFile][4], 'r', encoding="utf-8")
            for ligne in fichier:
                self.ZoneTextCode.insert(tk.INSERT, ligne)
        else:
            self.ZoneTextCode.insert(tk.INSERT, '')
        self.ZoneTextCode.tag_add('ZoneTextCodeTag', 0.0, tk.END)
        self.ZoneTextCode.tag_bind('ZoneTextCodeTag', '<KeyPress>', self.ModifCodeEnCours)
        self.ZonesText.append(self.ZoneTextCode)

        self.LabelDoc = LabelInCanvas(self.CanvasFrmFond, 'Documentation:', 'white', FontLabelTitre(12),
                                      int(self.SX * 0.65), int(self.SY * 0.05))

        if self.MainAppli.ListSketchs[self.IndexFile][5] is not None:
            self.PathFilePDF = self.MainAppli.ListSketchs[self.IndexFile][5]
            self.FrmPDF = FrmPDF(self.CanvasFrmFond, self.PathFilePDF, 1, int(self.SX * 0.82), int(self.SY * 0.5),
                                 int(self.SX * 0.32), int(self.SY * 0.78), self.RatioX, self.RatioY2, 0.5, 0.54)
        else:
            self.NoPDF = NoPDF(self.CanvasFrmFond, int(self.SX * 0.81), int(self.SY / 2),
                               self.MainAppli.RatioImgPhotoCircuitsX, self.MainAppli.RatioImgPhotoCircuitsY)
            ChangeCursor(self.NoPDF.CanvasImgNoPdf)
            self.NoPDF.CanvasImgNoPdf.bind('<ButtonRelease-1>', self.ChargePDF)

        self.BtnOK = BtnAction(self.CanvasFrmFond, int(self.SX * 0.8), int(self.SY * 0.955), self.RatioX,
                               self.RatioY2, 'Media/FrmDetails/BtnOK/')
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ModifDataOK)
        self.BtnOK.CanvasBtn.bind('<Motion>', self.MoveOnBtn1)

        self.BtnAnnul = BtnAction(self.CanvasFrmFond, int(self.SX * 0.85), int(self.SY * 0.955), self.RatioX,
                                  self.RatioY2,
                                  'Media/FrmDetails/BtnAnnul/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.ModifDataAnnul)
        self.BtnAnnul.CanvasBtn.bind('<Motion>', self.MoveOnBtn2)

        self.ListBtnSupp = []
        self.ListBtnTXT = []

        self.BtnImportTXTComp = BtnAction(self.CanvasFrmFond, int(self.SX * 0.58), int(self.SY * 0.165), self.RatioX,
                                          self.RatioY2, 'Media/FrmDetails/BtnTXT/')
        self.ListBtnTXT.append(self.BtnImportTXTComp)
        self.BtnSuppComp = BtnAction(self.CanvasFrmFond, int(self.SX * 0.6), int(self.SY * 0.165), self.RatioX,
                                     self.RatioY2, 'Media/FrmDetails/BtnSupp/')
        self.ListBtnSupp.append(self.BtnSuppComp)

        self.BtnImportTXTObj = BtnAction(self.CanvasFrmFond, int(self.SX * 0.58), int(self.SY * 0.379), self.RatioX,
                                         self.RatioY2, 'Media/FrmDetails/BtnTXT/')
        self.ListBtnTXT.append(self.BtnImportTXTObj)
        self.BtnSuppObj = BtnAction(self.CanvasFrmFond, int(self.SX * 0.6), int(self.SY * 0.379), self.RatioX,
                                    self.RatioY2, 'Media/FrmDetails/BtnSupp/')
        self.ListBtnSupp.append(self.BtnSuppObj)

        self.BtnImportTXTCode = BtnAction(self.CanvasFrmFond, int(self.SX * 0.58), int(self.SY * 0.631), self.RatioX,
                                          self.RatioY2, 'Media/FrmDetails/BtnINO/')
        self.ListBtnTXT.append(self.BtnImportTXTCode)
        self.BtnSuppCode = BtnAction(self.CanvasFrmFond, int(self.SX * 0.6), int(self.SY * 0.631), self.RatioX,
                                     self.RatioY2, 'Media/FrmDetails/BtnSupp/')
        self.ListBtnSupp.append(self.BtnSuppCode)

        self.BtnImportPDF = BtnAction(self.CanvasFrmFond, int(self.SX * 0.95), int(self.SY * 0.08), self.RatioX,
                                      self.RatioY2, 'Media/FrmDetails/BtnPDF/')
        self.ListBtnTXT.append(self.BtnImportPDF)
        self.BtnSuppDoc = BtnAction(self.CanvasFrmFond, int(self.SX * 0.97), int(self.SY * 0.08), self.RatioX,
                                    self.RatioY2, 'Media/FrmDetails/BtnSupp/')
        self.ListBtnSupp.append(self.BtnSuppDoc)

        for i in range(4):
            def GestEvt(_, j=i):
                return self.ActionBtnSupp(j)

            def GestEvt2(_, j=i):
                return self.ActionBtnImport(j)

            self.ListBtnSupp[i].CanvasBtn.bind('<ButtonRelease-1>', GestEvt)
            self.ListBtnTXT[i].CanvasBtn.bind('<ButtonRelease-1>', GestEvt2)

        self.LabelAction = self.CanvasFrmFond.create_text(int(self.SX * 0.88), int(self.SY * 0.96),
                                                          text='', font=FontLabel(10), anchor=tk.W)
        self.CanvasFrmFond.addtag_withtag('LabelAction', self.LabelAction)

        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

    def ModifDataOK(self, _):
        self.BtnOK.CanvasBtn.itemconfig(self.BtnOK.ImgCanvasBtn, image=self.BtnOK.ImgBtn[0])
        self.CanvasFrmFond.itemconfigure('LabelAction', text='')
        TitreRecherche = self.EntryTitre.get()
        if self.EntryTitre.get() != self.MainAppli.ListTitreSketchs[self.IndexFile]:
            self.ActionModifTitre()
        if self.EntryCat.get() != self.MainAppli.ListSketchs[self.IndexFile][6]:
            SQLRequet = "UPDATE Sketchs SET categorie = '" + self.EntryCat.get() + "' WHERE titre = '" + \
                        self.EntryTitre.get() + "'"
            self.MainAppli.cur.execute(SQLRequet)
            self.MainAppli.DataBase.commit()
        for i in range(3):
            if self.Modif[i]:
                self.ActionModif(i)
        if self.PathFilePDFToOpen != '':
            PathFile = 'Sketchs/Docs/' + self.EntryTitre.get() + ".pdf"
            shutil.copy(self.PathFilePDFToOpen, PathFile)
            SQLRequet = "UPDATE Sketchs SET doc = '" + PathFile + "' WHERE titre = '" + \
                        self.EntryTitre.get() + "'"
            self.MainAppli.cur.execute(SQLRequet)
            self.MainAppli.DataBase.commit()
        else:
            if self.PathFilePDF == '':
                SQLRequet = "UPDATE Sketchs SET doc = null WHERE titre = '" + self.EntryTitre.get() + "'"
                self.MainAppli.cur.execute(SQLRequet)
                self.MainAppli.DataBase.commit()
        if self.ModifImgCircuit:
            self.ImgCircuitModif[0] = self.ImgCircuitModif[0].resize((935, 565), Image.ANTIALIAS)
            PathFile = 'Sketchs/Circuits/' + self.EntryTitre.get() + ".jpg"
            self.ImgCircuitModif[0].save(PathFile)
            SQLRequet = "UPDATE Sketchs SET circuit = '" + PathFile + "' WHERE titre = '" + \
                        self.EntryTitre.get() + "'"
            self.MainAppli.cur.execute(SQLRequet)
            self.MainAppli.DataBase.commit()
        self.MainAppli.ReInitListSketch()
        if not self.MainAppli.ActionFind and not self.MainAppli.SelectCat:
            try:
                self.MainAppli.IndexFile = self.MainAppli.ListTitreSketchs.index(TitreRecherche)
            except:
                self.MainAppli.IndexFile = 0
        elif not self.MainAppli.SelectCat:
            self.MainAppli.ListBoxFichiers.delete(0, tk.END)
            self.MainAppli.ActionRecherche()
            try:
                self.MainAppli.IndexFile = self.MainAppli.ListTitreRecherch.index(TitreRecherche)
                self.MainAppli.IndexFileFind = self.MainAppli.ListTitreSketchs.index(
                    self.MainAppli.ListTitreRecherch[self.MainAppli.IndexFile])
            except:
                self.MainAppli.IndexFile = 0
                self.MainAppli.IndexFileFind = 0

        else:
            self.MainAppli.ListBoxFichiers.delete(0, tk.END)
            self.MainAppli.AffichEltCat()
            try:
                self.MainAppli.IndexFile = self.MainAppli.ListTitreCat.index(TitreRecherche)
                self.MainAppli.IndexFileFind = self.MainAppli.ListTitreSketchs.index(
                    self.MainAppli.ListTitreCat[self.MainAppli.IndexFile])
            except:
                self.MainAppli.IndexFile = 0
                self.MainAppli.IndexFileFind = 0

        self.MainAppli.ListBoxFichiers.selection_clear(0, tk.END)
        self.MainAppli.ListBoxFichiers.selection_set(self.MainAppli.IndexFile)
        self.MainAppli.ActionSelectListBoxFichiers()
        self.MainAppli.FrmLift()
        self.MainAppli.ModifData = False
        self.MainAppli.CanvasEtagCircuits.itemconfig(self.MainAppli.ImgCanvasEtagCircuits,
                                                     image=self.MainAppli.ImgEtagCircuits[1])
        if self.MainAppli.AffichData:
            self.MainAppli.AffichDataSketch()

    def ActionModifTitre(self):
        SQLRequet = "UPDATE Sketchs SET titre = '" + self.EntryTitre.get() + "' WHERE titre = '" + \
                    self.MainAppli.ListTitreSketchs[self.IndexFile] + "'"
        self.MainAppli.cur.execute(SQLRequet)
        self.MainAppli.DataBase.commit()

        for i in range(3):
            try:
                if i != 2:
                    os.remove("Sketchs/" + self.TypModif[i] + "/" +
                              self.MainAppli.ListTitreSketchs[self.IndexFile] + ".txt")
                else:
                    os.remove("Sketchs/" + self.TypModif[i] + "/" +
                              self.MainAppli.ListTitreSketchs[self.IndexFile] + "/" +
                              self.MainAppli.ListTitreSketchs[self.IndexFile] + ".ino")
                    os.rmdir("Sketchs/" + self.TypModif[i] + "/" +
                             self.MainAppli.ListTitreSketchs[self.IndexFile])
            except:
                pass
            self.ActionModif(i)

        if self.MainAppli.ListSketchs[self.IndexFile][1] is not None:
            os.rename('Sketchs/Circuits/' + self.MainAppli.ListTitreSketchs[self.IndexFile] + ".jpg",
                      'Sketchs/Circuits/' + self.EntryTitre.get() + ".jpg")
            SQLRequet = "UPDATE Sketchs SET circuit = '" + 'Sketchs/Circuits/' + self.EntryTitre.get() + ".jpg" + \
                        "' WHERE titre = '" + self.EntryTitre.get() + "'"
            self.MainAppli.cur.execute(SQLRequet)
            self.MainAppli.DataBase.commit()

        if self.MainAppli.ListSketchs[self.IndexFile][5] is not None:
            os.rename('Sketchs/Docs/' + self.MainAppli.ListTitreSketchs[self.IndexFile] + ".pdf",
                      'Sketchs/Docs/' + self.EntryTitre.get() + ".pdf")
            SQLRequet = "UPDATE Sketchs SET doc = '" + 'Sketchs/Docs/' + self.EntryTitre.get() + ".pdf" + \
                        "' WHERE titre = '" + self.EntryTitre.get() + "'"
            self.MainAppli.cur.execute(SQLRequet)
            self.MainAppli.DataBase.commit()

    def ModifCompEnCours(self, _):
        self.Modif[0] = True

    def ModifObjEnCours(self, _):
        self.Modif[1] = True

    def ModifCodeEnCours(self, _):
        self.Modif[2] = True

    def ModifCircuit(self, _):
        self.FrmModifCircuit = FrmModifCircuit(self.parent, self.RatioX, self.RatioY, self.RatioY2, self)

    def ActionModif(self, i):
        if i != 2:
            PathFile = "Sketchs/" + self.TypModif[i] + "/" + self.EntryTitre.get() + ".txt"
        else:
            PathDirInoToSave = "Sketchs/" + self.TypModif[i] + "/" + self.EntryTitre.get()
            os.makedirs(PathDirInoToSave, exist_ok=True)
            PathFile = "Sketchs/" + self.TypModif[
                i] + "/" + self.EntryTitre.get() + "/" + self.EntryTitre.get() + ".ino"
        File = open(PathFile, "w", encoding="utf-8")
        List = self.ZonesText[i].get(0.0, tk.END)
        File.write(List)
        File.close()
        SQLRequet = "UPDATE Sketchs SET " + self.TypRequet[i] + " = '" + PathFile + "' WHERE titre = '" + \
                    self.EntryTitre.get() + "'"
        self.MainAppli.cur.execute(SQLRequet)
        self.MainAppli.DataBase.commit()
        self.Modif[i] = False

    def ModifDataAnnul(self, _):
        self.BtnAnnul.CanvasBtn.itemconfig(self.BtnAnnul.ImgCanvasBtn, image=self.BtnAnnul.ImgBtn[0])
        self.CanvasFrmFond.itemconfigure('LabelAction', text='')
        self.lower()
        if not self.MainAppli.AffichData:
            self.MainAppli.FrmLift()
            self.MainAppli.MAJInfo()
        else:
            self.MainAppli.FrmDataSketch.lift()
        self.MainAppli.ModifData = False
        self.MainAppli.CanvasEtagCircuits.itemconfig(self.MainAppli.ImgCanvasEtagCircuits,
                                                     image=self.MainAppli.ImgEtagCircuits[1])

    def ChargePDF(self, _):
        self.PathFilePDFToOpen = ''
        self.PathFilePDFToOpen = tkfiledialog.askopenfilename(title="Ouvrir un fichier",
                                                              filetypes=[('PDF files', '.pdf')])
        if self.PathFilePDFToOpen != '':
            self.FrmPDF = FrmPDF(self.CanvasFrmFond, self.PathFilePDFToOpen, 1,
                                 int(self.SX * 0.82), int(self.SY * 0.5), int(self.SX * 0.32), int(self.SY * 0.78),
                                 self.RatioX, self.RatioY2, 0.5, 0.54)
        self.lift(self.parent)

    def AffichImgCircuitModif(self):
        img = self.ImgCircuitModif[0]
        img = img.resize((self.MainAppli.imgwsize, self.MainAppli.imghsize), Image.ANTIALIAS)
        img = img.transpose(Image.ROTATE_90)
        self.ImgCircuitModif.append(ImageTk.PhotoImage(img))
        self.CanvasImgCircuit.itemconfig(self.ImgCanvasImgCircuit, image=self.ImgCircuitModif[1])

    def MoveOnCanvas(self, _):
        self.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.ImgCanvasBtnQuit, image=self.MainAppli.ImgBtnQuit[0])
        self.CanvasFrmFond.itemconfigure('LabelAction', text='')

    def ActionBtnSupp(self, i):
        self.ListBtnSupp[i].CanvasBtn.itemconfig(self.ListBtnSupp[i].ImgCanvasBtn,
                                                 image=self.ListBtnSupp[i].ImgBtn[0])
        if i < 3:
            self.ZonesText[i].delete(0.0, tk.END)
        else:
            if self.MainAppli.ListSketchs[self.IndexFile][5] is not None:
                for widget in self.FrmPDF.FrameDoc.winfo_children():
                    widget.destroy()

                self.NoPDF = NoPDF(self.CanvasFrmFond, int(self.SX * 0.81), int(self.SY / 2),
                                   self.MainAppli.RatioImgPhotoCircuitsX, self.MainAppli.RatioImgPhotoCircuitsY)
                ChangeCursor(self.NoPDF.CanvasImgNoPdf)
                self.NoPDF.CanvasImgNoPdf.bind('<ButtonRelease-1>', self.ChargePDF)
                self.PathFilePDFToOpen = ''

    def ActionBtnImport(self, i):
        self.ListBtnTXT[i].CanvasBtn.itemconfig(self.ListBtnTXT[i].ImgCanvasBtn,
                                                image=self.ListBtnTXT[i].ImgBtn[0])
        if i == 3:
            self.PathFilePDFToOpen = ''
            self.PathFilePDFToOpen = tkfiledialog.askopenfilename(title="Ouvrir un fichier",
                                                                  filetypes=[('PDF files', '.pdf')])
            if self.PathFilePDFToOpen != '':
                if self.MainAppli.ListSketchs[self.IndexFile][5] is not None:
                    for widget in self.FrmPDF.FrameDoc.winfo_children():
                        widget.destroy()
                self.FrmPDF = FrmPDF(self.CanvasFrmFond, self.PathFilePDFToOpen, 1,
                                     int(self.SX * 0.82), int(self.SY * 0.5), int(self.SX * 0.32), int(self.SY * 0.78),
                                     self.RatioX, self.RatioY2, 0.5, 0.54)
        else:
            self.PathFileTXTToOpen = ''
            if i < 2:
                self.PathFileTXTToOpen = tkfiledialog.askopenfilename(title="Ouvrir un fichier",
                                                                      filetypes=[('TXT files', '.txt')])
            else:
                self.PathFileTXTToOpen = tkfiledialog.askopenfilename(title="Ouvrir un fichier",
                                                                      filetypes=[('INO files', '.ino')])
            if self.PathFileTXTToOpen != '':
                self.ZonesText[i].delete(0.0, tk.END)
                fichier = open(self.PathFileTXTToOpen, 'r', encoding="utf-8")
                for ligne in fichier:
                    self.ZonesText[i].insert(tk.INSERT, ligne)
                self.Modif[i] = True
        self.lift(self.parent)

    def MoveOnBtn1(self, _):
        self.CanvasFrmFond.itemconfigure('LabelAction', text="Valider les modifications")

    def MoveOnBtn2(self, _):
        self.CanvasFrmFond.itemconfigure('LabelAction', text="Annuler les modifications")
