from AppliDef import *
import serial.tools.list_ports


class FrmParametre(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, RatioY2, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.RatioY2 = RatioY2
        self.CheminArduinoProg = ''

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmPara/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmPara/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.7515)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.08)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.LabelLog = LabelText(self.CanvasFrmFond, 'ArdPyLog - Paramètres',
                                  '#E0E0E0', font=FontLabelTitre(12))
        self.CanvasFrmFond.create_window(int(self.SX / 2), int(self.SY * 0.014), anchor=tk.CENTER,
                                         window=self.LabelLog)

        self.ImgLogo, wsize, hsize, self.Canvaslogo, self.ImgCanvaslogo = CanInWindow(
            'Media/FrmMain/Logo/', self.RatioX, self.RatioY2, self.CanvasFrmFond, int(self.SX * 0.05),
            int(self.SY * 0.014), 0)

        self.BtnOK = BtnAction(self.CanvasFrmFond, int(self.SX * 0.7), int(self.SY * 0.95), self.RatioX,
                               self.RatioY2, 'Media/FrmPara/BtnOK/')
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ParaOK)

        self.BtnAnnul = BtnAction(self.CanvasFrmFond, int(self.SX * 0.85), int(self.SY * 0.95), self.RatioX,
                                  self.RatioY2, 'Media/FrmPara/BtnAnnul/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.ParaAnnul)

        self.LegendeParametre = LabelText(self.CanvasFrmFond, "Sélection du port COM de l'ARDUINO UNO:",
                                          'Grey', font=FontLabel2(12), foreground='white')
        self.CanvasFrmFond.create_window(int(self.SX * 0.05), int(self.SY * 0.1),
                                         anchor=tk.NW, window=self.LegendeParametre)

        self.PortsCOM = []
        self.Nport = []
        self.PortsCOM = list(serial.tools.list_ports.comports())
        for port_numero, description, address in self.PortsCOM:
            self.Nport.append(port_numero)

        if len(self.PortsCOM) == 0:
            self.MainAppli.ModeControlArduino = False
        elif len(self.PortsCOM) == 1:
            self.MainAppli.ArduinoPort = self.Nport[0]
            self.ModeControlArduino = True

        self.PortSelect = tk.StringVar()

        self.ListePortsCom = ListeDeroulante(self.CanvasFrmFond, '30', textvariable=self.PortSelect,
                                             values=self.PortsCOM)
        self.CanvasFrmFond.create_window(int(self.SX * 0.08), int(self.SY * 0.16),
                                         anchor=tk.NW, window=self.ListePortsCom)
        if self.MainAppli.ArduinoPort != '':
            self.ListePortsCom.set(self.MainAppli.ArduinoPort)
        else:
            self.ListePortsCom.set('Veuillez sélectionner un port:')
        self.ListePortsCom.bind('<<ComboboxSelected>>', self.SelectPort)

        if not self.PortsCOM:
            self.LabelAttention = LabelText(self.CanvasFrmFond, 'Attention, Arduino UNO non détecté !', 'Yellow',
                                            font=FontLabel2(12))
            self.CanvasFrmFond.create_window(int(self.SX * 0.05), int(self.SY * 0.22), anchor=tk.NW,
                                             window=self.LabelAttention)

            self.MainAppli.ModeControlArduino = False

        self.LegendeSelection = LabelText(self.CanvasFrmFond, 'Dossier ARDUINO IDE:', 'Grey', font=FontLabel2(12),
                                          foreground='white')
        self.CanvasFrmFond.create_window(int(self.SX * 0.05), int(self.SY * 0.35),
                                         anchor=tk.NW, window=self.LegendeSelection)

        self.CheminDossierIDE = tk.StringVar()
        self.LabelCheminDossierIDE = LabelVar(self.CanvasFrmFond, self.CheminDossierIDE, 'white',
                                              foreground='black', relief='ridge')
        self.CanvasFrmFond.create_window(int(self.SX * 0.08), int(self.SY * 0.41),
                                         anchor=tk.NW, window=self.LabelCheminDossierIDE)

        self.CheminDossierIDE.set(self.MainAppli.CheminArduinoProg)

        self.BtnModifDossierIDE = tk.Button(self.CanvasFrmFond, text='Modifier', command=self.ModifDossierArduinoIDE)
        self.CanvasFrmFond.create_window(int(self.SX * 0.6), int(self.SY * 0.348),
                                         anchor=tk.NW, window=self.BtnModifDossierIDE)

        self.CanvasFrmFond.pack()

    def ParaOK(self, _):
        if self.Nport:
            self.MainAppli.ArduinoPort = self.Nport[0].strip()
            self.MainAppli.ModeControlArduino = True
        if self.CheminDossierIDE.get() != '':
            self.MainAppli.CheminArduinoProg = self.CheminDossierIDE.get()
        self.destroy()
        self.MainAppli.FrmLift()
        self.MainAppli.ModifPara = False
        self.MainAppli.CanvasEtagCircuits.itemconfig(
            self.MainAppli.ImgCanvasEtagCircuits, image=self.MainAppli.ImgEtagCircuits[1])

    def ParaAnnul(self, _):
        self.destroy()
        self.MainAppli.FrmLift()
        self.MainAppli.ModifPara = False
        self.MainAppli.CanvasEtagCircuits.itemconfig(
            self.MainAppli.ImgCanvasEtagCircuits, image=self.MainAppli.ImgEtagCircuits[1])

    def SelectPort(self, _):
        self.Nport = []
        self.Nport = self.ListePortsCom.get().split('-')

    def ModifDossierArduinoIDE(self):
        self.CheminArduinoProg = tkfiledialog.askdirectory(parent=self.parent, initialdir="C:/",
                                                           title="Selection d'un dossier")
        if self.CheminArduinoProg != '':
            self.CheminDossierIDE.set(self.CheminArduinoProg)
        self.MainAppli.FrmLift()
        self.lift()
