// Déclaration des constantes et variables

const int PinUC = 0;
const int PinButton = 12;
const int PinAlimC = 2;

int ValPinUC = 0;
unsigned long t0; 
float dt;  

int ValButton = 0;
int OldValButton = 0;
int State = 0;


// Déclaration de fonctions

void decharge(){
  digitalWrite(PinAlimC, LOW);
  Serial.println("Decharge du condensateur.");
  while (analogRead(PinUC) > 0) {   
    delay(200);
    }
  Serial.println("Condensateur decharge.");
}


// Initialisation des entrées et sorties

void setup() {
  Serial.begin(9600);
  pinMode(PinButton, INPUT);
  pinMode(PinAlimC, OUTPUT);   
  decharge(); 
  Serial.println("Appuyez sur le bouton poussoir pour commencer les mesures.");
}


// Fonction principale en boucle

void loop() {
  ValButton = digitalRead(PinButton);
delay(10);

if ((ValButton == HIGH)&&(OldValButton == LOW)) 
  {
  State=1-State;
  }
OldValButton = ValButton;

if (State==1) 
  {
  Serial.println("Charge du condensateur en cours.");
  Serial.println("");
  digitalWrite(PinAlimC, 1);
  t0 = micros();
  while (ValPinUC<644) { 
    ValPinUC = analogRead(PinUC);
  }
  dt =  (micros() - t0)* 1e-6;
  Serial.print("Tau = ");
  Serial.println(dt,2);
  Serial.println("");
  Serial.println("Fin des mesures.");
  decharge();
  State = 0;
  ValPinUC = 0;
  Serial.println("Appuyez sur le bouton poussoir pour commencer les mesures.");
  }    
}
