from AppliDef import *


class FrmZoomCircuit(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, ratio, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmZoom/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmZoom/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.174)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.080)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift(container)

        self.ImgBtnQuit, wsize, hsize, self.CanvasBtnQuit, self.ImgCanvasBtnQuit = CanInWindow(
            'Media/FrmZoom/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, int(self.SX * 0.986),
            int(self.SY * 0.013), 0)
        ChangeCursor(self.CanvasBtnQuit)
        self.CanvasBtnQuit.bind('<Motion>',
                                lambda action: self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit,
                                                                             image=self.ImgBtnQuit[1]))
        self.CanvasBtnQuit.bind('<ButtonRelease-1>', self.Quitter)

        self.ImgCircuit = []
        if not self.MainAppli.ActionFind and not self.MainAppli.SelectCat:
            self.img = Image.open(self.MainAppli.ListCircuitSketchs[self.MainAppli.IndexFile])
            self.TitreCadre = self.MainAppli.ListTitreSketchs[self.MainAppli.IndexFile] + " - Circuit"
        elif not self.MainAppli.SelectCat:
            self.img = Image.open(self.MainAppli.ListCircuitRecherch[self.MainAppli.IndexFile])
            self.TitreCadre = self.MainAppli.ListTitreRecherch[self.MainAppli.IndexFile] + " - Circuit"
        else:
            self.img = Image.open(self.MainAppli.ListCircuitCat[self.MainAppli.IndexFile])
            self.TitreCadre = self.MainAppli.ListTitreCat[self.MainAppli.IndexFile] + " - Circuit"

        self.img = self.img.resize((int(self.img.size[0]*ratio), int(self.img.size[1]*ratio)), Image.ANTIALIAS)
        self.ImgCircuit.append(ImageTk.PhotoImage(self.img))
        self.CanvasImgCircuit = CanvasApp(self.CanvasFrmFond, width=self.img.size[0], height=self.img.size[1],
                                          bg='white')
        self.CanvasFrmFond.create_window(int(self.SX / 2), int(self.SY / 2), anchor=tk.CENTER,
                                         window=self.CanvasImgCircuit)
        self.wsize, self.hsize = self.img.size[0], self.img.size[1]
        self.ImgCanvasImgCircuit = self.CanvasImgCircuit.create_image(int(self.img.size[0]/2),
                                                                      int(self.img.size[1]/2),
                                                                      anchor=tk.CENTER,
                                                                      image=self.ImgCircuit[0])

        self.CanvasFrmFond.create_text(int(self.SX * 0.01), int(self.SY * 0.014),
                                       text=self.TitreCadre, font=FontLabel(10), anchor=tk.W)

        self.MainAppli.ActionClicOnMenu(1)
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

    def MoveOnCanvas(self, _):
        self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit, image=self.ImgBtnQuit[0])

    def Quitter(self, _):
        self.destroy()
        self.MainAppli.ZoomCircuitActif = False
        self.MainAppli.ActionClicOnMenu(0)
        self.MainAppli.FrmLift()


class FrmZoomDescript(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmZoom/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmZoom/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.174)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.080)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)

        self.ImgBtnQuit, wsize, hsize, self.CanvasBtnQuit, self.ImgCanvasBtnQuit = CanInWindow(
            'Media/FrmZoom/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, int(self.SX * 0.986),
            int(self.SY * 0.013), 0)
        ChangeCursor(self.CanvasBtnQuit)
        self.CanvasBtnQuit.bind('<Motion>',
                                lambda action: self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit,
                                                                             image=self.ImgBtnQuit[1]))
        self.CanvasBtnQuit.bind('<ButtonRelease-1>', self.Quitter)

        if not self.MainAppli.ActionFind and not self.MainAppli.SelectCat:
            self.TitreCadre = self.MainAppli.ListTitreSketchs[self.MainAppli.IndexFile] + " - Descriptif"
            self.IndexFile = self.MainAppli.IndexFile
        else:
            self.TitreCadre = self.MainAppli.ListTitreSketchs[self.MainAppli.IndexFileFind] + " - Descriptif"
            self.IndexFile = self.MainAppli.IndexFileFind

        self.CanvasFrmFond.create_text(int(self.SX * 0.01), int(self.SY * 0.014),
                                       text=self.TitreCadre, font=FontLabel(10), anchor=tk.W)

        self.LabelComp = LabelInCanvas(self.CanvasFrmFond, 'Liste des composants:', 'white', FontLabelTitre(12),
                                       int(self.SX * 0.1), int(self.SY * 0.1))
        self.ZoneTextComp = ZoneScrolledText(self.CanvasFrmFond, width=int(self.SX * 0.105),
                                             height=int(self.SY * 0.015), font=FontText(10))
        self.CanvasFrmFond.create_window(int(self.SX * 0.1), int(self.SY * 0.15), anchor=tk.NW,
                                         window=self.ZoneTextComp)

        if self.MainAppli.ListSketchs[self.IndexFile][2] is not None:
            fichier = open(self.MainAppli.ListSketchs[self.IndexFile][2], 'r', encoding="utf-8")
            for ligne in fichier:
                self.ZoneTextComp.insert(tk.INSERT, ligne)
        else:
            self.ZoneTextComp.insert(tk.INSERT, '')

        self.LabelObj = LabelInCanvas(self.CanvasFrmFond, 'Objectifs:', 'white', FontLabelTitre(12),
                                      int(self.SX * 0.1), int(self.SY * 0.45))
        self.ZoneTextObjectif = ZoneScrolledText(self.CanvasFrmFond, width=int(self.SX * 0.105),
                                                 height=int(self.SY * 0.02), font=FontText(10))
        self.CanvasFrmFond.create_window(int(self.SX * 0.1), int(self.SY * 0.5), anchor=tk.NW,
                                         window=self.ZoneTextObjectif)

        if self.MainAppli.ListSketchs[self.IndexFile][3] is not None:
            fichier = open(self.MainAppli.ListSketchs[self.IndexFile][3], 'r', encoding="utf-8")
            for ligne in fichier:
                self.ZoneTextObjectif.insert(tk.INSERT, ligne)
        else:
            self.ZoneTextObjectif.insert(tk.INSERT, '')

        self.ZoneTextObjectif.config(state='disabled')
        self.ZoneTextComp.config(state='disabled')

        self.MainAppli.ActionClicOnMenu(2)
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

    def MoveOnCanvas(self, _):
        self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit, image=self.ImgBtnQuit[0])

    def Quitter(self, _):
        self.destroy()
        self.MainAppli.ZoomDescriptActif = False
        self.MainAppli.ActionClicOnMenu(0)
        self.MainAppli.FrmLift()


class FrmZoomCode(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmZoom/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmZoom/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.174)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.080)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)

        self.ImgBtnQuit, wsize, hsize, self.CanvasBtnQuit, self.ImgCanvasBtnQuit = CanInWindow(
            'Media/FrmZoom/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, int(self.SX * 0.986),
            int(self.SY * 0.013), 0)
        ChangeCursor(self.CanvasBtnQuit)
        self.CanvasBtnQuit.bind('<Motion>',
                                lambda action: self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit,
                                                                             image=self.ImgBtnQuit[1]))
        self.CanvasBtnQuit.bind('<ButtonRelease-1>', self.Quitter)

        if not self.MainAppli.ActionFind and not self.MainAppli.SelectCat:
            self.TitreCadre = self.MainAppli.ListTitreSketchs[self.MainAppli.IndexFile] + " - Code"
            self.IndexFile = self.MainAppli.IndexFile
        else:
            self.TitreCadre = self.MainAppli.ListTitreSketchs[self.MainAppli.IndexFileFind] + " - Code"
            self.IndexFile = self.MainAppli.IndexFileFind

        self.CanvasFrmFond.create_text(int(self.SX * 0.01), int(self.SY * 0.014),
                                       text=self.TitreCadre, font=FontLabel(10), anchor=tk.W)

        self.ZoneTextCode = ZoneScrolledText(self.CanvasFrmFond, width=int(self.SX * 0.128),
                                             height=int(self.SY * 0.051), font=FontText2(11))
        self.CanvasFrmFond.create_window(int(self.SX * 0.03), int(self.SY * 0.05), anchor=tk.NW,
                                         window=self.ZoneTextCode)

        if self.MainAppli.ListSketchs[self.IndexFile][4] is not None:
            fichier = open(self.MainAppli.ListSketchs[self.IndexFile][4], 'r', encoding="utf-8")
            for ligne in fichier:
                self.ZoneTextCode.insert(tk.INSERT, ligne)

        self.ZoneTextCode.config(state='disabled')

        self.MainAppli.ActionClicOnMenu(3)
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

    def MoveOnCanvas(self, _):
        self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit, image=self.ImgBtnQuit[0])

    def Quitter(self, _):
        self.destroy()
        self.MainAppli.ZoomCodeActif = False
        self.MainAppli.ActionClicOnMenu(0)
        self.MainAppli.FrmLift()


class FrmZoomDoc(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmZoom/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmZoom/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.174)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.080)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)

        self.ImgBtnQuit, wsize, hsize, self.CanvasBtnQuit, self.ImgCanvasBtnQuit = CanInWindow(
            'Media/FrmZoom/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, int(self.SX * 0.986),
            int(self.SY * 0.013), 0)
        ChangeCursor(self.CanvasBtnQuit)
        self.CanvasBtnQuit.bind('<Motion>',
                                lambda action: self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit,
                                                                             image=self.ImgBtnQuit[1]))
        self.CanvasBtnQuit.bind('<ButtonRelease-1>', self.Quitter)

        if not self.MainAppli.ActionFind and not self.MainAppli.SelectCat:
            self.TitreCadre = self.MainAppli.ListTitreSketchs[self.MainAppli.IndexFile] + " - Documentation"
            self.IndexFile = self.MainAppli.IndexFile
        else:
            self.TitreCadre = self.MainAppli.ListTitreSketchs[self.MainAppli.IndexFileFind] + " - Documentation"
            self.IndexFile = self.MainAppli.IndexFileFind

        self.CanvasFrmFond.create_text(
            int(self.SX * 0.01), int(self.SY * 0.014), text=self.TitreCadre, font=FontLabel(10), anchor=tk.W)

        ratio = float(ConfigResolution(self.MainAppli.Nconfig, 'ZR'))

        if self.MainAppli.ListSketchs[self.IndexFile][5] is not None:
            self.FrmPDF = FrmPDF(self.CanvasFrmFond, self.MainAppli.ListSketchs[self.IndexFile][5], ratio,
                                 int(self.SX * 0.5), int(self.SY * 0.5), int(self.SX * 0.95), int(self.SY * 0.9),
                                 self.RatioX, self.RatioY, 0.46, 0.53)
            self.FrmPDF.CanvasDoc.bind('<Double-1>', self.MainAppli.ZoomDoc)
        else:
            self.NoPDF = NoPDF(self.CanvasFrmFond, int(self.SX / 2), int(self.SY / 2),
                               self.MainAppli.RatioImgPhotoCircuitsX, self.MainAppli.RatioImgPhotoCircuitsY)

        self.MainAppli.ActionClicOnMenu(0)
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

    def MoveOnCanvas(self, _):
        self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit, image=self.ImgBtnQuit[0])

    def Quitter(self, _):
        self.destroy()
        self.MainAppli.ZoomDocActif = False
        self.MainAppli.ActionClicOnMenu(0)
        self.MainAppli.FrmLift()
