import os
from FrmDef import *
from PIL import Image, ImageTk
import threading


def RedimImg(wsize, hsize, chemin):
    ListDossierImage=os.listdir(chemin)
    ListImages = []
    for elt in ListDossierImage:
        ListImages.append(Image.open(chemin + elt))
    ListImgRedim = []
    for img in ListImages:
        img = img.resize((wsize, hsize), Image.ANTIALIAS)
        ListImgRedim.append(ImageTk.PhotoImage(img))
    return ListImgRedim


def ChargeDossierImg(chemin, wpercent):
    ListDossierImage = os.listdir(chemin)
    ListImages = []
    for elt in ListDossierImage:
        ListImages.append(Image.open(chemin + elt))
    ListImgRedim = []
    for img in ListImages:
        wsize = int((float(img.size[0]) * float(wpercent)))
        hsize = int((float(img.size[1]) * float(wpercent)))
        img = img.resize((wsize, hsize), Image.ANTIALIAS)
        ListImgRedim.append(ImageTk.PhotoImage(img))
    return ListImgRedim, wsize, hsize


def CanInWindow (chemin, ratio, conteneur, XW, YW, n ):
    ListIma = []
    ListIma, wsize, hsize = ChargeDossierImg(chemin,ratio)
    CanvasListIma = CanvasApp(conteneur, width=wsize, height=hsize)
    conteneur.create_window(XW, YW, anchor=tk.NW, window=CanvasListIma)
    ImgCanvasListIma = CanvasListIma.create_image(0, 0, anchor=tk.NW, image=ListIma[n])
    return ListIma, wsize, hsize, CanvasListIma, ImgCanvasListIma


def ListCanInWindow (chemin, ratio, conteneur, XW, XWi, YW, YWi, imax, n ):
    ListIma = []
    ListIma, wsize, hsize = ChargeDossierImg(chemin,ratio)
    CanvasListIma = []
    ImgCanvasListIma = []
    for i in range(imax):
        X=int(XW + i*XWi)
        Y=int(YW + i*YWi)
        CanvasListIma.append(CanvasApp(conteneur, width=wsize, height=hsize))
        conteneur.create_window(X, Y, window=CanvasListIma[i])
        ImgCanvasListIma.append(CanvasListIma[i].create_image(0, 0, anchor=tk.NW, image=ListIma[n]))
    return ListIma, wsize, hsize, CanvasListIma, ImgCanvasListIma


def ChangeCursor (Canvas):
    Canvas.bind('<Enter>', lambda action: Canvas.configure(cursor='hand2'))
    Canvas.bind('<Leave>', lambda action: Canvas.configure(cursor=''))

def DeterminAspectRatio(X,Y):
    AspectRatio = X / Y
    if AspectRatio == 683 / 384:
        Nconfig = 0
    elif AspectRatio == 16 / 9:
        Nconfig = 1
    elif AspectRatio == 8 / 5:
        Nconfig = 2
    else:
        Nconfig = 0
    return Nconfig

def ConfigResolution(Nconfig, cle):
    dictresolconfig = {}
    with open("resolconfig", 'r') as fichierconfig:
        for line in fichierconfig:
            listline = line.split(";")
            dictresolconfig[listline[0]] = listline[1].strip()
    listconfig=dictresolconfig.get(cle).split(',')
    return float(listconfig[Nconfig])


class MyTimer:
    def __init__(self, tempo, target, args=[], kwargs={}):
        self._target = target
        self._args = args
        self._kwargs = kwargs
        self._tempo = tempo

    def _run(self):
        self._timer = threading.Timer(self._tempo, self._run)
        self._timer.start()
        self._target(*self._args, **self._kwargs)

    def start(self):
        self._timer = threading.Timer(self._tempo, self._run)
        self._timer.start()

    def stop(self):
        self._timer.cancel()