from FrmDef import *
from AppliDef import *


class AppliCircuit():

    def __init__(self, container, ratio, appli):

    ####################################################################################################################
    ########################################### DECLARATION DES VARIABLES ##############################################
    ####################################################################################################################

        self.MainAppli = appli
        self.CircuitSelect = 0
        self.Voie2Connect = False
        self.ValR = [1, 1.5, 2.2, 3.3, 4.7, 6.8, 10, 15, 22, 33, 47, 68, 100, 150, 220, 330, 470, 680, 1000,
            1500, 2200, 3300, 4700, 6800, 10000, 15000, 22000, 33000, 47000, 68000, 100000, 150000, 220000, 360000,
                     470000, 680000, 1000000, 1500000, 2200000, 3300000]
        self.ValC = [1e-12, 1.5e-12, 2.2e-12, 3.3e-12, 4.7e-12, 6.8e-12, 10e-12, 15e-12, 22e-12, 33e-12,
                     47e-12, 68e-12, 100e-12, 150e-12, 220e-12, 330e-12, 470e-12, 680e-12,
                     1e-9, 1.5e-9, 2.2e-9, 3.3e-9, 4.7e-9, 6.8e-9, 10e-9, 15e-9, 22e-9, 33e-9,
                     47e-9, 68e-9, 100e-9, 150e-9, 220e-9, 330e-9, 470e-9, 680e-9,
                     1e-6, 1.5e-6, 2.2e-6, 3.3e-6]

        PhotoCircuit = Image.open('Media/FrmCircuit/Circuits/0.jpg')
        self.RatioImgCircuit = ratio / float(PhotoCircuit.size[0])

        self.LegendR, wsize, hsize = ChargeDossierImg('Media/FrmCircuit/Casiers/R/', self.RatioImgCircuit)
        self.LegendC, wsize, hsize = ChargeDossierImg('Media/FrmCircuit/Casiers/C/', self.RatioImgCircuit)
        self.ImgRH, self.RHwsize, self.RHhsize = ChargeDossierImg('Media/FrmCircuit/RH/', self.RatioImgCircuit)
        self.ImgRV, self.RVwsize, self.RVhsize = ChargeDossierImg('Media/FrmCircuit/RV/', self.RatioImgCircuit)
        self.ImgCH, self.CHwsize, self.CHhsize = ChargeDossierImg('Media/FrmCircuit/CH/', self.RatioImgCircuit)
        self.ImgCV, self.CVwsize, self.CVhsize = ChargeDossierImg('Media/FrmCircuit/CV/', self.RatioImgCircuit)

    ####################################################################################################################
    ############################################ AFFICHAGE CIRCUIT VIDE ################################################
    ####################################################################################################################

        self.ImgFrameCircuit, self.WCircuit, self.HCircuit, self.CanvasCircuit, self.ImgCanvasCircuit = CanInWindow(
            'Media/FrmCircuit/Circuits/', self.RatioImgCircuit, container, 0, 0, 0)
        ChangeCursor(self.CanvasCircuit)
        self.CanvasCircuit.bind('<Button-1>', self.AffichCircuits)

        self.CanvasCircuit.pack()

    ####################################################################################################################
    ######################################## AFFICHAGE FENETRE DE SELECTION  ###########################################
    ####################################################################################################################

    def AffichFrmMenuSelect(self):

        self.FrmMenuSelect = tk.Toplevel(self.MainAppli.FrmMain)
        self.SX = int(self.MainAppli.FrmMain.swidth)
        self.SY = int(self.MainAppli.FrmMain.sheight * 0.547)
        self.FrmMenuSelect.geometry(str(self.SX) + "x" + str(self.SY) + "+0+0")
        self.FrmMenuSelect.resizable(width=False, height=False)
        self.FrmMenuSelect.overrideredirect(True)


        self.ImgFrmMenuSelect = RedimImg(self.SX, self.SY, 'Media/FrmCircuit/Main/')
        self.CanvasFrmMenuSelect = CanvasApp(self.FrmMenuSelect, width=self.SX, height=self.SY)
        self.ImgCanvasFrmMenuSelect = self.CanvasFrmMenuSelect.create_image(0, 0, anchor=tk.NW,
                                                                        image=self.ImgFrmMenuSelect[0])

        self.ImgBtnArret, wsize, hsize, self.CanvasBtnArret, self.ImgCanvasBtnArret = CanInWindow(
            'Media/FrmMain/BtnArret/', self.MainAppli.RatioFond, self.CanvasFrmMenuSelect , int(self.SX * 0.96), int(self.SY * 0.025), 0)
        ChangeCursor(self.CanvasBtnArret)
        self.CanvasBtnArret.bind('<ButtonPress-1>', lambda action: self.CanvasBtnArret.itemconfig(self.ImgCanvasBtnArret, image=self.ImgBtnArret[1]))
        self.CanvasBtnArret.bind('<ButtonRelease-1>', self.CacheFrmMenuSelect)


        self.CanvasFrmMenuSelect.pack()


    def CacheFrmMenuSelect(self, evt):
        self.FrmMenuSelect.destroy()

    ####################################################################################################################
    ############################################## SELECTION DU CIRCUIT  ###############################################
    ####################################################################################################################

    def AffichCircuits(self, evt):

        self.AffichFrmMenuSelect()
        self.TextTitreCircuit = [' Pas de circuit ', ' Circuit "Pont diviseur de tension" ',
                                 ' Circuit RC: Filtre passe-bas ', ' Circuit RC: Filtre passe-haut ']

        self.LabelTitreCircuit = LabelText(self.CanvasFrmMenuSelect, '', 'red', font=FontLabelG(16), relief=tk.RAISED)
        self.CanvasFrmMenuSelect.create_window(int(self.SX / 2)
                                               , int(self.SY * 0.87), anchor=tk.CENTER, window=self.LabelTitreCircuit)
        self.LabelTitreCircuit.configure(text=self.TextTitreCircuit[0])

        self.ChoixCircuit, wsize, hsize = ChargeDossierImg('Media/FrmCircuit/ChoixCircuits/', self.RatioImgCircuit)
        self.CanvasChoixCircuit = []
        self.ImgChoixCircuit = []
        for i in range(3):
            self.CanvasChoixCircuit.append(CanvasApp(self.CanvasFrmMenuSelect, width=wsize, height=hsize))
            self.CanvasFrmMenuSelect.create_window(int(self.SX * 0.05) + i * (self.SX * 0.03 + wsize), int((self.SY - hsize)/2), anchor=tk.NW,
                                         window=self.CanvasChoixCircuit[i])
            self.ImgChoixCircuit.append(self.CanvasChoixCircuit[i].create_image(0, 0, anchor=tk.NW, image=self.ChoixCircuit[i]))

        self.CanvasChoixCircuit[1].configure(bd=5, relief='raised')
        ChangeCursor(self.CanvasChoixCircuit[1])

        def GestEvt(evt, i=self.CircuitSelect):
            return self.AffichCircuitSelected(evt, self.CircuitSelect)
        self.CanvasChoixCircuit[1].bind('<Button-1>', GestEvt)
        self.CanvasChoixCircuit[1].bind('<MouseWheel>', self.MouseWheelCircuit)

        self.ChangeCircuit(evt, +1)
        self.ChangeCircuit(evt, -1)


    def ChangeCircuit(self, evt, i) :

        if self.CircuitSelect>0 and self.CircuitSelect < len(self.ChoixCircuit)-1:
            self.CircuitSelect = self.CircuitSelect + i
            for j in range(3):
                CircuitAffich=self.CircuitSelect+j-1
                if CircuitAffich > len(self.ChoixCircuit)-1: CircuitAffich=0
                self.CanvasChoixCircuit[j].itemconfig(self.ImgChoixCircuit[j], image=self.ChoixCircuit[CircuitAffich])
        else:
            if self.CircuitSelect == len(self.ChoixCircuit)-1:
                if i == 1:
                    self.CircuitSelect=0
                else:
                    self.CircuitSelect = len(self.ChoixCircuit)-2
                for j in range(3):
                    CircuitAffich = self.CircuitSelect + j - 1
                    if CircuitAffich <0: CircuitAffich = len(self.ChoixCircuit)-1
                    self.CanvasChoixCircuit[j].itemconfig(self.ImgChoixCircuit[j],
                                                          image=self.ChoixCircuit[CircuitAffich])
            else:
                if i==1 :
                    self.CircuitSelect = 1
                else:
                    self.CircuitSelect = 3
                for j in range(3):
                    CircuitAffich = self.CircuitSelect + j - 1
                    if CircuitAffich > 3: CircuitAffich = 0
                    self.CanvasChoixCircuit[j].itemconfig(self.ImgChoixCircuit[j],
                                                          image=self.ChoixCircuit[CircuitAffich])

        self.LabelTitreCircuit.configure(text=self.TextTitreCircuit[self.CircuitSelect])

    def AffichCircuitSelected(self, evt,i):
        self.EffaceCircuit()
        if i == 0: self.CircuitEtude=CircuitVide(self)
        if i == 1: self.CircuitEtude=CircuitPontDiviseur(self)
        if i == 2: self.CircuitEtude=CircuitRC(self)
        if i == 3: self.CircuitEtude=CircuitCR(self)
        self.CacheFrmMenuSelect(evt)

    def EffaceCircuit(self):
        for elt in self.CanvasCircuit.find_all():
            self.CanvasCircuit.delete(elt)

    def MouseWheelCircuit(self, event):
        if event.delta == -120:
            self.ChangeCircuit(event,-1)
        if event.delta == 120:
            self.ChangeCircuit(event,+1)

    def MAJCircuitEtude(self, Ncircuit, Z1, Z2):
        self.MainAppli.DefFonctionTransfert(Ncircuit, Z1, Z2)
        self.MainAppli.MAJSignal()

    ####################################################################################################################
    ####################################### SELECTION DES COMPOSANTS DU CIRCUIT  #######################################
    ####################################################################################################################

    def AffichCasier(self, evt, composant):

        self.AffichFrmMenuSelect()

        self.Casiers = []
        self.Casiers, Cwsize, Chsize = ChargeDossierImg('Media/FrmCircuit/Casiers/Fond/', self.RatioImgCircuit)
        self.CanvasCasiers = []
        self.ImgCasiers = []
        for i in range(2):
            self.CanvasCasiers.append(CanvasApp(self.CanvasFrmMenuSelect, width=Cwsize, height=Chsize))
            self.CanvasFrmMenuSelect.create_window(int(self.SX * 0.1) + i * (self.SX * 0.1 + Cwsize), int((self.SY - Chsize)/2), anchor=tk.NW,
                                         window=self.CanvasCasiers[i])
            self.ImgCasiers.append(self.CanvasCasiers[i].create_image(0, 0, anchor=tk.NW, image=self.Casiers[0]))

        self.Etiquette = []
        if composant=="R": self.Etiquette, wsize, hsize = ChargeDossierImg('Media/FrmCircuit/Casiers/R/', self.RatioImgCircuit)
        if composant=="C": self.Etiquette, wsize, hsize = ChargeDossierImg('Media/FrmCircuit/Casiers/C/', self.RatioImgCircuit)
        self.CanvasEtiq = []
        self.ImgCanvasEtiquette = []
        ComptC=0
        ComptL=0
        for i in range(40):
            if i<20:
                self.CanvasEtiq.append(CanvasApp(self.CanvasCasiers[0], width=wsize, height=hsize))
                self.CanvasCasiers[0].create_window(int((Cwsize * 0.078) + ComptC * (Cwsize * 0.076 + wsize)),
                                                int(Chsize * 0.185+ ComptL * (Chsize * 0.168 + hsize)) , anchor=tk.NW,window=self.CanvasEtiq[i])
            else:
                if i==20:
                    ComptC = 0
                    ComptL = 0
                self.CanvasEtiq.append(CanvasApp(self.CanvasCasiers[1], width=wsize, height=hsize))
                self.CanvasCasiers[1].create_window(int((Cwsize * 0.078) + ComptC * (Cwsize * 0.076 + wsize)),
                                                    int(Chsize * 0.185 + ComptL * (Chsize * 0.168 + hsize)),
                                                    anchor=tk.NW, window=self.CanvasEtiq[i])
            self.ImgCanvasEtiquette.append(self.CanvasEtiq[i].create_image(0, 0, anchor=tk.NW, image=self.Etiquette[i]))
            ComptC = ComptC + 1
            if ComptC == 5:
                ComptC = 0
                ComptL = ComptL + 1

            def GestEvt(evt, j=i):
                return self.ChangeComposant(evt, j)

            self.CanvasEtiq[i].bind('<Button-1>', GestEvt)
            ChangeCursor(self.CanvasEtiq[i])

    def ChangeComposant(self,evt,j):
        if self.CircuitSelect==1:
            if self.CircuitEtude.ChangeRH == True:
                self.CircuitEtude.R1 = self.ValR[j]
                self.CircuitEtude.NR1=j
                self.CircuitEtude.CanvasRH.itemconfig(self.CircuitEtude.ImgCanvasRH, image=self.ImgRH[j])
                self.CircuitEtude.ChangeRH = False
            if self.CircuitEtude.ChangeRV == True:
                self.CircuitEtude.R2 = self.ValR[j]
                self.CircuitEtude.NR2 = j
                self.CircuitEtude.CanvasRV.itemconfig(self.CircuitEtude.ImgCanvasRV, image=self.ImgRV[j])
                self.CircuitEtude.ChangeRV = False

            self.MAJCircuitEtude(self.CircuitSelect,self.CircuitEtude.R1,self.CircuitEtude.R2)

        if self.CircuitSelect == 2 or self.CircuitSelect == 3:
            if self.CircuitEtude.ChangeR == True:
                self.CircuitEtude.R = self.ValR[j]
                self.CircuitEtude.NR = j
                if self.CircuitSelect == 2:
                    self.CircuitEtude.CanvasR.itemconfig(self.CircuitEtude.ImgCanvasR, image=self.ImgRH[j])
                else:
                    self.CircuitEtude.CanvasR.itemconfig(self.CircuitEtude.ImgCanvasR, image=self.ImgRV[j])
                self.CircuitEtude.ChangeR = False
            if self.CircuitEtude.ChangeC == True:
                self.CircuitEtude.C = self.ValC[j]
                self.CircuitEtude.NC = j
                self.CircuitEtude.ChangeC = False
            self.MAJCircuitEtude(self.CircuitSelect, self.CircuitEtude.R, self.CircuitEtude.C)

        self.CacheFrmMenuSelect(evt)


########################################################################################################################
################################################# OBJETS CIRCUIT  ######################################################
########################################################################################################################

class CircuitVide():

    def __init__(self, appli):
        self.AppliCircuit = appli
        self.AppliCircuit.ImgCanvasCircuit = self.AppliCircuit.CanvasCircuit.create_image(0, 0, anchor=tk.NW,
                                                                image=self.AppliCircuit.ImgFrameCircuit[0])
        self.AppliCircuit.Voie2Connect = False
        self.AppliCircuit.MAJCircuitEtude(0, 0, 0)


class CircuitPontDiviseur():

    def __init__(self, appli):
        self.AppliCircuit=appli
        self.AppliCircuit.ImgCanvasCircuit = self.AppliCircuit.CanvasCircuit.create_image(0, 0, anchor=tk.NW,
                                                                image=self.AppliCircuit.ImgFrameCircuit[1])
        self.NR1 = 18
        self.NR2 = 18
        self.R1=self.AppliCircuit.ValR[self.NR1]
        self.R2=self.AppliCircuit.ValR[self.NR2]

        self.AppliCircuit.Voie2Connect = True
        self.ChangeRH = False
        self.ChangeRV = False

        self.CanvasRH = CanvasApp(self.AppliCircuit.CanvasCircuit, width=self.AppliCircuit.RHwsize, height=self.AppliCircuit.RHhsize)
        self.AppliCircuit.CanvasCircuit.create_window(int(self.AppliCircuit.WCircuit * 0.388),
                                        int(self.AppliCircuit.HCircuit * 0.317), anchor=tk.NW, window=self.CanvasRH)
        self.ImgCanvasRH = self.CanvasRH.create_image(0, 0, anchor=tk.NW, image=self.AppliCircuit.ImgRH[self.NR1])

        self.CanvasRV = CanvasApp(self.AppliCircuit.CanvasCircuit, width=self.AppliCircuit.RVwsize, height=self.AppliCircuit.RVhsize)
        self.AppliCircuit.CanvasCircuit.create_window(int(self.AppliCircuit.WCircuit * 0.618),
                                    int(self.AppliCircuit.HCircuit * 0.424), anchor=tk.NW, window=self.CanvasRV)
        self.ImgCanvasRV = self.CanvasRV.create_image(0, 0, anchor=tk.NW, image=self.AppliCircuit.ImgRV[self.NR2])

        self.CanvasRH.bind('<Enter>', self.SurvolCanvasRH)
        self.CanvasRH.bind('<Leave>', self.QuitteCanvasRH)
        self.CanvasRH.bind('<Button-1>', self.SelectRH)

        self.CanvasRV.bind('<Enter>', self.SurvolCanvasRV)
        self.CanvasRV.bind('<Leave>', self.QuitteCanvasRV)
        self.CanvasRV.bind('<Button-1>', self.SelectRV)

        self.AppliCircuit.MAJCircuitEtude(1,self.R1,self.R2)

    def SurvolCanvasRH(self, evt):
        self.CanvasRH.configure(cursor='hand1')
        self.TooltipRH=self.AppliCircuit.CanvasCircuit.create_image(int(self.AppliCircuit.WCircuit * 0.388)+ evt.x,
                int(self.AppliCircuit.HCircuit * 0.317)+evt.y, anchor=tk.NW, image=self.AppliCircuit.LegendR[self.NR1])

    def QuitteCanvasRH(self, evt):
        self.CanvasRH.configure(cursor='')
        self.AppliCircuit.CanvasCircuit.delete(self.TooltipRH)

    def SurvolCanvasRV(self, evt):
        self.CanvasRV.configure(cursor='hand1')
        self.TooltipRV=self.AppliCircuit.CanvasCircuit.create_image(int(self.AppliCircuit.WCircuit * 0.618)+ evt.x,
                int(self.AppliCircuit.HCircuit * 0.424)+evt.y, anchor=tk.NW, image=self.AppliCircuit.LegendR[self.NR2])

    def QuitteCanvasRV(self, evt):
        self.CanvasRV.configure(cursor='')
        self.AppliCircuit.CanvasCircuit.delete(self.TooltipRV)

    def SelectRH(self, evt):
        self.ChangeRH = True
        self.AppliCircuit.AffichCasier(evt,'R')

    def SelectRV(self, evt):
        self.ChangeRV = True
        self.AppliCircuit.AffichCasier(evt,'R')



class CircuitRC():

    def __init__(self,appli):
        self.AppliCircuit = appli
        self.AppliCircuit.ImgCanvasCircuit = self.AppliCircuit.CanvasCircuit.create_image(0, 0, anchor=tk.NW,
                                                                            image=self.AppliCircuit.ImgFrameCircuit[2])
        self.AppliCircuit.Voie2Connect = True
        self.ChangeR = False
        self.ChangeC = False
        self.NR = 18
        self.NC = 30
        self.R = self.AppliCircuit.ValR[self.NR]
        self.C = self.AppliCircuit.ValC[self.NC]


        self.CanvasR = CanvasApp(self.AppliCircuit.CanvasCircuit, width=self.AppliCircuit.RHwsize, height=self.AppliCircuit.RHhsize)
        self.AppliCircuit.CanvasCircuit.create_window(int(self.AppliCircuit.WCircuit * 0.388),
                                            int(self.AppliCircuit.HCircuit * 0.317), anchor=tk.NW,window=self.CanvasR)
        self.ImgCanvasR = self.CanvasR.create_image(0, 0, anchor=tk.NW, image=self.AppliCircuit.ImgRH[self.NR])

        self.CanvasC = CanvasApp(self.AppliCircuit.CanvasCircuit, width=self.AppliCircuit.CHwsize, height=self.AppliCircuit.CHhsize)
        self.AppliCircuit.CanvasCircuit.create_window(int(self.AppliCircuit.WCircuit * 0.625),
                                            int(self.AppliCircuit.HCircuit * 0.603), anchor=tk.NW, window=self.CanvasC)
        self.ImgCanvasC = self.CanvasC.create_image(0, 0, anchor=tk.NW, image=self.AppliCircuit.ImgCH[0])

        self.CanvasR.bind('<Enter>', self.SurvolCanvasR)
        self.CanvasR.bind('<Leave>', self.QuitteCanvasR)
        self.CanvasR.bind('<Button-1>', self.SelectR)

        self.CanvasC.bind('<Enter>', self.SurvolCanvasC)
        self.CanvasC.bind('<Leave>', self.QuitteCanvasC)
        self.CanvasC.bind('<Button-1>', self.SelectC)

        self.AppliCircuit.MAJCircuitEtude(2, self.R, self.C)


    def SurvolCanvasR(self, evt):
        self.CanvasR.configure(cursor='hand1')
        self.TooltipR=self.AppliCircuit.CanvasCircuit.create_image(int(self.AppliCircuit.WCircuit * 0.388)+ evt.x,
                int(self.AppliCircuit.HCircuit * 0.317)+evt.y,anchor=tk.NW, image=self.AppliCircuit.LegendR[self.NR])

    def QuitteCanvasR(self, evt):
        self.CanvasR.configure(cursor='')
        self.AppliCircuit.CanvasCircuit.delete(self.TooltipR)

    def SelectR(self, evt):
        self.ChangeR = True
        self.AppliCircuit.AffichCasier(evt, 'R')

    def SurvolCanvasC(self, evt):
        self.CanvasC.configure(cursor='hand1')
        self.TooltipC=self.AppliCircuit.CanvasCircuit.create_image(int(self.AppliCircuit.WCircuit * 0.625)+ evt.x,
                int(self.AppliCircuit.HCircuit * 0.603)+evt.y, anchor=tk.NW, image=self.AppliCircuit.LegendC[self.NC])

    def QuitteCanvasC(self, evt):
        self.CanvasC.configure(cursor='')
        self.AppliCircuit.CanvasCircuit.delete(self.TooltipC)

    def SelectC(self, evt):
        self.ChangeC = True
        self.AppliCircuit.AffichCasier(evt, 'C')


class CircuitCR():

    def __init__(self,appli):
        self.AppliCircuit = appli
        self.AppliCircuit.ImgCanvasCircuit = self.AppliCircuit.CanvasCircuit.create_image(0, 0, anchor=tk.NW,
                                                                            image=self.AppliCircuit.ImgFrameCircuit[3])
        self.AppliCircuit.Voie2Connect = True

        self.ChangeR = False
        self.ChangeC = False
        self.NR = 18
        self.NC = 30
        self.R = self.AppliCircuit.ValR[self.NR]
        self.C = self.AppliCircuit.ValC[self.NC]

        self.CanvasR = CanvasApp(self.AppliCircuit.CanvasCircuit, width=self.AppliCircuit.RVwsize,
                                 height=self.AppliCircuit.RVhsize)
        self.AppliCircuit.CanvasCircuit.create_window(int(self.AppliCircuit.WCircuit * 0.616),
                int(self.AppliCircuit.HCircuit * 0.422), anchor=tk.NW, window=self.CanvasR)
        self.ImgCanvasR = self.CanvasR.create_image(0, 0, anchor=tk.NW, image=self.AppliCircuit.ImgRV[self.NR])

        self.CanvasC = CanvasApp(self.AppliCircuit.CanvasCircuit, width=self.AppliCircuit.CVwsize,
                                 height=self.AppliCircuit.CVhsize)
        self.AppliCircuit.CanvasCircuit.create_window(int(self.AppliCircuit.WCircuit * 0.412),
                int(self.AppliCircuit.HCircuit * 0.128), anchor=tk.NW, window=self.CanvasC)
        self.ImgCanvasC = self.CanvasC.create_image(0, 0, anchor=tk.NW, image=self.AppliCircuit.ImgCV[0])

        self.CanvasR.bind('<Enter>', self.SurvolCanvasR)
        self.CanvasR.bind('<Leave>', self.QuitteCanvasR)
        self.CanvasR.bind('<Button-1>', self.SelectR)

        self.CanvasC.bind('<Enter>', self.SurvolCanvasC)
        self.CanvasC.bind('<Leave>', self.QuitteCanvasC)
        self.CanvasC.bind('<Button-1>', self.SelectC)

        self.AppliCircuit.MAJCircuitEtude(3, self.C, self.R)


    def SurvolCanvasR(self, evt):
        self.CanvasR.configure(cursor='hand1')
        self.TooltipR=self.AppliCircuit.CanvasCircuit.create_image(int(self.AppliCircuit.WCircuit * 0.616)+ evt.x,
            int(self.AppliCircuit.HCircuit * 0.422)+evt.y, anchor=tk.NW, image=self.AppliCircuit.LegendR[self.NR])

    def QuitteCanvasR(self, evt):
        self.CanvasR.configure(cursor='')
        self.AppliCircuit.CanvasCircuit.delete(self.TooltipR)

    def SelectR(self, evt):
        self.ChangeR = True
        self.AppliCircuit.AffichCasier(evt, 'R')

    def SurvolCanvasC(self, evt):
        self.CanvasC.configure(cursor='hand1')
        self.TooltipC=self.AppliCircuit.CanvasCircuit.create_image(int(self.AppliCircuit.WCircuit * 0.412)+ evt.x,
           int(self.AppliCircuit.HCircuit * 0.128)+evt.y, anchor=tk.NW, image=self.AppliCircuit.LegendC[self.NC])

    def QuitteCanvasC(self, evt):
        self.CanvasC.configure(cursor='')
        self.AppliCircuit.CanvasCircuit.delete(self.TooltipC)

    def SelectC(self, evt):
        self.ChangeC = True
        self.AppliCircuit.AffichCasier(evt, 'C')
