import tkinter as tk
import tkinter.font as tkFont


class FrmMainApp(tk.Tk):
    def __init__(self,Titre):

        tk.Tk.__init__(self,Titre)
        
        self.wm_title(Titre)
        self.swidth = self.winfo_screenwidth()
        self.sheight = self.winfo_screenheight()
        self.geometry(str(self.swidth)+"x"+str(self.sheight)+"+0+0")
        self.resizable(width=False,height=False)
        self.overrideredirect(True)
     

class FrameApp(tk.Frame):       
    def __init__(self, container, **kwargs):
        
        kwargs['bd']=0
        kwargs['highlightthickness']=0

        tk.Frame.__init__(self, container, **kwargs)
        

class CanvasApp(tk.Canvas):
    def __init__(self, container, **kwargs):
 
        kwargs['bd']=0
        kwargs['highlightthickness']=0
        
        tk.Canvas.__init__(self, container, **kwargs)


class LabelVar(tk.Label):
    def __init__(self, container, Var, Color, **kwargs):

        kwargs['textvariable'] = Var
        kwargs['bg'] = Color
        kwargs['padx'] = 0
        kwargs['pady'] = 0
        kwargs['highlightthickness'] = 0

        tk.Label.__init__(self, container, **kwargs)


class LabelText(tk.Label):
    def __init__(self, container, Txt, Color, **kwargs):

        kwargs['text'] = Txt
        kwargs['bg'] = Color
        kwargs['padx'] = 0
        kwargs['pady'] = 0
        kwargs['highlightthickness'] = 0

        tk.Label.__init__(self, container, **kwargs)


class FontLabel(tkFont.Font):
    def __init__(self, size,**kwargs):

        kwargs['family'] = 'Helvetica'
        kwargs['size'] = size
        kwargs['weight'] = 'normal'
        kwargs['slant'] = 'roman'
        kwargs['underline'] = 0
        kwargs['overstrike'] = 0

        tkFont.Font.__init__(self, **kwargs)

class FontLabelG(tkFont.Font):
    def __init__(self, size,**kwargs):

        kwargs['family'] = 'Helvetica'
        kwargs['size'] = size
        kwargs['weight'] = 'bold'
        kwargs['slant'] = 'roman'
        kwargs['underline'] = 0
        kwargs['overstrike'] = 0

        tkFont.Font.__init__(self, **kwargs)