from AppliDef import *


class AppliGBF():
    
    def __init__(self, container, ratio, appli):

    ####################################################################################################################
    ########################################### DECLARATION DES VARIABLES ##############################################
    ####################################################################################################################

        self.MainAppli=appli
        self.Freq=0.0
        self.Amp=0.0
        self.FreqMainOut = 0.0
        self.AmpMainOut = 0.0
        self.Offset=0.0
        self.OffsetMainOut = 0.0
        self.OnGBF=False
        self.OnMainOut = False
        self.OnRegFreq=False
        self.OnRegAmp=False
        self.OnRegOffset=False
        self.DigitFreqSelect=0
        self.ValeurDigitFreq=[]
        self.ValeurDigitAmp=[]
        self.ValeurDigitOffset=[]
        self.PosVirgFreq=0
        self.PosVirgAmp=0
        self.PosVirgOffset=0
        self.ValUnitFreq=0
        self.TypeSignal=1
        self.ListEltInCanvasGBF = []

        PhotoGBF = Image.open('Media/FrmGBF/Main/GBF.jpg')
        self.RatioImgGBF = ratio / float(PhotoGBF.size[0])

    ####################################################################################################################
    ######################################### AFFICHAGE GBF - BOUTONS INTERACTIFS ######################################
    ####################################################################################################################

        self.ImgFrameGBF, SX, SY, self.CanvasGBF, self.ImgCanvasGBF = CanInWindow('Media/FrmGBF/Main/',
                        self.RatioImgGBF, container, 0, 0, 0)

        self.BtnGBFOnOff, wsize, hsize, self.CanvasBtnGBFOnOff, self.ImgBtnGBFOnOff = CanInWindow(
            'Media/FrmGBF/BtnOnOff/',self.RatioImgGBF, self.CanvasGBF, int(SX*0.058), int(SY*0.738), 0)
        ChangeCursor(self.CanvasBtnGBFOnOff)
        self.CanvasBtnGBFOnOff.bind('<ButtonPress-1>', lambda action: self.CanvasBtnGBFOnOff.itemconfig(
        self.ImgBtnGBFOnOff,image=self.BtnGBFOnOff[1]))
        self.CanvasBtnGBFOnOff.bind('<ButtonRelease-1>', self.OnOffGBF)

        self.BtnGBFMainOut, wsize, hsize, self.CanvasBtnGBFMainOut, self.ImgBtnGBFMainOut = CanInWindow(
            'Media/FrmGBF/BtnMainOut/', self.RatioImgGBF, self.CanvasGBF, int(SX * 0.058), int(SY * 0.590), 0)
        self.ListEltInCanvasGBF.append(self.CanvasBtnGBFMainOut)
        self.CanvasBtnGBFMainOut.bind('<Button-1>', self.OnOffMainOut)

        self.LogoFreq, wsize, hsize, self.CanvasLogoFreq, self.ImglogoFreq = CanInWindow(
            'Media/FrmGBF/LogoFreq/', self.RatioImgGBF, self.CanvasGBF, int(SX*0.2),int(SY*0.18), 1)

        self.LogoSin, wsize, hsize, self.CanvasLogoSin, self.ImgLogoSin = CanInWindow(
            'Media/FrmGBF/LogoSin/', self.RatioImgGBF, self.CanvasGBF, int(SX*0.16),int(SY*0.16), 1)

        self.DigitFreq, wsize, hsize = ChargeDossierImg('Media/FrmGBF/DigitFreq/', self.RatioImgGBF)
        self.CanvasDigitFreq=[]
        self.ImgDigitFreq=[]
        for i in range(5):
            self.ValeurDigitFreq.append(0)
            self.CanvasDigitFreq.append(CanvasApp(self.CanvasGBF, width=wsize, height=hsize))
            self.CanvasGBF.create_window(int(SX*0.24)+ i*(SX*0.013 + wsize),int(SY*0.18),anchor=tk.NW, window=self.CanvasDigitFreq[i])
            self.ImgDigitFreq.append(self.CanvasDigitFreq[i].create_image(0,0, anchor=tk.NW, image=self.DigitFreq[10]))

        self.VirgFreq=[]
        self.VirgFreq, wsize, hsize = ChargeDossierImg('Media/FrmGBF/VirgFreq/',self.RatioImgGBF)
        self.CanvasVirgFreq=[]
        self.ImgVirgFreq=[]
        for i in range(4):
            self.CanvasVirgFreq.append(CanvasApp(self.CanvasGBF, width=wsize, height=hsize))
            self.CanvasGBF.create_window(int(SX*0.2925)+ i*(SX*0.0556 + wsize),int(SY*0.32),anchor=tk.NW, window=self.CanvasVirgFreq[i])
            self.ImgVirgFreq.append(self.CanvasVirgFreq[i].create_image(0,0, anchor=tk.NW, image=self.VirgFreq[1]))

        self.RegFreq=[]
        self.RegFreq, wsize, hsize = ChargeDossierImg('Media/FrmGBF/RegFreq/',self.RatioImgGBF)
        self.CanvasRegFreq=[]
        self.ImgRegFreq=[]
        for i in range(5):
            self.CanvasRegFreq.append(CanvasApp(self.CanvasGBF, width=wsize, height=hsize))
            self.CanvasGBF.create_window(int(SX*0.247)+ i*(SX*0.0358 + wsize),int(SY*0.35),anchor=tk.NW, window=self.CanvasRegFreq[i])
            self.ImgRegFreq.append(self.CanvasRegFreq[i].create_image(0,0, anchor=tk.NW, image=self.RegFreq[1]))

        self.UnitFreq, wsize, hsize, self.CanvasUnitFreq, self.ImgUnitFreq = CanInWindow(
            'Media/FrmGBF/UnitFreq/', self.RatioImgGBF, self.CanvasGBF, int(SX*0.58),int(SY*0.275), 2 )

        self.BtnRegFreq, wsize, hsize, self.CanvasBtnRegFreq, self.ImgBtnRegFreq = CanInWindow(
            'Media/FrmGBF/BtnRegFreq/', self.RatioImgGBF, self.CanvasGBF, int(SX*0.834),int(SY*0.473), 1)
        self.ListEltInCanvasGBF.append(self.CanvasBtnRegFreq)
        self.CanvasBtnRegFreq.bind('<Button-1>', self.SelectDigitFrequence)

        self.BtnRegAmp, wsize, hsize, self.CanvasBtnRegAmp, self.ImgBtnRegAmp = CanInWindow(
            'Media/FrmGBF/BtnRegAmp/', self.RatioImgGBF, self.CanvasGBF, int(SX*0.323),int(SY*0.591), 1)
        self.ListEltInCanvasGBF.append(self.CanvasBtnRegAmp)
        self.CanvasBtnRegAmp.bind('<Button-1>', self.ChangeAmplitude)

        self.BtnRegOffset, wsize, hsize, self.CanvasBtnRegOffset, self.ImgBtnRegOffset = CanInWindow(
            'Media/FrmGBF/BtnRegOffset/', self.RatioImgGBF, self.CanvasGBF, int(SX*0.44),int(SY*0.591),1)
        self.ListEltInCanvasGBF.append(self.CanvasBtnRegOffset)
        self.CanvasBtnRegOffset.bind('<Button-1>', self.ChangeOffset)

        self.BtnReglage, wsize, hsize, self.CanvasBtnReglage, self.ImgBtnReglag = CanInWindow(
            'Media/FrmGBF/BtnReg/',self.RatioImgGBF, self.CanvasGBF, int(SX*0.837),int(SY*0.119), 0 )
        self.ListEltInCanvasGBF.append(self.CanvasBtnReglage)
        self.CanvasBtnReglage.bind('<MouseWheel>', self.MouseWheel)

        self.BtnRangePlus, wsize, hsize, self.CanvasBtnRangePlus, self.ImgBtnRangePlus = CanInWindow(
            'Media/FrmGBF/BtnRangePlus/',self.RatioImgGBF, self.CanvasGBF, int(SX*0.892),int(SY*0.358), 0)
        self.ListEltInCanvasGBF.append(self.CanvasBtnRangePlus)
        self.CanvasBtnRangePlus.bind('<Button-1>', self.ChangeRangePlus)

        self.BtnRangeMoins, wsize, hsize, self.CanvasBtnRangeMoins, self.ImgBtnRangeMoins = CanInWindow(
            'Media/FrmGBF/BtnRangeMoins/', self.RatioImgGBF, self.CanvasGBF, int(SX * 0.815), int(SY * 0.358), 0)
        self.ListEltInCanvasGBF.append(self.CanvasBtnRangeMoins)
        self.CanvasBtnRangeMoins.bind('<Button-1>', self.ChangeRangeMoins)

        self.DigitAmp=[]
        self.DigitAmp, wsize, hsize = ChargeDossierImg('Media/FrmGBF/DigitV/',self.RatioImgGBF)
        self.CanvasDigitAmp=[]
        self.ImgDigitAmp=[]
        for i in range(3):
            self.ValeurDigitAmp.append(0)
            self.CanvasDigitAmp.append(CanvasApp(self.CanvasGBF, width=wsize, height=hsize))
            self.CanvasGBF.create_window(int(SX*0.329)+ i*(SX*0.006 + wsize),int(SY*0.38),anchor=tk.NW, window=self.CanvasDigitAmp[i])
            self.ImgDigitAmp.append(self.CanvasDigitAmp[i].create_image(0,0, anchor=tk.NW, image=self.DigitAmp[10]))

        self.LogoAmp, wsize, hsize, self.CanvasLogoAmp, self.ImgLogoAmp = CanInWindow(
            'Media/FrmGBF/LogoAmp/', self.RatioImgGBF, self.CanvasGBF, int(SX*0.329),int(SY*0.46),1)

        self.LogoVAmp, wsize, hsize, self.CanvasLogoVAmp, self.ImgLogoVAmp = CanInWindow(
            'Media/FrmGBF/LogoV/', self.RatioImgGBF, self.CanvasGBF, int(SX*0.43),int(SY*0.40), 1)

        self.LogoVOffset, wsize, hsize, self.CanvasLogoVOffset, self.ImgLogoVOffset = CanInWindow(
        'Media/FrmGBF/LogoV/', self.RatioImgGBF, self.CanvasGBF, int(SX * 0.575), int(SY * 0.40), 1)

        self.DigitOffset=[]
        self.DigitOffset, wsize, hsize = ChargeDossierImg('Media/FrmGBF/DigitV/',self.RatioImgGBF)
        self.CanvasDigitOffset=[]
        self.ImgDigitOffset=[]
        for i in range(3):
            self.ValeurDigitOffset.append(0)
            self.CanvasDigitOffset.append(CanvasApp(self.CanvasGBF, width=wsize, height=hsize))
            self.CanvasGBF.create_window(int(SX*0.475)+ i*(SX*0.006 + wsize),int(SY*0.38),anchor=tk.NW, window=self.CanvasDigitOffset[i])
            self.ImgDigitOffset.append(self.CanvasDigitOffset[i].create_image(0,0, anchor=tk.NW, image=self.DigitOffset[10]))

        self.LogoOffset, wsize, hsize, self.CanvasLogoOffset, self.ImgLogoOffset = CanInWindow(
            'Media/FrmGBF/LogoOffset/', self.RatioImgGBF, self.CanvasGBF, int(SX*0.49), int(SY*0.46), 1)

        self.VirgV, wsize, hsize = ChargeDossierImg('Media/FrmGBF/VirgV/',self.RatioImgGBF)
        self.CanvasVirgAmp=[]
        self.ImgVirgAmp=[]
        for i in range(2):
            self.CanvasVirgAmp.append(CanvasApp(self.CanvasGBF, width=wsize, height=hsize))
            self.CanvasGBF.create_window(int(SX*0.353)+ i*(SX*0.0242 + wsize),int(SY*0.435),anchor=tk.NW, window=self.CanvasVirgAmp[i])
            self.ImgVirgAmp.append(self.CanvasVirgAmp[i].create_image(0,0, anchor=tk.NW, image=self.VirgV[1]))

        self.CanvasVirgOffset=[]
        self.ImgVirgOffset=[]
        for i in range(2):
            self.CanvasVirgOffset.append(CanvasApp(self.CanvasGBF, width=wsize, height=hsize))
            self.CanvasGBF.create_window(int(SX*0.498)+ i*(SX*0.0242 + wsize),int(SY*0.435),anchor=tk.NW, window=self.CanvasVirgOffset[i])
            self.ImgVirgOffset.append(self.CanvasVirgOffset[i].create_image(0,0, anchor=tk.NW, image=self.VirgV[1]))

        self.CanvasGBF.pack()

    ####################################################################################################################
    ############################################ ALLUMAGE - EXTINCTION GBF #############################################
    ####################################################################################################################

    def OnOffGBF(self, evt):
        if self.OnGBF == False :
            self.OnGBF = True
            self.CanvasBtnGBFOnOff.itemconfig(self.ImgBtnGBFOnOff, image=self.BtnGBFOnOff[2])
            self.AllumeGBF()
        else :
            self.OnGBF =False
            self.CanvasBtnGBFOnOff.itemconfig(self.ImgBtnGBFOnOff, image=self.BtnGBFOnOff[0])
            self.EteintGBF()


    def OnOffMainOut(self, evt):
        if self.OnGBF == True:
            if self.OnMainOut == False:
                self.OnMainOut = True
                self.CanvasBtnGBFMainOut.itemconfig(self.ImgBtnGBFMainOut, image=self.BtnGBFMainOut[1])
                self.FreqMainOut = self.Freq
                self.AmpMainOut = self.Amp
                self.OffsetMainOut = self.Offset
                self.MainAppli.MAJSignal()
            else:
                self.OnMainOut = False
                self.CanvasBtnGBFMainOut.itemconfig(self.ImgBtnGBFMainOut, image=self.BtnGBFMainOut[0])
                self.FreqMainOut = 0.0
                self.AmpMainOut = 0.0
                self.OffsetMainOut = 0.0
                self.MainAppli.MAJSignal()

                
    def AllumeGBF(self):
        self.OnRegFreq=True
        self.DigitFreqSelect=4
        self.PosVirgFreq=0
        self.ValUnitFreq=0
        self.PosVirgAmp=1
        self.PosVirgOffset=1
        self.Amp=1.0
        self.Freq=1.0

        self.CanvasLogoFreq.itemconfig(self.ImglogoFreq, image=self.LogoFreq[0])
        self.CanvasLogoSin.itemconfig(self.ImgLogoSin, image=self.LogoSin[0])
        self.CanvasLogoAmp.itemconfig(self.ImgLogoAmp, image=self.LogoAmp[0])
        self.CanvasLogoVAmp.itemconfig(self.ImgLogoVAmp, image=self.LogoVAmp[0])
        self.CanvasLogoOffset.itemconfig(self.ImgLogoOffset, image=self.LogoOffset[0])
        self.CanvasLogoVOffset.itemconfig(self.ImgLogoVOffset, image=self.LogoVOffset[0])
        for i in range(5):
            if i==0:
                self.CanvasDigitFreq[i].itemconfig(self.ImgDigitFreq[i], image=self.DigitFreq[1])
                self.ValeurDigitFreq[i]=1
            else :
                self.CanvasDigitFreq[i].itemconfig(self.ImgDigitFreq[i], image=self.DigitFreq[0])
                self.ValeurDigitFreq[i]=0
        self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
        self.CanvasVirgAmp[self.PosVirgAmp].itemconfig(self.ImgVirgFreq[self.PosVirgAmp], image=self.VirgV[0])
        self.CanvasVirgOffset[self.PosVirgOffset].itemconfig(self.ImgVirgFreq[self.PosVirgOffset], image=self.VirgV[0])
        self.CanvasRegFreq[4].itemconfig(self.ImgRegFreq[4], image=self.RegFreq[0])
        self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
        self.CanvasBtnRegFreq.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegFreq[0])
        for i in range(3):
            if i==1:
                self.CanvasDigitAmp[i].itemconfig(self.ImgDigitAmp[i], image=self.DigitAmp[1])
                self.ValeurDigitAmp[i]=1
            else :
                self.CanvasDigitAmp[i].itemconfig(self.ImgDigitAmp[i], image=self.DigitAmp[0])
                self.ValeurDigitAmp[i]=0
        for i in range(3): self.CanvasDigitOffset[i].itemconfig(self.ImgDigitOffset[i], image=self.DigitOffset[0])

        for elt in self.ListEltInCanvasGBF:
            ChangeCursor(elt)

    def EteintGBF(self):
        self.OnRegFreq = False
        self.OnRegAmp = False
        self.OnRegOffset = False
        
        self.CanvasLogoFreq.itemconfig(self.ImglogoFreq, image=self.LogoFreq[1])
        self.CanvasLogoSin.itemconfig(self.ImgLogoSin, image=self.LogoSin[1])
        for i in range(5): self.CanvasDigitFreq[i].itemconfig(self.ImgDigitFreq[i], image=self.DigitFreq[10])
        for i in range(4): self.CanvasVirgFreq[i].itemconfig(self.ImgVirgFreq[i], image=self.VirgFreq[1])
        for i in range(5): self.CanvasRegFreq[i].itemconfig(self.ImgRegFreq[i], image=self.RegFreq[1])
        self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[2])
        self.CanvasBtnRegFreq.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegFreq[1])
        for i in range(3): self.CanvasDigitAmp[i].itemconfig(self.ImgDigitAmp[i], image=self.DigitAmp[10])
        for i in range(3): self.CanvasDigitOffset[i].itemconfig(self.ImgDigitOffset[i], image=self.DigitOffset[10])
        self.CanvasLogoAmp.itemconfig(self.ImgLogoAmp, image=self.LogoAmp[1])
        self.CanvasLogoOffset.itemconfig(self.ImgLogoOffset, image=self.LogoOffset[1])
        self.CanvasLogoVAmp.itemconfig(self.ImgLogoVAmp, image=self.LogoVAmp[1])
        self.CanvasLogoVOffset.itemconfig(self.ImgLogoVOffset, image=self.LogoVOffset[1])
        self.CanvasVirgAmp[self.PosVirgAmp].itemconfig(self.ImgVirgFreq[self.PosVirgAmp], image=self.VirgV[1])
        self.CanvasVirgOffset[self.PosVirgOffset].itemconfig(self.ImgVirgFreq[self.PosVirgOffset], image=self.VirgV[1])
        self.CanvasBtnRegAmp.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegAmp[1])
        self.CanvasBtnRegOffset.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegOffset[1])
        self.CanvasBtnGBFMainOut.itemconfig(self.ImgBtnGBFMainOut, image=self.BtnGBFMainOut[0])
        self.CanvasVirgAmp[0].itemconfig(self.ImgVirgFreq[self.PosVirgAmp], image=self.VirgV[1])

        self.OnMainOut = False
        self.FreqMainOut = 0.0
        self.AmpMainOut = 0.0
        self.MainAppli.MAJSignal()

        for elt in self.ListEltInCanvasGBF:
            elt.bind('<Enter>',lambda action: elt.configure(cursor=''))

    ####################################################################################################################
    ################################################# REGLAGE OFFSET ###################################################
    ####################################################################################################################

    def ChangeOffset(self,evt):

        if self.OnGBF == True:
            if self.OnRegOffset==False:
                self.CanvasBtnRegOffset.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegOffset[0])
                self.CanvasBtnRegAmp.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegAmp[1])
                self.CanvasBtnRegFreq.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegFreq[1])
                self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                self.OnRegAmp=False
                self.OnRegFreq=False
                self.OnRegOffset=True
                

    def ChangeDigitOffsetPlus(self,evt):

        if self.OnRegOffset==True and self.OnGBF == True:
            if self.Offset < 20.0:
                self.Offset = round(self.Offset+0.1, 1)
                Ent, Dec = str(self.Offset).split(".")
                self.ValeurDigitOffset[2]= int(Dec)
                self.CanvasDigitOffset[2].itemconfig(self.ImgDigitOffset[2], image=self.DigitOffset[self.ValeurDigitOffset[2]])

                if self.Offset < 10.0:                                    
                    self.ValeurDigitOffset[0] = 0
                    self.ValeurDigitOffset[1] = int(Ent)                
                    self.CanvasDigitOffset[1].itemconfig(self.ImgDigitOffset[1], image=self.DigitOffset[self.ValeurDigitOffset[1]])
                    self.CanvasDigitOffset[0].itemconfig(self.ImgDigitOffset[0], image=self.DigitOffset[self.ValeurDigitOffset[0]])
                else:
                    i=0
                    for l in Ent:
                        self.ValeurDigitOffset[i] = int(l)                
                        self.CanvasDigitOffset[i].itemconfig(self.ImgDigitOffset[i], image=self.DigitOffset[self.ValeurDigitOffset[i]])    
                        i=i+1

            if self.OnMainOut == True:
                self.OffsetMainOut = self.Offset
                self.MainAppli.MAJSignal()


    def ChangeDigitOffsetMoins(self,evt):

        if self.OnRegOffset==True and self.OnGBF == True:
            if self.Offset > 0.0:
                self.Offset = round(self.Offset-0.1, 1)
                Ent, Dec = str(self.Offset).split(".")
                self.ValeurDigitOffset[2]= int(Dec)
                self.CanvasDigitOffset[2].itemconfig(self.ImgDigitOffset[2], image=self.DigitOffset[self.ValeurDigitOffset[2]])
                if self.Offset < 10.0:                                    
                    self.ValeurDigitOffset[0] = 0                
                    self.CanvasDigitOffset[0].itemconfig(self.ImgDigitOffset[0], image=self.DigitOffset[self.ValeurDigitOffset[0]])
                    self.ValeurDigitOffset[1] = int(Ent)                
                    self.CanvasDigitOffset[1].itemconfig(self.ImgDigitOffset[1], image=self.DigitOffset[self.ValeurDigitOffset[1]])
                else:
                    i=0
                    for l in Ent:
                        self.ValeurDigitOffset[i] = int(l)                
                        self.CanvasDigitOffset[i].itemconfig(self.ImgDigitOffset[i], image=self.DigitOffset[self.ValeurDigitOffset[i]])    
                        i=i+1

        if self.OnMainOut == True:
            self.OffsetMainOut = self.Offset
            self.MainAppli.MAJSignal()

    ####################################################################################################################
    ################################################ REGLAGE AMPLITUDE #################################################
    ####################################################################################################################

    def ChangeAmplitude(self,evt):
        if self.OnGBF == True:
            if self.OnRegAmp==False:
                self.CanvasBtnRegAmp.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegAmp[0])
                self.CanvasBtnRegFreq.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegFreq[1])
                self.CanvasBtnRegOffset.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegOffset[1])
                self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                self.OnRegAmp=True
                self.OnRegFreq=False
                self.OnRegOffset=False


    def ChangeDigitAmpPlus(self,evt):
        if self.OnGBF == True and self.OnRegAmp==True:
            if self.Amp >= 1.0 and self.Amp <20.0:
                
                self.Amp = round(self.Amp+0.1, 1)                
                Ent, Dec = str(self.Amp).split(".")
                self.ValeurDigitAmp[2]= int(Dec)
                self.CanvasDigitAmp[2].itemconfig(self.ImgDigitAmp[2], image=self.DigitAmp[self.ValeurDigitAmp[2]])

                if self.Amp < 10.0:                                    
                    self.ValeurDigitAmp[0] = 0
                    self.ValeurDigitAmp[1] = int(Ent)                
                    self.CanvasDigitAmp[1].itemconfig(self.ImgDigitAmp[1], image=self.DigitAmp[self.ValeurDigitAmp[1]])
                    self.CanvasDigitAmp[0].itemconfig(self.ImgDigitAmp[0], image=self.DigitAmp[self.ValeurDigitAmp[0]])
                else:
                    i=0
                    for l in Ent:
                        self.ValeurDigitAmp[i] = int(l)                
                        self.CanvasDigitAmp[i].itemconfig(self.ImgDigitAmp[i], image=self.DigitAmp[self.ValeurDigitAmp[i]])    
                        i=i+1
            else:
                if self.Amp<0.99:
                    self.Amp=round(self.Amp+0.01,2)
                    Ent, Dec = str(self.Amp).split(".")
                    self.ValeurDigitAmp[0] = int(Ent)                
                    self.CanvasDigitAmp[0].itemconfig(self.ImgDigitAmp[0], image=self.DigitAmp[self.ValeurDigitAmp[0]])
                    self.CanvasVirgAmp[1].itemconfig(self.ImgVirgFreq[self.PosVirgAmp], image=self.VirgV[1])
                    self.CanvasVirgAmp[0].itemconfig(self.ImgVirgFreq[self.PosVirgAmp], image=self.VirgV[0])
                    if len(Dec) == 1: Dec = Dec + '0'
                    i=1
                    for l in Dec:
                        self.ValeurDigitAmp[i] = int(l)                
                        self.CanvasDigitAmp[i].itemconfig(self.ImgDigitAmp[i], image=self.DigitAmp[self.ValeurDigitAmp[i]])    
                        i=i+1
                else:
                    self.Amp=1.0
                    self.ValeurDigitAmp[0] = 0
                    self.ValeurDigitAmp[1] = 1
                    self.ValeurDigitAmp[2] = 0
                    self.CanvasVirgAmp[1].itemconfig(self.ImgVirgFreq[self.PosVirgAmp], image=self.VirgV[0])
                    self.CanvasVirgAmp[0].itemconfig(self.ImgVirgFreq[self.PosVirgAmp], image=self.VirgV[1])
                    for i in range (3):
                        self.CanvasDigitAmp[i].itemconfig(self.ImgDigitAmp[i], image=self.DigitAmp[self.ValeurDigitAmp[i]])

            if self.OnMainOut == True:
                self.AmpMainOut = self.Amp
                self.MainAppli.MAJSignal()


    def ChangeDigitAmpMoins(self,evt):
        if self.OnGBF == True and self.OnRegAmp==True:
            if self.Amp > 1.0 and self.Amp <20.0:
                self.Amp=round(self.Amp-0.1,1)
                Ent, Dec = str(self.Amp).split(".")
                self.ValeurDigitAmp[2]= int(Dec)
                self.CanvasDigitAmp[2].itemconfig(self.ImgDigitAmp[2], image=self.DigitAmp[self.ValeurDigitAmp[2]])
                if self.Amp < 10.0:                                    
                    self.ValeurDigitAmp[0] = 0                
                    self.CanvasDigitAmp[0].itemconfig(self.ImgDigitAmp[0], image=self.DigitAmp[self.ValeurDigitAmp[0]])
                    self.ValeurDigitAmp[1] = int(Ent)                
                    self.CanvasDigitAmp[1].itemconfig(self.ImgDigitAmp[1], image=self.DigitAmp[self.ValeurDigitAmp[1]])
                else:
                    i=0
                    for l in Ent:
                        self.ValeurDigitAmp[i] = int(l)                
                        self.CanvasDigitAmp[i].itemconfig(self.ImgDigitAmp[i], image=self.DigitAmp[self.ValeurDigitAmp[i]])    
                        i=i+1
            else:
                if self.Amp > 0:
                    self.Amp=round(self.Amp-0.01,2)
                    Ent, Dec = str(self.Amp).split(".")
                    self.ValeurDigitAmp[0] = int(Ent)                
                    self.CanvasDigitAmp[0].itemconfig(self.ImgDigitAmp[0], image=self.DigitAmp[self.ValeurDigitAmp[0]])
                    self.CanvasVirgAmp[1].itemconfig(self.ImgVirgFreq[self.PosVirgAmp], image=self.VirgV[1])
                    self.CanvasVirgAmp[0].itemconfig(self.ImgVirgFreq[self.PosVirgAmp], image=self.VirgV[0])
                    i=1
                    if len(Dec)==1: Dec=Dec+'0'
                    for l in Dec:
                        if i<3:
                            self.ValeurDigitAmp[i] = int(l)
                            self.CanvasDigitAmp[i].itemconfig(self.ImgDigitAmp[i], image=self.DigitAmp[self.ValeurDigitAmp[i]])
                        i=i+1

            if self.OnMainOut == True:
                self.AmpMainOut = self.Amp
                self.MainAppli.MAJSignal()

    ####################################################################################################################
    ################################################ REGLAGE FREQUENCE #################################################
    ####################################################################################################################

    def SelectDigitFrequence(self,evt):
        if self.OnGBF == True:
            if self.OnRegFreq==False:
                self.CanvasBtnRegFreq.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegFreq[0])
                self.CanvasBtnRegAmp.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegAmp[1])
                self.CanvasBtnRegOffset.itemconfig(self.ImgBtnRegFreq, image=self.BtnRegOffset[1])
                self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])
                self.OnRegFreq=True
                self.OnRegAmp=False
                self.OnRegOffset=False
            else:
                self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                self.DigitFreqSelect +=1
                if self.DigitFreqSelect >4: self.DigitFreqSelect=0
                self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])


    def ChangeDigitFreqPlus(self,evt):
        if self.OnRegFreq==True and self.OnGBF == True:
            self.ValMinFreq = False
            if self.ValeurDigitFreq[self.DigitFreqSelect]<9:
                self.ValeurDigitFreq[self.DigitFreqSelect]= self.ValeurDigitFreq[self.DigitFreqSelect]+1
                self.CanvasDigitFreq[self.DigitFreqSelect].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect],
                                                image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect]])
            else:
                self.ValeurDigitFreq[self.DigitFreqSelect]=0
                self.CanvasDigitFreq[self.DigitFreqSelect].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect],
                                                image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect]])
                if self.DigitFreqSelect>0:                    
                    if self.ValeurDigitFreq[self.DigitFreqSelect-1]<9:
                        self.ValeurDigitFreq[self.DigitFreqSelect-1]=self.ValeurDigitFreq[self.DigitFreqSelect-1]+1
                        self.CanvasDigitFreq[self.DigitFreqSelect-1].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-1],
                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-1]])
                    else:
                        if self.DigitFreqSelect-1>0:
                            self.ValeurDigitFreq[self.DigitFreqSelect-1]=0
                            self.CanvasDigitFreq[self.DigitFreqSelect-1].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-1],
                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-1]])
                            if self.ValeurDigitFreq[self.DigitFreqSelect-2] <9:
                                self.ValeurDigitFreq[self.DigitFreqSelect-2]=self.ValeurDigitFreq[self.DigitFreqSelect-2]+1
                                self.CanvasDigitFreq[self.DigitFreqSelect-2].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-2],
                                                                image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-2]])
                            else:
                                if self.DigitFreqSelect-2>0:
                                    self.ValeurDigitFreq[self.DigitFreqSelect-2]=0
                                    self.CanvasDigitFreq[self.DigitFreqSelect-2].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-2],
                                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-2]])
                                    if self.ValeurDigitFreq[self.DigitFreqSelect-3] <9:
                                        self.ValeurDigitFreq[self.DigitFreqSelect-3]=self.ValeurDigitFreq[self.DigitFreqSelect-3]+1
                                        self.CanvasDigitFreq[self.DigitFreqSelect-3].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-3],
                                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-3]])
                                    else:
                                        if self.DigitFreqSelect-3>0:
                                            self.ValeurDigitFreq[self.DigitFreqSelect-3]=0
                                            self.CanvasDigitFreq[self.DigitFreqSelect-3].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-3],
                                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-3]])
                                            if self.ValeurDigitFreq[self.DigitFreqSelect-4] <9:
                                                self.ValeurDigitFreq[self.DigitFreqSelect-4]=self.ValeurDigitFreq[self.DigitFreqSelect-4]+1
                                                self.CanvasDigitFreq[self.DigitFreqSelect-4].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-4],
                                                                                image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-4]])
                                            else:
                                                if self.DigitFreqSelect-4==0:    
                                                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                                    if self.PosVirgFreq<2 and self.ValUnitFreq==0:
                                                        self.PosVirgFreq=self.PosVirgFreq+1
                                                        self.ValeurDigitFreq[self.DigitFreqSelect-4]= 1
                                                    else:
                                                        if self.ValUnitFreq==0:
                                                            self.PosVirgFreq=0
                                                            self.ValUnitFreq=1
                                                            self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                                                            self.ValeurDigitFreq[self.DigitFreqSelect-4]= 1
                                                        else:
                                                            if self.PosVirgFreq<3:
                                                                self.PosVirgFreq=self.PosVirgFreq+1
                                                                self.ValeurDigitFreq[self.DigitFreqSelect-4]= 1
                                                            else:
                                                                for i in range(5):
                                                                    self.ValeurDigitFreq[self.DigitFreqSelect-i]=9                                                                    
                                                    self.CanvasDigitFreq[self.DigitFreqSelect-4].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-4],
                                                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-4]])
                                                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                                self.CanvasDigitFreq[self.DigitFreqSelect-4].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-4],
                                                                                image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-4]])
                                        else:
                                            self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                            if self.PosVirgFreq<2 and self.ValUnitFreq==0:
                                                self.PosVirgFreq=self.PosVirgFreq+1
                                                self.ValeurDigitFreq[self.DigitFreqSelect-3]= 1
                                            else:
                                                if self.ValUnitFreq==0:
                                                    self.PosVirgFreq=0
                                                    self.ValUnitFreq=1
                                                    self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                                                    self.ValeurDigitFreq[self.DigitFreqSelect-3]= 1
                                                else:
                                                    if self.PosVirgFreq<3:
                                                        self.PosVirgFreq=self.PosVirgFreq+1
                                                        self.ValeurDigitFreq[self.DigitFreqSelect-3]= 1
                                                    else:
                                                        for i in range(4):
                                                            self.ValeurDigitFreq[self.DigitFreqSelect-i]=9                                                            
                                            self.ValeurDigitFreq[self.DigitFreqSelect+1]= 0
                                            self.CanvasDigitFreq[self.DigitFreqSelect-3].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-3],
                                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-3]])
                                            self.CanvasDigitFreq[self.DigitFreqSelect+1].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+1],
                                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+1]])
                                            self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])                                                                               
                                        self.CanvasDigitFreq[self.DigitFreqSelect-3].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-3],
                                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-3]])
                                else:
                                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                    if self.PosVirgFreq<2 and self.ValUnitFreq==0:
                                        self.PosVirgFreq=self.PosVirgFreq+1
                                        self.ValeurDigitFreq[self.DigitFreqSelect-2]= 1
                                    else:
                                        if self.ValUnitFreq==0:
                                            self.PosVirgFreq=0
                                            self.ValUnitFreq=1
                                            self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                                            self.ValeurDigitFreq[self.DigitFreqSelect-2]= 1
                                        else:
                                            if self.PosVirgFreq<3:
                                                self.PosVirgFreq=self.PosVirgFreq+1
                                                self.ValeurDigitFreq[self.DigitFreqSelect-2]= 1
                                            else:
                                                for i in range(3):
                                                    self.ValeurDigitFreq[self.DigitFreqSelect-i]=9                                                                                                
                                    self.ValeurDigitFreq[self.DigitFreqSelect+2]= self.ValeurDigitFreq[self.DigitFreqSelect+1]
                                    self.ValeurDigitFreq[self.DigitFreqSelect+1]= 0
                                    self.CanvasDigitFreq[self.DigitFreqSelect-2].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-2],
                                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-2]])
                                    for i in range(-2,3):
                                        self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                    self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                                    self.DigitFreqSelect=self.DigitFreqSelect+1
                                    self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])                                                                
                        else:
                            self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                            if self.PosVirgFreq<2:
                                self.PosVirgFreq=self.PosVirgFreq+1
                                self.ValeurDigitFreq[self.DigitFreqSelect-1]= 1
                            else:
                                if self.ValUnitFreq==0 and self.ValUnitFreq==0:
                                    self.PosVirgFreq=0
                                    self.ValUnitFreq=1
                                    self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                                    self.ValeurDigitFreq[self.DigitFreqSelect-1]= 1
                                else:
                                    if self.PosVirgFreq<3:
                                        self.PosVirgFreq=self.PosVirgFreq+1
                                        self.ValeurDigitFreq[self.DigitFreqSelect-1]= 1
                                    else:
                                        self.ValeurDigitFreq[self.DigitFreqSelect]=9
                                        self.ValeurDigitFreq[self.DigitFreqSelect-1]=9                                                                
                            self.ValeurDigitFreq[self.DigitFreqSelect+3]= self.ValeurDigitFreq[self.DigitFreqSelect+2]
                            self.ValeurDigitFreq[self.DigitFreqSelect+2]= self.ValeurDigitFreq[self.DigitFreqSelect+1]
                            self.ValeurDigitFreq[self.DigitFreqSelect+1]= 0
                            self.CanvasDigitFreq[self.DigitFreqSelect-1].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-1],
                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-1]])
                            for i in range(-1,4):
                                self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                            self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])                            
                            self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                            self.DigitFreqSelect=self.DigitFreqSelect+1
                            self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])                            
                else:
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                    if self.PosVirgFreq<2 and self.ValUnitFreq==0:
                        self.PosVirgFreq=self.PosVirgFreq+1
                        self.ValeurDigitFreq[self.DigitFreqSelect]= self.ValeurDigitFreq[self.DigitFreqSelect]+1
                        
                    else:
                        if self.ValUnitFreq==0:
                            self.PosVirgFreq=0
                            self.ValUnitFreq=1
                            self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                            self.ValeurDigitFreq[self.DigitFreqSelect]= self.ValeurDigitFreq[self.DigitFreqSelect]+1
                        else:
                            if self.PosVirgFreq<3:
                                self.PosVirgFreq=self.PosVirgFreq+1
                                self.ValeurDigitFreq[self.DigitFreqSelect]= self.ValeurDigitFreq[self.DigitFreqSelect]+1
                            else: self.ValeurDigitFreq[self.DigitFreqSelect]=9
                    for i in range(4,1,-1):
                        self.ValeurDigitFreq[self.DigitFreqSelect+i]= self.ValeurDigitFreq[self.DigitFreqSelect+i-1]
                    self.ValeurDigitFreq[self.DigitFreqSelect+1]= 0
                    for i in range(5):
                        self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                    self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                    self.DigitFreqSelect=self.DigitFreqSelect+1
                    self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])

            self.CalculFreq()


    def ChangeDigitFreqMoins(self,evt):
        if self.OnRegFreq==True and self.OnGBF == True:
            if self.DigitFreqSelect>0 :
                if self.ValeurDigitFreq[self.DigitFreqSelect]>0:
                    self.ValeurDigitFreq[self.DigitFreqSelect]= self.ValeurDigitFreq[self.DigitFreqSelect]-1
                    self.CanvasDigitFreq[self.DigitFreqSelect].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect],
                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect]])
                else:
                    self.ValeurDigitFreq[self.DigitFreqSelect]=9
                    self.CanvasDigitFreq[self.DigitFreqSelect].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect],
                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect]])
                    if self.DigitFreqSelect-1>0:
                        if self.ValeurDigitFreq[self.DigitFreqSelect-1]>0:
                            self.ValeurDigitFreq[self.DigitFreqSelect-1]=self.ValeurDigitFreq[self.DigitFreqSelect-1]-1
                            self.CanvasDigitFreq[self.DigitFreqSelect-1].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-1],
                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-1]])
                        else:
                            self.ValeurDigitFreq[self.DigitFreqSelect-1]=9
                            self.CanvasDigitFreq[self.DigitFreqSelect-1].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-1],
                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-1]])
                            if self.DigitFreqSelect-2>0:
                                if self.ValeurDigitFreq[self.DigitFreqSelect-2]>0:
                                    self.ValeurDigitFreq[self.DigitFreqSelect-2]=self.ValeurDigitFreq[self.DigitFreqSelect-2]-1
                                    self.CanvasDigitFreq[self.DigitFreqSelect-2].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-2],
                                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-2]])
                                else:
                                    self.ValeurDigitFreq[self.DigitFreqSelect-2]=9
                                    self.CanvasDigitFreq[self.DigitFreqSelect-2].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-2],
                                                                image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-2]])
                                    if self.DigitFreqSelect-3>0:
                                        if self.ValeurDigitFreq[self.DigitFreqSelect-3]>0:
                                            self.ValeurDigitFreq[self.DigitFreqSelect-3]=self.ValeurDigitFreq[self.DigitFreqSelect-3]-1
                                            self.CanvasDigitFreq[self.DigitFreqSelect-3].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-3],
                                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-3]])
                                        else:
                                            self.ValeurDigitFreq[self.DigitFreqSelect-3]=9
                                            self.CanvasDigitFreq[self.DigitFreqSelect-3].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-3],
                                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-3]])
                                            if self.DigitFreqSelect-4==0:                                                
                                                if self.ValeurDigitFreq[self.DigitFreqSelect-4]>1:
                                                    self.ValeurDigitFreq[self.DigitFreqSelect-4]= self.ValeurDigitFreq[self.DigitFreqSelect-4]-1
                                                    self.CanvasDigitFreq[self.DigitFreqSelect-4].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-4],
                                                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-4]])
                                                else:
                                                    if self.PosVirgFreq>0:
                                                        for i in range(-4,0):
                                                            self.ValeurDigitFreq[self.DigitFreqSelect+i]=self.ValeurDigitFreq[self.DigitFreqSelect+i+1]                                                        
                                                        self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                                        self.PosVirgFreq=self.PosVirgFreq-1
                                                        self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                                        for i in range(-4,0):
                                                            self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                                        self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                                                        self.DigitFreqSelect=self.DigitFreqSelect-1
                                                        self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])
                                                    else:
                                                        if self.ValUnitFreq==0:
                                                            for i in range(4):
                                                                self.ValeurDigitFreq[self.DigitFreqSelect-i]=0                                                            
                                                            for i in range(-3,1):
                                                                self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                                                image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                                        else:
                                                            for i in range(-4,0):
                                                                self.ValeurDigitFreq[self.DigitFreqSelect+i]=self.ValeurDigitFreq[self.DigitFreqSelect+i+1]
                                                
                                                            for i in range(-4,1):
                                                                self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                                            self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                                            self.PosVirgFreq=self.PosVirgFreq+2
                                                            self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                                            self.ValUnitFreq=0
                                                            self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                                                            self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                                                            self.DigitFreqSelect=self.DigitFreqSelect-1
                                                            self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])                                                                                                                                                                                
                                    else:
                                        if self.ValeurDigitFreq[self.DigitFreqSelect-3]>1:
                                            self.ValeurDigitFreq[self.DigitFreqSelect-3]= self.ValeurDigitFreq[self.DigitFreqSelect-3]-1
                                            self.CanvasDigitFreq[self.DigitFreqSelect-3].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-3],
                                                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-3]])
                                        else:
                                            if self.PosVirgFreq>0:
                                                for i in range(-3,1):
                                                    self.ValeurDigitFreq[self.DigitFreqSelect+i]=self.ValeurDigitFreq[self.DigitFreqSelect+i+1]
                                                self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                                self.PosVirgFreq=self.PosVirgFreq-1
                                                self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                                for i in range(-3,1):
                                                    self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                                self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                                                self.DigitFreqSelect=self.DigitFreqSelect-1
                                                self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])
                                            else:
                                                if self.ValUnitFreq==0:
                                                    for i in range(3):
                                                        self.ValeurDigitFreq[self.DigitFreqSelect-i]=0                                                    
                                                    for i in range(-2,1):
                                                        self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                                else:
                                                    for i in range(-3,1):
                                                        self.ValeurDigitFreq[self.DigitFreqSelect+i]=self.ValeurDigitFreq[self.DigitFreqSelect+i+1]
                                                    self.ValeurDigitFreq[self.DigitFreqSelect+1]=0
                                                    for i in range(-3,2):
                                                        self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                                    self.PosVirgFreq=self.PosVirgFreq+2
                                                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                                    self.ValUnitFreq=0
                                                    self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                                                    self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                                                    self.DigitFreqSelect=self.DigitFreqSelect-1
                                                    self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])
                                                    
                            else:
                               if self.ValeurDigitFreq[self.DigitFreqSelect-2]>1:
                                    self.ValeurDigitFreq[self.DigitFreqSelect-2]= self.ValeurDigitFreq[self.DigitFreqSelect-2]-1
                                    self.CanvasDigitFreq[self.DigitFreqSelect-2].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-2],
                                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-2]])
                               else:
                                    if self.PosVirgFreq>0:
                                        for i in range(-2,2):
                                            self.ValeurDigitFreq[self.DigitFreqSelect+i]=self.ValeurDigitFreq[self.DigitFreqSelect+i+1]
                                        self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                        self.PosVirgFreq=self.PosVirgFreq-1
                                        self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                        for i in range(-2,2):
                                            self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                        self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                                        self.DigitFreqSelect=self.DigitFreqSelect-1
                                        self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])
                                    else:
                                        if self.ValUnitFreq==0:
                                            self.ValeurDigitFreq[self.DigitFreqSelect]=0
                                            self.ValeurDigitFreq[self.DigitFreqSelect-1]=0
                                            for i in range(-1,1):
                                                self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                                image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                        else:
                                            for i in range(-2,2):
                                                self.ValeurDigitFreq[self.DigitFreqSelect+i]=self.ValeurDigitFreq[self.DigitFreqSelect+i+1]
                                            self.ValeurDigitFreq[self.DigitFreqSelect+2]=0
                                            for i in range(-2,3):
                                                self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                            self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                            self.PosVirgFreq=self.PosVirgFreq+2
                                            self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                            self.ValUnitFreq=0
                                            self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                                            self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                                            self.DigitFreqSelect=self.DigitFreqSelect-1
                                            self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])
                                            
                    else:
                        if self.ValeurDigitFreq[self.DigitFreqSelect-1]>1:
                            self.ValeurDigitFreq[self.DigitFreqSelect-1]= self.ValeurDigitFreq[self.DigitFreqSelect-1]-1
                            self.CanvasDigitFreq[self.DigitFreqSelect-1].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect-1],
                                                            image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect-1]])
                        else:
                            
                            if self.PosVirgFreq>0: 
                                for i in range(-1,3):
                                    self.ValeurDigitFreq[self.DigitFreqSelect+i]=self.ValeurDigitFreq[self.DigitFreqSelect+i+1]                           
                                self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                self.PosVirgFreq=self.PosVirgFreq-1
                                self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                for i in range(-1,3):
                                    self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                                self.DigitFreqSelect=self.DigitFreqSelect-1
                                self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])
                            else:
                                if self.ValUnitFreq==0:
                                    self.ValeurDigitFreq[self.DigitFreqSelect]=0
                                    self.CanvasDigitFreq[self.DigitFreqSelect].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect],
                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect]])
                                else:
                                    for i in range(-1,3):
                                        self.ValeurDigitFreq[self.DigitFreqSelect+i]=self.ValeurDigitFreq[self.DigitFreqSelect+i+1]
                                    self.ValeurDigitFreq[self.DigitFreqSelect+3]=0
                                    for i in range(-1,4):
                                        self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                                        image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                                    self.PosVirgFreq=self.PosVirgFreq+2
                                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                                    self.ValUnitFreq=0
                                    self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                                    self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[1])
                                    self.DigitFreqSelect=self.DigitFreqSelect-1
                                    self.CanvasRegFreq[self.DigitFreqSelect].itemconfig(self.ImgRegFreq[self.DigitFreqSelect], image=self.RegFreq[0])
                                    
            else:
                if self.ValUnitFreq==0:
                    if self.ValeurDigitFreq[self.DigitFreqSelect]>1:
                        self.ValeurDigitFreq[self.DigitFreqSelect]= self.ValeurDigitFreq[self.DigitFreqSelect]-1 
                        self.CanvasDigitFreq[self.DigitFreqSelect].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect],
                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect]])
                else:
                    if self.ValeurDigitFreq[self.DigitFreqSelect]>1:
                        self.ValeurDigitFreq[self.DigitFreqSelect]= self.ValeurDigitFreq[self.DigitFreqSelect]-1 
                        self.CanvasDigitFreq[self.DigitFreqSelect].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect],
                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect]])
                    else:
                        self.ValeurDigitFreq[self.DigitFreqSelect]=9
                        for i in range(1,4):
                            self.ValeurDigitFreq[self.DigitFreqSelect+i]=self.ValeurDigitFreq[self.DigitFreqSelect+i+1]
                        self.ValeurDigitFreq[self.DigitFreqSelect+4]=0
                        self.ValUnitFreq=0
                        self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
                        self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                        self.PosVirgFreq=self.PosVirgFreq+2
                        self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                        for i in range(5):
                            self.CanvasDigitFreq[self.DigitFreqSelect+i].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect+i],
                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect+i]])
                        self.CanvasDigitFreq[self.DigitFreqSelect].itemconfig(self.ImgDigitFreq[self.DigitFreqSelect],
                                                    image=self.DigitFreq[self.ValeurDigitFreq[self.DigitFreqSelect]])

            self.CalculFreq()
    

    def ChangeRangePlus(self,evt):
        if self.OnRegFreq==True and self.OnGBF == True:
            if self.ValUnitFreq==0:
                if self.PosVirgFreq<2:
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                    self.PosVirgFreq=self.PosVirgFreq+1
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                else:
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                    self.PosVirgFreq=0
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                    self.ValUnitFreq=1
                    self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])
            else:
                if self.PosVirgFreq<3:
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                    self.PosVirgFreq=self.PosVirgFreq+1
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])

            self.CalculFreq()
                    
            
    def ChangeRangeMoins(self,evt):
        if self.OnRegFreq==True and self.OnGBF == True:
            if self.ValUnitFreq==0:
                if self.PosVirgFreq>0:
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                    self.PosVirgFreq=self.PosVirgFreq-1
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])       
            else:
                if self.PosVirgFreq>0:
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                    self.PosVirgFreq=self.PosVirgFreq-1
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                else:
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[1])
                    self.PosVirgFreq=2
                    self.CanvasVirgFreq[self.PosVirgFreq].itemconfig(self.ImgVirgFreq[self.PosVirgFreq], image=self.VirgFreq[0])
                    self.ValUnitFreq=0
                    self.CanvasUnitFreq.itemconfig(self.ImgUnitFreq, image=self.UnitFreq[self.ValUnitFreq])

            self.CalculFreq()
        

    def CalculFreq(self):
        if self.ValUnitFreq==0:
            if self.PosVirgFreq == 0:
                self.Freq=round(self.ValeurDigitFreq[0]+self.ValeurDigitFreq[1]*0.1+self.ValeurDigitFreq[2]*0.01+
                                self.ValeurDigitFreq[3]*0.001+self.ValeurDigitFreq[4]*0.0001,4)
            if self.PosVirgFreq == 1:
                self.Freq = round(self.ValeurDigitFreq[0]*10 + self.ValeurDigitFreq[1] + self.ValeurDigitFreq[2] * 0.1 +
                                  self.ValeurDigitFreq[3] * 0.01 + self.ValeurDigitFreq[4] * 0.001, 3)
            if self.PosVirgFreq == 2:
                self.Freq = round(self.ValeurDigitFreq[0]*100 + self.ValeurDigitFreq[1]*10 + self.ValeurDigitFreq[2] +
                                  self.ValeurDigitFreq[3] * 0.1 + self.ValeurDigitFreq[4] * 0.01, 2)
        else:
            if self.PosVirgFreq == 0:
                self.Freq=round(self.ValeurDigitFreq[0]*1000+self.ValeurDigitFreq[1]*100+self.ValeurDigitFreq[2]*10+
                                self.ValeurDigitFreq[3]+self.ValeurDigitFreq[4]*0.1,1)
            if self.PosVirgFreq == 1:
                self.Freq=self.ValeurDigitFreq[0]*10000+self.ValeurDigitFreq[1]*1000+self.ValeurDigitFreq[2]*100+ self.ValeurDigitFreq[3]*10+self.ValeurDigitFreq[4]
            if self.PosVirgFreq == 2:
                self.Freq=self.ValeurDigitFreq[0]*100000+self.ValeurDigitFreq[1]*10000+self.ValeurDigitFreq[2]*1000+ self.ValeurDigitFreq[3]*10+self.ValeurDigitFreq[4]*10
            if self.PosVirgFreq == 3:
                self.Freq=self.ValeurDigitFreq[0]*1000000+self.ValeurDigitFreq[1]*100000+self.ValeurDigitFreq[2]*10000+ self.ValeurDigitFreq[3]*100+self.ValeurDigitFreq[4]*100

        if self.OnMainOut == True:
            self.FreqMainOut = self.Freq
            self.MainAppli.MAJSignal()

    ####################################################################################################################
    ############################################# GESTION REGLAGES PAR ROULETTE ########################################
    ####################################################################################################################

    def MouseWheel(self, event):
    
        if event.delta == -120:
            if self.OnRegFreq==True: self.ChangeDigitFreqMoins(event)
            if self.OnRegAmp==True: self.ChangeDigitAmpMoins (event)
            if self.OnRegOffset==True: self.ChangeDigitOffsetMoins (event)
            
        if event.delta == 120:
            if self.OnRegFreq==True: self.ChangeDigitFreqPlus(event)
            if self.OnRegAmp==True:  self.ChangeDigitAmpPlus(event)
            if self.OnRegOffset==True:  self.ChangeDigitOffsetPlus(event)
        

