import sys
from math import *
from GBF import *
from Oscillo import *
from Circuit import *


class MainAppli():

    def __init__(self):

    ####################################################################################################################
    ########################################### DECLARATION DES VARIABLES ##############################################
    ####################################################################################################################

        self.FrmMain = FrmMainApp("")

        self.TypeCircuit = 0
        self.Z1 = 0
        self.Z2 = 0
        self.F = 0

        SX = self.FrmMain.swidth
        SY = self.FrmMain.sheight

        self.Nconfig = DeterminAspectRatio(SX,SY)

        FrmMainFond = Image.open('Media/FrmMain/Fond/Fond.jpg')
        self.RatioFond = float(SX) / float(FrmMainFond.size[0])

    ####################################################################################################################
    ########################################## CHARGEMENT FENETRE PRINCIPALE ###########################################
    ####################################################################################################################

        self.ImgFrmMain = []
        self.ImgFrmMain = RedimImg(SX, SY, 'Media/FrmMain/Fond/')
        self.CanvasFrmMain = CanvasApp(self.FrmMain, width=SX, height=SY)
        Nimage = int(ConfigResolution(self.Nconfig, 'N'))
        self.ImgCanvasFrmMain = self.CanvasFrmMain.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmMain[Nimage])

        self.ImgBtnArret, wsize, hsize, self.CanvasBtnArret, self.ImgCanvasBtnArret = CanInWindow(
            'Media/FrmMain/BtnArret/', self.RatioFond, self.CanvasFrmMain,int(SX * 0.945), int(SY * 0.04), 0)
        ChangeCursor(self.CanvasBtnArret)
        self.CanvasBtnArret.bind('<ButtonPress-1>',
                lambda action: self.CanvasBtnArret.itemconfig(self.ImgCanvasBtnArret, image=self.ImgBtnArret[1]))
        self.CanvasBtnArret.bind('<ButtonRelease-1>', self.AppliStop)

        self.ImgBtnOuvrir, wsize, hsize, self.CanvasBtnOuvrir, self.ImgCanvasBtnOuvrir = CanInWindow(
        'Media/FrmMain/BtnOuvrir/', self.RatioFond, self.CanvasFrmMain, int(SX * 0.018), int(SY * 0.04), 0)
        ChangeCursor(self.CanvasBtnOuvrir)
        self.CanvasBtnOuvrir.bind('<ButtonPress-1>', self.OuvreCircuit)

    ####################################################################################################################
    ############################################### CHARGEMENT GBF #####################################################
    ####################################################################################################################

        self.Ratio = self.FrmMain.swidth * ConfigResolution(self.Nconfig, 'R1')
        self.FrameGBF = CanvasApp(self.CanvasFrmMain)
        self.CanvasFrmMain.create_window(int(SX*0.368+(SX*0.646-self.Ratio)/2),int(SY*0.576),anchor=tk.NW, window=self.FrameGBF)
        self.MyGBF = AppliGBF(self.FrameGBF,self.Ratio,self)

    ####################################################################################################################
    ############################################## CHARGEMENT OSCILLO ##################################################
    ####################################################################################################################

        self.Ratio = self.FrmMain.swidth * ConfigResolution(self.Nconfig, 'R2')
        self.FrameOscillo = CanvasApp(self.CanvasFrmMain)
        self.CanvasFrmMain.create_window(int((SX - self.Ratio)/2), int(SY*0.001),anchor=tk.NW, window=self.FrameOscillo)
        self.MyOscillo = AppliOscillo(self.FrameOscillo, self.Ratio, self)

    ####################################################################################################################
    ############################################## CHARGEMENT CIRCUIT ##################################################
    ####################################################################################################################


        self.Ratio = self.FrmMain.swidth * ConfigResolution(self.Nconfig, 'R3')
        Ycircuit = int(SY * ConfigResolution(self.Nconfig, 'YC'))
        self.FrameCircuit = CanvasApp(self.CanvasFrmMain)
        self.CanvasFrmMain.create_window(int(SX*0.091), Ycircuit, anchor=tk.NW, window=self.FrameCircuit)
        self.MyCircuit = AppliCircuit(self.FrameCircuit, self.Ratio, self)



    ####################################################################################################################
    ######################################## AFFICHAGE FENETRE PRINCIPALE ##############################################
    ####################################################################################################################

        self.CanvasFrmMain.pack()
        self.FrmMain.mainloop()

    ####################################################################################################################
    ####################################### TRANSMITION SIGNAUX A L'OSCILLO ############################################
    ####################################################################################################################

    def MAJSignal(self):
        self.F = self.MyGBF.FreqMainOut
        if self.MyOscillo.OnVoie[0]== True:
            self.MyOscillo.MAJAmpFreq(self.MyGBF.AmpMainOut,self.MyGBF.FreqMainOut,self.MyGBF.OffsetMainOut,0)
        if self.MyCircuit.Voie2Connect == True and self.MyOscillo.OnVoie[1]== True:
            if self.TypeCircuit == 3:
                self.MyOscillo.MAJAmpFreq(self.MyGBF.AmpMainOut,self.MyGBF.FreqMainOut,0,1)
            else:
                if self.TypeCircuit == 1:
                    self.MyOscillo.MAJAmpFreq(self.MyGBF.AmpMainOut, self.MyGBF.FreqMainOut, self.FonctionTransfert(self.MyGBF.OffsetMainOut), 1)
                else:
                    self.MyOscillo.MAJAmpFreq(self.MyGBF.AmpMainOut, self.MyGBF.FreqMainOut, self.MyGBF.OffsetMainOut, 1)
        else:
            if self.MyOscillo.OnVoie[1] == True:
                self.MyOscillo.MAJAmpFreq(0,0,0,1)

    def FuncSignal(self,A,F,X,Phi):
        if self.MyGBF.TypeSignal==1:
            Y = (A / 2) * np.cos(2 * pi * F * X + Phi)
            return Y

    def DefFonctionTransfert (self, TypeCircuit, Z1, Z2):
        self.TypeCircuit = TypeCircuit
        self.Z1=Z1
        self.Z2=Z2

    def FonctionTransfert(self,E):
        if self.TypeCircuit==0:
            S=0
        if self.TypeCircuit==1:
            S=E*(self.Z1/(self.Z1+self.Z2))
        if self.TypeCircuit==2:
            S=E/sqrt(1+(2*pi*self.F*self.Z1*self.Z2)**2)
        if self.TypeCircuit==3:
            S=(E*2*pi*self.F*self.Z1*self.Z2)/sqrt(1+(2*pi*self.F*self.Z1*self.Z2)**2)
        return S

    def CalculDephasage(self,F):
        if F>0 :
            if self.TypeCircuit == 0:
                Phi = 0
            if self.TypeCircuit == 1:
                Phi = 0
            if self.TypeCircuit == 2:
                Phi = -atan(2*pi*self.F*self.Z1*self.Z2)
            if self.TypeCircuit == 3:
                Phi = pi/2 - atan(2*pi*self.F*self.Z1*self.Z2)
        else:
            Phi = 0
        return Phi

    ####################################################################################################################
    ############################################# OUVRIR UN CIRCUIT ####################################################
    ####################################################################################################################

    def OuvreCircuit(self,evt):
        self.MyCircuit.AffichCircuits(evt)

    ####################################################################################################################
    ################################################# STOP APPLI #######################################################
    ####################################################################################################################

    def AppliStop(self,evt):
        if self.MyOscillo.OnOscillo == True:
            self.MyOscillo.TimerDate.stop()
        self.FrmMain.destroy()
        sys.exit()


########################################################################################################################
################################################## LANCEMENT APPLI #####################################################
########################################################################################################################

MainAppli()
