from AppliDef import *
from matplotlib.figure import Figure
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg
import numpy as np
import time


class AppliOscillo():
    
    def __init__(self, container, ratio, appli):

    ####################################################################################################################
    ########################################### DECLARATION DES VARIABLES ##############################################
    ####################################################################################################################

        self.MainAppli = appli
        self.CalX = 1
        self.X0 = 0
        self.X1 = 0
        self.X2 = 0
        self.Y1 = 0
        self.Y2 = 0
        self.trigY = 0
        self.trigX = 0
        self.TypeSlope = 0
        self.DephasageVoie2 = 0
        self.Offset = []
        self.CalY = []
        self.OnOscillo = False
        self.OnVoie = []
        self.Y0Voie = []
        self.Y0VoieStr = []
        self.StrCalVoie = []
        self.StrValMeas = []
        self.StrTypeMeas = []
        self.SignalTypeCoupling=[]
        self.ChannelStr = ['Channel 1', 'Channel 2']
        self.ValCal = [0.0005, 0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1, 2, 5, 10]
        self.ValCalX = [0.000000005, 0.00000001, 0.00000002, 0.00000005, 0.0000001, 0.0000002, 0.0000005, 0.000001,
                        0.000002, 0.000005,
                        0.00001, 0.00002, 0.00005, 0.0001, 0.0002, 0.0005, 0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1,
                        0.2, 0.5, 1, 2, 5, 10, 20, 50]
        self.ComptValCal = []
        self.ComptValCalX = 0
        self.ComptDecalVoie = []
        self.ComptDecalX = 0
        self.FreqVoie = []
        self.AmplVoie = []
        self.TypeSignal = 0
        self.SymbVoieStr = ['[1]', '[2]']
        self.ColorVoie = ['yellow', 'green', '#181816', 'black']
        self.MenuSelect=''
        self.ActionMenu=''
        self.VoieActionMenu = 0
        self.VoieSourceMeas = 0
        self.VoieSourceTrigg = 0
        self.VSMeas=[]
        self.TypeMeas = 0
        self.TMeas=[]
        self.ValMeas=[]
        self.NbrMeas = 0
        self.ClearMeasFait = False
        self.LabelValMeas = []
        self.LabelTypeMeas = []
        self.ListEltInCanvasOscillo = []

        for i in range(2):
            self.Y0Voie.append(0.0)
            self.OnVoie.append(False)
            self.CalY.append(1)
            self.ComptValCal.append(10)
            self.ComptDecalVoie.append(0)
            self.FreqVoie.append(0.0)
            self.AmplVoie.append(0.0)
            self.Offset.append(0.0)
            self.SignalTypeCoupling.append(0)

        for i in range(4):
            self.VSMeas.append(0)
            self.TMeas.append(0)
            self.ValMeas.append(0)
            self.StrValMeas.append(tk.StringVar())
            self.StrTypeMeas.append(tk.StringVar())

        SizeFont = int(ConfigResolution(self.MainAppli.Nconfig, 'Osc1'))
        self.MyFont = FontLabel(SizeFont)
        SizeFont = int(ConfigResolution(self.MainAppli.Nconfig, 'Osc2'))
        self.MyFont2 = FontLabel(SizeFont)

        PhotoOscillo = Image.open('Media/FrmOscillo/Main/Oscillo.jpg')
        self.RatioImgOscillo = ratio / float(PhotoOscillo.size[0])

    ####################################################################################################################
    ###################################### AFFICHAGE OSCILLO - BOUTONS INTERACTIFS #####################################
    ####################################################################################################################

        self.ImgFrameOscillo, SX, SY, self.CanvasOscillo, self.ImgCanvasOscillo  = CanInWindow(
            'Media/FrmOscillo/Main/', self.RatioImgOscillo, container, 0, 0 , 1)
        self.SX = SX
        self.SY = SY

        self.Menu, self.Menuwsize, self.Menuhsize = ChargeDossierImg('Media/FrmOscillo/Menu/', self.RatioImgOscillo)
        self.CanvasMenu = CanvasApp(self.CanvasOscillo, width=self.Menuwsize, height=self.Menuhsize, bg='black')
        self.CanvasOscillo.create_window(int(SX * 0.469), int(SY * 0.212), anchor=tk.NW, window=self.CanvasMenu)

        self.BtnOscilloOnOff, wsize, hsize, self.CanvasBtnOscilloOnOff, self.ImgBtnOscilloOnOff  = CanInWindow(
            'Media/FrmOscillo/BtnOnOff/', self.RatioImgOscillo, self.CanvasOscillo, int(SX * 0.066), int(SY * 0.838), 0)
        ChangeCursor(self.CanvasBtnOscilloOnOff)
        self.CanvasBtnOscilloOnOff.bind('<Button-1>', self.OnOffOscillo)

        self.BtnOscilloVoie, wsize, hsize, self.CanvasBtnOscilloVoie, self.ImgBtnOscilloVoie = ListCanInWindow(
            'Media/FrmOscillo/BtnVoie/', self.RatioImgOscillo, self.CanvasOscillo, int(SX * 0.682), int(SX*0.113),
            int(SY * 0.649), 0, 2, 0)
        self.CanvasBtnOscilloVoie[1].itemconfig(self.ImgBtnOscilloVoie[1], image=self.BtnOscilloVoie[2])
        for i in range(2):
            def GestEvt(evt, j=i):
                return self.OnOffVoie(evt, j)
            self.CanvasBtnOscilloVoie[i].bind('<Button-1>', GestEvt)
            self.ListEltInCanvasOscillo.append(self.CanvasBtnOscilloVoie[i])

        self.BtnOscilloDecalVoie, wsize, hsize, self.CanvasBtnOscilloDecalVoie, self.ImgBtnOscilloDecalVoie = ListCanInWindow(
            'Media/FrmOscillo/BtnDecalVoie/', self.RatioImgOscillo, self.CanvasOscillo, int(SX*0.68),int(SX*0.114),
            int(SY * 0.744),0,2,0 )
        self.CanvasBtnOscilloDecalVoie[1].itemconfig(self.ImgBtnOscilloDecalVoie[1], image=self.BtnOscilloDecalVoie[1])
        for i in range(2):
            def GestEvt2(evt, j=i):
                return self.DecalVoieAnnul(evt, j)
            self.CanvasBtnOscilloDecalVoie[i].bind('<Button-1>', GestEvt2)
            def GestEvt3(evt, j=i):
                return self.MouseWheelDecalVoie(evt, j)
            self.CanvasBtnOscilloDecalVoie[i].bind('<MouseWheel>', GestEvt3)
            self.ListEltInCanvasOscillo.append(self.CanvasBtnOscilloDecalVoie[i])

        self.LabelSymbVoie = []
        for i in range(2):
            self.LabelSymbVoie.append(LabelText(self.CanvasOscillo, '', 'black', font=self.MyFont))
            self.CanvasOscillo.create_window(int((SX * 0.065)+ i * (SX * 0.10)), int(SY * 0.175) , anchor=tk.NW,
                window=self.LabelSymbVoie[i])

        self.ValCalVoie = []
        for i in range(2):
            self.StrCalVoie.append(tk.StringVar())
            self.ValCalVoie.append(LabelVar(self.CanvasOscillo, self.StrCalVoie[i], 'black', font=self.MyFont))
            self.CanvasOscillo.create_window(int((SX * 0.09)+ i * (SX * 0.10)), int(SY * 0.175), anchor=tk.NW,
                window=self.ValCalVoie[i])

        self.BtnCalVoie, wsize, hsize, self.CanvasBtnCalVoie, self.ImgBtnCalVoie = ListCanInWindow(
            'Media/FrmOscillo/BtnCalVoie/', self.RatioImgOscillo, self.CanvasOscillo, int(SX * 0.681), int(SX * 0.114),
            int(SY * 0.54), 0, 2, 0)
        self.CanvasBtnCalVoie[1].itemconfig(self.ImgBtnCalVoie[1], image=self.BtnCalVoie[1] )
        for i in range(2):
            def GestEvt4(evt, j=i):
                return self.MouseWheelChangeCalVoie(evt, j)
            self.CanvasBtnCalVoie[i].bind('<MouseWheel>', GestEvt4)
            self.ListEltInCanvasOscillo.append(self.CanvasBtnCalVoie[i])

        self.StrCalX=tk.StringVar()
        self.LabelValCalX = LabelVar(self.CanvasOscillo, self.StrCalX, 'black', font=self.MyFont)
        self.CanvasOscillo.create_window(int(SX * 0.35) , int(SY * 0.175), anchor=tk.NW, window=self.LabelValCalX)

        self.BtnCalX, wsize, hsize, self.CanvasBtnCalX, self.ImgBtnCalX = CanInWindow(
            'Media/FrmOscillo/BtnCalX/', self.RatioImgOscillo, self.CanvasOscillo, int(SX * 0.706), int(SY * 0.153), 0)
        self.CanvasBtnCalX.bind('<MouseWheel>', self.MouseWheelChangeCalX)
        self.ListEltInCanvasOscillo.append(self.CanvasBtnCalX)

        self.X0Str=tk.StringVar()
        self.ValDecalX=LabelVar(self.CanvasOscillo, self.X0Str, 'black', font=self.MyFont)
        self.CanvasOscillo.create_window(int(SX * 0.28), int((SY * 0.175)), anchor=tk.NW, window=self.ValDecalX)

        self.SymbDecalX, wsize, hsize, self.CanvasSymbDecalX, self.ImgSymbDecalX = CanInWindow(
        'Media/FrmOscillo/SymbDecalX/', self.RatioImgOscillo, self.CanvasOscillo, int(SX * 0.259), int(SY * 0.186), 1)

        self.BtnDecalX, wsize, hsize, self.CanvasBtnDecalX, self.ImgBtnDecalX = CanInWindow(
            'Media/FrmOscillo/BtnDecalX/', self.RatioImgOscillo, self.CanvasOscillo, int(SX * 0.83), int(SY * 0.167), 0)
        self.CanvasBtnDecalX.bind('<MouseWheel>', self.MouseWheelDecalX)
        self.CanvasBtnDecalX.bind('<Button-1>', self.AnnulDecalX)
        self.ListEltInCanvasOscillo.append(self.CanvasBtnDecalX)

        self.BtnAutoScale, wsize, hsize, self.CanvasBtnAutoScale, self.ImgBtnAutoScale = CanInWindow(
        'Media/FrmOscillo/BtnAutoScale/', self.RatioImgOscillo, self.CanvasOscillo, int(SX * 0.649), int(SY * 0.146),0)
        self.CanvasBtnAutoScale.bind('<ButtonPress-1>',
                lambda action: self.CanvasBtnAutoScale.itemconfig(self.ImgBtnAutoScale,image=self.BtnAutoScale[1]))
        self.CanvasBtnAutoScale.bind('<ButtonRelease-1>', self.AutoScale)
        self.ListEltInCanvasOscillo.append(self.CanvasBtnAutoScale)

        PercentY=ConfigResolution(self.MainAppli.Nconfig, 'Y')
        self.BtnMenu, wsize, hsize, self.CanvasBtnMenu, self.ImgBtnMenu = ListCanInWindow(
            'Media/FrmOscillo/BtnMenu/', self.RatioImgOscillo, self.CanvasOscillo, int(SX * 0.605), 0,
            int(SY * 0.326), int(SY * PercentY), 5, 0)
        for i in range(5):
            def GestEvt5(evt, j=i):
                return self.ActionBtnMenu(evt, j)
            def GestEvt6(evt, k=i):
                return self.PressBtnMenu(evt, k)
            self.CanvasBtnMenu[i].bind('<ButtonRelease-1>', GestEvt5)
            self.CanvasBtnMenu[i].bind('<ButtonPress-1>', GestEvt6)

        self.BtnEntry, wsize, hsize, self.CanvasBtnEntry, self.ImgBtnEntry = CanInWindow(
            'Media/FrmOscillo/BtnEntry/', self.RatioImgOscillo, self.CanvasOscillo, int(SX * 0.663), int(SY * 0.316),0)
        self.CanvasBtnEntry.bind('<MouseWheel>', self.MouseWheelEntry)
        self.CanvasBtnEntry.bind('<ButtonPress-1>', self.PressEntry)
        self.CanvasBtnEntry.bind('<ButtonRelease-1>', self.ActionEntry)

        self.BtnMeas, wsize, hsize, self.CanvasBtnMeas, self.ImgBtnMeas = CanInWindow(
            'Media/FrmOscillo/BtnMeas/', self.RatioImgOscillo, self.CanvasOscillo,
            int(SX * 0.783), int(SY * 0.33),0)
        self.CanvasBtnMeas.bind('<ButtonPress-1>',
                                lambda action: self.CanvasBtnMeas.itemconfig(self.ImgBtnMeas,image=self.BtnMeas[1]))
        self.CanvasBtnMeas.bind('<ButtonRelease-1>', self.AffichMenuMeasure)
        self.ListEltInCanvasOscillo.append(self.CanvasBtnMeas)

        self.BtnBack, wsize, hsize, self.CanvasBtnBack, self.ImgBtnBack = CanInWindow(
            'Media/FrmOscillo/BtnBack/', self.RatioImgOscillo, self.CanvasOscillo,
            int(SX * 0.591), int(SY * 0.228), 0)
        self.CanvasBtnBack.bind('<ButtonPress-1>',
                                lambda action: self.CanvasBtnBack.itemconfig(self.ImgBtnBack, image=self.BtnBack[1]))
        self.CanvasBtnBack.bind('<ButtonRelease-1>', self.Back)
        self.ListEltInCanvasOscillo.append(self.CanvasBtnBack)

        self.BtnCursors, wsize, hsize, self.CanvasBtnCursors, self.ImgBtnCursors = CanInWindow(
            'Media/FrmOscillo/BtnCursors/', self.RatioImgOscillo, self.CanvasOscillo,
            int(SX * 0.838), int(SY * 0.33), 0)
        self.CanvasBtnCursors.bind('<ButtonPress-1>',
                        lambda action: self.CanvasBtnCursors.itemconfig(self.ImgBtnCursors, image=self.BtnCursors[1]))
        self.CanvasBtnCursors.bind('<ButtonRelease-1>', self.AffichMenuCursors)
        self.ListEltInCanvasOscillo.append(self.CanvasBtnCursors)

        self.BtnRegCursors, wsize, hsize, self.CanvasBtnRegCursors, self.ImgBtnRegCursors = CanInWindow(
            'Media/FrmOscillo/BtnRegCursors/', self.RatioImgOscillo, self.CanvasOscillo,
            int(SX * 0.905), int(SY * 0.319), 0)
        self.CanvasBtnRegCursors.bind('<ButtonPress-1>',
                lambda action: self.CanvasBtnRegCursors.itemconfig(self.ImgBtnRegCursors, image=self.BtnRegCursors[1]))
        self.CanvasBtnRegCursors.bind('<ButtonRelease-1>', self.ActionBtnRegCursors)
        self.CanvasBtnRegCursors.bind('<MouseWheel>', self.MouseWheelRegCursors)
        self.ListEltInCanvasOscillo.append(self.CanvasBtnRegCursors)

        self.CadreMeas, self.CMwsize, self.CMhsize, self.CanvasCadreMeas, self.ImgCadreMeas=CanInWindow(
            'Media/FrmOscillo/CadreMeas/', self.RatioImgOscillo, self.CanvasOscillo,
            int(SX * 0.060), int(SY * 0.698), 0)

        self.BtnTrigger, wsize, hsize, self.CanvasBtnTrigger, self.ImgBtnTrigger = CanInWindow(
            'Media/FrmOscillo/BtnTrigger/', self.RatioImgOscillo, self.CanvasOscillo,
            int(SX * 0.902), int(SY * 0.612), 0)
        self.CanvasBtnTrigger.bind('<ButtonPress-1>',
                        lambda action: self.CanvasBtnTrigger.itemconfig(self.ImgBtnTrigger,image=self.BtnTrigger[1]))
        self.CanvasBtnTrigger.bind('<ButtonRelease-1>', self.AffichMenuTrigger)
        self.ListEltInCanvasOscillo.append(self.CanvasBtnTrigger)

        self.CanvasOscillo.pack()

    ####################################################################################################################
    ########################################### AFFICHAGE ECRAN OSCILLO ################################################
    ####################################################################################################################

    def AffichEcranOscillo(self):
        self.CanvasEcranOscillo = CanvasApp(self.CanvasOscillo, width=int(self.SX * 0.4), height=int(self.SY * 0.478), bg='black')
        self.CanvasOscillo.create_window(int(self.SX * 0.063), int(self.SY * 0.216), anchor=tk.NW, window=self.CanvasEcranOscillo)

        mydpi = 96
        self.fig = Figure(figsize=(self.SX * 0.4042 / mydpi, self.SY * 0.4798 / mydpi), dpi=mydpi, facecolor='black')
        self.GraphOscillo = self.fig.add_subplot(111)
        self.GraphOscillo.patch.set_facecolor('black')
        self.graph = FigureCanvasTkAgg(self.fig, master=self.CanvasEcranOscillo)
        self.CanvasGraph = self.graph.get_tk_widget()

        self.GraphOscillo.set_xlim(-5, 5)
        self.GraphOscillo.set_ylim(-4, 4)

        xmajor_ticks = np.arange(-5, 5, 1)
        xminor_ticks = np.arange(-5, 5, 0.2)
        ymajor_ticks = np.arange(-4, 4, 1)
        yminor_ticks = np.arange(-4, 4, 0.2)

        self.GraphOscillo.set_xticks(xmajor_ticks)
        self.GraphOscillo.set_xticks(xminor_ticks, minor=True)
        self.GraphOscillo.set_xticklabels('')
        self.GraphOscillo.set_yticks(ymajor_ticks)
        self.GraphOscillo.set_yticks(yminor_ticks, minor=True)
        self.GraphOscillo.set_yticklabels('')

        self.GraphOscillo.spines['right'].set_color('none')
        self.GraphOscillo.spines['top'].set_color('none')
        self.GraphOscillo.xaxis.set_ticks_position('bottom')
        self.GraphOscillo.spines['bottom'].set_position(('data', 0))
        self.GraphOscillo.spines['bottom'].set_color('#ababab')
        self.GraphOscillo.yaxis.set_ticks_position('left')
        self.GraphOscillo.spines['left'].set_position(('data', 0))
        self.GraphOscillo.spines['left'].set_color('#ababab')

        self.GraphOscillo.tick_params(axis='x', colors='#ababab')
        self.GraphOscillo.tick_params(axis='y', colors='#ababab')

        self.GraphOscillo.grid(which='minor', alpha=0.5, linestyle=':', linewidth=0.5, color="#ababab")
        self.GraphOscillo.grid(which='major', alpha=0.5, linewidth=0.6, color="#ababab")

        if self.MainAppli.FrmMain.swidth > 1366:
            self.fig.tight_layout(rect=[-0.048, -0.065, 1.040, 1.070])
        else:
            self.fig.tight_layout(rect=[-0.055, -0.09, 1.055, 1.085])

        self.lineSignalVoie1, = self.GraphOscillo.plot([], [], color='yellow')
        self.lineSignalVoie2, = self.GraphOscillo.plot([], [], color='green')
        self.SymbX0, = self.GraphOscillo.plot([], [], 'w^')
        self.CursorY1,= self.GraphOscillo.plot([], [], color='orange',linestyle=':', linewidth=1)
        self.CursorY2, = self.GraphOscillo.plot([], [], color='orange', linestyle=':', linewidth=1)
        self.CursorX1, = self.GraphOscillo.plot([], [], color='orange', linestyle=':', linewidth=1)
        self.CursorX2, = self.GraphOscillo.plot([], [], color='orange', linestyle=':', linewidth=1)


    ####################################################################################################################
    ############################################### AFFICHAGE MENUS ####################################################
    ####################################################################################################################

    def AffichMenuChannels(self):
        self.ImgMenu = self.CanvasMenu.create_image(0, 0, anchor=tk.NW, image=self.Menu[0])
        self.MenuSelect = 'Channels'

        self.TitreMenu, wsize, hsize, self.CanvasTitreMenu, self.ImgTitreMenu = CanInWindow(
            'Media/FrmOscillo/TitreMenu/', self.RatioImgOscillo, self.CanvasMenu,
            int(self.Menuwsize * 0.010), int(self.Menuhsize * 0.102),0)

        self.MenuCoupling, wsize, hsize, self.CanvasMenuCoupling, self.ImgMenuCoupling = ListCanInWindow(
            'Media/FrmOscillo/Coupling/Fond/', self.RatioImgOscillo, self.CanvasMenu,
            int(self.Menuwsize * 0.48), 0 , int(self.Menuhsize * 0.38), int(self.Menuhsize * 0.29), 2, 1)
        for i in range(2):
            if self.OnVoie[i] == True:
                self.CanvasMenuCoupling[i].itemconfig(self.ImgMenuCoupling[i], image=self.MenuCoupling[0])
            else:
                self.CanvasMenuCoupling[i].itemconfig(self.ImgMenuCoupling[i], image=self.MenuCoupling[1])

        self.TypeCoupling, wsize, hsize, self.CanvasTypeCoupling, self.ImgTypeCoupling = ListCanInWindow(
            'Media/FrmOscillo/Coupling/Type/', self.RatioImgOscillo, self.CanvasMenu,
            int(self.Menuwsize * 0.5), 0, int(self.Menuhsize * 0.4), int(self.Menuhsize * 0.29), 2, 2)
        for i in range(2):
            if self.OnVoie[i] == True:
                self.CanvasTypeCoupling[i].itemconfig(self.ImgTypeCoupling[i], image=self.TypeCoupling[self.SignalTypeCoupling[i]])
            else:
                self.CanvasTypeCoupling[i].itemconfig(self.ImgTypeCoupling[i], image=self.TypeCoupling[2])

        self.SymbChangeTypeCoupling, wsize, hsize, self.CanvasSymbChangeTypeCoupling, self.ImgSymbChangeTypeCoupling = ListCanInWindow(
            'Media/FrmOscillo/Coupling/IcoChgt/', self.RatioImgOscillo, self.CanvasMenu,
            int(self.Menuwsize * 0.18), 0 , int(self.Menuhsize * 0.363), int(self.Menuhsize * 0.29), 2, 2)
        for i in range(2):
            if self.OnVoie[i] == True:
                self.CanvasSymbChangeTypeCoupling[i].itemconfig(self.ImgSymbChangeTypeCoupling[i],
                                                                image=self.SymbChangeTypeCoupling[1])
            else:
                self.CanvasSymbChangeTypeCoupling[i].itemconfig(self.ImgSymbChangeTypeCoupling[i],
                                                                    image=self.SymbChangeTypeCoupling[2])

        self.TitreChannel = []
        for i in range(2):
            self.TitreChannel.append(LabelText(self.CanvasMenu, '', 'black', font=self.MyFont2))
            self.CanvasMenu.create_window(int(self.Menuwsize * 0.18), int((self.Menuhsize * 0.165) + i * (self.Menuhsize * 0.29)),
                                          anchor=tk.NW, window=self.TitreChannel[i])
            if self.OnVoie[i] == True:
                self.TitreChannel[i].config(text=self.ChannelStr[i], bg=self.ColorVoie[2], fg=self.ColorVoie[i])
            else:
                self.TitreChannel[i].config(text=self.ChannelStr[i], bg=self.ColorVoie[2], fg=self.ColorVoie[2])

        self.ValDecalVoie = []
        for i in range(2):
            self.Y0VoieStr.append(tk.StringVar())
            self.ValDecalVoie.append(LabelVar(self.CanvasMenu, self.Y0VoieStr[i], 'black', font=self.MyFont2))
            self.CanvasMenu.create_window(int(self.Menuwsize * 0.365), int((self.Menuhsize * 0.235) + i * (self.Menuhsize * 0.293)),
                                          anchor=tk.NW, window=self.ValDecalVoie[i])
            if self.OnVoie[i] == True:
                self.ValDecalVoie[i].config(bg=self.ColorVoie[2], fg=self.ColorVoie[i])
            else:
                self.ValDecalVoie[i].config(bg=self.ColorVoie[2], fg=self.ColorVoie[2])
            self.AffichY0Voie(i)

        self.SymbDecalVoie, wsize, hsize, self.CanvasSymbDecalVoie, self.ImgSymbDecalVoie = ListCanInWindow(
            'Media/FrmOscillo/SymbDecalVoie/', self.RatioImgOscillo, self.CanvasMenu, int(self.Menuwsize * 0.18), 0,
            int(self.Menuhsize * 0.268), int(self.Menuhsize * 0.295), 2,2)
        for i in range(2):
            if self.OnVoie[i] == True:
                self.CanvasSymbDecalVoie[i].itemconfig(self.ImgSymbDecalVoie[i], image=self.SymbDecalVoie[i])
            else:
                self.CanvasSymbDecalVoie[i].itemconfig(self.ImgSymbDecalVoie[i], image=self.SymbDecalVoie[2])

        if self.OnVoie[0] == True: ChangeCursor(self.CanvasBtnMenu[1])
        if self.OnVoie[1] == True: ChangeCursor(self.CanvasBtnMenu[3])

        self.ConfigDate()


    def AffichMenuMeasure(self,evt):
        self.CanvasBtnMeas.itemconfig(self.ImgBtnMeas, image=self.BtnMeas[0])

        if self.OnOscillo == True:
            self.CacheMenu()
            self.ImgMenu = self.CanvasMenu.create_image(0, 0, anchor=tk.NW, image=self.Menu[0])

            self.EffaceCadreMeas()
            self.ImgCadreMeas = self.CanvasCadreMeas.create_image(0, 0, anchor=tk.NW, image=self.CadreMeas[0])
            if self.MenuSelect == 'Cursors': self.EffaceCurseurs()

            self.AddMeas, self.AMwsize, self.AMhsize, self.CanvasAddMeas, self.ImgAddMeas = ListCanInWindow(
                'Media/FrmOscillo/Measure/Val/', self.RatioImgOscillo, self.CanvasCadreMeas,
                int(self.CMwsize * 0.135), int(self.CMwsize * 0.247), int(self.CMhsize * 0.5), 0, 4, 0)
            self.LabelValMeas = []
            self.LabelTypeMeas = []
            self.NbrMeas=0

            self.MenuSelect = 'Measurement'
            self.ActionMenu = ''
            self.VoieSourceMeas = 0
            self.TypeMeas = 0

            self.TitreMenu, wsize, hsize, self.CanvasTitreMenu, self.ImgTitreMenu = CanInWindow(
                'Media/FrmOscillo/TitreMenu/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.010), int(self.Menuhsize * 0.102), 1)

            self.MenuSource, MSwsize, MShsize, self.CanvasMenuSource, self.ImgMenuSource = CanInWindow(
                'Media/FrmOscillo/Measure/Source/Fond/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.07),int(self.Menuhsize * 0.185), 0)
            self.NvoieSource, wsize, hsize, self.CanvasNvoieSource, self.ImgNvoieSource = CanInWindow(
                'Media/FrmOscillo/Measure/Source/Nvoie/', self.RatioImgOscillo, self.CanvasMenuSource,
                int(MSwsize * 0.46), int(MShsize * 0.55), 0)
            self.ChangeNvoieSource, wsize, hsize, self.CanvasChangeNvoieSource, self.ImgChangeNvoieSource = CanInWindow(
                'Media/FrmOscillo/Measure/IcoChgt/', self.RatioImgOscillo, self.CanvasMenuSource,
                int(MSwsize * 0.1), int(MShsize * 0.135), 1)

            self.MenuType, MTwsize, MThsize, self.CanvasMenuType, self.ImgMenuType = CanInWindow(
                'Media/FrmOscillo/Measure/Type/Fond/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.07), int(self.Menuhsize * 0.33), 0)
            self.MeasType, wsize, hsize, self.CanvasMeasType, self.ImgMeasType = CanInWindow(
                'Media/FrmOscillo/Measure/Type/Meas/', self.RatioImgOscillo, self.CanvasMenuType, int(MTwsize * 0.36)
                , int(MTwsize * 0.2), 0)
            self.ChangeMeasType, wsize, hsize, self.CanvasChangeMeasType, self.ImgChangeMeasType = CanInWindow(
                'Media/FrmOscillo/Measure/IcoChgt/', self.RatioImgOscillo, self.CanvasMenuType,
                int(MSwsize * 0.1), int(MShsize * 0.135), 1)

            self.MenuAdd, MAwsize, MAhsize, self.CanvasMenuAdd, self.ImgMenuAdd = CanInWindow(
                'Media/FrmOscillo/Measure/Add/Fond/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.07), int(self.Menuhsize * 0.475), 0)

            self.MenuClear, MCwsize, MChsize, self.CanvasMenuClear, self.ImgMenuClear = CanInWindow(
                'Media/FrmOscillo/Measure/Clear/Fond/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.07), int(self.Menuhsize * 0.62), 0)

            for i in range(4): ChangeCursor(self.CanvasBtnMenu[i])

            if self.ClearMeasFait == False:

                for i in range (2):
                    self.VSMeas[i] = 0
                    self.TMeas[i] = i + i * 2
                    self.AffichLabelMeas(i, self.VSMeas[i],self.TMeas[i])
                    self.AffichValMeas(i, self.VSMeas[i], self.TMeas[i])
                    self.NbrMeas += 1

            self.ConfigDate()

    def AffichMenuClearMeasure(self):
        self.CacheMenu()
        self.ImgMenu = self.CanvasMenu.create_image(0, 0, anchor=tk.NW, image=self.Menu[0])
        self.MenuSelect = 'ClearMeasure'
        self.ClearMeasFait = True
        for i in range(5):
            self.CanvasBtnMenu[i].bind('<Enter>', lambda action: self.CanvasBtnMenu[i].configure(cursor=''))

        self.TitreMenu, wsize, hsize, self.CanvasTitreMenu, self.ImgTitreMenu = CanInWindow(
            'Media/FrmOscillo/TitreMenu/', self.RatioImgOscillo, self.CanvasMenu,
            int(self.Menuwsize * 0.010), int(self.Menuhsize * 0.102), 1)

        self.ClearMeas, wsize, hsize, self.CanvasClearMeas, self.ImgClearMeas = ListCanInWindow(
            'Media/FrmOscillo/Measure/Clear/ClearMeas/', self.RatioImgOscillo, self.CanvasMenu, int(self.Menuwsize * 0.5), 0,
            int(self.Menuhsize * 0.235), int(self.Menuhsize * 0.146), 5, 0)

        if self.NbrMeas>0:
            for i in range(self.NbrMeas):
                self.CanvasClearMeas[i].itemconfig(self.ImgClearMeas[i], image=self.ClearMeas[i+1])
                ChangeCursor(self.CanvasBtnMenu[i])

        self.CanvasClearMeas[4].itemconfig(self.ImgClearMeas[4], image=self.ClearMeas[5])
        ChangeCursor(self.CanvasBtnMenu[4])

        self.ConfigDate()

    def AffichMenuCursors(self,evt):
        self.CanvasBtnCursors.itemconfig(self.ImgBtnCursors, image=self.BtnCursors[0])
        self.CanvasBtnRegCursors.itemconfig(self.ImgBtnRegCursors, image=self.BtnRegCursors[0])
        if self.OnOscillo == True:
            self.CacheMenu()
            self.ImgMenu = self.CanvasMenu.create_image(0, 0, anchor=tk.NW, image=self.Menu[0])

            self.EffaceCadreMeas()
            self.ImgCadreMeas = self.CanvasCadreMeas.create_image(0, 0, anchor=tk.NW, image=self.CadreMeas[0])

            self.AddMeas, self.AMwsize, self.AMhsize, self.CanvasAddMeas, self.ImgAddMeas = ListCanInWindow(
                'Media/FrmOscillo/Measure/Val/', self.RatioImgOscillo, self.CanvasCadreMeas,
                int(self.CMwsize * 0.135), int(self.CMwsize * 0.247), int(self.CMhsize * 0.5), 0, 4, 0)
            self.LabelValMeas = []
            self.LabelTypeMeas = []

            self.MenuSelect = 'Cursors'
            self.ActionMenu = ''
            self.VoieSourceMeas = 0
            self.TypeMeas = 0

            self.TitreMenu, wsize, hsize, self.CanvasTitreMenu, self.ImgTitreMenu = CanInWindow(
                'Media/FrmOscillo/TitreMenu/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.010), int(self.Menuhsize * 0.102), 2)

            self.MenuSource, MSwsize, MShsize, self.CanvasMenuSource, self.ImgMenuSource = CanInWindow(
                'Media/FrmOscillo/Cursors/Source/Fond/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.07), int(self.Menuhsize * 0.185), 0)
            self.NvoieSource, wsize, hsize, self.CanvasNvoieSource, self.ImgNvoieSource = CanInWindow(
                'Media/FrmOscillo/Cursors/Source/Nvoie/', self.RatioImgOscillo, self.CanvasMenuSource,
                int(MSwsize * 0.46), int(MShsize * 0.55), 0)
            self.ChangeNvoieSource, wsize, hsize, self.CanvasChangeNvoieSource, self.ImgChangeNvoieSource = CanInWindow(
                'Media/FrmOscillo/Cursors/IcoChgt/', self.RatioImgOscillo, self.CanvasMenuSource,
                int(MSwsize * 0.1), int(MShsize * 0.135), 1)

            self.MenuType, MTwsize, MThsize, self.CanvasMenuType, self.ImgMenuType = CanInWindow(
                'Media/FrmOscillo/Cursors/Type/Fond/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.07), int(self.Menuhsize * 0.33), 0)
            self.MeasType, wsize, hsize, self.CanvasMeasType, self.ImgMeasType = CanInWindow(
                'Media/FrmOscillo/Cursors/Type/XY/', self.RatioImgOscillo, self.CanvasMenuType, int(MTwsize * 0.33)
                , int(MTwsize * 0.2), 0)
            self.ChangeMeasType, wsize, hsize, self.CanvasChangeMeasType, self.ImgChangeMeasType = CanInWindow(
                'Media/FrmOscillo/Cursors/IcoChgt/', self.RatioImgOscillo, self.CanvasMenuType,
                int(MSwsize * 0.1), int(MShsize * 0.135), 1)

            for N in range(4):
                self.CanvasAddMeas[N].itemconfig(self.ImgAddMeas[N], image=self.AddMeas[1])

                self.LabelValMeas.append(LabelVar(self.CanvasAddMeas[N], self.StrValMeas[N], 'black', font=self.MyFont, fg='white'))
                self.CanvasAddMeas[N].create_window(int(self.AMwsize * 0.4), int(self.AMhsize * 0.1), anchor=tk.NW,
                                                window=self.LabelValMeas[N])

                self.LabelTypeMeas.append(LabelVar(self.CanvasAddMeas[N], self.StrTypeMeas[N], 'black', font=self.MyFont, fg='white'))
                self.CanvasAddMeas[N].create_window(int(self.AMwsize * 0.1), int(self.AMhsize * 0.1), anchor=tk.NW,
                                                window=self.LabelTypeMeas[N])

            self.MenuDelta, MDwsize, MDhsize, self.CanvasMenuDelta, self.ImgMenuDelta = CanInWindow(
                'Media/FrmOscillo/Cursors/Delta/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.07), int(self.Menuhsize * 0.47), 0)

            self.LabelDelta = []
            self.LabelValDelta =[]
            self.StrValDelta = []
            for i in range(3):
                self.LabelDelta.append(LabelText(self.CanvasMenuDelta, '', 'black', font=self.MyFont, fg='white'))
                self.CanvasMenuDelta.create_window(int(MDwsize * 0.1), int((MDhsize * 0.033) + i * (MDhsize * 0.325)), anchor=tk.NW,
                                                    window=self.LabelDelta[i])
                self.StrValDelta.append(tk.StringVar())
                self.LabelValDelta.append(LabelVar(self.CanvasMenuDelta, self.StrValDelta[i], 'black', font=self.MyFont, fg='white'))
                self.CanvasMenuDelta.create_window(int(MDwsize * 0.3), int((MDhsize * 0.159) + i * (MDhsize * 0.325)), anchor=tk.NW,
                                               window=self.LabelValDelta[i])

            self.LabelDelta[0].configure(text = chr(916)+'X :')
            self.LabelDelta[1].configure(text='1/'+chr(916) + 'X :')
            self.LabelDelta[2].configure(text=chr(916) + 'Y :')


            for i in range(2): ChangeCursor(self.CanvasBtnMenu[i])

            self.X1= self.CalX
            self.X2 = - self.CalX
            self.Y1 = self.CalY[0]
            self.Y2 = - self.CalY[0]
            self.ComptDecalCursorX1 = 20
            self.ComptDecalCursorX2 = -20
            self.ComptDecalCursorY1 = 20
            self.ComptDecalCursorY2 = -20

            for i in range (1,3):
                self.AffichCursorsX(i)
                self.AffichCursorsY(i,0)

            self.StrTypeMeas[0].set('X1:')
            self.StrTypeMeas[1].set('X2:')
            self.StrTypeMeas[2].set('Y1:')
            self.StrTypeMeas[3].set('Y2:')

            for i in range(3): self.CalculDelta(i)

            self.ConfigDate()

    def AffichMenuTrigger(self,evt):
        self.CanvasBtnTrigger.itemconfig(self.ImgBtnTrigger, image=self.BtnTrigger[0])
        if self.OnOscillo == True:
            self.CacheMenu()
            self.ImgMenu = self.CanvasMenu.create_image(0, 0, anchor=tk.NW, image=self.Menu[0])
            if self.MenuSelect == 'Cursors':
                self.EffaceCurseurs()
                self.EffaceCadreMeas()
                self.ImgCadreMeas = self.CanvasCadreMeas.create_image(0, 0, anchor=tk.NW, image=self.CadreMeas[0])
            self.MenuSelect = 'Trigger'
            self.ActionMenu = ''
            self.VoieSourceTrigg = 0

            self.TitreMenu, wsize, hsize, self.CanvasTitreMenu, self.ImgTitreMenu = CanInWindow(
                'Media/FrmOscillo/TitreMenu/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.010), int(self.Menuhsize * 0.102), 3)

            self.MenuSource, MSwsize, MShsize, self.CanvasMenuSource, self.ImgMenuSource = CanInWindow(
                'Media/FrmOscillo/Trigger/Source/Fond/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.07), int(self.Menuhsize * 0.185), 0)
            self.NvoieSource, wsize, hsize, self.CanvasNvoieSource, self.ImgNvoieSource = CanInWindow(
                'Media/FrmOscillo/Trigger/Source/Nvoie/', self.RatioImgOscillo, self.CanvasMenuSource,
                int(MSwsize * 0.46), int(MShsize * 0.55), 0)
            self.ChangeNvoieSource, wsize, hsize, self.CanvasChangeNvoieSource, self.ImgChangeNvoieSource = CanInWindow(
                'Media/FrmOscillo/Trigger/IcoChgt/', self.RatioImgOscillo, self.CanvasMenuSource,
                int(MSwsize * 0.1), int(MShsize * 0.135), 1)

            self.MenuSlope, MTwsize, MThsize, self.CanvasMenuSlope, self.ImgMenuSlope = CanInWindow(
                'Media/FrmOscillo/Trigger/Slope/Fond/', self.RatioImgOscillo, self.CanvasMenu,
                int(self.Menuwsize * 0.07), int(self.Menuhsize * 0.33), 0)
            self.SlopeType, wsize, hsize, self.CanvasSlopeType, self.ImgSlopeType = CanInWindow(
                'Media/FrmOscillo/Trigger/Slope/Front/', self.RatioImgOscillo, self.CanvasMenuSlope, int(MTwsize * 0.48)
                , int(MTwsize * 0.2), 0)
            self.ChangeSlopeType, wsize, hsize, self.CanvasChangeSlopeType, self.ImgChangeSlopeType = CanInWindow(
                'Media/FrmOscillo/Trigger/IcoChgt/', self.RatioImgOscillo, self.CanvasMenuSlope,
                int(MSwsize * 0.1), int(MShsize * 0.135), 1)

            for i in range(2): ChangeCursor(self.CanvasBtnMenu[i])

            self.ConfigDate()

    def AfficheDate(self):
        date = time.strftime('%d/%m/%y' +'\n' +'%H:%M:%S', time.localtime())
        self.labelDate.configure(text=date, fg='white')

    def ConfigDate(self):
        self.labelDate = LabelText(self.CanvasMenu, '', '#181816', font=self.MyFont)
        self.CanvasMenu.create_window(int(self.Menuwsize * 0.23), int(self.Menuhsize * 0.865), anchor=tk.NW,
                                      window=self.labelDate)
        self.TimerDate = MyTimer(1.0, self.AfficheDate)
        self.TimerDate.start()

    ####################################################################################################################
    ############################################### NAVIGATION MENUS ####################################################
    ####################################################################################################################

    def CacheMenu (self):
        self.TimerDate.stop()
        for elt in self.CanvasMenu.find_all():
            self.CanvasMenu.delete(elt)
        for i in range(5):
            self.CanvasBtnMenu[i].bind('<Enter>', lambda action: self.CanvasBtnEntry.configure(cursor=''))

    def Back(self,evt):
        self.CanvasBtnBack.itemconfig(self.ImgBtnMeas, image=self.BtnBack[0])
        if self.MenuSelect != 'Channels':
            if self.ActionMenu=='':
                self.CacheMenu()
                if self.MenuSelect == 'Cursors':
                    self.EffaceCurseurs()
                    self.EffaceCadreMeas()
                    self.ImgCadreMeas = self.CanvasCadreMeas.create_image(0, 0, anchor=tk.NW, image=self.CadreMeas[0])
                self.AffichMenuChannels()
            else:
                if self.MenuSelect == 'Measurement' or self.MenuSelect == 'Cursors':
                    if self.ActionMenu == 'ChangeSourceMeas':
                        self.CanvasChangeNvoieSource.itemconfig(self.ImgChangeNvoieSource,
                                                                image=self.ChangeNvoieSource[1])
                        self.ActionMenu = ''
                        self.VoieSourceMeas=self.VoieSourceMeasOld
                        self.CanvasNvoieSource.itemconfig(self.ImgNvoieSource,
                                                          image=self.NvoieSource[self.VoieSourceMeas])
                        ChangeCursor(self.CanvasBtnMenu[0])
                    if self.ActionMenu == 'SelectTypeMeas':
                        if self.MenuSelect == 'Measurement': self.CanvasMenuSelectType.destroy()
                        self.CanvasChangeMeasType.itemconfig(self.ImgChangeMeasType, image=self.ChangeMeasType[1])
                        self.ActionMenu = ''
                        self.TypeMeas=self.TypeMeasOld
                        self.CanvasMeasType.itemconfig(self.ImgMeasType, image=self.MeasType[self.TypeMeas])
                        ChangeCursor(self.CanvasBtnMenu[1])
                    self.CanvasBtnEntry.bind('<Enter>', lambda action: self.CanvasBtnEntry.configure(cursor=''))
                else:
                    if self.MenuSelect == 'ClearMeasure':
                        self.CacheMenu()
                        self.AffichMenuMeasure(evt)
        else:
            if  self.ActionMenu!='':
                self.CanvasSymbChangeTypeCoupling[self.VoieActionMenu].itemconfig(
                    self.ImgSymbChangeTypeCoupling[self.VoieActionMenu],image=self.SymbChangeTypeCoupling[1])
                self.ActionMenu = ''
                if self.VoieActionMenu==0:
                    ChangeCursor(self.CanvasBtnMenu[1])
                else:
                    ChangeCursor(self.CanvasBtnMenu[3])
                self.CanvasBtnEntry.bind('<Enter>', lambda action: self.CanvasBtnEntry.configure(cursor=''))
                self.SignalTypeCoupling[self.VoieActionMenu] = self.SignalTypeCouplingOld
                self.CanvasTypeCoupling[self.VoieActionMenu].itemconfig(self.ImgTypeCoupling[self.VoieActionMenu],
                                            image=self.TypeCoupling[self.SignalTypeCoupling[self.VoieActionMenu]])
                self.AffichSignalVoie(self.AmplVoie[self.VoieActionMenu], self.FreqVoie[self.VoieActionMenu],
                        self.Offset[self.VoieActionMenu], self.CalX, self.CalY[self.VoieActionMenu],self.VoieActionMenu)


    ####################################################################################################################
    ######################################### ALLUMAGE - EXTINCTION OSCILLO ############################################
    ####################################################################################################################

    def OnOffOscillo(self, evt):
        if self.OnOscillo == False:
            self.CanvasOscillo.itemconfig(self.ImgCanvasOscillo, image=self.ImgFrameOscillo[0])
            self.CanvasBtnOscilloOnOff.itemconfig(self.ImgBtnOscilloOnOff, image=self.BtnOscilloOnOff[1])
            self.AllumeOscillo()
        else:
            self.CanvasOscillo.itemconfig(self.ImgCanvasOscillo, image=self.ImgFrameOscillo[1])
            self.CanvasBtnOscilloOnOff.itemconfig(self.ImgBtnOscilloOnOff, image=self.BtnOscilloOnOff[0])
            self.EteintOscillo()


    def AllumeOscillo(self):
        self.OnOscillo = True
        self.OnVoie[0] = True
        self.OnVoie[1] = False
        self.NbrMeas = 0
        self.ClearMeasFait = False

        self.AffichEcranOscillo()

        for i in range(2):
            self.ComptValCal[i]=10
            self.CalY[i] = self.ValCal[self.ComptValCal[i]]
            self.Y0Voie[i]=0.0
            self.ComptDecalVoie[i] = 0
            self.SignalTypeCoupling[i] = 1
            self.CanvasBtnOscilloVoie[i].itemconfig(self.ImgBtnOscilloVoie[i], image=self.BtnOscilloVoie[i+1])
            self.LabelSymbVoie[i].config(text=self.SymbVoieStr[i],fg=self.ColorVoie[i*3])
            self.ValCalVoie[i].config(fg=self.ColorVoie[i * 3])
            self.AffichCalVoie(i)

        self.AffichMenuChannels()

        self.ComptValCalX=25
        self.CalX = self.ValCalX[self.ComptValCalX]
        self.LabelValCalX.config(fg='white')
        self.X0=0
        self.AffichX0()
        self.AffichCalX()
        self.CanvasSymbDecalX.itemconfig(self.ImgSymbDecalX, image=self.SymbDecalX[0])
        self.ValDecalX.config(fg='white')

        for elt in self.ListEltInCanvasOscillo:
            ChangeCursor(elt)

        self.MainAppli.MAJSignal()
        self.CanvasGraph.pack()


    def EteintOscillo(self):
        self.OnOscillo = False
        self.CacheMenu()
        self.CanvasGraph.pack_forget()
        for i in range(2):
            self.OnVoie[i] = False
            self.CanvasBtnOscilloVoie[i].itemconfig(self.ImgBtnOscilloVoie[i], image=self.BtnOscilloVoie[i*2])
            self.LabelSymbVoie[i].config(fg=self.ColorVoie[3])
            self.ValCalVoie[i].config(fg=self.ColorVoie[3])
        self.labelDate.configure(text='', bg='black')
        self.LabelValCalX.config(fg='black')
        self.CanvasSymbDecalX.itemconfig(self.ImgSymbDecalX, image=self.SymbDecalX[1])
        self.ValDecalX.config(fg='black')

        for elt in self.ListEltInCanvasOscillo:
            elt.bind('<Enter>',lambda action: elt.configure(cursor=''))

        self.EffaceCadreMeas()
        self.ImgCadreMeas = self.CanvasCadreMeas.create_image(0, 0, anchor=tk.NW, image=self.CadreMeas[0])


    ####################################################################################################################
    ############################################### GESTION DES VOIES ##################################################
    ####################################################################################################################

    def OnOffVoie(self, evt, Nvoie):
        if self.OnOscillo == True:
            if self.OnVoie[Nvoie] == False:
                self.OnVoie[Nvoie] = True
                self.Y0Voie[Nvoie] = 0.0
                self.SignalTypeCoupling[Nvoie] = 1
                self.TitreChannel[Nvoie].config(text=self.ChannelStr[Nvoie], bg=self.ColorVoie[2], fg=self.ColorVoie[Nvoie])
                self.ValDecalVoie[Nvoie].config(bg=self.ColorVoie[2], fg=self.ColorVoie[Nvoie])
                self.CanvasMenuCoupling[Nvoie].itemconfig(self.ImgMenuCoupling[Nvoie], image=self.MenuCoupling[0])
                self.CanvasTypeCoupling[Nvoie].itemconfig(self.ImgTypeCoupling[Nvoie], image=self.TypeCoupling[1])
                self.CanvasSymbChangeTypeCoupling[Nvoie].itemconfig(self.ImgSymbChangeTypeCoupling[Nvoie], image=self.SymbChangeTypeCoupling[1])
                self.CanvasSymbDecalVoie[Nvoie].itemconfig(self.ImgSymbDecalVoie[Nvoie], image=self.SymbDecalVoie[Nvoie])
                self.CanvasBtnOscilloVoie[Nvoie].itemconfig(self.ImgBtnOscilloVoie[Nvoie], image=self.BtnOscilloVoie[1+Nvoie*2])
                self.LabelSymbVoie[Nvoie].config(text=self.SymbVoieStr[Nvoie], fg=self.ColorVoie[Nvoie])
                self.ValCalVoie[Nvoie].config(fg=self.ColorVoie[Nvoie])
                self.CanvasBtnMenu[Nvoie*2+1].bind('<Enter>', lambda action: self.CanvasBtnMenu[Nvoie*2+1].configure(cursor='hand2'))
                self.MainAppli.MAJSignal()
                self.MAJMeas()

            else:
                self.OnVoie[Nvoie] = False
                self.ActionMenu = ''
                self.CanvasBtnOscilloVoie[Nvoie].itemconfig(self.ImgBtnOscilloVoie[Nvoie], image=self.BtnOscilloVoie[0+Nvoie*2])
                self.TitreChannel[Nvoie].config(text=self.ChannelStr[Nvoie], bg=self.ColorVoie[2], fg=self.ColorVoie[2])
                self.ValDecalVoie[Nvoie].config(bg=self.ColorVoie[2], fg=self.ColorVoie[2])
                self.CanvasSymbDecalVoie[Nvoie].itemconfig(self.ImgSymbDecalVoie[Nvoie],image=self.SymbDecalVoie[2])
                self.CanvasMenuCoupling[Nvoie].itemconfig(self.ImgMenuCoupling[Nvoie], image=self.MenuCoupling[1])
                self.CanvasTypeCoupling[Nvoie].itemconfig(self.ImgTypeCoupling[Nvoie], image=self.TypeCoupling[2])
                self.CanvasSymbChangeTypeCoupling[Nvoie].itemconfig(self.ImgSymbChangeTypeCoupling[Nvoie],
                                                                    image=self.SymbChangeTypeCoupling[2])
                self.LabelSymbVoie[Nvoie].config(text=self.SymbVoieStr[Nvoie], fg=self.ColorVoie[3])
                self.ValCalVoie[Nvoie].config(fg=self.ColorVoie[3])
                self.CanvasBtnMenu[Nvoie*2+1].bind('<Enter>', lambda action: self.CanvasBtnMenu[Nvoie*2+1].configure(cursor=''))
                self.CanvasBtnEntry.bind('<Enter>', lambda action: self.CanvasBtnEntry.configure(cursor=''))
                if Nvoie == 0:
                    self.lineSignalVoie1.set_data(0, 0)
                else:
                    self.lineSignalVoie2.set_data(0, 0)
                self.graph.draw()
                self.MAJMeas()

    ####################################################################################################################
    ######################################### GESTION DES CALIBRES DES VOIES ###########################################
    ####################################################################################################################

    def DecalVoie(self, evt, Nvoie,i):
        self.ComptDecalVoie[Nvoie] = self.ComptDecalVoie[Nvoie]+i
        self.Y0Voie[Nvoie]=self.Y0Voie[Nvoie]+i*0.1*self.CalY[Nvoie]
        self.AffichY0Voie(Nvoie)
        self.AffichSignalVoie(self.AmplVoie[Nvoie], self.FreqVoie[Nvoie], self.Offset[Nvoie], self.CalX, self.CalY[Nvoie], Nvoie)

    def DecalVoieAnnul(self, evt, Nvoie):
        if self.OnOscillo == True:
            self.Y0Voie[Nvoie] = 0.0
            self.ComptDecalVoie[Nvoie]=0
            self.AffichY0Voie(Nvoie)
            self.AffichSignalVoie(self.AmplVoie[Nvoie], self.FreqVoie[Nvoie], self.Offset[Nvoie], self.CalX, self.CalY[Nvoie], Nvoie)

    def ChangeCalVoiePlus(self, evt, Nvoie):
        if self.ComptValCal[Nvoie]<13:
            self.ComptValCal[Nvoie]=self.ComptValCal[Nvoie]+1
            self.CalY[Nvoie] = self.ValCal[self.ComptValCal[Nvoie]]
            self.Y0Voie[Nvoie]=self.CalY[Nvoie]*self.ComptDecalVoie[Nvoie]*0.1
            self.AffichY0Voie(Nvoie)
            self.AffichCalVoie(Nvoie)
            if self.MenuSelect == 'Cursors':
                self.Y1 = self.CalY[self.VoieSourceMeas] * self.ComptDecalCursorY1 * 0.05
                self.Y2 = self.CalY[self.VoieSourceMeas] * self.ComptDecalCursorY2 * 0.05
                self.AffichValCurseursY(2, self.Y1, self.VoieSourceMeas)
                self.AffichValCurseursY(3, self.Y2, self.VoieSourceMeas)
            self.AffichSignalVoie(self.AmplVoie[Nvoie], self.FreqVoie[Nvoie], self.Offset[Nvoie], self.CalX, self.CalY[Nvoie], Nvoie)

    def ChangeCalVoieMoins(self, evt, Nvoie):
        if self.ComptValCal[Nvoie]>0:
            self.ComptValCal[Nvoie]=self.ComptValCal[Nvoie] -1
            self.CalY[Nvoie] = self.ValCal[self.ComptValCal[Nvoie]]
            self.Y0Voie[Nvoie] = self.CalY[Nvoie] * self.ComptDecalVoie[Nvoie]*0.1
            self.AffichY0Voie(Nvoie)
            self.AffichCalVoie(Nvoie)
            if self.MenuSelect == 'Cursors':
                self.Y1 = self.CalY[self.VoieSourceMeas] * self.ComptDecalCursorY1 * 0.05
                self.Y2 = self.CalY[self.VoieSourceMeas] * self.ComptDecalCursorY2 * 0.05
                self.AffichValCurseursY(2, self.Y1, self.VoieSourceMeas)
                self.AffichValCurseursY(3, self.Y2, self.VoieSourceMeas)
            self.AffichSignalVoie(self.AmplVoie[Nvoie], self.FreqVoie[Nvoie], self.Offset[Nvoie], self.CalX, self.CalY[Nvoie], Nvoie)

    def AffichY0Voie(self,Nvoie):
        if self.CalY[Nvoie]<0.01:
            self.Y0VoieStr[Nvoie].set(str(round(self.Y0Voie[Nvoie] * 1000, 2)) + ' mV')
        else:
            if self.Y0Voie[Nvoie] > 0:
                if self.Y0Voie[Nvoie]<0.99:
                    self.Y0VoieStr[Nvoie].set(str(int(round(self.Y0Voie[Nvoie]*1000,1))) + ' mV')
                else:
                    self.Y0VoieStr[Nvoie].set(str(round(self.Y0Voie[Nvoie], 1)) + ' V')
            else:
                if self.Y0Voie[Nvoie]>-0.99:
                    self.Y0VoieStr[Nvoie].set(str(int(round(self.Y0Voie[Nvoie]*1000,1))) + ' mV')
                else:
                    self.Y0VoieStr[Nvoie].set(str(round(self.Y0Voie[Nvoie], 1)) + ' V')

    def AffichCalVoie(self,Nvoie):
        if self.ComptValCal[Nvoie] > 9:
            UniteCal = ' V/div'
            MultiplCal = 1
        else:
            UniteCal = ' mV/div'
            MultiplCal = 1000
        if self.ComptValCal[Nvoie] > 0:
            self.StrCalVoie[Nvoie].set(str(int(self.CalY[Nvoie] * MultiplCal)) + UniteCal)
        else:
            self.StrCalVoie[Nvoie].set(str(round(self.CalY[Nvoie] * MultiplCal, 1)) + UniteCal)

    ####################################################################################################################
    ############################################ GESTION DE LA BASE DE TEMPS ###########################################
    ####################################################################################################################

    def ChangeCalXPlus(self,evt):
        if self.ComptValCalX < 30:
            self.ComptValCalX = self.ComptValCalX + 1
            self.CalX = self.ValCalX[self.ComptValCalX]
            self.X0 = self.CalX * self.ComptDecalX * 0.1
            self.AffichX0()
            self.AffichCalX()
            if self.MenuSelect == 'Cursors':
                self.X1 = self.CalX * self.ComptDecalCursorX1 * 0.05
                self.X2 = self.CalX * self.ComptDecalCursorX2 * 0.05
                self.AffichValCurseursX(0, self.X1)
                self.AffichValCurseursX(1, self.X2)
            for i in range(2):
                if self.OnVoie[i] == True:
                    self.AffichSignalVoie(self.AmplVoie[i], self.FreqVoie[i], self.Offset[i], self.CalX, self.CalY[i], i)

    def ChangeCalXMoins(self,evt):
        if self.ComptValCalX > 0:
            self.ComptValCalX = self.ComptValCalX - 1
            self.CalX = self.ValCalX[self.ComptValCalX]
            self.X0 = self.CalX * self.ComptDecalX * 0.1
            self.AffichX0()
            self.AffichCalX()
            if self.MenuSelect == 'Cursors':
                self.X1 = self.CalX * self.ComptDecalCursorX1 * 0.05
                self.X2 = self.CalX * self.ComptDecalCursorX2 * 0.05
                self.AffichValCurseursX(0, self.X1)
                self.AffichValCurseursX(1, self.X2)
            for i in range(2):
                if self.OnVoie[i] == True:
                    self.AffichSignalVoie(self.AmplVoie[i], self.FreqVoie[i], self.Offset[i], self.CalX, self.CalY[i], i)

    def DecalX(self,evt,i):
        self.ComptDecalX = self.ComptDecalX + i
        self.X0 = self.X0 + i*0.1*self.CalX
        self.AffichX0()
        for v in range(2):
            if self.OnVoie[v] == True:
                self.AffichSignalVoie(self.AmplVoie[v], self.FreqVoie[v], self.Offset[v], self.CalX, self.CalY[v], v)

    def AnnulDecalX(self, evt):
        if self.OnOscillo == True:
            self.X0 = 0.0
            self.ComptDecalX = 0
            self.AffichX0()
            for v in range(2):
                if self.OnVoie[v] == True:
                    self.AffichSignalVoie(self.AmplVoie[v], self.FreqVoie[v], self.Offset[v], self.CalX, self.CalY[v], v)

    def AffichCalX(self):
        if self.ComptValCalX >= 0 and self.ComptValCalX < 7:
            UniteCalX = ' ns/div'
            MultiplCalX = 1000000000
        if self.ComptValCalX >= 7 and self.ComptValCalX < 16:
            UniteCalX = ' '+ chr(956) +'s/div'
            MultiplCalX = 1000000
        if self.ComptValCalX >= 16 and self.ComptValCalX < 25:
            UniteCalX = ' ms/div'
            MultiplCalX = 1000
        if self.ComptValCalX >= 25:
            UniteCalX = ' s/div'
            MultiplCalX = 1
        self.StrCalX.set(str(int(self.CalX * MultiplCalX))+ UniteCalX)

    def AffichX0(self):
        if self.ComptValCalX >= 0 and self.ComptValCalX < 7:
            if abs(self.X0) < 0.000000999:
                UniteCalX = ' ns'
                MultiplCalX = 1000000000
                Prec = 1
            else:
                UniteCalX = ' '+ chr(956) +'s'
                MultiplCalX = 1000000
                Prec = 2
        if self.ComptValCalX >= 7 and self.ComptValCalX < 16:
            if abs(self.X0) < 0.000999:
                UniteCalX = ' '+ chr(956) +'s'
                MultiplCalX = 1000000
                Prec = 1
            else:
                UniteCalX = ' ms'
                MultiplCalX = 1000
                Prec = 2
        if self.ComptValCalX >= 16 and self.ComptValCalX < 25:
            if abs(self.X0) < 0.999:
                UniteCalX = ' ms'
                MultiplCalX = 1000
                Prec = 1
            else:
                UniteCalX = ' s'
                MultiplCalX = 1
                Prec = 2
        if self.ComptValCalX >= 25:
            UniteCalX = ' s'
            MultiplCalX = 1
            Prec = 1
        self.X0Str.set(str(round(float(self.X0*MultiplCalX),Prec)) + UniteCalX)
        self.SymbX0.set_data(self.X0/self.CalX, 3.85)
        self.graph.draw()

    ####################################################################################################################
    ############################################ GESTION DES BOUTONS INTERACTIFS #######################################
    ####################################################################################################################

    def ActionBtnMenu(self,evt,NBtnMenu):
        if self.MenuSelect == 'Channels' and (NBtnMenu==1 or NBtnMenu==3) :
            if NBtnMenu == 1: Nvoie=0
            if NBtnMenu == 3: Nvoie=1
            if self.ActionMenu == '' and self.OnVoie[Nvoie] == True:
                self.CanvasBtnMenu[NBtnMenu].itemconfig(self.ImgBtnMenu[NBtnMenu], image=self.BtnMenu[0])
                self.CanvasSymbChangeTypeCoupling[Nvoie].itemconfig(self.ImgSymbChangeTypeCoupling[Nvoie],
                                                                    image=self.SymbChangeTypeCoupling[0])
                self.ActionMenu='SelectTypeCoupling'
                self.VoieActionMenu=Nvoie
                self.SignalTypeCouplingOld = self.SignalTypeCoupling[self.VoieActionMenu]
                ChangeCursor(self.CanvasBtnEntry)
                self.CanvasBtnMenu[NBtnMenu].bind('<Enter>', lambda action: self.CanvasBtnMenu[NBtnMenu].configure(cursor=''))
            else:
                if self.OnVoie[Nvoie] == True:
                    self.Back(evt)
                    self.ActionBtnMenu(evt,NBtnMenu)

        if self.MenuSelect == 'Measurement' and (NBtnMenu >= 0 and NBtnMenu <= 3):
            if self.ActionMenu == '':
                self.CanvasBtnMenu[NBtnMenu].itemconfig(self.ImgBtnMenu[NBtnMenu], image=self.BtnMenu[0])
                ChangeCursor(self.CanvasBtnEntry)
                if NBtnMenu == 0:
                    self.CanvasChangeNvoieSource.itemconfig(self.ImgChangeNvoieSource,
                                                                        image=self.ChangeNvoieSource[0])
                    self.ActionMenu = 'ChangeSourceMeas'
                    self.VoieSourceMeasOld = self.VoieSourceMeas
                    self.CanvasBtnMenu[0].bind('<Enter>', lambda action: self.CanvasBtnMenu[0].configure(cursor=''))
                if NBtnMenu == 1:
                    self.CanvasChangeMeasType.itemconfig(self.ImgChangeMeasType,image=self.ChangeMeasType[0])
                    self.MenuSelectType, wsize, hsize, self.CanvasMenuSelectType, self.ImgMenuSelectType = CanInWindow(
                        'Media/FrmOscillo/Measure/Type/MenuSelectType/', self.RatioImgOscillo, self.CanvasEcranOscillo,
                        int(self.SX * 0.25), int(self.SY * 0.005), self.TypeMeas)
                    self.ActionMenu = 'SelectTypeMeas'
                    self.TypeMeasOld = self.TypeMeas
                    self.CanvasBtnMenu[1].bind('<Enter>', lambda action: self.CanvasBtnMenu[1].configure(cursor=''))
                if NBtnMenu == 2:
                    if self.NbrMeas<4:
                        self.VSMeas[self.NbrMeas] = self.VoieSourceMeas
                        self.TMeas[self.NbrMeas] = self.TypeMeas
                        self.AffichLabelMeas(self.NbrMeas, self.VoieSourceMeas, self.TypeMeas)
                        self.AffichValMeas(self.NbrMeas, self.VoieSourceMeas, self.TypeMeas)
                        self.NbrMeas += 1
                    else:
                        for i in range(0, self.NbrMeas - 1):
                            self.VSMeas[i] = self.VSMeas[i + 1]
                            self.TMeas[i] = self.TMeas[i + 1]
                        self.VSMeas[self.NbrMeas-1] = self.VoieSourceMeas
                        self.TMeas[self.NbrMeas-1] = self.TypeMeas
                        for i in range(self.NbrMeas - 1, -1, -1):
                            self.EffaceMeas(i)
                        for i in range(self.NbrMeas):
                            self.AffichLabelMeas(i, self.VSMeas[i], self.TMeas[i])
                            self.AffichValMeas(i, self.VSMeas[i], self.TMeas[i])

                if NBtnMenu == 3:
                    self.ActionMenu = 'ClearMeas'
                    self.AffichMenuClearMeasure()
                    return;
            else:
                self.Back(evt)
                self.ActionBtnMenu(evt, NBtnMenu)

        if self.MenuSelect == 'ClearMeasure':
            self.CanvasBtnMenu[NBtnMenu].itemconfig(self.ImgBtnMenu[NBtnMenu], image=self.BtnMenu[0])
            if self.NbrMeas>NBtnMenu:
                if self.NbrMeas == NBtnMenu+1:
                    self.EffaceMeas(NBtnMenu)
                    self.CanvasClearMeas[NBtnMenu].itemconfig(self.ImgClearMeas[NBtnMenu], image=self.ClearMeas[0])
                    self.NbrMeas = self.NbrMeas - 1
                    self.CanvasBtnMenu[4].bind('<Enter>', lambda action: self.CanvasBtnMenu[1].configure(cursor=''))
                    if self.NbrMeas == 0: self.Back(evt)
                else:
                    for i in range(NBtnMenu,self.NbrMeas-1):
                        self.VSMeas[i] = self.VSMeas[i+1]
                        self.TMeas[i] = self.TMeas[i+1]
                    for i in range(self.NbrMeas-1,-1,-1):
                        self.EffaceMeas(i)
                    self.NbrMeas = self.NbrMeas - 1
                    for i in range(self.NbrMeas):
                        self.CanvasAddMeas[i].itemconfig(self.ImgAddMeas[i],image=self.AddMeas[1])
                        self.AffichLabelMeas(i, self.VSMeas[i], self.TMeas[i])
                        self.AffichValMeas(i, self.VSMeas[i], self.TMeas[i])
                    self.CanvasClearMeas[self.NbrMeas].itemconfig(self.ImgClearMeas[self.NbrMeas], image=self.ClearMeas[0])

            if NBtnMenu == 4:
                for i in range(self.NbrMeas-1, -1, -1):
                    self.EffaceMeas(i)
                self.NbrMeas = 0
                self.CanvasBtnMenu[4].bind('<Enter>', lambda action: self.CanvasBtnMenu[1].configure(cursor=''))
                self.Back(evt)

        if self.MenuSelect == 'Cursors' and (NBtnMenu >= 0 and NBtnMenu <= 1):
            if self.ActionMenu == '':
                self.CanvasBtnMenu[NBtnMenu].itemconfig(self.ImgBtnMenu[NBtnMenu], image=self.BtnMenu[0])
                ChangeCursor(self.CanvasBtnEntry)
                if NBtnMenu == 0:
                    self.CanvasChangeNvoieSource.itemconfig(self.ImgChangeNvoieSource,
                                                        image=self.ChangeNvoieSource[0])
                    self.ActionMenu = 'ChangeSourceMeas'
                    self.VoieSourceMeasOld = self.VoieSourceMeas
                    self.CanvasBtnMenu[0].bind('<Enter>', lambda action: self.CanvasBtnMenu[0].configure(cursor=''))
                if NBtnMenu == 1:
                    self.CanvasChangeMeasType.itemconfig(self.ImgChangeMeasType, image=self.ChangeMeasType[0])
                    self.ActionMenu = 'SelectTypeMeas'
                    self.TypeMeasOld = self.TypeMeas
                    self.CanvasBtnMenu[1].bind('<Enter>', lambda action: self.CanvasBtnMenu[1].configure(cursor=''))
            else:
                self.Back(evt)
                self.ActionBtnMenu(evt, NBtnMenu)

        if self.MenuSelect == 'Trigger' and (NBtnMenu >= 0 and NBtnMenu <= 1):
            if self.ActionMenu == '':
                self.CanvasBtnMenu[NBtnMenu].itemconfig(self.ImgBtnMenu[NBtnMenu], image=self.BtnMenu[0])
                ChangeCursor(self.CanvasBtnEntry)
                if NBtnMenu == 0:
                    self.CanvasChangeNvoieSource.itemconfig(self.ImgChangeNvoieSource, image=self.ChangeNvoieSource[0])
                    self.ActionMenu = 'ChangeSourceTrigg'
                    self.VoieSourceTriggOld = self.VoieSourceTrigg
                    self.CanvasBtnMenu[0].bind('<Enter>', lambda action: self.CanvasBtnMenu[0].configure(cursor=''))
                if NBtnMenu == 1:
                    self.CanvasChangeSlopeType.itemconfig(self.ImgChangeSlopeType, image=self.ChangeSlopeType[0])
                    self.ActionMenu = 'SelectTypeSlope'
                    self.TypeSlopeOld = self.TypeSlope
                    self.CanvasBtnMenu[1].bind('<Enter>', lambda action: self.CanvasBtnMenu[1].configure(cursor=''))


    def PressBtnMenu(self,evt,NBtnMenu):
        if self.MenuSelect == 'Channels' and (NBtnMenu==1 or NBtnMenu==3):
            if NBtnMenu == 1: Nvoie=0
            if NBtnMenu == 3: Nvoie=1
            if self.ActionMenu=='' and self.OnVoie[Nvoie] == True :
                self.CanvasBtnMenu[NBtnMenu].itemconfig(self.ImgBtnMenu[NBtnMenu], image=self.BtnMenu[1])
        if self.MenuSelect == 'Measurement' and (NBtnMenu >= 0 and NBtnMenu <= 3):
            if self.ActionMenu == '':
                self.CanvasBtnMenu[NBtnMenu].itemconfig(self.ImgBtnMenu[NBtnMenu], image=self.BtnMenu[1])
        if self.MenuSelect == 'ClearMeasure':
            self.CanvasBtnMenu[NBtnMenu].itemconfig(self.ImgBtnMenu[NBtnMenu], image=self.BtnMenu[1])
        if self.MenuSelect == 'Cursors'and (NBtnMenu >= 0 and NBtnMenu <= 1):
            self.CanvasBtnMenu[NBtnMenu].itemconfig(self.ImgBtnMenu[NBtnMenu], image=self.BtnMenu[1])

    def ChangeEntry(self, evt, i):
        if self.ActionMenu == 'SelectTypeCoupling':
            self.SignalTypeCoupling[self.VoieActionMenu]=self.SignalTypeCoupling[self.VoieActionMenu]+i
            if self.SignalTypeCoupling[self.VoieActionMenu] == -1: self.SignalTypeCoupling[self.VoieActionMenu]=1
            if self.SignalTypeCoupling[self.VoieActionMenu] == 2: self.SignalTypeCoupling[self.VoieActionMenu] = 0
            self.CanvasTypeCoupling[self.VoieActionMenu].itemconfig(self.ImgTypeCoupling[self.VoieActionMenu],
                                                image=self.TypeCoupling[self.SignalTypeCoupling[self.VoieActionMenu]])
            self.AffichSignalVoie(self.AmplVoie[self.VoieActionMenu], self.FreqVoie[self.VoieActionMenu],
                    self.Offset[self.VoieActionMenu], self.CalX, self.CalY[self.VoieActionMenu], self.VoieActionMenu)

        if self.ActionMenu == 'ChangeSourceMeas' or self.ActionMenu == 'ChangeSourceTrigg':
            self.VoieSourceMeas += i
            if self.VoieSourceMeas == -1: self.VoieSourceMeas = 1
            if self.VoieSourceMeas == 2: self.VoieSourceMeas = 0
            self.CanvasNvoieSource.itemconfig(self.ImgNvoieSource, image=self.NvoieSource[self.VoieSourceMeas])
            if self.MenuSelect == 'Cursors':
                self.Y1 = self.CalY[self.VoieSourceMeas] * self.ComptDecalCursorY1 * 0.05
                self.Y2 = self.CalY[self.VoieSourceMeas] * self.ComptDecalCursorY2 * 0.05
                self.AffichValCurseursY(2, self.Y1, self.VoieSourceMeas)
                self.AffichValCurseursY(3, self.Y2, self.VoieSourceMeas)

        if self.ActionMenu == 'SelectTypeMeas':
            self.TypeMeas += i
            if self.TypeMeas == -1: self.TypeMeas = 5
            if self.TypeMeas == 6: self.TypeMeas = 0
            if self.MenuSelect=='Measurement':
                self.CanvasMenuSelectType.itemconfig(self.ImgMenuSelectType, image=self.MenuSelectType[self.TypeMeas])
            self.CanvasMeasType.itemconfig(self.ImgMeasType, image=self.MeasType[self.TypeMeas])

        if self.ActionMenu == 'SelectTypeSlope':
            self.TypeSlope += i
            if self.TypeSlope == -1: self.TypeSlope = 1
            if self.TypeSlope == 2: self.TypeSlope = 0
            self.CanvasSlopeType.itemconfig(self.ImgSlopeType, image=self.SlopeType[self.TypeSlope])

    def PressEntry(self, evt):
        if self.ActionMenu != '': self.CanvasBtnEntry.itemconfig(self.ImgBtnEntry, image=self.BtnEntry[1])

    def ActionEntry(self, evt):
        if self.ActionMenu != '':
            self.CanvasBtnEntry.itemconfig(self.ImgBtnEntry, image=self.BtnEntry[0])

            if self.ActionMenu == 'SelectTypeCoupling':
                self.CanvasSymbChangeTypeCoupling[self.VoieActionMenu].itemconfig(
                self.ImgSymbChangeTypeCoupling[self.VoieActionMenu],image=self.SymbChangeTypeCoupling[1])
                if self.OnVoie[0]==True:
                    self.CanvasBtnMenu[1].bind('<Enter>',lambda action: self.CanvasBtnMenu[1].configure(cursor='hand2'))
                if self.OnVoie[1]==True:
                    self.CanvasBtnMenu[3].bind('<Enter>',lambda action: self.CanvasBtnMenu[3].configure(cursor='hand2'))

            if self.ActionMenu == 'ChangeSourceMeas' or self.ActionMenu == 'ChangeSourceTrigg':
                self.CanvasChangeNvoieSource.itemconfig(self.ImgChangeNvoieSource, image=self.ChangeNvoieSource[1])
                self.CanvasBtnMenu[0].bind('<Enter>', lambda action: self.CanvasBtnMenu[0].configure(cursor='hand2'))

            if self.ActionMenu == 'SelectTypeMeas':
                if self.MenuSelect=='Measurement' : self.CanvasMenuSelectType.destroy()
                self.CanvasChangeMeasType.itemconfig(self.ImgChangeMeasType, image=self.ChangeMeasType[1])
                self.CanvasBtnMenu[1].bind('<Enter>', lambda action: self.CanvasBtnMenu[1].configure(cursor='hand2'))

            if self.ActionMenu == 'SelectTypeSlope':
                self.CanvasChangeSlopeType.itemconfig(self.ImgChangeSlopeType, image=self.ChangeSlopeType[1])
                self.CanvasBtnMenu[1].bind('<Enter>', lambda action: self.CanvasBtnMenu[1].configure(cursor='hand2'))

            self.ActionMenu = ''
            self.CanvasBtnEntry.bind('<Enter>', lambda action: self.CanvasBtnEntry.configure(cursor=''))


    def AutoScale(self, evt):
        if self.OnOscillo == True:
            self.CanvasBtnAutoScale.itemconfig(self.ImgBtnAutoScale, image=self.BtnAutoScale[0])

            if self.OnVoie[0] == True and self.AmplVoie[0] > 0:
                self.ComptValCal[0] = 0
                for val in self.ValCal:
                    if (self.AmplVoie[0] + self.Offset[0]) / val >= 2 and (
                            self.AmplVoie[0] + self.Offset[0]) / val <= 5:
                        self.CalY[0] = val
                        self.AffichCalVoie(0)
                        self.DecalVoieAnnul(evt, 0)
                        if self.MenuSelect == 'Cursors':
                            self.Y1 = self.CalY[0] * self.ComptDecalCursorY1 * 0.05
                            self.Y2 = self.CalY[0] * self.ComptDecalCursorY2 * 0.05
                            self.AffichValCurseursY(2, self.Y1, 0)
                            self.AffichValCurseursY(3, self.Y2, 0)
                        break
                    self.ComptValCal[0] = self.ComptValCal[0] + 1
            else:
                if self.OnVoie[1] == True and self.AmplVoie[1] > 0:
                    self.ComptValCal[1] = 0
                    for val in self.ValCal:
                        if (self.AmplVoie[1] + self.Offset[1]) / val >= 2 and (
                                self.AmplVoie[1] + self.Offset[1]) / val <= 5:
                            self.CalY[1] = val
                            self.AffichCalVoie(1)
                            self.DecalVoieAnnul(evt, 1)
                            if self.MenuSelect == 'Cursors':
                                self.Y1 = self.CalY[1] * self.ComptDecalCursorY1 * 0.05
                                self.Y2 = self.CalY[1] * self.ComptDecalCursorY2 * 0.05
                                self.AffichValCurseursY(2, self.Y1, 1)
                                self.AffichValCurseursY(3, self.Y2, 1)
                            break
                        self.ComptValCal[1] = self.ComptValCal[1] + 1

            if self.FreqVoie[0] > 0:
                self.ComptValCalX = 0
                for val in self.ValCalX:
                    if 10 * val >= 4 / self.FreqVoie[0] and 10 * val <= 5 / self.FreqVoie[0]:
                        self.CalX = val
                        self.AffichCalX()
                        self.AnnulDecalX(evt)
                        if self.MenuSelect == 'Cursors':
                            self.X1 = self.CalX * self.ComptDecalCursorX1 * 0.05
                            self.X2 = self.CalX * self.ComptDecalCursorX2 * 0.05
                            self.AffichValCurseursX(0, self.X1)
                            self.AffichValCurseursX(1, self.X2)
                        break
                    self.ComptValCalX = self.ComptValCalX + 1

    def RegCursors(self, event, i):
        if self.TypeMeas==0:
            self.ComptDecalCursorX1 = self.ComptDecalCursorX1 + i
            self.X1 = self.X1 + i * 0.05 * self.CalX
            self.AffichCursorsX(1)
        if self.TypeMeas==1:
            self.ComptDecalCursorX2 = self.ComptDecalCursorX2 + i
            self.X2 = self.X2 + i * 0.05 * self.CalX
            self.AffichCursorsX(2)
        if self.TypeMeas == 2:
            self.ComptDecalCursorX1 = self.ComptDecalCursorX1 + i
            self.ComptDecalCursorX2 = self.ComptDecalCursorX2 + i
            self.X1 = self.X1 + i * 0.05 * self.CalX
            self.X2 = self.X2 + i * 0.05 * self.CalX
            self.AffichCursorsX(1)
            self.AffichCursorsX(2)
        if self.TypeMeas == 3:
            self.ComptDecalCursorY1 = self.ComptDecalCursorY1 + i
            self.Y1 = self.Y1 + i * 0.05 * self.CalY[self.VoieSourceMeas]
            self.AffichCursorsY(1,self.VoieSourceMeas)
        if self.TypeMeas == 4:
            self.ComptDecalCursorY2 = self.ComptDecalCursorY2 + i
            self.Y2 = self.Y2 + i * 0.05 * self.CalY[self.VoieSourceMeas]
            self.AffichCursorsY(2,self.VoieSourceMeas)
        if self.TypeMeas == 5:
            self.ComptDecalCursorY1 = self.ComptDecalCursorY1 + i
            self.ComptDecalCursorY2 = self.ComptDecalCursorY2 + i
            self.Y1 = self.Y1 + i * 0.05 * self.CalY[self.VoieSourceMeas]
            self.AffichCursorsY(1, self.VoieSourceMeas)
            self.Y2 = self.Y2 + i * 0.05 * self.CalY[self.VoieSourceMeas]
            self.AffichCursorsY(2, self.VoieSourceMeas)

    def ActionBtnRegCursors(self,evt):
        if self.OnOscillo == True:
            if self.MenuSelect != 'Cursors':
                self.AffichMenuCursors(evt)
                self.ActionBtnMenu(evt, 1)
            else:
                if self.ActionMenu=='':
                    self.ActionBtnMenu(evt, 1)
                else:
                    self.ActionEntry(evt)

    def MouseWheelDecalVoie(self, event, Nvoie):
        if self.OnOscillo == True:
            if event.delta == -120:
                if self.OnVoie[Nvoie] == True: self.DecalVoie(event,Nvoie,-1)
            if event.delta == 120:
                if self.OnVoie[Nvoie] == True: self.DecalVoie(event,Nvoie,1)

    def MouseWheelChangeCalVoie(self, event, Nvoie):
        if self.OnOscillo == True:
            if event.delta == -120:
                if self.OnVoie[Nvoie] == True: self.ChangeCalVoieMoins(event,Nvoie)
            if event.delta == 120:
                if self.OnVoie[Nvoie] == True: self.ChangeCalVoiePlus(event,Nvoie)

    def MouseWheelChangeCalX(self,event):
        if self.OnOscillo == True:
            if event.delta == -120:
                self.ChangeCalXMoins(event)
            if event.delta == 120:
                self.ChangeCalXPlus(event)

    def MouseWheelDecalX(self, event):
        if self.OnOscillo == True:
            if event.delta == -120:
                self.DecalX(event,-1)
            if event.delta == 120:
                self.DecalX(event,1)

    def MouseWheelEntry(self, event):
        if self.OnOscillo == True:
            if event.delta == -120:
                self.ChangeEntry(event,-1)
            if event.delta == 120:
                self.ChangeEntry(event,+1)

    def MouseWheelRegCursors(self, event):
        if self.OnOscillo == True:
            if event.delta == -120:
                if self.ActionMenu == '':
                    self.RegCursors(event,-1)
                else:
                    self.ChangeEntry(event,-1)
            if event.delta == 120:
                if self.ActionMenu == '':
                    self.RegCursors(event,1)
                else:
                    self.ChangeEntry(event,1)

    ####################################################################################################################
    ############################################## AFFICHAGE DES MESURES ###############################################
    ####################################################################################################################

    def AffichLabelMeas(self, N, Source, Type):

        self.CanvasAddMeas[N].itemconfig(self.ImgAddMeas[N], image=self.AddMeas[1])

        self.LabelValMeas.append(LabelVar(self.CanvasAddMeas[N], self.StrValMeas[N], 'black', font=self.MyFont))
        self.CanvasAddMeas[N].create_window(int(self.AMwsize * 0.54), int(self.AMhsize * 0.1), anchor=tk.NW,
                                         window=self.LabelValMeas[N])

        self.LabelTypeMeas.append(LabelVar(self.CanvasAddMeas[N], self.StrTypeMeas[N], 'black', font=self.MyFont))
        self.CanvasAddMeas[N].create_window(int(self.AMwsize * 0.05), int(self.AMhsize * 0.1), anchor=tk.NW,
                                            window=self.LabelTypeMeas[N])
        self.LabelValMeas[N].configure(fg='white')
        self.LabelTypeMeas[N].configure(fg=self.ColorVoie[Source])

        StrTypeMeas = ''
        StrOrigine = ''
        if Type == 0: StrTypeMeas = 'Pk-Pk ['
        if Type == 1: StrTypeMeas = 'Ampl ['
        if Type == 2: StrTypeMeas = 'Period ['
        if Type == 3: StrTypeMeas = 'Freq ['
        if Type == 4: StrTypeMeas = 'Delay ['
        if Type == 5: StrTypeMeas = 'Phase ['
        if Type == 4 or self.TypeMeas == 5:
            if Source == 0:
                StrOrigine = '/2'
            else:
                StrOrigine = '/1'
        self.StrTypeMeas[N].set(StrTypeMeas + str(Source + 1) + StrOrigine + ']:')


    def AffichValMeas(self, N, Source, Type):

        if self.OnVoie[Source] == True:
            if Type==0:
                if Source == 1:
                    self.ValMeas[N] = 2* self.MainAppli.FonctionTransfert(self.MainAppli.FuncSignal(self.AmplVoie[1],
                                                                                    self.FreqVoie[1],0,0))
                else:
                    self.ValMeas[N] = self.AmplVoie[Source]
                PkPk = self.FormatTension(self.ValMeas[N])
                self.StrValMeas[N].set(PkPk)
            if Type==1:
                if Source == 1:
                    self.ValMeas[N] = self.MainAppli.FonctionTransfert(self.MainAppli.FuncSignal(self.AmplVoie[1],
                                                                                    self.FreqVoie[1],0,0))
                else:
                    self.ValMeas[N] = self.AmplVoie[Source]/2
                Ampl = self.FormatTension(self.ValMeas[N])
                self.StrValMeas[N].set(Ampl)
            if Type==2:
                if self.FreqVoie[Source]>0:
                    self.ValMeas[N] = 1/self.FreqVoie[Source]
                    PD = self.FormatTime(self.ValMeas[N])
                    self.StrValMeas[N].set(PD)
                else:
                    self.StrValMeas[N].set('No Signal')
            if Type==3:
                if self.FreqVoie[Source]>0:
                    self.ValMeas[N]=self.FreqVoie[Source]
                    valfreq=self.FormatFreq(self.ValMeas[N])
                    self.StrValMeas[N].set(valfreq)
                else:
                    self.StrValMeas[N].set('No Signal')
            if Type==4:
                if Source == 0:
                    if self.FreqVoie[Source] > 0:
                        if self.OnVoie[1] == True and self.FreqVoie[1]>0:
                            self.ValMeas[N]= -self.DephasageVoie2 / (2 * np.pi * self.FreqVoie[0])
                            DT = self.FormatTime(self.ValMeas[N])
                            self.StrValMeas[N].set(DT)
                        else:
                            self.ValMeas[N] = 0
                            self.StrValMeas[N].set('[2]:No Signal')
                    else :
                        self.ValMeas[N] = 0
                        self.StrValMeas[N].set('No Signal')
                else:
                    if self.FreqVoie[Source]>0:
                        if self.OnVoie[0] == True and self.FreqVoie[0] > 0:
                            self.ValMeas[N] = self.DephasageVoie2 / (2 * np.pi * self.FreqVoie[0])
                            DT = self.FormatTime(self.ValMeas[N])
                            self.StrValMeas[N].set(DT)
                        else:
                            self.ValMeas[N] = 0
                            self.StrValMeas[N].set('[1]:No Signal')
                    else :
                        self.ValMeas[N] = 0
                        self.StrValMeas[N].set('No Signal')
            if Type==5:
                if Source == 0:
                    if self.FreqVoie[Source] > 0:
                        if self.OnVoie[1] == True and self.FreqVoie[1]>0:
                            self.ValMeas[N] = self.DephasageVoie2 * 180 / np.pi
                            self.StrValMeas[N].set(str(round(-self.ValMeas[N],1))+'°')
                        else:
                            self.ValMeas[N] = 0
                            self.StrValMeas[N].set('[2]:No Signal')
                    else :
                        self.ValMeas[N] = 0
                        self.StrValMeas[N].set('No Signal')

                else:
                    if self.FreqVoie[Source] > 0 :
                        if self.OnVoie[0] == True and self.FreqVoie[0]>0:
                            self.ValMeas[N]= self.DephasageVoie2 * 180 / np.pi
                            self.StrValMeas[N].set(str(round(self.ValMeas[N],1))+'°')
                        else:
                            self.ValMeas[N] = 0
                            self.StrValMeas[N].set('[1]:No Signal')
                    else :
                        self.ValMeas[N] = 0
                        self.StrValMeas[N].set('No Signal')
        else:
            self.ValMeas[N] = 0
            self.StrValMeas[N].set('No Signal')


    def MAJMeas(self):
        for i in range(self.NbrMeas):
            self.AffichValMeas(i,self.VSMeas[i], self.TMeas[i])


    def FormatTime(self, DT):
        if abs(DT) < 0.0000001:
            UniteDT = ' ns'
            MultiplDT = 1000000000
            Prec = 3
        else:
            if abs(DT) >= 0.00000001 and abs(DT) < 0.000001:
                UniteDT = ' ns'
                MultiplDT = 1000000000
                Prec = 2
            else:
                if abs(DT) >= 0.000001 and abs(DT) < 0.0001:
                    UniteDT = ' ' + chr(956) +'s'
                    MultiplDT = 1000000
                    Prec = 3
                else:
                    if abs(DT) >= 0.0001 and abs(DT) < 0.001:
                        UniteDT = ' ' + chr(956) +'s'
                        MultiplDT = 1000000
                        Prec = 2
                    else:
                        if abs(DT) >= 0.001 and abs(DT) < 0.1:
                            UniteDT = ' ms'
                            MultiplDT = 1000
                            Prec = 3
                        else:
                            if abs(DT) >= 0.1 and abs(DT) < 1:
                                UniteDT = ' ms'
                                MultiplDT = 1000
                                Prec = 2
                            else:
                                UniteDT = ' s'
                                MultiplDT = 1
                                Prec = 2

        FormatDT=str(round(DT * MultiplDT, Prec)) + UniteDT
        return FormatDT

    def FormatTension(self, V):
        if abs(V) < 0.01:
            UniteV = ' mV'
            MultiplV = 1000
            Prec = 3
        else:
            if abs(V)>=0.01 and abs(V)<0.1:
                UniteV = ' mV'
                MultiplV = 1000
                Prec = 2
            else:
                if abs(V)>=0.1 and abs(V)<1:
                    UniteV = ' mV'
                    MultiplV = 1000
                    Prec = 1
                else:
                    if abs(V)>=1 and abs(V)<100:
                        UniteV = ' V'
                        MultiplV = 1
                        Prec = 2
                    else:
                        UniteV = ' V'
                        MultiplV = 1
                        Prec = 1

        FormatV=str(round(V * MultiplV, Prec)) + UniteV
        return FormatV

    def FormatFreq(self,F):

        if abs(F)< 1000:
            UniteV = ' Hz'
            DivF = 1
        if abs(F) >= 1000 and abs(F) < 1000000:
            UniteV = ' kHz'
            DivF = 1000
        if abs(F) >= 1000000 and abs(F) < 1000000000:
            UniteV = ' MHz'
            DivF = 1000000
        if abs(F) >= 1000000000:
            UniteV = ' GHz'
            DivF = 1000000000

        if abs(F)<10 : Prec = 3
        if abs(F)>=10 and abs(F) < 100: Prec = 2
        if abs(F) >= 100 and abs(F) < 1000: Prec = 1
        if abs(F)>=1000 and abs(F)<10000: Prec = 3
        if abs(F) >= 10000 and abs(F) < 100000: Prec = 2
        if abs(F) >= 100000 and abs(F) < 1000000: Prec = 1
        if abs(F) >= 1000000 and abs(F) < 10000000: Prec = 3
        if abs(F) >= 10000000 and abs(F) < 100000000: Prec = 2
        if abs(F) >= 100000000: Prec = 1

        FormatF = str(round(F / DivF, Prec)) + UniteV
        return FormatF

    def EffaceMeas(self, NMeas):

        self.CanvasAddMeas[NMeas].itemconfig(self.ImgAddMeas[NMeas], image=self.AddMeas[0])
        self.StrTypeMeas[NMeas].set('')
        self.StrValMeas[NMeas].set('')
        del self.LabelValMeas[NMeas]
        del self.LabelTypeMeas[NMeas]

    def EffaceCadreMeas(self):

        for elt in self.CanvasCadreMeas.find_all():
            self.CanvasCadreMeas.delete(elt)


    ####################################################################################################################
    ############################################## AFFICHAGE DES CURSEURS ##############################################
    ####################################################################################################################

    def AffichCursorsX(self, N):
        Y = np.arange(-4, 5, 8)
        if N==1:
            self.CursorX1.set_data(self.X1/self.CalX, Y)
            self.AffichValCurseursX(0, self.X1)
        if N==2:
            self.CursorX2.set_data(self.X2/self.CalX, Y)
            self.AffichValCurseursX(1, self.X2)
        self.graph.draw()

    def AffichCursorsY(self, N, source):
        X = np.arange(-5, 6, 10)
        if N==1:
            self.CursorY1.set_data(X, self.Y1/self.CalY[source])
            self.AffichValCurseursY(2, self.Y1, source )
        if N==2:
            self.CursorY2.set_data(X, self.Y2/self.CalY[source])
            self.AffichValCurseursY(3, self.Y2, source)
        self.graph.draw()

    def EffaceCurseurs(self):
        self.CursorY1.set_data(0, 0)
        self.CursorY2.set_data(0, 0)
        self.CursorX1.set_data(0, 0)
        self.CursorX2.set_data(0, 0)
        self.graph.draw()

    def AffichValCurseursX (self,N, X):
        if self.ComptValCalX >= 0 and self.ComptValCalX < 7:
            if abs(X) < 0.000000999:
                UniteCalX = ' ns'
                MultiplCalX = 1000000000
                Prec = 2
            else:
                UniteCalX = ' '+ chr(956) +'s'
                MultiplCalX = 1000000
                Prec = 3
        if self.ComptValCalX >= 7 and self.ComptValCalX < 16:
            if abs(X) < 0.000999:
                UniteCalX = ' '+ chr(956) +'s'
                MultiplCalX = 1000000
                Prec = 2
            else:
                UniteCalX = ' ms'
                MultiplCalX = 1000
                Prec = 3
        if self.ComptValCalX >= 16 and self.ComptValCalX < 25:
            if abs(X) < 0.999:
                UniteCalX = ' ms'
                MultiplCalX = 1000
                Prec = 2
            else:
                UniteCalX = ' s'
                MultiplCalX = 1
                Prec = 3
        if self.ComptValCalX >= 25:
            UniteCalX = ' s'
            MultiplCalX = 1
            Prec = 2

        self.StrValMeas[N].set(str(round(float(X * MultiplCalX), Prec)) + UniteCalX)
        for i in range (2): self.CalculDelta(i)

    def AffichValCurseursY(self, N, X, NvoieSource):

        if self.CalY[NvoieSource]<0.01:
            UniteCalX = ' mV'
            MultiplCalX = 1000
            Prec = 2
        else:
            if X > 0:
                if X<0.99:
                    UniteCalX = ' mV'
                    MultiplCalX = 1000
                    Prec = 1
                else:
                    UniteCalX = ' V'
                    MultiplCalX = 1
                    Prec = 2
            else:
                if X>-0.99:
                    UniteCalX = ' mV'
                    MultiplCalX = 1000
                    Prec = 1
                else:
                    UniteCalX = ' V'
                    MultiplCalX = 1
                    Prec = 2

        self.StrValMeas[N].set(str(round(float(X * MultiplCalX), Prec)) + UniteCalX)

        self.CalculDelta(2)

    def CalculDelta(self, N):
        if N==0:
            DT = self.FormatTime(self.X1-self.X2)
            self.StrValDelta[N].set(DT)
        if N==1:
            if round(self.X1,10) != round(self.X2,10):
                F=self.FormatFreq(abs(1/(self.X1 - self.X2)))
            else:
                F=0
            self.StrValDelta[N].set(F)
        if N==2:
            DY = self.FormatTension(self.Y1 - self.Y2)
            self.StrValDelta[N].set(DY)


    ####################################################################################################################
    ############################################## AFFICHAGE DES SIGNAUX ###############################################
    ####################################################################################################################

    def MAJAmpFreq(self,A,F,Offset,Nvoie):

        self.AmplVoie[Nvoie] = A
        self.FreqVoie[Nvoie] = F
        self.Offset[Nvoie] = Offset

        self.TriggerSignal(self.AmplVoie[Nvoie], self.FreqVoie[Nvoie],  self.CalX)
        self.AffichSignalVoie(self.AmplVoie[Nvoie], self.FreqVoie[Nvoie], self.Offset[Nvoie], self.CalX, self.CalY[Nvoie], Nvoie)

        self.MAJMeas()

    def AffichSignalVoie(self, A, F, Offset, CalX, CalY, Nvoie):
        if Nvoie==1 :
            self.DephasageVoie2 = self.MainAppli.CalculDephasage(F)
        X = np.arange(-5 , 5 , 0.001)
        if Nvoie == 0:
            Y=(self.MainAppli.FuncSignal(A,F,(X * CalX + self.X0 + self.trigX * CalX ),0) + self.Offset[Nvoie]*self.SignalTypeCoupling[Nvoie]
               + self.Y0Voie[Nvoie]) / CalY
            self.lineSignalVoie1.set_data(X, Y)
        else:
            Y = (self.MainAppli.FonctionTransfert(self.MainAppli.FuncSignal(A,F,(X * CalX + self.X0 + self.trigX * CalX),
                self.DephasageVoie2)) + self.Offset[Nvoie]*self.SignalTypeCoupling[Nvoie] + self.Y0Voie[Nvoie]) / CalY
            self.lineSignalVoie2.set_data(X, Y)
        self.graph.draw()


    def TriggerSignal(self,A, F, CalX):

        if F > 0:
            self.trigX=0
            Y1 = self.MainAppli.FuncSignal(A, F, (-5 * CalX + self.trigX * CalX), 0)
            self.trigX = self.trigX + 0.001
            Y2 = self.MainAppli.FuncSignal(A, F, (-5 * CalX + self.trigX * CalX), 0)
            if self.TypeSlope==0:
                while not (Y2 > Y1 and Y2 > self.trigY):
                    Y1 = Y2
                    self.trigX = self.trigX + 0.001
                    Y2 = self.MainAppli.FuncSignal(A, F, (-5 * CalX + self.X0 + self.trigX * CalX), 0)
            if self.TypeSlope==1:
                while not (Y2 < Y1 and Y2 < self.trigY):
                    Y1 = Y2
                    self.trigX = self.trigX + 0.001
                    Y2 = self.MainAppli.FuncSignal(A, F, (-5 * CalX + self.X0 + self.trigX * CalX), 0)