from AppliDef import *
import shutil
from FrmAjoutModifProd import ChargeEntry


class FrmAjoutDoc(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.DocPDF = False
        self.FrmPDF = None
        self.PathFilePDFToOpen = ''
        self.FichierPDFOpen = ''
        self.Doc = []
        self.ActionModifTitre = False
        self.MenuClicDroitPDF = None
        self.NomInit = ''
        self.FileResumeInit = ''
        self.DocPDFInit = ''

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmAjout)

        if self.MainAppli.BaseEnCours == "CHIMIE":
            Type = 'Chimie'
        else:
            Type = 'Physique'

        if self.MainAppli.ModifEnCours:
            textlabelTag = 'Modifier un document de ' + Type
        else:
            textlabelTag = 'Ajouter un document de ' + Type
        coefY = float(ConfigResolution(self.MainAppli.Nconfig, 'YTitreFrm', self.MainAppli.curSave))
        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, textlabelTag, '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * coefY), tk.NW)

        self.CanvasMenu1 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.665),
                                      int(self.SY * 0.967), int(self.SX * 0.003), int(self.SY * 0.03), tk.NW)

        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Document PDF', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.005), tk.NW)

        self.ImgSousMenu1 = []
        self.ImgSousMenu1 = RedimImg(int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.97),
                                     int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.9), 'Media/FrmAjout/SousMenu/')
        self.CanvasSousMenu1 = CanvasApp(self, width=int(self.CanvasMenu1.CanvasMenu['width']) * 0.95,
                                         height=int(self.CanvasMenu1.CanvasMenu['height']) * 0.9)
        self.CanvasMenu1.CanvasMenu.create_window(int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.5),
                                                  int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.53),
                                                  anchor=tk.CENTER, window=self.CanvasSousMenu1)
        self.ImgCanvasSousMenu1 = self.CanvasSousMenu1.create_image(0, 0, anchor=tk.NW, image=self.ImgSousMenu1[0])

        self.NoPDF = NoPDF(self.CanvasSousMenu1, 'Media/FrmAjout/NoPDF/NoPDF2.jpg',
                           int(int(self.CanvasSousMenu1['width']) * 0.5),
                           int(int(self.CanvasSousMenu1['height']) * 0.5), self.RatioX, self.RatioY)
        self.BtnImportPDF = BtnAction(self.CanvasMenu1.CanvasMenu,
                                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.91),
                                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.06), self.RatioX,
                                      self.RatioY, 'Media/FrmAjout/BtnPDF/')
        self.BtnSuppPDF = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.96),
                                    int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.06), self.RatioX,
                                    self.RatioY, 'Media/FrmAjout/BtnSupp/')

        self.BtnImportPDF.CanvasBtn.bind('<ButtonRelease-1>', self.ChargePDF)
        self.BtnSuppPDF.CanvasBtn.bind('<ButtonRelease-1>', self.SupPDF)
        ChangeCursor(self.NoPDF.CanvasImgNoPdf)
        self.NoPDF.CanvasImgNoPdf.bind('<ButtonRelease-1>', self.ChargePDF)

        self.CanvasMenu2 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.33),
                                      int(self.SY * 0.967), int(self.SX * 0.998), int(self.SY * 0.03), tk.NE)

        LabelInCanvas(self.CanvasMenu2.CanvasMenu, 'Descriptif du document', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.005), tk.NW)

        self.CanvasDescript = CanvasInWindow('Media/FrmInfo/FondDescriptMat/', self.RatioX * 1.65, self.RatioY * 1.65,
                                             self.CanvasMenu2.CanvasMenu, tk.CENTER,
                                             int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                             int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.5), 0)

        self.EntryNom = EntryData(self.CanvasDescript.CanvasListIma, int(self.CanvasDescript.wsize * 0.1),
                                  int(self.CanvasDescript.wsize * 0.5), int(self.CanvasDescript.hsize * 0.1), tk.CENTER,
                                  AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryNom.Data.set('Titre du document')
        self.EntryNom.EntryData.config(justify='center')
        self.EntryNom.EntryData.bind('<KeyRelease>', self.ModifTitre)

        self.CanvasDescript.CanvasListIma.create_text(
            int(self.CanvasDescript.wsize * 0.05), int(self.CanvasDescript.hsize * 0.18), text='Catégorie:',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.EntryCat = EntryData(self.CanvasDescript.CanvasListIma, int(self.CanvasDescript.wsize * 0.105),
                                  int(self.CanvasDescript.wsize * 0.5), int(self.CanvasDescript.hsize * 0.23),
                                  tk.CENTER, AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryCat.Data.set('')
        self.EntryCat.EntryData.config(justify='left')
        self.EntryCat.EntryData.bind('<Return>', self.ModifCat)

        self.CanvasDescript.CanvasListIma.create_text(
            int(self.CanvasDescript.wsize * 0.05), int(self.CanvasDescript.hsize * 0.3), text='Résumé:',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.ZoneText = ZoneScrolledText(self.CanvasDescript.CanvasListIma, width=int(self.CanvasDescript.wsize * 0.12),
                                         height=int(self.CanvasDescript.hsize * 0.03),
                                         font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.CanvasDescript.CanvasListIma.create_window(int(self.CanvasDescript.wsize * 0.03),
                                                        int(self.CanvasDescript.hsize * 0.335), anchor=tk.NW,
                                                        window=self.ZoneText)

        self.CanvasDescript.CanvasListIma.create_text(
            int(self.CanvasDescript.wsize * 0.05), int(self.CanvasDescript.hsize * 0.88), text='Mots clés:',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.EntryMotCle = EntryData(self.CanvasDescript.CanvasListIma, int(self.CanvasDescript.wsize * 0.105),
                                     int(self.CanvasDescript.wsize * 0.5), int(self.CanvasDescript.hsize * 0.93),
                                     tk.CENTER, AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryMotCle.Data.set('')
        self.EntryMotCle.EntryData.config(justify='left')

        self.BtnOK = BtnAction(self.CanvasFrmFond, int(self.SX * 0.962), int(self.SY * 0.972), self.RatioX * 0.15,
                               self.RatioX * 0.15, 'Media/FrmAjout/BtnOK/')
        self.BtnAnnul = BtnAction(self.CanvasFrmFond, int(self.SX * 0.985), int(self.SY * 0.972), self.RatioX * 0.15,
                                  self.RatioX * 0.15, 'Media/FrmAjout/BtnAnnul/')
        ChangeCursor(self.BtnAnnul.CanvasBtn)
        ChangeCursor(self.BtnOK.CanvasBtn)
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.CacheFrmAjout)
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.SaveNewDoc)

        if self.MainAppli.NAction != 403:
            self.AffichInfoDoc()
            self.TextAction = 'Mise à jour - Document - '
        else:
            self.TextAction = 'Ajout - Document - '

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)

        self.CanvasFrmFond.pack()

    def AffichInfoDoc(self):
        Doc = []
        if self.MainAppli.NAction == 4:
            Doc = self.MainAppli.ListDocs[self.MainAppli.IndexElt]
        elif self.MainAppli.NAction == 4011:
            Doc = self.MainAppli.ListRecherch[self.MainAppli.IndexElt]
        elif self.MainAppli.NAction == 4022:
            Doc = self.MainAppli.ListDocCat[self.MainAppli.IndexElt]

        if Doc[1] is not None and Doc[1] != '':
            self.DocPDFInit = Doc[1]
            path = ''
            if self.MainAppli.BaseEnCours == "CHIMIE":
                path = 'Datas/DocsPDFChim/' + Doc[1] + '.pdf'
            elif self.MainAppli.BaseEnCours == "PHYS":
                path = 'Datas/DocsPDFPhys/' + Doc[1] + '.pdf'

            if os.path.exists(path):
                self.FrmPDF = FrmPDF(self.CanvasSousMenu1, path, 1.5, int(self.CanvasMenu1.CanvasMenu['height']),
                                     int(int(self.CanvasSousMenu1['width']) * 0.5),
                                     int(int(self.CanvasSousMenu1['height']) * 0.48),
                                     int(int(self.CanvasSousMenu1['width']) * 0.98),
                                     int(int(self.CanvasSousMenu1['height']) * 0.9))
                self.FichierPDFOpen = Doc[1]
                self.DocPDF = True

        ChargeEntry(self.EntryNom, Doc[0])
        self.NomInit = Doc[0]
        ChargeEntry(self.EntryMotCle, Doc[3])
        ChargeEntry(self.EntryCat, Doc[4])
        if Doc[2] is not None and Doc[2] != '':
            self.FileResumeInit = Doc[2]
            File = ''
            if self.MainAppli.BaseEnCours == "CHIMIE":
                if os.path.exists('Datas/DescriptDocChim/' + Doc[2] + '.txt'):
                    File = open('Datas/DescriptDocChim/' + Doc[2] + '.txt', "r", encoding="utf-8")
            else:
                if os.path.exists('Datas/DescriptDocPhys/' + Doc[2] + '.txt'):
                    File = open('Datas/DescriptDocPhys/' + Doc[2] + '.txt', "r", encoding="utf-8")
            for ligne in File:
                self.ZoneText.insert(tk.INSERT, ligne)
        self.Doc = Doc

    def ChargePDF(self, _):
        self.PathFilePDFToOpen = tkfiledialog.askopenfilename(title="Ouvrir un fichier",
                                                              filetypes=[('PDF files', '.pdf')], parent=self)
        if self.PathFilePDFToOpen != '':
            self.FrmPDF = FrmPDF(self.CanvasSousMenu1, self.PathFilePDFToOpen, 1.5,
                                 int(self.CanvasMenu1.CanvasMenu['height']),
                                 int(int(self.CanvasSousMenu1['width']) * 0.5),
                                 int(int(self.CanvasSousMenu1['height']) * 0.48),
                                 int(int(self.CanvasSousMenu1['width']) * 0.98),
                                 int(int(self.CanvasSousMenu1['height']) * 0.9))
            self.FrmPDF.CanvasDoc.bind('<Double-1>', self.OuvrePDF)
            self.MenuClicDroitPDF = tk.Menu(self.FrmPDF.CanvasDoc, tearoff=0)
            self.MenuClicDroitPDF.add_command(label="Visualiser dans le navigateur", command=self.ActionOuvrePDF)
            self.MenuClicDroitPDF.add_separator()
            self.MenuClicDroitPDF.add_command(label="Supprimer le document", command=self.ActionSupPDF)
            self.FrmPDF.CanvasDoc.bind("<Button-3>", self.AffichMenuClicDroitPDF)
            self.DocPDF = True
            self.FichierPDFOpen = ''

        self.lift(self.parent)

    def SupPDF(self, _):
        self.BtnSuppPDF.CanvasBtn.itemconfig(self.BtnSuppPDF.ImgCanvasBtn, image=self.BtnSuppPDF.ImgBtn[0])
        self.ActionSupPDF()

    def ActionSupPDF(self):
        if self.DocPDF:
            for widget in self.FrmPDF.Container.winfo_children():
                widget.destroy()
            self.FrmPDF.CanvasScale.destroy()
            self.NoPDF = NoPDF(self.CanvasSousMenu1, 'Media/FrmAjout/NoPDF/NoPDF2.jpg',
                               int(int(self.CanvasSousMenu1['width']) * 0.5),
                               int(int(self.CanvasSousMenu1['height']) * 0.5), self.RatioX, self.RatioY)
            ChangeCursor(self.NoPDF.CanvasImgNoPdf)
            self.NoPDF.CanvasImgNoPdf.bind('<ButtonRelease-1>', self.ChargePDF)
            self.DocPDF = False
            self.FichierPDFOpen = ''
            self.PathFilePDFToOpen = ''

    def SaveNewDoc(self, _):
        self.BtnOK.CanvasBtn.itemconfig(self.BtnOK.ImgCanvasBtn, image=self.BtnOK.ImgBtn[0])
        if self.EntryNom.EntryData.get() != '' and (self.PathFilePDFToOpen != '' or self.FichierPDFOpen != ''):
            NOcur = 0
            Rep = True
            if self.MainAppli.BaseEnCours == "CHIMIE":
                self.MainAppli.cur.execute("Select * from Docs where " + 'Titre = "' +
                                           self.EntryNom.EntryData.get() + '"')
                NOcur = len(self.MainAppli.cur.fetchall())
            elif self.MainAppli.BaseEnCours == "PHYS":
                self.MainAppli.curphys.execute("Select * from Docs where " + 'Titre = "' +
                                               self.EntryNom.EntryData.get() + '"')
                NOcur = len(self.MainAppli.curphys.fetchall())

            if NOcur > 0:
                Rep = tkMB.askyesno('Attention', 'Un document nommé "' + self.EntryNom.EntryData.get()
                                    + '" est déja présent dans la base de données, souhaitez-vous mettre à jour '
                                      'les données?', parent=self)
            if Rep:
                if NOcur > 0:
                    SQLRequet = "DELETE FROM Docs WHERE " + 'Titre = "' + self.EntryNom.EntryData.get() + '"'
                    if self.MainAppli.BaseEnCours == "CHIMIE":
                        self.MainAppli.cur.execute(SQLRequet)
                        self.MainAppli.DataBaseChimie.commit()
                    elif self.MainAppli.BaseEnCours == "PHYS":
                        self.MainAppli.curphys.execute(SQLRequet)
                        self.MainAppli.DataBasePhys.commit()

                Nom = self.EntryNom.EntryData.get()
                NomSave = ModifString(self.EntryNom.EntryData.get())
                LNoms = []
                if self.MainAppli.BaseEnCours == "CHIMIE":
                    self.MainAppli.cur.execute("Select Titre from Docs")
                    LNoms = self.MainAppli.cur.fetchall()
                elif self.MainAppli.BaseEnCours == "PHYS":
                    self.MainAppli.curphys.execute("Select Titre from Docs")
                    LNoms = self.MainAppli.curphys.fetchall()
                Ocur = False
                for i in range(len(LNoms)):
                    if ModifString(LNoms[i][0]) == NomSave:
                        Ocur = True
                        break
                if Ocur:
                    NomSave = ModifString(NomSave + str(datetime.now()))

                PDF = ''
                if self.PathFilePDFToOpen != '':
                    PDF = NomSave
                    if self.MainAppli.BaseEnCours == "CHIMIE":
                        shutil.copy(self.PathFilePDFToOpen, 'Datas/DocsPDFChim/' + PDF + '.pdf')
                    elif self.MainAppli.BaseEnCours == "PHYS":
                        shutil.copy(self.PathFilePDFToOpen, 'Datas/DocsPDFPhys/' + PDF + '.pdf')
                elif self.ActionModifTitre:
                    if self.FichierPDFOpen != '':
                        PDF = NomSave
                        if self.MainAppli.BaseEnCours == "CHIMIE":
                            if not os.path.exists('Datas/DocsPDFChim/' + PDF + '.pdf'):
                                shutil.copy('Datas/DocsPDFChim/' + self.Doc[1] + '.pdf',
                                            'Datas/DocsPDFChim/' + PDF + '.pdf')
                        elif self.MainAppli.BaseEnCours == "PHYS":
                            if not os.path.exists('Datas/DocsPDFPhys/' + PDF + '.pdf'):
                                shutil.copy('Datas/DocsPDFPhys/' + self.Doc[1] + '.pdf',
                                            'Datas/DocsPDFPhys/' + PDF + '.pdf')
                elif self.FichierPDFOpen != '':
                    PDF = self.Doc[1]
                Cat = self.EntryCat.EntryData.get()

                Resume = self.ZoneText.get(0.0, tk.END)
                SaveResume = False
                for i in range(len(Resume)):
                    if Resume[i] != '' and Resume[i] != ' ' and Resume[i] != '\n':
                        SaveResume = True
                        break
                FileResume = ''
                if SaveResume:
                    FileResume = NomSave
                    if self.MainAppli.BaseEnCours == "CHIMIE":
                        File = open('Datas/DescriptDocChim/' + FileResume + '.txt', "w", encoding="utf-8")
                    else:
                        File = open('Datas/DescriptDocPhys/' + FileResume + '.txt', "w", encoding="utf-8")
                    File.write(Resume)
                    File.close()

                MotsCle = self.EntryMotCle.EntryData.get()
                data = [(Nom, PDF, FileResume, MotsCle, Cat)]
                if self.MainAppli.BaseEnCours == "CHIMIE":
                    self.MainAppli.cur.execute(
                        "INSERT INTO Docs(" + self.MainAppli.ListChampsTabDoc + ") VALUES(?,?,?,?,?)", data[0])

                    self.MainAppli.DataBaseChimie.commit()
                    self.MainAppli.SaveListModifDTB('Chimie', self.TextAction + Nom)
                    self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabDoc +
                                               " from Docs order by Titre")
                    self.MainAppli.ListDocs = self.MainAppli.cur.fetchall()
                elif self.MainAppli.BaseEnCours == "PHYS":
                    self.MainAppli.curphys.execute(
                        "INSERT INTO Docs(" + self.MainAppli.ListChampsTabDoc + ") VALUES(?,?,?,?,?)", data[0])
                    self.MainAppli.DataBasePhys.commit()
                    self.MainAppli.SaveListModifDTB('Physique', self.TextAction + Nom)
                    self.MainAppli.curphys.execute("select " + self.MainAppli.ListChampsTabDoc +
                                                   " from Docs order by Titre")
                    self.MainAppli.ListDocs = self.MainAppli.curphys.fetchall()

                if PDF != self.DocPDFInit and not self.ActionModifTitre and self.DocPDFInit != '':
                    if self.MainAppli.BaseEnCours == "CHIMIE":
                        if os.path.exists('Datas/DocsPDFChim/' + self.DocPDFInit + '.pdf'):
                            os.remove('Datas/DocsPDFChim/' + self.DocPDFInit + '.pdf')
                    else:
                        if os.path.exists('Datas/DocsPDFPhys/' + self.DocPDFInit + '.pdf'):
                            os.remove('Datas/DocsPDFPhys/' + self.DocPDFInit + '.pdf')

                if FileResume != self.FileResumeInit and not self.ActionModifTitre and self.FileResumeInit != '':
                    if self.MainAppli.BaseEnCours == "CHIMIE":
                        if os.path.exists('Datas/DescriptDocChim/' + self.FileResumeInit + '.txt'):
                            os.remove('Datas/DescriptDocChim/' + self.FileResumeInit + '.txt')
                    else:
                        if os.path.exists('Datas/DescriptDocPhys/' + self.FileResumeInit + '.txt'):
                            os.remove('Datas/DescriptDocPhys/' + self.FileResumeInit + '.txt')

                if self.MainAppli.NAction == 404:
                    if self.MainAppli.OldNAction == 4:
                        self.MainAppli.ChargeListProduits(self.MainAppli.ListDocs)
                        self.MainAppli.AffichEtagProduits(self.MainAppli.ListDocs)
                    elif self.MainAppli.OldNAction == 4011:
                        self.MainAppli.NAction = 401
                        self.MainAppli.ActionRecherche()
                    elif self.MainAppli.OldNAction == 4022:
                        self.MainAppli.AffichListDocCat(self.MainAppli.NSCatselected)
                else:
                    self.MainAppli.ChargeListProduits(self.MainAppli.ListDocs)
                    self.MainAppli.AffichEtagProduits(self.MainAppli.ListDocs)

                try:
                    self.MainAppli.IndexElt = self.MainAppli.ListNomProd.index(Nom)
                    self.MainAppli.FrmDoc.SelectDoc(self.MainAppli.IndexElt)
                except:
                    pass
                self.CacheFrmAjout(_)
            else:
                self.lift()
        else:
            tkMB.showwarning('Attention', "Veuillez ajouter un document et indiquer son titre!", parent=self)
            self.lift()

    def ModifCat(self, _):
        Cat = []
        if self.MainAppli.BaseEnCours == "CHIMIE":
            self.MainAppli.cur.execute('SELECT Cat'
                                       ' FROM Docs WHERE Cat LIKE \"%' + self.EntryCat.EntryData.get() +
                                       '%\" order by Cat')
            Cat = self.MainAppli.cur.fetchall()
        elif self.MainAppli.BaseEnCours == "PHYS":
            self.MainAppli.curphys.execute('SELECT Cat'
                                           ' FROM Docs WHERE Cat LIKE \"%' +
                                           self.EntryCat.EntryData.get() + '%\" order by Cat')
            Cat = self.MainAppli.curphys.fetchall()
        if len(Cat) > 0:
            self.EntryCat.Data.set(Cat[0][0])

    def ModifTitre(self, _):
        if self.EntryNom.EntryData.get() != self.NomInit:
            self.ActionModifTitre = True
        else:
            self.ActionModifTitre = False

    def OuvrePDF(self, _):
        self.ActionOuvrePDF()

    def ActionOuvrePDF(self):
        if self.PathFilePDFToOpen == '':
            if self.MainAppli.BaseEnCours == "CHIMIE":
                AffichPDF(self.EntryNom.EntryData.get(), 'Datas/DocsPDFChim/' + self.Doc + '.pdf',
                          self)
            elif self.MainAppli.BaseEnCours == "PHYS":
                AffichPDF(self.EntryNom.EntryData.get(), 'Datas/DocsPDFPhys/' + self.Doc + '.pdf',
                          self)
        else:
            AffichPDF(self.EntryNom.EntryData.get(), self.PathFilePDFToOpen, self)

    def AffichMenuClicDroitPDF(self, event):
        self.MenuClicDroitPDF.post(event.x_root, event.y_root)

    def ClosePDF(self):
        self.MainAppli.parent.focus_force()
        self.MainAppli.FrmLift()
        self.focus_force()

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.ImgCanvasBtnQuit, image=self.MainAppli.ImgBtnQuit[0])

    def CacheFrmAjout(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.ListBtnActionV[2].CanvasBtn.itemconfig(self.MainAppli.ListBtnActionV[2].ImgCanvasBtn,
                                                              image=self.MainAppli.ListBtnActionV[2].ImgBtn[0])
        self.destroy()
        if self.MainAppli.OldNAction != 0:
            self.MainAppli.NAction = self.MainAppli.OldNAction
        else:
            self.MainAppli.NAction = 4
        self.MainAppli.MAJInfo()
        self.MainAppli.parent.lift()
        self.MainAppli.FrmLift()
        self.MainAppli.ModifEnCours = False
