from AppliDef import *
from FrmInfoProdMat import InfoMatChim, InfoProd
from FrmZoom import FrmZoomDoc


class FrmAjoutTP(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.MenuClicDroitTabMat = []
        self.ListBoxMats = None
        self.ListMats = []
        self.CanvasBoite = None
        self.EntryMat = None
        self.IndexElt = None
        self.NomMat = None
        self.TitreStock = None
        self.TitreFournisseur = None
        self.BtnMoins = None
        self.CanvasEtiqPrix = None
        self.ImgFournisseur = None
        self.ImgCanvasImgEtiqMat = None
        self.CanvasImgEtiqMat = None
        self.ImgEtiqMat = []
        self.BtnAnnul2 = None
        self.BtnOK2 = None
        self.ListeLieu = None
        self.Lieu = None
        self.LieuListe = []
        self.BtnPlus = None
        self.QuantMat = None
        self.ListMatTP = [["", "", ""]]
        self.ListProdTP = [["", "", ""]]
        self.ListSolTP = [["", "", "", ""]]
        self.ListMelSolTP = None
        self.ListMelSolvantTP = None
        self.NlineMat = 1
        self.NColMat = 3
        self.NlineProd = 1
        self.NColProd = 3
        self.NlineSol = 1
        self.NColSol = 4
        self.NlineMelSol = 1
        self.NColMelSol = 5
        self.NlineMelSolvant = 1
        self.NColMelSolvant = 5
        self.TabMat = None
        self.TabProd = None
        self.TitreMat = None
        self.TitreQuant = None
        self.LinePar = None
        self.WindowListeLieu = None
        self.ModifenCours = False
        self.ModifTPenCours = False
        self.InfoMat = None
        self.LineSelect = 0
        self.MenuClicDroitTabProd = []
        self.EntryProd = None
        self.InfoProd = None
        self.UnitListe = []
        self.ListeUnit = None
        self.WindowListeUnit = None
        self.Unit = None
        self.EntryQuant = None
        self.ListProds = None
        self.ListBoxProd = None
        self.TitreProd = None
        self.MenuClicDroitTabSol = []
        self.TabSol = None
        self.EntrySolut = None
        self.TitreSolut = None
        self.InfoSolut = None
        self.TitreConc = None
        self.ListBoxSolut = None
        self.EntryConc = None
        self.UnitConc = None
        self.UnitQuant = None
        self.InfoSolvant = None
        self.ListSolvant = []
        self.ListSolvants = []
        self.ListBoxSolvant = None
        self.TitreSolvant = None
        self.EntrySolvant = None
        self.ListSolut2 = []
        self.TabMelSol = None
        self.MenuClicDroitTabMelSol = []
        self.TitreSolut2 = None
        self.EntrySolut2 = None
        self.ListBoxSolut2 = None
        self.EntryConc2 = None
        self.UnitConc2 = None
        self.TitreConc2 = None
        self.TitreSolvant2 = None
        self.EntrySolvant2 = None
        self.ListBoxSolvant2 = None
        self.MenuClicDroitTabMelSolvant = []
        self.TabMelSolvant = None
        self.ListMat = None
        self.ListProd = None
        self.ListSol = None
        self.PathFilePDFToOpen = ''
        self.ActionModifTitre = False
        self.FrmVisuPDF = None
        self.DocPDFInit = ''

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmAjout)

        coefY = float(ConfigResolution(self.MainAppli.Nconfig, 'YTitreFrm', self.MainAppli.curSave))

        self.EntryTitre = EntryData(self.CanvasFrmFond, int(self.SX * 0.03),
                                    int(self.SX * 0.5), int(self.SY * 0.08), tk.CENTER,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 10, 'bold', 0))
        self.EntryTitre.EntryData.bind('<KeyRelease>', self.ModifTitre)

        self.ClasseListe = self.MainAppli.ListClasses
        self.FichierPDFAOuvrir = ''
        Cat = ''
        if self.MainAppli.ModifEnCours:
            if self.MainAppli.NAction == 3011:
                self.TP = self.MainAppli.ListRecherch[self.MainAppli.IndexElt]
            elif self.MainAppli.NAction == 3022:
                self.TP = self.MainAppli.ListTPCat[self.MainAppli.IndexElt]
            else:
                self.TP = self.MainAppli.ListTPs[self.MainAppli.IndexElt]
            self.TitreTP = self.TP[0]
            textClasse = self.TP[2]
            self.EntryTitre.Data.set(self.TitreTP)
            textlabelTag = 'Modifier un TP de chimie'
            if self.TP[1] is not None and self.TP[1] != '':
                self.FichierPDFAOuvrir = 'Datas/PDFTPChim/' + self.TP[1] + '.pdf'
                self.DocPDFInit = self.TP[1]
            if self.TP[3] is not None and self.TP[3] != '':
                Cat = self.TP[3]
        else:
            self.TitreTP = ''
            self.EntryTitre.Data.set('Titre du TP')
            textlabelTag = 'Ajouter un TP de chimie'
            textClasse = self.ClasseListe[0]
            Cat = ''
        self.EntryTitre.EntryData.config(justify='center')

        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, textlabelTag, '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * coefY), tk.NW)

        self.TitreClasse = self.CanvasFrmFond.create_text(
            int(self.SX * 0.01), int(self.SY * 0.045), text='Classe',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.Classe = tk.StringVar()
        self.Classe.set(textClasse)
        self.ListeClasse = ListeDeroulante(self.CanvasFrmFond, int(self.SX * 0.02), textvariable=self.Classe,
                                           values=self.ClasseListe)
        self.CanvasFrmFond.create_window(int(self.SX * 0.01), int(self.SY * 0.07), anchor=tk.NW,
                                         window=self.ListeClasse)

        self.CanvasFrmFond.create_text(
            int(self.SX * 0.01), int(self.SY * 0.975), text='Catégorie :',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.EntryCat = EntryData(self.CanvasFrmFond, int(self.SX * 0.028),
                                  int(self.SX * 0.07), int(self.SY * 0.975), tk.W,
                                  AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryCat.Data.set(Cat)
        self.EntryCat.EntryData.bind('<Return>', self.ModifCat)

        self.BtnImportPDF = BtnAction(self.CanvasFrmFond, int(self.SX * 0.987), int(self.SY * 0.055), self.RatioX,
                                      self.RatioY, 'Media/FrmAjout/BtnPDF/')
        self.BtnImportPDF.CanvasBtn.bind('<ButtonRelease-1>', self.ChargePDF)

        self.BtnVisuPDF = BtnAction(self.CanvasFrmFond, int(self.SX * 0.987), int(self.SY * 0.1), self.RatioX,
                                    self.RatioY, 'Media/FrmAjout/BtnPDFvisuel/')
        self.BtnVisuPDF.CanvasBtn.bind('<ButtonRelease-1>', self.VisuPDF)
        self.BtnVisuPDF.CanvasBtn.bind('<ButtonPress-1>', self.PressBtnVisuPDF)
        if self.FichierPDFAOuvrir == "":
            self.BtnVisuPDF.CanvasBtn.itemconfig(self.BtnVisuPDF.ImgCanvasBtn, image=self.BtnVisuPDF.ImgBtn[2])
            ChangeCursor2(self.BtnVisuPDF.CanvasBtn)

        self.CanvasMenu1 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.8), int(self.SX * 0.003), int(self.SY * 0.15), tk.NW)

        self.AffichMat()

        self.CanvasMenu2 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.8), int(self.SX * 0.5), int(self.SY * 0.15), tk.N)

        self.AffichProd()

        self.CanvasMenu3 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.8), int(self.SX * 0.832), int(self.SY * 0.15), tk.N)

        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Solutions du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)

        self.ImgBtnSuiv, wsize, hsize, self.CanvasBtnSuiv, self.ImgCanvasBtnSuiv = CanInWindow(
            'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.99), int(self.SY * 0.161), 0)
        self.ImgBtnRetour, wsize, hsize, self.CanvasBtnRetour, self.ImgCanvasBtnRetour = CanInWindow(
            'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.98), int(self.SY * 0.161), 2)

        ChangeCursor(self.CanvasBtnSuiv)
        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSol)

        if self.MainAppli.ModifEnCours:
            self.MainAppli.cur.execute("SELECT " + "SOLUTE, SOLVANT, CONCENTRATION, QUANTITE, SOLUTE2, CONCENTRATION2, "
                                                   "SOLVANT2" +
                                       " FROM TP WHERE TITRE = \"" + self.TitreTP + "\" order by SOLUTE")
            self.ListSol = self.MainAppli.cur.fetchall()
            self.ActionAffichMelSolvant()
            self.ActionAffichMelSol()
            self.ActionAffichSol()
            self.TextAction = 'Mise à jour - TP - '
        else:
            self.ActionAffichSol()
            self.TextAction = 'Ajout - TP - '

        self.BtnOK = BtnAction(self.CanvasFrmFond, int(self.SX * 0.962), int(self.SY * 0.975), self.RatioX * 0.15,
                               self.RatioX * 0.15, 'Media/FrmAjout/BtnOK/')
        self.BtnAnnul = BtnAction(self.CanvasFrmFond, int(self.SX * 0.985), int(self.SY * 0.975), self.RatioX * 0.15,
                                  self.RatioX * 0.15, 'Media/FrmAjout/BtnAnnul/')
        ChangeCursor(self.BtnAnnul.CanvasBtn)
        ChangeCursor(self.BtnOK.CanvasBtn)
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.CacheFrmAjout)
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.SaveNewTP)

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)

        self.CanvasFrmFond.pack()

    def AffichMat(self):
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Matériel du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.002), tk.NW)

        if self.MainAppli.ModifEnCours:
            self.MainAppli.cur.execute("SELECT " + "MATERIEL, QUANTITE, LIEU" +
                                       " FROM TP WHERE TITRE = \"" + self.TitreTP + "\" order by MATERIEL")
            self.ListMat = self.MainAppli.cur.fetchall()
            nl = 0
            for i in range(len(self.ListMat)):
                if self.ListMat[i][0] != '' and self.ListMat[i][0] is not None:
                    nl = nl + 1
            self.NlineMat = nl + 1

            self.TabMat = TableauMain(self.CanvasMenu1.CanvasMenu, self.NlineMat, self.NColMat,
                                      ['Désignation', 'Quantité', 'Lieu'], [0.079, 0.02, 0.02],
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

            nl = 0
            self.ListMatTP = []
            for i in range(len(self.ListMat)):
                if self.ListMat[i][0] != '' and self.ListMat[i][0] is not None:
                    for j in range(3):
                        self.TabMat.TabLabels[nl][j]['text'] = self.ListMat[i][j]
                    self.ListMatTP.append([self.ListMat[i][0], self.ListMat[i][1], self.ListMat[i][2]])
                    nl = nl + 1
            self.ListMatTP.append(['', '', ''])
        else:
            self.TabMat = TableauMain(self.CanvasMenu1.CanvasMenu, self.NlineMat, self.NColMat,
                                      ['Désignation', 'Quantité', 'Lieu'], [0.079, 0.02, 0.02],
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))
        self.AjoutMenuMat()

    def ReAffichMat(self):
        self.TabMat = TableauMain(self.CanvasMenu1.CanvasMenu, self.NlineMat, self.NColMat,
                                  ['Désignation', 'Quantité', 'Lieu'], [0.079, 0.02, 0.02],
                                  AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                  AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))
        self.AjoutMenuMat()
        for r in range(self.NlineMat):
            self.TabMat.TabLabels[r][0]['text'] = self.ListMatTP[r][0]
            self.TabMat.TabLabels[r][1]['text'] = self.ListMatTP[r][1]
            self.TabMat.TabLabels[r][2]['text'] = self.ListMatTP[r][2]

    def AjoutMenuMat(self):
        self.MenuClicDroitTabMat = []
        for r in range(self.NlineMat):
            ListMenu = []
            for i in range(self.NColMat):
                ListMenu.append(tk.Menu(self.TabMat.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabMat, j)

                self.TabMat.TabLabels[r][i].bind("<Button-3>", GestEvt)
            self.MenuClicDroitTabMat.append(ListMenu)

        for r in range(self.TabMat.NLine):
            if r == self.TabMat.NLine - 1:
                self.MenuClicDroitTabMat[r][0].add_command(label="Ajouter un matériel", command=self.AjoutMateriel)
            else:
                self.MenuClicDroitTabMat[r][0].add_command(label="Modifier le matériel", command=self.ModifMateriel)
                self.MenuClicDroitTabMat[r][0].add_command(label="Supprimer le matériel", command=self.SupMateriel)

    def AffichProd(self):

        LabelInCanvas(self.CanvasMenu2.CanvasMenu, 'Produits chimiques du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.002), tk.NW)

        if self.MainAppli.ModifEnCours:
            self.MainAppli.cur.execute("SELECT " + "PRODUIT, QUANTITE, UNITMES" +
                                       " FROM TP WHERE TITRE = \"" + self.TitreTP + "\" order by PRODUIT")
            self.ListProd = self.MainAppli.cur.fetchall()

            nl = 0
            for i in range(len(self.ListProd)):
                if self.ListProd[i][0] != '' and self.ListProd[i][0] is not None:
                    nl = nl + 1
            self.NlineProd = nl + 1

            self.TabProd = TableauMain(self.CanvasMenu2.CanvasMenu, self.NlineProd, self.NColProd,
                                       ['Désignation', 'Quantité/Gr', 'Unit. Mes.'], [0.079, 0.02, 0.02],
                                       AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                       AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

            nl = 0
            self.ListProdTP = []
            for i in range(len(self.ListProd)):
                if self.ListProd[i][0] != '' and self.ListProd[i][0] is not None:
                    for j in range(3):
                        self.TabProd.TabLabels[nl][j]['text'] = self.ListProd[i][j]
                    self.ListProdTP.append([self.ListProd[i][0], self.ListProd[i][1], self.ListProd[i][2]])
                    nl = nl + 1
            self.ListProdTP.append(['', '', ''])
        else:
            self.TabProd = TableauMain(self.CanvasMenu2.CanvasMenu, self.NlineProd, self.NColProd,
                                       ['Désignation', 'Quantité/Gr', 'Unit. Mes.'], [0.079, 0.02, 0.02],
                                       AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                       AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.AjoutMenuProd()

    def ReAffichProd(self):
        self.TabProd = TableauMain(self.CanvasMenu2.CanvasMenu, self.NlineProd, self.NColProd,
                                   ['Désignation', 'Quantité/Gr', 'Unit. Mes.'], [0.079, 0.02, 0.02],
                                   AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                   AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.AjoutMenuProd()
        for r in range(self.NlineProd):
            self.TabProd.TabLabels[r][0]['text'] = self.ListProdTP[r][0]
            self.TabProd.TabLabels[r][1]['text'] = self.ListProdTP[r][1]
            self.TabProd.TabLabels[r][2]['text'] = self.ListProdTP[r][2]

    def AjoutMenuProd(self):
        self.MenuClicDroitTabProd = []
        for r in range(self.NlineProd):
            ListMenu = []
            for i in range(self.NColProd):
                ListMenu.append(tk.Menu(self.TabProd.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabProd, j)

                self.TabProd.TabLabels[r][i].bind("<Button-3>", GestEvt)
            self.MenuClicDroitTabProd.append(ListMenu)

        for r in range(self.TabProd.NLine):
            if r == self.TabProd.NLine - 1:
                self.MenuClicDroitTabProd[r][0].add_command(label="Ajouter un produit chimique",
                                                            command=self.AjoutProd)
            else:
                self.MenuClicDroitTabProd[r][0].add_command(label="Modifier le produit chimique",
                                                            command=self.ModifProduit)
                self.MenuClicDroitTabProd[r][0].add_command(label="Supprimer le produit chimique",
                                                            command=self.SupProd)

    def AffichMelSol(self, _):
        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSolvant)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[0])
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[1])
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.AffichSol)
        ChangeCursor(self.CanvasBtnRetour)
        if self.ListMelSolTP is None:
            self.ListMelSolTP = [["", "", "", "", ""]]
            self.ActionAffichMelSol()
        else:
            self.ReAffichMelSol()

    def ActionAffichMelSol(self):
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Mélanges de solutions du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)

        if self.MainAppli.ModifEnCours:
            nl = 0
            for i in range(len(self.ListSol)):
                if self.ListSol[i][4] != '' and self.ListSol[i][4] is not None \
                        and (self.ListSol[i][6] == '' or self.ListSol[i][6] is None):
                    nl = nl + 1
            self.NlineMelSol = nl + 1
            self.TabMelSol = TableauMain(self.CanvasMenu3.CanvasMenu, self.NlineMelSol, self.NColMelSol,
                                         ['Soluté 1', 'C1 (mol/L)', 'Soluté 2', 'C2 (mol/L)', 'Q/Gr (mL)'],
                                         [0.0305, 0.02, 0.0305, 0.02, 0.0175],
                                         AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                         AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

            nl = 0
            self.ListMelSolTP = []
            for i in range(len(self.ListSol)):
                if self.ListSol[i][4] != '' and self.ListSol[i][4] is not None \
                        and (self.ListSol[i][6] == '' or self.ListSol[i][6] is None):
                    self.TabMelSol.TabLabels[nl][0]['text'] = self.ListSol[i][0]
                    self.TabMelSol.TabLabels[nl][1]['text'] = self.ListSol[i][2]
                    self.TabMelSol.TabLabels[nl][2]['text'] = self.ListSol[i][4]
                    self.TabMelSol.TabLabels[nl][3]['text'] = self.ListSol[i][5]
                    self.TabMelSol.TabLabels[nl][4]['text'] = self.ListSol[i][3]
                    self.ListMelSolTP.append([self.ListSol[i][0], self.ListSol[i][2], self.ListSol[i][4],
                                              self.ListSol[i][5], self.ListSol[i][3]])
                    nl = nl + 1
            self.ListMelSolTP.append(['', '', '', '', ''])

        else:
            self.ListMelSolTP = [['', '', '', '', '']]
            self.TabMelSol = TableauMain(self.CanvasMenu3.CanvasMenu, self.NlineMelSol, self.NColMelSol,
                                         ['Soluté 1', 'C1 (mol/L)', 'Soluté 2', 'C2 (mol/L)', 'Q/Gr (mL)'],
                                         [0.0305, 0.02, 0.0305, 0.02, 0.0175],
                                         AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                         AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.AjoutMenuMelSol()

    def ReAffichMelSol(self):
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Mélanges de solutions du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)
        self.TabMelSol = TableauMain(self.CanvasMenu3.CanvasMenu, self.NlineMelSol, self.NColMelSol,
                                     ['Soluté 1', 'C1 (mol/L)', 'Soluté 2', 'C2 (mol/L)', 'Q/Gr (mL)'],
                                     [0.0305, 0.02, 0.0305, 0.02, 0.0175],
                                     AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                     AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.AjoutMenuMelSol()
        for r in range(self.NlineMelSol):
            for i in range(5):
                self.TabMelSol.TabLabels[r][i]['text'] = self.ListMelSolTP[r][i]

    def AjoutMenuMelSol(self):
        self.MenuClicDroitTabMelSol = []
        for r in range(self.NlineMelSol):
            ListMenu = []
            for i in range(self.NColMelSol):
                ListMenu.append(tk.Menu(self.TabMelSol.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabMelSol, j)

                self.TabMelSol.TabLabels[r][i].bind("<Button-3>", GestEvt)
            self.MenuClicDroitTabMelSol.append(ListMenu)

        for r in range(self.TabMelSol.NLine):
            if r == self.TabMelSol.NLine - 1:
                self.MenuClicDroitTabMelSol[r][0].add_command(label="Ajouter un mélange de solutions aqueuses",
                                                              command=self.AjoutMelSol)
            else:
                self.MenuClicDroitTabMelSol[r][0].add_command(label="Modifier le mélange",
                                                              command=self.ModifMelSol)
                self.MenuClicDroitTabMelSol[r][0].add_command(label="Supprimer le mélange",
                                                              command=self.SupMelSol)

    def AjoutMelSol(self):
        self.ModifTPenCours = True
        for widget in self.CanvasMenu1.CanvasMenu.winfo_children():
            widget.destroy()
        for widget in self.CanvasMenu2.CanvasMenu.winfo_children():
            widget.destroy()
        LabelInCanvas(self.CanvasMenu2.CanvasMenu, 'Ajouter un mélange de solutions aqueuses à la fiche TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.002), tk.NW)

        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.Pass)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[2])
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.Pass)
        ChangeCursor2(self.CanvasBtnRetour)
        ChangeCursor2(self.CanvasBtnSuiv)

        self.TitreSolut = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.05), text="Sélection d'un premier soluté",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntrySolut = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.108),
                                    int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                    int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.09), tk.CENTER,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntrySolut.EntryData.config(justify='center')
        self.EntrySolut.EntryData.bind('<KeyRelease>', self.ModifSolut)

        self.ListBoxSolut = Scrollable_ListBox(self.CanvasMenu2.CanvasMenu,
                                               int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                                               int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.12),
                                               int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.158),
                                               int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.014))

        self.ListBoxSolut.ListBox.bind('<<ListboxSelect>>', self.OnSelectListBox)

        self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabProd + " from PRODUITS order by NOMS")
        self.ListProds = self.MainAppli.cur.fetchall()
        self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabProd + " from PRODUITS order by NOMS")
        self.ListSolut2 = self.MainAppli.cur.fetchall()

        self.ListBoxSolut.ListBox.delete(0, tk.END)
        for i in range(len(self.ListProds)):
            self.ListBoxSolut.ListBox.insert(tk.END, self.ListProds[i][0])
        self.ListBoxSolut.ListBox.selection_set(0)
        self.EntrySolut.Data.set(self.ListProds[0][0])
        self.AffichInfoSolut(self.ListProds[0])

        self.TitreConc = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.39),
            text="Sélection de la concentration du premier soluté",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryConc = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.025),
                                   int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
                                   int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.43), tk.W,
                                   AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryConc.Data.set('')
        self.EntryConc.EntryData.config(justify='center')
        self.UnitConc = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.3),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.43), text="mol/L",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        self.TitreSolut2 = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.48), text="Sélection d'un deuxième soluté",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntrySolut2 = EntryData(self.CanvasMenu2.CanvasMenu,
                                     int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.108),
                                     int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                     int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.52), tk.CENTER,
                                     AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntrySolut2.EntryData.config(justify='center')
        self.EntrySolut2.EntryData.bind('<KeyRelease>', self.ModifSolut2)

        self.ListBoxSolut2 = Scrollable_ListBox(self.CanvasMenu2.CanvasMenu,
                                                int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                                                int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.56),
                                                int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.158),
                                                int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.014))

        self.ListBoxSolut2.ListBox.bind('<<ListboxSelect>>', self.OnSelectListBox2)

        self.ListBoxSolut2.ListBox.delete(0, tk.END)
        for i in range(len(self.ListSolut2)):
            self.ListBoxSolut2.ListBox.insert(tk.END, self.ListSolut2[i][0])
        self.EntrySolut2.Data.set(self.ListSolut2[1][0])

        self.TitreConc2 = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.83),
            text="Sélection de la concentration du deuxième soluté",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryConc2 = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.025),
                                    int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
                                    int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.87), tk.W,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryConc2.Data.set('')
        self.EntryConc2.EntryData.config(justify='center')
        self.UnitConc2 = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.3),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.87), text="mol/L",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        self.TitreQuant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.92), text='Sélection de la quantité (/groupe de TP)',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryQuant = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.025),
                                    int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
                                    int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.96), tk.W,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryQuant.Data.set('')
        self.EntryQuant.EntryData.config(justify='center')
        self.UnitQuant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.3),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.96), text="mL",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        self.BtnOK2 = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.88),
                                int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK2.CanvasBtn.bind('<ButtonRelease-1>', self.ValidAjoutMelSol)
        self.BtnAnnul2 = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.95),
                                   int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                   self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul2.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulAjoutMelSol)

    def ModifMelSol(self):
        self.ModifenCours = True
        self.AjoutMelSol()
        self.EntrySolut.Data.set(self.TabMelSol.TabLabels[self.LineSelect][0]['text'])
        self.EntryConc.Data.set(self.TabMelSol.TabLabels[self.LineSelect][1]['text'])
        self.EntrySolut2.Data.set(self.TabMelSol.TabLabels[self.LineSelect][2]['text'])
        self.EntryConc2.Data.set(self.TabMelSol.TabLabels[self.LineSelect][3]['text'])
        self.EntryQuant.Data.set(self.TabMelSol.TabLabels[self.LineSelect][4]['text'])
        self.ActionModifSolut()
        self.ActionModifSolut2()

    def SupMelSol(self):
        del self.ListMelSolTP[self.LineSelect]
        self.EffaceMenu3()
        self.NlineMelSol = self.NlineMelSol - 1
        self.ReAffichMelSol()

    def ValidAjoutMelSol(self, _):
        self.BtnOK2.CanvasBtn.itemconfig(self.BtnOK2.ImgCanvasBtn, image=self.BtnOK2.ImgBtn[0])
        if self.EntrySolut.EntryData.get() != '' and self.EntrySolut2.EntryData.get() != '' and \
                self.EntryConc.EntryData.get() != '' and self.EntryConc2.EntryData.get() != '' and \
                self.EntryQuant.EntryData.get():
            if not self.ModifenCours:
                Nline = self.NlineMelSol - 1
            else:
                Nline = self.LineSelect
            self.ListMelSolTP[Nline][0] = self.EntrySolut.EntryData.get()
            self.TabMelSol.TabLabels[Nline][0]['text'] = self.EntrySolut.EntryData.get()
            self.ListMelSolTP[Nline][1] = self.EntryConc.EntryData.get()
            self.TabMelSol.TabLabels[Nline][1]['text'] = self.EntryConc.EntryData.get()
            self.ListMelSolTP[Nline][2] = self.EntrySolut2.EntryData.get()
            self.TabMelSol.TabLabels[Nline][2]['text'] = self.EntrySolut2.EntryData.get()
            self.ListMelSolTP[Nline][3] = self.EntryConc2.EntryData.get()
            self.TabMelSol.TabLabels[Nline][3]['text'] = self.EntryConc2.EntryData.get()
            self.ListMelSolTP[Nline][4] = self.EntryQuant.EntryData.get()
            self.TabMelSol.TabLabels[Nline][4]['text'] = self.EntryQuant.EntryData.get()

            if not self.ModifenCours:
                self.TabMelSol.AjoutLine()
                self.NlineMelSol = self.NlineMelSol + 1
                self.ListMelSolTP.append(['', '', '', '', ''])
                self.AjoutMenuMelSol()

            self.AnnulAjoutMelSol(_)
        else:
            tkMB.showwarning('Attention', "Veuillez choisir les solutés, indiquer les concentrations et "
                                          "la quantité par groupe!", parent=self)
            self.lift()

    def AffichMelSolvant(self, _):
        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSol)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[1])
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
        if self.ListMelSolvantTP is None:
            self.ListMelSolvantTP = [["", "", "", "", ""]]
            self.ActionAffichMelSolvant()
        else:
            self.ReAffichMelSolvant()

    def ActionAffichMelSolvant(self):
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Mélanges de solvants du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)

        if self.MainAppli.ModifEnCours:
            nl = 0
            for i in range(len(self.ListSol)):
                if self.ListSol[i][6] != '' and self.ListSol[i][6] is not None:
                    nl = nl + 1
            self.NlineMelSolvant = nl + 1
            self.TabMelSolvant = TableauMain(self.CanvasMenu3.CanvasMenu, self.NlineMelSolvant, self.NColMelSolvant,
                                             ['Solvant 1', 'C1 (%)', 'Solvant 2', 'C2 (%)', 'Q/Gr (mL)'],
                                             [0.0305, 0.019, 0.0305, 0.019, 0.0175],
                                             AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                             AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

            nl = 0
            self.ListMelSolvantTP = []
            for i in range(len(self.ListSol)):
                if self.ListSol[i][6] != '' and self.ListSol[i][6] is not None:
                    self.TabMelSolvant.TabLabels[nl][0]['text'] = self.ListSol[i][1]
                    self.TabMelSolvant.TabLabels[nl][1]['text'] = self.ListSol[i][2]
                    self.TabMelSolvant.TabLabels[nl][2]['text'] = self.ListSol[i][6]
                    self.TabMelSolvant.TabLabels[nl][3]['text'] = self.ListSol[i][5]
                    self.TabMelSolvant.TabLabels[nl][4]['text'] = self.ListSol[i][3]
                    self.ListMelSolvantTP.append([self.ListSol[i][1], self.ListSol[i][2], self.ListSol[i][6],
                                                  self.ListSol[i][5], self.ListSol[i][3]])
                    nl = nl + 1
            self.ListMelSolvantTP.append(['', '', '', '', ''])
        else:
            self.TabMelSolvant = TableauMain(self.CanvasMenu3.CanvasMenu, self.NlineMelSolvant, self.NColMelSolvant,
                                             ['Solvant 1', 'C1 (%)', 'Solvant 2', 'C2 (%)', 'Q/Gr (mL)'],
                                             [0.0305, 0.019, 0.0305, 0.019, 0.0175],
                                             AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                             AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.AjoutMenuMelSolvant()

    def ReAffichMelSolvant(self):
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Mélanges de solvants du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)
        self.TabMelSolvant = TableauMain(self.CanvasMenu3.CanvasMenu, self.NlineMelSolvant, self.NColMelSolvant,
                                         ['Solvant 1', 'C1 (%)', 'Solvant 2', 'C2 (%)', 'Q/Gr (mL)'],
                                         [0.0305, 0.019, 0.0305, 0.019, 0.0175],
                                         AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                         AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.AjoutMenuMelSolvant()
        for r in range(self.NlineMelSolvant):
            for i in range(5):
                self.TabMelSolvant.TabLabels[r][i]['text'] = self.ListMelSolvantTP[r][i]

    def AjoutMenuMelSolvant(self):
        self.MenuClicDroitTabMelSolvant = []
        for r in range(self.NlineMelSolvant):
            ListMenu = []
            for i in range(self.NColMelSolvant):
                ListMenu.append(tk.Menu(self.TabMelSolvant.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabMelSolvant, j)

                self.TabMelSolvant.TabLabels[r][i].bind("<Button-3>", GestEvt)
            self.MenuClicDroitTabMelSolvant.append(ListMenu)

        for r in range(self.TabMelSolvant.NLine):
            if r == self.TabMelSolvant.NLine - 1:
                self.MenuClicDroitTabMelSolvant[r][0].add_command(label="Ajouter un mélange de solvants",
                                                                  command=self.AjoutMelSolvant)
            else:
                self.MenuClicDroitTabMelSolvant[r][0].add_command(label="Modifier le mélange de solvants",
                                                                  command=self.ModifMelSolvant)
                self.MenuClicDroitTabMelSolvant[r][0].add_command(label="Supprimer le mélange de solvants",
                                                                  command=self.SupMelSolvant)

    def AjoutMelSolvant(self):
        self.ModifTPenCours = True
        for widget in self.CanvasMenu1.CanvasMenu.winfo_children():
            widget.destroy()
        for widget in self.CanvasMenu2.CanvasMenu.winfo_children():
            widget.destroy()
        LabelInCanvas(self.CanvasMenu2.CanvasMenu, 'Ajouter un mélange de solvants à la fiche TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.002), tk.NW)

        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.Pass)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[2])
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.Pass)
        ChangeCursor2(self.CanvasBtnRetour)
        ChangeCursor2(self.CanvasBtnSuiv)

        self.TitreSolvant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.05), text="Sélection d'un premier solvant",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntrySolvant = EntryData(self.CanvasMenu2.CanvasMenu,
                                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.108),
                                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.09), tk.CENTER,
                                      AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntrySolvant.EntryData.config(justify='center')
        self.EntrySolvant.EntryData.bind('<KeyRelease>', self.ModifSolvant)

        self.ListBoxSolvant = Scrollable_ListBox(self.CanvasMenu2.CanvasMenu,
                                                 int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                                                 int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.12),
                                                 int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.158),
                                                 int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.014))

        self.ListBoxSolvant.ListBox.bind('<<ListboxSelect>>', self.OnSelectListBoxSolvant)

        self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabProd + " from PRODUITS order by NOMS")
        self.ListSolvant = self.MainAppli.cur.fetchall()

        self.ListBoxSolvant.ListBox.delete(0, tk.END)
        self.ListSolvants = []
        for i in range(len(self.ListSolvant)):
            if self.ListSolvant[i][1] == "mL":
                self.ListSolvants.append(self.ListSolvant[i])
                self.ListBoxSolvant.ListBox.insert(tk.END, self.ListSolvant[i][0])

        self.ListBoxSolvant.ListBox.selection_set(0)
        self.EntrySolvant.Data.set(self.ListSolvants[0][0])
        self.AffichInfoSolvant(0)

        self.TitreConc = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.39),
            text="Sélection de la concentration du premier solvant",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryConc = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.025),
                                   int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
                                   int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.43), tk.W,
                                   AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryConc.Data.set('')
        self.EntryConc.EntryData.config(justify='center')
        self.UnitConc = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.3),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.43), text="% volumique",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        self.TitreSolvant2 = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.48), text="Sélection d'un deuxième solvant",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntrySolvant2 = EntryData(self.CanvasMenu2.CanvasMenu,
                                       int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.108),
                                       int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                       int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.52), tk.CENTER,
                                       AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))

        self.EntrySolvant2.EntryData.config(justify='center')
        self.EntrySolvant2.EntryData.bind('<KeyRelease>', self.ModifSolvant2)

        self.ListBoxSolvant2 = Scrollable_ListBox(self.CanvasMenu2.CanvasMenu,
                                                  int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                                                  int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.56),
                                                  int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.158),
                                                  int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.014))

        self.ListBoxSolvant2.ListBox.bind('<<ListboxSelect>>', self.OnSelectListBoxSolvant2)

        self.ListBoxSolvant2.ListBox.delete(0, tk.END)
        for i in range(len(self.ListSolvants)):
            self.ListBoxSolvant2.ListBox.insert(tk.END, self.ListSolvants[i][0])
        self.EntrySolvant2.Data.set(self.ListSolvants[1][0])

        self.TitreConc2 = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.83),
            text="Sélection de la concentration du deuxième soluté",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryConc2 = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.025),
                                    int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
                                    int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.87), tk.W,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryConc2.Data.set('')
        self.EntryConc2.EntryData.config(justify='center')
        self.UnitConc2 = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.3),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.87), text="% volumique",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        self.TitreQuant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.92), text='Sélection de la quantité (/groupe de TP)',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryQuant = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.025),
                                    int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
                                    int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.96), tk.W,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryQuant.Data.set('')
        self.EntryQuant.EntryData.config(justify='center')
        self.UnitQuant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.3),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.96), text="mL",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        self.BtnOK2 = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.88),
                                int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK2.CanvasBtn.bind('<ButtonRelease-1>', self.ValidAjoutMelSolvant)
        self.BtnAnnul2 = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.95),
                                   int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                   self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul2.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulAjoutMelSolvant)

    def ModifMelSolvant(self):
        self.ModifenCours = True
        self.AjoutMelSolvant()
        self.EntrySolvant.Data.set(self.TabMelSolvant.TabLabels[self.LineSelect][0]['text'])
        self.EntryConc.Data.set(self.TabMelSolvant.TabLabels[self.LineSelect][1]['text'])
        self.EntrySolvant2.Data.set(self.TabMelSolvant.TabLabels[self.LineSelect][2]['text'])
        self.EntryConc2.Data.set(self.TabMelSolvant.TabLabels[self.LineSelect][3]['text'])
        self.EntryQuant.Data.set(self.TabMelSolvant.TabLabels[self.LineSelect][4]['text'])
        self.ActionModifSolvant()
        self.ActionModifSolvant2()

    def SupMelSolvant(self):
        del self.ListMelSolvantTP[self.LineSelect]
        self.EffaceMenu3()
        self.NlineMelSolvant = self.NlineMelSolvant - 1
        self.ReAffichMelSolvant()

    def ValidAjoutMelSolvant(self, _):
        self.BtnOK2.CanvasBtn.itemconfig(self.BtnOK2.ImgCanvasBtn, image=self.BtnOK2.ImgBtn[0])
        if self.EntrySolvant.EntryData.get() != '' and self.EntrySolvant2.EntryData.get() != '' and \
                self.EntryConc.EntryData.get() != '' and self.EntryConc2.EntryData.get() != '' and \
                self.EntryQuant.EntryData.get():
            if not self.ModifenCours:
                Nline = self.NlineMelSolvant - 1
            else:
                Nline = self.LineSelect
            self.ListMelSolvantTP[Nline][0] = self.EntrySolvant.EntryData.get()
            self.TabMelSolvant.TabLabels[Nline][0]['text'] = self.EntrySolvant.EntryData.get()
            self.ListMelSolvantTP[Nline][1] = self.EntryConc.EntryData.get()
            self.TabMelSolvant.TabLabels[Nline][1]['text'] = self.EntryConc.EntryData.get()
            self.ListMelSolvantTP[Nline][2] = self.EntrySolvant2.EntryData.get()
            self.TabMelSolvant.TabLabels[Nline][2]['text'] = self.EntrySolvant2.EntryData.get()
            self.ListMelSolvantTP[Nline][3] = self.EntryConc2.EntryData.get()
            self.TabMelSolvant.TabLabels[Nline][3]['text'] = self.EntryConc2.EntryData.get()
            self.ListMelSolvantTP[Nline][4] = self.EntryQuant.EntryData.get()
            self.TabMelSolvant.TabLabels[Nline][4]['text'] = self.EntryQuant.EntryData.get()

            if not self.ModifenCours:
                self.TabMelSolvant.AjoutLine()
                self.NlineMelSolvant = self.NlineMelSolvant + 1
                self.ListMelSolvantTP.append(['', '', '', '', ''])
                self.AjoutMenuMelSolvant()

            self.AnnulAjoutMelSolvant(_)
        else:
            tkMB.showwarning('Attention', "Veuillez choisir les solvants, indiquer les concentrations et "
                                          "la quantité par groupe!", parent=self)
            self.lift()

    def AnnulAjoutMelSolvant(self, _):
        self.ModifTPenCours = False
        self.ModifenCours = False
        self.EffaceMenu1()
        self.ReAffichMat()
        self.EffaceMenu2()
        self.ReAffichProd()
        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSol)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[1])
        ChangeCursor(self.CanvasBtnSuiv)
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.Pass)
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
        ChangeCursor2(self.CanvasBtnRetour)

    def AffichSol(self, _):
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
        ChangeCursor2(self.CanvasBtnRetour)
        self.ReAffichSol()

    def ActionAffichSol(self):
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()

        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Solutions du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)

        if self.MainAppli.ModifEnCours:
            nl = 0
            for i in range(len(self.ListSol)):
                if self.ListSol[i][0] != '' and self.ListSol[i][0] is not None \
                        and (self.ListSol[i][4] == '' or self.ListSol[i][4] is None):
                    nl = nl + 1
            self.NlineSol = nl + 1
            self.TabSol = TableauMain(self.CanvasMenu3.CanvasMenu, self.NlineSol, self.NColSol,
                                      ['Soluté', 'Solvant', 'C (mol/L)', 'Q/Gr (mL)'], [0.06, 0.02, 0.02, 0.02],
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

            nl = 0
            self.ListSolTP = []
            for i in range(len(self.ListSol)):
                if self.ListSol[i][0] != '' and self.ListSol[i][0] is not None \
                        and (self.ListSol[i][4] == '' or self.ListSol[i][4] is None):
                    for j in range(4):
                        self.TabSol.TabLabels[nl][j]['text'] = self.ListSol[i][j]
                    self.ListSolTP.append(
                        [self.ListSol[i][0], self.ListSol[i][1], self.ListSol[i][2], self.ListSol[i][3]])
                    nl = nl + 1
            self.ListSolTP.append(['', '', '', ''])
        else:
            self.TabSol = TableauMain(self.CanvasMenu3.CanvasMenu, self.NlineSol, self.NColSol,
                                      ['Soluté', 'Solvant', 'C (mol/L)', 'Q/Gr (mL)'], [0.06, 0.02, 0.02, 0.02],
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.AjoutMenuSol()

    def ReAffichSol(self):
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()

        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Solutions du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)
        self.TabSol = TableauMain(self.CanvasMenu3.CanvasMenu, self.NlineSol, self.NColSol,
                                  ['Soluté', 'Solvant', 'C (mol/L)', 'Q/Gr (mL)'], [0.06, 0.02, 0.02, 0.02],
                                  AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                  AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.AjoutMenuSol()
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[0])
        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSol)
        ChangeCursor(self.CanvasBtnSuiv)
        for r in range(self.NlineSol):
            for i in range(4):
                self.TabSol.TabLabels[r][i]['text'] = self.ListSolTP[r][i]

    def AjoutMenuSol(self):
        self.MenuClicDroitTabSol = []

        for r in range(self.NlineSol):
            ListMenu = []
            for i in range(self.NColSol):
                ListMenu.append(tk.Menu(self.TabSol.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabSol, j)

                self.TabSol.TabLabels[r][i].bind("<Button-3>", GestEvt)
            self.MenuClicDroitTabSol.append(ListMenu)

        for r in range(self.TabSol.NLine):
            if r == self.TabSol.NLine - 1:
                self.MenuClicDroitTabSol[r][0].add_command(label="Ajouter une solution",
                                                           command=self.AjoutSol)
            else:
                self.MenuClicDroitTabSol[r][0].add_command(label="Modifier la solution",
                                                           command=self.ModifSol)
                self.MenuClicDroitTabSol[r][0].add_command(label="Supprimer la solution",
                                                           command=self.SupSol)

    def AjoutSol(self):
        self.ModifTPenCours = True
        for widget in self.CanvasMenu1.CanvasMenu.winfo_children():
            widget.destroy()
        for widget in self.CanvasMenu2.CanvasMenu.winfo_children():
            widget.destroy()
        LabelInCanvas(self.CanvasMenu2.CanvasMenu, 'Ajouter une solution aqueuse à la fiche TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.002), tk.NW)

        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.Pass)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[2])
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.Pass)
        ChangeCursor2(self.CanvasBtnRetour)
        ChangeCursor2(self.CanvasBtnSuiv)

        self.TitreSolut = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.05), text="Sélection d'un soluté",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntrySolut = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.108),
                                    int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                    int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.09), tk.CENTER,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntrySolut.EntryData.config(justify='center')
        self.EntrySolut.EntryData.bind('<KeyRelease>', self.ModifSolut)

        self.ListBoxSolut = Scrollable_ListBox(self.CanvasMenu2.CanvasMenu,
                                               int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                                               int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.12),
                                               int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.158),
                                               int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.017))

        self.ListBoxSolut.ListBox.bind('<<ListboxSelect>>', self.OnSelectListBox)

        self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabProd + " from PRODUITS order by NOMS")
        self.ListProds = self.MainAppli.cur.fetchall()
        self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabProd + " from PRODUITS order by NOMS")
        self.ListSolvant = self.MainAppli.cur.fetchall()

        self.ListBoxSolut.ListBox.delete(0, tk.END)
        for i in range(len(self.ListProds)):
            self.ListBoxSolut.ListBox.insert(tk.END, self.ListProds[i][0])
        self.ListBoxSolut.ListBox.selection_set(0)
        self.EntrySolut.Data.set(self.ListProds[0][0])
        self.AffichInfoSolut(self.ListProds[0])

        self.TitreSolvant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.435), text="Sélection d'un solvant",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntrySolvant = EntryData(self.CanvasMenu2.CanvasMenu,
                                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.108),
                                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.475), tk.CENTER,
                                      AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntrySolvant.EntryData.config(justify='center')
        self.EntrySolvant.EntryData.bind('<KeyRelease>', self.ModifSolvant)

        self.ListBoxSolvant = Scrollable_ListBox(self.CanvasMenu2.CanvasMenu,
                                                 int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                                                 int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.51),
                                                 int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.158),
                                                 int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.017))

        self.ListBoxSolvant.ListBox.bind('<<ListboxSelect>>', self.OnSelectListBoxSolvant)

        self.ListBoxSolvant.ListBox.delete(0, tk.END)
        self.ListBoxSolvant.ListBox.insert(tk.END, 'Eau')
        self.ListSolvants = []
        for i in range(len(self.ListSolvant)):
            if self.ListSolvant[i][1] == "mL":
                self.ListSolvants.append(self.ListSolvant[i])
                self.ListBoxSolvant.ListBox.insert(tk.END, self.ListSolvant[i][0])
        self.EntrySolvant.Data.set('Eau')

        self.TitreConc = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.82), text="Sélection de la concentration",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryConc = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.025),
                                   int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
                                   int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.86), tk.W,
                                   AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryConc.Data.set('')
        self.EntryConc.EntryData.config(justify='center')
        self.UnitConc = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.3),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.86), text="mol/L",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        self.TitreQuant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.92), text='Sélection de la quantité (/groupe de TP)',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryQuant = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.025),
                                    int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
                                    int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.96), tk.W,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryQuant.Data.set('')
        self.EntryQuant.EntryData.config(justify='center')
        self.UnitQuant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.3),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.96), text="mL",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        self.BtnOK2 = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.88),
                                int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK2.CanvasBtn.bind('<ButtonRelease-1>', self.ValidAjoutSol)
        self.BtnAnnul2 = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.95),
                                   int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                   self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul2.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulAjoutSol)

    def ModifSolut(self, _):
        self.ActionModifSolut()

    def ActionModifSolut(self):
        self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabProd +
                                   ' FROM PRODUITS WHERE NOMS LIKE \"%' +
                                   self.EntrySolut.Data.get() + '%\" order by NOMS')
        self.ListProds = self.MainAppli.cur.fetchall()
        self.ListBoxSolut.ListBox.delete(0, tk.END)
        for i in range(len(self.ListProds)):
            self.ListBoxSolut.ListBox.insert(tk.END, self.ListProds[i][0])
        self.ListBoxSolut.ListBox.selection_set(0)
        if len(self.ListProds) > 0:
            self.AffichInfoSolut(self.ListProds[0])

    def ModifSolut2(self, _):
        self.ActionModifSolut2()

    def ActionModifSolut2(self):
        self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabProd +
                                   ' FROM PRODUITS WHERE NOMS LIKE \'%' +
                                   self.EntrySolut2.Data.get() + '%\' order by NOMS')
        self.ListSolut2 = self.MainAppli.cur.fetchall()
        self.ListBoxSolut2.ListBox.delete(0, tk.END)
        for i in range(len(self.ListSolut2)):
            self.ListBoxSolut2.ListBox.insert(tk.END, self.ListSolut2[i][0])
        self.ListBoxSolut2.ListBox.selection_set(0)
        if len(self.ListSolut2) > 0:
            self.AffichInfoSolut(self.ListSolut2[0])

    def ModifSolvant(self, _):
        self.ActionModifSolvant()

    def ActionModifSolvant(self):
        self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabProd +
                                   ' FROM PRODUITS WHERE NOMS LIKE \"%' +
                                   self.EntrySolvant.Data.get() + '%\" order by NOMS')
        self.ListSolvant = self.MainAppli.cur.fetchall()
        self.ListBoxSolvant.ListBox.delete(0, tk.END)
        if self.EntrySolvant.Data.get() == '':
            self.ListBoxSolvant.ListBox.insert(tk.END, 'Eau')
        self.ListSolvants = []
        for i in range(len(self.ListSolvant)):
            if self.ListSolvant[i][1] == 'mL':
                self.ListSolvants.append(self.ListSolvant[i])
                self.ListBoxSolvant.ListBox.insert(tk.END, self.ListSolvant[i][0])
        if len(self.ListSolvant) > 0:
            self.ListBoxSolvant.ListBox.selection_set(0)
            self.AffichInfoSolvant(0)

    def ModifSolvant2(self, _):
        self.ActionModifSolvant2()

    def ActionModifSolvant2(self):
        self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabProd +
                                   ' FROM PRODUITS WHERE NOMS LIKE \"%' +
                                   self.EntrySolvant2.Data.get() + '%\" order by NOMS')
        self.ListSolvant = self.MainAppli.cur.fetchall()
        self.ListBoxSolvant2.ListBox.delete(0, tk.END)
        if self.EntrySolvant2.Data.get() == '':
            self.ListBoxSolvant2.ListBox.insert(tk.END, 'Eau')
        self.ListSolvants = []
        for i in range(len(self.ListSolvant)):
            if self.ListSolvant[i][1] == 'mL':
                self.ListSolvants.append(self.ListSolvant[i])
                self.ListBoxSolvant2.ListBox.insert(tk.END, self.ListSolvant[i][0])
        if len(self.ListSolvant) > 0:
            self.ListBoxSolvant2.ListBox.selection_set(0)
            self.AffichInfoSolvant(0)

    def ModifSol(self):
        self.ModifenCours = True
        self.AjoutSol()
        self.EntrySolut.Data.set(self.TabSol.TabLabels[self.LineSelect][0]['text'])
        self.EntrySolvant.Data.set(self.TabSol.TabLabels[self.LineSelect][1]['text'])
        self.EntryConc.Data.set(self.TabSol.TabLabels[self.LineSelect][2]['text'])
        self.EntryQuant.Data.set(self.TabSol.TabLabels[self.LineSelect][3]['text'])
        self.ActionModifSolut()
        self.ActionModifSolvant()

    def SupSol(self):
        del self.ListSolTP[self.LineSelect]
        self.EffaceMenu3()
        self.NlineSol = self.NlineSol - 1
        self.ReAffichSol()

    def ValidAjoutSol(self, _):
        self.BtnOK2.CanvasBtn.itemconfig(self.BtnOK2.ImgCanvasBtn, image=self.BtnOK2.ImgBtn[0])
        if self.EntrySolut.EntryData.get() != '' and self.EntryConc.EntryData.get() != '' and \
                self.EntryQuant.EntryData.get() != '':
            if not self.ModifenCours:
                Nline = self.NlineSol - 1
            else:
                Nline = self.LineSelect
            self.ListSolTP[Nline][0] = self.EntrySolut.EntryData.get()
            self.TabSol.TabLabels[Nline][0]['text'] = self.EntrySolut.EntryData.get()
            self.ListSolTP[Nline][1] = self.EntrySolvant.EntryData.get()
            self.TabSol.TabLabels[Nline][1]['text'] = self.EntrySolvant.EntryData.get()
            self.ListSolTP[Nline][2] = self.EntryConc.EntryData.get()
            self.TabSol.TabLabels[Nline][2]['text'] = self.EntryConc.EntryData.get()
            self.ListSolTP[Nline][3] = self.EntryQuant.EntryData.get()
            self.TabSol.TabLabels[Nline][3]['text'] = self.EntryQuant.EntryData.get()

            if not self.ModifenCours:
                self.TabSol.AjoutLine()
                self.NlineSol = self.NlineSol + 1
                self.ListSolTP.append(['', '', '', ''])
                self.AjoutMenuSol()

            self.AnnulAjoutSol(_)
        else:
            tkMB.showwarning('Attention', "Veuillez choisir un soluté, indiquer la concentration de la solution "
                                          "et la quantité par groupe!", parent=self)
            self.lift()

    def AnnulAjoutSol(self, _):
        self.ModifTPenCours = False
        self.ModifenCours = False
        self.EffaceMenu1()
        self.ReAffichMat()
        self.EffaceMenu2()
        self.ReAffichProd()
        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSol)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[0])
        ChangeCursor(self.CanvasBtnSuiv)

    def AnnulAjoutMelSol(self, _):
        self.ModifTPenCours = False
        self.ModifenCours = False
        self.EffaceMenu1()
        self.ReAffichMat()
        self.EffaceMenu2()
        self.ReAffichProd()
        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSolvant)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[0])
        ChangeCursor(self.CanvasBtnSuiv)
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.AffichSol)
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[1])
        ChangeCursor(self.CanvasBtnRetour)

    def AffichInfoSolut(self, Prod):
        self.EffaceMenu1()
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Informations sur le soluté sélectionné', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.002), tk.NW)
        self.InfoSolut = InfoProd(self.CanvasMenu1.CanvasMenu, Prod,
                                  self.MainAppli.cur, self.MainAppli.SizeFont, self.RatioX, self.RatioY, 2)

    def AffichInfoSolvant(self, NProd):
        self.EffaceMenu1()
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Informations sur le solvant sélectionné', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.002), tk.NW)
        if NProd >= 0:
            self.InfoSolut = InfoProd(self.CanvasMenu1.CanvasMenu, self.ListSolvants[NProd],
                                      self.MainAppli.cur, self.MainAppli.SizeFont, self.RatioX, self.RatioY, 2)
        else:
            self.InfoSolvant = LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Eau', '#E0E0E0',
                                             AppliFont('Helvetica', self.MainAppli.SizeFont + 3, 'bold', 0),
                                             int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.5),
                                             int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.06), tk.CENTER)

    def AjoutProd(self):
        self.ModifTPenCours = True
        for widget in self.CanvasMenu1.CanvasMenu.winfo_children():
            widget.destroy()
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Ajouter un produit chimique à la fiche TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.002), tk.NW)

        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.Pass)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[2])
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.Pass)
        ChangeCursor2(self.CanvasBtnRetour)
        ChangeCursor2(self.CanvasBtnSuiv)

        self.TitreProd = self.CanvasMenu1.CanvasMenu.create_text(
            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.05), text='Sélection du produit chimique',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryProd = EntryData(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.108),
                                   int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.5),
                                   int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.09), tk.CENTER,
                                   AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryProd.EntryData.config(justify='center')
        self.EntryProd.EntryData.bind('<KeyRelease>', self.ModifProd)

        self.ListBoxProd = Scrollable_ListBox(self.CanvasMenu1.CanvasMenu,
                                              int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                                              int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.12),
                                              int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.158),
                                              int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.042))

        self.ListBoxProd.ListBox.bind('<<ListboxSelect>>', self.OnSelectListBox)

        self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabProd + " from PRODUITS order by NOMS")
        self.ListProds = self.MainAppli.cur.fetchall()

        self.ListBoxProd.ListBox.delete(0, tk.END)
        for i in range(len(self.ListProds)):
            self.ListBoxProd.ListBox.insert(tk.END, self.ListProds[i][0])
        self.ListBoxProd.ListBox.selection_set(0)
        self.EntryProd.Data.set(self.ListProds[0][0])
        self.AffichInfoProd(0)

        self.TitreQuant = self.CanvasMenu1.CanvasMenu.create_text(
            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.85), text='Sélection de la quantité (/groupe de TP)',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryQuant = EntryData(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.025),
                                    int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.05),
                                    int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.9), tk.W,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryQuant.Data.set('')
        self.EntryQuant.EntryData.config(justify='center')

        self.UnitListe = ["g", "mL", "Unité"]
        self.Unit = tk.StringVar()
        self.Unit.set(self.ListProds[0][1])
        self.ListeUnit = ListeDeroulante(self.CanvasFrmFond, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.015),
                                         textvariable=self.Unit,
                                         values=self.UnitListe)
        self.WindowListeUnit = self.CanvasMenu1.CanvasMenu.create_window(
            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.3),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.888), anchor=tk.NW, window=self.ListeUnit)

        self.BtnOK2 = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.88),
                                int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK2.CanvasBtn.bind('<ButtonRelease-1>', self.ValidAjoutProd)
        self.BtnAnnul2 = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.95),
                                   int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                   self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul2.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulAjoutProd)

    def ModifProd(self, _):
        self.ActionModifProd()

    def ActionModifProd(self):
        self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabProd +
                                   ' FROM PRODUITS WHERE NOMS LIKE \"%' +
                                   self.EntryProd.Data.get() + '%\" order by NOMS')
        self.ListProds = self.MainAppli.cur.fetchall()
        self.ListBoxProd.ListBox.delete(0, tk.END)
        if len(self.ListProds) > 0:
            for i in range(len(self.ListProds)):
                self.ListBoxProd.ListBox.insert(tk.END, self.ListProds[i][0])
            self.ListBoxProd.ListBox.selection_set(0)
            self.AffichInfoProd(0)

    def ModifProduit(self):
        self.ModifenCours = True
        self.AjoutProd()
        self.EntryProd.Data.set(self.TabProd.TabLabels[self.LineSelect][0]['text'])
        self.EntryQuant.Data.set(self.TabProd.TabLabels[self.LineSelect][1]['text'])
        self.Unit.set(self.TabProd.TabLabels[self.LineSelect][2]['text'])
        self.ActionModifProd()

    def SupProd(self):
        del self.ListProdTP[self.LineSelect]
        self.EffaceMenu2()
        self.NlineProd = self.NlineProd - 1
        self.ReAffichProd()

    def ValidAjoutProd(self, _):
        self.BtnOK2.CanvasBtn.itemconfig(self.BtnOK2.ImgCanvasBtn, image=self.BtnOK2.ImgBtn[0])
        if self.EntryProd.EntryData.get() != '' and self.EntryQuant.EntryData.get() != '':
            if not self.ModifenCours:
                Nline = self.NlineProd - 1
            else:
                Nline = self.LineSelect
            self.ListProdTP[Nline][0] = self.EntryProd.EntryData.get()
            self.TabProd.TabLabels[Nline][0]['text'] = self.EntryProd.EntryData.get()
            self.ListProdTP[Nline][1] = self.EntryQuant.EntryData.get()
            self.TabProd.TabLabels[Nline][1]['text'] = self.EntryQuant.EntryData.get()
            self.ListProdTP[Nline][2] = self.Unit.get()
            self.TabProd.TabLabels[Nline][2]['text'] = self.Unit.get()

            if not self.ModifenCours:
                self.TabProd.AjoutLine()
                self.NlineProd = self.NlineProd + 1
                self.ListProdTP.append(['', '', ''])
                self.AjoutMenuProd()

            self.AnnulAjoutProd(_)
        else:
            tkMB.showwarning('Attention', "Veuillez choisir un produit chimique et indiquer la quantité par groupe!",
                             parent=self)
            self.lift()

    def AnnulAjoutProd(self, _):
        self.ModifTPenCours = False
        self.ModifenCours = False
        self.EffaceMenu1()
        self.ReAffichMat()
        self.EffaceMenu3()
        self.ReAffichSol()

    def AffichInfoProd(self, NProd):
        self.EffaceMenu3()
        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Informations sur le produit chimique sélectionné', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)
        self.InfoProd = InfoProd(self.CanvasMenu3.CanvasMenu, self.ListProds[NProd],
                                 self.MainAppli.cur, self.MainAppli.SizeFont, self.RatioX, self.RatioY, 2)

    def AjoutMateriel(self):
        self.ModifTPenCours = True
        for widget in self.CanvasMenu2.CanvasMenu.winfo_children():
            widget.destroy()
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        LabelInCanvas(self.CanvasMenu2.CanvasMenu, 'Ajouter du matériel à la fiche TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.002), tk.NW)

        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.Pass)
        self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[2])
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.Pass)
        ChangeCursor2(self.CanvasBtnRetour)
        ChangeCursor2(self.CanvasBtnSuiv)

        self.TitreMat = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.05), text='Sélection du matériel',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.EntryMat = EntryData(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.108),
                                  int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                  int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.09), tk.CENTER,
                                  AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0))
        self.EntryMat.EntryData.config(justify='center')
        self.EntryMat.EntryData.bind('<KeyRelease>', self.ModifMat)

        self.ListBoxMats = Scrollable_ListBox(self.CanvasMenu2.CanvasMenu,
                                              int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                                              int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.12),
                                              int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.158),
                                              int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.042))

        self.ListBoxMats.ListBox.bind('<<ListboxSelect>>', self.OnSelectListBox)

        self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabMat + " from MATERIEL order by NOMS")
        self.ListMats = self.MainAppli.cur.fetchall()

        self.ListBoxMats.ListBox.delete(0, tk.END)
        for i in range(len(self.ListMats)):
            self.ListBoxMats.ListBox.insert(tk.END, self.ListMats[i][0])
        self.ListBoxMats.ListBox.selection_set(0)
        self.AffichStock(0)
        self.EntryMat.Data.set(self.ListMats[0][0])

        self.TitreQuant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.85), text='Sélection de la quantité',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)

        self.QuantMat = LabelInCanvas(self.CanvasMenu2.CanvasMenu, '1', 'white',
                                      AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0),
                                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
                                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.88), tk.NW)
        self.QuantMat.Label.config(width=int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.006),
                                   height=int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.003), relief=tk.RIDGE)

        self.BtnPlus = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.13),
                                 int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.895), self.RatioX * 1.1,
                                 self.RatioX * 1.1, 'Media/FrmAjout/BtnPlus/')
        self.BtnPlus.CanvasBtn.bind('<ButtonRelease-1>', self.QuantMatPlus)
        self.BtnMoins = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.13),
                                  int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.915), self.RatioX * 1.1,
                                  self.RatioX * 1.1, 'Media/FrmAjout/BtnMoins/')
        self.BtnMoins.CanvasBtn.bind('<ButtonRelease-1>', self.QuantMatMoins)
        self.LinePar = self.CanvasMenu2.CanvasMenu.create_line(int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.19),
                                                               int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.92),
                                                               int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.21),
                                                               int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.89),
                                                               width=2)

        self.LieuListe = ["Poste TP", "Bureau", "Salle spectro."]
        self.Lieu = tk.StringVar()
        self.Lieu.set(self.LieuListe[0])
        self.ListeLieu = ListeDeroulante(self.CanvasFrmFond, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.02),
                                         textvariable=self.Lieu,
                                         values=self.LieuListe)
        self.WindowListeLieu = self.CanvasMenu2.CanvasMenu.create_window(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.25),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.893), anchor=tk.NW, window=self.ListeLieu)

        self.BtnOK2 = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.88),
                                int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK2.CanvasBtn.bind('<ButtonRelease-1>', self.ValidAjoutMat)
        self.BtnAnnul2 = BtnAction(self.CanvasMenu2.CanvasMenu, int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.95),
                                   int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                   self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul2.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulAjoutMat)

    def ModifCat(self, _):
        self.MainAppli.cur.execute('SELECT CAT'
                                   ' FROM TP WHERE CAT LIKE \"%' + self.EntryCat.EntryData.get() +
                                   '%\" order by CAT')
        Cat = self.MainAppli.cur.fetchall()
        if len(Cat) > 0:
            self.EntryCat.Data.set(Cat[0][0])

    def ModifMat(self, _):
        self.ActionModifMat()

    def ActionModifMat(self):
        self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabMat +
                                   ' FROM MATERIEL WHERE NOMS LIKE \"%' +
                                   self.EntryMat.Data.get() + '%\" order by NOMS')
        self.ListMats = self.MainAppli.cur.fetchall()
        self.ListBoxMats.ListBox.delete(0, tk.END)
        if len(self.ListMats) > 0:
            for i in range(len(self.ListMats)):
                self.ListBoxMats.ListBox.insert(tk.END, self.ListMats[i][0])
            self.ListBoxMats.ListBox.selection_set(0)
            self.AffichStock(0)

    def ModifMateriel(self):
        self.ModifenCours = True
        self.AjoutMateriel()
        self.EntryMat.Data.set(self.TabMat.TabLabels[self.LineSelect][0]['text'])
        self.QuantMat.Label['text'] = self.TabMat.TabLabels[self.LineSelect][1]['text']
        self.Lieu.set(self.TabMat.TabLabels[self.LineSelect][2]['text'])
        self.ActionModifMat()

    def SupMateriel(self):
        del self.ListMatTP[self.LineSelect]
        self.EffaceMenu1()
        self.NlineMat = self.NlineMat - 1
        self.ReAffichMat()

    def ValidAjoutMat(self, _):
        self.BtnOK2.CanvasBtn.itemconfig(self.BtnOK2.ImgCanvasBtn, image=self.BtnOK2.ImgBtn[0])
        if self.EntryMat.EntryData.get() != '':
            if not self.ModifenCours:
                Nline = self.NlineMat - 1
            else:
                Nline = self.LineSelect
            self.ListMatTP[Nline][0] = self.EntryMat.EntryData.get()
            self.TabMat.TabLabels[Nline][0]['text'] = self.EntryMat.EntryData.get()
            self.ListMatTP[Nline][1] = self.QuantMat.Label['text']
            self.TabMat.TabLabels[Nline][1]['text'] = self.QuantMat.Label['text']
            self.ListMatTP[Nline][2] = self.Lieu.get()
            self.TabMat.TabLabels[Nline][2]['text'] = self.Lieu.get()

            if not self.ModifenCours:
                self.TabMat.AjoutLine()
                self.NlineMat = self.NlineMat + 1
                self.ListMatTP.append(['', '', ''])
                self.AjoutMenuMat()

            self.AnnulAjoutMat(_)
        else:
            tkMB.showwarning('Attention', "Veuillez choisir un matériel!", parent=self)
            self.lift()

    def AnnulAjoutMat(self, _):
        self.ModifTPenCours = False
        self.ModifenCours = False
        self.EffaceMenu2()
        self.ReAffichProd()
        self.EffaceMenu3()
        self.ReAffichSol()

    def AffichStock(self, Nmat):
        self.EffaceMenu3()
        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Informations sur le matériel sélectionné', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)
        self.InfoMat = InfoMatChim(self.CanvasMenu3.CanvasMenu, self.ListMats[Nmat],
                                   self.MainAppli.cur, self.MainAppli.SizeFont, self.RatioX,
                                   self.RatioY, 2, self.MainAppli.LieuxStockMatChim)

    def AffichMenuClicDroit(self, event, MenuClicDroitTab, j):
        if self.InfoMat is None:
            MenuClicDroitTab[j][0].post(event.x_root, event.y_root)
            self.LineSelect = j

    def OnSelectListBox(self, evt):
        try:
            w = evt.widget
            self.IndexElt = int(w.curselection()[0])
            if self.InfoMat is not None:
                self.EntryMat.Data.set(self.ListMats[self.IndexElt][0])
                self.AffichStock(self.IndexElt)
            if self.InfoProd is not None:
                self.EntryProd.Data.set(self.ListProds[self.IndexElt][0])
                self.Unit.set(self.ListProds[self.IndexElt][1])
                self.AffichInfoProd(self.IndexElt)
            if self.InfoSolut is not None or self.InfoSolvant is not None:
                self.EntrySolut.Data.set(self.ListProds[self.IndexElt][0])
                self.AffichInfoSolut(self.ListProds[self.IndexElt])
        except:
            pass

    def OnSelectListBox2(self, evt):
        try:
            w = evt.widget
            self.IndexElt = int(w.curselection()[0])
            self.EntrySolut2.Data.set(self.ListSolut2[self.IndexElt][0])
            self.AffichInfoSolut(self.ListSolut2[self.IndexElt])
        except:
            pass

    def OnSelectListBoxSolvant(self, evt):
        try:
            w = evt.widget
            self.IndexElt = int(w.curselection()[0])
            self.EntrySolvant.Data.set(self.ListBoxSolvant.ListBox.get(self.IndexElt))
            if self.ListBoxSolvant.ListBox.get(0) == 'Eau':
                self.AffichInfoSolvant(self.IndexElt - 1)
            else:
                self.AffichInfoSolvant(self.IndexElt)

        except:
            pass

    def OnSelectListBoxSolvant2(self, evt):
        try:
            w = evt.widget
            self.IndexElt = int(w.curselection()[0])
            self.EntrySolvant2.Data.set(self.ListBoxSolvant2.ListBox.get(self.IndexElt))
            self.AffichInfoSolvant(self.IndexElt)
        except:
            pass

    def SaveNewTP(self, _):
        self.BtnOK.CanvasBtn.itemconfig(self.BtnOK.ImgCanvasBtn, image=self.BtnOK.ImgBtn[0])
        if self.EntryTitre.EntryData.get() != '' and not self.ModifTPenCours:
            Rep = True
            self.MainAppli.cur.execute("Select * from TP where " + 'TITRE = "' + self.EntryTitre.EntryData.get() + '"')
            NOcur = len(self.MainAppli.cur.fetchall())

            if NOcur > 0:
                Rep = tkMB.askyesno('Attention', 'Un TP nommé "' + self.EntryTitre.EntryData.get()
                                    + '" est déja présent dans la base de données, souhaitez-vous mettre à jour '
                                      'les données?', parent=self)
            if Rep:
                if NOcur > 0:
                    SQLRequet = "DELETE FROM TP WHERE " + 'TITRE = "' + self.EntryTitre.EntryData.get() + '"'
                    self.MainAppli.cur.execute(SQLRequet)
                    self.MainAppli.DataBaseChimie.commit()

                Titre = self.EntryTitre.EntryData.get()
                NomSave = ModifString(self.EntryTitre.EntryData.get())
                self.MainAppli.cur.execute("Select TITRE from TP")
                LNoms = self.MainAppli.cur.fetchall()
                Ocur = False
                for i in range(len(LNoms)):
                    if ModifString(LNoms[i][0]) == NomSave:
                        Ocur = True
                        break
                if Ocur:
                    NomSave = ModifString(NomSave + str(datetime.now()))

                Classe = self.Classe.get()
                Cat = self.EntryCat.EntryData.get()
                PDF = ''
                if self.PathFilePDFToOpen != '':
                    PDF = NomSave
                    shutil.copy(self.PathFilePDFToOpen, 'Datas/PDFTPChim/' + PDF + '.pdf')
                elif self.ActionModifTitre:
                    if self.FichierPDFAOuvrir != '':
                        PDF = NomSave
                        if not os.path.exists('Datas/PDFTPChim/' + PDF + '.pdf'):
                            shutil.copy('Datas/PDFTPChim/' + self.TP[1] + '.pdf', 'Datas/PDFTPChim/' + PDF + '.pdf')
                elif self.FichierPDFAOuvrir != '':
                    PDF = self.TP[1]
                if self.ListMatTP[0][0] == '' and self.ListProdTP[0][0] == '' and self.ListSolTP[0][0] == '' \
                        and (self.ListMelSolTP is None or self.ListMelSolTP[0][0] == '') and \
                        (self.ListMelSolvantTP is None or self.ListMelSolTP[0][0] == ''):
                    data = [(Titre, PDF, Classe, Cat)]
                    self.MainAppli.cur.execute(
                        "INSERT INTO TP(" + self.MainAppli.ListChampsTabTP + ") VALUES(?,?,?,?)", data[0])
                else:
                    for r in range(self.NlineMat - 1):
                        data = [(Titre, PDF, Classe, self.ListMatTP[r][0], self.ListMatTP[r][1], self.ListMatTP[r][2],
                                 Cat)]
                        self.MainAppli.cur.execute(
                            "INSERT INTO TP(" + self.MainAppli.ListChampsTabTP2 + ") VALUES(?,?,?,?,?,?,?)", data[0])

                    for r in range(self.NlineProd - 1):
                        data = [(Titre, PDF, Classe, self.ListProdTP[r][0], self.ListProdTP[r][1],
                                 self.ListProdTP[r][2], Cat)]
                        self.MainAppli.cur.execute(
                            "INSERT INTO TP(" + self.MainAppli.ListChampsTabTP3 + ") VALUES(?,?,?,?,?,?,?)", data[0])

                    for r in range(self.NlineSol - 1):
                        data = [(Titre, PDF, Classe, self.ListSolTP[r][0], self.ListSolTP[r][1],
                                 self.ListSolTP[r][2], self.ListSolTP[r][3], Cat)]
                        self.MainAppli.cur.execute(
                            "INSERT INTO TP(" + self.MainAppli.ListChampsTabTP4 + ") VALUES(?,?,?,?,?,?,?,?)", data[0])

                    for r in range(self.NlineMelSol - 1):
                        data = [(Titre, PDF, Classe, self.ListMelSolTP[r][0], self.ListMelSolTP[r][1],
                                 self.ListMelSolTP[r][2], self.ListMelSolTP[r][3], self.ListMelSolTP[r][4], Cat)]
                        self.MainAppli.cur.execute(
                            "INSERT INTO TP(" + self.MainAppli.ListChampsTabTP5 + ") VALUES(?,?,?,?,?,?,?,?,?)",
                            data[0])

                    for r in range(self.NlineMelSolvant - 1):
                        data = [(Titre, PDF, Classe, self.ListMelSolvantTP[r][0], self.ListMelSolvantTP[r][1],
                                 self.ListMelSolvantTP[r][2], self.ListMelSolvantTP[r][3], self.ListMelSolvantTP[r][4],
                                 Cat)]
                        self.MainAppli.cur.execute(
                            "INSERT INTO TP(" + self.MainAppli.ListChampsTabTP6 + ") VALUES(?,?,?,?,?,?,?,?,?)",
                            data[0])

                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie', self.TextAction + Titre)
                self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabTP +
                                           " from TP order by TITRE")
                self.MainAppli.ListTP = self.MainAppli.cur.fetchall()

                self.MainAppli.ListTPs = []
                for i in self.MainAppli.ListTP:
                    if i not in self.MainAppli.ListTPs:
                        self.MainAppli.ListTPs.append(i)

                if PDF != self.DocPDFInit and not self.ActionModifTitre and self.DocPDFInit != '':
                    if os.path.exists('Datas/PDFTPChim/' + self.DocPDFInit + '.pdf'):
                        os.remove('Datas/PDFTPChim/' + self.DocPDFInit + '.pdf')

                if self.MainAppli.ModifEnCours:
                    if self.MainAppli.OldNAction == 3:
                        self.MainAppli.ChargeListProduits(self.MainAppli.ListTPs)
                        self.MainAppli.AffichEtagProduits(self.MainAppli.ListTPs)
                    elif self.MainAppli.OldNAction == 3011:
                        self.MainAppli.NAction = 301
                        self.MainAppli.ActionRecherche()
                    elif self.MainAppli.OldNAction == 3022:
                        self.MainAppli.AffichListTPCat(self.MainAppli.NSCatselected)
                else:
                    self.MainAppli.ChargeListProduits(self.MainAppli.ListTPs)
                    self.MainAppli.AffichEtagProduits(self.MainAppli.ListTPs)

                try:
                    self.MainAppli.IndexElt = self.MainAppli.ListNomProd.index(Titre)
                    self.MainAppli.FrmTP.SelectTP(self.MainAppli.IndexElt)
                except:
                    pass

                self.CacheFrmAjout(_)
            else:
                self.lift()
        else:
            if not self.ModifTPenCours:
                tkMB.showwarning('Attention', "Veuillez indiquer le nom du TP!", parent=self)
                self.lift()
            else:
                winsound.PlaySound("*", winsound.SND_ASYNC)

    def QuantMatPlus(self, _):
        self.BtnPlus.CanvasBtn.itemconfig(self.BtnPlus.ImgCanvasBtn, image=self.BtnPlus.ImgBtn[0])
        self.QuantMat.Label.config(text=str(int(self.QuantMat.Label['text']) + 1))

    def QuantMatMoins(self, _):
        self.BtnMoins.CanvasBtn.itemconfig(self.BtnMoins.ImgCanvasBtn, image=self.BtnMoins.ImgBtn[0])
        if int(self.QuantMat.Label['text']) > 1:
            self.QuantMat.Label.config(text=str(int(self.QuantMat.Label['text']) - 1))

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.ImgCanvasBtnQuit, image=self.MainAppli.ImgBtnQuit[0])

    def CacheFrmAjout(self, _):
        self.BtnAnnul.CanvasBtn.itemconfig(self.BtnAnnul.ImgCanvasBtn, image=self.BtnAnnul.ImgBtn[0])
        if not self.ModifTPenCours:
            self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
            self.MainAppli.ListBtnActionV[2].CanvasBtn.itemconfig(self.MainAppli.ListBtnActionV[2].ImgCanvasBtn,
                                                                  image=self.MainAppli.ListBtnActionV[2].ImgBtn[0])
            self.destroy()
            if self.MainAppli.OldNAction != 0:
                self.MainAppli.NAction = self.MainAppli.OldNAction
            else:
                self.MainAppli.NAction = 3
            self.MainAppli.MAJInfo()
            self.MainAppli.parent.focus_force()
            self.MainAppli.FrmLift()
            self.MainAppli.ModifEnCours = False
            self.ModifenCours = False
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)

    def Pass(self, _):
        pass

    def EffaceMenu1(self):
        for widget in self.CanvasMenu1.CanvasMenu.winfo_children():
            widget.destroy()
        self.CanvasMenu1.CanvasMenu.delete(self.TitreQuant)
        self.CanvasMenu1.CanvasMenu.delete(self.TitreProd)
        self.CanvasMenu1.CanvasMenu.delete(self.WindowListeUnit)
        if self.InfoSolut is not None:
            self.CanvasMenu1.CanvasMenu.delete(self.InfoSolut.NomProd)
            self.CanvasMenu1.CanvasMenu.delete(self.InfoSolut.TitreStock)
            self.CanvasMenu1.CanvasMenu.delete(self.InfoSolut.TitreFournisseur)
            self.InfoSolut = None
        self.InfoSolvant = None

    def EffaceMenu3(self):
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        if self.InfoMat is not None:
            self.CanvasMenu3.CanvasMenu.delete(self.InfoMat.NomMat)
            self.CanvasMenu3.CanvasMenu.delete(self.InfoMat.TitreStock)
            self.CanvasMenu3.CanvasMenu.delete(self.InfoMat.TitreFournisseur)
            self.InfoMat = None
        if self.InfoProd is not None:
            self.CanvasMenu3.CanvasMenu.delete(self.InfoProd.NomProd)
            self.CanvasMenu3.CanvasMenu.delete(self.InfoProd.TitreStock)
            self.CanvasMenu3.CanvasMenu.delete(self.InfoProd.TitreFournisseur)
            self.InfoProd = None

    def EffaceMenu2(self):
        for widget in self.CanvasMenu2.CanvasMenu.winfo_children():
            widget.destroy()
        self.CanvasMenu2.CanvasMenu.delete(self.TitreQuant)
        self.CanvasMenu2.CanvasMenu.delete(self.TitreMat)
        self.CanvasMenu2.CanvasMenu.delete(self.LinePar)
        self.CanvasMenu2.CanvasMenu.delete(self.WindowListeLieu)
        self.CanvasMenu2.CanvasMenu.delete(self.TitreSolut)
        self.CanvasMenu2.CanvasMenu.delete(self.TitreSolut2)
        self.CanvasMenu2.CanvasMenu.delete(self.TitreSolvant)
        self.CanvasMenu2.CanvasMenu.delete(self.TitreSolvant2)
        self.CanvasMenu2.CanvasMenu.delete(self.TitreConc)
        self.CanvasMenu2.CanvasMenu.delete(self.UnitConc)
        self.CanvasMenu2.CanvasMenu.delete(self.TitreConc2)
        self.CanvasMenu2.CanvasMenu.delete(self.UnitConc2)
        self.CanvasMenu2.CanvasMenu.delete(self.UnitQuant)

    def ModifTitre(self, _):
        if self.EntryTitre.EntryData.get() != self.TitreTP:
            self.ActionModifTitre = True
        else:
            self.ActionModifTitre = False

    def ChargePDF(self, _):
        self.BtnImportPDF.CanvasBtn.itemconfig(self.BtnImportPDF.ImgCanvasBtn, image=self.BtnImportPDF.ImgBtn[0])
        if not self.ModifTPenCours:
            self.PathFilePDFToOpen = tkfiledialog.askopenfilename(title="Ouvrir un fichier",
                                                                  filetypes=[('PDF files', '.pdf')], parent=self)
            if self.PathFilePDFToOpen != '':
                self.BtnVisuPDF.CanvasBtn.itemconfig(self.BtnVisuPDF.ImgCanvasBtn, image=self.BtnVisuPDF.ImgBtn[0])
                ChangeCursor(self.BtnVisuPDF.CanvasBtn)
            self.lift(self.parent)
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)

    def VisuPDF(self, _):
        if self.PathFilePDFToOpen == '' and self.FichierPDFAOuvrir != '':
            self.BtnVisuPDF.CanvasBtn.itemconfig(self.BtnVisuPDF.ImgCanvasBtn, image=self.BtnVisuPDF.ImgBtn[0])
            self.FrmVisuPDF = FrmVisuPDF(self.MainAppli.CanvasFrmMain, self.FichierPDFAOuvrir,
                                         self.Classe.get() + ' - ' + self.EntryTitre.EntryData.get(), self.RatioX,
                                         self.RatioY, self)
        elif self.PathFilePDFToOpen != '':
            self.BtnVisuPDF.CanvasBtn.itemconfig(self.BtnVisuPDF.ImgCanvasBtn, image=self.BtnVisuPDF.ImgBtn[0])
            self.FrmVisuPDF = FrmVisuPDF(self.MainAppli.CanvasFrmMain, self.PathFilePDFToOpen,
                                         self.Classe.get() + ' - ' + self.EntryTitre.EntryData.get(), self.RatioX,
                                         self.RatioY, self)
        else:
            self.BtnVisuPDF.CanvasBtn.itemconfig(self.BtnVisuPDF.ImgCanvasBtn, image=self.BtnVisuPDF.ImgBtn[2])

    def PressBtnVisuPDF(self, _):
        if self.PathFilePDFToOpen != '' or self.FichierPDFAOuvrir != '':
            self.BtnVisuPDF.CanvasBtn.itemconfig(self.BtnVisuPDF.ImgCanvasBtn, image=self.BtnVisuPDF.ImgBtn[1])


class FrmVisuPDF(tk.Toplevel):
    def __init__(self, container, PDF, Titre, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.PDF = PDF
        self.Titre = Titre

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmVisuPDF)

        coefY = float(ConfigResolution(self.MainAppli.MainAppli.Nconfig, 'YTitreFrm', self.MainAppli.MainAppli.curSave))

        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, Titre, '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * coefY), tk.NW)

        self.FrmPDF = FrmPDF(self.CanvasFrmFond, PDF, 1.5, int(self.SY), int(self.SX * 0.5), int(self.SY * 0.495),
                             int(self.SX * 0.97), int(self.SY * 0.905))

        self.FrmPDF.CanvasDoc.bind('<Double-1>', self.OuvrePDF)
        self.MenuClicDroitPDF = tk.Menu(self.FrmPDF.CanvasDoc, tearoff=0)
        self.MenuClicDroitPDF.add_command(label="Ouvrir dans le navigateur", command=self.ActionOuvrePDF)
        self.MenuClicDroitPDF.add_separator()
        self.MenuClicDroitPDF.add_command(label="Supprimer le document", command=self.ActionSupPDF)
        self.FrmPDF.CanvasDoc.bind("<Button-3>", self.AffichMenuClicDroitPDF)

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)

        self.CanvasFrmFond.pack()

    def ActionSupPDF(self):
        self.MainAppli.PathFilePDFToOpen = ''
        self.MainAppli.FichierPDFAOuvrir = ''
        self.MainAppli.BtnVisuPDF.CanvasBtn.itemconfig(self.MainAppli.BtnVisuPDF.ImgCanvasBtn,
                                                       image=self.MainAppli.BtnVisuPDF.ImgBtn[2])
        ChangeCursor2(self.MainAppli.BtnVisuPDF.CanvasBtn)
        self.MainAppli.FrmVisuPDF = None
        self.destroy()
        self.MainAppli.MainAppli.parent.lift()
        self.MainAppli.MainAppli.FrmLift()
        self.MainAppli.lift()

    def OuvrePDF(self, _):
        self.ActionOuvrePDF()

    def ActionOuvrePDF(self):
        AffichPDF(self.Titre, self.PDF, self)

    def ClosePDF(self):
        self.MainAppli.MainAppli.parent.focus_force()
        self.MainAppli.MainAppli.FrmLift()
        self.focus_force()

    def AffichMenuClicDroitPDF(self, event):
        self.MenuClicDroitPDF.post(event.x_root, event.y_root)

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.MainAppli.ImgCanvasBtnQuit,
                                                          image=self.MainAppli.MainAppli.ImgBtnQuit[0])

    def CacheFrmVisuPDF(self, _):
        self.MainAppli.FrmVisuPDF = None
        self.destroy()
        self.MainAppli.MainAppli.parent.lift()
        self.MainAppli.MainAppli.FrmLift()
        self.MainAppli.lift()
