from AppliDef import *
from FrmInfoProdMat import DescriptMat, InfoMatChim, InfoMatPhys
from FrmCommandProd import ChercheFour


def ChercheMat(cur, ListChamp, Nom):
    ListMats = []
    try:
        cur.execute("SELECT " + ListChamp + " FROM MATERIEL WHERE NOMS = '" + Nom + "' order by NOMS")
        ListMats = cur.fetchall()
    except:
        cur.execute('SELECT ' + ListChamp + ' FROM MATERIEL WHERE NOMS = \"%' + Nom + '%\" order by NOMS')
        ListMats = cur.fetchall()
    finally:
        if len(ListMats) == 0:
            cur.execute('SELECT ' + ListChamp + ' FROM MATERIEL WHERE NOMS LIKE \"%' + Nom + '%\" order by NOMS')
            ListMats = cur.fetchall()
    return ListMats


class FrmCommandMat(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.TabMatACom = None
        self.BtnPlus = None
        self.FrmAjoutMatACom = None
        self.ListMatACom = []
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            self.AffichList = ['Matériels de chimie à commander',
                               'Matériels de chimie à commander en attente de validation',
                               'Commandes de matériels de chimie en attente de livraison',
                               'Récapitulatif annuel des commandes de matériels de chimie',
                               'Récapitulatif annuel des quantités de matériels de chimie commandés']
        elif self.MainAppli.BaseEnCours == 'PHYS':
            self.AffichList = ['Matériels de physique à commander',
                               'Matériels de physique à commander en attente de validation',
                               'Commandes de matériels de physique en attente de livraison',
                               'Récapitulatif annuel des commandes de matériels de physique',
                               'Récapitulatif annuel des quantités de matériels de physique commandés']
        self.ListMats = []
        self.ListModif = []
        self.LCell = []
        self.ListTabMatACOM = []
        self.MenuClicDroitTabMatACom = []
        self.ImgBtnRetour, self.CanvasBtnRetour, self.ImgCanvasBtnRetour = None, None, None
        self.LineSelect = 0
        self.EntryManuelVal = None
        self.ListNomsMatACom = []
        self.FrmBonCom = None
        self.ListMatAComAnnul = []
        self.MenuClicDroitTabMatAComAnnul = []
        self.ListComDelay = []
        self.TabComDelay = None
        self.MenuClicDroitTabComDelay = []
        self.ListMatComDelay = []
        self.AnneeListe = []
        self.AnneeListe.append(str(datetime.now().date().year))
        self.StringAnnee = tk.StringVar()
        self.AnneeSelect = self.AnneeListe[0]
        self.ListAnnee = []
        self.TotalTTC = 0
        self.BonComAnnuel = []
        self.TabRecapComAnnuel = None
        self.labelValTotal = None
        self.MenuClicDroitTabRecapComAnnuel = []
        self.ListMatRecapCom = []
        self.ListMatRecapCom = []
        self.TabRecapQComAnnuel = None
        self.CoefSecu = float(self.MainAppli.CoeffSecuMat.replace(',', '.'))
        self.TVA = float(1 + float(self.MainAppli.TVA.replace(',', '.')) / 100)

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        coefY = float(ConfigResolution(self.MainAppli.Nconfig, 'YTitreFrm', self.MainAppli.curSave))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmCommandMat)

        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, 'Commandes de matériels de chimie', '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * coefY), tk.NW)

        self.SelectAffich = tk.StringVar()
        self.SelectAffich.set(self.AffichList[0])
        self.ListSelectAffich = ListeDeroulante(self.CanvasFrmFond, int(self.SX * 0.033),
                                                textvariable=self.SelectAffich, values=self.AffichList)
        self.CanvasFrmFond.create_window(int(self.SX * 0.975), int(self.SY * coefY), anchor=tk.NE,
                                         window=self.ListSelectAffich)

        self.ListSelectAffich.bind('<<ComboboxSelected>>', self.AffichSelection)

        self.CanvasMenu = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.995),
                                     int(self.SY * 0.965), int(self.SX * 0.003), int(self.SY * 0.031), tk.NW)

        self.AffichTabMatACom(0)

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)

        self.CanvasFrmFond.pack()

    def AffichSelection(self, _):
        Index = self.AffichList.index(self.SelectAffich.get())
        if Index == 0:
            self.AffichTabMatACom(Index)
        elif Index == 1:
            self.AffichTabMatAComDelay(Index)
        elif Index == 2:
            self.AffichTabComDelay(Index)
        elif Index == 3:
            self.AffichTabRecapCom(Index)
        elif Index == 4:
            self.AffichTabRecapQCom(Index)

    def AffichTabMatACom(self, Index):
        self.EffaceMenu()
        LabelInCanvas(self.CanvasMenu.CanvasMenu, self.AffichList[Index], '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.004), tk.NW)
        self.ListMatACom = []
        self.ListNomsMatACom = []

        ListIndex = []
        Type = ''
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabMat + " from MATERIEL order by NOMS")
            self.ListMats = self.MainAppli.cur.fetchall()
            ListIndex = [29, 14, 30, 31]
            Type = 'chimie'

        elif self.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.curphys.execute("select " + self.MainAppli.ListChampsTabMatPhys +
                                           " from MATERIEL order by NOMS")
            self.ListMats = self.MainAppli.curphys.fetchall()
            ListIndex = [24, 9, 25, 26]
            Type = 'physique'

        for i in range(len(self.ListMats)):
            if self.ListMats[i][ListIndex[0]] != '' and self.ListMats[i][ListIndex[0]] is not None:
                self.ListMatACom.append(self.ListMats[i])
                self.ListNomsMatACom.append(self.ListMats[i][0])
            elif self.ListMats[i][ListIndex[1]] != '' and self.ListMats[i][ListIndex[1]] is not None and \
                    self.ListMats[i][ListIndex[2]] != 'OUI' and (self.ListMats[i][ListIndex[3]] == ''
                                                                 or self.ListMats[i][ListIndex[3]] is None):
                Qstock = 0
                if self.MainAppli.BaseEnCours == 'CHIMIE':
                    Qstock = int(self.ListMats[i][13])
                elif self.MainAppli.BaseEnCours == 'PHYS':
                    for j in range(4, 9, 2):
                        if self.ListMats[i][j] != '' and self.ListMats[i][j] is not None:
                            Qstock = Qstock + int(self.ListMats[i][j])

                if Qstock < int(self.ListMats[i][ListIndex[1]]) * self.CoefSecu:
                    self.ListMatACom.append(self.ListMats[i])
                    self.ListNomsMatACom.append(self.ListMats[i][0])

        self.LCell = [0.05, 0.01, 0.01, 0.01, 0.01, 0.008, 0.01]
        self.TabMatACom = Tableau(self.CanvasMenu.CanvasMenu, len(self.ListMatACom), 7,
                                  ['Désignation', 'Fournisseur', 'Référence', 'Conditionnement',
                                   'Prix unitaire HT (€)', 'Quantité', 'Prix total HT (€)'], self.LCell,
                                  AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                  AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)

        self.FillTabMatACOM(self.ListMatACom)
        self.ListTabMatACOM = [["", "", "", "", "", "", "", ""]]
        self.MenuClicDroitTabMatACom = []
        for r in range(len(self.ListMatACom)):
            ListMenu = []
            for i in range(7):
                ListMenu.append(tk.Menu(self.TabMatACom.TabLabels[r][i], tearoff=0))
                self.ListTabMatACOM[r][i] = self.TabMatACom.TabLabels[r][i]['text']

                def GestEvt(evt, L=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabMatACom, L)

                self.TabMatACom.TabLabels[r][i].bind("<Button-3>", GestEvt)
            self.MenuClicDroitTabMatACom.append(ListMenu)
            self.ListTabMatACOM.append(["", "", "", "", "", "", "", ""])

        for r in range(self.TabMatACom.NLine):
            self.MenuClicDroitTabMatACom[r][0].add_command(label="Modifier la commande du matériel de " + Type,
                                                           command=self.ModifMatACom)
            self.MenuClicDroitTabMatACom[r][0].add_command(label="Supprimer le matériel de " + Type + " de la commande",
                                                           command=self.SupMatACom)
            self.MenuClicDroitTabMatACom[r][0].add_separator()
            self.MenuClicDroitTabMatACom[r][0].add_command(label="Editer un bon de commande", command=self.EditBonCom)
            self.MenuClicDroitTabMatACom[r][0].add_command(label="Editer une demande de devis",
                                                           command=self.EditDevis)

        self.BtnPlus = BtnAction(self.CanvasFrmFond, int(self.SX * 0.985), int(self.SY * 0.044), self.RatioX * 0.52,
                                 self.RatioX * 0.52, 'Media/FrmConsomProd/BtnPlus/')
        self.BtnPlus.CanvasBtn.bind('<ButtonRelease-1>', self.AjoutMatACom)

        for l in range(self.TabMatACom.NLine):
            for k in range(self.TabMatACom.NCol):
                def GestEvt(evt, Line=l, Col=k):
                    return self.ModifVal(evt, Line, Col)

                def GestEvt2(evt):
                    return self.AnnulModifVal(evt)

                self.TabMatACom.TabLabels[l][k].bind('<Double-1>', GestEvt)
                self.TabMatACom.TabLabels[l][k].bind('<Button-1>', GestEvt2)

        if len(self.ListMatACom) > 0:
            for C in range(self.TabMatACom.NCol):
                def GestEvt3(evt):
                    return self.AnnulModifVal(evt)

                self.TabMatACom.TabLabelNCol[C].bind('<Button-1>', GestEvt3)

        self.CanvasFrmFond.bind("<Button-1>", self.AnnulModifVal)
        self.CanvasMenu.CanvasMenu.bind("<Button-1>", self.AnnulModifVal)
        self.TabMatACom.scrollable_canvas.interior.bind("<Button-1>", self.AnnulModifVal)
        self.TabMatACom.scrollable_canvas.bind("<Button-1>", self.AnnulModifVal)

    def ActionBtnAnnulPress(self, _):
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])

    def ActionAnnul(self, _):
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[1])
        self.TabMatACom.TabLabels[self.ListModif[-1][0]][self.ListModif[-1][1]]['text'] = self.ListModif[-1][2]
        if self.ListModif[-1][1] == 4 or self.ListModif[-1][1] == 5:
            Ptotal = int(self.TabMatACom.TabLabels[self.ListModif[-1][0]][5]['text']) * \
                     float(self.TabMatACom.TabLabels[self.ListModif[-1][0]][4]['text'].replace(',', '.'))
            self.TabMatACom.TabLabels[self.ListModif[-1][0]][6]['text'] = ("%.2f" % Ptotal).replace('.', ',')
            self.ListTabMatACOM[self.ListModif[-1][0]][self.ListModif[-1][1]] = \
                self.TabMatACom.TabLabels[self.ListModif[-1][0]][self.ListModif[-1][1]]['text']
            self.ListTabMatACOM[self.ListModif[-1][0]][6] = self.TabMatACom.TabLabels[self.ListModif[-1][0]][6]['text']
        self.SaveModifVal(self.ListModif[-1][0], self.ListModif[-1][1])
        del self.ListModif[-1]
        if len(self.ListModif) == 0:
            self.CanvasBtnRetour.destroy()
            self.CanvasBtnRetour = None

    def FillTabMatACOM(self, List):
        ListIndex = []
        DebIndex = 0
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            ListIndex = [29, 17, 14]
            DebIndex = 15
        elif self.MainAppli.BaseEnCours == 'PHYS':
            ListIndex = [24, 12, 9]
            DebIndex = 10
        for i in range(len(List)):
            Qstock = 0
            self.TabMatACom.TabLabels[i][0]['text'] = List[i][0]
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                Qstock = int(List[i][13])
            elif self.MainAppli.BaseEnCours == 'PHYS':
                Qstock = 0
                for c in range(4, 9, 2):
                    if List[i][c] != '' and List[i][c] is not None:
                        Qstock = Qstock + int(List[i][c])

            for j in range(4):
                if List[i][DebIndex + j] != '' and List[i][DebIndex + j] is not None:
                    self.TabMatACom.TabLabels[i][j + 1]['text'] = List[i][DebIndex + j]
                else:
                    self.TabMatACom.TabLabels[i][j + 1]['text'] = '?'

            if List[i][ListIndex[0]] != '' and List[i][ListIndex[0]] is not None:
                if List[i][ListIndex[1]] != '' and List[i][ListIndex[1]] is not None:
                    self.TabMatACom.TabLabels[i][5]['text'] = str(
                        int(float(List[i][ListIndex[0]]) / float(List[i][ListIndex[1]])))
                    try:
                        Ptotal = int(self.TabMatACom.TabLabels[i][5]['text']) * float(
                            self.TabMatACom.TabLabels[i][4]['text'].replace(',', '.'))
                        self.TabMatACom.TabLabels[i][6]['text'] = ("%.2f" % Ptotal).replace('.', ',')
                    except:
                        self.TabMatACom.TabLabels[i][6]['text'] = '?'
                else:
                    self.TabMatACom.TabLabels[i][5]['text'] = str(List[i][ListIndex[0]])
                    self.TabMatACom.TabLabels[i][6]['text'] = '?'
            elif self.TabMatACom.TabLabels[i][1]['text'] != '?':
                if List[i][ListIndex[1]] != '' and List[i][ListIndex[1]] is not None:
                    if List[i][ListIndex[2]] != '' and List[i][ListIndex[2]] is not None:
                        self.TabMatACom.TabLabels[i][5]['text'] = str(
                            int((float(List[i][ListIndex[2]]) * self.CoefSecu - Qstock) / float(
                                List[i][ListIndex[1]])) + 1)
                    else:
                        self.TabMatACom.TabLabels[i][5]['text'] = '?'
                    try:
                        Ptotal = int(self.TabMatACom.TabLabels[i][5]['text']) * float(
                            self.TabMatACom.TabLabels[i][4]['text'].replace(',', '.'))
                        self.TabMatACom.TabLabels[i][6]['text'] = ("%.2f" % Ptotal).replace('.', ',')
                    except:
                        self.TabMatACom.TabLabels[i][6]['text'] = '?'
                else:
                    self.TabMatACom.TabLabels[i][5]['text'] = '?'
                    self.TabMatACom.TabLabels[i][6]['text'] = '?'
            else:
                try:
                    QMatACom = int(float(List[i][ListIndex[2]]) * self.CoefSecu - Qstock) + 1
                    self.TabMatACom.TabLabels[i][5]['text'] = str(QMatACom)
                    self.TabMatACom.TabLabels[i][6]['text'] = '?'
                except:
                    self.TabMatACom.TabLabels[i][5]['text'] = '1'
                    self.TabMatACom.TabLabels[i][6]['text'] = '?'

    def AjoutMatACom(self, _):
        self.ActionAjoutMatACom(0)

    def ActionAjoutMatACom(self, N):
        self.FrmAjoutMatACom = FrmAjoutMatACom(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY, N, self)

    def ModifMatACom(self):
        self.ActionAjoutMatACom(1)
        self.FrmAjoutMatACom.EntryMat.Data.set(self.TabMatACom.TabLabels[self.LineSelect][0]['text'])
        self.FrmAjoutMatACom.ActionModifMat()

    def SupMatACom(self):
        Mat = self.TabMatACom.TabLabels[self.LineSelect][0]['text']
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            if self.ListMatACom[self.LineSelect][29] != '' and self.ListMatACom[self.LineSelect][29] is not None:
                self.MainAppli.cur.execute('UPDATE MATERIEL SET QCOM ="" WHERE NOMS="' + Mat + '"')
            else:
                self.MainAppli.cur.execute('UPDATE MATERIEL SET QCOMANNUL ="OUI" WHERE NOMS="' + Mat + '"')
            self.MainAppli.DataBaseChimie.commit()
            self.MainAppli.SaveListModifDTB('Chimie', 'Suppression matériel à commander - ' + Mat)
        elif self.MainAppli.BaseEnCours == 'PHYS':
            if self.ListMatACom[self.LineSelect][24] != '' and self.ListMatACom[self.LineSelect][24] is not None:
                self.MainAppli.curphys.execute('UPDATE MATERIEL SET QCOM ="" WHERE NOMS="' + Mat + '"')
            else:
                self.MainAppli.curphys.execute('UPDATE MATERIEL SET QCOMANNUL ="OUI" WHERE NOMS="' + Mat + '"')
            self.MainAppli.DataBasePhys.commit()
            self.MainAppli.SaveListModifDTB('Physique', 'Suppression matériel à commander - ' + Mat)
        self.AffichTabMatACom(0)

    def EditBonCom(self):
        if self.TabMatACom.TabLabels[self.LineSelect][1]['text'] != '' \
                and self.TabMatACom.TabLabels[self.LineSelect][1]['text'] != '?':
            self.FrmBonCom = FrmBonCom(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY, self.ListTabMatACOM,
                                       self.TabMatACom.TabLabels[self.LineSelect][1]['text'], 1, self)
        else:
            tkMB.showwarning('Attention', "Veuillez indiquer le fournisseur du matériel", parent=self)

    def EditDevis(self):
        self.FrmBonCom = FrmBonCom(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY, self.ListTabMatACOM,
                                   self.TabMatACom.TabLabels[self.LineSelect][1]['text'], 4, self)

    def AffichTabMatAComDelay(self, Index):
        self.EffaceMenu()
        LabelInCanvas(self.CanvasMenu.CanvasMenu, self.AffichList[Index], '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.004), tk.NW)
        Index = 0
        Type = ''
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabMat + " from MATERIEL order by NOMS")
            self.ListMats = self.MainAppli.cur.fetchall()
            Index = 30
            Type = 'chimie'
        elif self.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.curphys.execute("select " + self.MainAppli.ListChampsTabMatPhys +
                                           " from MATERIEL order by NOMS")
            self.ListMats = self.MainAppli.curphys.fetchall()
            Index = 25
            Type = 'physique'
        self.ListMatAComAnnul = []

        for i in range(len(self.ListMats)):
            if self.ListMats[i][Index] == 'OUI':
                self.ListMatAComAnnul.append(self.ListMats[i])

        self.TabMatACom = Tableau(self.CanvasMenu.CanvasMenu, len(self.ListMatAComAnnul), 7,
                                  ['Désignation', 'Fournisseur', 'Référence', 'Conditionnement',
                                   'Prix unitaire HT (€]', 'Quantité', 'Prix total HT (€)'],
                                  [0.05, 0.01, 0.01, 0.01, 0.01, 0.008, 0.01],
                                  AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                  AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)
        self.FillTabMatACOM(self.ListMatAComAnnul)

        self.MenuClicDroitTabMatAComAnnul = []
        for r in range(len(self.ListMatAComAnnul)):
            ListMenu = []
            for i in range(7):
                ListMenu.append(tk.Menu(self.TabMatACom.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabMatAComAnnul, j)

                self.TabMatACom.TabLabels[r][i].bind("<Button-3>", GestEvt)
            self.MenuClicDroitTabMatAComAnnul.append(ListMenu)

        for r in range(self.TabMatACom.NLine):
            self.MenuClicDroitTabMatAComAnnul[r][0].add_command(label="Valider la commande du matériel de " + Type,
                                                                command=self.ValidMatACom)
            self.MenuClicDroitTabMatAComAnnul[r][0].add_separator()
            self.MenuClicDroitTabMatAComAnnul[r][0].add_command(label="Supprimer le matériel de " + Type +
                                                                      " en attente de validation",
                                                                command=self.SupMatAComDelay)

    def ValidMatACom(self):
        Mat = self.TabMatACom.TabLabels[self.LineSelect][0]['text']
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.cur.execute("UPDATE MATERIEL SET QCOMANNUL ='' WHERE " + 'NOMS="' + Mat + '"')
            self.MainAppli.DataBaseChimie.commit()
            self.MainAppli.SaveListModifDTB('Chimie', 'Validation matériel à commander - ' + Mat)
        elif self.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.curphys.execute("UPDATE MATERIEL SET QCOMANNUL ='' WHERE " + 'NOMS="' + Mat + '"')
            self.MainAppli.DataBasePhys.commit()
            self.MainAppli.SaveListModifDTB('Physique', 'Validation matériel à commander - ' + Mat)

        self.AffichTabMatAComDelay(1)

    def SupMatAComDelay(self):
        Mat = self.TabMatACom.TabLabels[self.LineSelect][0]['text']
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.cur.execute("UPDATE MATERIEL SET QUTIL ='' WHERE " + 'NOMS="' + Mat + '"')
            self.MainAppli.DataBaseChimie.commit()
            self.MainAppli.SaveListModifDTB('Chimie', 'Suppression matériel à commander en attente de validation - '
                                            + Mat)
        elif self.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.curphys.execute("UPDATE MATERIEL SET QUTIL ='' WHERE " + 'NOMS="' + Mat + '"')
            self.MainAppli.DataBasePhys.commit()
            self.MainAppli.SaveListModifDTB('Physique', 'Suppression matériel à commander en attente de validation - '
                                            + Mat)
        self.ValidMatACom()

    def AffichTabComDelay(self, Index):
        self.EffaceMenu()
        LabelInCanvas(self.CanvasMenu.CanvasMenu, self.AffichList[Index], '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.004), tk.NW)

        if self.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabBonComProd +
                                       " from BonsCommandeMateriel WHERE CLOTURE = 'NON' order by NBON")
            self.ListComDelay = self.MainAppli.cur.fetchall()
        elif self.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.curphys.execute("select " + self.MainAppli.ListChampsTabBonComProd +
                                           " from BonsCommandeMateriel WHERE CLOTURE = 'NON' order by NBON")
            self.ListComDelay = self.MainAppli.curphys.fetchall()

        ListNBonComDelay = []
        for i in range(len(self.ListComDelay)):
            if self.ListComDelay[i][0] not in ListNBonComDelay:
                ListNBonComDelay.append(self.ListComDelay[i][0])

        self.TabComDelay = Tableau(self.CanvasMenu.CanvasMenu, len(ListNBonComDelay), 5,
                                   ['Numéro de bon', 'Date', 'Fournisseur', 'Nombre de matériels \n commandés',
                                    'Prix total TTC (€)'], [0.015, 0.015, 0.015, 0.015, 0.015],
                                   AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                   AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)

        for j in range(len(ListNBonComDelay)):
            for i in range(len(self.ListComDelay)):
                if self.ListComDelay[i][0] == ListNBonComDelay[j]:
                    self.TabComDelay.TabLabels[j][0]['text'] = self.ListComDelay[i][0]
                    self.TabComDelay.TabLabels[j][1]['text'] = FormatDate(self.ListComDelay[i][1])
                    self.TabComDelay.TabLabels[j][2]['text'] = self.ListComDelay[i][2]
                    self.TabComDelay.TabLabels[j][3]['text'] = self.ListComDelay[i][3]
                    Ptotal = (float(self.ListComDelay[i][4].replace(',', '.')) +
                              float(self.ListComDelay[i][5].replace(',', '.'))) * self.TVA
                    self.TabComDelay.TabLabels[j][4]['text'] = ("%.2f" % Ptotal).replace('.', ',')
                    break

        self.MenuClicDroitTabComDelay = []
        for r in range(self.TabComDelay.NLine):
            ListMenu = []
            for i in range(5):
                ListMenu.append(tk.Menu(self.TabComDelay.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, k=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabComDelay, k)

                def GestEvt2(evt, k=r):
                    return self.ActionAffichBonComDelay(evt, k)

                self.TabComDelay.TabLabels[r][i].bind("<Button-3>", GestEvt)
                self.TabComDelay.TabLabels[r][i].bind("<Double-1>", GestEvt2)
            self.MenuClicDroitTabComDelay.append(ListMenu)

        for r in range(self.TabComDelay.NLine):
            self.MenuClicDroitTabComDelay[r][0].add_command(label="Visualiser le bon de commande",
                                                            command=self.AffichBonComDelay)
            self.MenuClicDroitTabComDelay[r][0].add_separator()
            self.MenuClicDroitTabComDelay[r][0].add_command(label="Supprimer le bon de commande",
                                                            command=self.SupBonComDelay)

    def ActionAffichBonComDelay(self, _, k):
        self.LineSelect = k
        self.AffichBonComDelay()

    def AffichBonComDelay(self):
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabBonComProd +
                                       " from BonsCommandeMateriel WHERE NBON = '" +
                                       self.TabComDelay.TabLabels[self.LineSelect][0]['text'] + "' order by PRODUIT")
            self.ListMatComDelay = self.MainAppli.cur.fetchall()
        elif self.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.curphys.execute("select " + self.MainAppli.ListChampsTabBonComProd +
                                           " from BonsCommandeMateriel WHERE NBON = '" +
                                           self.TabComDelay.TabLabels[self.LineSelect][0][
                                               'text'] + "' order by PRODUIT")
            self.ListMatComDelay = self.MainAppli.curphys.fetchall()

        self.FrmBonCom = FrmBonCom(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY, self.ListMatComDelay,
                                   self.TabComDelay.TabLabels[self.LineSelect][2]['text'], 2, self)

    def SupBonComDelay(self):
        Rep = tkMB.askyesno('Attention', 'Voulez-vous supprimer le bon de commande "' +
                            self.TabComDelay.TabLabels[self.LineSelect][0]['text'] +
                            '" en attente de livraison?', parent=self)
        if Rep:
            if self.MainAppli.BaseEnCours == "CHIMIE":
                self.MainAppli.cur.execute("SELECT PRODUIT FROM BonsCommandeMateriel WHERE NBON='" +
                                           self.TabComDelay.TabLabels[self.LineSelect][0]['text'] + "'")
                ListMat = self.MainAppli.cur.fetchall()
                for i in range(len(ListMat)):
                    self.MainAppli.cur.execute("UPDATE MATERIEL SET QenCOM ='' WHERE " + 'NOMS="' + ListMat[i][0] + '"')
                self.MainAppli.cur.execute("DELETE FROM BonsCommandeMateriel WHERE NBON='" +
                                           self.TabComDelay.TabLabels[self.LineSelect][0]['text'] + "'")
                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie', 'Suppression bon de commande - '
                                                + self.TabComDelay.TabLabels[self.LineSelect][0]['text'])
            elif self.MainAppli.BaseEnCours == "PHYS":
                self.MainAppli.curphys.execute("SELECT PRODUIT FROM BonsCommandeMateriel WHERE NBON='" +
                                               self.TabComDelay.TabLabels[self.LineSelect][0]['text'] + "'")
                ListMat = self.MainAppli.cur.fetchall()
                for i in range(len(ListMat)):
                    self.MainAppli.curphys.execute("UPDATE MATERIEL SET QenCOM ='' WHERE " + 'NOMS="' + ListMat[i][0] +
                                                   '"')
                self.MainAppli.curphys.execute("DELETE FROM BonsCommandeMateriel WHERE NBON='" +
                                               self.TabComDelay.TabLabels[self.LineSelect][0]['text'] + "'")
                self.MainAppli.DataBasePhys.commit()
                self.MainAppli.SaveListModifDTB('Physique', 'Suppression bon de commande - '
                                                + self.TabComDelay.TabLabels[self.LineSelect][0]['text'])

            self.AffichTabComDelay(2)

    def AffichTabRecapCom(self, Index):
        self.EffaceMenu()
        LabelInCanvas(self.CanvasMenu.CanvasMenu, self.AffichList[Index], '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.004), tk.NW)

        ListBonCom = []
        if self.MainAppli.BaseEnCours == "CHIMIE":
            self.MainAppli.cur.execute("SELECT NBON, DATE, FOURNISSEUR, NBRPROD, PRIXTOTCOM, FRAISPORT "
                                       "FROM BonsCommandeMateriel WHERE CLOTURE = 'OUI' order by NBON")
            ListBonCom = self.MainAppli.cur.fetchall()
        elif self.MainAppli.BaseEnCours == "PHYS":
            self.MainAppli.curphys.execute("SELECT NBON, DATE, FOURNISSEUR, NBRPROD, PRIXTOTCOM, FRAISPORT "
                                           "FROM BonsCommandeMateriel WHERE CLOTURE = 'OUI' order by NBON")
            ListBonCom = self.MainAppli.curphys.fetchall()

        self.AnneeListe = []
        self.AnneeListe.append(str(datetime.now().date().year))
        for i in range(len(ListBonCom)):
            if ListBonCom[i][0][0:4] not in self.AnneeListe:
                self.AnneeListe.append(ListBonCom[i][0][0:4])
        self.AnneeListe.sort()

        self.ListAnnee = ListeDeroulante(self.CanvasMenu.CanvasMenu,
                                         int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01),
                                         textvariable=self.StringAnnee, values=self.AnneeListe)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.978),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.004),
                                                 anchor=tk.NE,
                                                 window=self.ListAnnee)
        self.ListAnnee.bind('<<ComboboxSelected>>', self.SelectAnnee)
        self.StringAnnee.set(self.AnneeSelect)

        self.BonComAnnuel = []
        for i in range(len(ListBonCom)):
            if ListBonCom[i][0][0:4] == self.StringAnnee.get() and ListBonCom[i] not in self.BonComAnnuel:
                self.BonComAnnuel.append(ListBonCom[i])

        self.TabRecapComAnnuel = Tableau(self.CanvasMenu.CanvasMenu, len(self.BonComAnnuel), 5,
                                         ['Numéro de bon', 'Date', 'Fournisseur', 'Nombre de matériels \n commandés',
                                          'Prix total TTC (€)'], [0.015, 0.015, 0.015, 0.015, 0.015],
                                         AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                         AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)

        self.TotalTTC = 0
        for i in range(len(self.BonComAnnuel)):
            for j in range(4):
                if j == 1:
                    self.TabRecapComAnnuel.TabLabels[i][j]['text'] = FormatDate(self.BonComAnnuel[i][j])
                else:
                    self.TabRecapComAnnuel.TabLabels[i][j]['text'] = self.BonComAnnuel[i][j]
            if self.BonComAnnuel[i][5] != '' and self.BonComAnnuel[i][5] is not None:
                Ptotal = (float(self.BonComAnnuel[i][4].replace(',', '.')) +
                          float(self.BonComAnnuel[i][5].replace(',', '.'))) * self.TVA
            else:
                Ptotal = float(self.BonComAnnuel[i][4].replace(',', '.')) * self.TVA
            self.TotalTTC = self.TotalTTC + Ptotal
            self.TabRecapComAnnuel.TabLabels[i][4]['text'] = ("%.2f" % Ptotal).replace('.', ',')

        if len(self.BonComAnnuel) > 0:
            labelEspace = tk.Label(self.TabRecapComAnnuel.scrollable_canvas.interior, text='', relief=tk.RIDGE,
                                   width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.015), bg='white',
                                   font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0))
            labelEspace.grid(row=self.TabRecapComAnnuel.NLine + 1, column=3)
            labelEspace2 = tk.Label(self.TabRecapComAnnuel.scrollable_canvas.interior, text='', relief=tk.RIDGE,
                                    width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.015), bg='white',
                                    font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0))
            labelEspace2.grid(row=self.TabRecapComAnnuel.NLine + 1, column=4)

            labelTitreTotal = tk.Label(self.TabRecapComAnnuel.scrollable_canvas.interior, text='TOTAL TTC ANNUEL (€)',
                                       relief=tk.RIDGE,
                                       width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.015), bg='white',
                                       font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0))
            labelTitreTotal.grid(row=self.TabRecapComAnnuel.NLine + 2, column=3)
            self.labelValTotal = tk.Label(self.TabRecapComAnnuel.scrollable_canvas.interior,
                                          text=("%.2f" % self.TotalTTC).replace('.', ','), relief=tk.RIDGE,
                                          width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.015), bg='white',
                                          font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0))
            self.labelValTotal.grid(row=self.TabRecapComAnnuel.NLine + 2, column=4)

        self.MenuClicDroitTabRecapComAnnuel = []
        for r in range(self.TabRecapComAnnuel.NLine):
            ListMenu = []
            for i in range(5):
                ListMenu.append(tk.Menu(self.TabRecapComAnnuel.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, k=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabRecapComAnnuel, k)

                def GestEvt2(evt, k=r):
                    return self.ActionAffichBonComRecap(evt, k)

                self.TabRecapComAnnuel.TabLabels[r][i].bind("<Button-3>", GestEvt)
                self.TabRecapComAnnuel.TabLabels[r][i].bind("<Double-1>", GestEvt2)
            self.MenuClicDroitTabRecapComAnnuel.append(ListMenu)

        for r in range(self.TabRecapComAnnuel.NLine):
            self.MenuClicDroitTabRecapComAnnuel[r][0].add_command(label="Visualiser le bon de commande",
                                                                  command=self.AffichBonComRecap)

    def SelectAnnee(self, _):
        self.AnneeSelect = self.StringAnnee.get()
        self.AffichTabRecapCom(3)

    def ActionAffichBonComRecap(self, _, k):
        self.LineSelect = k
        self.AffichBonComRecap()

    def AffichBonComRecap(self):
        if self.MainAppli.BaseEnCours == "CHIMIE":
            self.MainAppli.cur.execute("select " + self.MainAppli.ListChampsTabBonComProd +
                                       " from BonsCommandeMateriel WHERE NBON = '" +
                                       self.TabRecapComAnnuel.TabLabels[self.LineSelect][0]['text'] +
                                       "' order by PRODUIT")
            self.ListMatRecapCom = self.MainAppli.cur.fetchall()
        elif self.MainAppli.BaseEnCours == "PHYS":
            self.MainAppli.curphys.execute("select " + self.MainAppli.ListChampsTabBonComProd +
                                           " from BonsCommandeMateriel WHERE NBON = '" +
                                           self.TabRecapComAnnuel.TabLabels[self.LineSelect][0]['text'] +
                                           "' order by PRODUIT")
            self.ListMatRecapCom = self.MainAppli.curphys.fetchall()

        self.FrmBonCom = FrmBonCom(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY, self.ListMatRecapCom,
                                   self.TabRecapComAnnuel.TabLabels[self.LineSelect][2]['text'], 3, self)

    def AffichTabRecapQCom(self, Index):
        self.EffaceMenu()
        LabelInCanvas(self.CanvasMenu.CanvasMenu, self.AffichList[Index], '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.004), tk.NW)

        ListBonCom = []
        if self.MainAppli.BaseEnCours == "CHIMIE":
            self.MainAppli.cur.execute(
                "SELECT NBON, PRODUIT, COND, QUANTITE FROM BonsCommandeMateriel WHERE CLOTURE = 'OUI' order by NBON")
            ListBonCom = self.MainAppli.cur.fetchall()
        elif self.MainAppli.BaseEnCours == "PHYS":
            self.MainAppli.curphys.execute(
                "SELECT NBON, PRODUIT, COND, QUANTITE FROM BonsCommandeMateriel WHERE CLOTURE = 'OUI' order by NBON")
            ListBonCom = self.MainAppli.curphys.fetchall()

        self.AnneeListe = []
        self.AnneeListe.append(str(datetime.now().date().year))
        for i in range(len(ListBonCom)):
            if ListBonCom[i][0][0:4] not in self.AnneeListe:
                self.AnneeListe.append(ListBonCom[i][0][0:4])
        self.AnneeListe.sort()

        self.ListAnnee = ListeDeroulante(self.CanvasMenu.CanvasMenu,
                                         int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01),
                                         textvariable=self.StringAnnee, values=self.AnneeListe)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.978),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.004),
                                                 anchor=tk.NE,
                                                 window=self.ListAnnee)
        self.ListAnnee.bind('<<ComboboxSelected>>', self.SelectAnnee2)
        self.StringAnnee.set(self.AnneeSelect)

        self.BonComAnnuel = []
        for i in range(len(ListBonCom)):
            if ListBonCom[i][0][0:4] == self.AnneeSelect:
                self.BonComAnnuel.append(ListBonCom[i])

        self.TabRecapQComAnnuel = Tableau(self.CanvasMenu.CanvasMenu, len(self.BonComAnnuel), 2,
                                          ['Matériels', 'Quantité'], [0.05, 0.015],
                                          AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                          AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)

        for i in range(len(self.BonComAnnuel)):
            self.TabRecapQComAnnuel.TabLabels[i][0]['text'] = self.BonComAnnuel[i][1]
            self.TabRecapQComAnnuel.TabLabels[i][1]['text'] = str(
                int(self.BonComAnnuel[i][2]) * int(self.BonComAnnuel[i][3]))

    def SelectAnnee2(self, _):
        self.AnneeSelect = self.StringAnnee.get()
        self.AffichTabRecapQCom(4)

    def EffaceMenu(self):
        self.ListModif = []
        for widget in self.CanvasMenu.CanvasMenu.winfo_children():
            widget.destroy()
        if self.BtnPlus is not None:
            self.BtnPlus.CanvasBtn.destroy()
            self.BtnPlus = None
        if self.CanvasBtnRetour is not None:
            self.CanvasBtnRetour.destroy()
            self.CanvasBtnRetour = None

    def AffichMenuClicDroit(self, event, MenuClicDroitTab, j):
        MenuClicDroitTab[j][0].post(event.x_root, event.y_root)
        self.LineSelect = j

    def ModifVal(self, _, i, j):
        if j != 0 and j != 6 and self.EntryManuelVal is None:
            self.EntryManuelVal = tk.Entry(self.TabMatACom.scrollable_canvas.interior, text='',
                                           width=int(int(self.CanvasMenu.CanvasMenu['width']) * self.LCell[j]),
                                           font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                           justify='right')
            self.EntryManuelVal.grid(row=i + 1, column=j)
            self.EntryManuelVal.insert(0, self.TabMatACom.TabLabels[i][j]['text'])
            self.EntryManuelVal.focus_set()

            def GestEvt(evt):
                return self.ValidModifVal(evt, i, j)

            self.EntryManuelVal.bind('<Return>', GestEvt)
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)

    def AnnulModifVal(self, _):
        if self.EntryManuelVal is not None:
            self.EntryManuelVal.grid_forget()
            self.EntryManuelVal = None
        self.TabMatACom.ActionUnSelect()

    def ValidModifVal(self, _, i, j):
        OldVal = self.TabMatACom.TabLabels[i][j]['text']
        if self.EntryManuelVal.get() != '':
            self.TabMatACom.TabLabels[i][j]['text'] = self.EntryManuelVal.get()
            self.ListTabMatACOM[i][j] = self.TabMatACom.TabLabels[i][j]['text']
            if j == 4 or j == 5:
                try:
                    if j == 4:
                        self.TabMatACom.TabLabels[i][j]['text'] = ("%.2f" % float(
                            self.TabMatACom.TabLabels[i][j]['text'].replace(',', '.'))).replace('.', ',')
                    else:
                        int(self.EntryManuelVal.get())
                    try:
                        Ptotal = int(self.TabMatACom.TabLabels[i][5]['text']) * \
                                 float(self.TabMatACom.TabLabels[i][4]['text'].replace(',', '.'))
                        self.TabMatACom.TabLabels[i][6]['text'] = ("%.2f" % Ptotal).replace('.', ',')
                    except:
                        self.TabMatACom.TabLabels[i][6]['text'] = '?'
                    self.ListTabMatACOM[i][6] = self.TabMatACom.TabLabels[i][6]['text']
                    self.ListTabMatACOM[i][j] = self.TabMatACom.TabLabels[i][j]['text']
                except:
                    self.EntryManuelVal.delete(0, tk.END)
                    self.EntryManuelVal.insert(0, OldVal)
                    self.TabMatACom.TabLabels[i][j]['text'] = OldVal
                    self.ListTabMatACOM[i][j] = self.TabMatACom.TabLabels[i][j]['text']
            elif j == 3:
                try:
                    int(self.EntryManuelVal.get())
                except:
                    self.EntryManuelVal.delete(0, tk.END)
                    self.EntryManuelVal.insert(0, OldVal)
                    self.TabMatACom.TabLabels[i][j]['text'] = OldVal
                    self.ListTabMatACOM[i][j] = self.TabMatACom.TabLabels[i][j]['text']

            if self.EntryManuelVal.get() != OldVal:
                if self.CanvasBtnRetour is None:
                    self.ImgBtnRetour, wsize, hsize, self.CanvasBtnRetour, self.ImgCanvasBtnRetour = CanInWindow(
                        'Media/FrmMain/BtnRetour/', self.RatioX, self.RatioX, self.CanvasFrmFond, tk.CENTER,
                        int(self.SX * 0.965), int(self.SY * 0.045), 1)
                    self.CanvasBtnRetour.bind('<ButtonPress-1>', self.ActionBtnAnnulPress)
                    self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.ActionAnnul)
                    ChangeCursor(self.CanvasBtnRetour)
                self.ListModif.append([i, j, OldVal])
                self.SaveModifVal(i, j)

            self.EntryManuelVal.grid_forget()
            self.EntryManuelVal = None

        else:
            self.EntryManuelVal.insert(0, OldVal)

    def SaveModifVal(self, i, j):
        if 0 < j < 5 and self.TabMatACom.TabLabels[i][j]['text'] != '?':
            REQUETE = ['FOURNISSEUR', 'REFERENCE', 'CONDITIONNEMENT', 'PRIXHT']
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                self.MainAppli.cur.execute("UPDATE MATERIEL SET '" + REQUETE[j - 1] + "' ='" +
                                           self.TabMatACom.TabLabels[i][j]['text']
                                           + "' WHERE " + 'NOMS="' + self.TabMatACom.TabLabels[i][0]['text'] + '"')
                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie', 'Modification - ' + REQUETE[j - 1] + ' - ' +
                                                self.TabMatACom.TabLabels[i][0]['text'])
            elif self.MainAppli.BaseEnCours == 'PHYS':
                self.MainAppli.curphys.execute("UPDATE MATERIEL SET '" + REQUETE[j - 1] + "' ='" +
                                               self.TabMatACom.TabLabels[i][j]['text']
                                               + "' WHERE " + 'NOMS="' + self.TabMatACom.TabLabels[i][0]['text'] + '"')
                self.MainAppli.DataBasePhys.commit()
                self.MainAppli.SaveListModifDTB('Physique', 'Modification - ' + REQUETE[j - 1] + ' - ' +
                                                self.TabMatACom.TabLabels[i][0]['text'])

        elif j == 5:
            try:
                QCom = int(self.TabMatACom.TabLabels[i][j]['text']) * int(self.TabMatACom.TabLabels[i][3]['text'])
            except:
                QCom = int(self.TabMatACom.TabLabels[i][j]['text'])
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                self.MainAppli.cur.execute("UPDATE MATERIEL SET 'QCOM' ='" + str(QCom)
                                           + "' WHERE " + 'NOMS="' + self.TabMatACom.TabLabels[i][0]['text'] + '"')
                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie', 'Modification quantité en commande - '
                                                + self.TabMatACom.TabLabels[i][0]['text'])
            elif self.MainAppli.BaseEnCours == 'PHYS':
                self.MainAppli.curphys.execute("UPDATE MATERIEL SET 'QCOM' ='" + str(QCom)
                                               + "' WHERE " + 'NOMS="' + self.TabMatACom.TabLabels[i][0]['text'] + '"')
                self.MainAppli.DataBasePhys.commit()
                self.MainAppli.SaveListModifDTB('Physique', 'Modification quantité en commande - '
                                                + self.TabMatACom.TabLabels[i][0]['text'])

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.ImgCanvasBtnQuit, image=self.MainAppli.ImgBtnQuit[0])

    def CacheFrmCommandMat(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.ListBtnActionV[7].CanvasBtn.itemconfig(self.MainAppli.ListBtnActionV[7].ImgCanvasBtn,
                                                              image=self.MainAppli.ListBtnActionV[7].ImgBtn[0])
        self.destroy()
        self.MainAppli.parent.lift()
        self.MainAppli.Action2()


class FrmAjoutMatACom(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Action, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.Action = Action
        self.EntryMat = None
        self.ListBoxMat = None
        self.TitreQuant = None
        self.EntryQuant = None
        self.ListMats = []
        self.InfoMat = None
        self.DescriptMat = None
        self.TitreQuantACom = None
        self.QuantACom = None
        self.BtnPlus, self.BtnMoins = None, None
        self.BtnOK, self.BtnAnnul = None, None
        self.IndexElt = 0

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        coefY = float(ConfigResolution(self.MainAppli.MainAppli.Nconfig, 'YTitreFrm', self.MainAppli.MainAppli.curSave))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmAjoutMatACom)

        Titre = ''
        if self.Action == 0:
            if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                Titre = 'Ajouter des matériel de chimie à commander'
            elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                Titre = 'Ajouter des matériel de physique à commander'
        elif self.Action == 1:
            if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                Titre = 'Modifier un matériel de chimie à commander'
            elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                Titre = 'Modifier un matériel de physique à commander'

        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, Titre, '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * coefY), tk.NW)

        self.CanvasMenu1 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.965), int(self.SX * 0.003), int(self.SY * 0.031), tk.NW)

        self.CanvasMenu2 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.965), int(self.SX * 0.5), int(self.SY * 0.031), tk.N)

        self.CanvasMenu3 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.965), int(self.SX * 0.998), int(self.SY * 0.031), tk.NE)

        self.AffichSelectMat()

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)

        self.CanvasFrmFond.pack()

    def AffichSelectMat(self):
        Titre = ''
        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            Titre = "Sélection d'un matériel de chimie"
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            Titre = "Sélection d'un matériel de physique"
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, Titre, '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.004), tk.NW)

        self.EntryMat = EntryData(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.108),
                                  int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.5),
                                  int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.07), tk.CENTER,
                                  AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont + 2, 'bold', 0))

        self.EntryMat.EntryData.config(justify='center')
        self.EntryMat.EntryData.bind('<KeyRelease>', self.ModifMat)

        self.ListBoxMat = Scrollable_ListBox(self.CanvasMenu1.CanvasMenu,
                                             int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                                             int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.11),
                                             int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.158),
                                             int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.053))

        self.ListBoxMat.ListBox.bind('<<ListboxSelect>>', self.OnSelectListBox)

        self.AffichListMat()
        self.ListBoxMat.ListBox.selection_set(0)
        if len(self.ListMats) > 0:
            self.EntryMat.Data.set(self.ListMats[0][0])
            self.AffichInfoMat(0)
            self.AffichDescriptMat(0)

    def AffichListMat(self):
        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.MainAppli.cur.execute("select " + self.MainAppli.MainAppli.ListChampsTabMat +
                                                 " from MATERIEL order by NOMS")
            self.ListMats = self.MainAppli.MainAppli.cur.fetchall()
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.MainAppli.curphys.execute("select " + self.MainAppli.MainAppli.ListChampsTabMatPhys +
                                                     " from MATERIEL order by NOMS")
            self.ListMats = self.MainAppli.MainAppli.curphys.fetchall()

        self.ListBoxMat.ListBox.delete(0, tk.END)
        for i in range(len(self.ListMats)):
            self.ListBoxMat.ListBox.insert(tk.END, self.ListMats[i][0])
        self.ListBoxMat.ListBox.selection_set(0)

    def ModifMat(self, _):
        self.ActionModifMat()

    def ActionModifMat(self):
        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.MainAppli.cur.execute('SELECT ' + self.MainAppli.MainAppli.ListChampsTabMat +
                                                 ' FROM MATERIEL WHERE NOMS LIKE \"%' +
                                                 self.EntryMat.Data.get() + '%\" order by NOMS')
            self.ListMats = self.MainAppli.MainAppli.cur.fetchall()
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.MainAppli.curphys.execute('SELECT ' + self.MainAppli.MainAppli.ListChampsTabMatPhys +
                                                     ' FROM MATERIEL WHERE NOMS LIKE \"%' +
                                                     self.EntryMat.Data.get() + '%\" order by NOMS')
            self.ListMats = self.MainAppli.MainAppli.curphys.fetchall()

        self.ListBoxMat.ListBox.delete(0, tk.END)
        for i in range(len(self.ListMats)):
            self.ListBoxMat.ListBox.insert(tk.END, self.ListMats[i][0])
        self.ListBoxMat.ListBox.selection_set(0)
        if len(self.ListMats) > 0:
            self.AffichInfoMat(0)
            self.AffichDescriptMat(0)

    def OnSelectListBox(self, evt):
        try:
            w = evt.widget
            self.IndexElt = int(w.curselection()[0])
            self.EntryMat.Data.set(self.ListMats[self.IndexElt][0])
            self.AffichInfoMat(self.IndexElt)
            self.AffichDescriptMat(self.IndexElt)
        except:
            pass

    def ModifQuant(self, _):
        try:
            int(self.EntryQuant.Data.get())
        except:
            self.EntryQuant.Data.set('')

    def AffichInfoMat(self, NMat):
        self.EffaceMenu3()
        Titre = ''
        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            Titre = "Stock / Fournisseur du matériel de chimie sélectionné"
            self.InfoMat = InfoMatChim(self.CanvasMenu3.CanvasMenu, self.ListMats[NMat],
                                       self.MainAppli.MainAppli.cur, self.MainAppli.MainAppli.SizeFont, self.RatioX,
                                       self.RatioY, 3, self.MainAppli.MainAppli.LieuxStockMatChim)
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            Titre = "Stock / Fournisseur du matériel de physique sélectionné"
            self.InfoMat = InfoMatPhys(self.CanvasMenu3.CanvasMenu, self.ListMats[NMat],
                                       self.MainAppli.MainAppli.curphys, self.MainAppli.MainAppli.SizeFont, self.RatioX,
                                       self.RatioY, 3, self.MainAppli.MainAppli.LieuxStockMatPhys)

        LabelInCanvas(self.CanvasMenu3.CanvasMenu, Titre, '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.002), tk.NW)

        self.TitreQuantACom = self.CanvasMenu3.CanvasMenu.create_text(
            int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.05),
            int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.952), text='Quantité à commander:',
            font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        if self.Action == 1:
            Quant = self.MainAppli.TabMatACom.TabLabels[self.MainAppli.LineSelect][5]['text']
        else:
            Quant = '1'

        self.QuantACom = LabelInCanvas(self.CanvasMenu3.CanvasMenu, Quant, 'white',
                                       AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont + 2, 'bold', 0),
                                       int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.4),
                                       int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.94), tk.NW)
        self.QuantACom.Label.config(width=int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.006),
                                    height=int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.003), relief=tk.RIDGE)

        self.BtnPlus = BtnAction(self.CanvasMenu3.CanvasMenu, int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.48),
                                 int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.95), self.RatioX * 1.1,
                                 self.RatioX * 1.1, 'Media/FrmAjout/BtnPlus/')
        self.BtnPlus.CanvasBtn.bind('<ButtonRelease-1>', self.QuantAComPlus)
        self.BtnMoins = BtnAction(self.CanvasMenu3.CanvasMenu, int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.48),
                                  int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.97), self.RatioX * 1.1,
                                  self.RatioX * 1.1, 'Media/FrmAjout/BtnMoins/')
        self.BtnMoins.CanvasBtn.bind('<ButtonRelease-1>', self.QuantAComMoins)

        self.BtnOK = BtnAction(self.CanvasMenu3.CanvasMenu, int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.88),
                               int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.96), self.RatioX * 0.75,
                               self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidAjoutMatACom)
        self.BtnAnnul = BtnAction(self.CanvasMenu3.CanvasMenu, int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.95),
                                  int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.96), self.RatioX * 0.75,
                                  self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.CacheFrmAjoutMatACom)

    def AffichDescriptMat(self, NMat):
        self.EffaceMenu2()
        Titre = ''
        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            Titre = "Informations sur le matériel de chimie sélectionné"
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            Titre = "Informations sur le matériel de physique sélectionné"
        LabelInCanvas(self.CanvasMenu2.CanvasMenu, Titre, '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.002), tk.NW)
        self.DescriptMat = DescriptMat(self.CanvasMenu2.CanvasMenu, self.ListMats[NMat],
                                       self.MainAppli.MainAppli.BaseEnCours,
                                       self.MainAppli.MainAppli.SizeFont, self.RatioX, self.RatioY)

    def QuantAComPlus(self, _):
        self.BtnPlus.CanvasBtn.itemconfig(self.BtnPlus.ImgCanvasBtn, image=self.BtnPlus.ImgBtn[0])
        self.QuantACom.Label.config(text=str(int(self.QuantACom.Label['text']) + 1))

    def QuantAComMoins(self, _):
        self.BtnMoins.CanvasBtn.itemconfig(self.BtnMoins.ImgCanvasBtn, image=self.BtnMoins.ImgBtn[0])
        if int(self.QuantACom.Label['text']) > 1:
            self.QuantACom.Label.config(text=str(int(self.QuantACom.Label['text']) - 1))

    def EffaceMenu3(self):
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        if self.InfoMat is not None:
            self.CanvasMenu3.CanvasMenu.delete(self.InfoMat.NomMat)
            self.CanvasMenu3.CanvasMenu.delete(self.InfoMat.TitreStock)
            self.CanvasMenu3.CanvasMenu.delete(self.InfoMat.TitreFournisseur)
            self.CanvasMenu3.CanvasMenu.delete(self.TitreQuantACom)
            self.InfoMat = None

    def EffaceMenu2(self):
        for widget in self.CanvasMenu2.CanvasMenu.winfo_children():
            widget.destroy()

    def ValidAjoutMatACom(self, _):
        self.BtnOK.CanvasBtn.itemconfig(self.BtnOK.ImgCanvasBtn, image=self.BtnOK.ImgBtn[0])
        Rep = True
        if self.ListMats[self.IndexElt][0] in self.MainAppli.ListNomsMatACom:
            Rep = tkMB.askyesno('Attention', self.ListMats[self.IndexElt][0]
                                + '" est déja présent dans la liste des matériels de chimie à commander, '
                                  'souhaitez-vous mettre à jour les données?', parent=self)
        if Rep:
            if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                if self.ListMats[self.IndexElt][12] != '' and self.ListMats[self.IndexElt][12] is not None:
                    QuantACOM = int(self.QuantACom.Label['text']) * int(self.ListMats[self.IndexElt][17])
                else:
                    QuantACOM = int(self.QuantACom.Label['text'])
                self.MainAppli.MainAppli.cur.execute('UPDATE MATERIEL SET QCOM ="' + str(QuantACOM) +
                                                     '" WHERE NOMS=\"' + self.ListMats[self.IndexElt][0] + '\"')
                self.MainAppli.MainAppli.DataBaseChimie.commit()
                self.MainAppli.MainAppli.SaveListModifDTB('Chimie', 'Ajout matériel à commander - '
                                                          + self.ListMats[self.IndexElt][0])
            elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                if self.ListMats[self.IndexElt][12] != '' and self.ListMats[self.IndexElt][12] is not None:
                    QuantACOM = int(self.QuantACom.Label['text']) * int(self.ListMats[self.IndexElt][12])
                else:
                    QuantACOM = int(self.QuantACom.Label['text'])
                self.MainAppli.MainAppli.curphys.execute('UPDATE MATERIEL SET QCOM ="' + str(QuantACOM) +
                                                         '" WHERE NOMS=\"' + self.ListMats[self.IndexElt][0] + '\"')
                self.MainAppli.MainAppli.DataBasePhys.commit()
                self.MainAppli.MainAppli.SaveListModifDTB('Physique', 'Ajout matériel à commander - '
                                                          + self.ListMats[self.IndexElt][0])
            self.CacheFrmAjoutMatACom(_)

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.MainAppli.ImgCanvasBtnQuit,
                                                          image=self.MainAppli.MainAppli.ImgBtnQuit[0])

    def CacheFrmAjoutMatACom(self, _):
        self.MainAppli.AffichTabMatACom(0)
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.destroy()
        self.MainAppli.FrmAjoutMatACom = None
        self.MainAppli.MainAppli.parent.lift()
        self.MainAppli.MainAppli.FrmLift()
        self.MainAppli.lift()


class FrmBonCom(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, ListMatACom, Fournisseur, NAction, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.Fournisseur = Fournisseur
        self.ListMatACom = ListMatACom
        self.NAction = NAction
        self.ListMatBonCom = []
        self.TabBonCom = None
        self.FraisPort = 0.0
        self.TotalHT = 0
        self.TotalTTC = 0
        self.labelValTotal = None
        self.labelFrais = None
        self.labelTotalTTC = None
        self.ImgFournisseur = None
        self.MenuClicDroitTabBonCom = []
        self.LineSelect = 0
        self.EntryManuelVal = None
        self.TVA = self.MainAppli.TVA
        self.LCell = []
        self.MenuClicDroitTabBonComSup = []
        self.ListModif = []
        self.Four = []

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        coefY = float(ConfigResolution(self.MainAppli.MainAppli.Nconfig, 'YTitreFrm', self.MainAppli.MainAppli.curSave))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmBonCom)

        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            self.Type = "chimie"
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            self.Type = "physique"

        Titre = ''
        if self.NAction == 1:
            Titre = 'Bons de commandes de matériels de ' + self.Type
        elif self.NAction == 2:
            Titre = 'Bons de commandes de matériels de ' + self.Type + ' en attente de livraison'
        elif self.NAction == 3:
            Titre = 'Bons de commandes de matériels de ' + self.Type + ' livrés'
        elif self.NAction == 4:
            Titre = 'Commande de matériels de ' + self.Type + ' - Demande de devis'

        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, Titre, '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * coefY), tk.NW)
        if self.NAction < 4:
            self.CanvasMenu = CanvasMenu(self.CanvasFrmFond, 'Media/FrmCom/BonCom/', int(self.SX * 0.994),
                                         int(self.SY * 0.78), int(self.SX * 0.5), int(self.SY * 0.56), tk.CENTER)
        else:
            self.CanvasMenu = CanvasMenu(self.CanvasFrmFond, 'Media/FrmCom/BonCom/', int(self.SX * 0.994),
                                         int(self.SY * 0.9), int(self.SX * 0.5), int(self.SY * 0.5), tk.CENTER)
        if self.NAction != 3:
            self.BtnOK = BtnAction(self.CanvasFrmFond, int(int(self.CanvasFrmFond['width']) * 0.945),
                                   int(int(self.CanvasFrmFond['height']) * 0.975), self.RatioX * 0.75,
                                   self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
            self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidBonCom)
            self.BtnAnnul = BtnAction(self.CanvasFrmFond, int(int(self.CanvasFrmFond['width']) * 0.97),
                                      int(int(self.CanvasFrmFond['height']) * 0.975), self.RatioX * 0.75,
                                      self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
            self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.CacheFrmBonCom)

        self.ImgBtnRetour, wsize, hsize, self.CanvasBtnRetour, self.ImgCanvasBtnRetour = CanInWindow(
            'Media/FrmMain/BtnRetour/', self.RatioX, self.RatioX, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.965), int(self.SY * 0.014), 0)
        self.CanvasBtnRetour.bind('<ButtonPress-1>', self.ActionBtnAnnulPress)
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.ActionAnnul)

        self.AffichBondeCom()

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)

        self.CanvasFrmFond.pack()

    def AffichBondeCom(self):
        Logo = []
        if self.NAction < 4:
            if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                self.MainAppli.MainAppli.cur.execute('SELECT Logo FROM Fournisseurs WHERE NOM LIKE \'%' +
                                                     self.Fournisseur + '%\' order by NOM')
                Logo = self.MainAppli.MainAppli.cur.fetchall()
                self.Four = ChercheFour(self.MainAppli.MainAppli.cur,
                                        self.MainAppli.MainAppli.ListChampsTabFournisseurs, self.Fournisseur)
            elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                self.MainAppli.MainAppli.curphys.execute('SELECT Logo FROM Fournisseurs WHERE NOM LIKE \'%' +
                                                         self.Fournisseur + '%\' order by NOM')
                Logo = self.MainAppli.MainAppli.curphys.fetchall()
                self.Four = ChercheFour(self.MainAppli.MainAppli.curphys,
                                        self.MainAppli.MainAppli.ListChampsTabFournisseurs, self.Fournisseur)
            if len(Logo) > 0 and Logo[0][0] != '' and Logo[0][0] is not None:
                PathLogo = 'Datas/Fournisseurs/Logos/' + Logo[0][0]
            else:
                PathLogo = 'Datas/Fournisseurs/Logos/Vide'

            self.ImgFournisseur = ImgInCanvas(self.CanvasFrmFond, PathLogo, 0.1, tk.CENTER,
                                              int(int(self.CanvasFrmFond['width']) * 0.07),
                                              int(int(self.CanvasFrmFond['height']) * 0.11))

            if len(Logo) == 0 or Logo[0][0] == '' or Logo[0][0] is None:
                if len(self.Fournisseur) < 15:
                    TextFournisseur = self.Fournisseur
                else:
                    TextFournisseur = self.Fournisseur.split(' ')[0] + '\n' + self.Fournisseur.split(' ')[1]
                self.ImgFournisseur.CanvasImg.create_text(
                    int(int(self.ImgFournisseur.CanvasImg['width']) * 0.5),
                    int(int(self.ImgFournisseur.CanvasImg['height']) * 0.5), text=TextFournisseur,
                    font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont + 4, 'bold', 0), anchor=tk.CENTER,
                    justify=tk.CENTER)

            if len(self.Four) > 0:
                c = 0
                for i in [0, 12, 1, 2, 3, 4, 10, 11]:
                    Text = ''
                    if i != 4 and i != 10 and i != 11:
                        if self.Four[0][i] is not None:
                            Text = self.Four[0][i]
                    elif i == 4:
                        if self.Four[0][i] is not None:
                            Text = 'Tel: ' + self.Four[0][i]
                    elif i == 10:
                        if self.Four[0][i] is not None:
                            Text = 'Fax: ' + self.Four[0][i]
                    elif i == 11:
                        if self.Four[0][i] is not None:
                            Text = 'Email: ' + self.Four[0][i]

                    if Text != '':
                        LabelInCanvas(self.CanvasFrmFond, Text, 'white',
                                      AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0),
                                      int(int(self.CanvasFrmFond['width']) * 0.13),
                                      int(int(self.CanvasFrmFond['height']) * 0.06 + c * int(
                                          self.CanvasFrmFond['height']) * 0.017), tk.W)
                        c += 1

        if self.NAction == 1:
            if not self.ListMatBonCom:
                for i in range(len(self.ListMatACom)):
                    if self.ListMatACom[i][1] == self.Fournisseur:
                        self.ListMatBonCom.append(self.ListMatACom[i])

            self.LCell = [0.05, 0.02, 0.013, 0.013, 0.01, 0.013]
            self.TabBonCom = Tableau(self.CanvasMenu.CanvasMenu, len(self.ListMatBonCom), 6,
                                     ['Désignation', 'Référence', 'Conditionnement',
                                      'Prix unitaire HT (€]', 'Quantité', 'Prix total HT (€)'], self.LCell,
                                     AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                                     AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)

            self.TotalHT = 0
            self.FraisPort = 0.0
            for i in range(len(self.ListMatBonCom)):
                self.TabBonCom.TabLabels[i][0]['text'] = self.ListMatBonCom[i][0]
                self.TabBonCom.TabLabels[i][1]['text'] = self.ListMatBonCom[i][2]
                self.TabBonCom.TabLabels[i][2]['text'] = self.ListMatBonCom[i][3]
                self.TabBonCom.TabLabels[i][3]['text'] = self.ListMatBonCom[i][4]
                self.TabBonCom.TabLabels[i][4]['text'] = self.ListMatBonCom[i][5]
                self.TabBonCom.TabLabels[i][5]['text'] = self.ListMatBonCom[i][6]
                if self.ListMatBonCom[i][6] != '' and self.ListMatBonCom[i][6] is not None and \
                        self.ListMatBonCom[i][6] != '?':
                    self.TotalHT = self.TotalHT + float(self.ListMatBonCom[i][6].replace(',', '.'))
            self.TotalTTC = self.TotalHT * self.TVA

            self.MenuClicDroitTabBonComSup = []
            for r in range(self.TabBonCom.NLine):
                ListMenu = []
                for k in range(6):
                    ListMenu.append(tk.Menu(self.TabBonCom.TabLabels[r][k], tearoff=0))

                    def GestEvt(evt, L=r):
                        return self.AffichMenuClicDroitSup(evt, self.MenuClicDroitTabBonComSup, L)

                    self.TabBonCom.TabLabels[r][k].bind("<Button-3>", GestEvt)
                self.MenuClicDroitTabBonComSup.append(ListMenu)

            for r in range(self.TabBonCom.NLine):
                for k in range(6):
                    self.MenuClicDroitTabBonComSup[r][k].add_command(
                        label='Supprimer le matériel de ' + self.Type + ' du bon de commande', command=self.SupMat)

        elif self.NAction == 2 or self.NAction == 3:
            self.CanvasFrmFond.create_text(
                int(int(self.CanvasFrmFond['width']) * 0.8), int(int(self.CanvasFrmFond['height']) * 0.05),
                text='N° de Bon: ' + self.ListMatACom[0][0],
                font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.W)

            self.CanvasFrmFond.create_text(
                int(int(self.CanvasFrmFond['width']) * 0.8), int(int(self.CanvasFrmFond['height']) * 0.08),
                text='Date: ' + FormatDate(self.ListMatACom[0][1]),
                font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.W)

            self.LCell = [0.048, 0.018, 0.011, 0.011, 0.01, 0.013, 0.008]
            self.TabBonCom = Tableau(self.CanvasMenu.CanvasMenu, len(self.ListMatACom), 7,
                                     ['Désignation', 'Référence', 'Conditionnement', 'Prix unitaire HT (€]',
                                      'Quantité', 'Prix total HT (€)', 'Matériel livré'], self.LCell,
                                     AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                                     AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)

            self.TotalHT = float(self.ListMatACom[0][4].replace(',', '.'))
            if self.ListMatACom[0][5] != '' and self.ListMatACom[0][5] is not None:
                self.FraisPort = float(self.ListMatACom[0][5].replace(',', '.'))
            else:
                self.FraisPort = 0
            self.TotalTTC = (self.TotalHT + self.FraisPort) * self.TVA

            for i in range(len(self.ListMatACom)):
                self.TabBonCom.TabLabels[i][0]['text'] = self.ListMatACom[i][6]
                self.TabBonCom.TabLabels[i][1]['text'] = self.ListMatACom[i][7]
                self.TabBonCom.TabLabels[i][2]['text'] = self.ListMatACom[i][8]
                self.TabBonCom.TabLabels[i][3]['text'] = self.ListMatACom[i][9]
                self.TabBonCom.TabLabels[i][4]['text'] = self.ListMatACom[i][10]
                self.TabBonCom.TabLabels[i][5]['text'] = self.ListMatACom[i][11]
                self.TabBonCom.TabLabels[i][6]['text'] = self.ListMatACom[i][12]

            if self.NAction == 2:
                self.MenuClicDroitTabBonCom = []
                self.MenuClicDroitTabBonComSup = []
                for r in range(self.TabBonCom.NLine):
                    ListMenu = []
                    self.MenuClicDroitTabBonCom.append(tk.Menu(self.TabBonCom.TabLabels[r][6], tearoff=0))

                    def GestEvt(evt, L=r):
                        return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabBonCom, L)

                    self.TabBonCom.TabLabels[r][6].bind("<Button-3>", GestEvt)

                    for k in range(6):
                        ListMenu.append(tk.Menu(self.TabBonCom.TabLabels[r][k], tearoff=0))

                        def GestEvt2(evt, L=r):
                            return self.AffichMenuClicDroitSup(evt, self.MenuClicDroitTabBonComSup, L)

                        self.TabBonCom.TabLabels[r][k].bind("<Button-3>", GestEvt2)
                    self.MenuClicDroitTabBonComSup.append(ListMenu)

                for r in range(self.TabBonCom.NLine):
                    self.MenuClicDroitTabBonCom[r].add_command(label='Livré', command=self.MatLivraison)
                    self.MenuClicDroitTabBonCom[r].add_command(label='Non livré', command=self.MatNonLivraison)
                    for k in range(6):
                        self.MenuClicDroitTabBonComSup[r][k].add_command(
                            label='Supprimer le matériel de ' + self.Type + ' du bon de commande',
                            command=self.SupMatComDelay)

        elif self.NAction == 4:
            self.LCell = [0.05, 0.02, 0.02, 0.015, 0.012]
            self.TabBonCom = Tableau(self.CanvasMenu.CanvasMenu, len(self.ListMatACom) - 1, 5,
                                     ['Désignation', 'Fournisseur', 'Référence', 'Conditionnement', 'Quantité'],
                                     self.LCell,
                                     AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                                     AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)
            for i in range(self.TabBonCom.NLine):
                for j in range(3):
                    self.TabBonCom.TabLabels[i][j]['text'] = self.ListMatACom[i][j]
                self.TabBonCom.TabLabels[i][3]['text'] = self.ListMatACom[i][3]
                self.TabBonCom.TabLabels[i][4]['text'] = self.ListMatACom[i][5]

            self.MenuClicDroitTabBonComSup = []
            for r in range(self.TabBonCom.NLine):
                ListMenu = []
                for k in range(5):
                    ListMenu.append(tk.Menu(self.TabBonCom.TabLabels[r][k], tearoff=0))

                    def GestEvt(evt, L=r):
                        return self.AffichMenuClicDroitSup(evt, self.MenuClicDroitTabBonComSup, L)

                    self.TabBonCom.TabLabels[r][k].bind("<Button-3>", GestEvt)
                self.MenuClicDroitTabBonComSup.append(ListMenu)

            for r in range(self.TabBonCom.NLine):
                for k in range(5):
                    self.MenuClicDroitTabBonComSup[r][k].add_command(
                        label='Supprimer le matériel de ' + self.Type + ' de la demande de devis', command=self.SupMat)

        for l in range(self.TabBonCom.NLine):
            for k in range(self.TabBonCom.NCol):
                def GestEvt(evt, Line=l, Col=k):
                    return self.ModifVal(evt, Line, Col)

                def GestEvt2(evt):
                    return self.AnnulModifVal(evt)

                self.TabBonCom.TabLabels[l][k].bind('<Double-1>', GestEvt)
                self.TabBonCom.TabLabels[l][k].bind('<Button-1>', GestEvt2)

        for C in range(self.TabBonCom.NCol):
            def GestEvt3(evt):
                return self.AnnulModifVal(evt)

            self.TabBonCom.TabLabelNCol[C].bind('<Button-1>', GestEvt3)

        if self.NAction < 4:
            labelEspace = tk.Label(self.TabBonCom.scrollable_canvas.interior, text='', relief=tk.RIDGE,
                                   width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01), bg='white',
                                   font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0))
            labelEspace.grid(row=self.TabBonCom.NLine + 1, column=4)
            labelEspace2 = tk.Label(self.TabBonCom.scrollable_canvas.interior, text='', relief=tk.RIDGE,
                                    width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.013), bg='white',
                                    font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0))
            labelEspace2.grid(row=self.TabBonCom.NLine + 1, column=5)

            labelTitreTotal = tk.Label(self.TabBonCom.scrollable_canvas.interior, text='TOTAL HT (€)', relief=tk.RIDGE,
                                       width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01), bg='white',
                                       font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0))
            labelTitreTotal.grid(row=self.TabBonCom.NLine + 2, column=4)
            self.labelValTotal = tk.Label(self.TabBonCom.scrollable_canvas.interior,
                                          text=("%.2f" % self.TotalHT).replace('.', ','), relief=tk.RIDGE,
                                          width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.013), bg='white',
                                          font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0))
            self.labelValTotal.grid(row=self.TabBonCom.NLine + 2, column=5)
            labelTitreFrais = tk.Label(self.TabBonCom.scrollable_canvas.interior, text='Frais de port HT (€)',
                                       relief=tk.RIDGE,
                                       width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01), bg='white',
                                       font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0))
            labelTitreFrais.grid(row=self.TabBonCom.NLine + 3, column=4)
            self.labelFrais = tk.Label(self.TabBonCom.scrollable_canvas.interior,
                                       text=("%.2f" % self.FraisPort).replace('.', ','), relief=tk.RIDGE,
                                       width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.013), bg='white',
                                       font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0))
            self.labelFrais.grid(row=self.TabBonCom.NLine + 3, column=5)
            self.labelFrais.bind('<Double-1>', self.ModifFraisPort)

            labelTitreTotalTTC = tk.Label(self.TabBonCom.scrollable_canvas.interior, text='TOTAL TTC (€)',
                                          relief=tk.RIDGE,
                                          width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01), bg='white',
                                          font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0))
            labelTitreTotalTTC.grid(row=self.TabBonCom.NLine + 4, column=4)
            self.labelTotalTTC = tk.Label(self.TabBonCom.scrollable_canvas.interior,
                                          text=("%.2f" % self.TotalTTC).replace('.', ','), relief=tk.RIDGE,
                                          width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.013), bg='white',
                                          font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0))
            self.labelTotalTTC.grid(row=self.TabBonCom.NLine + 4, column=5)

        self.CanvasFrmFond.bind("<Button-1>", self.AnnulModifVal)
        self.TabBonCom.scrollable_canvas.interior.bind("<Button-1>", self.AnnulModifVal)
        self.TabBonCom.scrollable_canvas.bind("<Button-1>", self.AnnulModifVal)

    def SupMat(self):
        if self.NAction != 4:
            if len(self.ListMatBonCom) > 1:
                MatSup = self.ListMatBonCom[self.LineSelect][0]
                Rep = tkMB.askyesno('Attention', 'Voulez-vous supprimer "' + MatSup
                                    + '" du bon de commande ?', parent=self)
                if Rep:
                    del self.ListMatBonCom[self.LineSelect]
                    self.AffichBondeCom()
            else:
                Rep = tkMB.askyesno('Attention', "Voulez-vous annuler l'édition du bon de commande ?", parent=self)
                if Rep:
                    self.RetourTabMatACom()
        else:
            if len(self.ListMatACom) - 1 > 1:
                MatSup = self.ListMatACom[self.LineSelect][0]
                Rep = tkMB.askyesno('Attention', 'Voulez-vous supprimer "' + MatSup
                                    + '" de la demande de devis ?', parent=self)
                if Rep:
                    del self.ListMatACom[self.LineSelect]
                    self.AffichBondeCom()
            else:
                Rep = tkMB.askyesno('Attention', "Voulez-vous annuler la demande de devis ?", parent=self)
                if Rep:
                    self.RetourTabMatACom()

    def RetourTabMatACom(self):
        self.MainAppli.AffichTabMatACom(0)
        self.destroy()
        self.MainAppli.MainAppli.parent.lift()
        self.MainAppli.MainAppli.FrmLift()
        self.MainAppli.lift()

    def SupMatComDelay(self):
        if len(self.ListMatACom) > 1:
            MatSup = self.ListMatACom[self.LineSelect][6]
            Rep = tkMB.askyesno('Attention', 'Voulez-vous supprimer "' + self.ListMatACom[self.LineSelect][6]
                                + '" du bon de commande "' + self.ListMatACom[0][0] + '" en attente de livraison?',
                                parent=self)
            if Rep:
                del self.ListMatACom[self.LineSelect]
                self.AffichBondeCom()
                self.CalculTotalHT()
                self.CalculTotalTTC()
                if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                    self.MainAppli.MainAppli.cur.execute("DELETE FROM BonsCommandeMateriel WHERE NBON='" +
                                                         self.ListMatACom[0][0] + "' and " + 'PRODUIT="' + MatSup + '"')
                    self.MainAppli.MainAppli.cur.execute(
                        "UPDATE BonsCommandeMateriel SET PRIXTOTCOM ='" + str(self.TotalHT) +
                        "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                    self.MainAppli.MainAppli.cur.execute(
                        "UPDATE BonsCommandeMateriel SET NBRPROD ='" + str(self.TabBonCom.NLine) +
                        "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                    self.MainAppli.MainAppli.cur.execute("UPDATE MATERIEL SET QenCOM ='' WHERE " + 'NOMS="' + MatSup +
                                                         '"')
                    self.MainAppli.MainAppli.DataBaseChimie.commit()
                    self.MainAppli.MainAppli.SaveListModifDTB('Chimie', 'Suppression matériel en commande - ' + MatSup)
                elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                    self.MainAppli.MainAppli.curphys.execute("DELETE FROM BonsCommandeMateriel WHERE NBON='" +
                                                             self.ListMatACom[0][0] + "' and " + 'PRODUIT="' + MatSup +
                                                             '"')
                    self.MainAppli.MainAppli.curphys.execute(
                        "UPDATE BonsCommandeMateriel SET PRIXTOTCOM ='" + str(self.TotalHT) +
                        "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                    self.MainAppli.MainAppli.curphys.execute(
                        "UPDATE BonsCommandeMateriel SET NBRPROD ='" + str(self.TabBonCom.NLine) +
                        "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                    self.MainAppli.MainAppli.curphys.execute("UPDATE MATERIEL SET QenCOM ='' WHERE " + 'NOMS="' +
                                                             MatSup + '"')
                    self.MainAppli.MainAppli.DataBasePhys.commit()
                    self.MainAppli.MainAppli.SaveListModifDTB('Physique', 'Suppression matériel en commande - ' +
                                                              MatSup)
        else:
            self.MainAppli.SupBonComDelay()

    def ModifVal(self, _, i, j):
        if j != 0 and j != 5 and self.EntryManuelVal is None and self.NAction != 3:
            self.EntryManuelVal = tk.Entry(self.TabBonCom.scrollable_canvas.interior, text='',
                                           width=int(int(self.CanvasMenu.CanvasMenu['width']) * self.LCell[j]),
                                           font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                                           justify='right')
            self.EntryManuelVal.grid(row=i + 1, column=j)
            self.EntryManuelVal.insert(0, self.TabBonCom.TabLabels[i][j]['text'])
            self.EntryManuelVal.focus_set()

            def GestEvt(evt):
                return self.ValidModifVal(evt, i, j)

            self.EntryManuelVal.bind('<Return>', GestEvt)
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)

    def ModifFraisPort(self, _):
        if self.EntryManuelVal is None and self.NAction != 3:
            self.EntryManuelVal = tk.Entry(self.TabBonCom.scrollable_canvas.interior, text='',
                                           width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.013),
                                           font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                                           justify='right')
            self.EntryManuelVal.grid(row=self.TabBonCom.NLine + 3, column=5)
            self.EntryManuelVal.insert(0, self.labelFrais['text'])
            self.EntryManuelVal.focus_set()
            self.EntryManuelVal.bind('<Return>', self.ValidModifFrais)
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)

    def ValidModifVal(self, _, i, j):
        OldVal = self.TabBonCom.TabLabels[i][j]['text']
        if self.EntryManuelVal.get() != '':
            self.TabBonCom.TabLabels[i][j]['text'] = self.EntryManuelVal.get()
            if (j == 4 or j == 3) and self.NAction != 4:
                try:
                    Ptotal = int(self.TabBonCom.TabLabels[i][4]['text']) * \
                             float(self.TabBonCom.TabLabels[i][3]['text'].replace(',', '.'))
                    self.TabBonCom.TabLabels[i][5]['text'] = ("%.2f" % Ptotal).replace('.', ',')
                    self.CalculTotalHT()
                    self.CalculTotalTTC()
                    if j == 3:
                        self.TabBonCom.TabLabels[i][j]['text'] = ("%.2f" % float(
                            self.EntryManuelVal.get().replace(',', '.'))).replace('.', ',')
                except:
                    self.EntryManuelVal.delete(0, tk.END)
                    self.EntryManuelVal.insert(0, OldVal)
                    self.TabBonCom.TabLabels[i][j]['text'] = OldVal
            elif j == 2:
                try:
                    int(self.EntryManuelVal.get().split(' ')[0])
                except:
                    self.EntryManuelVal.delete(0, tk.END)
                    self.EntryManuelVal.insert(0, OldVal)
                    self.TabBonCom.TabLabels[i][j]['text'] = OldVal
            elif j == 6 and self.NAction == 2:
                if self.EntryManuelVal.get().upper() != 'OUI' and self.EntryManuelVal.get().upper() != 'NON':
                    self.EntryManuelVal.delete(0, tk.END)
                    self.EntryManuelVal.insert(0, OldVal)
                    self.TabBonCom.TabLabels[i][j]['text'] = OldVal
                else:
                    self.TabBonCom.TabLabels[i][j]['text'] = self.EntryManuelVal.get().upper()

            if self.EntryManuelVal.get() != OldVal:
                self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[1])
                ChangeCursor(self.CanvasBtnRetour)
                self.ListModif.append([i, j, OldVal])
                self.SaveModifVal(i, j)

            self.EntryManuelVal.grid_forget()
            self.EntryManuelVal = None
        else:
            self.EntryManuelVal.insert(0, OldVal)

    def SaveModifVal(self, i, j):
        if j == 1 or j == 2 or j == 3:
            REQUETE = ['REFERENCE', 'CONDITIONNEMENT', 'PRIXHT']
            Val = self.TabBonCom.TabLabels[i][j]['text']
            if self.MainAppli.MainAppli.BaseEnCours == "CHIMIE":
                self.MainAppli.MainAppli.cur.execute("UPDATE MATERIEL SET '" + REQUETE[j - 1] + "' ='" + Val
                                                     + "' WHERE " + 'NOMS="' + self.TabBonCom.TabLabels[i][0][
                                                         'text'] + '"')
                self.MainAppli.MainAppli.DataBaseChimie.commit()
                self.MainAppli.MainAppli.SaveListModifDTB('Chimie', 'Modification bon de commande - ' +
                                                          REQUETE[j - 1] + ' - ' +
                                                          self.TabBonCom.TabLabels[i][0]['text'])
            elif self.MainAppli.MainAppli.BaseEnCours == "PHYS":
                self.MainAppli.MainAppli.curphys.execute("UPDATE MATERIEL SET '" + REQUETE[j - 1] + "' ='" + Val
                                                         + "' WHERE " + 'NOMS="' + self.TabBonCom.TabLabels[i][0][
                                                             'text'] + '"')
                self.MainAppli.MainAppli.DataBasePhys.commit()
                self.MainAppli.MainAppli.SaveListModifDTB('Physique', 'Modification bon de commande - ' +
                                                          REQUETE[j - 1] + ' - ' +
                                                          self.TabBonCom.TabLabels[i][0]['text'])
            if self.NAction != 1 and self.NAction != 4:
                REQUETE = ['REFERENCE', 'COND', 'PRIXUNIT', 'PRIXTOTAL', 'PRIXTOTCOM']
                if j == 2:
                    Val = self.TabBonCom.TabLabels[i][j]['text']
                if self.MainAppli.MainAppli.BaseEnCours == "CHIMIE":
                    self.MainAppli.MainAppli.cur.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[j - 1] + "'='" + Val + "' WHERE NBON='" +
                        self.ListMatACom[0][0] + "' and " + 'PRODUIT="' + self.TabBonCom.TabLabels[i][0]['text'] + '"')
                    self.MainAppli.MainAppli.cur.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[3] + "'='" + self.TabBonCom.TabLabels[i][5][
                            'text'] + "' WHERE NBON='" +
                        self.ListMatACom[0][0] + "'and " + 'PRODUIT="' + self.TabBonCom.TabLabels[i][0]['text'] + '"')
                    self.MainAppli.MainAppli.cur.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[4] + "'='" + self.labelValTotal[
                            'text'] + "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                    self.MainAppli.MainAppli.DataBaseChimie.commit()
                    self.MainAppli.MainAppli.SaveListModifDTB('Chimie', 'Modification bon de commande - '
                                                              + self.ListMatACom[0][0])
                elif self.MainAppli.MainAppli.BaseEnCours == "PHYS":
                    self.MainAppli.MainAppli.curphys.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[j - 1] + "'='" + Val + "' WHERE NBON='" +
                        self.ListMatACom[0][0] + "' and " + 'PRODUIT="' + self.TabBonCom.TabLabels[i][0]['text'] + '"')
                    self.MainAppli.MainAppli.curphys.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[3] + "'='" + self.TabBonCom.TabLabels[i][5][
                            'text'] + "' WHERE NBON='" +
                        self.ListMatACom[0][0] + "'and " + 'PRODUIT="' + self.TabBonCom.TabLabels[i][0]['text'] + '"')
                    self.MainAppli.MainAppli.curphys.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[4] + "'='" + self.labelValTotal[
                            'text'] + "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                    self.MainAppli.MainAppli.DataBasePhys.commit()
                    self.MainAppli.MainAppli.SaveListModifDTB('Physique', 'Modification bon de commande - '
                                                              + self.ListMatACom[0][0])
        elif j == 4 and self.NAction != 1 and self.NAction != 4:
            REQUETE = ['QUANTITE', 'PRIXTOTAL', 'PRIXTOTCOM']
            for c in range(2):
                if self.MainAppli.MainAppli.BaseEnCours == "CHIMIE":
                    self.MainAppli.MainAppli.cur.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[0 + c] + "'='" +
                        self.TabBonCom.TabLabels[i][4 + c]['text'] + "' WHERE NBON='" +
                        self.ListMatACom[0][0] + "'and " + 'PRODUIT="' + self.TabBonCom.TabLabels[i][0]['text'] + '"')
                    self.MainAppli.MainAppli.cur.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[2] + "'='" + self.labelValTotal[
                            'text'] + "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                    self.MainAppli.MainAppli.DataBaseChimie.commit()
                    self.MainAppli.MainAppli.SaveListModifDTB('Chimie', 'Modification bon de commande - '
                                                              + self.ListMatACom[0][0])
                elif self.MainAppli.MainAppli.BaseEnCours == "PHYS":
                    self.MainAppli.MainAppli.curphys.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[0 + c] + "'='" +
                        self.TabBonCom.TabLabels[i][4 + c]['text'] + "' WHERE NBON='" +
                        self.ListMatACom[0][0] + "'and " + 'PRODUIT="' + self.TabBonCom.TabLabels[i][0]['text'] + '"')
                    self.MainAppli.MainAppli.curphys.execute(
                        "UPDATE BonsCommandeMateriel SET '" + REQUETE[2] + "'='" + self.labelValTotal[
                            'text'] + "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                    self.MainAppli.MainAppli.DataBasePhys.commit()
                    self.MainAppli.MainAppli.SaveListModifDTB('Physique', 'Modification bon de commande - '
                                                              + self.ListMatACom[0][0])

    def ValidModifFrais(self, _):
        OldVal = self.labelFrais['text']
        if self.EntryManuelVal.get() != '':
            try:
                self.labelFrais['text'] = ("%.2f" % float(self.EntryManuelVal.get().replace(',', '.'))).replace('.',
                                                                                                                ',')
                self.FraisPort = float(self.labelFrais['text'].replace(',', '.'))
                self.CalculTotalTTC()
                if self.NAction != 1:
                    if self.MainAppli.MainAppli.BaseEnCours == "CHIMIE":
                        self.MainAppli.MainAppli.cur.execute(
                            "UPDATE BonsCommandeMateriel SET FRAISPORT = '" + self.labelFrais[
                                'text'] + "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                        self.MainAppli.MainAppli.DataBaseChimie.commit()
                        self.MainAppli.MainAppli.SaveListModifDTB('Chimie',
                                                                  'Modification bon de commande - Frais de port - '
                                                                  + self.ListMatACom[0][0])
                    elif self.MainAppli.MainAppli.BaseEnCours == "PHYS":
                        self.MainAppli.MainAppli.curphys.execute(
                            "UPDATE BonsCommandeMateriel SET FRAISPORT = '" + self.labelFrais[
                                'text'] + "' WHERE NBON='" + self.ListMatACom[0][0] + "'")
                        self.MainAppli.MainAppli.DataBasePhys.commit()
                        self.MainAppli.MainAppli.SaveListModifDTB('Physique',
                                                                  'Modification bon de commande - Frais de port - '
                                                                  + self.ListMatACom[0][0])

            except:
                self.labelFrais['text'] = OldVal
            self.EntryManuelVal.grid_forget()
            self.EntryManuelVal = None
        else:
            self.EntryManuelVal.insert(0, OldVal)

    def AnnulModifVal(self, _):
        if self.EntryManuelVal is not None:
            self.EntryManuelVal.grid_forget()
            self.EntryManuelVal = None
        self.TabBonCom.ActionUnSelect()

    def CalculTotalHT(self):
        PtotalHT = 0
        for r in range(self.TabBonCom.NLine):
            PtotalHT = PtotalHT + float(self.TabBonCom.TabLabels[r][5]['text'].replace(',', '.'))
        self.labelValTotal['text'] = ("%.2f" % PtotalHT).replace('.', ',')
        self.TotalHT = PtotalHT

    def CalculTotalTTC(self):
        PtotalTTC = (float(self.labelValTotal['text'].replace(',', '.')) + float(
            self.labelFrais['text'].replace(',', '.'))) * self.TVA
        self.labelTotalTTC['text'] = ("%.2f" % PtotalTTC).replace('.', ',')

    def ValidBonCom(self, _):
        self.BtnOK.CanvasBtn.itemconfig(self.BtnOK.ImgCanvasBtn, image=self.BtnOK.ImgBtn[0])
        if self.NAction == 1:
            Date = datetime.now()
            An = str(Date.date().year)
            Mois = str(Date.date().month)
            Jour = str(Date.date().day)
            ValidCommande = True

            NumBon = self.DeterminNBon()
            NBon = An + ' - ' + str("%03d" % NumBon)

            for i in range(len(self.ListMatBonCom)):
                for j in range(2, 6):
                    if self.TabBonCom.TabLabels[i][j]['text'] == '?':
                        tkMB.showwarning('Attention', "Veuillez indiquer le conditionnement, le prix unitaire et la "
                                                      "quantité des matériels commandés !", parent=self)
                        ValidCommande = False
                        break
                if not ValidCommande:
                    break

            if ValidCommande:
                for i in range(len(self.ListMatBonCom)):
                    data = [(NBon, An + '-' + Mois + '-' + Jour, self.Fournisseur, len(self.ListMatBonCom),
                             ("%.2f" % self.TotalHT).replace('.', ','), ("%.2f" % self.FraisPort).replace('.', ','),
                             self.TabBonCom.TabLabels[i][0]['text'], self.TabBonCom.TabLabels[i][1]['text'],
                             self.TabBonCom.TabLabels[i][2]['text'], self.TabBonCom.TabLabels[i][3]['text'],
                             self.TabBonCom.TabLabels[i][4]['text'], self.TabBonCom.TabLabels[i][5]['text'], 'NON',
                             'NON')]
                    QenCom = str(int(self.TabBonCom.TabLabels[i][2]['text']) *
                                 int(self.TabBonCom.TabLabels[i][4]['text']))
                    if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                        self.MainAppli.MainAppli.cur.execute(
                            "INSERT INTO BonsCommandeMateriel(" + self.MainAppli.MainAppli.ListChampsTabBonComProd +
                            ") VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", data[0])
                        self.MainAppli.MainAppli.cur.execute('UPDATE MATERIEL SET QCOM ="" WHERE NOMS="' +
                                                             self.ListMatBonCom[i][0] + '"')
                        self.MainAppli.MainAppli.cur.execute(
                            'UPDATE MATERIEL SET QenCOM ="' + QenCom + '" WHERE NOMS="' +
                            self.ListMatBonCom[i][0] + '"')
                    elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                        self.MainAppli.MainAppli.curphys.execute(
                            "INSERT INTO BonsCommandeMateriel(" + self.MainAppli.MainAppli.ListChampsTabBonComProd +
                            ") VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", data[0])
                        self.MainAppli.MainAppli.curphys.execute('UPDATE MATERIEL SET QCOM ="" WHERE NOMS="' +
                                                                 self.ListMatBonCom[i][0] + '"')
                        self.MainAppli.MainAppli.curphys.execute('UPDATE MATERIEL SET QenCOM ="' + QenCom +
                                                                 '" WHERE NOMS="' + self.ListMatBonCom[i][0] + '"')

                if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                    self.MainAppli.MainAppli.DataBaseChimie.commit()
                    self.MainAppli.MainAppli.SaveListModifDTB('Chimie', 'Validation bon de commande - ' + NBon)
                elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                    self.MainAppli.MainAppli.DataBasePhys.commit()
                    self.MainAppli.MainAppli.SaveListModifDTB('Physique', 'Validation bon de commande - ' + NBon)
                self.CacheFrmBonCom(_)

        elif self.NAction == 2:
            Livraison = True
            for i in range(self.TabBonCom.NLine):
                if self.TabBonCom.TabLabels[i][6]['text'] == 'NON':
                    Livraison = False
            if not Livraison:
                tkMB.showwarning('Attention', "La commande n'a pas été livrée en totalité !", parent=self)
            else:
                FrmMAJStock(self.MainAppli.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY,
                            self.MainAppli.ListMatComDelay, self)

        elif self.NAction == 4:
            Devis = SaveToPDF(self.CanvasMenu.CanvasMenu, 'Datas/Devis/', 'tmp.bmp')
            if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                AffichPDF('Matériels de chimie - Demande de devis', Devis, self)
            elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                AffichPDF('Matériels de physique - Demande de devis', Devis, self)
            self.CacheFrmBonCom(_)

    def ClosePDF(self):
        self.MainAppli.MainAppli.parent.focus_force()
        self.MainAppli.MainAppli.FrmLift()
        self.MainAppli.focus_force()

    def DeterminNBon(self):
        NBon = 1
        ListNBon = []
        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.MainAppli.cur.execute('SELECT NBON FROM BonsCommandeMateriel order by NBON')
            ListNBon = self.MainAppli.MainAppli.cur.fetchall()
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.MainAppli.curphys.execute('SELECT NBON FROM BonsCommandeMateriel order by NBON')
            ListNBon = self.MainAppli.MainAppli.curphys.fetchall()
        ListNBonAn = []
        for i in range(len(ListNBon)):
            if ListNBon[i][0][0:4] == str(datetime.now().date().year):
                if ListNBon[i][0][-3:] not in ListNBonAn:
                    ListNBonAn.append(ListNBon[i][0][-3:])
        ListNBonAn.sort()
        if len(ListNBonAn) > 0:
            NBon = int(ListNBonAn[-1]) + 1
        return NBon

    def AffichMenuClicDroit(self, event, MenuClicDroitTab, j):
        MenuClicDroitTab[j].post(event.x_root, event.y_root)
        self.LineSelect = j

    def AffichMenuClicDroitSup(self, event, MenuClicDroitTab, j):
        MenuClicDroitTab[j][0].post(event.x_root, event.y_root)
        self.LineSelect = j

    def MatLivraison(self):
        self.TabBonCom.TabLabels[self.LineSelect][6]['text'] = 'OUI'
        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.MainAppli.cur.execute("UPDATE BonsCommandeMateriel SET LIVRAISON ='OUI' WHERE NBON='" +
                                                 self.ListMatACom[0][0] + "' AND " + 'PRODUIT="' +
                                                 self.TabBonCom.TabLabels[self.LineSelect][0]['text'] + '"')
            self.MainAppli.MainAppli.DataBaseChimie.commit()
            self.MainAppli.MainAppli.SaveListModifDTB('Chimie', 'Mise à jour livraison matériel en commande - ' +
                                                      self.TabBonCom.TabLabels[self.LineSelect][0]['text'])
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.MainAppli.curphys.execute("UPDATE BonsCommandeMateriel SET LIVRAISON ='OUI' WHERE NBON='" +
                                                     self.ListMatACom[0][0] + "' AND " + 'PRODUIT="' +
                                                     self.TabBonCom.TabLabels[self.LineSelect][0]['text'] + '"')
            self.MainAppli.MainAppli.DataBasePhys.commit()
            self.MainAppli.MainAppli.SaveListModifDTB('Physique', 'Mise à jour livraison matériel en commande - ' +
                                                      self.TabBonCom.TabLabels[self.LineSelect][0]['text'])

    def MatNonLivraison(self):
        self.TabBonCom.TabLabels[self.LineSelect][6]['text'] = 'NON'
        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.MainAppli.cur.execute("UPDATE BonsCommandeMateriel SET LIVRAISON ='NON' WHERE NBON='" +
                                                 self.ListMatACom[0][0] + "' AND " + 'PRODUIT="' +
                                                 self.TabBonCom.TabLabels[self.LineSelect][0]['text'] + '"')
            self.MainAppli.MainAppli.DataBaseChimie.commit()
            self.MainAppli.MainAppli.SaveListModifDTB('Chimie', 'Mise à jour livraison matériel en commande - ' +
                                                      self.TabBonCom.TabLabels[self.LineSelect][0]['text'])
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.MainAppli.curphys.execute("UPDATE BonsCommandeMateriel SET LIVRAISON ='NON' WHERE NBON='" +
                                                     self.ListMatACom[0][0] + "' AND " + 'PRODUIT="' +
                                                     self.TabBonCom.TabLabels[self.LineSelect][0]['text'] + '"')
            self.MainAppli.MainAppli.DataBasePhys.commit()
            self.MainAppli.MainAppli.SaveListModifDTB('Physique', 'Mise à jour livraison matériel en commande - ' +
                                                      self.TabBonCom.TabLabels[self.LineSelect][0]['text'])

    def ActionBtnAnnulPress(self, _):
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])

    def ActionAnnul(self, _):
        self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[1])
        self.TabBonCom.TabLabels[self.ListModif[-1][0]][self.ListModif[-1][1]]['text'] = self.ListModif[-1][2]
        if (self.ListModif[-1][1] == 4 or self.ListModif[-1][1] == 3) and self.NAction != 4:
            Ptotal = int(self.TabBonCom.TabLabels[self.ListModif[-1][0]][4]['text']) * \
                     float(self.TabBonCom.TabLabels[self.ListModif[-1][0]][3]['text'].replace(',', '.'))
            self.TabBonCom.TabLabels[self.ListModif[-1][0]][5]['text'] = ("%.2f" % Ptotal).replace('.', ',')
            self.CalculTotalHT()
            self.CalculTotalTTC()
        self.SaveModifVal(self.ListModif[-1][0], self.ListModif[-1][1])
        del self.ListModif[-1]
        if len(self.ListModif) == 0:
            self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[0])

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.MainAppli.ImgCanvasBtnQuit,
                                                          image=self.MainAppli.MainAppli.ImgBtnQuit[0])

    def CacheFrmBonCom(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.destroy()
        self.MainAppli.MainAppli.parent.lift()
        self.MainAppli.MainAppli.FrmLift()
        self.MainAppli.lift()
        if self.NAction == 1 or self.NAction == 4:
            self.MainAppli.AffichTabMatACom(0)
        elif self.NAction == 2:
            self.MainAppli.AffichTabComDelay(2)
        elif self.NAction == 3:
            self.MainAppli.AffichTabRecapCom(3)


class FrmMAJStock(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, ListMat, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.ListMat = ListMat
        self.TabMAJStock = None
        self.LineSelect = 0
        self.TextQuant = None
        self.QuantToStockInit = 0
        self.QuantTotInit = 0
        self.QuantToStock = None
        self.CanvasBoite = None
        self.ImgEtiqMat = []
        self.CanvasImgEtiqMat = None
        self.ImgCanvasImgEtiqMat = None
        self.EntryLieuLabo = None
        self.EntryQuantLabo = None
        self.EntryLieuTP = None
        self.EntryQuantTP = None
        self.EntryQuantLabo2 = None
        self.EntryLieuTP2 = None
        self.EntryQuantTP2 = None
        self.EntryLieuLabo2 = None
        self.EntryLieuSpectro = None
        self.EntryQuantSpectro = None
        self.EntryQuantSpectro = None
        self.QTot = None
        self.QTotal = 0
        self.BtnOKStock = None
        self.BtnAnnulStock = None

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        self.coefY = float(ConfigResolution(self.MainAppli.MainAppli.MainAppli.Nconfig, 'YTitreFrm',
                                            self.MainAppli.MainAppli.MainAppli.curSave))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmMAJStock)

        self.LabelTag = LabelInCanvas(self.CanvasFrmFond,
                                      'Mise à jour du stock de matériels de chimie après réception de la commande',
                                      '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * self.coefY), tk.NW)

        self.CanvasMenu = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.664),
                                     int(self.SY * 0.92), int(self.SX * 0.002), int(self.SY * 0.49), tk.W)
        self.CanvasMenu2 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.332),
                                      int(self.SY * 0.92), int(self.SX * 0.998), int(self.SY * 0.49), tk.E)

        self.BtnOK = BtnAction(self.CanvasFrmFond, int(int(self.CanvasFrmFond['width']) * 0.945),
                               int(int(self.CanvasFrmFond['height']) * 0.975), self.RatioX * 0.75,
                               self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidMAJStock)
        self.BtnAnnul = BtnAction(self.CanvasFrmFond, int(int(self.CanvasFrmFond['width']) * 0.97),
                                  int(int(self.CanvasFrmFond['height']) * 0.975), self.RatioX * 0.75,
                                  self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.CacheFrmMAJStock)

        self.AffichMAJStock()
        self.SelectLine()

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)

        self.CanvasFrmFond.pack()

    def SelectLine(self):
        self.TabMAJStock.ActionUnSelect()
        self.LineSelect = 0
        for j in range(self.TabMAJStock.NLine):
            if self.TabMAJStock.TabLabels[j][4]['text'] == 'NON':
                self.LineSelect = j
                for i in range(self.TabMAJStock.NCol):
                    self.TabMAJStock.TabLabels[j][i].config(bg='#E0E0E0')
                break
        if self.LineSelect == 0:
            for i in range(self.TabMAJStock.NCol):
                self.TabMAJStock.TabLabels[0][i].config(bg='#E0E0E0')
        self.AffichLieuxStock(self.LineSelect)

    def AffichMAJStock(self):
        Titre = ''
        ListIndex = []
        if self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            Titre = 'Matériels de chimie reçus'
            ListIndex = [17, 31, 13]
        elif self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            Titre = 'Matériels de physique reçus'
            ListIndex = [12, 26]

        LabelInCanvas(self.CanvasMenu.CanvasMenu, Titre, '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'normal', 0),
                      int(self.SX * 0.005), int(self.SY * 0.004), tk.NW)
        self.TabMAJStock = Tableau(self.CanvasMenu.CanvasMenu, len(self.ListMat), 5,
                                   ['Désignation', 'Quantité en stock \n avant commande',
                                    'Quantité commandée', 'Quantité en stock \n après commande',
                                    'Commande stockée'], [0.05, 0.015, 0.015, 0.015, 0.015],
                                   AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'bold', 0),
                                   AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'normal', 0),
                                   self)
        ListMat = []
        OldQStock = ''
        for i in range(len(self.ListMat)):
            if self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                ListMat = ChercheMat(self.MainAppli.MainAppli.MainAppli.cur,
                                     self.MainAppli.MainAppli.MainAppli.ListChampsTabMat, self.ListMat[i][6])
                OldQStock = ListMat[0][13]
            elif self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                ListMat = ChercheMat(self.MainAppli.MainAppli.MainAppli.curphys,
                                     self.MainAppli.MainAppli.MainAppli.ListChampsTabMatPhys, self.ListMat[i][6])
                Q = 0
                for j in range(4, 9, 2):
                    if ListMat[0][j] != '' and ListMat[0][j] is not None:
                        Q = Q + int(ListMat[0][j])
                OldQStock = str(Q)
            self.TabMAJStock.TabLabels[i][0]['text'] = self.ListMat[i][6]
            self.TabMAJStock.TabLabels[i][2]['text'] = str(int(self.ListMat[i][10]) * int(ListMat[0][ListIndex[0]]))

            if ListMat[0][ListIndex[1]] != '' and ListMat[0][ListIndex[1]] is not None:
                self.TabMAJStock.TabLabels[i][1]['text'] = OldQStock
                QStock = int(OldQStock) + int(self.TabMAJStock.TabLabels[i][2]['text'])
                self.TabMAJStock.TabLabels[i][3]['text'] = str(QStock)
                self.TabMAJStock.TabLabels[i][4]['text'] = 'NON'
            else:
                QStock = int(OldQStock) - int(self.TabMAJStock.TabLabels[i][2]['text'])
                self.TabMAJStock.TabLabels[i][1]['text'] = str(QStock)
                self.TabMAJStock.TabLabels[i][3]['text'] = OldQStock
                self.TabMAJStock.TabLabels[i][4]['text'] = 'OUI'

        for l in range(self.TabMAJStock.NLine):
            for k in range(self.TabMAJStock.NCol):
                def GestEvt(evt, Line=l):
                    return self.SelectMat(evt, Line)

                self.TabMAJStock.TabLabels[l][k].bind('<Button-1>', GestEvt)

    def SelectMat(self, _, L):
        self.LineSelect = L
        self.AffichLieuxStock(self.LineSelect)

    def AffichLieuxStock(self, N):
        self.EffaceMenu2()
        LabelInCanvas(self.CanvasMenu2.CanvasMenu, 'Lieux de stockage du matériel reçu', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'normal', 0),
                      int(self.SX * 0.005), int(self.SY * 0.004), tk.NW)
        Mat = []
        Index = 0
        if self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            Mat = ChercheMat(self.MainAppli.MainAppli.MainAppli.cur,
                             self.MainAppli.MainAppli.MainAppli.ListChampsTabMat,
                             self.TabMAJStock.TabLabels[N][0]['text'])[0]
            Index = 31
        elif self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            Mat = ChercheMat(self.MainAppli.MainAppli.MainAppli.curphys,
                             self.MainAppli.MainAppli.MainAppli.ListChampsTabMatPhys,
                             self.TabMAJStock.TabLabels[N][0]['text'])[0]
            Index = 26

        if Mat[Index] != '' and Mat[Index] is not None:
            self.QuantToStockInit = int(self.TabMAJStock.TabLabels[N][2]['text'])
            self.QuantTotInit = int(self.TabMAJStock.TabLabels[N][1]['text'])
        else:
            self.QuantToStockInit = 0
            self.QuantTotInit = int(self.TabMAJStock.TabLabels[N][3]['text'])

        LabelInCanvas(self.CanvasMenu2.CanvasMenu, Mat[0], '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont + 3, 'bold', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.08), tk.CENTER)

        self.TextQuant = self.CanvasMenu2.CanvasMenu.create_text(
            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.05),
            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.16),
            text='Quantité à stocker:', font=AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont + 2,
                                                       'bold', 1), anchor=tk.W)
        self.QuantToStock = LabelInCanvas(self.CanvasMenu2.CanvasMenu, str(self.QuantToStockInit), '#C0C0C0',
                                          AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont + 5,
                                                    'bold', 0),
                                          int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.4),
                                          int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.16), tk.CENTER)
        self.CanvasBoite = CanvasInWindow('Media/FrmInfo/Boite/', self.RatioX * 1.4, self.RatioY * 1.4,
                                          self.CanvasMenu2.CanvasMenu, tk.CENTER,
                                          int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                          int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.55), 0)

        if Mat[2] is not None and Mat[2] != '':
            LabelInCanvas(self.CanvasBoite.CanvasListIma, Mat[2], '#C0C0C0',
                          AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont + 1, 'bold', 0),
                          int(self.CanvasBoite.wsize * 0.5), int(self.CanvasBoite.hsize * 0.1), tk.CENTER)

        if Mat[1] is not None and Mat[1] != '':
            self.ImgEtiqMat = []
            img = None
            if self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                img = Image.open('Datas/VisuelMatChim/' + Mat[1])
            elif self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                img = Image.open('Datas/VisuelMatPhys/' + Mat[1])
            imgEtiqwsize = int(self.CanvasBoite.wsize * 0.295)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasBoite.hsize * 0.115:
                imgEtiqhsize = int(self.CanvasBoite.hsize * 0.115)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqMat.append(ImageTk.PhotoImage(img))

            self.CanvasImgEtiqMat = CanvasApp(self.CanvasBoite.CanvasListIma, width=imgEtiqwsize,
                                              height=imgEtiqhsize)
            self.CanvasBoite.CanvasListIma.create_window(int(self.CanvasBoite.wsize * 0.497),
                                                         int(self.CanvasBoite.hsize * 0.158), anchor=tk.N,
                                                         window=self.CanvasImgEtiqMat)
            self.ImgCanvasImgEtiqMat = self.CanvasImgEtiqMat.create_image(0, 0, anchor=tk.NW, image=self.ImgEtiqMat[0])
            CreateCadre(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.494 - imgEtiqwsize / 2),
                        int(self.CanvasBoite.hsize * 0.155),
                        int(self.CanvasBoite.wsize * 0.500 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasBoite.hsize * 0.161) + imgEtiqhsize)

        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.35), text='Lieu de stockage',
            font=AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont + 1, 'bold', 1), anchor=tk.CENTER)
        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.35), text='Quantité',
            font=AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont + 1, 'bold', 1), anchor=tk.CENTER)

        LabelInCanvas(self.CanvasBoite.CanvasListIma, 'Laboratoire', '#C0C0C0',
                      AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.41), tk.CENTER)

        self.EntryLieuLabo = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.03),
                                       int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.465),
                                       tk.CENTER,
                                       AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'bold', 0))
        self.EntryQuantLabo = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.01),
                                        int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.465),
                                        tk.CENTER,
                                        AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'bold', 0))
        self.EntryLieuLabo.EntryData.config(justify='center')
        self.EntryQuantLabo.EntryData.config(justify='center')
        self.EntryQuantLabo.EntryData.bind('<KeyRelease>', self.CalculQTot)

        LabelInCanvas(self.CanvasBoite.CanvasListIma, 'Salle TP', '#C0C0C0',
                      AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.58), tk.CENTER)

        self.EntryLieuTP = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.03),
                                     int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.635),
                                     tk.CENTER,
                                     AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'bold', 0))
        self.EntryQuantTP = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.01),
                                      int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.635),
                                      tk.CENTER,
                                      AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'bold', 0))
        self.EntryLieuTP.EntryData.config(justify='center')
        self.EntryQuantTP.EntryData.config(justify='center')
        self.EntryQuantTP.EntryData.bind('<KeyRelease>', self.CalculQTot)

        Lieu3 = ''
        if self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            self.EntryLieuLabo2 = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.03),
                                            int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.515),
                                            tk.CENTER,
                                            AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont,
                                                      'bold', 0))
            self.EntryQuantLabo2 = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.01),
                                             int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.515),
                                             tk.CENTER,
                                             AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont,
                                                       'bold', 0))
            self.EntryLieuLabo2.EntryData.config(justify='center')
            self.EntryQuantLabo2.EntryData.config(justify='center')
            self.EntryQuantLabo2.EntryData.bind('<KeyRelease>', self.CalculQTot)
            self.EntryLieuTP2 = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.03),
                                          int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.685),
                                          tk.CENTER,
                                          AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont,
                                                    'bold', 0))
            self.EntryQuantTP2 = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.01),
                                           int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.685),
                                           tk.CENTER,
                                           AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont,
                                                     'bold', 0))
            self.EntryLieuTP2.EntryData.config(justify='center')
            self.EntryQuantTP2.EntryData.config(justify='center')
            self.EntryQuantTP2.EntryData.bind('<KeyRelease>', self.CalculQTot)

            Lieu3 = 'Salle spectroscopie'

        elif self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            Lieu3 = 'Réserve'

        LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieu3, '#C0C0C0',
                      AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.75), tk.CENTER)

        self.EntryLieuSpectro = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.03),
                                          int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.81),
                                          tk.CENTER,
                                          AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont,
                                                    'bold', 0))
        self.EntryQuantSpectro = EntryData(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.01),
                                           int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.81),
                                           tk.CENTER,
                                           AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont,
                                                     'bold', 0))
        self.EntryLieuSpectro.EntryData.config(justify='center')
        self.EntryQuantSpectro.EntryData.config(justify='center')
        self.EntryQuantSpectro.EntryData.bind('<KeyRelease>', self.CalculQTot)

        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.18), int(self.CanvasBoite.hsize * 0.88), text='Stock - Quantité totale: ',
            font=AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont + 1, 'bold', 0), anchor=tk.W)
        self.QTot = self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.88), text='0',
            font=AppliFont('Helvetica', self.MainAppli.MainAppli.MainAppli.SizeFont + 2, 'bold', 0),
            anchor=tk.CENTER, fill='blue')

        if Mat[3] is not None and Mat[3] != '':
            self.EntryLieuLabo.Data.set(Mat[3])
            self.EntryQuantLabo.Data.set(Mat[4])
        if Mat[5] is not None and Mat[5] != '' and self.MainAppli.MainAppli.MainAppli.BaseEnCours == "CHIMIE":
            self.EntryLieuLabo2.Data.set(Mat[5])
            self.EntryQuantLabo2.Data.set(Mat[6])
        if self.MainAppli.MainAppli.MainAppli.BaseEnCours == "CHIMIE":
            if Mat[7] is not None and Mat[7] != '':
                self.EntryLieuTP.Data.set(Mat[7])
                self.EntryQuantTP.Data.set(Mat[8])
            if Mat[9] is not None and Mat[9] != '':
                self.EntryLieuTP2.Data.set(Mat[9])
                self.EntryQuantTP2.Data.set(Mat[10])
            if Mat[11] is not None and Mat[11] != '':
                self.EntryLieuSpectro.Data.set(Mat[11])
                self.EntryQuantSpectro.Data.set(Mat[12])
            if Mat[13] is not None and Mat[13] != '':
                self.CanvasBoite.CanvasListIma.itemconfig(self.QTot, text=Mat[13])
                self.QTotal = int(Mat[13])
        elif self.MainAppli.MainAppli.MainAppli.BaseEnCours == "PHYS":
            if Mat[5] is not None and Mat[5] != '':
                self.EntryLieuTP.Data.set(Mat[5])
                self.EntryQuantTP.Data.set(Mat[6])
            if Mat[7] is not None and Mat[7] != '':
                self.EntryLieuSpectro.Data.set(Mat[7])
                self.EntryQuantSpectro.Data.set(Mat[8])
            self.ActionQTot()
            self.CanvasBoite.CanvasListIma.itemconfig(self.QTot, text=str(self.QTotal))

        self.BtnOKStock = BtnAction(self.CanvasMenu2.CanvasMenu,
                                    int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.88),
                                    int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.15,
                                    self.RatioX * 0.15, 'Media/FrmAjout/BtnOK/')
        self.BtnOKStock.CanvasBtn.bind('<ButtonRelease-1>', self.ValidStock)

        if Mat[Index] != '' and Mat[Index] is not None:
            self.BtnAnnulStock = BtnAction(self.CanvasMenu2.CanvasMenu,
                                           int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.95),
                                           int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.95), self.RatioX * 0.15,
                                           self.RatioX * 0.15, 'Media/FrmAjout/BtnAnnul/')
            self.BtnAnnulStock.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulStock)

    def ValidMAJStock(self, _):
        ValidStock = True
        for i in range(self.TabMAJStock.NLine):
            if self.TabMAJStock.TabLabels[i][4]['text'] == 'NON' or int(self.QuantToStock.Label['text']) != 0:
                self.BtnOK.CanvasBtn.itemconfig(self.BtnOK.ImgCanvasBtn, image=self.BtnOK.ImgBtn[0])
                tkMB.showwarning('Attention',
                                 "Veuillez indiquer un lieu de stockage pour la totalité des matériels reçus !",
                                 parent=self)
                ValidStock = False
                break

        if ValidStock:
            if self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                for i in range(len(self.ListMat)):
                    self.MainAppli.MainAppli.MainAppli.cur.execute(
                        "UPDATE BonsCommandeMateriel SET CLOTURE ='OUI' WHERE " + 'NBON="' + self.ListMat[i][
                            0] + '" AND PRODUIT="' + self.TabMAJStock.TabLabels[i][0]['text'] + '"')
                self.MainAppli.MainAppli.MainAppli.DataBaseChimie.commit()
                self.MainAppli.MainAppli.MainAppli.SaveListModifDTB('Chimie',
                                                                    'Mise à jour stock matériel - Commande livrée - ' +
                                                                    self.ListMat[0][0])
            elif self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                for i in range(len(self.ListMat)):
                    self.MainAppli.MainAppli.MainAppli.curphys.execute(
                        "UPDATE BonsCommandeMateriel SET CLOTURE ='OUI' WHERE " + 'NBON="' + self.ListMat[i][
                            0] + '" AND PRODUIT="' + self.TabMAJStock.TabLabels[i][0]['text'] + '"')
                self.MainAppli.MainAppli.MainAppli.DataBasePhys.commit()
                self.MainAppli.MainAppli.MainAppli.SaveListModifDTB('Physique',
                                                                    'Mise à jour stock matériel - Commande livrée - ' +
                                                                    self.ListMat[0][0])
            self.destroy()
            self.MainAppli.CacheFrmBonCom(_)

    def ValidStock(self, _):
        if int(self.QuantToStock.Label['text']) == 0:
            if self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
                self.MainAppli.MainAppli.MainAppli.cur.execute(
                    'UPDATE MATERIEL SET QSTOCK ="' + self.TabMAJStock.TabLabels[self.LineSelect][3]['text'] +
                    '" WHERE NOMS="' + self.TabMAJStock.TabLabels[self.LineSelect][0]['text'] + '"')
                self.MainAppli.MainAppli.MainAppli.cur.execute(
                    'UPDATE MATERIEL SET QenCOM ="" WHERE NOMS="' + self.TabMAJStock.TabLabels[self.LineSelect][0][
                        'text'] + '"')
                Lieux = ['LABOLIEU', 'LABOLIEU2', 'SALLETPLIEU', 'POSTETPLIEU', 'SPECTROLIEU']
                ValLieux = [self.EntryLieuLabo.EntryData.get(), self.EntryLieuLabo2.EntryData.get(),
                            self.EntryLieuTP.EntryData.get(), self.EntryLieuTP2.EntryData.get(),
                            self.EntryLieuSpectro.EntryData.get()]
                QuantByLieux = ['LABOQUANT', 'LABOQUANT2', 'SALLETPQUANT', 'POSTETPQUANT', 'SPECTROQUANT']
                ValQuantByLieux = [self.EntryQuantLabo.EntryData.get(), self.EntryQuantLabo2.EntryData.get(),
                                   self.EntryQuantTP.EntryData.get(), self.EntryQuantTP2.EntryData.get(),
                                   self.EntryQuantSpectro.EntryData.get()]
                for i in range(5):
                    self.MainAppli.MainAppli.MainAppli.cur.execute(
                        "UPDATE MATERIEL SET '" + Lieux[i] + "' ='" + ValLieux[i] +
                        "' WHERE " + 'NOMS="' + self.TabMAJStock.TabLabels[self.LineSelect][0]['text'] + '"')
                    self.MainAppli.MainAppli.MainAppli.cur.execute(
                        "UPDATE MATERIEL SET '" + QuantByLieux[i] + "' ='" + ValQuantByLieux[i] +
                        "' WHERE " + 'NOMS="' + self.TabMAJStock.TabLabels[self.LineSelect][0]['text'] + '"')
                self.MainAppli.MainAppli.MainAppli.DataBaseChimie.commit()
                self.MainAppli.MainAppli.MainAppli.SaveListModifDTB('Chimie',
                                                                    'Validation stock matériel - Commande livrée')

            elif self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'PHYS':
                self.MainAppli.MainAppli.MainAppli.curphys.execute(
                    "UPDATE MATERIEL SET QenCOM ='' WHERE " + 'NOMS="' + self.TabMAJStock.TabLabels[self.LineSelect][0][
                        'text'] + '"')
                Lieux = ['LABOLIEU', 'SALLETPLIEU', 'RESLIEU']
                ValLieux = [self.EntryLieuLabo.EntryData.get(), self.EntryLieuTP.EntryData.get(),
                            self.EntryLieuSpectro.EntryData.get()]
                QuantByLieux = ['LABOQUANT', 'SALLETPQUANT', 'RESQUANT']
                ValQuantByLieux = [self.EntryQuantLabo.EntryData.get(), self.EntryQuantTP.EntryData.get(),
                                   self.EntryQuantSpectro.EntryData.get()]
                for i in range(3):
                    self.MainAppli.MainAppli.MainAppli.curphys.execute(
                        "UPDATE MATERIEL SET '" + Lieux[i] + "' ='" + ValLieux[i] +
                        "' WHERE " + 'NOMS="' + self.TabMAJStock.TabLabels[self.LineSelect][0]['text'] + '"')
                    self.MainAppli.MainAppli.MainAppli.curphys.execute(
                        "UPDATE MATERIEL SET '" + QuantByLieux[i] + "' ='" + ValQuantByLieux[i] +
                        "' WHERE " + 'NOMS="' + self.TabMAJStock.TabLabels[self.LineSelect][0]['text'] + '"')
                self.MainAppli.MainAppli.MainAppli.DataBasePhys.commit()
                self.MainAppli.MainAppli.MainAppli.SaveListModifDTB('Physique',
                                                                    'Validation stock matériel - Commande livrée')

            self.AffichMAJStock()
            self.AnnulStock(_)
        else:
            self.BtnOKStock.CanvasBtn.itemconfig(self.BtnOKStock.ImgCanvasBtn, image=self.BtnOKStock.ImgBtn[0])
            tkMB.showwarning('Attention', "Veuillez indiquer un lieu de stockage pour la totalité du matériel reçu !",
                             parent=self)

    def AnnulStock(self, _):
        self.LineSelect = self.LineSelect + 1
        if self.LineSelect == self.TabMAJStock.NLine:
            self.LineSelect = 0
        boucle = 0
        LineSelectOld = self.LineSelect
        while self.TabMAJStock.TabLabels[self.LineSelect][4]['text'] == 'OUI':
            self.LineSelect = self.LineSelect + 1
            boucle = boucle + 1
            if self.LineSelect == self.TabMAJStock.NLine:
                self.LineSelect = 0
            if boucle > self.TabMAJStock.NLine:
                self.LineSelect = LineSelectOld
                break
        self.TabMAJStock.SelectLine(_, self.LineSelect)
        self.AffichLieuxStock(self.LineSelect)

    def CalculQTot(self, _):
        self.QTotal = 0
        try:
            self.ActionQTot()
            self.CalculQuantToStock()
            self.CanvasBoite.CanvasListIma.itemconfig(self.QTot, text=str(self.QTotal))
        except:
            self.CanvasBoite.CanvasListIma.itemconfig(self.QTot, text='')

    def ActionQTot(self):
        self.QTotal = 0
        if self.EntryQuantLabo.EntryData.get() != '':
            self.QTotal = self.QTotal + int(self.EntryQuantLabo.EntryData.get())
        if self.EntryQuantTP.EntryData.get() != '':
            self.QTotal = self.QTotal + int(self.EntryQuantTP.EntryData.get())
        if self.EntryQuantSpectro.EntryData.get() != '':
            self.QTotal = self.QTotal + int(self.EntryQuantSpectro.EntryData.get())
        if self.MainAppli.MainAppli.MainAppli.BaseEnCours == "CHIMIE":
            if self.EntryQuantLabo2.EntryData.get() != '':
                self.QTotal = self.QTotal + int(self.EntryQuantLabo2.EntryData.get())
            if self.EntryQuantTP2.EntryData.get() != '':
                self.QTotal = self.QTotal + int(self.EntryQuantTP2.EntryData.get())

    def CalculQuantToStock(self):
        ValQuantToStock = self.QuantTotInit + self.QuantToStockInit - self.QTotal
        self.QuantToStock.Label['text'] = str(ValQuantToStock)

    def EffaceMenu2(self):
        for widget in self.CanvasMenu2.CanvasMenu.winfo_children():
            widget.destroy()
            if self.TextQuant is not None:
                self.CanvasMenu2.CanvasMenu.delete(self.TextQuant)
                self.TextQuant = None

    def CacheFrmMAJStock(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.destroy()
        self.MainAppli.MainAppli.MainAppli.parent.lift()
        self.MainAppli.MainAppli.MainAppli.FrmLift()
        self.MainAppli.lift()

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.MainAppli.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.MainAppli.MainAppli.ImgCanvasBtnQuit,
                                                                    image=self.MainAppli.MainAppli.MainAppli.ImgBtnQuit[
                                                                        0])
