from AppliDef import *
from FrmZoom import *


class FrmDoc(tk.Toplevel):
    def __init__(self, container, ListDocs, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.ListDocs = ListDocs
        self.Page1PDF = None
        self.Page2PDF = None
        self.FilePDFAOuvrir = None
        self.PageAffich = 0
        self.NbrPagesPDF = 0
        self.DocZoom = None
        self.MenuClicDroitPDF = None
        self.ZoomActif = False

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmTP/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmTP/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.174)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.08)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.DefilPage = tk.Scale(self.CanvasFrmFond, orient=tk.HORIZONTAL, length=self.SX, showvalue=0)
        self.CanvasFrmFond.create_window(int(self.SX / 2), int(self.SY * 0.99), anchor=tk.CENTER,
                                         window=self.DefilPage)
        if self.MainAppli.NbrElt > 0:
            self.DefilPage.config(command=self.DefilPageDoc)
        else:
            self.DefilPage.config(state='disabled')

        self.DefilPage.bind('<Button-1>', self.ClicOnCanvas)
        self.DefilPage.bind('<MouseWheel>', self.MouseWheelDefil)
        self.CanvasFrmFond.bind('<MouseWheel>', self.MouseWheelDefil)
        self.CanvasFrmFond.bind('<Double-2>', self.OuvreAcrobat)
        self.CanvasFrmFond.bind('<Double-1>', self.ZoomDoc)

        self.EnTeteDoc = self.CanvasFrmFond.create_text(int(self.SX * 0.01), int(self.SY * 0.015), text='',
                                                        font=AppliFont('Calibri', self.MainAppli.SizeFont + 2,
                                                                       'bold', 0), anchor=tk.W)
        self.CanvasFrmFond.addtag_withtag('EnTeteDoc', self.EnTeteDoc)

        if len(ListDocs) > 0:
            self.Titre = 'Document "' + self.ListDocs[0][0] + '"'
            self.AffichPDF(0)

        self.MainAppli.ListBoxProduits.selection_clear(0, tk.END)
        self.MainAppli.IndexElt = 0
        self.MainAppli.ListBoxProduits.selection_set(self.MainAppli.IndexElt)
        self.MainAppli.ListBoxProduits.see(self.MainAppli.IndexElt)

        ChangeCursor(self.CanvasFrmFond)
        self.CanvasFrmFond.bind('<Button-1>', self.ClicOnCanvas)
        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.pack()

    def AffichPDF(self, Doc):
        if self.ZoomActif:
            self.DocZoom.destroy()
            self.ZoomActif = False
        self.CanvasFrmFond.itemconfigure('EnTeteDoc', text=self.Titre)
        self.PageAffich = 0
        self.DefilPage.config(from_=0, to=0, resolution=1)
        self.DefilPage.set(0)
        self.FilePDFAOuvrir = ''
        if self.ListDocs[Doc][1] is not None and self.ListDocs[Doc][1] != '':
            if self.MainAppli.BaseEnCours == "CHIMIE":
                if os.path.exists('Datas/DocsPDFChim/' + self.ListDocs[Doc][1] + '.pdf'):
                    self.FilePDFAOuvrir = 'Datas/DocsPDFChim/' + self.ListDocs[Doc][1] + '.pdf'
            else:
                if os.path.exists('Datas/DocsPDFPhys/' + self.ListDocs[Doc][1] + '.pdf'):
                    self.FilePDFAOuvrir = 'Datas/DocsPDFPhys/' + self.ListDocs[Doc][1] + '.pdf'
        if self.Page1PDF is not None:
            self.CanvasFrmFond.delete(self.Page1PDF.ImgCanvasDoc)
        if self.Page2PDF is not None:
            self.CanvasFrmFond.delete(self.Page2PDF.ImgCanvasDoc)

        if self.FilePDFAOuvrir != '':
            self.Page1PDF = PagePDF(self.CanvasFrmFond, self.FilePDFAOuvrir, int(self.SX * 0.458),
                                    int(self.SX * 0.241), int(self.SY * 0.5), 0)

            self.CanvasFrmFond.bind('<Double-2>', self.OuvreAcrobat)
            self.CanvasFrmFond.bind('<Double-1>', self.ZoomDoc)
            self.MenuClicDroitPDF = tk.Menu(self.CanvasFrmFond, tearoff=0)
            self.MenuClicDroitPDF.add_command(label="Zoom sur le document", command=self.ActionZoom)
            self.MenuClicDroitPDF.add_separator()
            self.MenuClicDroitPDF.add_command(label="Ouvrir dans le navigateur", command=self.ActionOpenPDF)
            self.CanvasFrmFond.bind("<Button-3>", self.AffichMenuClicDroitPDF)

            self.NbrPagesPDF = self.Page1PDF.NbrPagesPDF
            if self.NbrPagesPDF - 1 > 0:
                self.Page2PDF = PagePDF(self.CanvasFrmFond, self.FilePDFAOuvrir, int(self.SX * 0.458),
                                        int(self.SX * 0.76), int(self.SY * 0.5), 1)

            self.DefilPage.config(from_=0, to=self.NbrPagesPDF // 2 - 1 + self.NbrPagesPDF % 2, resolution=1)

    def SelectDoc(self, j):
        self.MainAppli.ListBoxProduits.selection_clear(0, tk.END)
        self.MainAppli.ListBoxProduits.selection_set(j)
        self.MainAppli.ListBoxProduits.see(j)
        self.Titre = 'Document "' + self.ListDocs[j][0] + '"'
        self.AffichPDF(j)

        if not self.MainAppli.Init:
            self.MainAppli.InfoDoc.Doc = self.ListDocs[j]
            self.MainAppli.InfoDoc.AffichInfoDoc()
            self.MainAppli.InfoDoc.lift()

        self.lift()

    def AffichPagesPDF(self, npage):
        self.CanvasFrmFond.delete(self.Page1PDF.ImgCanvasDoc)
        self.CanvasFrmFond.delete(self.Page2PDF.ImgCanvasDoc)
        self.Page1PDF.ImgCanvasDoc = self.CanvasFrmFond.create_image(int(self.SX * 0.243), int(self.SY * 0.5),
                                                                     anchor=tk.CENTER,
                                                                     image=self.Page1PDF.PDF[npage])
        if npage + 1 < self.NbrPagesPDF:
            self.Page2PDF.ImgCanvasDoc = self.CanvasFrmFond.create_image(int(self.SX * 0.758), int(self.SY * 0.5),
                                                                         anchor=tk.CENTER,
                                                                         image=self.Page2PDF.PDF[npage + 1])

    def DefilPageDoc(self, _):
        if self.MainAppli.NbrElt > 0:
            if self.MainAppli.NAction != 5:
                self.PageAffich = self.DefilPage.get() * 2
                self.AffichPagesPDF(self.PageAffich)
            else:
                self.DefilPage.set(self.PageAffich / 2)
                self.MainAppli.FrmLift()

    def MouseWheelDefil(self, event):
        if event.delta == -120:
            if self.DefilPage.get() > 0:
                self.DefilPage.set(self.DefilPage.get() - 1)
        if event.delta == 120:
            self.PageAffich = self.PageAffich + 2
            if self.DefilPage.get() < self.NbrPagesPDF // 2 - 1 + self.NbrPagesPDF % 2:
                self.DefilPage.set(self.DefilPage.get() + 1)

    def ClicOnCanvas(self, _):
        if self.MainAppli.NAction == 5:
            self.MainAppli.FrmLift()

    def AffichMenuClicDroitPDF(self, event):
        self.MenuClicDroitPDF.post(event.x_root, event.y_root)

    def ActionZoom(self):
        self.DocZoom = FrmZoomDoc(self.parent, self.RatioX, self.RatioY, self.FilePDFAOuvrir, self.Titre, self)
        self.DocZoom.FrmPDF.CanvasDoc.bind('<Double-1>', self.OuvreAcrobat)
        self.DocZoom.FrmPDF.CanvasDoc.bind('<Button-1>', self.ClicOnCanvas)
        self.DocZoom.CanvasFrmFond.bind('<Button-1>', self.ClicOnCanvas)
        self.DocZoom.FrmPDF.DefilPage.set(self.PageAffich)
        self.ZoomActif = True

    def ZoomDoc(self, _):
        self.ActionZoom()

    def ActionOpenPDF(self):
        AffichPDF(self.Titre, self.FilePDFAOuvrir, self)

    def OuvreAcrobat(self, _):
        self.ActionOpenPDF()

    def ClosePDF(self):
        self.MainAppli.parent.focus_force()
        self.MainAppli.FrmLift()
        self.focus_force()
