from AppliDef import *
from FrmZoom import FrmZoomDoc


class FrmInfoMat(tk.Toplevel):
    def __init__(self, container, Mat, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.Mat = Mat

        self.NomMat = None
        self.TitreStock = None
        self.TitreFournisseur = None
        self.CanvasBoite = None
        self.CanvasDescript = None
        self.ImgEtiqMat = []
        self.CanvasImgEtiqMat = None
        self.ImgCanvasImgEtiqMat = None
        self.ImgFournisseur = None
        self.CanvasEtiqPrix = None
        self.NomMat1 = None
        self.NomMat2 = None
        self.FrmPDF = None
        self.NoPDF = None
        self.ZoneText = None
        self.CanvasVisuel = None
        self.indice = 0
        self.rep = ''
        self.MenuClicDroitPDF = None
        self.PDFZoom = None
        self.ZoomActif = False
        self.ListMenuClicDroitDescript = []

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmInfo/Fond/Fond.bmp')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmInfo/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.753)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.11)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.CanvasMenu = CanvasInWindow('Media/FrmInfo/FondMenu/', self.RatioX, self.RatioY,
                                         self.CanvasFrmFond, tk.CENTER, int(self.SX * 0.5), int(self.SY * 0.48), 0)
        self.CanvasMenu.CanvasListIma.bind('<Motion>', self.MoveOnCanvas)
        self.MenuOnglets = MenuOnglets(self.CanvasFrmFond, int(self.SX * 0.5), int(self.SY * 0.985), RatioX, RatioY, 0,
                                       'Stock / Fournisseur', 'Descriptif', 'Notice', self.MainAppli.SizeFont,
                                       self.ActionAffichStock, self.ActionAffichDescript, self.ActionAffichNotice)

        self.ActionAffichStock()

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.pack()

    def ActionAffichStock(self):
        if self.Mat:
            self.AffichStock()

    def ActionAffichDescript(self):
        if self.Mat:
            self.AffichDescript()
        else:
            self.MenuOnglets.MenuSelected[1] = False
            self.MenuOnglets.ListCanvasMenu[1].itemconfig(self.MenuOnglets.ListImgMenu[1],
                                                          image=self.MenuOnglets.ListMenu[1][1])
            self.MenuOnglets.ListCanvasMenu[0].itemconfig(self.MenuOnglets.ListImgMenu[0],
                                                          image=self.MenuOnglets.ListMenu[0][2])
            self.MenuOnglets.MenuSelected[0] = True

    def ActionAffichNotice(self):
        if self.Mat:
            self.AffichNotice()
        else:
            self.MenuOnglets.MenuSelected[2] = False
            self.MenuOnglets.ListCanvasMenu[2].itemconfig(self.MenuOnglets.ListImgMenu[2],
                                                          image=self.MenuOnglets.ListMenu[2][1])
            self.MenuOnglets.ListCanvasMenu[0].itemconfig(self.MenuOnglets.ListImgMenu[0],
                                                          image=self.MenuOnglets.ListMenu[0][2])
            self.MenuOnglets.MenuSelected[0] = True

    def AffichStock(self):
        self.EffaceMenu()
        Mat = self.Mat
        QuantTot = ""
        QuantMin = ""
        Fournisseur = ""
        Ref = ""
        Cdt = ""
        Pht = ""
        self.NomMat = LabelInCanvas(self.CanvasMenu.CanvasListIma, Mat[0], '#E0E0E0',
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 3, 'bold', 0),
                                    int(self.CanvasMenu.wsize * 0.5), int(self.CanvasMenu.hsize * 0.038), tk.CENTER)

        self.TitreStock = self.CanvasMenu.CanvasListIma.create_text(
            int(self.CanvasMenu.wsize * 0.05), int(self.CanvasMenu.hsize * 0.09), text='Stock',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.CanvasBoite = CanvasInWindow('Media/FrmInfo/Boite/', self.RatioX, self.RatioY,
                                          self.CanvasMenu.CanvasListIma, tk.CENTER, int(self.CanvasMenu.wsize * 0.5),
                                          int(self.CanvasMenu.hsize * 0.355), 0)

        if Mat[2] is not None and Mat[2] != '':
            LabelInCanvas(self.CanvasBoite.CanvasListIma, Mat[2], '#C0C0C0',
                          AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 0),
                          int(self.CanvasBoite.wsize * 0.5), int(self.CanvasBoite.hsize * 0.1), tk.CENTER)

        if Mat[1] is not None and Mat[1] != '':
            self.ImgEtiqMat = []
            img = None
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                img = Image.open('Datas/VisuelMatChim/' + Mat[1])
            elif self.MainAppli.BaseEnCours == 'PHYS':
                img = Image.open('Datas/VisuelMatPhys/' + Mat[1])
            imgEtiqwsize = int(self.CanvasBoite.wsize * 0.295)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasBoite.hsize * 0.115:
                imgEtiqhsize = int(self.CanvasBoite.hsize * 0.115)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqMat.append(ImageTk.PhotoImage(img))

            self.CanvasImgEtiqMat = CanvasApp(self.CanvasBoite.CanvasListIma, width=imgEtiqwsize,
                                              height=imgEtiqhsize)
            self.CanvasBoite.CanvasListIma.create_window(int(self.CanvasBoite.wsize * 0.497),
                                                         int(self.CanvasBoite.hsize * 0.158), anchor=tk.N,
                                                         window=self.CanvasImgEtiqMat)
            self.ImgCanvasImgEtiqMat = self.CanvasImgEtiqMat.create_image(0, 0, anchor=tk.NW, image=self.ImgEtiqMat[0])
            CreateCadre(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.494 - imgEtiqwsize / 2),
                        int(self.CanvasBoite.hsize * 0.155),
                        int(self.CanvasBoite.wsize * 0.500 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasBoite.hsize * 0.161) + imgEtiqhsize)

        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.35), text='Lieu de stockage',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 1), anchor=tk.CENTER)
        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.35), text='Quantité',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 1), anchor=tk.CENTER)

        if self.MainAppli.BaseEnCours == "CHIMIE":
            Lieux1 = self.MainAppli.LieuxStockMatChim[0]
            Lieux2 = self.MainAppli.LieuxStockMatChim[1]
            Lieux3 = self.MainAppli.LieuxStockMatChim[2]
        else:
            Lieux1 = self.MainAppli.LieuxStockMatPhys[0]
            Lieux2 = self.MainAppli.LieuxStockMatPhys[1]
            Lieux3 = self.MainAppli.LieuxStockMatPhys[2]

        LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux1, '#C0C0C0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.41), tk.CENTER)
        if Mat[3] is not None and Mat[3] != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.47), text=Mat[3],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.47), text=Mat[4],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            if Mat[4] is not None and Mat[4] != '':
                QuantTot = Mat[4]
        if Mat[5] is not None and Mat[5] != '' and self.MainAppli.BaseEnCours == "CHIMIE":
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.51), text=Mat[5],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.51), text=Mat[6],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux2, '#C0C0C0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.58), tk.CENTER)
        if self.MainAppli.BaseEnCours == "CHIMIE":
            if Mat[7] is not None and Mat[7] != '':
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.64), text=Mat[7],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.64), text=Mat[8],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            if Mat[9] is not None and Mat[9] != '':
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.68), text=Mat[9],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.68), text=Mat[10],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux3, '#C0C0C0',
                          AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                          int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.75), tk.CENTER)
            if Mat[11] is not None and Mat[11] != '':
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.81), text=Mat[11],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.81), text=Mat[12],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            if Mat[13] is not None and Mat[13] != '':
                QuantTot = Mat[13]
            if Mat[14] is not None and Mat[14] != '':
                QuantMin = Mat[14]
            if Mat[15] is not None and Mat[15] != '':
                Fournisseur = Mat[15]
            if Mat[16] is not None and Mat[16] != '':
                Ref = Mat[16]
            if Mat[17] is not None and Mat[17] != '':
                Cdt = Mat[17]
            if Mat[18] is not None and Mat[18] != '':
                Pht = Mat[18]
        elif self.MainAppli.BaseEnCours == "PHYS":
            if Mat[5] is not None and Mat[5] != '':
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.64), text=Mat[5],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.64), text=Mat[6],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
                if Mat[6] != '':
                    if QuantTot != '':
                        QuantTot = str(int(QuantTot) + int(Mat[6]))
                    else:
                        QuantTot = Mat[6]
            LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux3, '#C0C0C0',
                          AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                          int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.75), tk.CENTER)
            if Mat[7] is not None and Mat[7] != '':
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.81), text=Mat[7],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
                self.CanvasBoite.CanvasListIma.create_text(
                    int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.81), text=Mat[8],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
                if Mat[8] != '':
                    if QuantTot != '':
                        QuantTot = str(int(QuantTot) + int(Mat[8]))
                    else:
                        QuantTot = Mat[8]
            if Mat[9] is not None and Mat[9] != '':
                QuantMin = Mat[9]
            if Mat[10] is not None and Mat[10] != '':
                Fournisseur = Mat[10]
            if Mat[11] is not None and Mat[11] != '':
                Ref = Mat[11]
            if Mat[12] is not None and Mat[12] != '':
                Cdt = Mat[12]
            if Mat[13] is not None and Mat[13] != '':
                Pht = Mat[13]

        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.18), int(self.CanvasBoite.hsize * 0.88), text='Stock - Quantité totale: ',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 0), anchor=tk.W)
        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.88), text=QuantTot,
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        if QuantMin != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.18), int(self.CanvasBoite.hsize * 0.92),
                text='Stock - Quantité minimale: ',
                font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.92), text=QuantMin,
                font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.CENTER, fill='blue')

        self.TitreFournisseur = self.CanvasMenu.CanvasListIma.create_text(
            int(self.CanvasMenu.wsize * 0.05), int(self.CanvasMenu.hsize * 0.62), text='Fournisseur',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        Logo = []
        if Fournisseur != '':
            if self.MainAppli.BaseEnCours == "CHIMIE":
                self.MainAppli.cur.execute('SELECT Logo'
                                           ' FROM Fournisseurs WHERE NOM LIKE \'%' + Fournisseur + '%\' order by NOM')
                Logo = self.MainAppli.cur.fetchall()
            elif self.MainAppli.BaseEnCours == "PHYS":
                self.MainAppli.curphys.execute('SELECT Logo'
                                               ' FROM Fournisseurs WHERE NOM LIKE \'%' + Fournisseur +
                                               '%\' order by NOM')
                Logo = self.MainAppli.curphys.fetchall()

        if len(Logo) > 0 and Logo[0][0] != '' and Logo[0][0] is not None:
            PathLogo = 'Datas/Fournisseurs/Logos/' + Logo[0][0]
        else:
            if Fournisseur == '':
                PathLogo = 'Datas/Fournisseurs/Logos/NC'
            else:
                PathLogo = 'Datas/Fournisseurs/Logos/Vide'

        self.ImgFournisseur = ImgInCanvas(self.CanvasMenu.CanvasListIma, PathLogo, 0.4, tk.CENTER,
                                          int(self.CanvasMenu.wsize * 0.5), int(self.CanvasMenu.hsize * 0.7))

        if len(Logo) == 0 or Logo[0][0] == '' or Logo[0][0] is None:
            if len(Fournisseur) < 15:
                TextFournisseur = Fournisseur
            else:
                TextFournisseur = Fournisseur.split(' ')[0]
                for i in range(1, len(Fournisseur.split(' '))):
                    TextFournisseur = TextFournisseur + '\n' + Fournisseur.split(' ')[i]
            self.ImgFournisseur.CanvasImg.create_text(int(int(self.ImgFournisseur.CanvasImg['width']) * 0.5),
                                                      int(int(self.ImgFournisseur.CanvasImg['height']) * 0.5),
                                                      text=TextFournisseur,
                                                      font=AppliFont('Helvetica', self.MainAppli.SizeFont + 4, 'bold',
                                                                     0), anchor=tk.CENTER, justify=tk.CENTER)

        self.CanvasEtiqPrix = CanvasInWindow('Media/FrmInfo/Etiq/', self.RatioX * 0.9, self.RatioY * 0.7,
                                             self.CanvasMenu.CanvasListIma, tk.CENTER, int(self.CanvasMenu.wsize * 0.5),
                                             int(self.CanvasMenu.hsize * 0.87), 0)
        self.CanvasEtiqPrix.CanvasListIma.create_text(
            int(self.CanvasEtiqPrix.wsize * 0.5), int(self.CanvasEtiqPrix.hsize * 0.2), text=Mat[0],
            font=AppliFont('Helvetica', self.MainAppli.SizeFont - 1, 'bold', 0), anchor=tk.CENTER)

        if Ref != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.45), text='Ref: ' + Ref,
                font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        if Cdt != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.6),
                text='Cdt: ' + Cdt,
                font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        if Pht != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.75), int(self.CanvasEtiqPrix.hsize * 0.55),
                text=Pht + ' € HT',
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 3, 'bold', 0), anchor=tk.CENTER)

        self.MainAppli.CanvasFrmMain.itemconfigure('LegendePanneauD',
                                                   text="Informations - Stock/Fournisseur du matériel")

    def AffichDescript(self):
        self.EffaceMenu()
        Mat = self.Mat
        Indice = 0
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            Indice = 19
        elif self.MainAppli.BaseEnCours == 'PHYS':
            Indice = 14
        self.CanvasDescript = CanvasInWindow('Media/FrmInfo/FondDescriptMat/', self.RatioX * 1.55, self.RatioY * 1.7,
                                             self.CanvasMenu.CanvasListIma, tk.CENTER, int(self.CanvasMenu.wsize * 0.5),
                                             int(self.CanvasMenu.hsize * 0.5), 0)
        self.ListMenuClicDroitDescript = tk.Menu(self.CanvasDescript.CanvasListIma, tearoff=0)
        self.ListMenuClicDroitDescript.add_command(label="Recherche internet", command=self.ChercheWeb)
        self.CanvasDescript.CanvasListIma.bind("<Button-3>", self.AffichMenuClicDroitDescript)

        if len(Mat[0]) >= 55:
            self.NomMat = None
            (Nom1, Nom2) = (Mat[0][:len(Mat[0]) // 2], Mat[0][len(Mat[0]) // 2:])
            self.NomMat1 = self.CanvasDescript.CanvasListIma.create_text(
                int(self.CanvasDescript.wsize * 0.5), int(self.CanvasDescript.hsize * 0.08), text=Nom1 + '-',
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.CENTER)
            self.NomMat2 = self.CanvasDescript.CanvasListIma.create_text(
                int(self.CanvasDescript.wsize * 0.5), int(self.CanvasDescript.hsize * 0.11), text=Nom2,
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.CENTER)
        else:
            self.NomMat1 = None
            self.NomMat2 = None
            self.NomMat = self.CanvasDescript.CanvasListIma.create_text(
                int(self.CanvasDescript.wsize * 0.5), int(self.CanvasDescript.hsize * 0.08), text=Mat[0],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.CENTER)

        if Mat[1] is not None and Mat[1] != '':
            self.ImgEtiqMat = []
            img = None
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                img = Image.open('Datas/VisuelMatChim/' + Mat[1])
            elif self.MainAppli.BaseEnCours == 'PHYS':
                img = Image.open('Datas/VisuelMatPhys/' + Mat[1])
            imgEtiqwsize = int(self.CanvasDescript.wsize * 0.6)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasDescript.hsize * 0.25:
                imgEtiqhsize = int(self.CanvasDescript.hsize * 0.25)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqMat.append(ImageTk.PhotoImage(img))

            self.CanvasImgEtiqMat = CanvasApp(self.CanvasDescript.CanvasListIma, width=imgEtiqwsize,
                                              height=imgEtiqhsize)
            self.CanvasDescript.CanvasListIma.create_window(int(self.CanvasDescript.wsize * 0.5),
                                                            int(self.CanvasDescript.hsize * 0.15), anchor=tk.N,
                                                            window=self.CanvasImgEtiqMat)
            self.ImgCanvasImgEtiqMat = self.CanvasImgEtiqMat.create_image(0, 0, anchor=tk.NW, image=self.ImgEtiqMat[0])
            CreateCadre(self.CanvasDescript.CanvasListIma, int(self.CanvasDescript.wsize * 0.498 - imgEtiqwsize / 2),
                        int(self.CanvasDescript.hsize * 0.148),
                        int(self.CanvasDescript.wsize * 0.502 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasDescript.hsize * 0.151) + imgEtiqhsize)

        else:
            self.CanvasVisuel = CanvasInWindow('Media/FrmAjout/NoVisuel/', self.RatioX, self.RatioY,
                                               self.CanvasDescript.CanvasListIma, tk.CENTER,
                                               int(self.CanvasDescript.wsize * 0.5),
                                               int(self.CanvasDescript.hsize * 0.25), 0)

        self.CanvasDescript.CanvasListIma.create_text(
            int(self.CanvasDescript.wsize * 0.05), int(self.CanvasDescript.hsize * 0.46), text='Caractéristiques:',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        Coefhsize = 0.51
        for i in range(0, 8, 2):
            if Mat[Indice + i] is not None and Mat[Indice + i] != '':
                self.CanvasDescript.CanvasListIma.create_text(
                    int(self.CanvasDescript.wsize * 0.11), int(self.CanvasDescript.hsize * Coefhsize),
                    text=Mat[Indice + i] + ' : ' + Mat[Indice + 1 + i],
                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.W)
                Coefhsize = Coefhsize + 0.03

        self.CanvasDescript.CanvasListIma.create_text(
            int(self.CanvasDescript.wsize * 0.05), int(self.CanvasDescript.hsize * 0.67), text='Descriptif:',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.ZoneText = ZoneScrolledText(self.CanvasDescript.CanvasListIma, width=int(self.CanvasDescript.wsize * 0.12),
                                         height=int(self.CanvasDescript.hsize * 0.015),
                                         font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0))

        self.CanvasDescript.CanvasListIma.create_window(int(self.CanvasDescript.wsize * 0.025),
                                                        int(self.CanvasDescript.hsize * 0.72), anchor=tk.NW,
                                                        window=self.ZoneText)
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            if Mat[28] is not None and Mat[28] != '':
                File = open('Datas/DescriptMatChim/' + Mat[28] + '.txt', "r", encoding="utf-8")
                for ligne in File:
                    self.ZoneText.insert(tk.INSERT, ligne)
        elif self.MainAppli.BaseEnCours == 'PHYS':
            if Mat[23] is not None and Mat[23] != '':
                File = open('Datas/DescriptMatPhys/' + Mat[23] + '.txt', "r", encoding="utf-8")
                for ligne in File:
                    self.ZoneText.insert(tk.INSERT, ligne)

        self.ZoneText.configure(state='disabled')

        self.MainAppli.CanvasFrmMain.itemconfigure('LegendePanneauD', text="Informations - Descriptif du matériel")

    def AffichNotice(self):
        self.EffaceMenu()
        self.indice = 0
        self.rep = ''
        if self.MainAppli.BaseEnCours == 'CHIMIE':
            self.indice = 27
            self.rep = 'NoticeChim'
        elif self.MainAppli.BaseEnCours == 'PHYS':
            self.indice = 22
            self.rep = 'NoticePhys'
        if self.Mat[self.indice] is not None and self.Mat[self.indice] != '':
            self.FrmPDF = FrmPDF(self.CanvasMenu.CanvasListIma, 'Datas/' + self.rep + '/' + self.Mat[self.indice] +
                                 '.pdf', 0.85, self.CanvasMenu.hsize, int(self.CanvasMenu.wsize * 0.5),
                                 int(self.CanvasMenu.hsize * 0.49), int(self.CanvasMenu.wsize * 0.98),
                                 int(self.CanvasMenu.hsize * 0.855))
            self.FrmPDF.CanvasDoc.bind('<Double-1>', self.ZoomPDF)
            self.FrmPDF.CanvasDoc.bind('<Double-2>', self.OuvrePDF)
            self.MenuClicDroitPDF = tk.Menu(self.FrmPDF.CanvasDoc, tearoff=0)
            self.MenuClicDroitPDF.add_command(label="Zoom sur le document", command=self.ActionZoomPDF)
            self.MenuClicDroitPDF.add_separator()
            self.MenuClicDroitPDF.add_command(label="Ouvrir dans le navigateur", command=self.ActionOuvrePDF)
            self.FrmPDF.CanvasDoc.bind("<Button-3>", self.AffichMenuClicDroitPDF)
        else:
            self.NoPDF = NoPDF(self.CanvasMenu.CanvasListIma, 'Media/FrmInfo/NoPdf/NoPDF.jpg', int(self.SX * 0.5),
                               int(self.SY * 0.5), self.RatioX, self.RatioY)
            ChangeCursor2(self.NoPDF.CanvasImgNoPdf)

        self.MainAppli.CanvasFrmMain.itemconfigure('LegendePanneauD', text="Informations - Notice du matériel")

    def EffaceMenu(self):
        for widget in self.CanvasMenu.CanvasListIma.winfo_children():
            widget.destroy()
        self.CanvasMenu.CanvasListIma.delete(self.NomMat)
        self.CanvasMenu.CanvasListIma.delete(self.TitreStock)
        self.CanvasMenu.CanvasListIma.delete(self.TitreFournisseur)

    def ZoomPDF(self, _):
        self.ActionZoomPDF()

    def ActionZoomPDF(self):
        if self.PDFZoom is not None:
            self.PDFZoom.destroy()
        self.PDFZoom = FrmZoomDoc(self.parent, self.RatioX, self.RatioY,  'Datas/' + self.rep + '/' +
                                  self.Mat[self.indice] + '.pdf', self.Mat[0] + ' - Notice', self)
        self.PDFZoom.FrmPDF.DefilPage.set(self.FrmPDF.PageAffich)
        self.PDFZoom.FrmPDF.CanvasDoc.bind('<Double-1>', self.OuvrePDF)
        self.PDFZoom.FrmPDF.CanvasDoc.bind('<Button-1>', self.ClicOnCanvas)
        self.PDFZoom.CanvasFrmFond.bind('<Button-1>', self.ClicOnCanvas)
        self.ZoomActif = True

    def OuvrePDF(self, _):
        self.ActionOuvrePDF()

    def ActionOuvrePDF(self):
        AffichPDF(self.Mat[0] + ' - Notice', 'Datas/' + self.rep + '/' + self.Mat[self.indice] + '.pdf', self)

    def AffichMenuClicDroitPDF(self, event):
        self.MenuClicDroitPDF.post(event.x_root, event.y_root)

    def AffichMenuClicDroitDescript(self, event):
        self.ListMenuClicDroitDescript.post(event.x_root, event.y_root)

    def ClosePDF(self):
        self.MainAppli.parent.focus_force()
        self.MainAppli.FrmLift()
        self.focus_force()

    def ChercheWeb(self):
        webbrowser.open('https://www.google.fr/search?q=' + self.Mat[0], new=1)

    def MoveOnCanvas(self, _):
        for i in range(3):
            if not self.MenuOnglets.MenuSelected[i]:
                self.MenuOnglets.ListCanvasMenu[i].itemconfig(self.MenuOnglets.ListImgMenu[i],
                                                              image=self.MenuOnglets.ListMenu[i][0])

    def ClicOnCanvas(self, _):
        if self.MainAppli.NAction == 5:
            self.MainAppli.FrmLift()
