from AppliDef import *
from EtagProduits import ModifFB, ModifListDanger
from FrmZoom import FrmZoomDanger, FrmZoomDoc


class FrmInfoProd(tk.Toplevel):
    def __init__(self, container, prod, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.Prod = prod

        self.CanvasCont = None
        self.NomProduit = None
        self.ImgEtiqProd = []
        self.CanvasContEtiqProd = None
        self.ImgCanvasContEtiqProd = None
        self.CanvasGHS = []
        self.FBProduit = None
        self.SynoProd = None
        self.MMProd = None
        self.DProd = None
        self.CanvasArmoire = None
        self.CanvasFonction = None
        self.TitreStock = None
        self.TitreFournisseur = None
        self.CanvasFournisseur = None
        self.CanvasEtiqPrix = None
        self.listGHS = None
        self.FrmPDF = None
        self.CanvasImgEtiqProd = None
        self.ImgCanvasImgEtiqProd = None
        self.ImgFournisseur = None
        self.NoPDF = None
        self.ZoomDanger, self.ZoomConseil = None, None
        self.TextDanger, self.TextConseil = '', ''
        self.Dangers, self.Conseils = None, None
        self.Nflacon = 0
        self.FDSZoom = None
        self.ListMenuClicDroitCaract = None
        self.MenuClicDroitFDS = None
        self.ZoomActif = False

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmInfo/Fond/Fond.bmp')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmInfo/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.753)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.11)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.CanvasMenu = CanvasInWindow('Media/FrmInfo/FondMenu/', self.RatioX, self.RatioY,
                                         self.CanvasFrmFond, tk.CENTER, int(self.SX * 0.5), int(self.SY * 0.48), 0)

        self.MenuOnglets = MenuOnglets(self.CanvasFrmFond, int(self.SX * 0.5), int(self.SY * 0.985), RatioX, RatioY, 0,
                                       'Propriétés', 'FDS', 'Stock / Fournisseur', self.MainAppli.SizeFont,
                                       self.ActionAffichInfo, self.ActionAffichFDS, self.ActionAffichStock)

        self.ActionAffichInfo()
        self.CanvasMenu.CanvasListIma.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.pack()

    def ActionAffichInfo(self):
        if self.Prod:
            self.AffichInfo()

    def ActionAffichFDS(self):
        if self.Prod:
            self.AffichFDS()
        else:
            self.MenuOnglets.MenuSelected[1] = False
            self.MenuOnglets.ListCanvasMenu[1].itemconfig(self.MenuOnglets.ListImgMenu[1],
                                                          image=self.MenuOnglets.ListMenu[1][1])
            self.MenuOnglets.ListCanvasMenu[0].itemconfig(self.MenuOnglets.ListImgMenu[0],
                                                          image=self.MenuOnglets.ListMenu[0][2])
            self.MenuOnglets.MenuSelected[0] = True

    def ActionAffichStock(self):
        if self.Prod:
            self.AffichStock()
        else:
            self.MenuOnglets.MenuSelected[2] = False
            self.MenuOnglets.ListCanvasMenu[2].itemconfig(self.MenuOnglets.ListImgMenu[2],
                                                          image=self.MenuOnglets.ListMenu[2][1])
            self.MenuOnglets.ListCanvasMenu[0].itemconfig(self.MenuOnglets.ListImgMenu[0],
                                                          image=self.MenuOnglets.ListMenu[0][2])
            self.MenuOnglets.MenuSelected[0] = True

    def AffichStock(self):
        self.EffaceMenu()
        prod = self.Prod
        Fournisseur = ''
        self.NomProduit = LabelInCanvas(self.CanvasMenu.CanvasListIma, prod[0], '#E0E0E0',
                                        AppliFont('Helvetica', self.MainAppli.SizeFont + 3, 'bold', 0),
                                        int(self.CanvasMenu.wsize * 0.5), int(self.CanvasMenu.hsize * 0.038), tk.CENTER)

        self.TitreStock = self.CanvasMenu.CanvasListIma.create_text(
            int(self.CanvasMenu.wsize * 0.05), int(self.CanvasMenu.hsize * 0.09), text='Stock',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.CanvasArmoire = CanvasInWindow('Media/FrmInfo/Armoires/', self.RatioX * 1.1, self.RatioY * 0.9,
                                            self.CanvasMenu.CanvasListIma, tk.CENTER, int(self.CanvasMenu.wsize * 0.5),
                                            int(self.CanvasMenu.hsize * 0.35), 0)
        if prod[7] is not None and prod[7] != '':
            LabelInCanvas(self.CanvasArmoire.CanvasListIma, prod[7], '#C0C0C0',
                          AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 0),
                          int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.1), tk.CENTER)

        if prod[2] is not None and prod[2] != '' and os.path.exists('Datas/Formdev/' + prod[2]):
            self.ImgEtiqProd = []
            img = Image.open('Datas/Formdev/' + prod[2])
            imgEtiqwsize = int(self.CanvasArmoire.wsize * 0.2)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasArmoire.hsize * 0.2:
                imgEtiqhsize = int(self.CanvasArmoire.hsize * 0.2)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqProd.append(ImageTk.PhotoImage(img))

            self.CanvasImgEtiqProd = CanvasApp(self.CanvasArmoire.CanvasListIma, width=imgEtiqwsize,
                                               height=imgEtiqhsize)
            self.CanvasArmoire.CanvasListIma.create_window(int(self.CanvasArmoire.wsize * 0.145),
                                                           int(self.CanvasArmoire.hsize * 0.065), anchor=tk.N,
                                                           window=self.CanvasImgEtiqProd)
            self.ImgCanvasImgEtiqProd = self.CanvasImgEtiqProd.create_image(0, 0, anchor=tk.NW,
                                                                            image=self.ImgEtiqProd[0])
            CreateCadre(self.CanvasArmoire.CanvasListIma, int(self.CanvasArmoire.wsize * 0.14 - imgEtiqwsize / 2),
                        int(self.CanvasArmoire.hsize * 0.06),
                        int(self.CanvasArmoire.wsize * 0.148 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasArmoire.hsize * 0.065) + imgEtiqhsize)

        if prod[8] is not None and prod[8] != '':
            LabelInCanvas(self.CanvasArmoire.CanvasListIma, 'Lieu de stockage', '#C0C0C0',
                          AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 0),
                          int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.245), tk.CENTER)
            self.CanvasArmoire.CanvasListIma.create_text(
                int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.335),
                text=prod[8],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        if prod[18] is not None and prod[18] != '':
            LabelInCanvas(self.CanvasArmoire.CanvasListIma, 'Quantité en stock (' + prod[1] + '):', '#C0C0C0',
                          AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 0),
                          int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.476), tk.CENTER)
            self.CanvasArmoire.CanvasListIma.create_text(
                int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.565), text=prod[18],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        if prod[19] is not None and prod[19] != '':
            LabelInCanvas(self.CanvasArmoire.CanvasListIma, 'Quantité utilisée / an (' + prod[1] + '):', '#C0C0C0',
                          AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 0),
                          int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.698), tk.CENTER)
            self.CanvasArmoire.CanvasListIma.create_text(
                int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.79), text=prod[19],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        self.DeterminListGHS(prod)
        self.CanvasGHS = []
        deb = 0
        if len(self.listGHS) == 3:
            deb = int(self.CanvasCont.wsize * 0.4)
        elif len(self.listGHS) == 2:
            deb = int(self.CanvasCont.wsize * 0.45)
        elif len(self.listGHS) == 1:
            deb = int(self.CanvasCont.wsize * 0.5)
        for i in range(len(self.listGHS)):
            self.CanvasGHS.append(
                CanvasInWindow('Media/PictoDanger/', self.RatioX * 0.6, self.RatioX * 0.6,
                               self.CanvasArmoire.CanvasListIma,
                               tk.CENTER, int(self.CanvasArmoire.wsize * 0.13),
                               deb + int(i * self.CanvasArmoire.hsize * 0.15),
                               self.listGHS[i]))

        self.TitreFournisseur = self.CanvasMenu.CanvasListIma.create_text(
            int(self.CanvasMenu.wsize * 0.05), int(self.CanvasMenu.hsize * 0.62), text='Fournisseur',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        if prod[9] is not None and prod[9] != '':
            Fournisseur = prod[9]

        Logo = []
        if Fournisseur != '':
            self.MainAppli.cur.execute('SELECT Logo FROM Fournisseurs WHERE NOM LIKE \'%' + Fournisseur +
                                       '%\' order by NOM')
            Logo = self.MainAppli.cur.fetchall()
        if len(Logo) > 0 and Logo[0][0] != '' and Logo[0][0] is not None:
            PathLogo = 'Datas/Fournisseurs/Logos/' + Logo[0][0]
        else:
            if Fournisseur == '':
                PathLogo = 'Datas/Fournisseurs/Logos/NC'
            else:
                PathLogo = 'Datas/Fournisseurs/Logos/Vide'

        self.ImgFournisseur = ImgInCanvas(self.CanvasMenu.CanvasListIma, PathLogo, 0.4, tk.CENTER,
                                          int(self.CanvasMenu.wsize * 0.5), int(self.CanvasMenu.hsize * 0.7))

        if len(Logo) == 0 or Logo[0][0] == '' or Logo[0][0] is None:
            if len(Fournisseur) < 15:
                TextFournisseur = Fournisseur
            else:
                TextFournisseur = Fournisseur.split(' ')[0]
                for i in range(1, len(Fournisseur.split(' '))):
                    TextFournisseur = TextFournisseur + '\n' + Fournisseur.split(' ')[i]
            self.ImgFournisseur.CanvasImg.create_text(int(int(self.ImgFournisseur.CanvasImg['width']) * 0.5),
                                                      int(int(self.ImgFournisseur.CanvasImg['height']) * 0.5),
                                                      text=TextFournisseur,
                                                      font=AppliFont('Helvetica', self.MainAppli.SizeFont + 4, 'bold',
                                                                     0), anchor=tk.CENTER, justify=tk.CENTER)

        self.CanvasEtiqPrix = CanvasInWindow('Media/FrmInfo/Etiq/', self.RatioX * 0.9, self.RatioY * 0.7,
                                             self.CanvasMenu.CanvasListIma, tk.CENTER, int(self.CanvasMenu.wsize * 0.5),
                                             int(self.CanvasMenu.hsize * 0.87), 0)
        self.CanvasEtiqPrix.CanvasListIma.create_text(
            int(self.CanvasEtiqPrix.wsize * 0.5), int(self.CanvasEtiqPrix.hsize * 0.2), text=prod[0],
            font=AppliFont('Helvetica', self.MainAppli.SizeFont - 1, 'bold', 0), anchor=tk.CENTER)

        if prod[20] is not None and prod[20] != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.45), text='Ref: ' + prod[20],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        if prod[21] is not None and prod[21] != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.6),
                text='Cdt: ' + prod[21] + ' ' + prod[1],
                font=AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        if prod[22] is not None and prod[22] != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.75), int(self.CanvasEtiqPrix.hsize * 0.55),
                text=prod[22] + ' € HT',
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 3, 'bold', 0), anchor=tk.CENTER)

        if prod[26] is not None and prod[26] != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.83),
                text='CAS: ' + prod[26], fill='white',
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 0), anchor=tk.W)

        self.MainAppli.CanvasFrmMain.itemconfigure('LegendePanneauD',
                                                   text="Informations - Stock/Fournisseur du produit chimique")

    def AffichInfo(self):
        self.EffaceMenu()
        prod = self.Prod
        self.Nflacon = 0
        coefY = 0.38
        coefR = 0.9
        Coefw = 0.2
        Coefd = 0.3
        coefX = 0.18
        coefh = 1
        Dd = 0.1
        maxchr = 35
        if prod[12] is not None and prod[12] != '' or (prod[1] == 'mL' and prod[7].upper() != 'GAZ'):
            self.Nflacon = 0
        elif prod[1] == 'g':
            self.Nflacon = 1
        elif prod[7] is not None and prod[7].upper() == 'GAZ':
            self.Nflacon = 2
            coefY = 0.41
            coefR = 0.7
            Coefw = 0.15
            Coefd = 0.35
            coefX = 0.25
            Dd = 0.08
            maxchr = 20
        elif prod[1].upper() == 'UNIT' or prod[1] == '':
            self.Nflacon = 3
            maxchr = 42
            coefY = 0.365
            coefh = 0.87
        self.CanvasCont = CanvasInWindow('Media/FrmInfo/Flacon/', self.RatioX, self.RatioY * 0.92,
                                         self.CanvasMenu.CanvasListIma, tk.CENTER, int(self.SX * 0.5),
                                         int(self.SY * 0.5), self.Nflacon)
        self.CanvasCont.CanvasListIma.bind('<Motion>', self.MoveOnCanvasCont)
        self.CanvasCont.CanvasListIma.bind('<Button-1>', self.ClicOnCanvasCont)
        self.ListMenuClicDroitCaract = tk.Menu(self.CanvasCont.CanvasListIma, tearoff=0)
        self.ListMenuClicDroitCaract.add_command(label="Recherche internet", command=self.ChercheWeb)
        self.CanvasCont.CanvasListIma.bind("<Button-3>", self.AffichMenuClicDroitCaract)

        FB = ''
        FormDev = ''
        Nom = prod[0]
        if prod[2] is not None and prod[2] != '':
            FormDev = prod[2]
        if prod[6] is not None and prod[6] != '':
            FB = prod[6]
            FB = ModifFB(FB)

        self.DeterminListGHS(prod)

        if len(Nom) >= maxchr:
            sizefont = self.MainAppli.SizeFont
            if len(Nom) > 28:
                (Nom1, Nom2) = (Nom[:len(Nom) // 2], Nom[len(Nom) // 2:])
                Nom = Nom1 + '-\n' + Nom2
        else:
            sizefont = self.MainAppli.SizeFont + 2
        self.NomProduit = self.CanvasCont.CanvasListIma.create_text(int(self.CanvasCont.wsize * 0.5),
                                                                    int(self.CanvasCont.hsize * (coefY - 0.03)),
                                                                    text=Nom,
                                                                    font=AppliFont('Helvetica', sizefont, 'bold', 0),
                                                                    anchor=tk.CENTER)
        imgEtiqhsize = 0
        if FormDev != '' and os.path.exists('Datas/Formdev/' + FormDev):
            self.ImgEtiqProd = []
            img = Image.open('Datas/Formdev/' + FormDev)
            imgEtiqwsize = int(self.CanvasCont.wsize * 0.4)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasCont.hsize * 0.08:
                imgEtiqhsize = int(self.CanvasCont.hsize * 0.1)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqProd.append(ImageTk.PhotoImage(img))

            self.CanvasContEtiqProd = CanvasApp(self.CanvasCont.CanvasListIma, width=imgEtiqwsize, height=imgEtiqhsize)
            self.CanvasCont.CanvasListIma.create_window(int(self.CanvasCont.wsize * 0.5),
                                                        int(self.CanvasCont.hsize * coefY), anchor=tk.N,
                                                        window=self.CanvasContEtiqProd)
            self.ImgCanvasContEtiqProd = self.CanvasContEtiqProd.create_image(0, 0, anchor=tk.NW,
                                                                              image=self.ImgEtiqProd[0])

            CreateCadre(self.CanvasCont.CanvasListIma, int(self.CanvasCont.wsize * 0.496 - imgEtiqwsize / 2),
                        int(self.CanvasCont.hsize * (coefY - 0.001)),
                        int(self.CanvasCont.wsize * 0.504 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasCont.hsize * (coefY + 0.001)) + imgEtiqhsize)

        self.CanvasGHS = []
        deb = 0
        if len(self.listGHS) == 3:
            deb = int(self.CanvasCont.wsize * Coefd)
        elif len(self.listGHS) == 2:
            deb = int(self.CanvasCont.wsize * (Coefd + Dd))
        elif len(self.listGHS) == 1:
            deb = int(self.CanvasCont.wsize * 0.5)
        for i in range(len(self.listGHS)):
            self.CanvasGHS.append(
                CanvasInWindow('Media/PictoDanger/', self.RatioX * coefR, self.RatioX * coefR,
                               self.CanvasCont.CanvasListIma,
                               tk.CENTER, deb + int(i * self.CanvasCont.wsize * Coefw),
                               int(self.CanvasCont.hsize * (coefY + 0.48)), self.listGHS[i]))

        self.FBProduit = self.CanvasCont.CanvasListIma.create_text(int(self.CanvasCont.wsize * 0.5),
                                                                   int(self.CanvasCont.hsize * (coefY + 0.02) +
                                                                       imgEtiqhsize),
                                                                   text=FB, font=AppliFont('Calibri',
                                                                                           self.MainAppli.SizeFont + 4,
                                                                                           'bold', 0), anchor=tk.CENTER)
        if prod[10] is not None and prod[10] != '':
            self.SynoProd = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * 0.5), int(self.CanvasCont.hsize * (coefY + 0.05) + imgEtiqhsize),
                text=prod[10], font=AppliFont('Calibri', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.CENTER)

        if prod[11] is not None and prod[11] != '':
            self.MMProd = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * 0.5), int(self.CanvasCont.hsize * (coefY + 0.08) + imgEtiqhsize),
                text='M: ' + prod[11] + ' g/mol', font=AppliFont('Calibri', self.MainAppli.SizeFont + 1, 'bold', 0),
                anchor=tk.CENTER)

        if prod[12] is not None and prod[12] != '':
            self.DProd = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * 0.5), int(self.CanvasCont.hsize * (coefY + 0.10) + imgEtiqhsize),
                text='d: ' + prod[12], font=AppliFont('Calibri', self.MainAppli.SizeFont + 1, 'bold', 0),
                anchor=tk.CENTER)
            h = 0.66
        elif prod[1] == 'mL' and prod[7].upper() != 'GAZ':
            h = 0.66
        else:
            h = 0.72
        if prod[13] is not None and prod[13] != '':
            self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h - 0.05) * coefh),
                text='mp (°C): ' + prod[13],
                font=AppliFont('Calibri', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        if prod[14] is not None and prod[14] != '':
            TextSolub = prod[14]
            if len(prod[14]) > 25:
                TextSolub = prod[14][0:26] + '\n' + prod[14][26:len(prod[14])]
            self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h - 0.03) * coefh),
                text='Hydrosolubilité (g/L à 20 °C): ' + TextSolub,
                font=AppliFont('Calibri', self.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        if prod[15] is not None and prod[15] != '':
            self.TextDanger = prod[15]
            if len(prod[15]) > 45:
                sizefont = self.MainAppli.SizeFont - 2
                if len(prod[15]) > 54:
                    self.TextDanger = prod[15][0:55] + '\n' + prod[15][55:len(prod[15])]
            else:
                sizefont = self.MainAppli.SizeFont
            MentionDanger = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * h * coefh),
                text='Mention de danger:', font=AppliFont('Calibri', self.MainAppli.SizeFont, 'bold', 1), anchor=tk.W)
            self.CanvasCont.CanvasListIma.addtag_withtag('MentionDangers', MentionDanger)
            self.CanvasCont.CanvasListIma.tag_bind('MentionDangers', '<ButtonRelease-1>', self.AffichDangers)
            self.Dangers = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h + 0.02) * coefh),
                text=self.TextDanger, font=AppliFont('Calibri', sizefont, 'bold', 0), anchor=tk.W)
            self.CanvasCont.CanvasListIma.addtag_withtag('Dangers', self.Dangers)
            self.CanvasCont.CanvasListIma.tag_bind('Dangers', '<ButtonRelease-1>', self.AffichDangers)

        if prod[16] is not None and prod[16] != '':
            self.TextConseil = prod[16]
            if len(prod[16]) > 45:
                sizefont = self.MainAppli.SizeFont - 2
                if len(prod[16]) > 54:
                    self.TextConseil = prod[16][0:55] + '\n' + prod[16][55:len(prod[16])]
            else:
                sizefont = self.MainAppli.SizeFont
            ConseilPrud = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h + 0.04) * coefh),
                text='Conseils de prudence:', font=AppliFont('Calibri', self.MainAppli.SizeFont, 'bold', 1),
                anchor=tk.W)
            self.CanvasCont.CanvasListIma.addtag_withtag('ConseilPrudence', ConseilPrud)
            self.CanvasCont.CanvasListIma.tag_bind('ConseilPrudence', '<ButtonRelease-1>', self.AffichConseils)
            self.Conseils = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h + 0.06) * coefh),
                text=self.TextConseil, font=AppliFont('Calibri', sizefont, 'bold', 0), anchor=tk.W)
            self.CanvasCont.CanvasListIma.addtag_withtag('Conseils', self.Conseils)
            self.CanvasCont.CanvasListIma.tag_bind('Conseils', '<ButtonRelease-1>', self.AffichConseils)

        self.MainAppli.CanvasFrmMain.itemconfigure('LegendePanneauD',
                                                   text="Informations - "
                                                        "Propriétés physico-chimiques du produit chimique")

    def AffichFDS(self):
        self.EffaceMenu()
        if self.Prod[17] is not None and self.Prod[17] != '' and \
                os.path.exists('Datas/FDS/' + self.Prod[17] + '.pdf'):
            self.FrmPDF = FrmPDF(self.CanvasMenu.CanvasListIma, 'Datas/FDS/' + self.Prod[17] + '.pdf', 0.85,
                                 self.CanvasMenu.hsize, int(self.CanvasMenu.wsize * 0.5),
                                 int(self.CanvasMenu.hsize * 0.49), int(self.CanvasMenu.wsize * 0.98),
                                 int(self.CanvasMenu.hsize * 0.855))
            self.FrmPDF.CanvasDoc.bind('<Double-1>', self.ZoomFDS)
            self.FrmPDF.CanvasDoc.bind('<Double-2>', self.OuvreFDS)
            self.MenuClicDroitFDS = tk.Menu(self.FrmPDF.CanvasDoc, tearoff=0)
            self.MenuClicDroitFDS.add_command(label="Zoom sur le document", command=self.ActionZoomFDS)
            self.MenuClicDroitFDS.add_separator()
            self.MenuClicDroitFDS.add_command(label="Ouvrir dans le navigateur", command=self.ActionOuvreFDS)
            self.FrmPDF.CanvasDoc.bind("<Button-3>", self.AffichMenuClicDroitFDS)
        else:
            self.NoPDF = NoPDF(self.CanvasMenu.CanvasListIma, 'Media/FrmInfo/NoPdf/NoPDF.jpg', int(self.SX * 0.5),
                               int(self.SY * 0.5), self.RatioX, self.RatioY)
            ChangeCursor2(self.NoPDF.CanvasImgNoPdf)

        self.MainAppli.CanvasFrmMain.itemconfigure('LegendePanneauD',
                                                   text="Informations - Fiche de sécurité du produit chimique")

    def EffaceMenu(self):
        for widget in self.CanvasMenu.CanvasListIma.winfo_children():
            widget.destroy()
        self.CanvasMenu.CanvasListIma.delete(self.NomProduit)
        self.CanvasMenu.CanvasListIma.delete(self.TitreStock)
        self.CanvasMenu.CanvasListIma.delete(self.TitreFournisseur)

    def DeterminListGHS(self, prod):
        listGHS = []
        for i in range(3):
            if prod[i + 3] is not None and prod[i + 3] != '':
                listGHS.append(prod[i + 3])
        self.listGHS = ModifListDanger(listGHS)

    def AffichDangers(self, _):
        if self.ZoomConseil is not None:
            self.ZoomConseil.destroy()
            self.ZoomConseil = None
        self.ZoomDanger = FrmZoomDanger(self.MainAppli.CanvasFrmMain, self.MainAppli.RatioFondX,
                                        self.MainAppli.RatioFondY, self.Prod[0], self.TextDanger, 'Dangers', self)
        self.ZoomActif = True

    def AffichConseils(self, _):
        if self.ZoomDanger is not None:
            self.ZoomDanger.destroy()
            self.ZoomDanger = None
        self.ZoomConseil = FrmZoomDanger(self.MainAppli.CanvasFrmMain, self.MainAppli.RatioFondX,
                                         self.MainAppli.RatioFondY, self.Prod[0], self.TextConseil, 'Conseils', self)
        self.ZoomActif = True

    def ClicOnCanvasCont(self, evt):
        if self.Nflacon < 3:
            if self.Nflacon == 1 or self.Nflacon == 2:
                Y = [0.715, 0.745, 0.75, 0.785]
            else:
                Y = [0.655, 0.685, 0.695, 0.725]
            if (self.CanvasCont.wsize * 0.18 < evt.x < self.CanvasCont.wsize * 0.9 and
                    self.CanvasCont.hsize * Y[0] < evt.y < self.CanvasCont.hsize * Y[1]):
                self.AffichDangers(evt)
            elif (self.CanvasCont.wsize * 0.18 < evt.x < self.CanvasCont.wsize * 0.9 and
                  self.CanvasCont.hsize * Y[2] < evt.y < self.CanvasCont.hsize * Y[3]):
                self.AffichConseils(evt)

    def MoveOnCanvasCont(self, evt):
        if self.Nflacon < 3:
            if self.Nflacon == 1 or self.Nflacon == 2:
                Y = [0.715, 0.745, 0.75, 0.785]
            else:
                Y = [0.655, 0.685, 0.695, 0.725]

            if (self.CanvasCont.wsize * 0.18 < evt.x < self.CanvasCont.wsize * 0.9 and
                self.CanvasCont.hsize * Y[0] < evt.y < self.CanvasCont.hsize * Y[1]) or \
                    (self.CanvasCont.wsize * 0.18 < evt.x < self.CanvasCont.wsize * 0.9 and
                     self.CanvasCont.hsize * Y[2] < evt.y < self.CanvasCont.hsize * Y[3]):
                self.CanvasCont.CanvasListIma.configure(cursor='hand2')
            else:
                self.CanvasCont.CanvasListIma.configure(cursor='')

    def ZoomFDS(self, _):
        self.ActionZoomFDS()

    def ActionZoomFDS(self):
        if self.FDSZoom is not None:
            self.FDSZoom.destroy()
        self.FDSZoom = FrmZoomDoc(self.parent, self.RatioX, self.RatioY, 'Datas/FDS/' + self.Prod[17] + '.pdf',
                                  self.Prod[0] + ' - FDS', self)
        self.FDSZoom.FrmPDF.DefilPage.set(self.FrmPDF.PageAffich)
        self.FDSZoom.FrmPDF.CanvasDoc.bind('<Double-1>', self.OuvreFDS)
        self.FDSZoom.FrmPDF.CanvasDoc.bind('<Button-1>', self.ClicOnCanvas)
        self.FDSZoom.CanvasFrmFond.bind('<Button-1>', self.ClicOnCanvas)
        self.ZoomActif = True

    def OuvreFDS(self, _):
        self.ActionOuvreFDS()

    def ActionOuvreFDS(self):
        AffichPDF(self.Prod[0] + ' - FDS', 'Datas/FDS/' + self.Prod[17] + '.pdf', self)

    def ClosePDF(self):
        self.MainAppli.parent.focus_force()
        self.MainAppli.FrmLift()
        self.focus_force()

    def ChercheWeb(self):
        webbrowser.open('https://fr.wikipedia.org/wiki/' + self.Prod[0], new=1)

    def AffichMenuClicDroitFDS(self, event):
        self.MenuClicDroitFDS.post(event.x_root, event.y_root)

    def AffichMenuClicDroitCaract(self, event):
        self.ListMenuClicDroitCaract.post(event.x_root, event.y_root)

    def MoveOnCanvas(self, _):
        for i in range(3):
            if not self.MenuOnglets.MenuSelected[i]:
                self.MenuOnglets.ListCanvasMenu[i].itemconfig(self.MenuOnglets.ListImgMenu[i],
                                                              image=self.MenuOnglets.ListMenu[i][0])

    def ClicOnCanvas(self, _):
        if self.MainAppli.NAction == 5:
            self.MainAppli.FrmLift()
