from AppliDef import *
from EtagProduits import ModifListDanger, ModifFB


class InfoMatPhys:
    def __init__(self, container, Mat, Cur, SizeFont, RatioX, RatioY, style, Lieux):
        QuantTot = ""
        QuantMin = ""
        Fournisseur = ""
        Ref = ""
        Cdt = ""
        Pht = ""
        Y = []
        X = []
        R = 0
        Rb = 0
        self.container = container
        if style == 1:
            Y = [0.055, 0.355, 0.62, 0.72, 0.9, 0.1]
            X = [0.5, 0.5]
            R = 0.4
            Rb = 1
        elif style == 2:
            Y = [0.06, 0.4, 0.72, 0.87, 0.87, 0.1]
            X = [0.19, 0.67]
            R = 0.3
            Rb = 1
        elif style == 3:
            Y = [0.06, 0.4, 0.72, 0.82, 0.82, 0.11]
            X = [0.19, 0.67]
            R = 0.3
            Rb = 1.2
        elif style == 4:
            Y = [0.055, 0.355, 0.62, 0.71, 0.88, 0.1]
            X = [0.5, 0.5]
            R = 0.4
            Rb = 1
        self.NomMat = LabelInCanvas(container, Mat[0], '#E0E0E0', AppliFont('Helvetica', SizeFont + 3, 'bold', 0),
                                    int(int(container['width']) * 0.5), int(int(container['height']) * Y[0]), tk.CENTER)

        self.TitreStock = container.create_text(int(int(container['width']) * 0.05),
                                                int(int(container['height']) * Y[5]), text='Stock',
                                                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.CanvasBoite = CanvasInWindow('Media/FrmInfo/Boite/', RatioX * Rb, RatioY * Rb, container, tk.CENTER,
                                          int(int(container['width']) * 0.5), int(int(container['height']) * Y[1]), 0)

        if Mat[2] is not None and Mat[2] != '':
            LabelInCanvas(self.CanvasBoite.CanvasListIma, Mat[2], '#C0C0C0',
                          AppliFont('Helvetica', SizeFont + 1, 'bold', 0),
                          int(self.CanvasBoite.wsize * 0.5), int(self.CanvasBoite.hsize * 0.1), tk.CENTER)

        if Mat[1] is not None and Mat[1] != '':
            self.ImgEtiqMat = []
            img = Image.open('Datas/VisuelMatPhys/' + Mat[1])
            imgEtiqwsize = int(self.CanvasBoite.wsize * 0.295)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasBoite.hsize * 0.115:
                imgEtiqhsize = int(self.CanvasBoite.hsize * 0.115)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqMat.append(ImageTk.PhotoImage(img))

            self.CanvasImgEtiqMat = CanvasApp(self.CanvasBoite.CanvasListIma, width=imgEtiqwsize,
                                              height=imgEtiqhsize)
            self.CanvasBoite.CanvasListIma.create_window(int(self.CanvasBoite.wsize * 0.497),
                                                         int(self.CanvasBoite.hsize * 0.158), anchor=tk.N,
                                                         window=self.CanvasImgEtiqMat)
            self.ImgCanvasImgEtiqMat = self.CanvasImgEtiqMat.create_image(0, 0, anchor=tk.NW, image=self.ImgEtiqMat[0])
            CreateCadre(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.494 - imgEtiqwsize / 2),
                        int(self.CanvasBoite.hsize * 0.155),
                        int(self.CanvasBoite.wsize * 0.500 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasBoite.hsize * 0.161) + imgEtiqhsize)

        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.35), text='Lieu de stockage',
            font=AppliFont('Helvetica', SizeFont + 1, 'bold', 1), anchor=tk.CENTER)
        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.35), text='Quantité',
            font=AppliFont('Helvetica', SizeFont + 1, 'bold', 1), anchor=tk.CENTER)

        LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux[0], '#C0C0C0',
                      AppliFont('Helvetica', SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.41), tk.CENTER)
        if Mat[3] is not None and Mat[3] != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.47), text=Mat[3],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.47), text=Mat[4],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            if Mat[4] is not None and Mat[4] != '':
                QuantTot = Mat[4]
        LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux[1], '#C0C0C0',
                      AppliFont('Helvetica', SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.58), tk.CENTER)
        if Mat[5] is not None and Mat[5] != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.64), text=Mat[5],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.64), text=Mat[6],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            if Mat[6] is not None and Mat[6] != '':
                if QuantTot != '':
                    QuantTot = str(int(QuantTot) + int(Mat[6]))
                else:
                    QuantTot = Mat[6]
        LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux[2], '#C0C0C0',
                      AppliFont('Helvetica', SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.75), tk.CENTER)
        if Mat[7] is not None and Mat[7] != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.81), text=Mat[7],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.81), text=Mat[8],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            if Mat[8] is not None and Mat[8] != '':
                if QuantTot != '':
                    QuantTot = str(int(QuantTot) + int(Mat[8]))
                else:
                    QuantTot = Mat[8]
        if Mat[9] is not None and Mat[9] != '':
            QuantMin = Mat[9]
        if Mat[10] is not None and Mat[10] != '':
            Fournisseur = Mat[10]
        if Mat[11] is not None and Mat[11] != '':
            Ref = Mat[11]
        if Mat[12] is not None and Mat[12] != '':
            Cdt = Mat[12]
        if Mat[13] is not None and Mat[13] != '':
            Pht = Mat[13]

        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.18), int(self.CanvasBoite.hsize * 0.88), text='Stock - Quantité totale: ',
            font=AppliFont('Helvetica', SizeFont + 1, 'bold', 0), anchor=tk.W)
        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.88), text=QuantTot,
            font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        if QuantMin != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.18), int(self.CanvasBoite.hsize * 0.92),
                text='Stock - Quantité minimale: ',
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.W)
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.92), text=QuantMin,
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.CENTER, fill='blue')

        self.TitreFournisseur = container.create_text(
            int(int(container['width']) * 0.05), int(int(container['height']) * Y[2]), text='Fournisseur',
            font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.W)

        Logo = []
        if Fournisseur != '':
            Cur.execute('SELECT Logo FROM Fournisseurs WHERE NOM LIKE \'%' + Fournisseur + '%\' order by NOM')
            Logo = Cur.fetchall()

        if len(Logo) > 0 and Logo[0][0] != '' and Logo[0][0] is not None:
            PathLogo = 'Datas/Fournisseurs/Logos/' + Logo[0][0]
        else:
            if Fournisseur == '':
                PathLogo = 'Datas/Fournisseurs/Logos/NC'
            else:
                PathLogo = 'Datas/Fournisseurs/Logos/Vide'

        self.ImgFournisseur = ImgInCanvas(container, PathLogo, R, tk.CENTER,
                                          int(int(container['width']) * X[0]), int(int(container['height']) * Y[3]))

        if len(Logo) == 0 or Logo[0][0] == '' or Logo[0][0] is None:
            if len(Fournisseur) < 15:
                TextFournisseur = Fournisseur
            else:
                TextFournisseur = Fournisseur.split(' ')[0] + '\n' + Fournisseur.split(' ')[1]
            self.ImgFournisseur.CanvasImg.create_text(
                int(int(self.ImgFournisseur.CanvasImg['width']) * 0.5),
                int(int(self.ImgFournisseur.CanvasImg['height']) * 0.5), text=TextFournisseur,
                font=AppliFont('Helvetica', SizeFont + 4, 'bold', 0), anchor=tk.CENTER, justify=tk.CENTER)

        self.CanvasEtiqPrix = CanvasInWindow('Media/FrmInfo/Etiq/', RatioX * 0.9, RatioY * 0.7,
                                             container, tk.CENTER, int(int(container['width']) * X[1]),
                                             int(int(container['height']) * Y[4]), 0)
        self.CanvasEtiqPrix.CanvasListIma.create_text(
            int(self.CanvasEtiqPrix.wsize * 0.5), int(self.CanvasEtiqPrix.hsize * 0.2), text=Mat[0],
            font=AppliFont('Helvetica', SizeFont - 1, 'bold', 0), anchor=tk.CENTER)

        if Ref != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.45), text='Ref: ' + Ref,
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.W)

        if Cdt != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.6),
                text='Cdt: ' + Cdt,
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.W)

        if Pht != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.75), int(self.CanvasEtiqPrix.hsize * 0.55),
                text=Pht + ' € HT',
                font=AppliFont('Helvetica', SizeFont + 3, 'bold', 0), anchor=tk.CENTER)

    def EffaceMenu(self):
        for widget in self.container.winfo_children():
            widget.destroy()
        self.container.delete(self.NomMat)
        self.container.delete(self.TitreStock)
        self.container.delete(self.TitreFournisseur)


class InfoMatChim:
    def __init__(self, container, Mat, Cur, SizeFont, RatioX, RatioY, style, Lieux):
        QuantTot = ""
        QuantMin = ""
        Fournisseur = ""
        Ref = ""
        Cdt = ""
        Pht = ""
        Y = []
        X = []
        R = 0
        Rb = 0
        if style == 1:
            Y = [0.058, 0.355, 0.62, 0.72, 0.89, 0.11]
            X = [0.5, 0.5]
            R = 0.35
            Rb = 1
        elif style == 2:
            Y = [0.06, 0.4, 0.72, 0.87, 0.87, 0.09]
            X = [0.19, 0.67]
            R = 0.3
            Rb = 1
        elif style == 3:
            Y = [0.06, 0.4, 0.72, 0.82, 0.82, 0.11]
            X = [0.19, 0.67]
            R = 0.3
            Rb = 1.2
        self.NomMat = LabelInCanvas(container, Mat[0], '#E0E0E0', AppliFont('Helvetica', SizeFont + 3, 'bold', 0),
                                    int(int(container['width']) * 0.5), int(int(container['height']) * Y[0]), tk.CENTER)

        self.TitreStock = container.create_text(int(int(container['width']) * 0.05),
                                                int(int(container['height']) * Y[5]), text='Stock',
                                                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.CanvasBoite = CanvasInWindow('Media/FrmInfo/Boite/', RatioX * Rb, RatioY * Rb, container, tk.CENTER,
                                          int(int(container['width']) * 0.5), int(int(container['height']) * Y[1]), 0)

        if Mat[2] is not None and Mat[2] != '':
            LabelInCanvas(self.CanvasBoite.CanvasListIma, Mat[2], '#C0C0C0',
                          AppliFont('Helvetica', SizeFont + 1, 'bold', 0),
                          int(self.CanvasBoite.wsize * 0.5), int(self.CanvasBoite.hsize * 0.1), tk.CENTER)

        if Mat[1] is not None and Mat[1] != '':
            self.ImgEtiqMat = []
            img = Image.open('Datas/VisuelMatChim/' + Mat[1])
            imgEtiqwsize = int(self.CanvasBoite.wsize * 0.295)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasBoite.hsize * 0.115:
                imgEtiqhsize = int(self.CanvasBoite.hsize * 0.115)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqMat.append(ImageTk.PhotoImage(img))

            self.CanvasImgEtiqMat = CanvasApp(self.CanvasBoite.CanvasListIma, width=imgEtiqwsize,
                                              height=imgEtiqhsize)
            self.CanvasBoite.CanvasListIma.create_window(int(self.CanvasBoite.wsize * 0.497),
                                                         int(self.CanvasBoite.hsize * 0.158), anchor=tk.N,
                                                         window=self.CanvasImgEtiqMat)
            self.ImgCanvasImgEtiqMat = self.CanvasImgEtiqMat.create_image(0, 0, anchor=tk.NW, image=self.ImgEtiqMat[0])
            CreateCadre(self.CanvasBoite.CanvasListIma, int(self.CanvasBoite.wsize * 0.494 - imgEtiqwsize / 2),
                        int(self.CanvasBoite.hsize * 0.155),
                        int(self.CanvasBoite.wsize * 0.500 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasBoite.hsize * 0.161) + imgEtiqhsize)

        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.35), text='Lieu de stockage',
            font=AppliFont('Helvetica', SizeFont + 1, 'bold', 1), anchor=tk.CENTER)
        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.35), text='Quantité',
            font=AppliFont('Helvetica', SizeFont + 1, 'bold', 1), anchor=tk.CENTER)

        LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux[0], '#C0C0C0',
                      AppliFont('Helvetica', SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.41), tk.CENTER)
        if Mat[3] is not None and Mat[3] != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.47), text=Mat[3],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.47), text=Mat[4],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            if Mat[4] is not None and Mat[4] != '':
                QuantTot = Mat[4]
        if Mat[5] is not None and Mat[5] != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.51), text=Mat[5],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.51), text=Mat[6],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux[1], '#C0C0C0',
                      AppliFont('Helvetica', SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.58), tk.CENTER)

        if Mat[7] is not None and Mat[7] != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.64), text=Mat[7],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.64), text=Mat[8],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
        if Mat[9] is not None and Mat[9] != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.68), text=Mat[9],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.68), text=Mat[10],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        LabelInCanvas(self.CanvasBoite.CanvasListIma, Lieux[2], '#C0C0C0',
                      AppliFont('Helvetica', SizeFont, 'bold', 0),
                      int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.75), tk.CENTER)
        if Mat[11] is not None and Mat[11] != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.37), int(self.CanvasBoite.hsize * 0.81), text=Mat[11],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.81), text=Mat[12],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')
        if Mat[13] is not None and Mat[13] != '':
            QuantTot = Mat[13]
        if Mat[14] is not None and Mat[14] != '':
            QuantMin = Mat[14]
        if Mat[15] is not None and Mat[15] != '':
            Fournisseur = Mat[15]
        if Mat[16] is not None and Mat[16] != '':
            Ref = Mat[16]
        if Mat[17] is not None and Mat[17] != '':
            Cdt = Mat[17]
        if Mat[18] is not None and Mat[18] != '':
            Pht = Mat[18]

        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.18), int(self.CanvasBoite.hsize * 0.88), text='Stock - Quantité totale: ',
            font=AppliFont('Helvetica', SizeFont + 1, 'bold', 0), anchor=tk.W)
        self.CanvasBoite.CanvasListIma.create_text(
            int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.88), text=QuantTot,
            font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        if QuantMin != '':
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.18), int(self.CanvasBoite.hsize * 0.92),
                text='Stock - Quantité minimale: ',
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.W)
            self.CanvasBoite.CanvasListIma.create_text(
                int(self.CanvasBoite.wsize * 0.67), int(self.CanvasBoite.hsize * 0.92), text=QuantMin,
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.CENTER, fill='blue')

        self.TitreFournisseur = container.create_text(
            int(int(container['width']) * 0.05),
            int(int(container['height']) * Y[2]), text='Fournisseur',
            font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.W)

        Logo = []
        if Fournisseur != '':
            Cur.execute('SELECT Logo FROM Fournisseurs WHERE NOM LIKE \'%' + Fournisseur + '%\' order by NOM')
            Logo = Cur.fetchall()

        if len(Logo) > 0 and Logo[0][0] != '' and Logo[0][0] is not None:
            PathLogo = 'Datas/Fournisseurs/Logos/' + Logo[0][0]
        else:
            if Fournisseur == '':
                PathLogo = 'Datas/Fournisseurs/Logos/NC'
            else:
                PathLogo = 'Datas/Fournisseurs/Logos/Vide'

        self.ImgFournisseur = ImgInCanvas(container, PathLogo, R, tk.CENTER, int(int(container['width']) * X[0]),
                                          int(int(container['height']) * Y[3]))

        if len(Logo) == 0 or Logo[0][0] == '' or Logo[0][0] is None:
            if len(Fournisseur) < 15:
                TextFournisseur = Fournisseur
            else:
                TextFournisseur = Fournisseur.split(' ')[0] + '\n' + Fournisseur.split(' ')[1]
            self.ImgFournisseur.CanvasImg.create_text(
                int(int(self.ImgFournisseur.CanvasImg['width']) * 0.5),
                int(int(self.ImgFournisseur.CanvasImg['height']) * 0.5), text=TextFournisseur,
                font=AppliFont('Helvetica', SizeFont + 4, 'bold', 0), anchor=tk.CENTER, justify=tk.CENTER)

        self.CanvasEtiqPrix = CanvasInWindow('Media/FrmInfo/Etiq/', RatioX * 0.9, RatioY * 0.7, container, tk.CENTER,
                                             int(int(container['width']) * X[1]),
                                             int(int(container['height']) * Y[4]), 0)
        self.CanvasEtiqPrix.CanvasListIma.create_text(
            int(self.CanvasEtiqPrix.wsize * 0.5), int(self.CanvasEtiqPrix.hsize * 0.2), text=Mat[0],
            font=AppliFont('Helvetica', SizeFont - 1, 'bold', 0), anchor=tk.CENTER)

        if Ref != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.45), text='Ref: ' + Ref,
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.W)

        if Cdt != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.6),
                text='Cdt: ' + Cdt,
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.W)

        if Pht != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.75), int(self.CanvasEtiqPrix.hsize * 0.55),
                text=Pht + ' € HT',
                font=AppliFont('Helvetica', SizeFont + 3, 'bold', 0), anchor=tk.CENTER)


class InfoProd:
    def __init__(self, container, prod, cur, SizeFont, RatioX, RatioY, style):
        R = []
        Y = 0
        Fournisseur = ''
        if style == 1:
            R = [1.3, 1.1]
            Y = 0.87
        elif style == 2:
            R = [1.1, 0.9]
            Y = 0.87
        elif style == 3:
            R = [1.3, 1.1]
            Y = 0.83
        self.listGHS = None

        self.NomProd = LabelInCanvas(container, prod[0], '#E0E0E0', AppliFont('Helvetica', SizeFont + 3, 'bold', 0),
                                     int(int(container['width']) * 0.5), int(int(container['height']) * 0.06),
                                     tk.CENTER)

        self.TitreStock = container.create_text(
            int(int(container['width']) * 0.05), int(int(container['height']) * 0.12), text='Stock',
            font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.CanvasArmoire = CanvasInWindow('Media/FrmInfo/Armoires/', RatioX * R[0], RatioY * R[1],
                                            container, tk.CENTER, int(int(container['width']) * 0.5),
                                            int(int(container['height']) * 0.42), 0)
        if prod[7] is not None and prod[7] != '':
            LabelInCanvas(self.CanvasArmoire.CanvasListIma, prod[7], '#C0C0C0',
                          AppliFont('Helvetica', SizeFont + 1, 'bold', 0),
                          int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.1), tk.CENTER)

        if prod[2] is not None and prod[2] != '':
            self.ImgEtiqProd = []
            img = Image.open('Datas/Formdev/' + prod[2])
            imgEtiqwsize = int(self.CanvasArmoire.wsize * 0.2)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasArmoire.hsize * 0.2:
                imgEtiqhsize = int(self.CanvasArmoire.hsize * 0.2)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqProd.append(ImageTk.PhotoImage(img))

            self.CanvasImgEtiqProd = CanvasApp(self.CanvasArmoire.CanvasListIma, width=imgEtiqwsize,
                                               height=imgEtiqhsize)
            self.CanvasArmoire.CanvasListIma.create_window(int(self.CanvasArmoire.wsize * 0.145),
                                                           int(self.CanvasArmoire.hsize * 0.065), anchor=tk.N,
                                                           window=self.CanvasImgEtiqProd)
            self.ImgCanvasImgEtiqProd = self.CanvasImgEtiqProd.create_image(0, 0, anchor=tk.NW,
                                                                            image=self.ImgEtiqProd[0])
            CreateCadre(self.CanvasArmoire.CanvasListIma, int(self.CanvasArmoire.wsize * 0.14 - imgEtiqwsize / 2),
                        int(self.CanvasArmoire.hsize * 0.06),
                        int(self.CanvasArmoire.wsize * 0.148 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasArmoire.hsize * 0.065) + imgEtiqhsize)

        if prod[8] is not None and prod[8] != '':
            LabelInCanvas(self.CanvasArmoire.CanvasListIma, 'Lieu de stockage', '#C0C0C0',
                          AppliFont('Helvetica', SizeFont + 1, 'bold', 0),
                          int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.245), tk.CENTER)
            self.CanvasArmoire.CanvasListIma.create_text(
                int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.335),
                text=prod[8],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        if prod[18] is not None and prod[18] != '':
            LabelInCanvas(self.CanvasArmoire.CanvasListIma, 'Quantité en stock (' + prod[1] + '):', '#C0C0C0',
                          AppliFont('Helvetica', SizeFont + 1, 'bold', 0),
                          int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.476), tk.CENTER)
            self.CanvasArmoire.CanvasListIma.create_text(
                int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.565),
                text=prod[18].replace('.', ','),
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        if prod[19] is not None and prod[19] != '':
            LabelInCanvas(self.CanvasArmoire.CanvasListIma, 'Quantité utilisée / an (' + prod[1] + '):', '#C0C0C0',
                          AppliFont('Helvetica', SizeFont + 1, 'bold', 0),
                          int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.698), tk.CENTER)
            self.CanvasArmoire.CanvasListIma.create_text(
                int(self.CanvasArmoire.wsize * 0.52), int(self.CanvasArmoire.hsize * 0.79),
                text=prod[19].replace('.', ','),
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.CENTER, fill='blue')

        self.DeterminListGHS(prod)
        self.CanvasGHS = []
        deb = 0
        if len(self.listGHS) == 3:
            deb = int(self.CanvasArmoire.wsize * 0.4)
        elif len(self.listGHS) == 2:
            deb = int(self.CanvasArmoire.wsize * 0.45)
        elif len(self.listGHS) == 1:
            deb = int(self.CanvasArmoire.wsize * 0.5)
        for i in range(len(self.listGHS)):
            self.CanvasGHS.append(
                CanvasInWindow('Media/PictoDanger/', RatioX * 0.6, RatioX * 0.6, self.CanvasArmoire.CanvasListIma,
                               tk.CENTER, int(self.CanvasArmoire.wsize * 0.13),
                               deb + int(i * self.CanvasArmoire.hsize * 0.15), self.listGHS[i]))

        self.TitreFournisseur = container.create_text(
            int(int(container['width']) * 0.05), int(int(container['height']) * 0.73), text='Fournisseur',
            font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.W)

        if prod[9] is not None and prod[9] != '':
            Fournisseur = prod[9]

        Logo = []
        if Fournisseur != '':
            cur.execute('SELECT Logo FROM Fournisseurs WHERE NOM LIKE \'%' + Fournisseur + '%\' order by NOM')
            Logo = cur.fetchall()
        if len(Logo) > 0 and Logo[0][0] != '' and Logo[0][0] is not None:
            PathLogo = 'Datas/Fournisseurs/Logos/' + Logo[0][0]
        else:
            if Fournisseur == '':
                PathLogo = 'Datas/Fournisseurs/Logos/NC'
            else:
                PathLogo = 'Datas/Fournisseurs/Logos/Vide'

        self.ImgFournisseur = ImgInCanvas(container, PathLogo, 0.3, tk.CENTER,
                                          int(int(container['width']) * 0.19), int(int(container['height']) * Y))

        if len(Logo) == 0 or Logo[0][0] == '' or Logo[0][0] is None:
            if len(Fournisseur) < 15:
                TextFournisseur = Fournisseur
            else:
                TextFournisseur = Fournisseur.split(' ')[0] + '\n' + Fournisseur.split(' ')[1]
            self.ImgFournisseur.CanvasImg.create_text(int(int(self.ImgFournisseur.CanvasImg['width']) * 0.5),
                                                      int(int(self.ImgFournisseur.CanvasImg['height']) * 0.5),
                                                      text=TextFournisseur,
                                                      font=AppliFont('Helvetica', SizeFont + 4, 'bold', 0),
                                                      anchor=tk.CENTER, justify=tk.CENTER)

        self.CanvasEtiqPrix = CanvasInWindow('Media/FrmInfo/Etiq/', RatioX * 0.9, RatioY * 0.7,
                                             container, tk.CENTER, int(int(container['width']) * 0.67),
                                             int(int(container['height']) * Y), 0)
        self.CanvasEtiqPrix.CanvasListIma.create_text(
            int(self.CanvasEtiqPrix.wsize * 0.5), int(self.CanvasEtiqPrix.hsize * 0.2), text=prod[0],
            font=AppliFont('Helvetica', SizeFont - 1, 'bold', 0), anchor=tk.CENTER)

        if prod[20] is not None and prod[20] != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.45), text='Ref: ' + prod[20],
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.W)

        if prod[21] is not None and prod[21] != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.6),
                text='Cdt: ' + prod[21] + ' ' + prod[1],
                font=AppliFont('Helvetica', SizeFont, 'bold', 0), anchor=tk.W)

        if prod[22] is not None and prod[22] != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.75), int(self.CanvasEtiqPrix.hsize * 0.55),
                text=prod[22] + ' € HT',
                font=AppliFont('Helvetica', SizeFont + 3, 'bold', 0), anchor=tk.CENTER)

        if prod[26] is not None and prod[26] != '':
            self.CanvasEtiqPrix.CanvasListIma.create_text(
                int(self.CanvasEtiqPrix.wsize * 0.1), int(self.CanvasEtiqPrix.hsize * 0.83),
                text='CAS: ' + prod[26], fill='white',
                font=AppliFont('Helvetica', SizeFont + 1, 'bold', 0), anchor=tk.W)

    def DeterminListGHS(self, prod):
        listGHS = []
        for i in range(3):
            if prod[i + 3] is not None and prod[i + 3] != '':
                listGHS.append(prod[i + 3])
        self.listGHS = ModifListDanger(listGHS)


class DescriptMat:
    def __init__(self, container, Mat, BaseEnCours, SizeFont, RatioX, RatioY):
        Indice = 0
        if BaseEnCours == 'CHIMIE':
            Indice = 19
        elif BaseEnCours == 'PHYS':
            Indice = 14
        self.CanvasDescript = CanvasInWindow('Media/FrmInfo/FondDescriptMat/', RatioX * 1.8, RatioY * 1.8,
                                             container, tk.CENTER, int(int(container['width']) * 0.5),
                                             int(int(container['height']) * 0.5), 0)
        if len(Mat[0]) >= 55:
            self.NomMat = None
            (Nom1, Nom2) = (Mat[0][:len(Mat[0]) // 2], Mat[0][len(Mat[0]) // 2:])
            self.NomMat1 = self.CanvasDescript.CanvasListIma.create_text(
                int(self.CanvasDescript.wsize * 0.5), int(self.CanvasDescript.hsize * 0.08), text=Nom1 + '-',
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.CENTER)
            self.NomMat2 = self.CanvasDescript.CanvasListIma.create_text(
                int(self.CanvasDescript.wsize * 0.5), int(self.CanvasDescript.hsize * 0.11), text=Nom2,
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.CENTER)
        else:
            self.NomMat1 = None
            self.NomMat2 = None
            self.NomMat = self.CanvasDescript.CanvasListIma.create_text(
                int(self.CanvasDescript.wsize * 0.5), int(self.CanvasDescript.hsize * 0.08), text=Mat[0],
                font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.CENTER)

        if Mat[1] is not None and Mat[1] != '':
            self.ImgEtiqMat = []
            img = None
            if BaseEnCours == 'CHIMIE':
                img = Image.open('Datas/VisuelMatChim/' + Mat[1])
            elif BaseEnCours == 'PHYS':
                img = Image.open('Datas/VisuelMatPhys/' + Mat[1])
            imgEtiqwsize = int(self.CanvasDescript.wsize * 0.6)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasDescript.hsize * 0.25:
                imgEtiqhsize = int(self.CanvasDescript.hsize * 0.25)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqMat.append(ImageTk.PhotoImage(img))

            self.CanvasImgEtiqMat = CanvasApp(self.CanvasDescript.CanvasListIma, width=imgEtiqwsize,
                                              height=imgEtiqhsize)
            self.CanvasDescript.CanvasListIma.create_window(int(self.CanvasDescript.wsize * 0.5),
                                                            int(self.CanvasDescript.hsize * 0.15), anchor=tk.N,
                                                            window=self.CanvasImgEtiqMat)
            self.ImgCanvasImgEtiqMat = self.CanvasImgEtiqMat.create_image(0, 0, anchor=tk.NW, image=self.ImgEtiqMat[0])
            CreateCadre(self.CanvasDescript.CanvasListIma, int(self.CanvasDescript.wsize * 0.498 - imgEtiqwsize / 2),
                        int(self.CanvasDescript.hsize * 0.148),
                        int(self.CanvasDescript.wsize * 0.502 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasDescript.hsize * 0.151) + imgEtiqhsize)

        else:
            self.CanvasVisuel = CanvasInWindow('Media/FrmAjout/NoVisuel/', RatioX, RatioY,
                                               self.CanvasDescript.CanvasListIma, tk.CENTER,
                                               int(self.CanvasDescript.wsize * 0.5),
                                               int(self.CanvasDescript.hsize * 0.25), 0)

        self.CanvasDescript.CanvasListIma.create_text(
            int(self.CanvasDescript.wsize * 0.05), int(self.CanvasDescript.hsize * 0.46), text='Caractéristiques:',
            font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.W)

        Coefhsize = 0.51
        for i in range(0, 8, 2):
            if Mat[Indice + i] is not None and Mat[Indice + i] != '':
                self.CanvasDescript.CanvasListIma.create_text(
                    int(self.CanvasDescript.wsize * 0.11), int(self.CanvasDescript.hsize * Coefhsize),
                    text=Mat[Indice + i] + ' : ' + Mat[Indice + 1 + i],
                    font=AppliFont('Helvetica', SizeFont + 2, 'bold', 0), anchor=tk.W)
                Coefhsize = Coefhsize + 0.03

        self.CanvasDescript.CanvasListIma.create_text(
            int(self.CanvasDescript.wsize * 0.05), int(self.CanvasDescript.hsize * 0.67), text='Descriptif:',
            font=AppliFont('Helvetica', SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.ZoneText = ZoneScrolledText(self.CanvasDescript.CanvasListIma, width=int(self.CanvasDescript.wsize * 0.12),
                                         height=int(self.CanvasDescript.hsize * 0.015),
                                         font=AppliFont('Helvetica', SizeFont, 'normal', 0))

        self.CanvasDescript.CanvasListIma.create_window(int(self.CanvasDescript.wsize * 0.025),
                                                        int(self.CanvasDescript.hsize * 0.72), anchor=tk.NW,
                                                        window=self.ZoneText)
        if BaseEnCours == 'CHIMIE':
            if Mat[28] is not None and Mat[28] != '':
                File = open('Datas/DescriptMatChim/' + Mat[28] + '.txt', "r", encoding="utf-8")
                for ligne in File:
                    self.ZoneText.insert(tk.INSERT, ligne)
        elif BaseEnCours == 'PHYS':
            if Mat[23] is not None and Mat[23] != '':
                File = open('Datas/DescriptMatPhys/' + Mat[23] + '.txt', "r", encoding="utf-8")
                for ligne in File:
                    self.ZoneText.insert(tk.INSERT, ligne)

        self.ZoneText.configure(state='disabled')


class CaractProd:
    def __init__(self, container, prod, SizeFont, RatioX, RatioY):
        self.listGHS = []
        Nflacon = 0
        coefY = 0.38
        coefR = 0.9
        Coefw = 0.2
        Coefd = 0.3
        coefX = 0.18
        coefh = 1
        Dd = 0.1
        maxchr = 35
        if prod[12] is not None and prod[12] != '' or (prod[1] == 'mL' and prod[7].upper() != 'GAZ'):
            Nflacon = 0
        elif prod[1] == 'g':
            Nflacon = 1
        elif prod[7] is not None and prod[7].upper() == 'GAZ':
            Nflacon = 2
            coefY = 0.41
            coefR = 0.7
            Coefw = 0.15
            Coefd = 0.35
            coefX = 0.25
            Dd = 0.08
            maxchr = 20
        elif prod[1].upper() == 'UNIT' or prod[1] == '':
            Nflacon = 3
            maxchr = 42
            coefY = 0.365
            coefh = 0.87
        self.CanvasCont = CanvasInWindow('Media/FrmInfo/Flacon/', RatioX, RatioY * 0.92,
                                         container, tk.CENTER, int(int(container['width']) * 0.5),
                                         int(int(container['height']) * 0.5), Nflacon)
        FB = ''
        FormDev = ''
        Nom = prod[0]
        if prod[2] is not None and prod[2] != '':
            FormDev = prod[2]
        if prod[6] is not None and prod[6] != '':
            FB = prod[6]
            FB = ModifFB(FB)

        self.DeterminListGHS(prod)

        if len(Nom) >= maxchr:
            sizefont = SizeFont
            if len(Nom) > 28:
                (Nom1, Nom2) = (Nom[:len(Nom) // 2], Nom[len(Nom) // 2:])
                Nom = Nom1 + '-\n' + Nom2
        else:
            sizefont = SizeFont + 2
        self.NomProduit = self.CanvasCont.CanvasListIma.create_text(int(self.CanvasCont.wsize * 0.5),
                                                                    int(self.CanvasCont.hsize * (coefY - 0.03)),
                                                                    text=Nom,
                                                                    font=AppliFont('Helvetica', sizefont, 'bold', 0),
                                                                    anchor=tk.CENTER)
        imgEtiqhsize = 0
        if FormDev != '':
            self.ImgEtiqProd = []
            img = Image.open('Datas/Formdev/' + FormDev)
            imgEtiqwsize = int(self.CanvasCont.wsize * 0.4)
            imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
            if imgEtiqhsize > self.CanvasCont.hsize * 0.08:
                imgEtiqhsize = int(self.CanvasCont.hsize * 0.1)
                imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
            img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
            self.ImgEtiqProd.append(ImageTk.PhotoImage(img))

            self.CanvasContEtiqProd = CanvasApp(self.CanvasCont.CanvasListIma, width=imgEtiqwsize, height=imgEtiqhsize)
            self.CanvasCont.CanvasListIma.create_window(int(self.CanvasCont.wsize * 0.5),
                                                        int(self.CanvasCont.hsize * coefY), anchor=tk.N,
                                                        window=self.CanvasContEtiqProd)
            self.ImgCanvasContEtiqProd = self.CanvasContEtiqProd.create_image(0, 0, anchor=tk.NW,
                                                                              image=self.ImgEtiqProd[0])

            CreateCadre(self.CanvasCont.CanvasListIma, int(self.CanvasCont.wsize * 0.496 - imgEtiqwsize / 2),
                        int(self.CanvasCont.hsize * (coefY - 0.001)),
                        int(self.CanvasCont.wsize * 0.504 - imgEtiqwsize / 2) + imgEtiqwsize,
                        int(self.CanvasCont.hsize * (coefY + 0.001)) + imgEtiqhsize)

        self.CanvasGHS = []
        deb = 0
        if len(self.listGHS) == 3:
            deb = int(self.CanvasCont.wsize * Coefd)
        elif len(self.listGHS) == 2:
            deb = int(self.CanvasCont.wsize * (Coefd + Dd))
        elif len(self.listGHS) == 1:
            deb = int(self.CanvasCont.wsize * 0.5)
        for i in range(len(self.listGHS)):
            self.CanvasGHS.append(
                CanvasInWindow('Media/PictoDanger/', RatioX * coefR, RatioX * coefR,
                               self.CanvasCont.CanvasListIma,
                               tk.CENTER, deb + int(i * self.CanvasCont.wsize * Coefw),
                               int(self.CanvasCont.hsize * (coefY + 0.48)), self.listGHS[i]))

        self.FBProduit = self.CanvasCont.CanvasListIma.create_text(int(self.CanvasCont.wsize * 0.5),
                                                                   int(self.CanvasCont.hsize * (coefY + 0.02) +
                                                                       imgEtiqhsize),
                                                                   text=FB, font=AppliFont('Calibri',
                                                                                           SizeFont + 4,
                                                                                           'bold', 0), anchor=tk.CENTER)
        if prod[10] is not None and prod[10] != '':
            self.SynoProd = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * 0.5), int(self.CanvasCont.hsize * (coefY + 0.05) + imgEtiqhsize),
                text=prod[10], font=AppliFont('Calibri', SizeFont, 'bold', 0), anchor=tk.CENTER)

        if prod[11] is not None and prod[11] != '':
            self.MMProd = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * 0.5), int(self.CanvasCont.hsize * (coefY + 0.08) + imgEtiqhsize),
                text='M: ' + prod[11] + ' g/mol', font=AppliFont('Calibri', SizeFont + 1, 'bold', 0),
                anchor=tk.CENTER)

        if prod[12] is not None and prod[12] != '':
            self.dProd = self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * 0.5), int(self.CanvasCont.hsize * (coefY + 0.10) + imgEtiqhsize),
                text='d: ' + prod[12], font=AppliFont('Calibri', SizeFont + 1, 'bold', 0),
                anchor=tk.CENTER)
            h = 0.66
        else:
            h = 0.72
        if prod[13] is not None and prod[13] != '':
            self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h - 0.05) * coefh),
                text='mp (°C): ' + prod[13],
                font=AppliFont('Calibri', SizeFont, 'bold', 0), anchor=tk.W)

        if prod[14] is not None and prod[14] != '':
            self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h - 0.03) * coefh),
                text='Hydrosolubilité (g/L à 20 °C): ' + prod[14],
                font=AppliFont('Calibri', SizeFont, 'bold', 0), anchor=tk.W)

        if prod[15] is not None and prod[15] != '':
            if len(prod[15]) > 45:
                sizefont = SizeFont - 2
            else:
                sizefont = SizeFont
            self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * h * coefh),
                text='Mention de danger:', font=AppliFont('Calibri', SizeFont, 'bold', 1), anchor=tk.W)
            self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h + 0.02) * coefh),
                text=prod[15], font=AppliFont('Calibri', sizefont, 'bold', 0), anchor=tk.W)
        if prod[16] is not None and prod[16] != '':
            if len(prod[16]) > 45:
                sizefont = SizeFont - 2
            else:
                sizefont = SizeFont
            self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h + 0.04) * coefh),
                text='Conseils de prudence:', font=AppliFont('Calibri', SizeFont, 'bold', 1),
                anchor=tk.W)
            self.CanvasCont.CanvasListIma.create_text(
                int(self.CanvasCont.wsize * coefX), int(self.CanvasCont.hsize * (h + 0.06) * coefh),
                text=prod[16], font=AppliFont('Calibri', sizefont, 'bold', 0), anchor=tk.W)

    def DeterminListGHS(self, prod):
        listGHS = []
        for i in range(3):
            if prod[i + 3] is not None and prod[i + 3] != '':
                listGHS.append(prod[i + 3])
        self.listGHS = ModifListDanger(listGHS)


class Tableau:
    def __init__(self, container, NLine, NCol, ListLabelCol, LabelWidth, Font1, Font2, MainAppli):
        self.MainAppli = MainAppli
        self.NLine = NLine
        self.NCol = NCol
        self.FrameTableur = tk.Frame(container)
        container.create_window(int(int(container['width']) * 0.5),
                                int(int(container['height']) * 0.513), anchor=tk.CENTER,
                                window=self.FrameTableur)
        self.scrollable_canvas = ScrollableCanvas(self.FrameTableur, int(int(container['width']) * 0.965),
                                                  int(int(container['height']) * 0.945))
        self.scrollable_canvas.grid(row=1, column=1)

        self.TabLabelNCol = []
        self.TabLabels = []

        for r in range(NLine):
            self.TabLabelCol = []
            for i in range(NCol):
                self.TabLabelNCol.append(
                    tk.Label(self.scrollable_canvas.interior, text='', relief=tk.RIDGE,
                             width=int(int(container['width']) * LabelWidth[i]), height=2, bg='white', font=Font1))
                self.TabLabelNCol[i].grid(row=0, column=i)
                self.TabLabelCol.append(tk.Label(self.scrollable_canvas.interior, text='', relief=tk.RIDGE,
                                                 width=int(int(container['width']) * LabelWidth[i]), bg='white',
                                                 font=Font2))
                self.TabLabelCol[i].grid(row=r + 1, column=i)
                self.TabLabelNCol[i]['text'] = ListLabelCol[i]

            self.TabLabels.append(self.TabLabelCol)

        for r in range(NLine):
            for i in range(NCol):
                def GestEvt(evt, j=r):
                    return self.SelectLine(evt, j)

                self.TabLabels[r][i].bind('<ButtonRelease-1>', GestEvt)
                ChangeCursor(self.TabLabels[r][i])

    def SelectLine(self, _, j):
        self.ActionUnSelect()
        for i in range(self.NCol):
            self.TabLabels[j][i].config(bg='#E0E0E0')
        try:
            self.MainAppli.AffichStock(j)
        except:
            pass

    def ActionUnSelect(self):
        for r in range(self.NLine):
            for i in range(self.NCol):
                self.TabLabels[r][i].config(bg='white')


class FrmTabRecap(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, MainTitre, Titre, Entete, AnScol, SizeFont, Nline, NCol,
                 WCel, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        coefY = float(ConfigResolution(self.MainAppli.MainAppli.Nconfig, 'YTitreFrm', self.MainAppli.MainAppli.curSave))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmTabRecap)

        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, MainTitre, '#E0E0E0',
                                      AppliFont('Helvetica', SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * coefY), tk.NW)

        self.CanvasMenu = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.995),
                                     int(self.SY * 0.965), int(self.SX * 0.003), int(self.SY * 0.031), tk.NW)

        LabelInCanvas(self.CanvasMenu.CanvasMenu, Titre, '#E0E0E0',
                      AppliFont('Helvetica', SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.004), tk.NW)

        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'Année scolaire ' + AnScol, '#E0E0E0',
                      AppliFont('Helvetica', SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.9),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.004), tk.NW)

        self.TabProd = Tableau(self.CanvasMenu.CanvasMenu, Nline, NCol, Entete, WCel,
                               AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                               AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)

        self.CanvasFrmFond.pack()

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.MainAppli.ImgCanvasBtnQuit,
                                                          image=self.MainAppli.MainAppli.ImgBtnQuit[0])

    def CacheFrmTabRecap(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.destroy()
        self.MainAppli.TabRecap = None
        self.MainAppli.MainAppli.parent.lift()
        self.MainAppli.MainAppli.FrmLift()
        self.MainAppli.lift()
