from AppliDef import *
from FrmAccueil import *


def Format(ch):
    Listch = ch.split("/")
    if len(Listch) > 5:
        ch = Listch[0] + '/' + Listch[1] + '/.../' + Listch[-3] + '/' + Listch[-2] + '/' + Listch[-1]
    return ch


def AffichMenuClicDroit2(event, MenuClicDroitTab, j):
    MenuClicDroitTab[j].post(event.x_root, event.y_root)


class FrmParam(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.LabelMenu = []
        self.MenuActif = 0
        self.ChoixSave = tk.IntVar()
        self.ChoixDTB = tk.IntVar()
        self.ChoixEtab = tk.IntVar()
        self.ChoixService = tk.IntVar()
        self.ChoixLogo = tk.IntVar()
        self.SaveChoix = None
        self.DTBChoix = None
        self.CanvasPathSave = None
        self.CheminSave = ''
        self.CheminFile = ''
        self.CanvasFileDTB = None
        self.BtnNewDTB = None
        self.BtnSaveDTB = None
        self.CanvasPath = None
        self.BtnRestore = None
        self.BtnOK = None
        self.BtnAnnul = None
        self.CheminFileNewDTB = ''
        self.CheminFileSaveDTB = ''
        self.ListSaves = []
        self.MaxSavesListe = [5, 10, 15, 20]
        self.MaxSaves = tk.IntVar()
        self.CanvasListSaves = None
        self.BtnSavePonct = None
        self.ListMaxSaves = None
        self.TabSaves = None
        self.CheminFileRestoreDTB = ''
        self.NDTBSelect = 0
        self.ListModifs, self.ListModif = [], []
        self.MenuClicDroitTab = []
        self.MenuClicDroitTab2 = []
        self.CanvasBarre = None
        self.BtnQuit = None
        self.TabModifs = None
        self.ModifEnCours = False
        self.EtabChoix, self.CanvasEtab, = None, None
        self.ServiceChoix, self.CanvasService = None, None
        self.LabelLieuxMat = []
        self.ListEntryLieux = [None, None, None]
        self.CanvasContLogo, self.LogoChoix, self.CanvasLogo = None, None, None
        self.ImgLogo = []
        self.ImgCanvasContLogo = None
        self.PathFilejpgToOpen = ''
        self.CanvasAdresse, self.CanvasTel, self.CanvasEmail = None, None, None
        self.LogoPath = ''
        self.BtnAjoutClasse, self.ScrollbarListBoxV, self.ListBoxClasses = None, None, None
        self.CanvasListBox, self.ScrollbarListBoxH = None, None
        self.ListClasses = []
        self.EntryClasse = None
        self.BtnSupClasse = None
        self.IndexClasse = 0
        self.CanvasMenuAjoutClasse, self.BtnPoubClasse = None, None
        self.BtnOKClasse, self.BtnAnnulClasse = None, None
        self.CoefSecuProd, self.CoefSecuMat, self.EntrySecuProd, self.TVA = None, None, None, None
        self.EntrySecuMat, self.EntryTVA = None, None
        self.MenuClicDroitNoLogo, self.MenuClicDroitLogo = None, None

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmParam/Fond/Fond.bmp')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX * 1.2)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY * 1.1)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmParam/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.5 - self.SX / 2))
                      + "+" + str(int(screen.GetSystemMetrics(1) * 0.5 - self.SY / 2)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)

        self.ImgBtnQuit, wsize, hsize, self.CanvasBtnQuit, self.ImgCanvasBtnQuit = CanInWindow(
            'Media/FrmParam/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER, int(self.SX * 0.983),
            int(self.SY * 0.018), 0)
        ChangeCursor(self.CanvasBtnQuit)
        self.CanvasBtnQuit.bind('<Motion>',
                                lambda action: self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit,
                                                                             image=self.ImgBtnQuit[1]))
        self.CanvasBtnQuit.bind('<ButtonRelease-1>', self.Quitter)

        if self.MainAppli.BaseEnCours == 'CHIMIE':
            self.TypeBDD = 'Chimie'
            self.DTBPath = self.MainAppli.DTBChimiePath
        else:
            self.TypeBDD = 'Physique'
            self.DTBPath = self.MainAppli.DTBPhysPath

        self.CanvasFrmFond.create_text(
            int(self.SX * 0.01), int(self.SY * 0.021), text='Paramètres - Base de données - ' + self.TypeBDD,
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'bold', 0), anchor=tk.W)

        self.LabelMenu.append(LabelInCanvas(self.CanvasFrmFond, 'Sauvegardes', '#E0E0E0',
                                            AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                            int(self.SX * 0.05), int(self.SY * 0.15), tk.NW))
        self.LabelMenu.append(LabelInCanvas(self.CanvasFrmFond, 'Personnalisation', '#E0E0E0',
                                            AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                            int(self.SX * 0.05), int(self.SY * 0.19), tk.NW))
        self.LabelMenu.append(LabelInCanvas(self.CanvasFrmFond, 'Options', '#E0E0E0',
                                            AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                            int(self.SX * 0.05), int(self.SY * 0.23), tk.NW))
        self.LabelMenu.append(LabelInCanvas(self.CanvasFrmFond, 'Rétablir par défaut', '#E0E0E0',
                                            AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                            int(self.SX * 0.05), int(self.SY * 0.9), tk.NW))

        for i in range(len(self.LabelMenu)):
            self.LabelMenu[i].Label.config(width=int(self.SX * 0.02))

            def GestEvt(_, j=i):
                return self.MoveLabel(j)

            def GestEvt2(_, j=i):
                return self.ClicLabel(j)

            self.LabelMenu[i].Label.bind('<Motion>', GestEvt)
            self.LabelMenu[i].Label.bind('<ButtonPress-1>', GestEvt2)
            ChangeCursor(self.LabelMenu[i].Label)

        self.CanvasMenu = CanvasMenu(self.CanvasFrmFond, 'Media/FrmParam/Menu/', int(self.SX * 0.62),
                                     int(self.SY * 0.88), int(self.SX * 0.33), int(self.SY * 0.08), tk.NW)
        self.CanvasMenu.CanvasMenu.bind('<Motion>', self.MoveOnCanvasMenu)

        self.AffichMenuSave()

        self.LabelMenu[self.MenuActif].Label.config(bg='#3FAFDF')
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.pack()

    def MoveLabel(self, j):
        for i in range(len(self.LabelMenu)):
            if i != self.MenuActif:
                self.LabelMenu[i].Label.config(bg='#E0E0E0')

        if j != self.MenuActif:
            self.LabelMenu[j].Label.config(bg='#A9A9A9')

    def ClicLabel(self, j):
        ListMenu = ['Sauvegardes', 'Personnalisation', 'Options']
        for i in range(len(self.LabelMenu)):
            self.LabelMenu[i].Label.config(bg='#E0E0E0')

        if j == 0 and self.MenuActif != 0:
            self.LabelMenu[j].Label.config(bg='#3FAFDF')
            if not self.ModifEnCours:
                self.MenuActif = j
                self.AffichMenuSave()
            else:
                Rep = tkMB.askyesno('Annuler les changements du menu "' + ListMenu[self.MenuActif] + '" ?',
                                    'Les changements de paramètres en cours ne seront pas validés si vous quitter '
                                    'ce menu, souhaitez-vous continuer?', parent=self)
                if Rep:
                    self.MenuActif = j
                    self.AffichMenuSave()
                else:
                    for i in range(len(self.LabelMenu)):
                        if i != self.MenuActif:
                            self.LabelMenu[i].Label.config(bg='#E0E0E0')
                        else:
                            self.LabelMenu[i].Label.config(bg='#3FAFDF')
        elif j == 1 and self.MenuActif != 1 and not self.TabModifs:
            self.LabelMenu[j].Label.config(bg='#3FAFDF')
            if not self.ModifEnCours:
                self.MenuActif = j
                self.AffichMenuPerso()
            else:
                Rep = tkMB.askyesno('Annuler les changements du menu "' + ListMenu[self.MenuActif] + '" ?',
                                    'Les changements de paramètres en cours ne seront pas validés si vous quitter '
                                    'ce menu, souhaitez-vous continuer?', parent=self)
                if Rep:
                    self.MenuActif = j
                    self.AffichMenuPerso()
                else:
                    for i in range(len(self.LabelMenu)):
                        if i != self.MenuActif:
                            self.LabelMenu[i].Label.config(bg='#E0E0E0')
                        else:
                            self.LabelMenu[i].Label.config(bg='#3FAFDF')
        elif j == 2 and self.MenuActif != 2 and not self.TabModifs:
            self.LabelMenu[j].Label.config(bg='#3FAFDF')
            if not self.ModifEnCours:
                self.MenuActif = j
                self.AffichMenuOptions()
            else:
                Rep = tkMB.askyesno('Annuler les changements du menu "' + ListMenu[self.MenuActif] + '" ?',
                                    'Les changements de paramètres en cours ne seront pas validés si vous quitter '
                                    'ce menu, souhaitez-vous continuer?', parent=self)
                if Rep:
                    self.MenuActif = j
                    self.AffichMenuOptions()
                else:
                    for i in range(len(self.LabelMenu)):
                        if i != self.MenuActif:
                            self.LabelMenu[i].Label.config(bg='#E0E0E0')
                        else:
                            self.LabelMenu[i].Label.config(bg='#3FAFDF')
        elif j == 3 and not self.TabModifs:
            self.LabelMenu[3].Label.bind('<ButtonRelease-1>', self.Defaut)
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)
            self.LabelMenu[self.MenuActif].Label.config(bg='#3FAFDF')
            if j != self.MenuActif:
                self.LabelMenu[j].Label.config(bg='#A9A9A9')

    def Defaut(self, _):
        if self.MenuActif == 0:
            self.ChoixSave.set(self.MainAppli.ListParam[0][3])
            self.ChoixDTB.set(self.MainAppli.ListParam[0][4])
            self.CanvasPathSave.LabelPath.Label['text'] = Format(self.MainAppli.ListParam[0][5])
            self.CheminSave = self.MainAppli.ListParam[0][5]
            self.MaxSaves.set(self.MainAppli.ListParam[0][6])
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                self.CanvasFileDTB.LabelPath.Label['text'] = Format(self.MainAppli.ListParam[0][1])
                self.CheminFile = self.MainAppli.ListParam[0][1]
            else:
                self.CanvasFileDTB.LabelPath.Label['text'] = Format(self.MainAppli.ListParam[0][2])
                self.CheminFile = self.MainAppli.ListParam[0][2]
            self.LabelMenu[3].Label.config(bg='#A9A9A9')
            self.LabelMenu[0].Label.config(bg='#3FAFDF')
            self.MenuActif = 0
            self.ModifEnCours = True
        elif self.MenuActif == 2:
            self.ChoixEtab.set(self.MainAppli.ListParam[0][9])
            self.ChoixService.set(self.MainAppli.ListParam[0][10])
            self.ChoixLogo.set(self.MainAppli.ListParam[0][18])
            self.CanvasEtab.LabelEntry.Label['text'] = self.MainAppli.ListParam[0][7]
            self.CanvasEtab.ModifText(_)
            self.CanvasAdresse.LabelEntry.Label['text'] = self.MainAppli.ListParam[0][19]
            self.CanvasAdresse.ModifText(_)
            self.CanvasTel.LabelEntry.Label['text'] = self.MainAppli.ListParam[0][20]
            self.CanvasTel.ModifText(_)
            self.CanvasEmail.LabelEntry.Label['text'] = self.MainAppli.ListParam[0][21]
            self.CanvasEmail.ModifText(_)
            self.CanvasService.LabelEntry.Label['text'] = self.MainAppli.ListParam[0][8]
            self.CanvasService.ModifText(_)

            if self.MainAppli.ListParam[0][17] != '':
                self.AffichLogo(self.MainAppli.ListParam[0][17])
            else:
                self.LogoPath = ''
                if self.CanvasContLogo is not None:
                    self.CanvasContLogo.destroy()
                    self.CanvasContLogo = None
                if self.CanvasLogo is not None:
                    self.CanvasLogo.CanvasListIma.destroy()
                    self.CanvasLogo = None
                self.CanvasLogo = CanvasInWindow('Media/FrmAjout/NoVisuel/', self.RatioX * 0.8, self.RatioY * 0.8,
                                                 self.CanvasMenu.CanvasMenu, tk.CENTER,
                                                 int(int(self.CanvasMenu.CanvasMenu['width']) * 0.5),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.63), 0)

                ChangeCursor(self.CanvasLogo.CanvasListIma)
                self.CanvasLogo.CanvasListIma.bind('<ButtonRelease-1>', self.ChargeLogo)

            self.LabelMenu[3].Label.config(bg='#A9A9A9')
            self.LabelMenu[2].Label.config(bg='#3FAFDF')
            self.MenuActif = 2
            self.ModifEnCours = True
        elif self.MenuActif == 1:
            for i in range(3):
                if self.TypeBDD == 'Chimie':
                    self.LabelLieuxMat[i].Label['text'] = self.MainAppli.ListParam[0][11 + i]
                else:
                    self.LabelLieuxMat[i].Label['text'] = self.MainAppli.ListParam[0][14 + i]
                self.ModifLieux(_, i)

            self.ListClasses = self.MainAppli.ListParam[0][22].split(',')
            self.ListBoxClasses.delete(0, tk.END)
            for i in range(len(self.ListClasses)):
                self.ListBoxClasses.insert(tk.END, self.ListClasses[i])
            self.ListBoxClasses.selection_set(0)

            if self.TypeBDD == 'Chimie':
                self.CoefSecuProd.Label['text'] = self.MainAppli.ListParam[0][23]
                self.ModifSecuProd(_)
            self.CoefSecuMat.Label['text'] = self.MainAppli.ListParam[0][24]
            self.ModifSecuMat(_)
            self.TVA.Label['text'] = self.MainAppli.ListParam[0][25]
            self.ModifTVA(_)

            self.LabelMenu[3].Label.config(bg='#A9A9A9')
            self.LabelMenu[1].Label.config(bg='#3FAFDF')
            self.MenuActif = 1
            self.ModifEnCours = True

    def AffichMenuOptions(self):
        self.ModifEnCours = False
        self.EffaceMenu()
        self.EtabChoix = CaseACocher(self.CanvasMenu.CanvasMenu, "Affichage du nom de l'établissement:",
                                     font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                     variable=self.ChoixEtab, bg='#F7F7F7', justify='left', command=self.ModifChoix)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.08),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04), anchor=tk.NW,
                                                 window=self.EtabChoix)
        self.ChoixEtab.set(self.MainAppli.AffichEtab)
        self.CanvasEtab = CanvasEntry(self.CanvasMenu.CanvasMenu, int(int(self.CanvasMenu.CanvasMenu['width']) * 0.88),
                                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04),
                                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.08),
                                      self.MainAppli.Etab[0], self)
        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'Adresse:', '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.138), tk.NW)
        self.CanvasAdresse = CanvasEntry(self.CanvasMenu.CanvasMenu,
                                         int(int(self.CanvasMenu.CanvasMenu['width']) * 0.769),
                                         int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04),
                                         int(int(self.CanvasMenu.CanvasMenu['width']) * 0.17),
                                         int(int(self.CanvasMenu.CanvasMenu['height']) * 0.133),
                                         self.MainAppli.Etab[1], self)
        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'Tel:', '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.186), tk.NW)
        self.CanvasTel = CanvasEntry(self.CanvasMenu.CanvasMenu,
                                     int(int(self.CanvasMenu.CanvasMenu['width']) * 0.769),
                                     int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04),
                                     int(int(self.CanvasMenu.CanvasMenu['width']) * 0.17),
                                     int(int(self.CanvasMenu.CanvasMenu['height']) * 0.181),
                                     self.MainAppli.Etab[2], self)
        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'E-mail:', '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.234), tk.NW)
        self.CanvasEmail = CanvasEntry(self.CanvasMenu.CanvasMenu,
                                       int(int(self.CanvasMenu.CanvasMenu['width']) * 0.769),
                                       int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04),
                                       int(int(self.CanvasMenu.CanvasMenu['width']) * 0.17),
                                       int(int(self.CanvasMenu.CanvasMenu['height']) * 0.229),
                                       self.MainAppli.Etab[3], self)

        self.ServiceChoix = CaseACocher(
            self.CanvasMenu.CanvasMenu, "Affichage du nom du service au sein de l'établissement:",
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
            variable=self.ChoixService, bg='#F7F7F7', justify='left', command=self.ModifChoix)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.08),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.33), anchor=tk.NW,
                                                 window=self.ServiceChoix)
        self.ChoixService.set(self.MainAppli.AffichService)
        self.CanvasService = CanvasEntry(self.CanvasMenu.CanvasMenu,
                                         int(int(self.CanvasMenu.CanvasMenu['width']) * 0.88),
                                         int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04),
                                         int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                                         int(int(self.CanvasMenu.CanvasMenu['height']) * 0.37), self.MainAppli.Service,
                                         self)

        self.LogoChoix = CaseACocher(self.CanvasMenu.CanvasMenu, "Affichage du logo de l'établissement:",
                                     font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                     variable=self.ChoixLogo, bg='#F7F7F7', justify='left', command=self.ModifChoix)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.08),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.47), anchor=tk.NW,
                                                 window=self.LogoChoix)
        self.ChoixLogo.set(self.MainAppli.AffichLogo)

        if self.MainAppli.LogoPath != '':
            self.AffichLogo(self.MainAppli.LogoPath)
        else:
            self.LogoPath = ''
            self.CanvasLogo = CanvasInWindow('Media/FrmAjout/NoVisuel/', self.RatioX * 0.8, self.RatioY * 0.8,
                                             self.CanvasMenu.CanvasMenu, tk.CENTER,
                                             int(int(self.CanvasMenu.CanvasMenu['width']) * 0.5),
                                             int(int(self.CanvasMenu.CanvasMenu['height']) * 0.63), 0)
            self.MenuClicDroitNoLogo = tk.Menu(self.CanvasLogo.CanvasListIma, tearoff=0)
            self.MenuClicDroitNoLogo.add_command(label="Recherche internet", command=self.ChercheWeb)
            self.MenuClicDroitNoLogo.add_separator()
            self.MenuClicDroitNoLogo.add_command(label="Coller une image", command=self.ColleLogo)
            self.CanvasLogo.CanvasListIma.bind("<Button-3>", self.AffichMenuClicDroitNoLogo)

            ChangeCursor(self.CanvasLogo.CanvasListIma)
            self.CanvasLogo.CanvasListIma.bind('<ButtonRelease-1>', self.ChargeLogo)

        self.BtnOK = BtnAction(self.CanvasMenu.CanvasMenu, int(int(self.CanvasMenu.CanvasMenu['width']) * 0.85),
                               int(int(self.CanvasMenu.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                               self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnAnnul = BtnAction(self.CanvasMenu.CanvasMenu, int(int(self.CanvasMenu.CanvasMenu['width']) * 0.93),
                                  int(int(self.CanvasMenu.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                  self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.Quitter)
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidParaOptions)

    def AffichLogo(self, File):
        self.LogoPath = File
        self.ImgLogo = []
        img = Image.open(File)
        imgEtiqwsize = int(int(self.CanvasMenu.CanvasMenu['width']) * 0.35)
        imgEtiqhsize = int(imgEtiqwsize * float(img.size[1]) / float(img.size[0]))
        if imgEtiqhsize > int(self.CanvasMenu.CanvasMenu['height']) * 0.25:
            imgEtiqhsize = int(int(self.CanvasMenu.CanvasMenu['height']) * 0.25)
            imgEtiqwsize = int(imgEtiqhsize * float(img.size[0]) / float(img.size[1]))
        img = img.resize((imgEtiqwsize, imgEtiqhsize), Image.ANTIALIAS)
        self.ImgLogo.append(ImageTk.PhotoImage(img))

        if self.CanvasContLogo is not None:
            self.CanvasContLogo.destroy()
            self.CanvasContLogo = None
        if self.CanvasLogo is not None:
            self.CanvasLogo.CanvasListIma.destroy()
            self.CanvasLogo = None
        self.CanvasContLogo = CanvasApp(self.CanvasMenu.CanvasMenu, width=imgEtiqwsize, height=imgEtiqhsize)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.5),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.63),
                                                 anchor=tk.CENTER,
                                                 window=self.CanvasContLogo)
        self.ImgCanvasContLogo = self.CanvasContLogo.create_image(0, 0, anchor=tk.NW, image=self.ImgLogo[0])

        ChangeCursor(self.CanvasContLogo)
        self.CanvasContLogo.bind('<ButtonRelease-1>', self.ChargeLogo)
        self.MenuClicDroitLogo = tk.Menu(self.CanvasContLogo, tearoff=0)
        self.MenuClicDroitLogo.add_command(label="Effacer", command=self.EffacerLogo)
        self.CanvasContLogo.bind("<Button-3>", self.AffichMenuClicDroitLogo)

    def AffichMenuClicDroitLogo(self, event):
        self.MenuClicDroitLogo.post(event.x_root, event.y_root)

    def AffichMenuClicDroitNoLogo(self, event):
        self.MenuClicDroitNoLogo.post(event.x_root, event.y_root)

    def EffacerLogo(self):
        self.CanvasContLogo.destroy()
        self.LogoPath = ''
        self.CanvasLogo = CanvasInWindow('Media/FrmAjout/NoVisuel/', self.RatioX * 0.8, self.RatioY * 0.8,
                                         self.CanvasMenu.CanvasMenu, tk.CENTER,
                                         int(int(self.CanvasMenu.CanvasMenu['width']) * 0.5),
                                         int(int(self.CanvasMenu.CanvasMenu['height']) * 0.63), 0)

        self.MenuClicDroitNoLogo = tk.Menu(self.CanvasLogo.CanvasListIma, tearoff=0)
        self.MenuClicDroitNoLogo.add_command(label="Recherche internet", command=self.ChercheWeb)
        self.MenuClicDroitNoLogo.add_separator()
        self.MenuClicDroitNoLogo.add_command(label="Coller une image", command=self.ColleLogo)
        self.CanvasLogo.CanvasListIma.bind("<Button-3>", self.AffichMenuClicDroitNoLogo)

        ChangeCursor(self.CanvasLogo.CanvasListIma)
        self.CanvasLogo.CanvasListIma.bind('<ButtonRelease-1>', self.ChargeLogo)

    def ChercheWeb(self):
        webbrowser.open('https://www.google.fr/search?q=' + 'Logo' + ' - ' +
                        self.CanvasEtab.LabelEntry.Label['text'], new=1)

    def ColleLogo(self):
        img = ImageGrab.grabclipboard()
        if img is not None:
            self.PathFilejpgToOpen = 'Datas/Temp/Visuel.png'
            img.save(self.PathFilejpgToOpen)
            self.AffichLogo(self.PathFilejpgToOpen)

    def ChargeLogo(self, _):
        self.PathFilejpgToOpen = ''
        self.PathFilejpgToOpen = tkfiledialog.askopenfilename(title="Ouvrir un fichier",
                                                              filetypes=[('JPG files', '*.*')], parent=self)
        if self.PathFilejpgToOpen != '':
            self.AffichLogo(self.PathFilejpgToOpen)
            self.ModifEnCours = True

        self.lift()

    def ModifLieux(self, _, j):
        self.ListEntryLieux[j] = tk.Entry(self.CanvasMenu.CanvasMenu, text='',
                                          width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.055),
                                          font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                          justify='center')
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.1),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.1 +
                                                     j * int(self.CanvasMenu.CanvasMenu['height']) * 0.05),
                                                 anchor=tk.NW, window=self.ListEntryLieux[j])
        self.ListEntryLieux[j].insert(0, self.LabelLieuxMat[j].Label['text'])
        self.ListEntryLieux[j].focus_set()
        self.ModifEnCours = True

    def AffichMenuSave(self):
        self.ModifEnCours = False
        self.EffaceMenu()
        self.DTBChoix = CaseACocher(self.CanvasMenu.CanvasMenu, 'Chargement automatique de la base de données de ' +
                                    self.TypeBDD + '\nau démarrage:', command=self.ModifChoix,
                                    font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                    variable=self.ChoixDTB, bg='#F7F7F7', justify='left')
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.08),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04), anchor=tk.NW,
                                                 window=self.DTBChoix)
        self.ChoixDTB.set(self.MainAppli.AutoLoad)

        self.CanvasFileDTB = CanvasFileDialog(self.CanvasMenu.CanvasMenu, self.RatioX, self.RatioY,
                                              int(int(self.CanvasMenu.CanvasMenu['width']) * 0.88),
                                              int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04),
                                              int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                                              int(int(self.CanvasMenu.CanvasMenu['height']) * 0.105),
                                              Format(self.DTBPath), 'Fichier', self)

        self.BtnNewDTB = tk.Button(self.CanvasMenu.CanvasMenu, text='Nouvelle base de données', command=self.NewDTB)

        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.6),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.165), anchor=tk.NW,
                                                 window=self.BtnNewDTB)
        ChangeCursor(self.BtnNewDTB)

        self.BtnSaveDTB = tk.Button(self.CanvasMenu.CanvasMenu, text='Enregistrer sous', command=self.SaveDTB)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.4),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.165), anchor=tk.NW,
                                                 window=self.BtnSaveDTB)
        ChangeCursor(self.BtnSaveDTB)

        self.SaveChoix = CaseACocher(self.CanvasMenu.CanvasMenu, 'Sauvegarder la base de données de ' + self.TypeBDD +
                                     ' au démarrage', command=self.ModifChoix,
                                     font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                     variable=self.ChoixSave, bg='#F7F7F7', justify='left')
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.08),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.235), anchor=tk.NW,
                                                 window=self.SaveChoix)
        self.ChoixSave.set(self.MainAppli.AutoSave)

        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'Dossier des sauvegardes:', '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.12),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.27), tk.NW)
        self.CanvasPathSave = CanvasFileDialog(self.CanvasMenu.CanvasMenu, self.RatioX, self.RatioY,
                                               int(int(self.CanvasMenu.CanvasMenu['width']) * 0.88),
                                               int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04),
                                               int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                                               int(int(self.CanvasMenu.CanvasMenu['height']) * 0.3),
                                               Format(self.MainAppli.AutoSavePath), 'Dossier', self)

        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'Liste des sauvegardes:', '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.12),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.35), tk.NW)
        self.CanvasListSaves = CanvasMenu(self.CanvasMenu.CanvasMenu, 'Media/FrmParam/SaveList/',
                                          int(int(self.CanvasMenu.CanvasMenu['width']) * 0.88),
                                          int(int(self.CanvasMenu.CanvasMenu['height']) * 0.4),
                                          int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                                          int(int(self.CanvasMenu.CanvasMenu['height']) * 0.38), tk.NW)

        self.BtnSavePonct = tk.Button(self.CanvasMenu.CanvasMenu, text='Sauvegarder la base de données',
                                      command=self.SavePonctDTB)
        ChangeCursor(self.BtnSavePonct)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.6),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.8), anchor=tk.NW,
                                                 window=self.BtnSavePonct)

        self.BtnRestore = tk.Button(self.CanvasMenu.CanvasMenu, text='Restaurer la base de données',
                                    state='disabled', command=self.RestoreDTB)
        ChangeCursor(self.BtnRestore)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.6),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.85), anchor=tk.NW,
                                                 window=self.BtnRestore)
        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'Maximum de sauvegardes:', '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.12),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.815), tk.W)

        self.MaxSaves.set(self.MainAppli.MaxSaves)
        self.ListMaxSaves = ListeDeroulante(self.CanvasMenu.CanvasMenu,
                                            int(int(self.CanvasMenu.CanvasMenu['width']) * 0.005),
                                            textvariable=self.MaxSaves, values=self.MaxSavesListe)
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.42),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.815),
                                                 anchor=tk.W, window=self.ListMaxSaves)
        self.ListMaxSaves.focus_set()

        self.ChargeListSaves()

        self.BtnOK = BtnAction(self.CanvasMenu.CanvasMenu, int(int(self.CanvasMenu.CanvasMenu['width']) * 0.85),
                               int(int(self.CanvasMenu.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                               self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnAnnul = BtnAction(self.CanvasMenu.CanvasMenu, int(int(self.CanvasMenu.CanvasMenu['width']) * 0.93),
                                  int(int(self.CanvasMenu.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                  self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.Quitter)
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidPara)

    def AffichMenuPerso(self):
        self.ModifEnCours = False
        self.EffaceMenu()
        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'Lieux de stockage du matériel:', '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 1),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.04), tk.NW)

        self.LabelLieuxMat = []
        for i in range(3):
            if self.TypeBDD == 'Chimie':
                Lieux = self.MainAppli.LieuxStockMatChim[i]
            else:
                Lieux = self.MainAppli.LieuxStockMatPhys[i]
            self.LabelLieuxMat.append(LabelInCanvas(self.CanvasMenu.CanvasMenu, Lieux, '#E0E0E0',
                                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'normal', 0),
                                                    int(int(self.CanvasMenu.CanvasMenu['width']) * 0.1),
                                                    int(int(self.CanvasMenu.CanvasMenu['height']) * 0.1 +
                                                        i * int(self.CanvasMenu.CanvasMenu['height']) * 0.05), tk.NW))
            self.LabelLieuxMat[i].Label.config(width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.05))
            ChangeCursor(self.LabelLieuxMat[i].Label)

            def GestEvt(evt, j=i):
                return self.ModifLieux(evt, j)

            self.LabelLieuxMat[i].Label.bind('<Double-1>', GestEvt)

        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'Liste des classes:', '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 1),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.28), tk.NW)

        self.CanvasListBox = CanvasApp(self.CanvasMenu.CanvasMenu, bg='white')
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.1),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.33), anchor=tk.NW,
                                                 window=self.CanvasListBox)
        self.ScrollbarListBoxV = tk.Scrollbar(self.CanvasListBox)
        self.ScrollbarListBoxV.pack(side=tk.RIGHT, fill=tk.Y)
        self.ListBoxClasses = tk.Listbox(self.CanvasListBox,
                                         width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.068),
                                         height=int(int(self.CanvasMenu.CanvasMenu['height']) * 0.01),
                                         activestyle='none')
        self.ListBoxClasses.bind('<<ListboxSelect>>', self.OnSelectListBox)

        self.ListBoxClasses.config(yscrollcommand=self.ScrollbarListBoxV.set)
        self.ScrollbarListBoxV.config(command=self.ListBoxClasses.yview)

        self.ScrollbarListBoxH = tk.Scrollbar(self.CanvasListBox, orient=tk.HORIZONTAL)
        self.ScrollbarListBoxH.pack(side=tk.BOTTOM, fill=tk.X)
        self.ListBoxClasses.config(xscrollcommand=self.ScrollbarListBoxH.set)
        self.ScrollbarListBoxH.config(command=self.ListBoxClasses.xview)

        self.ListBoxClasses.pack()

        self.ListClasses = []
        self.ListBoxClasses.delete(0, tk.END)
        for i in range(len(self.MainAppli.ListClasses)):
            self.ListBoxClasses.insert(tk.END, self.MainAppli.ListClasses[i])
            self.ListClasses.append(self.MainAppli.ListClasses[i])
        self.ListBoxClasses.selection_set(0)
        self.BtnAjoutClasse = BtnAction(self.CanvasMenu.CanvasMenu,
                                        int(int(self.CanvasMenu.CanvasMenu['width']) * 0.565),
                                        int(int(self.CanvasMenu.CanvasMenu['height']) * 0.345), self.RatioX,
                                        self.RatioX, 'Media/FrmParam/BtnPlus/')
        self.BtnAjoutClasse.CanvasBtn.bind('<Motion>', self.MoveInBtnAjoutClasse)
        self.BtnAjoutClasse.CanvasBtn.bind('<ButtonRelease-1>', self.AjoutClasse)

        self.BtnSupClasse = BtnAction(self.CanvasMenu.CanvasMenu,
                                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.565),
                                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.375), self.RatioX,
                                      self.RatioX, 'Media/FrmParam/BtnMoins/')
        self.BtnSupClasse.CanvasBtn.bind('<Motion>', self.MoveInBtnSupClasse)
        self.BtnSupClasse.CanvasBtn.bind('<ButtonRelease-1>', self.SupClasse)

        self.BtnPoubClasse = BtnAction(self.CanvasMenu.CanvasMenu,
                                       int(int(self.CanvasMenu.CanvasMenu['width']) * 0.565),
                                       int(int(self.CanvasMenu.CanvasMenu['height']) * 0.405), self.RatioX,
                                       self.RatioX, 'Media/FrmParam/BtnPoub/')
        self.BtnPoubClasse.CanvasBtn.bind('<Motion>', self.MoveInBtnPoubClasse)
        self.BtnPoubClasse.CanvasBtn.bind('<ButtonRelease-1>', self.PoubClasse)

        LabelInCanvas(self.CanvasMenu.CanvasMenu, 'Paramètres des commandes:', '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 1),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.56), tk.NW)

        if self.TypeBDD == 'Chimie':
            LabelInCanvas(self.CanvasMenu.CanvasMenu, '- Coefficient de sécurité du stock de produits chimiques:',
                          '#F7F7F7', AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                          int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                          int(int(self.CanvasMenu.CanvasMenu['height']) * 0.61), tk.NW)
            self.CoefSecuProd = LabelInCanvas(self.CanvasMenu.CanvasMenu, self.MainAppli.CoeffSecuProd, '#E0E0E0',
                                              AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                              int(int(self.CanvasMenu.CanvasMenu['width']) * 0.72),
                                              int(int(self.CanvasMenu.CanvasMenu['height']) * 0.61), tk.NW)
            self.CoefSecuProd.Label.config(width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.025))
            ChangeCursor(self.CoefSecuProd.Label)
            self.CoefSecuProd.Label.bind('<Double-1>', self.ModifSecuProd)
            Title = '- Coefficient de sécurité du stock de matériels de chimie:'
            YTVA = 0.71
        else:
            Title = '- Coefficient de sécurité du stock de matériels de physique:'
            YTVA = 0.66
        LabelInCanvas(self.CanvasMenu.CanvasMenu, Title, '#F7F7F7',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * (YTVA - 0.05)), tk.NW)
        self.CoefSecuMat = LabelInCanvas(self.CanvasMenu.CanvasMenu, self.MainAppli.CoeffSecuMat, '#E0E0E0',
                                         AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                         int(int(self.CanvasMenu.CanvasMenu['width']) * 0.72),
                                         int(int(self.CanvasMenu.CanvasMenu['height']) * (YTVA - 0.05)), tk.NW)
        self.CoefSecuMat.Label.config(width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.025))
        ChangeCursor(self.CoefSecuMat.Label)
        self.CoefSecuMat.Label.bind('<Double-1>', self.ModifSecuMat)
        LabelInCanvas(self.CanvasMenu.CanvasMenu, '- TVA (%):',
                      '#F7F7F7', AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.06),
                      int(int(self.CanvasMenu.CanvasMenu['height']) * YTVA), tk.NW)
        self.TVA = LabelInCanvas(self.CanvasMenu.CanvasMenu, self.MainAppli.TVA, '#E0E0E0',
                                 AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                 int(int(self.CanvasMenu.CanvasMenu['width']) * 0.72),
                                 int(int(self.CanvasMenu.CanvasMenu['height']) * YTVA), tk.NW)
        self.TVA.Label.config(width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.025))
        ChangeCursor(self.TVA.Label)
        self.TVA.Label.bind('<Double-1>', self.ModifTVA)

        self.BtnOK = BtnAction(self.CanvasMenu.CanvasMenu, int(int(self.CanvasMenu.CanvasMenu['width']) * 0.85),
                               int(int(self.CanvasMenu.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                               self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnAnnul = BtnAction(self.CanvasMenu.CanvasMenu, int(int(self.CanvasMenu.CanvasMenu['width']) * 0.93),
                                  int(int(self.CanvasMenu.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                  self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.Quitter)
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidParaPerso)

    def ModifSecuProd(self, _):
        self.EntrySecuProd = tk.Entry(self.CanvasMenu.CanvasMenu, text='',
                                      width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.029),
                                      font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                      justify='center')
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.72),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * 0.61),
                                                 anchor=tk.NW, window=self.EntrySecuProd)
        self.EntrySecuProd.insert(0, self.CoefSecuProd.Label['text'])
        self.EntrySecuProd.focus_set()
        self.EntrySecuProd.bind('<KeyRelease>', self.ModifValProd)
        self.ModifEnCours = True

    def ModifValProd(self,_):
        try:
            float(self.EntrySecuProd.get().replace(',','.'))
        except:
            self.EntrySecuProd.delete(0,tk.END)

    def ModifValMat(self,_):
        try:
            float(self.EntrySecuMat.get().replace(',','.'))
        except:
            self.EntrySecuMat.delete(0,tk.END)

    def ModifValTVA(self,_):
        try:
            float(self.EntryTVA.get().replace(',','.'))
        except:
            self.EntryTVA.delete(0,tk.END)

    def ModifSecuMat(self, _):
        if self.TypeBDD == 'Chimie':
            Y = 0.66
        else:
            Y = 0.61
        self.EntrySecuMat = tk.Entry(self.CanvasMenu.CanvasMenu, text='',
                                     width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.029),
                                     font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                     justify='center')
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.72),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * Y),
                                                 anchor=tk.NW, window=self.EntrySecuMat)
        self.EntrySecuMat.insert(0, self.CoefSecuMat.Label['text'])
        self.EntrySecuMat.focus_set()
        self.EntrySecuMat.bind('<KeyRelease>', self.ModifValMat)
        self.ModifEnCours = True

    def ModifTVA(self, _):
        if self.TypeBDD == 'Chimie':
            Y = 0.71
        else:
            Y = 0.66
        self.EntryTVA = tk.Entry(self.CanvasMenu.CanvasMenu, text='',
                                 width=int(int(self.CanvasMenu.CanvasMenu['width']) * 0.029),
                                 font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                 justify='center')
        self.CanvasMenu.CanvasMenu.create_window(int(int(self.CanvasMenu.CanvasMenu['width']) * 0.72),
                                                 int(int(self.CanvasMenu.CanvasMenu['height']) * Y),
                                                 anchor=tk.NW, window=self.EntryTVA)
        self.EntryTVA.insert(0, self.TVA.Label['text'])
        self.EntryTVA.focus_set()
        self.EntryTVA.bind('<KeyRelease>', self.ModifValTVA)
        self.ModifEnCours = True

    def MoveInBtnPoubClasse(self, _):
        self.BtnSupClasse.CanvasBtn.itemconfig(self.BtnSupClasse.ImgCanvasBtn, image=self.BtnSupClasse.ImgBtn[0])
        self.BtnPoubClasse.CanvasBtn.itemconfig(self.BtnPoubClasse.ImgCanvasBtn, image=self.BtnPoubClasse.ImgBtn[2])

    def PoubClasse(self, _):
        if self.CanvasMenuAjoutClasse is None:
            self.ListBoxClasses.delete(0, tk.END)
            self.ListClasses = []
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)

    def MoveInBtnSupClasse(self, _):
        self.BtnAjoutClasse.CanvasBtn.itemconfig(self.BtnAjoutClasse.ImgCanvasBtn, image=self.BtnAjoutClasse.ImgBtn[0])
        self.BtnSupClasse.CanvasBtn.itemconfig(self.BtnSupClasse.ImgCanvasBtn, image=self.BtnSupClasse.ImgBtn[2])
        self.BtnPoubClasse.CanvasBtn.itemconfig(self.BtnPoubClasse.ImgCanvasBtn, image=self.BtnPoubClasse.ImgBtn[0])

    def SupClasse(self, _):
        if self.CanvasMenuAjoutClasse is None:
            del (self.ListClasses[self.IndexClasse])
            self.ListBoxClasses.delete(0, tk.END)
            for i in range(len(self.ListClasses)):
                self.ListBoxClasses.insert(tk.END, self.ListClasses[i])
            self.ListBoxClasses.selection_set(0)
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)

    def MoveInBtnAjoutClasse(self, _):
        self.BtnAjoutClasse.CanvasBtn.itemconfig(self.BtnAjoutClasse.ImgCanvasBtn, image=self.BtnAjoutClasse.ImgBtn[2])
        self.BtnSupClasse.CanvasBtn.itemconfig(self.BtnSupClasse.ImgCanvasBtn, image=self.BtnSupClasse.ImgBtn[0])

    def AjoutClasse(self, _):
        if self.CanvasMenuAjoutClasse is None:
            self.CanvasMenuAjoutClasse = CanvasMenu(self.CanvasMenu.CanvasMenu, 'Media/FrmParam/Menu/',
                                                    int(int(self.CanvasMenu.CanvasMenu['width']) * 0.35),
                                                    int(int(self.CanvasMenu.CanvasMenu['height']) * 0.18),
                                                    int(int(self.CanvasMenu.CanvasMenu['width']) * 0.6),
                                                    int(int(self.CanvasMenu.CanvasMenu['height']) * 0.33), tk.NW)
            LabelInCanvas(self.CanvasMenuAjoutClasse.CanvasMenu, 'Ajouter une classe:', '#F7F7F7',
                          AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 1),
                          int(int(self.CanvasMenuAjoutClasse.CanvasMenu['width']) * 0.06),
                          int(int(self.CanvasMenuAjoutClasse.CanvasMenu['height']) * 0.05), tk.NW)

            self.EntryClasse = tk.Entry(self.CanvasMenuAjoutClasse.CanvasMenu, text='',
                                        width=int(int(self.CanvasMenuAjoutClasse.CanvasMenu['width']) * 0.1),
                                        font=AppliFont('Helvetica', self.MainAppli.SizeFont + 1, 'normal', 0),
                                        justify='center')
            self.CanvasMenuAjoutClasse.CanvasMenu.create_window(
                int(int(self.CanvasMenuAjoutClasse.CanvasMenu['width']) * 0.1),
                int(int(self.CanvasMenuAjoutClasse.CanvasMenu['height']) * 0.4),
                anchor=tk.NW, window=self.EntryClasse)
            self.EntryClasse.focus_set()
            self.EntryClasse.bind('<Return>', self.ValidAjoutClasse)

            self.BtnOKClasse = BtnAction(self.CanvasMenuAjoutClasse.CanvasMenu,
                                         int(int(self.CanvasMenuAjoutClasse.CanvasMenu['width']) * 0.75),
                                         int(int(self.CanvasMenuAjoutClasse.CanvasMenu['height']) * 0.88),
                                         self.RatioX * 0.5, self.RatioX * 0.5, 'Media/FrmAjout/BtnOK2/')
            self.BtnAnnulClasse = BtnAction(self.CanvasMenuAjoutClasse.CanvasMenu,
                                            int(int(self.CanvasMenuAjoutClasse.CanvasMenu['width']) * 0.9),
                                            int(int(self.CanvasMenuAjoutClasse.CanvasMenu['height']) * 0.88),
                                            self.RatioX * 0.5, self.RatioX * 0.5, 'Media/FrmAjout/BtnAnnul2/')
            self.BtnAnnulClasse.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulAjoutClasse)
            self.BtnOKClasse.CanvasBtn.bind('<ButtonRelease-1>', self.ValidAjoutClasse)
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)

    def AnnulAjoutClasse(self, _):
        for widget in self.CanvasMenuAjoutClasse.CanvasMenu.winfo_children():
            widget.destroy()
        self.CanvasMenuAjoutClasse.CanvasMenu.destroy()
        self.CanvasMenuAjoutClasse = None

    def ValidAjoutClasse(self, _):
        self.BtnOKClasse.CanvasBtn.itemconfig(self.BtnOKClasse.ImgCanvasBtn, image=self.BtnOKClasse.ImgBtn[0])
        if self.EntryClasse.get() != '':
            self.ModifEnCours = True
            self.ListClasses.append(self.EntryClasse.get())
            self.ListBoxClasses.insert(tk.END, self.EntryClasse.get())
            self.ListBoxClasses.selection_set(0)
            self.AnnulAjoutClasse(_)
        else:
            tkMB.showwarning('Attention', "Veuillez indiquer le nom d'une classe!", parent=self)

    def ModifChoix(self):
        self.ModifEnCours = True

    def ChangeSavePath(self, _):
        self.CheminSave = tkfiledialog.askdirectory(parent=self, initialdir=self.MainAppli.AutoSavePath,
                                                    title="Selection d'un dossier de sauvegarde")
        if self.CheminSave != '':
            if self.CheminSave != os.getcwd().replace('\\', '/') + '/Datas/Backup':
                self.CanvasPathSave.LabelPath.Label['text'] = Format(self.CheminSave)
            else:
                self.CanvasPathSave.LabelPath.Label['text'] = 'Datas/Backup'
                self.CheminSave = 'Datas/Backup'
            self.ModifEnCours = True

    def ChangeFileDTB(self, _):
        self.CheminFile = tkfiledialog.askopenfilename(parent=self, initialdir='Datas/DTB',
                                                       filetypes=[('DTB files', '.sq3')],
                                                       title="Selection d'un fichier de base de données")
        if self.CheminFile != '':
            if os.path.dirname(self.CheminFile) != os.getcwd().replace('\\', '/') + '/Datas/DTB':
                self.CanvasFileDTB.LabelPath.Label['text'] = Format(self.CheminFile)
            else:
                self.CanvasFileDTB.LabelPath.Label['text'] = 'Datas/DTB/' + os.path.basename(self.CheminFile)
                self.CheminFile = 'Datas/DTB/' + os.path.basename(self.CheminFile)
            self.ModifEnCours = True

    def RestoreDTB(self):
        Rep = tkMB.askyesno('Restaurer une sauvegarde', 'Etes vous sûr de vouloir restaurer la sauvegarde "' +
                            self.ListSaves[self.NDTBSelect][2].split('/')[-1] + '" de la base de données?', parent=self)
        if Rep:
            self.CheminFileRestoreDTB = self.ListSaves[self.NDTBSelect][2]
            self.BtnRestore.config(state='disabled')
            self.ModifEnCours = True

    def SavePonctDTB(self):
        self.MainAppli.SaveDTB(self.DTBPath, self.TypeBDD)
        self.EffaceListSaves()
        self.ChargeListSaves()

    def NewDTB(self):
        self.CheminFileNewDTB = tkfiledialog.asksaveasfilename(
            parent=self, initialdir='Datas/DTB', filetypes=[('DTB files', '.sq3')],
            title="Enregistrer un nouveau fichier de base de données sous")
        if self.CheminFileNewDTB != '':
            if os.path.dirname(self.CheminFileNewDTB) != os.getcwd().replace('\\', '/') + '/Datas/DTB':
                self.CanvasFileDTB.LabelPath.Label['text'] = Format(self.CheminFileNewDTB)
            else:
                self.CanvasFileDTB.LabelPath.Label['text'] = 'Datas/DTB/' + os.path.basename(self.CheminFileNewDTB)
                self.CheminFileNewDTB = 'Datas/DTB/' + os.path.basename(self.CheminFileNewDTB)
            self.ModifEnCours = True

    def SaveDTB(self):
        self.CheminFileSaveDTB = tkfiledialog.asksaveasfilename(parent=self, initialdir='Datas/DTB',
                                                                filetypes=[('DTB files', '.sq3')],
                                                                title="Enregistrer un fichier de base de données sous")
        if self.CheminFileSaveDTB != '':
            if os.path.dirname(self.CheminFileSaveDTB) != os.getcwd().replace('\\', '/') + '/Datas/DTB':
                self.CanvasFileDTB.LabelPath.Label['text'] = Format(self.CheminFileSaveDTB)
            else:
                self.CanvasFileDTB.LabelPath.Label['text'] = 'Datas/DTB/' + os.path.basename(self.CheminFileSaveDTB)
                self.CheminFileSaveDTB = 'Datas/DTB/' + os.path.basename(self.CheminFileSaveDTB)
            self.ModifEnCours = True

    def ValidPara(self, _):
        if self.ChoixSave.get() == 1:
            self.MainAppli.AutoSave = 1
        else:
            self.MainAppli.AutoSave = 0
        if self.ChoixDTB.get() == 1:
            self.MainAppli.AutoLoad = 1
        else:
            self.MainAppli.AutoLoad = 0
        self.MainAppli.MaxSaves = self.MaxSaves.get()

        if self.CheminSave != '':
            self.MainAppli.AutoSavePath = self.CheminSave

        if self.CheminFile != '':
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                self.MainAppli.DTBChimiePath = self.CheminFile
            elif self.MainAppli.BaseEnCours == 'PHYS':
                self.MainAppli.DTBPhysPath = self.CheminFile

        PathFileToSave = ''
        if self.CheminFileNewDTB != '':
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                PathFileToSave = 'Datas/Backup/DTBChimie.sq3'
                self.MainAppli.DTBChimiePath = self.CheminFileNewDTB
            elif self.MainAppli.BaseEnCours == 'PHYS':
                PathFileToSave = 'Datas/Backup/DTBPhys.sq3'
                self.MainAppli.DTBPhysPath = self.CheminFileNewDTB
            shutil.copy(PathFileToSave, self.CheminFileNewDTB)

        PathFileToSave = ''
        if self.CheminFileSaveDTB != '':
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                PathFileToSave = self.MainAppli.DTBChimiePath
                self.MainAppli.DTBChimiePath = self.CheminFileSaveDTB
            elif self.MainAppli.BaseEnCours == 'PHYS':
                PathFileToSave = self.MainAppli.DTBPhysPath
                self.MainAppli.DTBPhysPath = self.CheminFileSaveDTB
            shutil.copy(PathFileToSave, self.CheminFileSaveDTB)

        PathFileToSave = ''
        if self.CheminFileRestoreDTB != '':
            if self.MainAppli.BaseEnCours == 'CHIMIE':
                PathFileToSave = self.MainAppli.DTBChimiePath
            elif self.MainAppli.BaseEnCours == 'PHYS':
                PathFileToSave = self.MainAppli.DTBPhysPath
            shutil.copy(self.CheminFileRestoreDTB, PathFileToSave)

        self.SaveParam()

    def SaveParam(self):
        if len(self.MainAppli.ListParam) == 2:
            SQLRequet = "DELETE FROM Param WHERE Type='" + 'User' + "'"
            self.MainAppli.curSave.execute(SQLRequet)

        if len(self.MainAppli.ListClasses) > 0:
            Classes = self.MainAppli.ListClasses[0]
            for i in range(1, len(self.MainAppli.ListClasses)):
                Classes = Classes + ',' + self.MainAppli.ListClasses[i]
        else:
            Classes = ''

        data = [('User', self.MainAppli.DTBChimiePath, self.MainAppli.DTBPhysPath, self.MainAppli.AutoSave,
                 self.MainAppli.AutoLoad, self.MainAppli.AutoSavePath, self.MainAppli.MaxSaves,
                 self.MainAppli.Etab[0], self.MainAppli.Service, self.MainAppli.AffichEtab,
                 self.MainAppli.AffichService, self.MainAppli.LieuxStockMatChim[0],
                 self.MainAppli.LieuxStockMatChim[1], self.MainAppli.LieuxStockMatChim[2],
                 self.MainAppli.LieuxStockMatPhys[0], self.MainAppli.LieuxStockMatPhys[1],
                 self.MainAppli.LieuxStockMatPhys[2], self.MainAppli.LogoPath, self.MainAppli.AffichLogo,
                 self.MainAppli.Etab[1], self.MainAppli.Etab[2], self.MainAppli.Etab[3], Classes,
                 self.MainAppli.CoeffSecuProd, self.MainAppli.CoeffSecuMat, self.MainAppli.TVA)]
        self.MainAppli.curSave.execute(
            "INSERT INTO Param(" + "Type , DTBChimie, DTBPhys, AutoSave, AutoLoad, SavePath, MaxSave,"
                                   "Etablissement, Service, AffichEtab, AffichService, MatChimLieux1,"
                                   "MatChimLieux2, MatChimLieux3, MatPhysLieux1, MatPhysLieux2, MatPhysLieux3,"
                                   "Logo, AffichLogo, Adresse, Tel, Email, Classes, CoefSecuProd, CoefSecuMat, TVA" +
            ") VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", data[0])

        self.MainAppli.DataBaseSave.commit()
        self.MainAppli.ChargeParam()
        self.MainAppli.CloseDTB()
        self.MainAppli.OpenDTB()
        self.destroy()
        self.MainAppli.ListBtnAction[4].CanvasBtn.itemconfig(self.MainAppli.ListBtnAction[4].ImgCanvasBtn,
                                                             image=self.MainAppli.ListBtnAction[4].ImgBtn[0])
        if self.MainAppli.OldNAction == 1:
            self.MainAppli.Action1()
        elif self.MainAppli.OldNAction == 2:
            self.MainAppli.Action2()
        elif self.MainAppli.OldNAction == 3:
            self.MainAppli.Action3()
        elif self.MainAppli.OldNAction == 4:
            self.MainAppli.Action4()
        elif self.MainAppli.OldNAction == 6:
            self.MainAppli.Action6()
        elif self.MainAppli.OldNAction == 0:
            self.MainAppli.FrmAccueil.destroy()
            self.MainAppli.FrmAccueil = FrmAccueil(self.MainAppli.CanvasFrmMain, self.MainAppli.RatioFondX,
                                                   self.MainAppli.RatioFondY, self.MainAppli)
            self.MainAppli.NAction = 0
            self.MainAppli.FrmLift()

    def ChargeListSaves(self):
        self.MainAppli.curSave.execute("select " + "Date , Heure, File" + " from Saves WHERE Type = \"" +
                                       self.TypeBDD + "\"")
        self.ListSaves = self.MainAppli.curSave.fetchall()
        self.ListSaves.reverse()
        if len(self.ListSaves) > 0:
            self.MainAppli.curSave.execute("select " + "Date , Action" + " from Modif WHERE TypeDTB = \"" +
                                           self.TypeBDD + "\"order by Date")
            self.ListModif = self.MainAppli.curSave.fetchall()
            self.ListModifs = []
            for i in range(len(self.ListSaves) - 1):
                ListModifsParSave = []
                for j in range(len(self.ListModif)):
                    if (datetime.strptime(self.ListSaves[i][0] + ' ' + self.ListSaves[i][1], '%d-%m-%Y %H:%M:%S') >
                        datetime.strptime(self.ListModif[j][0].split('.')[0], '%Y-%m-%d %H:%M:%S')) and \
                            (datetime.strptime(self.ListModif[j][0].split('.')[0], '%Y-%m-%d %H:%M:%S') >
                             datetime.strptime(self.ListSaves[i + 1][0] + ' ' + self.ListSaves[i + 1][1],
                                               '%d-%m-%Y %H:%M:%S')):
                        ListModifsParSave.append(self.ListModif[j][1])
                self.ListModifs.append(ListModifsParSave)
            ListModifsParSave = []
            for j in range(len(self.ListModif)):
                if (datetime.strptime(self.ListSaves[-1][0] + ' ' + self.ListSaves[-1][1], '%d-%m-%Y %H:%M:%S') >
                        datetime.strptime(self.ListModif[j][0].split('.')[0], '%Y-%m-%d %H:%M:%S')):
                    ListModifsParSave.append(self.ListModif[j][1])
            self.ListModifs.append(ListModifsParSave)

            self.TabSaves = MiniTableau(self.CanvasListSaves.CanvasMenu, self.MaxSaves.get(), 4,
                                        ['Date', 'Heure', 'Fichier', 'Modifications\n(/Sauvegarde précédente)'],
                                        [0.02, 0.02, 0.075, 0.075],
                                        AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                        AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)

            if self.MaxSaves.get() > len(self.ListSaves):
                Imax = len(self.ListSaves)
            else:
                Imax = self.MaxSaves.get()
            self.MenuClicDroitTab = []
            self.MenuClicDroitTab2 = []
            for i in range(Imax):
                for j in range(2):
                    self.TabSaves.TabLabels[i][j]['text'] = self.ListSaves[i][j]
                self.TabSaves.TabLabels[i][2]['text'] = self.ListSaves[i][2].split('/')[-1]
                self.TabSaves.TabLabels[i][3]['text'] = str(self.ListModifs[i])

                ListMenu = []
                for c in range(3):
                    ListMenu.append(tk.Menu(self.TabSaves.TabLabels[i][c], tearoff=0))

                    def GestEvt(evt, L=i):
                        return self.AffichMenuClicDroit(evt, self.MenuClicDroitTab, L)

                    self.TabSaves.TabLabels[i][c].bind("<Button-3>", GestEvt)
                self.MenuClicDroitTab.append(ListMenu)
                self.MenuClicDroitTab2.append(tk.Menu(self.TabSaves.TabLabels[i][3], tearoff=0))

                def GestEvt2(evt, L=i):
                    return AffichMenuClicDroit2(evt, self.MenuClicDroitTab2, L)

                self.TabSaves.TabLabels[i][3].bind("<Button-3>", GestEvt2)

                self.MenuClicDroitTab[i][0].add_command(label="Supprimer la sauvegarde", command=self.SupSave)
                self.MenuClicDroitTab2[i].add_command(label="Afficher la liste des modifications",
                                                      command=self.AffichListModif)

            for l in range(self.TabSaves.NLine):
                for k in range(self.TabSaves.NCol):
                    def GestEvt(evt, Line=l):
                        return self.SelectSaveDTB(evt, Line)

                    self.TabSaves.TabLabels[l][k].bind('<Button-1>', GestEvt)

            for C in range(self.TabSaves.NCol):
                def GestEvt2(evt):
                    return self.AnnulSelectSaveDTB(evt)

                self.TabSaves.TabLabelNCol[C].bind('<Button-1>', GestEvt2)

            self.CanvasFrmFond.bind("<Button-1>", self.AnnulSelectSaveDTB)
            self.CanvasMenu.CanvasMenu.bind("<Button-1>", self.AnnulSelectSaveDTB)
            self.TabSaves.scrollable_canvas.interior.bind("<Button-1>", self.AnnulSelectSaveDTB)
            self.TabSaves.scrollable_canvas.bind("<Button-1>", self.AnnulSelectSaveDTB)

    def SelectSaveDTB(self, _, L):
        self.NDTBSelect = L
        self.BtnRestore.config(state='normal')

    def AnnulSelectSaveDTB(self, _):
        if self.TabSaves:
            self.TabSaves.ActionUnSelect()
            self.BtnRestore.config(state='disabled')

    def AffichMenuClicDroit(self, event, MenuClicDroitTab, j):
        MenuClicDroitTab[j][0].post(event.x_root, event.y_root)
        self.NDTBSelect = j

    def AffichListModif(self):
        self.EffaceMenu()
        self.MainAppli.curSave.execute("select " + "Date , Action" + " from Modif WHERE TypeDTB = \"" +
                                       self.TypeBDD + "\"order by Date DESC")
        self.ListModif = self.MainAppli.curSave.fetchall()
        self.CanvasBarre = CanvasMenu(self.CanvasMenu.CanvasMenu, 'Media/FrmParam/Barre/',
                                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.998),
                                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.035),
                                      int(int(self.CanvasMenu.CanvasMenu['width']) * 0.5),
                                      int(int(self.CanvasMenu.CanvasMenu['height']) * 0.021), tk.CENTER)
        self.CanvasBarre.CanvasMenu.bind('<Motion>',
                                         lambda action: self.BtnQuit.CanvasBtn.itemconfig(self.BtnQuit.ImgCanvasBtn,
                                                                                          image=self.BtnQuit.ImgBtn[0]))
        self.BtnQuit = BtnAction(self.CanvasBarre.CanvasMenu, int(int(self.CanvasBarre.CanvasMenu['width']) * 0.97),
                                 int(int(self.CanvasBarre.CanvasMenu['height']) * 0.5), self.RatioX, self.RatioX,
                                 'Media/FrmParam/BtnClose/')
        self.BtnQuit.CanvasBtn.bind('<Motion>',
                                    lambda action: self.BtnQuit.CanvasBtn.itemconfig(self.BtnQuit.ImgCanvasBtn,
                                                                                     image=self.BtnQuit.ImgBtn[1]))
        self.BtnQuit.CanvasBtn.bind('<ButtonRelease-1>', self.QuitListModif)
        LabelInCanvas(self.CanvasBarre.CanvasMenu, 'Base de données - ' + self.TypeBDD + ' - Liste des modifications',
                      '#E0E0E0', AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasBarre.CanvasMenu['width']) * 0.02),
                      int(int(self.CanvasBarre.CanvasMenu['height']) * 0.15), tk.NW)
        self.CanvasListSaves = CanvasMenu(self.CanvasMenu.CanvasMenu, 'Media/FrmParam/SaveList/',
                                          int(int(self.CanvasMenu.CanvasMenu['width']) * 0.99),
                                          int(int(self.CanvasMenu.CanvasMenu['height']) * 0.93),
                                          int(int(self.CanvasMenu.CanvasMenu['width']) * 0.5),
                                          int(int(self.CanvasMenu.CanvasMenu['height']) * 0.53), tk.CENTER)
        self.TabModifs = MiniTableau(self.CanvasListSaves.CanvasMenu, len(self.ListModif), 2,
                                     ['Date', 'Modifications'], [0.05, 0.12],
                                     AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                     AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)
        self.MenuClicDroitTab = []
        for i in range(len(self.ListModif)):
            ListMenu = []
            for c in range(2):
                self.TabModifs.TabLabels[i][c]['text'] = self.ListModif[i][c]
                ListMenu.append(tk.Menu(self.TabModifs.TabLabels[i][c], tearoff=0))

                def GestEvt(evt, j=i):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTab, j)

                self.TabModifs.TabLabels[i][c].bind("<Button-3>", GestEvt)
            self.MenuClicDroitTab.append(ListMenu)
            self.MenuClicDroitTab[i][0].add_command(label="Effacer la modification", command=self.SupModif)

    def SupSave(self):
        Rep = tkMB.askyesno('Supprimer une sauvegarde', 'Etes vous sûr de vouloir supprimer la sauvegarde "' +
                            self.ListSaves[self.NDTBSelect][2].split('/')[-1] + '" de la base de données?', parent=self)
        if Rep:
            SQLRequet = "DELETE FROM Saves WHERE File='" + self.ListSaves[self.NDTBSelect][2] + "'"
            self.MainAppli.curSave.execute(SQLRequet)
            if os.path.exists(self.ListSaves[self.NDTBSelect][2]):
                os.remove(self.ListSaves[self.NDTBSelect][2])
            self.MainAppli.DataBaseSave.commit()
            self.EffaceListSaves()
            self.ChargeListSaves()

    def SupModif(self):
        Rep = tkMB.askyesno('Effacer une modification', 'Etes vous sûr de vouloir effacer la modification du "' +
                            self.ListModif[self.NDTBSelect][0].split('.')[0] + '" de la liste?', parent=self)
        if Rep:
            SQLRequet = "DELETE FROM Modif WHERE Date='" + self.ListModif[self.NDTBSelect][0] + "'"
            self.MainAppli.curSave.execute(SQLRequet)
            self.MainAppli.DataBaseSave.commit()
            self.EffaceListSaves()
            self.AffichListModif()

    def EffaceMenu(self):
        for widget in self.CanvasMenu.CanvasMenu.winfo_children():
            widget.destroy()
        self.TabSaves = None
        self.BtnPoubClasse = None
        self.BtnAjoutClasse = None
        self.BtnSupClasse = None

    def EffaceListSaves(self):
        for widget in self.CanvasListSaves.CanvasMenu.winfo_children():
            widget.destroy()

    def ValidParaOptions(self, _):
        if self.ChoixEtab.get() == 1:
            self.MainAppli.AffichEtab = 1
        else:
            self.MainAppli.AffichEtab = 0
        if self.ChoixService.get() == 1:
            self.MainAppli.AffichService = 1
        else:
            self.MainAppli.AffichService = 0
        if self.ChoixLogo.get() == 1:
            self.MainAppli.AffichLogo = 1
        else:
            self.MainAppli.AffichLogo = 0

        if self.CanvasEtab.Entry is not None:
            self.MainAppli.Etab[0] = self.CanvasEtab.Entry.get()
        if self.CanvasAdresse.Entry is not None:
            self.MainAppli.Etab[1] = self.CanvasAdresse.Entry.get()
        if self.CanvasTel.Entry is not None:
            self.MainAppli.Etab[2] = self.CanvasTel.Entry.get()
        if self.CanvasEmail.Entry is not None:
            self.MainAppli.Etab[3] = self.CanvasEmail.Entry.get()
        if self.CanvasService.Entry is not None:
            self.MainAppli.Service = self.CanvasService.Entry.get()

        if self.PathFilejpgToOpen != '':
            self.MainAppli.LogoPath = 'Datas/LogoETAB/LogoETAB'
            try:
                shutil.copy(self.PathFilejpgToOpen, self.MainAppli.LogoPath)
            except:
                pass
        else:
            self.MainAppli.LogoPath = self.LogoPath
            if self.LogoPath == '':
                if os.path.exists('Datas/LogoETAB/LogoETAB'):
                    os.remove('Datas/LogoETAB/LogoETAB')

        self.SaveParam()

    def ValidParaPerso(self, _):
        for i in range(3):
            if self.ListEntryLieux[i] is not None:
                if self.TypeBDD == 'Chimie':
                    self.MainAppli.LieuxStockMatChim[i] = self.ListEntryLieux[i].get()
                else:
                    self.MainAppli.LieuxStockMatPhys[i] = self.ListEntryLieux[i].get()
        self.MainAppli.ListClasses = []
        for i in range(len(self.ListClasses)):
            self.MainAppli.ListClasses.append(self.ListClasses[i])
        if self.EntrySecuProd is not None:
            self.MainAppli.CoeffSecuProd = self.EntrySecuProd.get()
        if self.EntrySecuMat is not None:
            self.MainAppli.CoeffSecuMat = self.EntrySecuMat.get()
        if self.EntryTVA is not None:
            self.MainAppli.TVA = self.EntryTVA.get()
        self.SaveParam()

    def OnSelectListBox(self, evt):
        try:
            w = evt.widget
            self.IndexClasse = int(w.curselection()[0])
        except:
            pass

    def MoveOnCanvas(self, _):
        self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit, image=self.ImgBtnQuit[0])
        for i in range(len(self.LabelMenu)):
            if i != self.MenuActif:
                self.LabelMenu[i].Label.config(bg='#E0E0E0')

    def MoveOnCanvasMenu(self, _):
        if self.BtnPoubClasse is not None:
            self.BtnPoubClasse.CanvasBtn.itemconfig(self.BtnPoubClasse.ImgCanvasBtn,
                                                    image=self.BtnPoubClasse.ImgBtn[0])
        if self.BtnAjoutClasse is not None:
            self.BtnAjoutClasse.CanvasBtn.itemconfig(self.BtnAjoutClasse.ImgCanvasBtn,
                                                     image=self.BtnAjoutClasse.ImgBtn[0])
        if self.BtnSupClasse is not None:
            self.BtnSupClasse.CanvasBtn.itemconfig(self.BtnSupClasse.ImgCanvasBtn,
                                                   image=self.BtnSupClasse.ImgBtn[0])

    def QuitListModif(self, _):
        self.EffaceMenu()
        self.AffichMenuSave()
        self.TabModifs = None

    def Quitter(self, _):
        self.destroy()
        self.MainAppli.ListBtnAction[4].CanvasBtn.itemconfig(self.MainAppli.ListBtnAction[4].ImgCanvasBtn,
                                                             image=self.MainAppli.ListBtnAction[4].ImgBtn[0])
        self.MainAppli.parent.focus_force()
        self.MainAppli.NAction = self.MainAppli.OldNAction
        self.MainAppli.FrmLift()


class CanvasFileDialog:
    def __init__(self, container, RatioX, RatioY, W, H, X, Y, Path, Type, Appli):
        self.MainAppli = Appli
        self.CanvasPath = CanvasMenu(container, 'Media/FrmParam/Chemin/', W, H, X, Y, tk.NW)
        self.LabelPath = LabelInCanvas(self.CanvasPath.CanvasMenu, Path, '#FFFFFF',
                                       AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0),
                                       int(int(self.CanvasPath.CanvasMenu['width']) * 0.02),
                                       int(int(self.CanvasPath.CanvasMenu['height']) * 0.5), tk.W)
        self.BtnDossier = BtnAction(self.CanvasPath.CanvasMenu,
                                    int(int(self.CanvasPath.CanvasMenu['width']) * 0.975),
                                    int(int(self.CanvasPath.CanvasMenu['height']) * 0.5), RatioX,
                                    RatioY * 1.1, 'Media/FrmParam/BtnDossier/')
        if Type == "Dossier":
            self.BtnDossier.CanvasBtn.bind('<ButtonRelease-1>', self.MainAppli.ChangeSavePath)
        elif Type == "Fichier":
            self.BtnDossier.CanvasBtn.bind('<ButtonRelease-1>', self.MainAppli.ChangeFileDTB)


class CanvasEntry:
    def __init__(self, container, W, H, X, Y, Text, Appli):
        self.MainAppli = Appli
        self.Entry = None

        self.CanvasEntry = CanvasMenu(container, 'Media/FrmParam/Chemin/', W, H, X, Y, tk.NW)
        self.LabelEntry = LabelInCanvas(self.CanvasEntry.CanvasMenu, Text, '#FFFFFF',
                                        AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0),
                                        int(int(self.CanvasEntry.CanvasMenu['width']) * 0.02),
                                        int(int(self.CanvasEntry.CanvasMenu['height']) * 0.5), tk.W)
        self.CanvasEntry.CanvasMenu.bind('<Double-1>', self.ModifText)
        self.LabelEntry.Label.bind('<Double-1>', self.ModifText)
        ChangeCursor(self.CanvasEntry.CanvasMenu)
        ChangeCursor(self.LabelEntry.Label)

    def ModifText(self, _):
        self.Entry = tk.Entry(self.CanvasEntry.CanvasMenu, text='',
                              width=int(int(self.CanvasEntry.CanvasMenu['width']) * 0.122),
                              font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont + 1, 'normal', 0),
                              justify='left')
        self.CanvasEntry.CanvasMenu.create_window(int(int(self.CanvasEntry.CanvasMenu['width']) * 0.01),
                                                  int(int(self.CanvasEntry.CanvasMenu['height']) * 0.15), anchor=tk.NW,
                                                  window=self.Entry)
        self.Entry.insert(0, self.LabelEntry.Label['text'])
        self.Entry.focus_set()
        self.MainAppli.ModifEnCours = True
