from AppliDef import *
from FrmInfoProdMat import Tableau, InfoProd, CaractProd, FrmTabRecap
from EtagProduits import ModifListDanger, ModifFB


class FrmPrepaProd(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.ListProd = []
        self.TabProd = None
        self.InfoProd = None
        self.CaractProd = None
        self.CanvasFond = None
        self.EntryPavTP = None
        self.EntryPapTP = None
        self.TitreQuant = None
        self.LabelQuantCons = None
        self.BtnOK = None
        self.BtnAnnul = None
        self.ListProds = []
        self.Quantcons = 0
        self.NumFlacon = 1
        self.Nflacon = str(self.NumFlacon)
        self.IndexElt = 0
        self.ListFlacon = []
        self.MenuClicDroitTabProd = []
        self.NlineProd = 0
        self.NewPes = False
        self.LabelNFlacon = None
        self.ImgBtnSuiv = None
        self.ImgBtnRetour = None
        self.CanvasBtnSuiv = None
        self.CanvasBtnRetour = None
        self.ImgCanvasBtnSuiv = None
        self.ImgCanvasBtnRetour = None
        self.ComptFlacon = 0
        self.BtnTab = None
        self.TabRecap = None
        self.ListRecapProdConsom = []
        self.FrmImprimEtiqProd = None

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        coefY = float(ConfigResolution(self.MainAppli.Nconfig, 'YTitreFrm', self.MainAppli.curSave))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmPrepaProd)

        if self.MainAppli.NAction == 3011:
            self.TP = self.MainAppli.ListRecherch[self.MainAppli.IndexElt]
        elif self.MainAppli.NAction == 3022:
            self.TP = self.MainAppli.ListTPCat[self.MainAppli.IndexElt]
        else:
            self.TP = self.MainAppli.ListTPs[self.MainAppli.IndexElt]

        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, self.TP[2] + ' - ' + self.TP[0] +
                                      ' - Préparation des produits chimiques', '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * coefY), tk.NW)

        self.CanvasMenu1 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.965), int(self.SX * 0.003), int(self.SY * 0.031), tk.NW)

        self.CanvasMenu2 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.965), int(self.SX * 0.5), int(self.SY * 0.031), tk.N)

        self.CanvasMenu3 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.965), int(self.SX * 0.998), int(self.SY * 0.031), tk.NE)

        self.AffichProd()
        if len(self.ListProd) > 0:
            self.AffichStock(0)

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.bind('<Button-1>', self.ClicOnCanvas)

        self.CanvasMenu2.CanvasMenu.bind('<Button-1>', self.ClicOnCanvas)
        self.CanvasMenu3.CanvasMenu.bind('<Button-1>', self.ClicOnCanvas)

        self.CanvasFrmFond.pack()

    def AffichProd(self):
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Produits chimiques du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.004), tk.NW)
        self.MainAppli.cur.execute("SELECT " + "PRODUIT, QUANTITE, UNITMES" +
                                   " FROM TP WHERE TITRE = \"" + self.TP[0] + "\" order by PRODUIT")
        ListProds = self.MainAppli.cur.fetchall()
        self.ListProd = []
        for i in range(len(ListProds)):
            if ListProds[i][0] != '' and ListProds[i][0] is not None:
                self.ListProd.append(ListProds[i])

        self.TabProd = Tableau(self.CanvasMenu1.CanvasMenu, len(self.ListProd), 3,
                               ['Désignation', 'Quantité', 'Unit. Mes.'],
                               [0.078, 0.02, 0.02],
                               AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                               AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)

        nl = 0
        self.NlineProd = len(self.ListProd)
        for i in range(len(self.ListProd)):
            for j in range(3):
                self.TabProd.TabLabels[nl][j]['text'] = self.ListProd[i][j]
                if nl == self.IndexElt:
                    self.TabProd.TabLabels[nl][j].config(bg='#E0E0E0')
            nl = nl + 1

        self.BtnTab = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.975),
                                int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.014), self.RatioX * 0.6,
                                self.RatioX * 0.6, 'Media/FrmPrepaTPChimie/BtnTab/')
        self.BtnTab.CanvasBtn.bind('<ButtonRelease-1>', self.AffichTabRecap)

        self.AjoutMenuProd()

    def AffichStock(self, IndexElt):
        self.EffaceMenus()
        LabelInCanvas(self.CanvasMenu2.CanvasMenu, 'Stock / Fournisseur du produit chimique sélectionné', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.004), tk.NW)
        LabelInCanvas(self.CanvasMenu3.CanvasMenu, 'Informations sur le produit chimique sélectionné', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.004), tk.NW)

        self.ListProds = []
        try:
            self.MainAppli.cur.execute("SELECT " + self.MainAppli.ListChampsTabProd +
                                       " FROM PRODUITS WHERE " + 'NOMS = "' +
                                       self.ListProd[IndexElt][0] + '" order by NOMS')
            self.ListProds = self.MainAppli.cur.fetchall()
        except:
            self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabProd +
                                       ' FROM PRODUITS WHERE ' + 'NOMS = \"%' +
                                       self.ListProd[IndexElt][0] + '%\" order by NOMS')
            self.ListProds = self.MainAppli.cur.fetchall()
        finally:
            if len(self.ListProds) == 0:
                self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabProd +
                                           ' FROM PRODUITS WHERE NOMS LIKE \"%' +
                                           self.ListProd[IndexElt][0] + '%\" order by NOMS')
                self.ListProds = self.MainAppli.cur.fetchall()

        if len(self.ListProds) > 0:
            self.InfoProd = InfoProd(self.CanvasMenu2.CanvasMenu, self.ListProds[0],
                                     self.MainAppli.cur, self.MainAppli.SizeFont, self.RatioX,
                                     self.RatioY, 1)
            self.CaractProd = CaractProd(self.CanvasMenu3.CanvasMenu, self.ListProds[0],
                                         self.MainAppli.SizeFont, self.RatioX, self.RatioY)

    def PrepaTP(self, IndexElt):
        self.IndexElt = IndexElt
        self.EffaceMenuMain()

        LabelInCanvas(self.CanvasMenu1.CanvasMenu, self.ListProd[IndexElt][0] + ' - Consommation', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.004), tk.NW)

        self.CanvasFond = CanvasInWindow('Media/FrmPrepaTPChimie/Fond/', self.RatioX * 1.1, self.RatioY * 0.9,
                                         self.CanvasMenu1.CanvasMenu, tk.CENTER,
                                         int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.5),
                                         int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.5), 0)
        self.LabelNFlacon = LabelInCanvas(self.CanvasMenu1.CanvasMenu, '', '#C0C0C0',
                                          AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1),
                                          int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.1),
                                          int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.07), tk.CENTER)
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Pesée avant TP:', '#C0C0C0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.2),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.15), tk.CENTER)
        self.EntryPavTP = EntryData(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.018),
                                    int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.2),
                                    int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.2), tk.CENTER,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 4, 'bold', 0))
        self.EntryPavTP.EntryData.config(justify='center')
        self.EntryPavTP.EntryData.bind('<KeyRelease>', self.CalculQuantCons)
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Pesée après TP:', '#C0C0C0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.8),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.15), tk.CENTER)
        self.EntryPapTP = EntryData(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.018),
                                    int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.8),
                                    int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.2), tk.CENTER,
                                    AppliFont('Helvetica', self.MainAppli.SizeFont + 4, 'bold', 0))
        self.EntryPapTP.EntryData.config(justify='center')
        self.EntryPapTP.EntryData.bind('<KeyRelease>', self.CalculQuantCons)

        self.TitreQuant = self.CanvasMenu1.CanvasMenu.create_text(
            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.05),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.85),
            text='Quantité consommée (' + self.ListProds[0][1] + '):',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 4, 'bold', 0), anchor=tk.W)

        self.LabelQuantCons = LabelInCanvas(self.CanvasMenu1.CanvasMenu, '', '#C0C0C0',
                                            AppliFont('Helvetica', self.MainAppli.SizeFont + 5, 'bold', 0),
                                            int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.5),
                                            int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.85), tk.CENTER)

        self.BtnOK = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.83),
                               int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                               self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidPrepa)
        self.BtnAnnul = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.90),
                                  int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                  self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulPrepa)
        self.ListFlacon = []
        self.MainAppli.cur.execute("Select " + self.MainAppli.ListChampsTabTPConsomprod +
                                   " from TPConsomprod where TITRE = \"" + self.TP[0] + "\" and ANNEESCOL = '" +
                                   self.MainAppli.AnScol + "' and PRODUIT = '" + self.ListProd[self.IndexElt][
                                       0] + "'")
        ListProdConsom = self.MainAppli.cur.fetchall()
        if len(ListProdConsom) > 0:
            for i in range(len(ListProdConsom)):
                if ListProdConsom[i][6] == '' or ListProdConsom[i][6] is None:
                    self.ListFlacon.append(ListProdConsom[i])
        if not self.NewPes:
            if len(self.ListFlacon) > 0:
                self.ComptFlacon = 0
                self.EntryPavTP.Data.set(self.ListFlacon[self.ComptFlacon][5])
                self.NumFlacon = self.ListFlacon[self.ComptFlacon][2]
                if len(self.ListFlacon) > 1:
                    self.AffichBtnSuivRetour()
            else:
                self.NumFlacon = len(ListProdConsom) + 1
        else:
            self.NumFlacon = len(ListProdConsom) + 1

        self.Nflacon = str(self.NumFlacon)
        self.LabelNFlacon.Label['text'] = 'Flacon N° ' + self.Nflacon

    def EffaceMenuMain(self):
        for widget in self.CanvasMenu1.CanvasMenu.winfo_children():
            widget.destroy()
        self.CanvasMenu1.CanvasMenu.delete(self.TitreQuant)

    def EffaceMenus(self):
        for widget in self.CanvasMenu2.CanvasMenu.winfo_children():
            widget.destroy()
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        if self.InfoProd is not None:
            self.CanvasMenu2.CanvasMenu.delete(self.InfoProd.NomProd)
            self.CanvasMenu2.CanvasMenu.delete(self.InfoProd.TitreStock)
            self.CanvasMenu2.CanvasMenu.delete(self.InfoProd.TitreFournisseur)
            self.InfoProd = None

    def CalculQuantCons(self, _):
        if self.ListProds[0][1] != 'mL':
            try:
                self.Quantcons = float(self.EntryPavTP.Data.get().replace(',', '.')) - \
                                 float(self.EntryPapTP.Data.get().replace(',', '.'))
                self.LabelQuantCons.Label['text'] = str(round(self.Quantcons, 1)).replace('.', ',')
            except:
                self.LabelQuantCons.Label['text'] = ''
        else:
            try:
                self.Quantcons = (float(self.EntryPavTP.Data.get().replace(',', '.')) -
                                  float(self.EntryPapTP.Data.get().replace(',', '.'))) / float(
                    self.ListProds[0][12].replace(',', '.'))
                self.LabelQuantCons.Label['text'] = str(round(self.Quantcons, 1)).replace('.', ',')
            except:
                self.LabelQuantCons.Label['text'] = ''

    def ValidPrepa(self, _):
        if self.LabelQuantCons.Label['text'] != '':
            self.SaveConsomProd()
            QuantStock = str(
                round(float(self.ListProds[0][18].replace(',', '.')) - self.Quantcons, 1)).replace('.', ',')
            self.MainAppli.cur.execute(
                "UPDATE PRODUITS SET QSTOCK ='" + QuantStock + "' WHERE NOMS='" + self.ListProds[0][0] + "'")
            self.MainAppli.DataBaseChimie.commit()
            self.MainAppli.SaveListModifDTB('Chimie', 'Mise à jour stock produit chimique après TP - ' +
                                            self.ListProds[0][0])
            self.MainAppli.cur.execute("SELECT Quant FROM ConsomProd WHERE Annee ='" + self.MainAppli.AnScol
                                       + "' and produit = '" + self.ListProds[0][0] + "' and Classe ='"
                                       + self.TP[2] + "'")
            ListConsomProd = self.MainAppli.cur.fetchall()
            if len(ListConsomProd) > 0:
                QuantConsom = str(round(self.Quantcons + float(
                    ListConsomProd[0][0].replace(',', '.')), 1)).replace('.', ',')
                self.MainAppli.cur.execute(
                    "UPDATE ConsomProd SET Quant ='" + QuantConsom + "' WHERE Produit='" + self.ListProds[0][0]
                    + "' and Annee ='" + self.MainAppli.AnScol + "'and Classe ='" + self.TP[2] + "'")
            else:
                QuantConsom = str(round(self.Quantcons, 1)).replace('.', ',')
                data = [(self.MainAppli.AnScol, self.ListProds[0][0], self.TP[2], self.ListProds[0][1], QuantConsom)]
                self.MainAppli.cur.execute(
                    "INSERT INTO ConsomProd(Annee, Produit, Classe , UnitMes, Quant) VALUES(?,?,?,?,?)", data[0])
            self.MainAppli.DataBaseChimie.commit()
            self.MainAppli.SaveListModifDTB('Chimie', 'Ajout consommation produit chimique après TP - ' +
                                            self.ListProds[0][0])

        elif self.EntryPavTP.EntryData.get() != '':
            self.SaveConsomProd()

        self.AnnulPrepa(_)

    def AnnulPrepa(self, _):
        self.EffaceMenuMain()
        self.AffichProd()
        self.AffichStock(self.IndexElt)
        self.NewPes = False

    def SaveConsomProd(self):
        if not self.ListFlacon or self.NewPes:
            data = [(self.TP[0], self.MainAppli.AnScol, self.Nflacon, self.ListProd[self.IndexElt][0], 'PUR',
                     self.EntryPavTP.Data.get(), self.EntryPapTP.Data.get(), self.ListProd[self.IndexElt][2],
                     self.LabelQuantCons.Label['text'])]
            self.MainAppli.cur.execute(
                "INSERT INTO TPConsomprod(" + self.MainAppli.ListChampsTabTPConsomprod + ") VALUES(?,?,?,?,?,?,?,?,?)",
                data[0])
        else:
            self.MainAppli.cur.execute(
                "UPDATE TPConsomprod SET PFLACONAPTP ='" + self.EntryPapTP.Data.get() + "', QUANTITE ='" +
                self.LabelQuantCons.Label['text'] + "' WHERE TITRE = \"" +
                self.TP[0] + "\" and ANNEESCOL = '" + self.MainAppli.AnScol + "' and PRODUIT = '" +
                self.ListProd[self.IndexElt][0] + "' and NFLACON = '" + self.Nflacon + "'")

        self.MainAppli.DataBaseChimie.commit()
        self.MainAppli.SaveListModifDTB('Chimie', 'Pesée produit chimique avant TP - ' +
                                        self.ListProd[self.IndexElt][0] + ' (' + self.TP[0] + ')')

    def AjoutMenuProd(self):
        self.MenuClicDroitTabProd = []
        for r in range(self.NlineProd):
            ListMenu = []
            for i in range(3):
                ListMenu.append(tk.Menu(self.TabProd.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabProd, j)

                def GestEvt2(evt, j=r):
                    return self.PrepaTPDoubleClic(evt, j)

                self.TabProd.TabLabels[r][i].bind("<Button-3>", GestEvt)
                self.TabProd.TabLabels[r][i].bind("<Double-2>", GestEvt2)
            self.MenuClicDroitTabProd.append(ListMenu)

        for r in range(self.TabProd.NLine):
            self.MenuClicDroitTabProd[r][0].add_command(label="Pesée avant TP", command=self.ActionPrepaTP)
            self.MenuClicDroitTabProd[r][0].add_command(label="Nouvelle pesée avant TP", command=self.NewPrepaTP)
            self.MenuClicDroitTabProd[r][0].add_separator()
            self.MenuClicDroitTabProd[r][0].add_command(label="Imprimer une étiquette", command=self.AffichFrmImprim)

    def AffichMenuClicDroit(self, event, MenuClicDroitProd, j):
        MenuClicDroitProd[j][0].post(event.x_root, event.y_root)
        self.IndexElt = j

    def ActionPrepaTP(self):
        self.AffichStock(self.IndexElt)
        self.PrepaTP(self.IndexElt)

    def PrepaTPDoubleClic(self, _, j):
        self.IndexElt = j
        self.AffichStock(self.IndexElt)
        self.PrepaTP(self.IndexElt)

    def NewPrepaTP(self):
        self.AffichStock(self.IndexElt)
        self.NewPes = True
        self.PrepaTP(self.IndexElt)

    def AffichBtnSuivRetour(self):
        self.ImgBtnSuiv, wsize, hsize, self.CanvasBtnSuiv, self.ImgCanvasBtnSuiv = CanInWindow(
            'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu1.CanvasMenu, tk.CENTER,
            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.98),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.015), 0)
        ChangeCursor(self.CanvasBtnSuiv)
        self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.ActionFlaconSuiv)

        self.ImgBtnRetour, wsize, hsize, self.CanvasBtnRetour, self.ImgCanvasBtnRetour = CanInWindow(
            'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu1.CanvasMenu, tk.CENTER,
            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.95),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.015), 2)
        ChangeCursor2(self.CanvasBtnRetour)
        self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.ActionFlaconRetour)

    def ActionFlaconSuiv(self, _):
        if self.ComptFlacon < len(self.ListFlacon) - 1:
            self.ComptFlacon = self.ComptFlacon + 1
            self.EntryPavTP.Data.set(self.ListFlacon[self.ComptFlacon][5])
            self.NumFlacon = self.ListFlacon[self.ComptFlacon][2]
            self.Nflacon = str(self.NumFlacon)
            self.LabelNFlacon.Label['text'] = 'Flacon N° ' + self.Nflacon
            if self.ComptFlacon == len(self.ListFlacon) - 1:
                self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[1])
                self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
                self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.ActionFlaconRetour)
            else:
                self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[1])
                ChangeCursor(self.CanvasBtnRetour)

    def ActionFlaconRetour(self, _):
        if self.ComptFlacon > 0:
            self.ComptFlacon = self.ComptFlacon - 1
            self.EntryPavTP.Data.set(self.ListFlacon[self.ComptFlacon][5])
            self.NumFlacon = self.ListFlacon[self.ComptFlacon][2]
            self.Nflacon = str(self.NumFlacon)
            self.LabelNFlacon.Label['text'] = 'Flacon N° ' + self.Nflacon
            if self.ComptFlacon == 0:
                self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[0])
                self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.ActionFlaconSuiv)
                self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[2])
                ChangeCursor2(self.CanvasBtnRetour)
            else:
                self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.ActionFlaconSuiv)
                self.CanvasBtnSuiv.itemconfig(self.ImgCanvasBtnSuiv, image=self.ImgBtnSuiv[0])
                self.CanvasBtnRetour.itemconfig(self.ImgCanvasBtnRetour, image=self.ImgBtnRetour[1])

    def AffichTabRecap(self, _):
        self.BtnTab.CanvasBtn.itemconfig(self.BtnTab.ImgCanvasBtn, image=self.BtnTab.ImgBtn[0])

        self.MainAppli.cur.execute("Select " + self.MainAppli.ListChampsTabTPConsomprod +
                                   " from TPConsomprod where TITRE = \"" + self.TP[0] +
                                   "\" and ANNEESCOL = '" + self.MainAppli.AnScol + "' and UTIL = 'PUR'")
        self.ListRecapProdConsom = self.MainAppli.cur.fetchall()

        self.TabRecap = FrmTabRecap(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY,
                                    self.TP[2] + ' - ' + self.TP[0] + ' - Préparation des produits chimiques',
                                    'Récapitulatif des produits chimiques consommés',
                                    ['Désignation', 'N° Flacon', 'Masse flacon avant TP', 'Masse flacon après TP',
                                     'Quantité consommée', 'Unit. Mes.'], self.MainAppli.AnScol,
                                    self.MainAppli.SizeFont, len(self.ListRecapProdConsom), 6,
                                    [0.05, 0.014, 0.014, 0.014, 0.014, 0.014], self)

        for i in range(len(self.ListRecapProdConsom)):
            self.TabRecap.TabProd.TabLabels[i][0]['text'] = self.ListRecapProdConsom[i][3]
            self.TabRecap.TabProd.TabLabels[i][1]['text'] = self.ListRecapProdConsom[i][2]
            self.TabRecap.TabProd.TabLabels[i][2]['text'] = self.ListRecapProdConsom[i][5]
            self.TabRecap.TabProd.TabLabels[i][3]['text'] = self.ListRecapProdConsom[i][6]
            self.TabRecap.TabProd.TabLabels[i][4]['text'] = self.ListRecapProdConsom[i][8]
            self.TabRecap.TabProd.TabLabels[i][5]['text'] = self.ListRecapProdConsom[i][7]

    def AffichFrmImprim(self):
        self.AffichStock(self.IndexElt)
        self.FrmImprimEtiqProd = FrmImprimEtiqProd(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY,
                                                   self.MainAppli.SizeFont, self.ListProd[self.IndexElt][0], self)

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.ImgCanvasBtnQuit, image=self.MainAppli.ImgBtnQuit[0])

    def ClicOnCanvas(self, _):
        if self.FrmImprimEtiqProd is not None:
            self.FrmImprimEtiqProd.lift()

    def CacheFrmPrepaProd(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.ListBtnActionV[6].CanvasBtn.itemconfig(self.MainAppli.ListBtnActionV[6].ImgCanvasBtn,
                                                              image=self.MainAppli.ListBtnActionV[6].ImgBtn[0])
        self.destroy()
        if self.MainAppli.OldNAction != 0:
            self.MainAppli.NAction = self.MainAppli.OldNAction
        else:
            self.MainAppli.NAction = 3
        self.MainAppli.MAJInfo()
        self.MainAppli.parent.focus_force()
        self.MainAppli.FrmLift()
        self.MainAppli.ModifEnCours = False


class EtiqProd:
    def __init__(self, container, prod, SizeFont, RatioX):
        self.listGHS = []
        FB = ''
        maxchr = 24
        Nom = prod[0]
        if prod[6] is not None and prod[6] != '':
            FB = prod[6]
            FB = ModifFB(FB)

        self.DeterminListGHS(prod)

        if len(Nom) >= maxchr:
            sizefont = SizeFont + 6
            if len(Nom) > 27:
                (Nom1, Nom2) = (Nom[:len(Nom) // 2], Nom[len(Nom) // 2:])
                Nom = Nom1 + '-\n' + Nom2
        else:
            sizefont = SizeFont + 8
        self.NomProd = LabelInCanvas(container.CanvasListIma, Nom, '#FFFFFF',
                                     AppliFont('Helvetica', sizefont, 'bold', 0),
                                     int(int(container.CanvasListIma['width']) * 0.5),
                                     int(int(container.CanvasListIma['height']) * 0.15),
                                     tk.CENTER)
        self.FBProduit = container.CanvasListIma.create_text(
            int(int(container.CanvasListIma['width']) * 0.5), int(int(container.CanvasListIma['height']) * 0.32),
            text=FB, font=AppliFont('Calibri', SizeFont + 6, 'bold', 0), anchor=tk.CENTER)

        self.CanvasGHS = []
        deb = 0
        if len(self.listGHS) == 3:
            deb = int(container.wsize * 0.2)
        elif len(self.listGHS) == 2:
            deb = int(container.wsize * 0.35)
        elif len(self.listGHS) == 1:
            deb = int(container.wsize * 0.5)
        for i in range(len(self.listGHS)):
            self.CanvasGHS.append(
                CanvasInWindow('Media/PictoDanger/', RatioX * 0.75, RatioX * 0.75,
                               container.CanvasListIma, tk.CENTER, deb + int(i * container.wsize * 0.3),
                               int(container.hsize * 0.8), self.listGHS[i]))

        if prod[11] is not None and prod[11] != '':
            self.MMProd = container.CanvasListIma.create_text(int(container.wsize * 0.5), int(container.hsize * 0.47),
                                                              text='M: ' + prod[11] + ' g/mol',
                                                              font=AppliFont('Calibri', SizeFont + 4, 'bold', 0),
                                                              anchor=tk.CENTER)

        if prod[12] is not None and prod[12] != '':
            self.dProd = container.CanvasListIma.create_text(int(container.wsize * 0.5), int(container.hsize * 0.57),
                                                             text='d: ' + prod[12],
                                                             font=AppliFont('Calibri', SizeFont + 4, 'bold', 0),
                                                             anchor=tk.CENTER)

    def DeterminListGHS(self, prod):
        listGHS = []
        for i in range(3):
            if prod[i + 3] is not None and prod[i + 3] != '':
                listGHS.append(prod[i + 3])
        self.listGHS = ModifListDanger(listGHS)


class FrmImprimEtiqProd(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, SizeFont, Prod, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.SizeFont = SizeFont
        self.img = None
        self.Img = None
        self.CanvasImg = []
        self.ImgCanvasImg = None
        self.ModifEnCours = 0
        self.ListEntryEtiq = []
        self.MenuPicto = None
        self.ListCanvasGHS = []
        self.NPictoSelected = 0
        self.MenuClicDroit = []
        self.ListNPicto = []

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Menu/Fond.bmp')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX * 1.092)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.005)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.06)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.Titre = LabelInCanvas(self.CanvasFrmFond, 'Etiquettes - ' + Prod, '#E0E0E0',
                                   AppliFont('Helvetica', SizeFont, 'normal', 0), int(self.SX * 0.01),
                                   int(self.SY * 0.004), tk.NW)

        self.CanvasEtiq = CanvasInWindow('Media/FrmEtiq/EtiqProdSolo/', self.RatioX * 3, self.RatioY * 3,
                                         self.CanvasFrmFond, tk.CENTER,
                                         int(self.SX * 0.5),
                                         int(self.SY * 0.18), 0)
        self.CanvasPlancheEtiq = CanvasInWindow('Media/FrmEtiq/EtiqProd/', self.RatioX * 1.5, self.RatioY * 1.5,
                                                self.CanvasFrmFond, tk.CENTER,
                                                int(self.SX * 0.55),
                                                int(self.SY * 0.62), 0)

        self.BtnQuant = BtnPlusMoins(self.CanvasFrmFond, self.RatioX, self.RatioY, 'Quantité:', 8, 0,
                                     SizeFont, 0.03, 0.6, self)
        self.BtnPos = BtnPlusMoins(self.CanvasFrmFond, self.RatioX, self.RatioY, 'Position:', 8, 1,
                                   SizeFont, 0.03, 0.45, self)

        self.BtnOK = BtnAction(self.CanvasFrmFond, int(self.SX * 0.83),
                               int(self.SY * 0.95), self.RatioX * 0.75,
                               self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidEtiq)
        self.BtnAnnul = BtnAction(self.CanvasFrmFond, int(self.SX * 0.90),
                                  int(self.SY * 0.95), self.RatioX * 0.75,
                                  self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulEtiq)

        self.BtnModifEtiq = BtnAction(self.CanvasFrmFond, int(self.SX * 0.95),
                                      int(self.SY * 0.05), self.RatioX * 0.25,
                                      self.RatioX * 0.25, 'Media/FrmEtiq/ModifEtiq/')
        self.BtnModifEtiq.CanvasBtn.bind('<ButtonRelease-1>', self.ModifEtiq)

        self.Prod = self.ChercheProd(Prod)
        self.EtiqProd = EtiqProd(self.CanvasEtiq, self.Prod[0], SizeFont, self.RatioX)

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.pack()

    def GrabEtiq(self):
        x = self.CanvasEtiq.CanvasListIma.winfo_rootx()
        y = self.CanvasEtiq.CanvasListIma.winfo_rooty()
        w = self.CanvasEtiq.CanvasListIma.winfo_width()
        h = self.CanvasEtiq.CanvasListIma.winfo_height()
        image = ImageGrab.grab((x + 5, y + 5, x + w - 5, y + h - 5))
        image.save('Datas/Print/tmp.bmp')
        imgwsize = int(int(self.CanvasPlancheEtiq.CanvasListIma['width']) * 0.46)
        imghsize = int(imgwsize * float(image.size[1]) / float(image.size[0]))
        self.img = image.resize((imgwsize, imghsize), Image.ANTIALIAS)
        self.Img = ImageTk.PhotoImage(self.img)

    def AffichPlancheEtiq(self):
        self.EffaceEtiq()
        self.CanvasImg = []
        if (int(self.BtnPos.Val.Label['text']) % 2) == 0:
            Nl = (int(self.BtnPos.Val.Label['text']) // 2) - 1
            Nc = 1
        else:
            Nl = int(self.BtnPos.Val.Label['text']) // 2
            Nc = 0
        if int(self.BtnPos.Val.Label['text']) + int(self.BtnQuant.Val.Label['text']) > 9:
            self.BtnQuant.Val.Label['text'] = str(9 - int(self.BtnPos.Val.Label['text']))
        for i in range(int(self.BtnQuant.Val.Label['text'])):
            self.CanvasImg.append(CanvasApp(self.CanvasPlancheEtiq.CanvasListIma, width=self.img.size[0],
                                            height=self.img.size[1]))
            self.CanvasPlancheEtiq.CanvasListIma.create_window(int(self.CanvasPlancheEtiq.wsize * (0.038 + Nc * 0.475)),
                                                               int(self.CanvasPlancheEtiq.hsize * (0.048 + Nl * 0.228)),
                                                               anchor=tk.NW, window=self.CanvasImg[i])
            self.ImgCanvasImg = self.CanvasImg[i].create_image(0, 0, anchor=tk.NW, image=self.Img)
            Nc = Nc + 1
            if Nc == 2:
                Nc = 0
                Nl = Nl + 1

    def CallbackPlusMoins(self):
        if int(self.BtnQuant.Val.Label['text']) == 1:
            self.GrabEtiq()
        self.AffichPlancheEtiq()

    def EffaceEtiq(self):
        for widget in self.CanvasPlancheEtiq.CanvasListIma.winfo_children():
            widget.destroy()

    def ValidEtiq(self, _):
        self.BtnOK.CanvasBtn.itemconfig(self.BtnOK.ImgCanvasBtn, image=self.BtnOK.ImgBtn[0])
        if int(self.BtnQuant.Val.Label['text']) > 0:
            CreatePDF('Datas/Print/tmp.bmp', int(self.BtnPos.Val.Label['text']), int(self.BtnQuant.Val.Label['text']),
                      [[0.7, 21.8], [10.8, 21.8], [0.7, 15], [10.8, 15], [0.7, 8.3], [10.8, 8.3], [0.7, 1.5],
                       [10.8, 1.5]],
                      9.5, 6.3, 'Datas/Print/', 'tmp.pdf')
            if self.ModifEnCours == 1:
                Titre = 'Etiquettes personnalisées (100 x 68 mm)'
            else:
                Titre = 'Etiquettes - ' + self.Prod[0][0]
            AffichPDF(Titre, 'Datas/Print/' + 'tmp.pdf', self)
            self.AnnulEtiq(_)
        else:
            tkMB.showwarning('Attention', "Veuillez indiquer la quantité d'étiquettes à imprimer !", parent=self)

    def ModifEtiq(self, _):
        self.ModifEnCours = 1 - self.ModifEnCours
        if self.ModifEnCours == 1:
            self.Titre.Label.config(text='Etiquettes personnalisées (100 x 68 mm)')
            self.BtnModifEtiq.CanvasBtn.itemconfig(self.BtnModifEtiq.ImgCanvasBtn, image=self.BtnModifEtiq.ImgBtn[2])
            self.CanvasEtiq.CanvasListIma.destroy()
            if int(self.BtnQuant.Val.Label['text']) > 0:
                self.EffaceEtiq()
                self.BtnQuant.Val.Label['text'] = 0
            self.EtiqProd = None
            self.CanvasEtiq = CanvasInWindow('Media/FrmEtiq/EtiqProdSolo/', self.RatioX * 3, self.RatioY * 3,
                                             self.CanvasFrmFond, tk.CENTER,
                                             int(self.SX * 0.5),
                                             int(self.SY * 0.18), 0)
            self.CanvasEtiq.CanvasListIma.bind('<Return>', self.ValidModifEtiq)
            self.ListEntryEtiq = []
            self.ListCanvasGHS = []
            self.MenuClicDroit = []
            self.ListNPicto = []
            for i in range(4):
                self.ListEntryEtiq.append(
                    EntryData(self.CanvasEtiq.CanvasListIma, int(self.CanvasEtiq.wsize * 0.08),
                              int(self.CanvasEtiq.wsize * 0.068),
                              int(self.CanvasEtiq.hsize * 0.15 + i * self.CanvasEtiq.hsize * 0.14), tk.W,
                              AppliFont('Helvetica', self.SizeFont + 4, 'bold', 0)))
                self.ListEntryEtiq[i].EntryData.config(justify='center')

                def GestEvt(_, j=i):
                    return self.ValidModifVal(j)

                self.ListEntryEtiq[i].EntryData.bind('<Return>', GestEvt)

            for i in range(3):
                self.ListCanvasGHS.append(
                    CanvasInWindow('Media/FrmEtiq/Picto/', self.RatioX * 0.75, self.RatioX * 0.75,
                                   self.CanvasEtiq.CanvasListIma, tk.CENTER,
                                   int(self.CanvasEtiq.wsize * 0.2) + int(i * self.CanvasEtiq.wsize * 0.3),
                                   int(self.CanvasEtiq.hsize * 0.8), 10))
                self.ListNPicto.append(10)
                ChangeCursor(self.ListCanvasGHS[i].CanvasListIma)

                self.MenuClicDroit.append(tk.Menu(self.ListCanvasGHS[i].CanvasListIma, tearoff=0))

                def GestEvt(_, j=i):
                    return self.ChargePicto(j)

                self.ListCanvasGHS[i].CanvasListIma.bind('<ButtonRelease-1>', GestEvt)

                def GestEvt2(evt, j=i):
                    return self.AffichMenuClicDroit(evt, j)

                self.ListCanvasGHS[i].CanvasListIma.bind("<Button-3>", GestEvt2)
                self.MenuClicDroit[i].add_command(label="Effacer", command=self.EffacerPicto)
        else:
            self.BtnModifEtiq.CanvasBtn.itemconfig(self.BtnModifEtiq.ImgCanvasBtn, image=self.BtnModifEtiq.ImgBtn[0])
            self.CanvasEtiq.CanvasListIma.destroy()
            if int(self.BtnQuant.Val.Label['text']) > 0:
                self.EffaceEtiq()
                self.BtnQuant.Val.Label['text'] = 0
            self.Titre.Label.config(text='Etiquettes - ' + self.Prod[0][0])
            self.CanvasEtiq = CanvasInWindow('Media/FrmEtiq/EtiqProdSolo/', self.RatioX * 3, self.RatioY * 3,
                                             self.CanvasFrmFond, tk.CENTER,
                                             int(self.SX * 0.5),
                                             int(self.SY * 0.18), 0)
            self.EtiqProd = EtiqProd(self.CanvasEtiq, self.Prod[0], self.SizeFont, self.RatioX)

    def EffacerPicto(self):
        if self.ListNPicto[self.NPictoSelected] != 10:
            self.ListCanvasGHS[self.NPictoSelected].CanvasListIma.itemconfig(
                self.ListCanvasGHS[self.NPictoSelected].ImgCanvasListIma,
                image=self.ListCanvasGHS[self.NPictoSelected].ListIma[10])
            self.ListNPicto[self.NPictoSelected] = 10
        else:
            self.ListCanvasGHS[self.NPictoSelected].CanvasListIma.itemconfig(
                self.ListCanvasGHS[self.NPictoSelected].ImgCanvasListIma,
                image=self.ListCanvasGHS[self.NPictoSelected].ListIma[11])
            self.ListNPicto[self.NPictoSelected] = 11
        self.CanvasEtiq.CanvasListIma.focus_set()

    def AffichMenuClicDroit(self, event, j):
        self.MenuClicDroit[j].post(event.x_root, event.y_root)
        self.NPictoSelected = j

    def AnnulEtiq(self, _):
        self.destroy()
        self.MainAppli.FrmImprimEtiqProd = None

    def ClosePDF(self):
        self.MainAppli.MainAppli.parent.focus_force()
        self.MainAppli.MainAppli.FrmLift()
        self.MainAppli.focus_force()

    def ChargePicto(self, j):
        if self.MenuPicto is None:
            self.MenuPicto = MenuPicto(self.CanvasPlancheEtiq.CanvasListIma, 'Media/FrmAjout/MenuPicto/',
                                       int(self.CanvasPlancheEtiq.wsize * 0.99),
                                       int(self.CanvasPlancheEtiq.hsize * 0.99),
                                       int(self.CanvasPlancheEtiq.wsize * 0.5), int(self.CanvasPlancheEtiq.hsize * 0.5),
                                       self.RatioX * 0.7, self.SizeFont - 1, j, self)

    def ValidModifVal(self, j):
        self.ListEntryEtiq[j].EntryData.config(relief='flat')
        self.CanvasEtiq.CanvasListIma.focus_set()

    def ValidModifEtiq(self, _):
        if int(self.BtnQuant.Val.Label['text']) > 0:
            self.GrabEtiq()
            self.AffichPlancheEtiq()

    def ChercheProd(self, Nom):
        ListProds = []
        try:
            self.MainAppli.MainAppli.cur.execute("SELECT " + self.MainAppli.MainAppli.ListChampsTabProd +
                                                 " FROM PRODUITS WHERE NOMS = '" + Nom + "' order by NOMS")
            ListProds = self.MainAppli.MainAppli.cur.fetchall()
        except:
            self.MainAppli.MainAppli.cur.execute('SELECT ' + self.MainAppli.MainAppli.ListChampsTabProd +
                                                 ' FROM PRODUITS WHERE NOMS = \"%' + Nom + '%\" order by NOMS')
            ListProds = self.MainAppli.MainAppli.cur.fetchall()
        finally:
            if len(ListProds) == 0:
                self.MainAppli.MainAppli.cur.execute('SELECT ' + self.MainAppli.MainAppli.ListChampsTabProd +
                                                     ' FROM PRODUITS WHERE NOMS LIKE \"%' + Nom + '%\" order by NOMS')
                ListProds = self.MainAppli.cur.fetchall()
        return ListProds


class MenuPicto:
    def __init__(self, container, path, W, H, X, Y, ratio, sizefont, N, MainAppli):

        self.MainAppli = MainAppli
        self.N = N
        self.CanvasMenuPicto = CanvasMenu(container, path, W, H, X, Y, tk.CENTER)

        self.ListDanger = ['Attention', 'CMR', 'Corrosif', 'Comburant', 'Danger', 'Explosif', 'Inflammable',
                           'Gaz sous pression', "Nocif pour l'environnement", 'Toxique']
        self.CanvasGHS = []
        self.LabelGHS = []
        l = 0
        c = 0
        for i in range(10):
            self.CanvasGHS.append(CanvasInWindow('Media/PictoDanger/', ratio, ratio, self.CanvasMenuPicto.CanvasMenu,
                                                 tk.CENTER, int(W * 0.25 + c * W * 0.48),
                                                 int(H * 0.085 + l * H * 0.19), i))
            self.LabelGHS.append(LabelInCanvas(self.CanvasMenuPicto.CanvasMenu, self.ListDanger[i], '#E0E0E0',
                                               AppliFont('Helvetica', sizefont, 'normal', 0),
                                               int(W * 0.25 + c * W * 0.48),
                                               int(H * 0.18 + l * H * 0.19), tk.CENTER))
            c = c + 1
            if c > 1:
                c = 0
                l = l + 1

            ChangeCursor(self.CanvasGHS[i].CanvasListIma)
            ChangeCursor(self.LabelGHS[i].Label)

            def GestEvt(_, j=i):
                return self.SelectDanger(j)

            self.CanvasGHS[i].CanvasListIma.bind('<ButtonRelease-1>', GestEvt)
            self.LabelGHS[i].Label.bind('<ButtonRelease-1>', GestEvt)

    def SelectDanger(self, j):
        self.CanvasMenuPicto.CanvasMenu.destroy()
        self.MainAppli.ListCanvasGHS[self.N].CanvasListIma.itemconfig(
            self.MainAppli.ListCanvasGHS[self.N].ImgCanvasListIma,
            image=self.MainAppli.ListCanvasGHS[self.N].ListIma[j])
        self.MainAppli.ListNPicto[self.N] = j
        self.MainAppli.MenuPicto = None
        self.MainAppli.CanvasEtiq.CanvasListIma.focus_set()
