from AppliDef import *
from FrmInfoProdMat import Tableau, InfoProd, CaractProd, FrmTabRecap
from datetime import datetime
import re
from EtagProduits import ModifListDanger, ModifFB
from FrmPrepaProdChim import MenuPicto


def ModifNom(Nom):
    if Nom[-1] == "M" or Nom[-1] == "%":
        if Nom[-1] == "M":
            Index = 2
        else:
            Index = 1
        Lnomprod = Nom.split(' ')
        nomprod = Lnomprod[0]
        for i in range(1, len(Lnomprod) - Index):
            nomprod = nomprod + ' ' + Lnomprod[i]
    else:
        nomprod = Nom
    return nomprod


class FrmPrepaSol(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.InfoProd = None
        self.ListSol = []
        self.TabSol = None
        self.NlineSol = 0
        self.BtnTab = None
        self.ListProds = []
        self.CaractProd = None
        self.MenuClicDroitTabSol = []
        self.IndexElt = 0
        self.CanvasFond = None
        self.Fioles = []
        self.VolFioles = [50, 100, 200, 250, 500, 1000, 2000]
        self.CanvasArmoire = None
        self.TitreVol = None
        self.CanvasAgitateur = None
        self.LabelVol = None
        self.TitreMasse = None
        self.CanvasBalance = None
        self.LabelMasse = None
        self.BtnOK = None
        self.BtnAnnul = None
        self.VolSelect = 0
        self.Masse = 0.0
        self.UnitMes = ''
        self.Util = ''
        self.InfoAffich = 0
        self.Solvant = ''
        self.ImgBtnSuiv = None
        self.CanvasBtnSuiv = None
        self.ImgCanvasBtnSuiv = None
        self.ImgBtnSuivProd = None
        self.CanvasBtnSuivProd = None
        self.ImgCanvasBtnSuivProd = None
        self.ImgBtnRetour = None
        self.CanvasBtnRetour = None
        self.ImgCanvasBtnRetour = None
        self.TabRecap = None
        self.ListRecapProdConsom = []
        self.TypePrepa = ''
        self.CanvasFioleMere = None
        self.CanvasFioleFille = None
        self.EntryCSolMere = None
        self.LabelVolSolMere = None
        self.VolSolMere = 0.0
        self.ListMelSol = []
        self.TabMelSol = None
        self.NlineMelSol = 0
        self.ListMelSolvant = []
        self.TabMelSolvant = None
        self.NlineMelSolvant = 0
        self.PrepaEnCours = ''
        self.TabEnCours = ''
        self.Solute = [["", "", "", ""], ["", "", "", ""]]
        self.MenuClicDroitTabMelSol = []
        self.MSolvant = [["", "", ""], ["", "", ""]]
        self.MenuClicDroitTabMelSolvant = []
        self.FrmImprimEtiqSol = None

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        coefY = float(ConfigResolution(self.MainAppli.Nconfig, 'YTitreFrm', self.MainAppli.curSave))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.002)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.031)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.ImgBtnClose, wsize, hsize, self.CanvasBtnClose, self.ImgCanvasBtnClose = CanInWindow(
            'Media/FrmAjout/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER,
            int(self.SX * 0.988), int(self.SY * 0.014), 0)
        ChangeCursor(self.CanvasBtnClose)
        self.CanvasBtnClose.bind('<Motion>',
                                 lambda action: self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose,
                                                                               image=self.ImgBtnClose[1]))
        self.CanvasBtnClose.bind('<ButtonRelease-1>', self.CacheFrmPrepaProd)

        if self.MainAppli.NAction == 3011:
            self.TP = self.MainAppli.ListRecherch[self.MainAppli.IndexElt]
        elif self.MainAppli.NAction == 3022:
            self.TP = self.MainAppli.ListTPCat[self.MainAppli.IndexElt]
        else:
            self.TP = self.MainAppli.ListTPs[self.MainAppli.IndexElt]

        self.LabelTag = LabelInCanvas(self.CanvasFrmFond, self.TP[2] + ' - ' + self.TP[0] +
                                      ' - Préparation des solutions', '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                                      int(self.SX * 0.005), int(self.SY * coefY), tk.NW)

        self.CanvasMenu1 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.965), int(self.SX * 0.003), int(self.SY * 0.031), tk.NW)

        self.CanvasMenu2 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.965), int(self.SX * 0.5), int(self.SY * 0.031), tk.N)

        self.CanvasMenu3 = CanvasMenu(self.CanvasFrmFond, 'Media/FrmAjout/Menu/', int(self.SX * 0.331),
                                      int(self.SY * 0.965), int(self.SX * 0.998), int(self.SY * 0.031), tk.NE)

        self.MainAppli.cur.execute("SELECT " + "SOLUTE, SOLVANT, CONCENTRATION, QUANTITE, SOLUTE2, CONCENTRATION2, "
                                               "SOLVANT2" +
                                   " FROM TP WHERE TITRE = \"" + self.TP[0] + "\" order by SOLUTE")
        ListSol = self.MainAppli.cur.fetchall()

        self.Sol = False
        self.MelangeSol = False
        self.MelangeSolvant = False
        for i in range(len(ListSol)):
            if ListSol[i][4] != '' and ListSol[i][4] is not None:
                self.MelangeSol = True
            if ListSol[i][6] != '' and ListSol[i][6] is not None:
                self.MelangeSolvant = True

        self.AffichSol()
        if len(self.ListSol) > 0:
            self.Sol = True
            self.AffichStock(0)
        else:
            if self.MelangeSol:
                self.ActionAffichMelSol()
                self.AffichStock(0)
            elif self.MelangeSolvant:
                self.ActionAffichMelSolvant()
                self.AffichStock(0)

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.bind('<Button-1>', self.ClicOnCanvas)
        self.CanvasMenu2.CanvasMenu.bind('<Button-1>', self.ClicOnCanvas)
        self.CanvasMenu3.CanvasMenu.bind('<Button-1>', self.ClicOnCanvas)

        self.CanvasFrmFond.pack()

    def AffichSol(self):
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Solutions du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.004), tk.NW)
        self.MainAppli.cur.execute("SELECT " + "SOLUTE, SOLVANT, CONCENTRATION, QUANTITE" +
                                   " FROM TP WHERE TITRE = \"" + self.TP[0] + "\" order by SOLUTE")
        ListSols = self.MainAppli.cur.fetchall()
        self.ListSol = []
        for i in range(len(ListSols)):
            if ListSols[i][0] != '' and ListSols[i][0] is not None and ListSols[i][1] != '' \
                    and ListSols[i][1] is not None:
                self.ListSol.append(ListSols[i])

        self.TabSol = Tableau(self.CanvasMenu1.CanvasMenu, len(self.ListSol), 4,
                              ['Soluté', 'SOLVANT', 'C (mol/L)', 'Q/Gr (mL)'],
                              [0.061, 0.02, 0.02, 0.018],
                              AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                              AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)

        nl = 0
        self.NlineSol = len(self.ListSol)
        for i in range(len(self.ListSol)):
            for j in range(4):
                self.TabSol.TabLabels[nl][j]['text'] = self.ListSol[i][j]
                if nl == 0:
                    self.TabSol.TabLabels[nl][j].config(bg='#E0E0E0')
            nl = nl + 1

        self.BtnTab = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.975),
                                int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.014), self.RatioX * 0.6,
                                self.RatioX * 0.6, 'Media/FrmPrepaTPChimie/BtnTab/')

        self.BtnTab.CanvasBtn.bind('<ButtonRelease-1>', self.AffichTabRecap)
        if self.MelangeSol or self.MelangeSolvant:
            self.ImgBtnSuiv, wsize, hsize, self.CanvasBtnSuiv, self.ImgCanvasBtnSuiv = CanInWindow(
                'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu1.CanvasMenu, tk.CENTER,
                int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.93),
                int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.015), 0)
            ChangeCursor(self.CanvasBtnSuiv)
            if self.MelangeSol:
                self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSol)
            else:
                self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSolvant)

        self.TabEnCours = "Sol"
        self.AjoutMenuSol()

    def AffichMelSol(self, _):
        self.ActionAffichMelSol()
        self.AffichStock(0)

    def ActionAffichMelSol(self):
        self.EffaceMenuMain()
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Mélange de solutions aqueuses du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.004), tk.NW)

        self.MainAppli.cur.execute("SELECT " + "SOLUTE, CONCENTRATION, SOLUTE2, CONCENTRATION2, QUANTITE" +
                                   " FROM TP WHERE TITRE = \"" + self.TP[0] + "\" order by SOLUTE")
        ListMelSols = self.MainAppli.cur.fetchall()

        self.ListMelSol = []
        for i in range(len(ListMelSols)):
            if ListMelSols[i][0] != '' and ListMelSols[i][0] is not None and ListMelSols[i][2] != '' \
                    and ListMelSols[i][2] is not None:
                self.ListMelSol.append(ListMelSols[i])
        self.TabMelSol = Tableau(self.CanvasMenu1.CanvasMenu, len(self.ListMelSol), 5,
                                 ['Soluté 1', 'C1 (mol/L)', 'Soluté 2', 'C2 (mol/L)', 'Q/Gr (mL)'],
                                 [0.03, 0.02, 0.03, 0.02, 0.018],
                                 AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                 AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)

        nl = 0
        self.NlineMelSol = len(self.ListMelSol)
        for i in range(len(self.ListMelSol)):
            for j in range(5):
                self.TabMelSol.TabLabels[nl][j]['text'] = self.ListMelSol[i][j]
                if nl == 0:
                    self.TabMelSol.TabLabels[nl][j].config(bg='#E0E0E0')
            nl = nl + 1

        self.BtnTab = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.975),
                                int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.014), self.RatioX * 0.6,
                                self.RatioX * 0.6, 'Media/FrmPrepaTPChimie/BtnTab/')
        self.BtnTab.CanvasBtn.bind('<ButtonRelease-1>', self.AffichTabRecap)

        if not self.MelangeSolvant:
            if self.Sol:
                self.ImgBtnSuiv, wsize, hsize, self.CanvasBtnSuiv, self.ImgCanvasBtnSuiv = CanInWindow(
                    'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu1.CanvasMenu, tk.CENTER,
                    int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.93),
                    int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.015), 1)
                ChangeCursor(self.CanvasBtnSuiv)
                self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.ActionAffichSol)
        else:
            self.ImgBtnSuiv, wsize, hsize, self.CanvasBtnSuiv, self.ImgCanvasBtnSuiv = CanInWindow(
                'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu1.CanvasMenu, tk.CENTER,
                int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.93),
                int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.015), 0)
            ChangeCursor(self.CanvasBtnSuiv)
            self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSolvant)
            if self.Sol:
                self.ImgBtnRetour, wsize, hsize, self.CanvasBtnRetour, self.ImgCanvasBtnRetour = CanInWindow(
                    'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu1.CanvasMenu, tk.CENTER,
                    int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.9),
                    int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.015), 1)
                ChangeCursor(self.CanvasBtnRetour)
                self.CanvasBtnRetour.bind('<ButtonRelease-1>', self.ActionAffichSol)

        self.TabEnCours = "MelSol"
        self.AjoutMenuMelSol()

    def ActionAffichSol(self, _):
        self.EffaceMenuMain()
        self.AffichSol()
        self.AffichStock(0)

    def AffichMelSolvant(self, _):
        self.ActionAffichMelSolvant()
        self.AffichStock(0)

    def ActionAffichMelSolvant(self):
        self.EffaceMenuMain()
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, 'Mélange de solvants du TP', '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.004), tk.NW)

        self.MainAppli.cur.execute("SELECT " + "SOLVANT, CONCENTRATION, SOLVANT2, CONCENTRATION2, QUANTITE" +
                                   " FROM TP WHERE TITRE = \"" + self.TP[0] + "\" order by SOLUTE")
        ListMelSolvants = self.MainAppli.cur.fetchall()

        self.ListMelSolvant = []
        for i in range(len(ListMelSolvants)):
            if ListMelSolvants[i][0] != '' and ListMelSolvants[i][0] is not None and ListMelSolvants[i][2] != '' \
                    and ListMelSolvants[i][2] is not None:
                self.ListMelSolvant.append(ListMelSolvants[i])
        self.TabMelSolvant = Tableau(self.CanvasMenu1.CanvasMenu, len(self.ListMelSolvant), 5,
                                     ['Solvant 1', 'C1 (% vol.)', 'Solvant 2', 'C2 (% vol.)', 'Q/Gr (mL)'],
                                     [0.03, 0.02, 0.03, 0.02, 0.018],
                                     AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                                     AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0), self)

        nl = 0
        self.NlineMelSolvant = len(self.ListMelSolvant)
        for i in range(len(self.ListMelSolvant)):
            for j in range(5):
                self.TabMelSolvant.TabLabels[nl][j]['text'] = self.ListMelSolvant[i][j]
                if nl == 0:
                    self.TabMelSolvant.TabLabels[nl][j].config(bg='#E0E0E0')
            nl = nl + 1

        self.BtnTab = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.975),
                                int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.014), self.RatioX * 0.6,
                                self.RatioX * 0.6, 'Media/FrmPrepaTPChimie/BtnTab/')
        self.BtnTab.CanvasBtn.bind('<ButtonRelease-1>', self.AffichTabRecap)

        if self.MelangeSol or self.Sol:
            self.ImgBtnSuiv, wsize, hsize, self.CanvasBtnSuiv, self.ImgCanvasBtnSuiv = CanInWindow(
                'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu1.CanvasMenu, tk.CENTER,
                int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.93),
                int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.015), 1)
            ChangeCursor(self.CanvasBtnSuiv)
            if self.MelangeSol:
                self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.AffichMelSol)
            elif self.Sol:
                self.CanvasBtnSuiv.bind('<ButtonRelease-1>', self.ActionAffichSol)

        self.TabEnCours = "MelSolvant"
        self.AjoutMenuMelSolvant()

    def AffichStock(self, IndexElt):
        self.EffaceMenus()
        TitreMenu1 = ""
        TitreMenu2 = ""
        Prod = ""

        if self.TabEnCours == "Sol":
            Prod = self.ListSol[IndexElt][0]
            if self.ListSol[IndexElt][1] != "Eau":
                self.ImgBtnSuivProd, wsize, hsize, self.CanvasBtnSuivProd, self.ImgCanvasBtnSuivProd = CanInWindow(
                    'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu2.CanvasMenu, tk.CENTER,
                    int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.98),
                    int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.015), 0)
                ChangeCursor(self.CanvasBtnSuivProd)
                self.CanvasBtnSuivProd.bind('<ButtonRelease-1>', self.InfoSuiv)
                TitreMenu1 = 'Stock / Fournisseur du soluté'
                TitreMenu2 = 'Informations sur le soluté'
            else:
                TitreMenu1 = 'Stock / Fournisseur du produit chimique sélectionné'
                TitreMenu2 = 'Informations sur le produit chimique sélectionné'
        elif self.TabEnCours == "MelSol":
            Prod = self.ListMelSol[IndexElt][0]
            TitreMenu1 = 'Stock / Fournisseur du soluté 1'
            TitreMenu2 = 'Informations sur le soluté 1'
            self.ImgBtnSuivProd, wsize, hsize, self.CanvasBtnSuivProd, self.ImgCanvasBtnSuivProd = CanInWindow(
                'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu2.CanvasMenu, tk.CENTER,
                int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.98),
                int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.015), 0)
            ChangeCursor(self.CanvasBtnSuivProd)
            self.CanvasBtnSuivProd.bind('<ButtonRelease-1>', self.InfoSuiv)
        elif self.TabEnCours == "MelSolvant":
            Prod = self.ListMelSolvant[IndexElt][0]
            TitreMenu1 = 'Stock / Fournisseur du solvant 1'
            TitreMenu2 = 'Informations sur le solvant 1'
            self.ImgBtnSuivProd, wsize, hsize, self.CanvasBtnSuivProd, self.ImgCanvasBtnSuivProd = CanInWindow(
                'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu2.CanvasMenu, tk.CENTER,
                int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.98),
                int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.015), 0)
            ChangeCursor(self.CanvasBtnSuivProd)
            self.CanvasBtnSuivProd.bind('<ButtonRelease-1>', self.InfoSuiv)

        LabelInCanvas(self.CanvasMenu2.CanvasMenu, TitreMenu1, '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.004), tk.NW)
        LabelInCanvas(self.CanvasMenu3.CanvasMenu, TitreMenu2, '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                      int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.004), tk.NW)

        self.ListProds = self.ChercheProd(Prod)

        if len(self.ListProds) > 0:
            self.InfoProd = InfoProd(self.CanvasMenu2.CanvasMenu, self.ListProds[0],
                                     self.MainAppli.cur, self.MainAppli.SizeFont, self.RatioX,
                                     self.RatioY, 1)
            self.CaractProd = CaractProd(self.CanvasMenu3.CanvasMenu, self.ListProds[0],
                                         self.MainAppli.SizeFont, self.RatioX, self.RatioY)

    def InfoSuiv(self, _):
        self.InfoAffich = 1 - self.InfoAffich
        Prod = ""
        TitreMenu1 = ""
        TitreMenu2 = ""

        if self.TabEnCours == "Sol":
            if self.InfoAffich == 1:
                Prod = self.ListSol[self.IndexElt][1]
                TitreMenu1 = 'Stock / Fournisseur du solvant'
                TitreMenu2 = 'Informations sur le solvant'
            else:
                Prod = self.ListSol[self.IndexElt][0]
                TitreMenu1 = 'Stock / Fournisseur du soluté'
                TitreMenu2 = 'Informations sur le soluté'
        elif self.TabEnCours == "MelSol":
            if self.InfoAffich == 1:
                Prod = self.ListMelSol[self.IndexElt][2]
                TitreMenu1 = 'Stock / Fournisseur du soluté 2'
                TitreMenu2 = 'Informations sur le soluté 2'
            else:
                Prod = self.ListMelSol[self.IndexElt][0]
                TitreMenu1 = 'Stock / Fournisseur du soluté 1'
                TitreMenu2 = 'Informations sur le soluté 1'
        elif self.TabEnCours == "MelSolvant":
            if self.InfoAffich == 1:
                Prod = self.ListMelSolvant[self.IndexElt][2]
                TitreMenu1 = 'Stock / Fournisseur du solvant 2'
                TitreMenu2 = 'Informations sur le solvant 2'
            else:
                Prod = self.ListMelSolvant[self.IndexElt][0]
                TitreMenu1 = 'Stock / Fournisseur du solvant 1'
                TitreMenu2 = 'Informations sur le solvant 1'

        self.ListProds = self.ChercheProd(Prod)
        if len(self.ListProds) > 0:
            self.EffaceMenus()
            self.ImgBtnSuivProd, wsize, hsize, self.CanvasBtnSuivProd, self.ImgCanvasBtnSuivProd = CanInWindow(
                'Media/FrmMain/BtnSuiv/', self.RatioX, self.RatioY, self.CanvasMenu2.CanvasMenu, tk.CENTER,
                int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.98),
                int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.015), 0)
            ChangeCursor(self.CanvasBtnSuivProd)
            self.CanvasBtnSuivProd.bind('<ButtonRelease-1>', self.InfoSuiv)
            self.CanvasBtnSuivProd.itemconfig(self.ImgCanvasBtnSuivProd, image=self.ImgBtnSuivProd[self.InfoAffich])

            LabelInCanvas(self.CanvasMenu2.CanvasMenu, TitreMenu1, '#E0E0E0',
                          AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                          int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                          int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.004), tk.NW)
            LabelInCanvas(self.CanvasMenu3.CanvasMenu, TitreMenu2, '#E0E0E0',
                          AppliFont('Helvetica', self.MainAppli.SizeFont, 'normal', 0),
                          int(int(self.CanvasMenu3.CanvasMenu['width']) * 0.01),
                          int(int(self.CanvasMenu3.CanvasMenu['height']) * 0.004), tk.NW)

            self.InfoProd = InfoProd(self.CanvasMenu2.CanvasMenu, self.ListProds[0],
                                     self.MainAppli.cur, self.MainAppli.SizeFont, self.RatioX,
                                     self.RatioY, 1)
            self.CaractProd = CaractProd(self.CanvasMenu3.CanvasMenu, self.ListProds[0],
                                         self.MainAppli.SizeFont, self.RatioX, self.RatioY)

            if self.PrepaEnCours == 'MelSol':
                if self.ListProds[0][0][-1:] != "M" and self.ListProds[0][0][-1:] != "%":
                    self.TypePrepa = 'Dissolution'
                    if self.LabelMasse is not None:
                        self.CalculMasse()
                    elif self.LabelVolSolMere is not None:
                        self.CanvasMenu1.CanvasMenu.delete(self.TitreVol)
                        self.LabelVolSolMere.Label.destroy()
                        self.LabelVolSolMere = None
                        self.AffichBalance()
                        self.CalculMasse()
                else:
                    self.TypePrepa = 'DilutionSolCom'
                    if self.LabelVolSolMere is not None:
                        self.CalculVolSolCom()
                    elif self.LabelMasse is not None:
                        self.CanvasMenu1.CanvasMenu.delete(self.TitreMasse)
                        self.LabelMasse.Label.destroy()
                        self.LabelMasse = None
                        self.AffichSolCom()
                        self.CalculVolSolCom()
            elif self.PrepaEnCours == 'MelSolvant':
                self.CalculVolSolvant()
        if self.FrmImprimEtiqSol is not None:
            self.FrmImprimEtiqSol.lift()

    def ChercheProd(self, Nom):
        ListProds = []
        try:
            self.MainAppli.cur.execute("SELECT " + self.MainAppli.ListChampsTabProd +
                                       " FROM PRODUITS WHERE NOMS = '" + Nom + "' order by NOMS")
            ListProds = self.MainAppli.cur.fetchall()
        except:
            self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabProd +
                                       ' FROM PRODUITS WHERE NOMS LIKE \'%' + Nom + '%\' order by NOMS')
            ListProds = self.MainAppli.cur.fetchall()
        finally:
            if len(ListProds) == 0:
                self.MainAppli.cur.execute('SELECT ' + self.MainAppli.ListChampsTabProd +
                                           ' FROM PRODUITS WHERE NOMS LIKE \'%' + Nom + '%\' order by NOMS')
                ListProds = self.MainAppli.cur.fetchall()
        return ListProds

    def AjoutMenuSol(self):
        self.MenuClicDroitTabSol = []
        for r in range(self.NlineSol):
            ListMenu = []
            for i in range(3):
                ListMenu.append(tk.Menu(self.TabSol.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabSol, j)

                self.TabSol.TabLabels[r][i].bind("<Button-3>", GestEvt)

                def GestEvt2(evt, j=r):
                    return self.PrepaTPDoubleClic(evt, j)

                self.TabSol.TabLabels[r][i].bind("<Double-2>", GestEvt2)

            self.MenuClicDroitTabSol.append(ListMenu)

        for r in range(self.TabSol.NLine):
            if self.TabSol.TabLabels[r][0]['text'][-1:] != "M" and self.TabSol.TabLabels[r][0]['text'][-1:] != "%":
                self.ListProds = self.ChercheProd(self.TabSol.TabLabels[r][0]['text'])
                if self.ListProds[0][12] is not None and self.ListProds[0][12] != '':
                    self.MenuClicDroitTabSol[r][0].add_command(label="Préparation par dilution solution commerciale",
                                                               command=self.ActionDilutionSolCom)
                else:
                    self.MenuClicDroitTabSol[r][0].add_command(label="Préparation par dissolution",
                                                               command=self.ActionDissol)

            else:
                self.MenuClicDroitTabSol[r][0].add_command(label="Préparation par dilution solution commerciale",
                                                           command=self.ActionDilutionSolCom)
            self.MenuClicDroitTabSol[r][0].add_command(label="Préparation par dilution",
                                                       command=self.ActionDilution)
            self.MenuClicDroitTabSol[r][0].add_separator()
            self.MenuClicDroitTabSol[r][0].add_command(label="Imprimer une étiquette", command=self.AffichFrmImprim)

    def AjoutMenuMelSol(self):
        self.MenuClicDroitTabMelSol = []
        for r in range(self.NlineMelSol):
            ListMenu = []
            for i in range(5):
                ListMenu.append(tk.Menu(self.TabMelSol.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabMelSol, j)

                self.TabMelSol.TabLabels[r][i].bind("<Button-3>", GestEvt)

                def GestEvt2(evt, j=r):
                    return self.PrepaTPDoubleClic(evt, j)

                self.TabMelSol.TabLabels[r][i].bind("<Double-2>", GestEvt2)

            self.MenuClicDroitTabMelSol.append(ListMenu)

        for r in range(self.TabMelSol.NLine):
            self.MenuClicDroitTabMelSol[r][0].add_command(label="Préparer le mélange",
                                                          command=self.ActionPrepaMelSol)
            self.MenuClicDroitTabMelSol[r][0].add_separator()
            self.MenuClicDroitTabMelSol[r][0].add_command(label="Imprimer une étiquette", command=self.AffichFrmImprim)

    def AjoutMenuMelSolvant(self):
        self.MenuClicDroitTabMelSolvant = []
        for r in range(self.NlineMelSolvant):
            ListMenu = []
            for i in range(5):
                ListMenu.append(tk.Menu(self.TabMelSolvant.TabLabels[r][i], tearoff=0))

                def GestEvt(evt, j=r):
                    return self.AffichMenuClicDroit(evt, self.MenuClicDroitTabMelSolvant, j)

                self.TabMelSolvant.TabLabels[r][i].bind("<Button-3>", GestEvt)

                def GestEvt2(evt, j=r):
                    return self.PrepaTPDoubleClic(evt, j)

                self.TabMelSolvant.TabLabels[r][i].bind("<Double-2>", GestEvt2)

            self.MenuClicDroitTabMelSolvant.append(ListMenu)

        for r in range(self.TabMelSolvant.NLine):
            self.MenuClicDroitTabMelSolvant[r][0].add_command(label="Préparer le mélange",
                                                              command=self.ActionPrepaMelSolvant)
            self.MenuClicDroitTabMelSolvant[r][0].add_separator()
            self.MenuClicDroitTabMelSolvant[r][0].add_command(label="Imprimer une étiquette",
                                                              command=self.AffichFrmImprim)

    def AffichMenuClicDroit(self, event, MenuClicDroitProd, j):
        MenuClicDroitProd[j][0].post(event.x_root, event.y_root)
        self.IndexElt = j

    def ActionDissol(self):
        self.VolSelect = 0
        self.TypePrepa = 'Dissolution'
        self.UnitMes = 'g'
        self.AffichStock(self.IndexElt)
        self.PrepaSol(self.IndexElt, 'Dissolution')

    def ActionDilution(self):
        self.VolSelect = 0
        self.TypePrepa = 'Dilution'
        self.AffichStock(self.IndexElt)
        self.PrepaSol(self.IndexElt, 'Dilution')

    def ActionDilutionSolCom(self):
        self.VolSelect = 0
        self.UnitMes = 'mL'
        self.TypePrepa = 'DilutionSolCom'
        self.AffichStock(self.IndexElt)
        self.PrepaSol(self.IndexElt, 'DilutionSolCom')

    def ActionPrepaMelSol(self):
        self.VolSelect = 0
        self.AffichStock(self.IndexElt)
        self.PrepaMelSol(self.IndexElt)

    def ActionPrepaMelSolvant(self):
        self.VolSelect = 0
        self.AffichStock(self.IndexElt)
        self.PrepaMelSolvant(self.IndexElt)

    def AffichArmoireFioles(self):
        self.CanvasArmoire = CanvasInWindow('Media/FrmPrepaTPChimie/FondSol/', self.RatioX * 0.8, self.RatioY * 0.8,
                                            self.CanvasMenu1.CanvasMenu, tk.NW,
                                            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.03),
                                            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.08), 0)
        self.Fioles = []
        self.Fioles.append(BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.2),
                                     int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.3), self.RatioX * 0.8,
                                     self.RatioY * 0.8, 'Media/FrmPrepaTPChimie/Fiole50/'))
        self.Fioles.append(BtnAction(self.CanvasMenu1.CanvasMenu,
                                     int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.314),
                                     int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.294), self.RatioX * 0.8,
                                     self.RatioY * 0.8, 'Media/FrmPrepaTPChimie/Fiole100/'))
        self.Fioles.append(BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.43),
                                     int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.288), self.RatioX * 0.8,
                                     self.RatioY * 0.8, 'Media/FrmPrepaTPChimie/Fiole200/'))
        self.Fioles.append(BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.21),
                                     int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.438), self.RatioX * 0.8,
                                     self.RatioY * 0.8, 'Media/FrmPrepaTPChimie/Fiole250/'))
        self.Fioles.append(BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.42),
                                     int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.425), self.RatioX * 0.8,
                                     self.RatioY * 0.8, 'Media/FrmPrepaTPChimie/Fiole500/'))
        self.Fioles.append(BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.21),
                                     int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.598), self.RatioX * 0.8,
                                     self.RatioY * 0.8, 'Media/FrmPrepaTPChimie/Fiole1000/'))
        self.Fioles.append(BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.42),
                                     int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.59), self.RatioX * 0.8,
                                     self.RatioY * 0.8, 'Media/FrmPrepaTPChimie/Fiole2000/'))

        for i in range(len(self.Fioles)):
            def GestEvt(_, j=i):
                return self.SelectVolume(j)

            self.Fioles[i].CanvasBtn.bind('<ButtonRelease-1>', GestEvt)

        self.TitreVol = self.CanvasMenu1.CanvasMenu.create_text(
            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.65),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.12), text='Volume à préparer:',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.CanvasAgitateur = CanvasInWindow(
            'Media/FrmPrepaTPChimie/Agitateur/', self.RatioX * 1.2, self.RatioY * 1.2,
            self.CanvasMenu1.CanvasMenu, tk.CENTER, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.78),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.28), 0)

        self.LabelVol = LabelInCanvas(self.CanvasMenu1.CanvasMenu, "", '#E0E0E0',
                                      AppliFont('Helvetica', self.MainAppli.SizeFont + 4, 'bold', 0),
                                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.78),
                                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.45), tk.CENTER)
        self.LabelVol.Label.config(fg='blue')

    def AffichBalance(self):
        self.TitreMasse = self.CanvasMenu1.CanvasMenu.create_text(
            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.65),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.55), text='Masse à peser:',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

        self.CanvasBalance = CanvasInWindow('Media/FrmPrepaTPChimie/Balance/', self.RatioX * 1.2, self.RatioY * 1.2,
                                            self.CanvasMenu1.CanvasMenu, tk.CENTER,
                                            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.78),
                                            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.68), 0)

        self.LabelMasse = LabelInCanvas(self.CanvasMenu1.CanvasMenu, "", '#E0E0E0',
                                        AppliFont('Helvetica', self.MainAppli.SizeFont + 4, 'bold', 0),
                                        int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.78),
                                        int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.78), tk.CENTER)
        self.LabelMasse.Label.config(fg='blue')

    def AffichSolCom(self):
        self.TitreVol = self.CanvasMenu1.CanvasMenu.create_text(
            int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.65),
            int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.55), text='Volume à prélever:',
            font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)
        self.CanvasFioleMere = CanvasInWindow('Media/FrmPrepaTPChimie/SolCOM/', self.RatioX * 1.3,
                                              self.RatioY * 1.3,
                                              self.CanvasMenu1.CanvasMenu, tk.CENTER,
                                              int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.78),
                                              int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.68), 0)
        self.LabelVolSolMere = LabelInCanvas(self.CanvasMenu1.CanvasMenu, "", '#E0E0E0',
                                             AppliFont('Helvetica', self.MainAppli.SizeFont + 4, 'bold', 0),
                                             int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.78),
                                             int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.78), tk.CENTER)
        self.LabelVolSolMere.Label.config(fg='blue')

    def AffichBtnValid(self):
        self.BtnOK = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.83),
                               int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                               self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidPrepa)
        self.BtnAnnul = BtnAction(self.CanvasMenu1.CanvasMenu, int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.90),
                                  int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.95), self.RatioX * 0.75,
                                  self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulPrepa)

    def PrepaTPDoubleClic(self, _, j):
        self.PrepaTP(j)

    def PrepaTP(self, IndexElt):
        if self.TabEnCours == "MelSol":
            self.IndexElt = IndexElt
            self.PrepaMelSol(IndexElt)
            self.AffichStock(IndexElt)
        elif self.TabEnCours == "MelSolvant":
            self.IndexElt = IndexElt
            self.PrepaMelSolvant(IndexElt)
            self.AffichStock(IndexElt)
        elif self.TabEnCours == "Sol":
            self.IndexElt = IndexElt
            if self.TabSol.TabLabels[IndexElt][0]['text'][-1:] != "M" and \
                    self.TabSol.TabLabels[IndexElt][0]['text'][-1:] != "%":
                self.ActionDissol()
            else:
                self.ActionDilutionSolCom()

    def PrepaMelSol(self, IndexElt):
        self.PrepaEnCours = "MelSol"
        self.EffaceMenuMain()
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, "Préparation mélange de solutions aqueuses", '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.004), tk.NW)

        STitre = self.ListMelSol[IndexElt][0] + ' - ' + self.ListMelSol[IndexElt][1] + ' mol/L\n' + self.ListMelSol[
            IndexElt][2] + ' - ' + self.ListMelSol[IndexElt][3] + ' mol/L'
        self.Util = 'MelSolAq'
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, STitre, '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.03), tk.NW)

        self.AffichArmoireFioles()
        if self.ListMelSol[IndexElt][0][-1:] != "M" and self.ListMelSol[IndexElt][0][-1:] != "%":
            self.TypePrepa = 'Dissolution'
            self.AffichBalance()
        else:
            self.TypePrepa = 'DilutionSolCom'
            self.AffichSolCom()

        self.AffichBtnValid()

    def PrepaMelSolvant(self, IndexElt):
        self.PrepaEnCours = "MelSolvant"
        self.EffaceMenuMain()
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, "Préparation mélange de solvants", '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.004), tk.NW)

        STitre = self.ListMelSolvant[IndexElt][0] + ' - ' + self.ListMelSolvant[
            IndexElt][1] + ' % vol.\n' + self.ListMelSolvant[IndexElt][2] + ' - ' + self.ListMelSolvant[
                     IndexElt][3] + ' % vol.'
        self.Util = 'MelSolv'
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, STitre, '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.03), tk.NW)

        self.AffichArmoireFioles()
        self.TypePrepa = 'MelSolvant'
        self.AffichSolCom()

        self.AffichBtnValid()

    def PrepaSol(self, IndexElt, Type):
        self.PrepaEnCours = "Sol"
        self.EffaceMenuMain()
        if self.ListSol[IndexElt][1] == "Eau":
            Titre = 'Préparation solution aqueuse - ' + self.ListSol[IndexElt][0] + ' - ' + self.ListSol[IndexElt][
                2] + ' mol/L'
            self.Util = 'SolAq'
        else:
            Titre = 'Préparation solution dans ' + self.ListSol[IndexElt][1] + ' - ' + self.ListSol[IndexElt][
                0] + ' - ' + self.ListSol[IndexElt][2] + ' mol/L'
            self.Util = 'SolNonAq'
        self.Solvant = self.ListSol[IndexElt][1]
        LabelInCanvas(self.CanvasMenu1.CanvasMenu, Titre, '#E0E0E0',
                      AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                      int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.01),
                      int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.004), tk.NW)

        self.AffichArmoireFioles()

        if Type == "Dissolution":
            self.AffichBalance()

        elif Type == "Dilution":
            self.TitreMasse = self.CanvasMenu1.CanvasMenu.create_text(
                int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.65),
                int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.55), text='Volume à prélever:',
                font=AppliFont('Helvetica', self.MainAppli.SizeFont + 2, 'bold', 1), anchor=tk.W)

            self.CanvasFioleMere = CanvasInWindow('Media/FrmPrepaTPChimie/SolMere/', self.RatioX * 1.3,
                                                  self.RatioY * 1.3,
                                                  self.CanvasMenu1.CanvasMenu, tk.CENTER,
                                                  int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.7),
                                                  int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.68), 0)
            self.CanvasFioleFille = CanvasInWindow('Media/FrmPrepaTPChimie/FioleFille/', self.RatioX * 0.78,
                                                   self.RatioY * 0.78,
                                                   self.CanvasMenu1.CanvasMenu, tk.CENTER,
                                                   int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.9),
                                                   int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.68), 0)
            LabelInCanvas(self.CanvasMenu1.CanvasMenu, "Concentration\nSolution mère (mol/L):", '#F7F7F7',
                          AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0),
                          int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.7),
                          int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.8), tk.CENTER)

            self.EntryCSolMere = EntryData(self.CanvasMenu1.CanvasMenu,
                                           int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.02),
                                           int(int(self.CanvasMenu1.CanvasMenu['width']) * 0.7),
                                           int(int(self.CanvasMenu1.CanvasMenu['height']) * 0.85), tk.CENTER,
                                           AppliFont('Helvetica', self.MainAppli.SizeFont, 'bold', 0))
            self.EntryCSolMere.Data.set('')
            self.EntryCSolMere.EntryData.config(justify='center')
            self.EntryCSolMere.EntryData.bind('<KeyRelease>', self.ActionCalculVolSolMere)
            self.LabelVolSolMere = LabelInCanvas(self.CanvasMenu1.CanvasMenu, "", '#E0E0E0',
                                                 AppliFont('Helvetica', self.MainAppli.SizeFont + 4, 'bold', 0),
                                                 int(int(self.CanvasMenu2.CanvasMenu['width']) * 0.9),
                                                 int(int(self.CanvasMenu2.CanvasMenu['height']) * 0.85), tk.CENTER)
            self.LabelVolSolMere.Label.config(fg='blue')

        elif Type == "DilutionSolCom":
            self.AffichSolCom()

        self.AffichBtnValid()

    def SelectVolume(self, j):
        self.CanvasAgitateur.CanvasListIma.itemconfig(self.CanvasAgitateur.ImgCanvasListIma,
                                                      image=self.CanvasAgitateur.ListIma[j + 1])
        self.LabelVol.Label['text'] = str(self.VolFioles[j]) + ' mL'
        self.VolSelect = self.VolFioles[j]
        if self.TypePrepa == 'Dissolution':
            self.CalculMasse()
        elif self.TypePrepa == 'Dilution':
            self.CalculVolSolMere()
        elif self.TypePrepa == 'DilutionSolCom':
            self.CalculVolSolCom()
        elif self.TypePrepa == 'MelSolvant':
            self.CalculVolSolvant()
        if self.PrepaEnCours == "MelSol" or self.PrepaEnCours == "MelSolvant":
            self.InfoSuiv(j)

    def CalculMasse(self):
        if self.VolSelect != 0:
            C = ""
            Prod = ""
            if self.PrepaEnCours == "Sol":
                C = self.ListSol[self.IndexElt][2]
            elif self.PrepaEnCours == "MelSol":
                if self.InfoAffich == 1:
                    C = self.ListMelSol[self.IndexElt][3]
                    Prod = self.ListMelSol[self.IndexElt][2]
                else:
                    C = self.ListMelSol[self.IndexElt][1]
                    Prod = self.ListMelSol[self.IndexElt][0]
            self.Masse = float(C.replace(',', '.')) * self.VolSelect / 1000 * float(
                self.ListProds[0][11].replace(',', '.'))
            self.LabelMasse.Label['text'] = str(round(self.Masse, 3)).replace('.', ',') + ' g'
            if self.PrepaEnCours == "MelSol":
                self.Solute[self.InfoAffich] = [Prod, C, self.Masse, 'g']

    def ActionCalculVolSolMere(self, _):
        self.CalculVolSolMere()

    def CalculVolSolMere(self):
        if self.VolSelect != 0:
            try:
                self.VolSolMere = float(self.ListSol[self.IndexElt][2].replace(',', '.')) * \
                                  self.VolSelect / float(self.EntryCSolMere.Data.get().replace(',', '.'))
                if self.VolSolMere < self.VolSelect:
                    self.LabelVolSolMere.Label['text'] = str(round(self.VolSolMere, 3)).replace('.', ',') + ' mL'
                else:
                    self.LabelVolSolMere.Label['text'] = ''
            except:
                self.LabelVolSolMere.Label['text'] = ''

    def CalculVolSolvant(self):
        if self.VolSelect != 0:
            if self.InfoAffich == 1:
                Prod = self.ListMelSolvant[self.IndexElt][2]
                C = self.ListMelSolvant[self.IndexElt][3]
            else:
                Prod = self.ListMelSolvant[self.IndexElt][0]
                C = self.ListMelSolvant[self.IndexElt][1]
            self.VolSolMere = self.VolSelect * float(C.replace(',', '.')) / 100
            self.LabelVolSolMere.Label['text'] = str(round(self.VolSolMere, 3)).replace('.', ',') + ' mL'
            if self.PrepaEnCours == "MelSolvant":
                self.MSolvant[self.InfoAffich] = [Prod, C, self.VolSolMere]

    def CalculVolSolCom(self):
        if self.VolSelect != 0 and len(self.ListProds) > 0:
            Cf = ""
            Prod = ""
            if self.PrepaEnCours == "Sol":
                Prod = self.ListSol[self.IndexElt][0]
                Cf = self.ListSol[self.IndexElt][2]
            elif self.PrepaEnCours == "MelSol":
                if self.InfoAffich == 1:
                    Prod = self.ListMelSol[self.IndexElt][2]
                    Cf = self.ListMelSol[self.IndexElt][3]
                else:
                    Prod = self.ListMelSol[self.IndexElt][0]
                    Cf = self.ListMelSol[self.IndexElt][1]
            if Prod[-1:] == "M":
                Cm = [float(s) for s in re.findall(r'-?\d+\.?\d*', Prod)][0]
                self.VolSolMere = float(Cf.replace(',', '.')) * self.VolSelect / Cm
            elif Prod[-1:] == "%":
                t = [float(s) for s in re.findall(r'-?\d+\.?\d*', Prod)][0] / 100
                self.VolSolMere = float(Cf.replace(',', '.')) * (self.VolSelect / 1000) * float(
                    self.ListProds[0][11].replace(',', '.')) / (t * float(self.ListProds[0][12].replace(',', '.')))
            else:
                self.VolSolMere = float(Cf.replace(',', '.')) * (self.VolSelect / 1000) * float(
                    self.ListProds[0][11].replace(',', '.')) / float(self.ListProds[0][12].replace(',', '.'))
            self.LabelVolSolMere.Label['text'] = str(round(self.VolSolMere, 3)).replace('.', ',') + ' mL'
            if self.PrepaEnCours == "MelSol":
                self.Solute[self.InfoAffich] = [Prod, Cf, self.VolSolMere, 'mL']

    def AffichTabRecap(self, _):
        self.BtnTab.CanvasBtn.itemconfig(self.BtnTab.ImgCanvasBtn, image=self.BtnTab.ImgBtn[0])

        if self.TabEnCours == 'Sol':
            self.MainAppli.cur.execute("Select " + self.MainAppli.ListChampsTabTPSol +
                                       " from TPConsomprod where TITRE = \"" + self.TP[0] +
                                       "\" and ANNEESCOL = '" + self.MainAppli.AnScol + "' and UTIL != 'PUR' "
                                                                                        "and UTIL != 'MelSolAq'")
            self.ListRecapProdConsom = self.MainAppli.cur.fetchall()

            self.TabRecap = FrmTabRecap(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY,
                                        self.TP[2] + ' - ' + self.TP[0] + ' - Préparation des solutions',
                                        'Récapitulatif des solutions préparées et des produits chimiques consommés',
                                        ['Date', 'Soluté', 'Solvant', 'Volume préparé (mL)', 'Concentration (mol/L)',
                                         'Quantité soluté consommée', 'Unit. Mes. Soluté'], self.MainAppli.AnScol,
                                        self.MainAppli.SizeFont, len(self.ListRecapProdConsom), 7,
                                        [0.014, 0.045, 0.01, 0.014, 0.014, 0.014, 0.008], self)

            for i in range(len(self.ListRecapProdConsom)):
                self.TabRecap.TabProd.TabLabels[i][0]['text'] = self.ListRecapProdConsom[i][2]
                self.TabRecap.TabProd.TabLabels[i][1]['text'] = self.ListRecapProdConsom[i][3]
                self.TabRecap.TabProd.TabLabels[i][2]['text'] = self.ListRecapProdConsom[i][5]
                self.TabRecap.TabProd.TabLabels[i][3]['text'] = self.ListRecapProdConsom[i][6]
                self.TabRecap.TabProd.TabLabels[i][4]['text'] = self.ListRecapProdConsom[i][7]
                self.TabRecap.TabProd.TabLabels[i][5]['text'] = self.ListRecapProdConsom[i][9]
                self.TabRecap.TabProd.TabLabels[i][6]['text'] = self.ListRecapProdConsom[i][8]

        elif self.TabEnCours == 'MelSol':
            self.MainAppli.cur.execute("Select " + self.MainAppli.ListChampsTabTPSol +
                                       " from TPConsomprod where TITRE = \"" + self.TP[0] +
                                       "\" and ANNEESCOL = '" + self.MainAppli.AnScol + "' and UTIL = 'MelSolAq'")
            self.ListRecapProdConsom = self.MainAppli.cur.fetchall()

            TabRecapDef = []
            for i in range(len(self.ListRecapProdConsom) - 1):
                ListTabRecapDef = []
                if self.ListRecapProdConsom[i][2] == self.ListRecapProdConsom[i + 1][2]:
                    for j in range(len(self.ListRecapProdConsom[i])):
                        ListTabRecapDef.append(self.ListRecapProdConsom[i][j])
                    ListTabRecapDef.append(self.ListRecapProdConsom[i + 1][3])
                    ListTabRecapDef.append(self.ListRecapProdConsom[i + 1][7])
                    ListTabRecapDef.append(self.ListRecapProdConsom[i + 1][9])
                    ListTabRecapDef.append(self.ListRecapProdConsom[i + 1][8])
                    TabRecapDef.append(ListTabRecapDef)

            self.TabRecap = FrmTabRecap(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY,
                                        self.TP[2] + ' - ' + self.TP[0] + ' - Préparation des solutions',
                                        'Récapitulatif des mélanges de solutions aqueuses préparées et '
                                        'des produits chimiques consommés',
                                        ['Date', 'Volume préparé (mL)', 'Soluté 1', 'Concentration (mol/L)',
                                         'Quantité soluté 1 consommée', 'Unit. Mes. Soluté 1', 'Soluté 2',
                                         'Concentration (mol/L)',
                                         'Quantité soluté 2 consommée', 'Unit. Mes. Soluté 2'], self.MainAppli.AnScol,
                                        self.MainAppli.SizeFont, len(TabRecapDef), 10,
                                        [0.014, 0.01, 0.04, 0.014, 0.014, 0.008, 0.04, 0.014, 0.014, 0.008], self)

            for i in range(len(TabRecapDef)):
                self.TabRecap.TabProd.TabLabels[i][0]['text'] = TabRecapDef[i][2]
                self.TabRecap.TabProd.TabLabels[i][1]['text'] = TabRecapDef[i][6]
                self.TabRecap.TabProd.TabLabels[i][2]['text'] = TabRecapDef[i][3]
                self.TabRecap.TabProd.TabLabels[i][3]['text'] = TabRecapDef[i][7]
                self.TabRecap.TabProd.TabLabels[i][4]['text'] = TabRecapDef[i][9]
                self.TabRecap.TabProd.TabLabels[i][5]['text'] = TabRecapDef[i][8]
                self.TabRecap.TabProd.TabLabels[i][6]['text'] = TabRecapDef[i][10]
                self.TabRecap.TabProd.TabLabels[i][7]['text'] = TabRecapDef[i][11]
                self.TabRecap.TabProd.TabLabels[i][8]['text'] = TabRecapDef[i][12]
                self.TabRecap.TabProd.TabLabels[i][9]['text'] = TabRecapDef[i][13]

        elif self.TabEnCours == 'MelSolvant':
            self.MainAppli.cur.execute("Select " + self.MainAppli.ListChampsTabTPSol +
                                       " from TPConsomprod where TITRE = \"" + self.TP[0] +
                                       "\" and ANNEESCOL = '" + self.MainAppli.AnScol + "' and UTIL = 'MelSolv'")
            self.ListRecapProdConsom = self.MainAppli.cur.fetchall()
            TabRecapDef = []
            for i in range(len(self.ListRecapProdConsom) - 1):
                ListTabRecapDef = []
                if self.ListRecapProdConsom[i][2] == self.ListRecapProdConsom[i + 1][2]:
                    for j in range(len(self.ListRecapProdConsom[i])):
                        ListTabRecapDef.append(self.ListRecapProdConsom[i][j])
                    ListTabRecapDef.append(self.ListRecapProdConsom[i + 1][3])
                    ListTabRecapDef.append(self.ListRecapProdConsom[i + 1][7])
                    ListTabRecapDef.append(self.ListRecapProdConsom[i + 1][9])
                    TabRecapDef.append(ListTabRecapDef)

            self.TabRecap = FrmTabRecap(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY,
                                        self.TP[2] + ' - ' + self.TP[0] + ' - Préparation des solutions',
                                        'Récapitulatif des mélanges de solvants préparés et '
                                        'des produits chimiques consommés',
                                        ['Date', 'Volume préparé (mL)', 'Solvant 1', 'Concentration (% vol.)',
                                         'Quantité solvant 1 consommée (mL)', 'Solvant 2', 'Concentration (% vol.)',
                                         'Quantité solvant 2 consommée (mL)'], self.MainAppli.AnScol,
                                        self.MainAppli.SizeFont, len(TabRecapDef), 8,
                                        [0.014, 0.01, 0.04, 0.014, 0.018, 0.04, 0.014, 0.018], self)

            for i in range(len(TabRecapDef)):
                self.TabRecap.TabProd.TabLabels[i][0]['text'] = TabRecapDef[i][2]
                self.TabRecap.TabProd.TabLabels[i][1]['text'] = TabRecapDef[i][6]
                self.TabRecap.TabProd.TabLabels[i][2]['text'] = TabRecapDef[i][3]
                self.TabRecap.TabProd.TabLabels[i][3]['text'] = TabRecapDef[i][7]
                self.TabRecap.TabProd.TabLabels[i][4]['text'] = TabRecapDef[i][9]
                self.TabRecap.TabProd.TabLabels[i][5]['text'] = TabRecapDef[i][10]
                self.TabRecap.TabProd.TabLabels[i][6]['text'] = TabRecapDef[i][11]
                self.TabRecap.TabProd.TabLabels[i][7]['text'] = TabRecapDef[i][12]

    def EffaceMenus(self):
        for widget in self.CanvasMenu2.CanvasMenu.winfo_children():
            widget.destroy()
        for widget in self.CanvasMenu3.CanvasMenu.winfo_children():
            widget.destroy()
        if self.InfoProd is not None:
            self.CanvasMenu2.CanvasMenu.delete(self.InfoProd.NomProd)
            self.CanvasMenu2.CanvasMenu.delete(self.InfoProd.TitreStock)
            self.CanvasMenu2.CanvasMenu.delete(self.InfoProd.TitreFournisseur)
            self.InfoProd = None

    def EffaceMenuMain(self):
        for widget in self.CanvasMenu1.CanvasMenu.winfo_children():
            widget.destroy()
        self.CanvasMenu1.CanvasMenu.delete(self.TitreMasse)
        self.CanvasMenu1.CanvasMenu.delete(self.TitreVol)

    def MajConsomProd(self, Prod, Classe, UnitMes, Quant):
        self.MainAppli.cur.execute("SELECT Quant FROM ConsomProd WHERE Annee ='" + self.MainAppli.AnScol
                                   + "' and produit = '" + Prod + "' and Classe ='"
                                   + Classe + "'")
        ListConsomProd = self.MainAppli.cur.fetchall()
        if len(ListConsomProd) > 0:
            QuantConsom = str(round(Quant + float(ListConsomProd[0][0].replace(',', '.')), 1)).replace('.', ',')
            self.MainAppli.cur.execute("UPDATE ConsomProd SET Quant ='" + QuantConsom + "' WHERE Produit='" + Prod
                                       + "' and Annee ='" + self.MainAppli.AnScol + "'and Classe ='" + Classe + "'")
        else:
            QuantConsom = str(round(Quant, 1)).replace('.', ',')
            data = [(self.MainAppli.AnScol, Prod, Classe, UnitMes, QuantConsom)]
            self.MainAppli.cur.execute(
                "INSERT INTO ConsomProd(Annee, Produit, Classe , UnitMes, Quant) VALUES(?,?,?,?,?)", data[0])
        self.MainAppli.DataBaseChimie.commit()
        self.MainAppli.SaveListModifDTB('Chimie', 'Ajout consommation produit chimique pour préparation solution - ' +
                                        Prod)

    def ValidPrepa(self, _):
        if self.PrepaEnCours == 'Sol':
            self.ValidPrepaSol(_)
        elif self.PrepaEnCours == 'MelSol':
            self.ValidPrepaMelSol(_)
        elif self.PrepaEnCours == 'MelSolvant':
            self.ValidPrepaMelSolvant(_)

    def ValidPrepaSol(self, _):
        Date = datetime.now()
        if self.TypePrepa == 'Dissolution':
            if self.LabelMasse.Label['text'] != '':
                QuantStock = str(round(float(self.ListProds[0][18].replace(',', '.')) - self.Masse, 1))
                self.MainAppli.cur.execute(
                    "UPDATE PRODUITS SET QSTOCK ='" + QuantStock + "' WHERE NOMS='" + self.ListProds[0][0] + "'")
                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie',
                                                'Mise à jour stock produit chimique après préparation solution - ' +
                                                self.ListProds[0][0])
                self.MajConsomProd(self.ListProds[0][0], self.TP[2], self.ListProds[0][1], self.Masse)

                if self.Solvant != "Eau":
                    ListProdSolvant = self.ChercheProd(self.Solvant)
                    QuantStock = str(round(float(ListProdSolvant[0][18].replace(',', '.')) - self.VolSelect, 1))
                    self.MainAppli.cur.execute(
                        "UPDATE PRODUITS SET QSTOCK ='" + QuantStock + "' WHERE NOMS='" + ListProdSolvant[0][0] + "'")
                    self.MainAppli.DataBaseChimie.commit()
                    self.MainAppli.SaveListModifDTB('Chimie',
                                                    'Mise à jour stock produit chimique après préparation solution - ' +
                                                    ListProdSolvant[0][0])
                    self.MajConsomProd(ListProdSolvant[0][0], self.TP[2], ListProdSolvant[0][1], self.VolSelect)

                data = [(self.TP[0], self.MainAppli.AnScol, Date, self.ListSol[self.IndexElt][0], self.Util,
                         self.ListSol[self.IndexElt][1], str(self.VolSelect), self.ListSol[self.IndexElt][2],
                         self.UnitMes, str(round(self.Masse, 3)).replace('.', ','))]
                self.MainAppli.cur.execute(
                    "INSERT INTO TPConsomprod(" + self.MainAppli.ListChampsTabTPSol + ") VALUES(?,?,?,?,?,?,?,?,?,?)",
                    data[0])

                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie',
                                                'Ajout consommation produit chimique après préparation solution par TP '
                                                '- ' + self.ListSol[self.IndexElt][0] + ' (' + self.TP[0] + ')')
            else:
                winsound.PlaySound("*", winsound.SND_ASYNC)

        elif self.TypePrepa == "Dilution":
            if self.LabelVolSolMere.Label['text'] != '':
                data = [(self.TP[0], self.MainAppli.AnScol, Date, self.ListSol[self.IndexElt][0], self.Util,
                         self.ListSol[self.IndexElt][1], str(self.VolSelect), self.ListSol[self.IndexElt][2],
                         '', "Dilution " + self.EntryCSolMere.Data.get() + " M")]
                self.MainAppli.cur.execute(
                    "INSERT INTO TPConsomprod(" + self.MainAppli.ListChampsTabTPSol + ") VALUES(?,?,?,?,?,?,?,?,?,?)",
                    data[0])
                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie',
                                                'Ajout consommation produit chimique après préparation solution par TP '
                                                '- ' + self.ListSol[self.IndexElt][0] + ' (' + self.TP[0] + ')')

                if self.Solvant != "Eau":
                    ListProdSolvant = self.ChercheProd(self.Solvant)
                    QuantStock = str(
                        round(float(ListProdSolvant[0][18].replace(',', '.')) - (self.VolSelect - self.VolSolMere), 1))
                    self.MainAppli.cur.execute(
                        "UPDATE PRODUITS SET QSTOCK ='" + QuantStock + "' WHERE NOMS='" + ListProdSolvant[0][0] + "'")
                    self.MainAppli.DataBaseChimie.commit()
                    self.MainAppli.SaveListModifDTB('Chimie',
                                                    'Mise à jour stock produit chimique après préparation solution - ' +
                                                    self.ListProdSolvant[0][0])
                    self.MajConsomProd(ListProdSolvant[0][0], self.TP[2], ListProdSolvant[0][1],
                                       self.VolSelect - self.VolSolMere)
            else:
                winsound.PlaySound("*", winsound.SND_ASYNC)

        elif self.TypePrepa == "DilutionSolCom":
            if self.LabelVolSolMere.Label['text'] != '':
                QuantStock = str(round(float(self.ListProds[0][18].replace(',', '.')) - self.VolSolMere, 1))
                self.MainAppli.cur.execute(
                    "UPDATE PRODUITS SET QSTOCK ='" + QuantStock + "' WHERE NOMS='" + self.ListProds[0][0] + "'")
                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie',
                                                'Mise à jour stock produit chimique après préparation solution - ' +
                                                self.ListProds[0][0])
                self.MajConsomProd(self.ListProds[0][0], self.TP[2], self.ListProds[0][1], self.VolSolMere)

                data = [(self.TP[0], self.MainAppli.AnScol, Date, self.ListSol[self.IndexElt][0], self.Util,
                         self.ListSol[self.IndexElt][1], str(self.VolSelect), self.ListSol[self.IndexElt][2],
                         self.UnitMes, str(round(self.VolSolMere, 3)).replace('.', ','))]
                self.MainAppli.cur.execute(
                    "INSERT INTO TPConsomprod(" + self.MainAppli.ListChampsTabTPSol + ") VALUES(?,?,?,?,?,?,?,?,?,?)",
                    data[0])
                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie',
                                                'Ajout consommation produit chimique après préparation solution par TP '
                                                '- ' + self.ListSol[self.IndexElt][0] + ' (' + self.TP[0] + ')')
            else:
                winsound.PlaySound("*", winsound.SND_ASYNC)
        self.AnnulPrepa(_)

    def ValidPrepaMelSol(self, _):
        Date = datetime.now()
        if self.Solute[0] != ["", "", "", ""] and self.Solute[1] != ["", "", "", ""]:
            for i in range(2):
                data = [(self.TP[0], self.MainAppli.AnScol, Date, self.Solute[i][0], self.Util,
                         "Eau", str(self.VolSelect), self.Solute[i][1],
                         self.Solute[i][3], str(round(self.Solute[i][2], 3)).replace('.', ','))]
                self.MainAppli.cur.execute(
                    "INSERT INTO TPConsomprod(" + self.MainAppli.ListChampsTabTPSol + ") VALUES(?,?,?,?,?,?,?,?,?,?)",
                    data[0])

                ListProd = self.ChercheProd(self.Solute[i][0])
                QuantStock = str(round(float(ListProd[0][18].replace(',', '.')) - self.Solute[i][2], 1))
                self.MainAppli.cur.execute(
                    "UPDATE PRODUITS SET QSTOCK ='" + QuantStock + "' WHERE NOMS='" + ListProd[0][0] + "'")
                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie',
                                                'Mise à jour stock produit chimique après préparation solution - ' +
                                                ListProd[0][0])
                self.MajConsomProd(self.Solute[i][0], self.TP[2], self.Solute[i][3], self.Solute[i][2])

        self.AnnulPrepa(_)

    def AffichFrmImprim(self):
        self.AffichStock(self.IndexElt)
        Sol = []
        if self.TabEnCours == "Sol":
            Sol = [self.ListSol[self.IndexElt][0], self.ListSol[self.IndexElt][2], self.ListSol[self.IndexElt][1]]
        elif self.TabEnCours == "MelSol":
            Sol = [self.ListMelSol[self.IndexElt][0], self.ListMelSol[self.IndexElt][1],
                   self.ListMelSol[self.IndexElt][2] + ' ' + self.ListMelSol[self.IndexElt][3] + ' M']
        elif self.TabEnCours == "MelSolvant":
            Sol = [self.ListMelSolvant[self.IndexElt][0], self.ListMelSolvant[self.IndexElt][1],
                   self.ListMelSolvant[self.IndexElt][2], self.ListMelSolvant[self.IndexElt][3]]
        self.FrmImprimEtiqSol = FrmImprimEtiqSol(self.MainAppli.CanvasFrmMain, self.RatioX, self.RatioY,
                                                 self.MainAppli.SizeFont, Sol, self)

    def ValidPrepaMelSolvant(self, _):
        Date = datetime.now()
        if self.MSolvant[0] != ["", "", ""] and self.MSolvant[1] != ["", "", ""]:
            for i in range(2):
                data = [(self.TP[0], self.MainAppli.AnScol, Date, self.MSolvant[i][0], self.Util, '',
                         str(self.VolSelect), self.MSolvant[i][1],
                         'mL', str(round(self.MSolvant[i][2], 3)).replace('.', ','))]
                self.MainAppli.cur.execute(
                    "INSERT INTO TPConsomprod(" + self.MainAppli.ListChampsTabTPSol + ") VALUES(?,?,?,?,?,?,?,?,?,?)",
                    data[0])

                ListProd = self.ChercheProd(self.MSolvant[i][0])
                QuantStock = str(round(float(ListProd[0][18].replace(',', '.')) - self.MSolvant[i][2], 1))
                self.MainAppli.cur.execute(
                    "UPDATE PRODUITS SET QSTOCK ='" + QuantStock + "' WHERE NOMS='" + ListProd[0][0] + "'")
                self.MajConsomProd(self.MSolvant[i][0], self.TP[2], 'mL', self.MSolvant[i][2])

                self.MainAppli.DataBaseChimie.commit()
                self.MainAppli.SaveListModifDTB('Chimie',
                                                'Mise à jour stock produit chimique après préparation solution - ' +
                                                ListProd[0][0])

        self.AnnulPrepa(_)

    def AnnulPrepa(self, _):
        self.EffaceMenuMain()
        if self.PrepaEnCours == "Sol":
            self.AffichSol()
        elif self.PrepaEnCours == "MelSol":
            self.ActionAffichMelSol()
        elif self.PrepaEnCours == "MelSolvant":
            self.ActionAffichMelSolvant()
        self.PrepaEnCours = ''
        self.AffichStock(0)

    def ClicOnCanvas(self, _):
        if self.FrmImprimEtiqSol is not None:
            self.FrmImprimEtiqSol.lift()

    def MoveOnCanvas(self, _):
        self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
        self.MainAppli.CanvasBtnQuit.itemconfig(self.MainAppli.ImgCanvasBtnQuit, image=self.MainAppli.ImgBtnQuit[0])

    def CacheFrmPrepaProd(self, _):
        if self.PrepaEnCours == '':
            self.CanvasBtnClose.itemconfig(self.ImgCanvasBtnClose, image=self.ImgBtnClose[0])
            self.MainAppli.ListBtnActionV[7].CanvasBtn.itemconfig(self.MainAppli.ListBtnActionV[7].ImgCanvasBtn,
                                                                  image=self.MainAppli.ListBtnActionV[7].ImgBtn[0])
            self.destroy()
            if self.MainAppli.OldNAction != 0:
                self.MainAppli.NAction = self.MainAppli.OldNAction
            else:
                self.MainAppli.NAction = 3
            self.MainAppli.MAJInfo()
            self.MainAppli.parent.lift()
            self.MainAppli.FrmLift()
            self.MainAppli.ModifEnCours = False
        else:
            winsound.PlaySound("*", winsound.SND_ASYNC)


class FrmImprimEtiqSol(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, SizeFont, Sol, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.Container = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.Sol = Sol
        self.SizeFont = SizeFont
        self.img = None
        self.Img = None
        self.CanvasImg = []
        self.ImgCanvasImg = None
        self.ModifEnCours = 0
        self.ListEntryEtiq = []
        self.ListCanvasGHS = []
        self.MenuClicDroit = []
        self.NPictoSelected = 0
        self.MenuPicto = None
        self.ListNPicto = []

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmAjout/Menu/Fond.bmp')
        self.SX = int((float(FrmFond.size[0]) * float(self.RatioX * 1.092)))
        self.SY = int((float(FrmFond.size[1]) * float(self.RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmAjout/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.005)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.06)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)
        self.lift()

        self.CanvasEtiq = CanvasInWindow('Media/FrmEtiq/EtiqSolSolo/', self.RatioX * 4, self.RatioY * 4,
                                         self.CanvasFrmFond, tk.CENTER,
                                         int(self.SX * 0.5),
                                         int(self.SY * 0.18), 0)
        self.CanvasPlancheEtiq = CanvasInWindow('Media/FrmEtiq/EtiqSol/', self.RatioX * 1.5, self.RatioY * 1.5,
                                                self.CanvasFrmFond, tk.CENTER,
                                                int(self.SX * 0.55),
                                                int(self.SY * 0.62), 0)

        self.BtnQuant = BtnPlusMoins(self.CanvasFrmFond, self.RatioX, self.RatioY, 'Quantité:', 16, 0,
                                     SizeFont, 0.03, 0.6, self)
        self.BtnPos = BtnPlusMoins(self.CanvasFrmFond, self.RatioX, self.RatioY, 'Position:', 16, 1,
                                   SizeFont, 0.03, 0.45, self)

        self.BtnModifEtiq = BtnAction(self.CanvasFrmFond, int(self.SX * 0.95),
                                      int(self.SY * 0.05), self.RatioX * 0.25,
                                      self.RatioX * 0.25, 'Media/FrmEtiq/ModifEtiq/')
        self.BtnModifEtiq.CanvasBtn.bind('<ButtonRelease-1>', self.ModifEtiq)

        self.BtnOK = BtnAction(self.CanvasFrmFond, int(self.SX * 0.83),
                               int(self.SY * 0.95), self.RatioX * 0.75,
                               self.RatioX * 0.75, 'Media/FrmAjout/BtnOK2/')
        self.BtnOK.CanvasBtn.bind('<ButtonRelease-1>', self.ValidEtiq)
        self.BtnAnnul = BtnAction(self.CanvasFrmFond, int(self.SX * 0.90),
                                  int(self.SY * 0.95), self.RatioX * 0.75,
                                  self.RatioX * 0.75, 'Media/FrmAjout/BtnAnnul2/')
        self.BtnAnnul.CanvasBtn.bind('<ButtonRelease-1>', self.AnnulEtiq)

        Prod = self.ChercheProd(Sol[0])
        Sol[0] = Prod[0]
        self.Type = 0
        self.TextType = ''
        if self.MainAppli.TabEnCours == "Sol":
            self.Type = 1
            self.TextType = 'Etiquettes - Solution - ' + ModifNom(Sol[0][0])
        elif self.MainAppli.TabEnCours == "MelSol":
            self.Type = 2
            self.TextType = 'Etiquettes - Mélange de solutions aqueuses'
        elif self.MainAppli.TabEnCours == "MelSolvant":
            self.Type = 3
            self.TextType = 'Etiquettes - Mélange de solvants'
            Prod = self.ChercheProd(Sol[2])
            Sol[2] = Prod[0]

        self.Titre = LabelInCanvas(self.CanvasFrmFond, self.TextType, '#E0E0E0',
                                   AppliFont('Helvetica', SizeFont, 'normal', 0), int(self.SX * 0.01),
                                   int(self.SY * 0.004), tk.NW)
        self.EtiqSol = EtiqSol(self.CanvasEtiq, self.Type, Sol, SizeFont, self.RatioX, self)

        self.CanvasFrmFond.focus_set()
        self.CanvasFrmFond.pack()

    def GrabEtiq(self):
        x = self.CanvasEtiq.CanvasListIma.winfo_rootx()
        y = self.CanvasEtiq.CanvasListIma.winfo_rooty()
        w = self.CanvasEtiq.CanvasListIma.winfo_width()
        h = self.CanvasEtiq.CanvasListIma.winfo_height()
        image = ImageGrab.grab((x + 8, y + 8, x + w - 8, y + h - 8))
        image.save('Datas/Print/tmp.bmp')
        imgwsize = int(int(self.CanvasPlancheEtiq.CanvasListIma['width']) * 0.46)
        imghsize = int(imgwsize * float(image.size[1]) / float(image.size[0]))
        self.img = image.resize((imgwsize, imghsize), Image.ANTIALIAS)
        self.Img = ImageTk.PhotoImage(self.img)

    def AffichPlancheEtiq(self):
        self.EffaceEtiq()
        self.CanvasImg = []
        if (int(self.BtnPos.Val.Label['text']) % 2) == 0:
            Nl = (int(self.BtnPos.Val.Label['text']) // 2) - 1
            Nc = 1
        else:
            Nl = int(self.BtnPos.Val.Label['text']) // 2
            Nc = 0
        if int(self.BtnPos.Val.Label['text']) + int(self.BtnQuant.Val.Label['text']) > 17:
            self.BtnQuant.Val.Label['text'] = str(17 - int(self.BtnPos.Val.Label['text']))
        for i in range(int(self.BtnQuant.Val.Label['text'])):
            self.CanvasImg.append(CanvasApp(self.CanvasPlancheEtiq.CanvasListIma, width=self.img.size[0],
                                            height=self.img.size[1]))
            self.CanvasPlancheEtiq.CanvasListIma.create_window(int(self.CanvasPlancheEtiq.wsize * (0.035 + Nc * 0.475)),
                                                               int(self.CanvasPlancheEtiq.hsize * (0.04 + Nl * 0.117)),
                                                               anchor=tk.NW, window=self.CanvasImg[i])
            self.ImgCanvasImg = self.CanvasImg[i].create_image(0, 0, anchor=tk.NW, image=self.Img)
            Nc = Nc + 1
            if Nc == 2:
                Nc = 0
                Nl = Nl + 1

    def CallbackPlusMoins(self):
        if int(self.BtnQuant.Val.Label['text']) == 1:
            self.GrabEtiq()
        self.AffichPlancheEtiq()

    def EffaceEtiq(self):
        for widget in self.CanvasPlancheEtiq.CanvasListIma.winfo_children():
            widget.destroy()

    def ValidEtiq(self, _):
        self.BtnOK.CanvasBtn.itemconfig(self.BtnOK.ImgCanvasBtn, image=self.BtnOK.ImgBtn[0])
        if int(self.BtnQuant.Val.Label['text']) > 0:
            CreatePDF('Datas/Print/tmp.bmp', int(self.BtnPos.Val.Label['text']), int(self.BtnQuant.Val.Label['text']),
                      [[0.2, 25.4], [10.6, 25.4], [0.2, 21.9], [10.6, 21.9], [0.2, 18.4], [10.6, 18.4], [0.2, 14.9],
                       [10.6, 14.9], [0.2, 11.4], [10.6, 11.4], [0.2, 7.9], [10.6, 7.9], [0.2, 4.4], [10.6, 4.4],
                       [0.2, 0.9],
                       [10.6, 0.9]], 10.4, 3.4, 'Datas/Print/', 'tmp.pdf')
            if self.ModifEnCours == 1:
                Titre = 'Etiquettes personnalisées (105 x 35 mm)'
            else:
                Titre = self.TextType
            AffichPDF(Titre, 'Datas/Print/' + 'tmp.pdf', self)
            self.AnnulEtiq(_)
        else:
            tkMB.showwarning('Attention', "Veuillez indiquer la quantité d'étiquettes à imprimer !", parent=self)

    def AnnulEtiq(self, _):
        self.destroy()
        self.MainAppli.FrmImprimEtiqSol = None

    def ModifEtiq(self, _):
        self.ModifEnCours = 1 - self.ModifEnCours
        if self.ModifEnCours == 1:
            self.Titre.Label.config(text='Etiquettes personnalisées (105 x 35 mm)')
            self.BtnModifEtiq.CanvasBtn.itemconfig(self.BtnModifEtiq.ImgCanvasBtn, image=self.BtnModifEtiq.ImgBtn[2])
            if self.Type != 3:
                self.EtiqSol.LabelPrec.Label.destroy()
                self.EtiqSol.BtnPlus.CanvasBtn.destroy()
                self.EtiqSol.BtnMoins.CanvasBtn.destroy()
            self.CanvasEtiq.CanvasListIma.destroy()
            if int(self.BtnQuant.Val.Label['text']) > 0:
                self.EffaceEtiq()
                self.BtnQuant.Val.Label['text'] = 0
            self.EtiqSol = None

            self.CanvasEtiq = CanvasInWindow('Media/FrmEtiq/EtiqSolSolo/', self.RatioX * 4, self.RatioY * 4,
                                             self.CanvasFrmFond, tk.CENTER,
                                             int(self.SX * 0.5),
                                             int(self.SY * 0.18), 0)
            self.CanvasEtiq.CanvasListIma.bind('<Return>', self.ValidModifEtiq)
            self.ListEntryEtiq = []
            self.ListCanvasGHS = []
            self.MenuClicDroit = []
            self.ListNPicto = []
            coef = 0.08
            deb = 0.065
            for i in range(4):
                if i > 1:
                    deb = 0.34
                    coef = 0.03
                self.ListEntryEtiq.append(
                    EntryData(self.CanvasEtiq.CanvasListIma, int(self.CanvasEtiq.wsize * coef),
                              int(self.CanvasEtiq.wsize * deb),
                              int(self.CanvasEtiq.hsize * 0.18 + i * self.CanvasEtiq.hsize * 0.19), tk.W,
                              AppliFont('Helvetica', self.SizeFont + 4, 'bold', 0)))
                self.ListEntryEtiq[i].EntryData.config(justify='center')

                def GestEvt(_, j=i):
                    return self.ValidModifVal(j)

                self.ListEntryEtiq[i].EntryData.bind('<Return>', GestEvt)

            coef = 0.15
            for i in range(4):
                if i == 2:
                    coef = 0.325
                elif i == 3:
                    coef = 0.267
                self.ListCanvasGHS.append(
                    CanvasInWindow('Media/FrmEtiq/Picto/', self.RatioX * 0.75, self.RatioX * 0.75,
                                   self.CanvasEtiq.CanvasListIma, tk.CENTER,
                                   int(self.CanvasEtiq.wsize * 0.1) + int(i * self.CanvasEtiq.wsize * coef),
                                   int(self.CanvasEtiq.hsize * 0.73), 10))
                self.ListNPicto.append(10)
                ChangeCursor(self.ListCanvasGHS[i].CanvasListIma)

                self.MenuClicDroit.append(tk.Menu(self.ListCanvasGHS[i].CanvasListIma, tearoff=0))

                def GestEvt(_, j=i):
                    return self.ChargePicto(j)

                self.ListCanvasGHS[i].CanvasListIma.bind('<ButtonRelease-1>', GestEvt)

                def GestEvt2(evt, j=i):
                    return self.AffichMenuClicDroit(evt, j)

                self.ListCanvasGHS[i].CanvasListIma.bind("<Button-3>", GestEvt2)
                self.MenuClicDroit[i].add_command(label="Effacer", command=self.EffacerPicto)
        else:
            self.BtnModifEtiq.CanvasBtn.itemconfig(self.BtnModifEtiq.ImgCanvasBtn, image=self.BtnModifEtiq.ImgBtn[0])
            self.CanvasEtiq.CanvasListIma.destroy()
            if int(self.BtnQuant.Val.Label['text']) > 0:
                self.EffaceEtiq()
                self.BtnQuant.Val.Label['text'] = 0
            self.Titre.Label.config(text=self.TextType)
            self.CanvasEtiq = CanvasInWindow('Media/FrmEtiq/EtiqSolSolo/', self.RatioX * 4, self.RatioY * 4,
                                             self.CanvasFrmFond, tk.CENTER,
                                             int(self.SX * 0.5),
                                             int(self.SY * 0.18), 0)
            self.EtiqSol = EtiqSol(self.CanvasEtiq, self.Type, self.Sol, self.SizeFont, self.RatioX, self)

    def ChargePicto(self, j):
        if self.MenuPicto is None:
            self.MenuPicto = MenuPicto(self.CanvasPlancheEtiq.CanvasListIma, 'Media/FrmAjout/MenuPicto/',
                                       int(self.CanvasPlancheEtiq.wsize * 0.99),
                                       int(self.CanvasPlancheEtiq.hsize * 0.99),
                                       int(self.CanvasPlancheEtiq.wsize * 0.5), int(self.CanvasPlancheEtiq.hsize * 0.5),
                                       self.RatioX * 0.7, self.SizeFont - 1, j, self)

    def EffacerPicto(self):
        if self.ListNPicto[self.NPictoSelected] != 10:
            self.ListCanvasGHS[self.NPictoSelected].CanvasListIma.itemconfig(
                self.ListCanvasGHS[self.NPictoSelected].ImgCanvasListIma,
                image=self.ListCanvasGHS[self.NPictoSelected].ListIma[10])
            self.ListNPicto[self.NPictoSelected] = 10
        else:
            self.ListCanvasGHS[self.NPictoSelected].CanvasListIma.itemconfig(
                self.ListCanvasGHS[self.NPictoSelected].ImgCanvasListIma,
                image=self.ListCanvasGHS[self.NPictoSelected].ListIma[11])
            self.ListNPicto[self.NPictoSelected] = 11
        self.CanvasEtiq.CanvasListIma.focus_set()

    def AffichMenuClicDroit(self, event, j):
        self.MenuClicDroit[j].post(event.x_root, event.y_root)
        self.NPictoSelected = j

    def ValidModifVal(self, j):
        self.ListEntryEtiq[j].EntryData.config(relief='flat')
        self.CanvasEtiq.CanvasListIma.focus_set()

    def ValidModifEtiq(self, _):
        if int(self.BtnQuant.Val.Label['text']) > 0:
            self.GrabEtiq()
            self.AffichPlancheEtiq()

    def ClosePDF(self):
        self.MainAppli.MainAppli.parent.focus_force()
        self.MainAppli.MainAppli.FrmLift()
        self.MainAppli.focus_force()

    def ChercheProd(self, Nom):
        ListProds = []
        try:
            self.MainAppli.MainAppli.cur.execute("SELECT " + self.MainAppli.MainAppli.ListChampsTabProd +
                                                 " FROM PRODUITS WHERE NOMS = '" + Nom + "' order by NOMS")
            ListProds = self.MainAppli.MainAppli.cur.fetchall()
        except:
            self.MainAppli.MainAppli.cur.execute('SELECT ' + self.MainAppli.MainAppli.ListChampsTabProd +
                                                 ' FROM PRODUITS WHERE NOMS = \"%' + Nom + '%\" order by NOMS')
            ListProds = self.MainAppli.MainAppli.cur.fetchall()
        finally:
            if len(ListProds) == 0:
                self.MainAppli.MainAppli.cur.execute('SELECT ' + self.MainAppli.MainAppli.ListChampsTabProd +
                                                     ' FROM PRODUITS WHERE NOMS LIKE \"%' + Nom + '%\" order by NOMS')
                ListProds = self.MainAppli.MainAppli.cur.fetchall()
        return ListProds


class EtiqSol:
    def __init__(self, container, Type, Sol, SizeFont, RatioX, Appli):
        self.MainAppli = Appli
        self.Container = container
        self.Sol = Sol
        self.Type = Type
        self.listGHS = []
        self.prod2 = []
        FB = ''
        NomSolvant2 = ''
        prod = Sol[0]
        Nom = ModifNom(prod[0])
        self.Type = Type

        if Type != 3:
            self.LabelPrec = LabelInCanvas(self.MainAppli.CanvasFrmFond, 'Précision :', '#E0E0E0',
                                           AppliFont('Helvetica', SizeFont, 'normal', 0), int(self.MainAppli.SX * 0.96),
                                           int(self.MainAppli.SY * 0.004), tk.NE)
            self.BtnPlus = BtnAction(self.MainAppli.CanvasFrmFond,
                                     int(int(self.MainAppli.CanvasFrmFond['width']) * 0.98),
                                     int(int(self.MainAppli.CanvasFrmFond['height']) * 0.008), RatioX * 1.1,
                                     RatioX * 1.1, 'Media/FrmAjout/BtnPlus/')
            self.BtnPlus.CanvasBtn.bind('<ButtonRelease-1>', self.PrecisionPlus)
            self.BtnMoins = BtnAction(self.MainAppli.CanvasFrmFond,
                                      int(int(self.MainAppli.CanvasFrmFond['width']) * 0.98),
                                      int(int(self.MainAppli.CanvasFrmFond['height']) * 0.019), RatioX * 1.1,
                                      RatioX * 1.1, 'Media/FrmAjout/BtnMoins/')
            self.BtnMoins.CanvasBtn.bind('<ButtonRelease-1>', self.PrecisionMoins)
            maxchr = 32
            if prod[6] is not None and prod[6] != '':
                FB = prod[6]
                FB = ModifFB(FB)
        else:
            maxchr = 26
            self.prod2 = Sol[2]
            NomSolvant2 = self.prod2[0]

        if len(Nom) >= maxchr:
            sizefont = SizeFont + 4
            YlabSolv = 0.39
            if len(Nom) > maxchr + 11:
                (Nom1, Nom2) = (Nom[:len(Nom) // 2], Nom[len(Nom) // 2:])
                Nom = Nom1 + '-\n' + Nom2
        else:
            sizefont = SizeFont + 8
            YlabSolv = 0.35

        if Type != 3:
            LabelInCanvas(container.CanvasListIma, Nom, '#FFFFFF',
                          AppliFont('Helvetica', sizefont, 'bold', 0), int(int(container.CanvasListIma['width']) * 0.5),
                          int(int(container.CanvasListIma['height']) * 0.19), tk.CENTER)
            if Sol[2] == "Eau":
                TextSolvant = "(solution aqueuse)"
            else:
                self.prod2 = self.Determinsolvant(Sol[2])
                if Sol[2][-1] != 'M':
                    TextSolvant = "(solution dans " + Sol[2] + ")"
                else:
                    LSolv = Sol[2].split(' ')
                    Csolv = LSolv[-2] + ' ' + LSolv[-1]
                    TextSolvant = "(solution dans " + ModifNom(self.prod2[0]) + " " + Csolv + ")"
            container.CanvasListIma.create_text(
                int(int(container.CanvasListIma['width']) * 0.5),
                int(int(container.CanvasListIma['height']) * YlabSolv),
                text=TextSolvant, font=AppliFont('Calibri', SizeFont + 4, 'bold', 0), anchor=tk.CENTER)

            container.CanvasListIma.create_text(
                int(int(container.CanvasListIma['width']) * 0.5),
                int(int(container.CanvasListIma['height']) * (YlabSolv + 0.21)),
                text=FB, font=AppliFont('Calibri', SizeFont + 6, 'bold', 0), anchor=tk.CENTER)

            self.ValPrec = 2
            Prec = "%." + str(self.ValPrec) + "f"
            self.Conc = container.CanvasListIma.create_text(
                int(int(container.CanvasListIma['width']) * 0.5),
                int(int(container.CanvasListIma['height']) * (YlabSolv + 0.41)),
                text=(Prec % float(Sol[1].replace(',', '.'))).replace('.', ',') + ' mol/L',
                font=AppliFont('Calibri', SizeFont + 6, 'bold', 0), anchor=tk.CENTER)
            container.CanvasListIma.addtag_withtag('Precision', self.Conc)
        else:
            LabelInCanvas(container.CanvasListIma, Nom + ' (' + Sol[1] + ' %)', '#FFFFFF',
                          AppliFont('Helvetica', sizefont, 'bold', 0), int(int(container.CanvasListIma['width']) * 0.5),
                          int(int(container.CanvasListIma['height']) * 0.19), tk.CENTER)
            if len(NomSolvant2) >= maxchr:
                sizefont = SizeFont + 4
                if len(NomSolvant2) > maxchr + 11:
                    (Nom1, Nom2) = (NomSolvant2[:len(NomSolvant2) // 2], NomSolvant2[len(NomSolvant2) // 2:])
                    NomSolvant2 = Nom1 + '-\n' + Nom2
            else:
                sizefont = SizeFont + 8
            LabelInCanvas(container.CanvasListIma, NomSolvant2 + ' (' + Sol[3] + ' %)', '#FFFFFF',
                          AppliFont('Helvetica', sizefont, 'bold', 0),
                          int(int(container.CanvasListIma['width']) * 0.5),
                          int(int(container.CanvasListIma['height']) * 0.42),
                          tk.CENTER)

        self.DeterminListGHS(prod)
        self.CanvasGHS = []
        coef = 0
        deb = 0
        if len(self.listGHS) < 4:
            Max = len(self.listGHS)
        else:
            Max = 4
        if self.Type != 3:
            if Max == 3 or Max == 4:
                coef = 0.15
                deb = 0.1
            elif Max == 2:
                coef = 0.7
                deb = 0.15
            elif Max == 1:
                coef = 0
                deb = 0.15
        else:
            if Max == 4:
                coef = 0.2
                deb = 0.2
            elif Max == 3:
                coef = 0.2
                deb = 0.3
            elif Max == 2:
                coef = 0.2
                deb = 0.4
            elif Max == 1:
                coef = 0
                deb = 0.5
        for i in range(Max):
            if self.Type != 3:
                if i == 2 and Max < 4:
                    coef = 0.4
                elif i == 2 and Max == 4:
                    coef = 0.325
                elif i == 3:
                    coef = 0.267
            self.CanvasGHS.append(
                CanvasInWindow('Media/PictoDanger/', RatioX * 0.75, RatioX * 0.75,
                               container.CanvasListIma, tk.CENTER, int(container.wsize * (deb + i * coef)),
                               int(container.hsize * 0.73), self.listGHS[i]))

    def DeterminListGHS(self, prod):
        listGHS = []
        for i in range(3):
            if prod[i + 3] is not None and prod[i + 3] != '':
                listGHS.append(prod[i + 3])
        if self.prod2:
            for i in range(3):
                if self.prod2[i + 3] is not None and self.prod2[i + 3] != '' and self.prod2[i + 3] not in listGHS:
                    listGHS.append(self.prod2[i + 3])
        self.listGHS = ModifListDanger(listGHS)

    def Determinsolvant(self, prod):
        Prod = []
        if self.Type == 1:
            Prod = self.MainAppli.ChercheProd(prod)[0]
        elif self.Type == 2:
            LNomProd = prod.split(' ')
            NomProd = LNomProd[0]
            for i in range(1, len(LNomProd) - 2):
                NomProd = NomProd + ' ' + LNomProd[i]
            Prod = self.MainAppli.ChercheProd(NomProd)[0]
        return Prod

    def PrecisionPlus(self, _):
        self.BtnPlus.CanvasBtn.itemconfig(self.BtnPlus.ImgCanvasBtn, image=self.BtnPlus.ImgBtn[0])
        if self.ValPrec < 5:
            self.ValPrec += 1
            Prec = "%." + str(self.ValPrec) + "f"
            self.Container.CanvasListIma.itemconfigure(
                'Precision', text=(Prec % float(self.Sol[1].replace(',', '.'))).replace('.', ',') + ' mol/L')

    def PrecisionMoins(self, _):
        self.BtnMoins.CanvasBtn.itemconfig(self.BtnMoins.ImgCanvasBtn, image=self.BtnMoins.ImgBtn[0])
        if self.ValPrec > 0:
            self.ValPrec -= 1
            Prec = "%." + str(self.ValPrec) + "f"
            self.Container.CanvasListIma.itemconfigure(
                'Precision', text=(Prec % float(self.Sol[1].replace(',', '.'))).replace('.', ',') + ' mol/L')
