from AppliDef import *
from FrmInfoProdMat import InfoMatPhys
import re


class FrmZoomDanger(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Prod, Dangers, Type, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.Dangers = Dangers
        self.Type = Type
        self.ListNDanger = []
        self.TabDangers = None

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmZoom/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmZoom/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.174)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.080)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)

        self.ImgBtnQuit, wsize, hsize, self.CanvasBtnQuit, self.ImgCanvasBtnQuit = CanInWindow(
            'Media/FrmZoom/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER, int(self.SX * 0.986),
            int(self.SY * 0.013), 0)
        ChangeCursor(self.CanvasBtnQuit)
        self.CanvasBtnQuit.bind('<Motion>',
                                lambda action: self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit,
                                                                             image=self.ImgBtnQuit[1]))
        self.CanvasBtnQuit.bind('<ButtonRelease-1>', self.Quitter)

        if Type == 'Dangers':
            TypeText = ' - Mention de dangers'
        else:
            TypeText = ' - Conseils de prudence'
        self.CanvasFrmFond.create_text(
            int(self.SX * 0.01), int(self.SY * 0.014), text=Prod + TypeText,
            font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0), anchor=tk.W)

        self.AffichDangers()

        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

    def AffichDangers(self):
        self.ListNDanger = self.Dangers.split(',')
        self.TabDangers = Tableau(self.CanvasFrmFond, len(self.ListNDanger), 2, ['Numéros', 'Significations'],
                                  [0.03, 0.09],
                                  AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                                  AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)

        for L in range(len(self.ListNDanger)):
            self.TabDangers.TabLabels[L][0]['text'] = self.ListNDanger[L].replace('\n', '').replace(' ', '')
            if self.Type == 'Dangers':
                self.MainAppli.MainAppli.curSave.execute("SELECT " + 'Text' + " FROM Dangers WHERE Numero = '" +
                                                         self.TabDangers.TabLabels[L][0]['text'] + "'")
            else:
                self.MainAppli.MainAppli.curSave.execute("SELECT " + 'Text' + " FROM Prudence WHERE Numero = '" +
                                                         self.TabDangers.TabLabels[L][0]['text'] + "'")
            ListDangers = self.MainAppli.MainAppli.curSave.fetchall()
            if len(ListDangers) > 0:
                TextDanger = ListDangers[0][0]
                if len(TextDanger) > 100:
                    TextDanger = TextDanger[0:100] + '\n' + TextDanger[100:len(TextDanger)]
                self.TabDangers.TabLabels[L][1]['text'] = TextDanger

            self.TabDangers.TabLabels[L][0].config(height=int(int(self.CanvasFrmFond['height']) * 0.003))
            self.TabDangers.TabLabels[L][1].config(height=int(int(self.CanvasFrmFond['height']) * 0.003))

        for i in range(self.TabDangers.NCol):
            self.TabDangers.TabLabelNCol[i].config(height=int(int(self.CanvasFrmFond['height']) * 0.004))

    def MoveOnCanvas(self, _):
        self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit, image=self.ImgBtnQuit[0])

    def Quitter(self, _):
        self.destroy()
        self.MainAppli.ZoomActif = False
        self.MainAppli.ZoomDanger = None
        self.MainAppli.ZoomConseil = None
        self.MainAppli.MainAppli.FrmLift()


class FrmZoomDoc(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, File, Titre, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmZoom/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmZoom/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.174)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.080)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)

        self.ImgBtnQuit, wsize, hsize, self.CanvasBtnQuit, self.ImgCanvasBtnQuit = CanInWindow(
            'Media/FrmZoom/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER, int(self.SX * 0.986),
            int(self.SY * 0.013), 0)
        ChangeCursor(self.CanvasBtnQuit)
        self.CanvasBtnQuit.bind('<Motion>',
                                lambda action: self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit,
                                                                             image=self.ImgBtnQuit[1]))
        self.CanvasBtnQuit.bind('<ButtonRelease-1>', self.Quitter)

        self.TitreCadre = Titre

        self.CanvasFrmFond.create_text(
            int(self.SX * 0.01), int(self.SY * 0.014), text=self.TitreCadre,
            font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), anchor=tk.W)

        self.FrmPDF = FrmPDF(self.CanvasFrmFond, File, 1.3, int(self.SY), int(self.SX * 0.5), int(self.SY * 0.5),
                             int(self.SX * 0.702), int(self.SY * 0.88))

        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

    def MoveOnCanvas(self, _):
        self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit, image=self.ImgBtnQuit[0])

    def Quitter(self, _):
        self.destroy()
        self.MainAppli.ZoomActif = False
        self.MainAppli.MainAppli.FrmLift()


class FrmZoomTab(tk.Toplevel):
    def __init__(self, container, RatioX, RatioY, Type, Appli):
        tk.Toplevel.__init__(self, container)
        self.MainAppli = Appli
        self.parent = container
        self.RatioX = RatioX
        self.RatioY = RatioY
        self.TabProd = None
        self.TabMat = None
        self.TabSol = None
        self.InfoMat = None

        screen = ctypes.windll.user32
        FrmFond = Image.open('Media/FrmZoom/Fond/Fond.jpg')
        self.SX = int((float(FrmFond.size[0]) * float(RatioX)))
        self.SY = int((float(FrmFond.size[1]) * float(RatioY)))

        self.ImgFrmFond = []
        self.ImgFrmFond = RedimImg(self.SX, self.SY, 'Media/FrmZoom/Fond/')
        self.CanvasFrmFond = CanvasApp(self, width=self.SX, height=self.SY)
        self.ImgCanvasFrmFond = self.CanvasFrmFond.create_image(0, 0, anchor=tk.NW, image=self.ImgFrmFond[0])

        self.geometry(str(self.SX) + "x" + str(self.SY) + "+" + str(int(screen.GetSystemMetrics(0) * 0.174)) + "+" +
                      str(int(screen.GetSystemMetrics(1) * 0.080)))
        self.resizable(width=False, height=False)
        self.overrideredirect(True)

        self.ImgBtnQuit, wsize, hsize, self.CanvasBtnQuit, self.ImgCanvasBtnQuit = CanInWindow(
            'Media/FrmZoom/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER, int(self.SX * 0.986),
            int(self.SY * 0.013), 0)
        ChangeCursor(self.CanvasBtnQuit)
        self.CanvasBtnQuit.bind('<Motion>',
                                lambda action: self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit,
                                                                             image=self.ImgBtnQuit[1]))
        self.CanvasBtnQuit.bind('<ButtonRelease-1>', self.Quitter)

        self.TitreCadre = self.CanvasFrmFond.create_text(int(self.SX * 0.01), int(self.SY * 0.014), text='',
                                                         font=AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont,
                                                                        'normal', 0), anchor=tk.W)

        if Type == 0:
            self.AffichTabMat()
        elif Type == 1:
            self.AffichTabProd()
        elif Type == 2:
            self.AffichTabSol()
        elif Type == 3:
            self.AffichTabMelSol()
        elif Type == 4:
            self.AffichTabMelSolvant()

        self.CanvasFrmFond.bind('<Motion>', self.MoveOnCanvas)
        self.CanvasFrmFond.pack()

    def AffichTabMat(self):
        self.CanvasFrmFond.itemconfigure(self.TitreCadre, text="Matériel du TP")

        self.TabMat = Tableau(self.CanvasFrmFond, len(self.MainAppli.ListMat), 3, ['Désignation', 'Quantité', 'Lieu'],
                              [0.078, 0.02, 0.02],
                              AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                              AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)

        nl = 0
        for i in range(len(self.MainAppli.ListMat)):
            if self.MainAppli.ListMat[i][0] != '' and self.MainAppli.ListMat[i][0] is not None:
                for j in range(3):
                    self.TabMat.TabLabels[nl][j]['text'] = self.MainAppli.ListMat[i][j]
                nl = nl + 1

        if self.MainAppli.MainAppli.BaseEnCours == 'CHIMIE':
            self.MainAppli.AffichProduits()
            self.MainAppli.MenuOnglets.InitOnglets2()
            self.MainAppli.MenuOnglets.MenuSelected[1] = True
            self.MainAppli.MenuOnglets.ListCanvasMenu[1].itemconfig(self.MainAppli.MenuOnglets.ListImgMenu[1],
                                                                    image=self.MainAppli.MenuOnglets.ListMenu[1][2])
        elif self.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            for i in range(3):
                self.TabMat.TabLabels[0][i].config(bg='#E0E0E0')
            self.TabMat.IndexElt = 0
            self.AffichStockMatPhys(0)

    def AffichTabProd(self):
        self.CanvasFrmFond.itemconfigure(self.TitreCadre, text="Produits chimiques du TP")

        self.TabProd = Tableau(self.CanvasFrmFond, len(self.MainAppli.ListProd), 3,
                               ['Désignation', 'Quantité/Gr', 'Unit. Mes.'], [0.078, 0.02, 0.02],
                               AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                               AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)

        nl = 0
        for i in range(len(self.MainAppli.ListProd)):
            if self.MainAppli.ListProd[i][0] != '' and self.MainAppli.ListProd[i][0] is not None:
                for j in range(3):
                    self.TabProd.TabLabels[nl][j]['text'] = self.MainAppli.ListProd[i][j]
                nl = nl + 1

        self.MainAppli.AffichSolutions()
        self.MainAppli.MenuOnglets.InitOnglets2()
        self.MainAppli.MenuOnglets.MenuSelected[2] = True
        self.MainAppli.MenuOnglets.ListCanvasMenu[2].itemconfig(self.MainAppli.MenuOnglets.ListImgMenu[2],
                                                                image=self.MainAppli.MenuOnglets.ListMenu[2][2])

    def AffichTabSol(self):
        self.CanvasFrmFond.itemconfigure(self.TitreCadre, text="Solutions du TP")
        ListSol = []
        for i in range(len(self.MainAppli.ListSol)):
            if self.MainAppli.ListSol[i][0] != '' and self.MainAppli.ListSol[i][0] is not None \
                    and self.MainAppli.ListSol[i][1] != '' and self.MainAppli.ListSol[i][1] is not None:
                ListSol.append(self.MainAppli.ListSol[i])
        self.TabSol = Tableau(self.CanvasFrmFond, len(ListSol), 4,
                              ['Soluté', 'Solvant', 'C (mol/L)', 'Q/Gr (mL)'], [0.058, 0.02, 0.02, 0.018],
                              AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                              AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)

        nl = 0
        for i in range(len(self.MainAppli.ListSol)):
            if (self.MainAppli.ListSol[i][0] != '' or self.MainAppli.ListSol[i][0] is not None) and \
                    (self.MainAppli.ListSol[i][4] == '' or self.MainAppli.ListSol[i][4] is None):
                if self.MainAppli.ListSol[i][0] != '' and self.MainAppli.ListSol[i][0] is not None:
                    for j in range(4):
                        self.TabSol.TabLabels[nl][j]['text'] = self.MainAppli.ListSol[i][j]
                    nl = nl + 1

        if not self.MainAppli.MelangeSol and not self.MainAppli.MelangeSolvant:
            self.MainAppli.AffichMat()
            self.MainAppli.MenuOnglets.InitOnglets2()
            self.MainAppli.MenuOnglets.MenuSelected[0] = True
            self.MainAppli.MenuOnglets.ListCanvasMenu[0].itemconfig(self.MainAppli.MenuOnglets.ListImgMenu[0],
                                                                    image=self.MainAppli.MenuOnglets.ListMenu[0][2])
        elif self.MainAppli.MelangeSol:
            self.MainAppli.ActionAffichMelSol()

        elif self.MainAppli.MelangeSolvant:
            self.MainAppli.ActionAffichMelSolvant()

    def AffichTabMelSol(self):
        self.CanvasFrmFond.itemconfigure(self.TitreCadre, text="Mélange de solutions du TP")
        ListMelSol = []
        for i in range(len(self.MainAppli.ListSol)):
            if self.MainAppli.ListSol[i][0] != '' and self.MainAppli.ListSol[i][0] is not None \
                    and self.MainAppli.ListSol[i][4] != '' and self.MainAppli.ListSol[i][4] is not None:
                ListMelSol.append(self.MainAppli.ListSol[i])
        self.TabSol = Tableau(self.CanvasFrmFond, len(ListMelSol), 5,
                              ['Soluté 1', 'C1 (mol/L)', 'Soluté 2', 'C2 (mol/L)', 'Q/Gr (mL)'],
                              [0.03, 0.02, 0.03, 0.02, 0.018],
                              AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                              AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)
        nl = 0
        for i in range(len(self.MainAppli.ListSol)):
            if self.MainAppli.ListSol[i][0] != '' and self.MainAppli.ListSol[i][0] is not None \
                    and self.MainAppli.ListSol[i][4] != '' and self.MainAppli.ListSol[i][4] is not None:
                self.TabSol.TabLabels[nl][0]['text'] = self.MainAppli.ListSol[i][0]
                self.TabSol.TabLabels[nl][1]['text'] = self.MainAppli.ListSol[i][2]
                self.TabSol.TabLabels[nl][2]['text'] = self.MainAppli.ListSol[i][4]
                self.TabSol.TabLabels[nl][3]['text'] = self.MainAppli.ListSol[i][5]
                self.TabSol.TabLabels[nl][4]['text'] = self.MainAppli.ListSol[i][3]
                nl = nl + 1

        self.MainAppli.AffichSolutions()

    def AffichTabMelSolvant(self):
        self.CanvasFrmFond.itemconfigure(self.TitreCadre, text="Mélange de solvants du TP")
        ListMelSolvant = []
        for i in range(len(self.MainAppli.ListSol)):
            if self.MainAppli.ListSol[i][1] != '' and self.MainAppli.ListSol[i][1] is not None \
                    and self.MainAppli.ListSol[i][6] != '' and self.MainAppli.ListSol[i][6] is not None:
                ListMelSolvant.append(self.MainAppli.ListSol[i])
        self.TabSol = Tableau(self.CanvasFrmFond, len(ListMelSolvant), 5,
                              ['Solvant 1', 'C1 (%)', 'Solvant 2', 'C2 (%)', 'Q/Gr (mL)'],
                              [0.03, 0.019, 0.03, 0.019, 0.018],
                              AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'bold', 0),
                              AppliFont('Helvetica', self.MainAppli.MainAppli.SizeFont, 'normal', 0), self)
        nl = 0
        for i in range(len(self.MainAppli.ListSol)):
            if self.MainAppli.ListSol[i][1] != '' and self.MainAppli.ListSol[i][1] is not None \
                    and self.MainAppli.ListSol[i][6] != '' and self.MainAppli.ListSol[i][6] is not None:
                self.TabSol.TabLabels[nl][0]['text'] = self.MainAppli.ListSol[i][1]
                self.TabSol.TabLabels[nl][1]['text'] = self.MainAppli.ListSol[i][2]
                self.TabSol.TabLabels[nl][2]['text'] = self.MainAppli.ListSol[i][6]
                self.TabSol.TabLabels[nl][3]['text'] = self.MainAppli.ListSol[i][5]
                self.TabSol.TabLabels[nl][4]['text'] = self.MainAppli.ListSol[i][3]
                nl = nl + 1

        self.MainAppli.AffichSolutions()

    def AffichStockMatPhys(self, IndexElt):
        if self.InfoMat is not None:
            self.InfoMat.EffaceMenu()
        ListMats = []
        try:
            self.MainAppli.MainAppli.curphys.execute("SELECT " + self.MainAppli.MainAppli.ListChampsTabMatPhys +
                                                     " FROM MATERIEL WHERE " + 'NOMS = "' +
                                                     self.MainAppli.ListMat[IndexElt][0] + '" order by NOMS')
            ListMats = self.MainAppli.MainAppli.curphys.fetchall()
        except:
            self.MainAppli.MainAppli.curphys.execute("SELECT " + self.MainAppli.MainAppli.ListChampsTabMatPhys +
                                                     " FROM MATERIEL WHERE " + 'NOMS LIKE \"%' +
                                                     self.MainAppli.ListMat[IndexElt][0].replace('"', "") +
                                                     '%\" order by NOMS')
            ListMats = self.MainAppli.MainAppli.curphys.fetchall()

        finally:
            if len(ListMats) == 0:
                Mat = re.split(' ', self.MainAppli.ListMat[IndexElt][0].replace('"', ""))
                c = 1
                while len(ListMats) == 0:
                    NomMat = Mat[0]
                    for i in range(1, len(Mat) - c):
                        NomMat = NomMat + ' ' + Mat[i]
                    self.MainAppli.MainAppli.curphys.execute("SELECT " + self.MainAppli.MainAppli.ListChampsTabMatPhys +
                                                             " FROM MATERIEL WHERE " + 'NOMS LIKE \"%' +
                                                             NomMat + '%\" order by NOMS')
                    ListMats = self.MainAppli.MainAppli.curphys.fetchall()
                    c += 1
                    if c == len(Mat):
                        break

        if len(ListMats) > 0:
            self.InfoMat = InfoMatPhys(self.MainAppli.CanvasMenu.CanvasListIma, ListMats[0],
                                       self.MainAppli.MainAppli.curphys, self.MainAppli.MainAppli.SizeFont, self.RatioX,
                                       self.RatioY, 4, self.MainAppli.MainAppli.LieuxStockMatPhys)

    def MoveOnCanvas(self, _):
        self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit, image=self.ImgBtnQuit[0])

    def AffichBtnQuit(self):
        self.ImgBtnQuit, wsize, hsize, self.CanvasBtnQuit, self.ImgCanvasBtnQuit = CanInWindow(
            'Media/FrmZoom/BtnClose/', self.RatioX, self.RatioY, self.CanvasFrmFond, tk.CENTER, int(self.SX * 0.986),
            int(self.SY * 0.013), 0)
        ChangeCursor(self.CanvasBtnQuit)
        self.CanvasBtnQuit.bind('<Motion>',
                                lambda action: self.CanvasBtnQuit.itemconfig(self.ImgCanvasBtnQuit,
                                                                             image=self.ImgBtnQuit[1]))
        self.CanvasBtnQuit.bind('<ButtonRelease-1>', self.Quitter)

    def Quitter(self, _):
        self.destroy()
        self.MainAppli.ZoomActif = False
        self.MainAppli.MainAppli.FrmLift()
        if self.MainAppli.MainAppli.BaseEnCours == "PHYS":
            self.MainAppli.AffichMat()


class Tableau:
    def __init__(self, container, NLine, NCol, ListLabelCol, LabelWidth, Font1, Font2, MainAppli):
        self.NLine = NLine
        self.NCol = NCol
        self.IndexElt = 0
        self.MainAppli = MainAppli
        self.container = container
        self.LabelWidth = LabelWidth
        self.Font2 = Font2
        self.FrameTableur = tk.Frame(container)
        container.create_window(int(int(container['width']) * 0.5),
                                int(int(container['height']) * 0.513), anchor=tk.CENTER,
                                window=self.FrameTableur)
        self.scrollable_canvas = ScrollableCanvas(self.FrameTableur, int(int(container['width']) * 0.965),
                                                  int(int(container['height']) * 0.945))
        self.scrollable_canvas.grid(row=1, column=1)

        self.TabLabelNCol = []
        self.TabLabels = []

        for r in range(NLine):
            self.TabLabelCol = []
            for i in range(NCol):
                self.TabLabelNCol.append(
                    tk.Label(self.scrollable_canvas.interior, text='', relief=tk.RIDGE,
                             width=int(int(container['width']) * LabelWidth[i]), height=2, bg='white', font=Font1))
                self.TabLabelNCol[i].grid(row=0, column=i)
                self.TabLabelCol.append(tk.Label(self.scrollable_canvas.interior, text='', relief=tk.RIDGE,
                                                 width=int(int(container['width']) * LabelWidth[i]), bg='white',
                                                 font=Font2))
                self.TabLabelCol[i].grid(row=r + 1, column=i)
                self.TabLabelNCol[i]['text'] = ListLabelCol[i]

            self.TabLabels.append(self.TabLabelCol)

        for r in range(NLine):
            for i in range(NCol):
                def GestEvt(evt, j=r):
                    return self.SelectLine(evt, j)

                self.TabLabels[r][i].bind('<Button-1>', GestEvt)
                ChangeCursor(self.TabLabels[r][i])

    def SelectLine(self, _, j):
        self.ActionUnSelect()
        for i in range(self.NCol):
            self.TabLabels[j][i].config(bg='#E0E0E0')
        self.IndexElt = j
        if self.MainAppli.MainAppli.MainAppli.BaseEnCours == 'PHYS':
            self.MainAppli.AffichStockMatPhys(self.IndexElt)

    def ActionUnSelect(self):
        for r in range(self.NLine):
            for i in range(self.NCol):
                self.TabLabels[r][i].config(bg='white')
