#include <FastLED.h>
#define NUM_LEDS 30
#define LED_TYPE WS2812B
#define COLOR_ORDER BRG//RGB

CRGB leds[NUM_LEDS];

const int stripPin  = 3;
unsigned long previousMillis = 0; 
const long interval = 28800000;
const long interval2 = 57600000;
int ledState = LOW;
int BRIGHTNESS = 250;
unsigned long startTime = 0;

const int OnOffSwitchPin = 12;
const int OnOffSwitchTimePin = 2;
const int PinLEDOnOff = 13;
const int PinLEDTimeOnOff = 4;

const int PinLEDBlueOnOff = 10;
const int OnOffSwitchPinBlue = 11;

const int PinLEDRedOnOff = 8;
const int OnOffSwitchPinRed = 9;

const int PinLEDGreenOnOff = 6;
const int OnOffSwitchPinGreen = 7;

int OnOffSwitchState = 0;  
int previousOnOffSwitchState = 0; 
int OnOffSwitchTimeState = 0;  
int previousOnOffSwitchTimeState = 0; 
int state=0;
int previousstate=0;
int stateTime=0;
int previousstateTime=0;

int OnOffBlueState = 0;  
int previousOnOffBlueState = 0; 
int Bluestate=1;
int previousBluestate=1;

int OnOffRedState = 0;  
int previousOnOffRedState = 0; 
int Redstate=1;
int previousRedstate=1;

int OnOffGreenState = 0;  
int previousOnOffGreenState = 0; 
int Greenstate=1;
int previousGreenstate=1;
 

void AllumLeds() {
  int LedBlue = 3;
  int LedGreen = 5;
  int LedRed = 1;
  for (int i = 0; i < NUM_LEDS; i++) {
      if (i!=LedBlue and i!=LedGreen and i!=LedRed){
      leds[i].setRGB(255, 255, 255);
      }
      else{
        if (i==LedBlue){
          if (Bluestate==1){
            leds[i].setRGB(0, 255, 0);
            }
          else{
            leds[i].setRGB(255, 255, 255);
          }
        LedBlue = LedBlue + 4;
        }
        else {
          if (i==LedGreen){
            if (Greenstate==1){
                leds[i].setRGB(0, 0, 255);
              }
              else {
                leds[i].setRGB(255, 255, 255);
              }
          LedGreen = LedGreen + 8;
          }
          else {
            if (Redstate==1){
            leds[i].setRGB(255, 0, 0);
            }
            else {
              leds[i].setRGB(255, 255, 255);
            }
            LedRed = LedRed + 8;
          }
        }
      }
  }
  FastLED.show(); 
  ledState = HIGH;  
}

void EteintLeds() {
  ledState = LOW;
  for (int j = 0; j < NUM_LEDS; j++) {
  leds[j].setRGB(0,0,0);
  }
  FastLED.show();
}

void LedScenario() {
  unsigned long currentMillis = millis();
  if (ledState == LOW) {
    if (currentMillis - previousMillis >= interval2) {
      previousMillis = currentMillis;    
      AllumLeds();
      }
    }
    else {
      if (currentMillis - previousMillis >= interval) {
        previousMillis = currentMillis;
        EteintLeds();
      }
    }
}

void setup() {
FastLED.addLeds<LED_TYPE, stripPin, COLOR_ORDER>(leds, NUM_LEDS);
FastLED.setBrightness(BRIGHTNESS);
pinMode (PinLEDOnOff, OUTPUT);
pinMode (PinLEDTimeOnOff, OUTPUT);
pinMode (PinLEDBlueOnOff, OUTPUT);
pinMode (PinLEDRedOnOff, OUTPUT);
pinMode (PinLEDGreenOnOff, OUTPUT);
pinMode (OnOffSwitchPin, INPUT);
pinMode (OnOffSwitchTimePin, INPUT);
pinMode (OnOffSwitchPinBlue, INPUT);
pinMode (OnOffSwitchPinRed, INPUT);
pinMode (OnOffSwitchPinGreen, INPUT);
}

void loop() {
  OnOffSwitchState = digitalRead(OnOffSwitchPin);
  delay(10);
  if ((OnOffSwitchState == HIGH)&&(previousOnOffSwitchState == LOW)) 
 {
    state=1-state;
    startTime= millis();
    delay(10);
 }
 else 
 {
    if ((OnOffSwitchState == LOW)&&(previousOnOffSwitchState == HIGH)) 
    {
    delay(10);
    }
    else {
    if ((OnOffSwitchState == HIGH) && (previousOnOffSwitchState == HIGH)) {
    if (state == 1 && (millis() - startTime) > 500) {
    BRIGHTNESS = BRIGHTNESS + 25;
    if (BRIGHTNESS > 250) {
      BRIGHTNESS = 25;
    }
    FastLED.setBrightness(BRIGHTNESS);
    FastLED.show();
    delay(500);
    }  
    }
    }
 }
 previousOnOffSwitchState = OnOffSwitchState;

OnOffSwitchTimeState = digitalRead(OnOffSwitchTimePin);
  delay(10);
  
  if ((OnOffSwitchTimeState == HIGH)&&(previousOnOffSwitchTimeState == LOW)) 
 {
    stateTime=1-stateTime;
    delay(10);
 }
 else 
 {
    if ((OnOffSwitchTimeState == LOW)&&(previousOnOffSwitchTimeState == HIGH)) 
    {
    delay(10);
    }
 }
 previousOnOffSwitchTimeState = OnOffSwitchTimeState;

OnOffBlueState = digitalRead(OnOffSwitchPinBlue);
  delay(10);
  if ((OnOffBlueState == HIGH)&&(previousOnOffBlueState == LOW)) 
 {
    Bluestate=1-Bluestate;
    delay(10);    
 }
 else 
 {
    if ((OnOffBlueState == LOW)&&(previousOnOffBlueState == HIGH)) 
    {
    delay(10);
    }
 }
 previousOnOffBlueState = OnOffBlueState;

OnOffRedState = digitalRead(OnOffSwitchPinRed);
  delay(10);
  if ((OnOffRedState == HIGH)&&(previousOnOffRedState == LOW)) 
 {
    Redstate=1-Redstate;
    delay(10);    
 }
 else 
 {
    if ((OnOffRedState == LOW)&&(previousOnOffRedState == HIGH)) 
    {
    delay(10);
    }
 }
 previousOnOffRedState = OnOffRedState;

 OnOffGreenState = digitalRead(OnOffSwitchPinGreen);
  delay(10);
  if ((OnOffGreenState == HIGH)&&(previousOnOffGreenState == LOW)) 
 {
    Greenstate=1-Greenstate;
    delay(10);    
 }
 else 
 {
    if ((OnOffGreenState == LOW)&&(previousOnOffGreenState == HIGH)) 
    {
    delay(10);
    }
 }
 previousOnOffGreenState = OnOffGreenState;


if (state==1) {
  if (previousstate==0) {
    AllumLeds();
    digitalWrite(PinLEDOnOff, HIGH);
    digitalWrite(PinLEDBlueOnOff, Bluestate);
    digitalWrite(PinLEDRedOnOff, Redstate);
    digitalWrite(PinLEDGreenOnOff, Greenstate);
    previousstate=1;
    }
  else{
    if (stateTime==1) {
      if (previousstateTime==0) {
        previousMillis = millis();
        previousstateTime=1; 
        digitalWrite(PinLEDTimeOnOff, HIGH);
        }
       else {
        LedScenario();
       }
      }
    else {
      if (previousstateTime==1) {
        AllumLeds();
        previousstateTime=0; 
        digitalWrite(PinLEDTimeOnOff, LOW);
      }
     }
    }
  if ((Bluestate==1 and previousBluestate==0) or (Bluestate==0 and previousBluestate==1)) {
     digitalWrite(PinLEDBlueOnOff, Bluestate);
     previousBluestate = Bluestate;
     AllumLeds();
   }   

  if ((Redstate==1 and previousRedstate==0) or (Redstate==0 and previousRedstate==1)) {
     digitalWrite(PinLEDRedOnOff, Redstate);
     previousRedstate = Redstate;
     AllumLeds();
   }   

  if ((Greenstate==1 and previousGreenstate==0) or (Greenstate==0 and previousGreenstate==1)) {
     digitalWrite(PinLEDGreenOnOff, Greenstate);
     previousGreenstate = Greenstate;
     AllumLeds();
   }   
}
else 
{
  EteintLeds();
  digitalWrite(PinLEDOnOff, LOW);
  digitalWrite(PinLEDTimeOnOff, LOW);
  digitalWrite(PinLEDBlueOnOff, LOW);
  digitalWrite(PinLEDRedOnOff, LOW);
  digitalWrite(PinLEDGreenOnOff, LOW);
  state=0;
  previousstate=0;
  stateTime=0;
  previousstateTime=0;
  Redstate=1;
  previousRedstate=1;
  Bluestate=1;
  previousBluestate=1;
  Greenstate=1;
  previousGreenstate=1;
}
}


