
// include the library code:
#include <LiquidCrystal.h>

// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

// set up a constant for the switchPin
const int switchPin = 6;

// variable to hold the value of the switchPin
int switchState = 0;

// variable to hold previous value of the switchpin
int prevSwitchState = 0;

// a variable to choose which reply on the LCD
int reply;

void setup() {
  // set up the number of columns and rows on the LCD 
  lcd.begin(16, 2);
  
  // set up the switch pin as an input
  pinMode(switchPin,INPUT);
  
  // Print a message to the LCD.
  lcd.print("Appuyez sur le");
  // set the cursor to column 0, line 1
  // line 1 is the second row, since counting begins with 0
  lcd.setCursor(0, 1);
  // print to the second line
  lcd.print("bouton poussoir");
}

void loop() {
  // check the status of the switch
  switchState = digitalRead(switchPin);

  // compare the switchState to its previous state
  if (switchState != prevSwitchState) {
   
    if (switchState == HIGH) {
      // randomly chose a reply
      reply = random(10);
      // clean up the screen before printing a new reply
      lcd.clear();
      // set the cursor to column 0, line 0     
      lcd.setCursor(0, 0);
      // print some text
      lcd.print("Chiffre:");
      // move the cursor to the second line
      lcd.setCursor(0, 1);

     
      switch(reply){
      case 0:
        lcd.print("Zero");
        break;

      case 1:
        lcd.print("Un");
        break;

      case 2:
        lcd.print("Deux");
        break;

      case 3:
        lcd.print("Trois");
        break;

      case 4:
        lcd.print("Quatre");
        break;

      case 5:
        lcd.print("Cinq");
        break;

      case 6:
        lcd.print("Six");
        break;

      case 7:
        lcd.print("Sept");
        break;

      case 8:
        lcd.print("Huit");
        break;

      case 9:
        lcd.print("Neuf");
        break;
      }
    }
  }
  // save the current switch state as the last state 
  prevSwitchState = switchState;
}

