#include <LiquidCrystal.h>

LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

//Constants:
const int sensorPin = A0; //pin A0 to read analog input

const int onOffSwitchStateSwitchPin = 7;
const int PinLED = 6;

int onOffSwitchState = 0;  
int previousOnOffSwitchState = 0; 
int state=0;
 
//Variables:
int value = 0; //save analog value
int previousvalue = 0;
 
void setup(){
 
  Serial.begin(9600);       //Begin serial communication
  pinMode(onOffSwitchStateSwitchPin, INPUT);
  pinMode(PinLED,OUTPUT);

  lcd.begin(16, 2);
  lcd.clear();
  lcd.setCursor(0, 0);
  lcd.print ("ARDUINO -");
  lcd.setCursor(0, 1);
  lcd.print ("CAPTEUR FORCE");
 
}
 
void loop(){

  onOffSwitchState = digitalRead(onOffSwitchStateSwitchPin);
  delay(1);
  if ((onOffSwitchState == HIGH)&&(previousOnOffSwitchState == LOW)) 
 {
    state=1-state;
    delay(10);
 }
 else 
 {
    if ((onOffSwitchState == LOW)&&(previousOnOffSwitchState == HIGH)) 
    {
    delay(10);
    }
 }
 previousOnOffSwitchState = onOffSwitchState;

if (state==1) 
{ 
 digitalWrite(PinLED, HIGH);
  value = analogRead(sensorPin);       //Read and save analog value from sensor
  Serial.println(value);               //Print value

  if (value!=previousvalue and value>1) {
  lcd.clear();
   lcd.setCursor(0, 0);
   lcd.print("Valeur capteur:");
   lcd.setCursor(0, 1);
   lcd.print (value);
   previousvalue = value;
   }
   
  delay(100);                          //Small delay
  }
 else 
{
  digitalWrite(PinLED, LOW);
   lcd.clear();
   lcd.setCursor(0, 0);
   lcd.print ("ARDUINO -");
   lcd.setCursor(0, 1);
   lcd.print ("CAPTEUR FORCE");
   
   delay(100);
}  
}
