// Déclaration des constantes et variables

const int PinSensor=0;
const int PinButton= 12;
const int PinLedR = 8;
const int PinLedV = 7;
const int PinLedB = 2;
const float TempRef = 20.0;
const float DT = 1.0;

int ValSensor = 0;
float tension = 0.0;
float Temp = 0.0;
float OldTemp = 0.0;

int ValButton = 0;
int OldValButton = 0;
int State = 0;
int OldState = 0;


// Initialisation des entrées et sorties

void setup() {
  Serial.begin(9600);
  pinMode(PinButton,INPUT);
  pinMode(PinLedR,OUTPUT);
  pinMode(PinLedV,OUTPUT);
  pinMode(PinLedB,OUTPUT);
  Serial.println("Appuyez sur le bouton poussoir pour commencer les mesures.");
}


// Fonction principale en boucle

void loop() {
  ValButton = digitalRead(PinButton);
  delay(10);

  if ((ValButton == HIGH)&&(OldValButton == LOW)) 
  {
  State=1-State;
  }
  OldValButton = ValButton;

  if (State==1) 
  {
  if (OldState == 0)
  {
   Serial.println("Mesure de la temperature en cours.");
   Serial.println("");
   Serial.println ("Temperature en degre Celsius:");
   OldState=1;
  }
  ValSensor = analogRead(PinSensor);
  tension = (ValSensor/1023.0)*5.0;

  // Capteur TMP 36
  Temp = (tension - 0.5) * 100;

  // Capteur LM 35
  //Temp = tension * 100;

  if (OldTemp != Temp)
  {
    Serial.println(Temp,1);
    OldTemp = Temp;
  }
  if ((Temp > TempRef - DT) && (Temp < TempRef + DT)) {
    digitalWrite(PinLedR, LOW);
    digitalWrite(PinLedV, HIGH);
    digitalWrite(PinLedB, LOW);
  }

  if (Temp > TempRef + DT)  {
    digitalWrite(PinLedR, HIGH);
    digitalWrite(PinLedV, LOW);
    digitalWrite(PinLedB, LOW);
  }
  
  if (Temp < TempRef - DT)  {
    digitalWrite(PinLedR, LOW);
    digitalWrite(PinLedV, LOW);
    digitalWrite(PinLedB, HIGH);
  }
  delay(100);
  }
  else
  {
   if (OldState == 1){
   Serial.println("Fin des mesures.");
   digitalWrite(PinLedB, LOW);
   digitalWrite(PinLedR, LOW);
   digitalWrite(PinLedV, LOW);
   OldState = 0;} 
  }   
}
