# Importations des librairies et définition de fonctions

from ConnectToArduino import *
import asyncio

def Set_AnalogInput_Pin(board,pin):
    loop.run_until_complete(board.set_pin_mode_analog_input(pin))

def Analog_Read(board, pin):
    value = loop.run_until_complete(board.analog_read(pin))
    return value[0]

def Set_AnalogOutput_Pin(board,pin):
    loop.run_until_complete(board.set_pin_mode_pwm(pin))

def Analog_Write(board, pin, val):
    loop.run_until_complete(board.analog_write(pin, val))

def Arduino_Exit(board):
    loop.run_until_complete(board.shutdown())


# Déclaration des constantes et variables

PinLedR = 11
PinPot = 0
ValPot = 0


# Connexion à l'Arduino
            
PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

loop = asyncio.get_event_loop()
Set_AnalogOutput_Pin(board, PinLedR)
Set_AnalogInput_Pin(board, PinPot)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")
    

# Boucle principale du programme

while True:
    try: 
        ValPot = Analog_Read(board,0)
        Analog_Write(board,PinLedR,int(ValPot/4))
                       
    except KeyboardInterrupt:            
        Analog_Write(board,PinLedR,0)
        Arduino_Exit(board)
        sys.exit(0)
