# Importations des librairies et définition de fonctions

from ConnectToArduino import *
import asyncio

def Set_AnalogOutput_Pin(board,pin):
    loop.run_until_complete(board.set_pin_mode_pwm(pin))

def Analog_Write(board, pin, val):
    loop.run_until_complete(board.analog_write(pin, val))
    
def Arduino_Exit(board):
    loop.run_until_complete(board.shutdown())
    

# Déclaration des constantes et variables

PinLedR = 11


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties
    
loop = asyncio.get_event_loop()
Set_AnalogOutput_Pin(board, PinLedR)
    
print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")

    
# Boucle principale du programme

print("Veuillez saisir la luminosite de la DEL rouge (nombre entier entre 0 et 255):")

while True:
    try: 
        ChoixRP=False
        while ChoixRP==False:
            saisie = input("")
            try:
                saisie = int(saisie)
                assert saisie >= 0 and saisie <= 255
                ChoixRP = True
            except AssertionError:
                print("Le nombre indiqué n'est pas entre 0 et 255 !")
                ChoixRP = False           
            except:
                print("Vous n'avez pas saisi un nombre entre 0 et 255 !")

        Analog_Write(board,PinLedR,saisie)
                       
    except KeyboardInterrupt:            
        Analog_Write(board,PinLedR,0)
        Arduino_Exit(board)
        sys.exit(0)
