# Importations des librairies et définition de fonctions

from ConnectToArduino import *
import asyncio


def Set_DigitalInput_Pin(board, pin):
    loop.run_until_complete(board.set_pin_mode_digital_input(pin))

def Digital_Read(board, pin):
    value = loop.run_until_complete(board.digital_read(pin))
    return value[0]

def Set_DigitalOutput_Pin(board, pin):
    loop.run_until_complete(board.set_pin_mode_digital_output(pin))

def Digital_Write(board, pin, val):
    loop.run_until_complete(board.digital_write(pin, val))

def Arduino_Exit(board):
    loop.run_until_complete(board.shutdown())

# Déclaration des constantes et variables

PinLedR = 11
PinButton = 12
ValButton = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

loop = asyncio.get_event_loop()
Set_DigitalOutput_Pin(board, PinLedR)
Set_DigitalInput_Pin(board, PinButton)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")
    

# Boucle principale du programme
print("Appuyez sur le bouton poussoir pour allumer la DEL.")

while True:
    try: 
        ValButton = Digital_Read(board, PinButton)
        if ValButton == 1:
            Digital_Write(board,PinLedR,1)
        else:
            Digital_Write(board,PinLedR,0)
                       
    except KeyboardInterrupt:            
        Digital_Write(board,PinLedR,0)
        Arduino_Exit(board)
        sys.exit(0)
