# Importations des librairies et définition de fonctions

from ConnectToArduino import *
import asyncio

def Set_DigitalOutput_Pin(board, pin):
    loop.run_until_complete(board.set_pin_mode_digital_output(pin))

def Digital_Write(board, pin, val):
    loop.run_until_complete(board.digital_write(pin, val))

def Arduino_Exit(board):
    loop.run_until_complete(board.shutdown())


# Déclaration des constantes et variables

PinLedR = 11


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

loop = asyncio.get_event_loop()
Set_DigitalOutput_Pin(board, PinLedR) 
    
print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")
    
    
# Boucle principale du programme

print("Pour allumer la DEL rouge, envoyer: ON");
print("Pour éteindre la DEL rouge, envoyer: OFF\n");

while True:
    try: 
        saisie = str(input(""))
        if saisie=="ON" : Digital_Write(board,PinLedR,1)
        elif saisie=="OFF" : Digital_Write(board,PinLedR,0)
                       
    except KeyboardInterrupt:            
        Digital_Write(board,PinLedR,0)
        Arduino_Exit(board)
        sys.exit(0)
