# Importations des librairies et définition de fonctions

from ConnectToArduino import *
import asyncio
import time

async def Get_Distance(data):
    global Distance
    Distance = data[1]

def Set_Sonar_Pins(board, trigger_pin, echo_pin):
    loop.run_until_complete(board.set_pin_mode_sonar(trigger_pin, echo_pin, Get_Distance))
    
def Sonar_Read(board, trigger_pin):
    loop.run_until_complete(board.sonar_read(trigger_pin))

def Arduino_Exit(board):
    loop.run_until_complete(board.shutdown())
    

# Déclaration des constantes et variables

TRIGGER_PIN = 8 
ECHO_PIN = 9
Distance = 0
OldDistance = 0


# Connexion à l'Arduino
             
PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

loop = asyncio.get_event_loop()
Set_Sonar_Pins(board, TRIGGER_PIN, ECHO_PIN)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")
    

# Boucle principale du programme

while True:
    try: 
        Sonar_Read(board,TRIGGER_PIN)
        if Distance != OldDistance:
            print("Distance (cm):",Distance)
            OldDistance = Distance                
        time.sleep(.01)
                       
    except KeyboardInterrupt:            
        Arduino_Exit(board)
        sys.exit(0)
