# Importations des librairies et définition de fonctions

from ConnectToArduino import *
import asyncio
import time

def Tone(board,pin,freq,duration):
    if duration>0:
        loop.run_until_complete(board.play_tone(pin, freq, duration))
    else:
        loop.run_until_complete(board.play_tone_continuously(pin, freq))
                                
def No_Tone(board,pin):
    loop.run_until_complete(board.play_tone_off(pin))

def Set_Tone_Pin(board,pin):
    loop.run_until_complete(board.set_pin_mode_tone(pin))

def Arduino_Exit(board):
    loop.run_until_complete(board.shutdown())

    
# Déclaration des constantes et variables

PinTone = 3
FreqTone = 440
TimeSleep1 = 0.5
TimeSleep2 = 0.5


# Connexion à l'Arduino
             
PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)

# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

loop = asyncio.get_event_loop()
Set_Tone_Pin(board, PinTone)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")
    

# Boucle principale du programme

while True:
    try: 
        Tone(board, PinTone, FreqTone, 0)
        time.sleep(TimeSleep1)
        No_Tone(board, PinTone)
        time.sleep(TimeSleep2)
                       
    except KeyboardInterrupt:            
        No_Tone(board, PinTone)
        Arduino_Exit(board)
        sys.exit(0)
