# Importations des librairies et définition de fonctions

from ConnectToArduino import *

def AnalogOutput(board,pin):
    AnalogOutputPin=board.get_pin('d:'+ str(pin) +':p')
    return AnalogOutputPin

def AnalogWrite(board,pin,val):         
    board.digital[pin].write(val)


# Déclaration des constantes et variables

PinLedR = 11
RapportCyclique = 0.0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)
    
PinPWM = AnalogOutput(board, PinLedR)
    
print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")

    
# Boucle principale du programme

print("Veuillez saisir la luminosite de la DEL rouge (nombre entier entre 0 et 100):")

while True:
    try: 
        ChoixRP=False
        while ChoixRP==False:
            saisie = input("")
            try:
                saisie = int(saisie)
                assert saisie >= 0 and saisie <= 100
                ChoixRP = True
            except AssertionError:
                print("Le nombre indiqué n'est pas entre 0 et 100 !")
                ChoixRP = False           
            except:
                print("Vous n'avez pas saisi un nombre entre 0 et 100 !")

        RapportCyclique = float(saisie/100)
        AnalogWrite(board,PinLedR,RapportCyclique)
                       
    except KeyboardInterrupt:            
        AnalogWrite(board,PinLedR,0)
        board.exit()
        sys.exit(0)
