# Importations des librairies et définition de fonctions

from ConnectToArduino import *
import time

def DigitalInput(board,pin):
    DigitalInputPin=board.get_pin('d:'+ str(pin) +':i')
    return DigitalInputPin

def DigitalWrite(board,pin,val):         
    board.digital[pin].write(val)

def Iterateur(board):
    it = pyfirmata.util.Iterator(board)
    it.start()
    return it


# Déclaration des constantes et variables

PinLedR = 11
PinButton = 12
ValButton = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)
    
ArduinoIterateur = Iterateur(board)
InputPin = DigitalInput(board, PinButton)
time.sleep (0.5)
print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")
    

# Boucle principale du programme

print("Appuyez sur le bouton poussoir pour allumer la DEL.")

while True:
    try: 
        ValButton = InputPin.read()
        if ValButton == 1:
            DigitalWrite(board,PinLedR,1)
        else:
            DigitalWrite(board,PinLedR,0)
                       
    except KeyboardInterrupt:            
        DigitalWrite(board,PinLedR,0)
        board.exit()
        sys.exit(0)
