import pyfirmata


########## GESTION DES SORTIES NUMERIQUES ##########

# MODIFICATION DE L'ETAT LOGIQUE D'UNE SORTIE NUMERIQUE

def DigitalWrite(board,pin,val):
    board.digital[pin].write(val)

    

########## GESTION DES ENTREES NUMERIQUES ##########

# DECLARATION D'UNE BROCHE EN ENTREE NUMERIQUE
# LECTURE DE L'ETAT LOGIQUE AVEC LA FONCTION DigitalInputPin.read()

def DigitalInput(board,pin):
    DigitalInputPin=board.get_pin('d:'+ str(pin) +':i')
    return DigitalInputPin



########## GESTION DES SORTIES ANALOGIQUES ##########

# DECLARATION D'UNE BROCHE EN SORTIE ANALOGIQUE

def AnalogOutput(board,pin):
    AnalogOutputPin=board.get_pin('d:'+ str(pin) +':p')
    return AnalogOutputPin

# MODIFICATION DE LA VALEUR D'UNE SORTIE ANALOGIQUE

def AnalogWrite(board,pin,val):
    board.digital[pin].write(val)
    


########## GESTION DES ENTREES ANALOGIQUES ##########

# DECLARATION D'UNE BROCHE EN ENTREE ANALOGIQUE
# LECTURE DE LA VALEUR DE L'ENTREE ANALOGIQUE AVEC LA FONCTION AnalogInputPin.read()

def AnalogInput(board,pin):
    AnalogInputPin = board.get_pin('a:'+ str(pin) +':i')
    return AnalogInputPin



########## ITERATEUR ##########

# DECLARATION D'UN ITERATEUR POUR EVITER LA SATURATION DU PORT SERIE

def Iterateur(board):
    it = pyfirmata.util.Iterator(board)
    it.start()
    return it
