# Importations des librairies et définition de fonctions

from PymataExpressDef import *
from ConnectToArduino import *


# Déclaration des constantes et variables

PinLedR = 11
PinLedB = 10
PinTone = 3
FreqTone = 440
PinPot = 0
ValPot = 0
PinButton = 12
ValButton = 0


# Connexion à l'Arduino
             
PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

Set_AnalogOutput_Pin(board, PinLedR)
Set_AnalogInput_Pin(board, PinPot)
Set_DigitalOutput_Pin(board, PinLedB)
Set_DigitalInput_Pin(board, PinButton)
Set_Tone_Pin(board, PinTone)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")
    

# Boucle principale du programme

while True:
    try:
        ValButton = Digital_Read(board, PinButton)
        if ValButton == 1:
            Digital_Write(board,PinLedB,1)
            Tone(board, PinTone, FreqTone, 0)
        else:
            Digital_Write(board,PinLedB,0)
            No_Tone(board, PinTone)

        ValPot = Analog_Read(board,0)
        Analog_Write(board,PinLedR,int(ValPot/4))
                       
    except KeyboardInterrupt:            
        Analog_Write(board,PinLedR,0)
        Digital_Write(board,PinLedB,0)
        No_Tone(board, PinTone)
        Arduino_Exit(board)
        sys.exit(0)

