# Importations des librairies et définition de fonctions

from PyFirmataDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinLedR = 11
PinLedB = 10
PinButton = 12
ValButton = 0
PinPot = 0
ValPot = 0


# Connexion à l'Arduino
             
PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

DigitalInputPin = DigitalInput(board, PinButton)
AnalogInputPin = AnalogInput(board, PinPot)
PinPWM = AnalogOutput(board, PinLedR)
  
ArduinoIterateur = Iterateur(board)
time.sleep(0.5)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")
    

# Boucle principale du programme

while True:
    try:
        ValButton = DigitalInputPin.read()
        if ValButton == 1:
            DigitalWrite(board,PinLedB,1)
        else:
            DigitalWrite(board,PinLedB,0)
        ValPot = AnalogInputPin.read()
        AnalogWrite(board,PinLedR,ValPot)
                       
    except KeyboardInterrupt:
        DigitalWrite(board,PinLedB,0)
        AnalogWrite(board,PinLedR,0)
        board.exit()
        sys.exit(0)

