// Déclaration des constantes et variables

const int PinSensor = 0;
const int PinButton = 12;
const int PinLed = 9;
const int PMax = 240;
const int PMin = 50;

int ValSensor = 0;
float tension = 0.0;
float Pression = 0.0;
float OldPression = 0.0;
int Vol = 0;

int ValButton = 0;
int OldValButton = 0;
int State = 0;
int OldState = 0;


// Initialisation des entrées et sorties

void setup() {
  Serial.begin(9600);
  pinMode(PinButton,INPUT);
  pinMode(PinLed,OUTPUT);
  Serial.println("Appuyez sur le bouton poussoir pour commencer les mesures.");
}


// Fonction principale en boucle

void loop() {

ValButton = digitalRead(PinButton);
delay(10);

if ((ValButton == HIGH)&&(OldValButton == LOW))
  {
  State=1-State;
  }

OldValButton = ValButton;

if (State==1) 
{
  if (OldState == 0)
  {
    Serial.print("Veuillez saisir le volume V de la seringue en mL ");
    Serial.println("(valeur entre 10 et 60 mL).");
    Vol = 0;
    while(Vol<10 || Vol>60)  
    {     
    Vol=Serial.parseInt();
    }
    Serial.println("Mesure de la pression en cours.");
    Serial.println("");
    Serial.println ("Volume (mL);Pression (kPa):");
    OldState=1;
  }
  Pression = 0;
  for(int i = 0 ; i < 10 ; i++){
    ValSensor = analogRead(PinSensor);
    tension = (ValSensor/1023.0)*5.0;
    Pression = Pression + (tension / 0.02 + 10);
  }
  Pression = Pression / 10;
  if (OldPression != Pression)
  {
    Serial.print(Vol);
    Serial.print(";");
    Serial.println(Pression,1);
    OldPression = Pression;
  }
  if (Pression>PMax or Pression<PMin)
  {
    digitalWrite(PinLed,HIGH);
  }
  else {
    digitalWrite(PinLed,LOW);
  }
  delay(500);  
  }
  else
  {
    if (OldState == 1){
    Serial.println("Fin des mesures.");
    Serial.println("");
    digitalWrite(PinLed,LOW);
    OldState = 0;} 
  }   
}
