// Déclaration des constantes et variables

const int PinSensor=0;
const int PinButton= 12;

int ValSensor = 0;
float tension = 0.0;
float Pression = 0.0;
float PRef = 0.0;
float Dz=0.0;
float OldDz = 0.0;

int ValButton = 0;
int OldValButton = 0;
int State = 0;
int OldState = 0;
boolean BtnAppui = false;


// Initialisation des entrées et sorties

void setup() {
  Serial.begin(9600);
  pinMode(PinButton,INPUT);
  Serial.print("Placer le tuyau a la position de reference ");
  Serial.println("et appuyez sur le bouton poussoir.");
  while (BtnAppui==false){
    ValButton = digitalRead(PinButton);
    if ((ValButton == HIGH)&&(OldValButton == LOW)){
       BtnAppui=true;
    delay (200);
    }
  }
  OldValButton = ValButton;
  ValSensor = analogRead(PinSensor);
  tension = (ValSensor/1023.0)*5.0;
  PRef = (tension / 0.02) + 10;
  Serial.println("Appuyez sur le bouton poussoir pour commencer les mesures.");
}


// Fonction principale en boucle

void loop() {
  ValButton = digitalRead(PinButton);
delay(10);

if ((ValButton == HIGH)&&(OldValButton == LOW)) 
  {
  State=1-State;
  }
OldValButton = ValButton;

if (State==1) 
  {
  if (OldState == 0)
  {
   Serial.println("Mesure de la pression en cours.");
   Serial.println("");
   Serial.println ("Pression (en kPa), Profondeur (cm):");
   OldState=1;
  }
  ValSensor = analogRead(PinSensor);
  tension = (ValSensor/1023.0)*5.0;
  Pression = (tension / 0.02) + 10;
  Dz = 100*(Pression-PRef)/9.81;

  if (abs(OldDz - Dz)>2)
  {
    Serial.print(Pression,1);
    Serial.print(" ; ");
    Serial.println(Dz,0);
    OldDz = Dz;
  }
  delay(500);
  }
  else
  {
    if (OldState == 1){
    Serial.println("Fin des mesures.");
    OldState = 0;} 
  }   
}
