# Importations des librairies et définition des fonctions

from PyFirmataDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinLEDR = 8
PinLEDV = 7
PinLEDB = 2
PinButton = 12
ComptBtn = 0
ValButton = 0
OldValButton = 0
StartTime = 0
DeltaTime = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

DigitalInputPin = DigitalInput(board, PinButton)
ArduinoIterateur = Iterateur(board)
time.sleep (0.5)

print("Connexion à l'arduino établie- Appuyez sur Ctrl-C pour quitter")


# Boucle principale du programme

while True:
    try:
        ValButton = DigitalInputPin.read()
        time.sleep(0.01)
        if ValButton == 1 and OldValButton == 0:
            StartTime=time.time()
            ComptBtn = ComptBtn +1
            if ComptBtn == 4: ComptBtn = 1
        if ValButton == 1 and OldValButton == 1:
            DeltaTime=time.time()-StartTime
            if DeltaTime > 0.5: ComptBtn = 0
        
        OldValButton = ValButton

        if ComptBtn == 0:
            board.digital[PinLEDR].write(0)
            board.digital[PinLEDV].write(0)
            board.digital[PinLEDB].write(0)
        elif ComptBtn == 1:
            board.digital[PinLEDR].write(1)
            board.digital[PinLEDV].write(0)
            board.digital[PinLEDB].write(0)
        elif ComptBtn == 2:
            board.digital[PinLEDR].write(0)
            board.digital[PinLEDV].write(1)
            board.digital[PinLEDB].write(0)
        elif ComptBtn == 3:
            board.digital[PinLEDR].write(0)
            board.digital[PinLEDV].write(0)
            board.digital[PinLEDB].write(1)

    except KeyboardInterrupt:
        board.digital[PinLEDR].write(0)
        board.digital[PinLEDV].write(0)
        board.digital[PinLEDB].write(0)
        board.exit()
        sys.exit(0)

