# Importations des librairies et définition des fonctions

from PyFirmataDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinLED = 11
PinSensor = 5
ValSensor = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties
    
ArduinoIterator = Iterateur(board)
PinAnalogInput = AnalogInput(board, PinSensor)
time.sleep (0.5)

print("Connexion à l'Arduino établie - Appuyez sur Ctrl-C pour quitter")

# Boucle principale du programme

while True:
    try:
        ValSensor = PinAnalogInput.read()
        DigitalWrite(board, PinLED, 1)
        time.sleep(ValSensor)
        DigitalWrite(board, PinLED, 0)
        time.sleep(ValSensor)
    
    except KeyboardInterrupt:
        DigitalWrite(board, PinLED, 0)
        board.exit()
        sys.exit(0)
