# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinTone = 3
PinLED = 4
FreqTone = 440
TimeSleep1 = 0.5
TimeSleep2 = 0.5


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

Set_Tone_Pin(board, PinTone)
Set_DigitalOutput_Pin(board, PinLED)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter")


# Boucle principale du programme

while True:
    try:
        Digital_Write(board, PinLED, 1)
        Tone(board, PinTone, FreqTone, 0)
        time.sleep(TimeSleep1)
        Digital_Write(board, PinLED, 0)
        No_Tone(board, PinTone)
        time.sleep(TimeSleep2)

    except KeyboardInterrupt:
        No_Tone(board, PinTone)
        Digital_Write(board, PinLED, 0)
        Arduino_Exit(board)
        sys.exit(0)
