# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinTone=3
PinPhotoR=0
PinLED=4
CapteurSensib = 700
ValCapteur = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

Set_Tone_Pin(board, PinTone)
Set_AnalogInput_Pin(board, PinPhotoR)
Set_DigitalOutput_Pin(board, PinLED)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter")

Digital_Write(board, PinLED, 1)


# Boucle principale du programme

while True:
    try:
        ValCapteur = Analog_Read(board,PinPhotoR)
        if ValCapteur < CapteurSensib:
            Tone(board,PinTone,440,0)
            time.sleep(0.2)
            No_Tone(board,PinTone)
            time.sleep(0.2)
        else:
            No_Tone(board,PinTone)                 

    except KeyboardInterrupt:
        Digital_Write(board, PinLED, 0)
        No_Tone(board, PinTone) 
        Arduino_Exit(board)
        sys.exit(0)
        
