# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinTone = 3
PinButton = 12
FreqWave = 440
ValButton = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties

Set_Tone_Pin(board, PinTone)
Set_DigitalInput_Pin(board, PinButton)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter")


# Boucle principale du programme

while True:
    try:    
        ValButton = Digital_Read(board, PinButton)
        time.sleep(0.01)
        
        if ValButton == 1: Tone(board, PinTone, FreqWave, 0)
        else:  No_Tone(board, PinTone)
    
    except KeyboardInterrupt:
        No_Tone(board, PinTone)
        Arduino_Exit(board)
        sys.exit(0)
