# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time


# Déclaration des constantes et variables

PinTone=3
PinButton=[12,11,10,9,8]
Notes=[262,294,330,349,392]
NoteDurations=[4,4,4,4,8]

PlayNote = False
Note = 0
NoteDuration = 0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)

# Connexion à l'Arduino réussie - Déclaration des entrées et sorties
    
Set_Tone_Pin(board, PinTone)
for i in range(5):
    Set_DigitalInput_Pin(board, PinButton[i])

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter")


# Boucle principale du programme

while True:
    try:       
        if Digital_Read(board, PinButton[0])==1:
            PlayNote = True
            Note = 0
        elif Digital_Read(board, PinButton[1])==1:
            PlayNote = True
            Note = 1
        elif Digital_Read(board, PinButton[2])==1:
            PlayNote = True
            Note = 2
        elif Digital_Read(board, PinButton[3])==1:
            PlayNote = True
            Note = 3
        elif Digital_Read(board, PinButton[4])==1:
            PlayNote = True
            Note = 4

        if PlayNote == True :
            NoteDuration = int(1000/NoteDurations[Note])
            Tone(board, PinTone, Notes[Note], NoteDuration)
            time.sleep(1.3*NoteDuration/1000)  
            PlayNote = False

    except KeyboardInterrupt:
        No_Tone(board, PinTone)
        Arduino_Exit(board)
        sys.exit(0)
