# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time

def dec2bin(d, nb=0):
    if d == 0:
        b = "0"
    else:
        b = ""
        while d != 0:
            b = "01"[d & 1] + b
            d = d >> 1
    return b.zfill(nb)

def bin2dec(b):
    return int(b, 2)

def CalculFreq(valpot1, valpot2):
    valpot1bin = dec2bin(int(valpot1/4))
    valpot1bin= valpot1bin+'0000'
    valpot2bin = dec2bin(int(valpot2/4),12)
    freq = bin2dec(valpot1bin) + bin2dec(valpot2bin)
    return freq


# Déclaration des constantes et variables

PinButton = 12
PinTone = 3
PinPot = [1,2]
ValButton=0
OldValButton=0
State = 0
ValPot=[0,0]
FreqWave=0


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)


# Connexion à l'Arduino réussie - Déclaration des entrées et sorties
    
Set_Tone_Pin(board, PinTone)
Set_AnalogInput_Pin(board, PinPot[0])
Set_AnalogInput_Pin(board, PinPot[1])
Set_DigitalInput_Pin(board, PinButton)

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter")


# Boucle principale du programme

while True:
    try:
        ValButton = Digital_Read(board, PinButton)
        time.sleep(0.01)
        if ValButton == 1 and OldValButton==0:
            State = 1 - State
        OldValButton = ValButton
        if State==1:
            for i in range(2):
                ValPot[i]= Analog_Read(board, PinPot[i])                 
            FreqWave = CalculFreq(ValPot[0],ValPot[1])
            Tone(board, PinTone, FreqWave, 0)         
        else:
            No_Tone(board, PinTone)                
        
    except KeyboardInterrupt:
        No_Tone(board, PinTone)
        Arduino_Exit(board)
        sys.exit(0)
