// Déclaration des constantes et variables

int TRIGGER_PIN = 8; 
int ECHO_PIN = 9;
const int PinButton = 7;   

const unsigned long MEASURE_TIMEOUT = 25000UL;

int ValButton = 0;
int OldValButton = 0;
int State = 0;
int OldState = 0;

long DtMesure = 0;
long Dt = 0.0;
int Distance = 0;
float Vitesse = 0.0;


// Initialisation des entrées et sorties

void setup() 
{  
Serial.begin(9600);
pinMode(PinButton,INPUT);
pinMode(TRIGGER_PIN, OUTPUT);
digitalWrite(TRIGGER_PIN, LOW); 
if (ECHO_PIN != TRIGGER_PIN){
pinMode(ECHO_PIN, INPUT);}

while(Distance<3 || Distance>200)  
  { 
  int Val=0; 
  char tampon[10]="";      
  Serial.println("Veuillez entrer la distance en cm entre le capteur et l'obstacle (valeur entre 3 et 200):");
  while(!Val)  
    { 
    delay(200); 
    Val=Serial.available();
    }
  for (int i=0; i < Val; i++)
    { 
    tampon[i]=Serial.read();
    delay(15); 
    } 
  Distance = atoi(tampon); 
  }
Serial.print("Distance entre le capteur et l'obstacle = ");    Serial.print(Distance);    Serial.println(" cm");
Serial.println("Appuyez sur le bouton poussoir pour mesurer la duree de propagation de l'onde sonore.");
}


// Fonction principale en boucle

void loop() 
{
ValButton = digitalRead(PinButton);
delay(10);
if ((ValButton == HIGH)&&(OldValButton == LOW)) 
  {
  State=1-State;
  }
OldValButton = ValButton;

if (State==1) 
{
  if (OldState == 0)
  {
   Serial.println("Mesure de la duree de propagation de l'onde sonore en cours.");
   Serial.println("");
   Serial.println("Dt (microS) ; Vitesse onde sonore (m/s):");  
   OldState=1;
  }
  
  if (ECHO_PIN != TRIGGER_PIN){
  digitalWrite(TRIGGER_PIN, HIGH);
  delayMicroseconds(10);
  digitalWrite(TRIGGER_PIN, LOW);
  Dt = pulseIn(ECHO_PIN, HIGH, MEASURE_TIMEOUT);}
  else {
  pinMode(TRIGGER_PIN, OUTPUT);
  digitalWrite(TRIGGER_PIN, LOW);
  delayMicroseconds(2);
  digitalWrite(TRIGGER_PIN, HIGH);
  delayMicroseconds(5);
  digitalWrite(TRIGGER_PIN,LOW);
  pinMode(ECHO_PIN,INPUT);
  Dt = pulseIn(ECHO_PIN,HIGH);}

  if (DtMesure != Dt)
  {
  Vitesse = 2*float(Distance)/Dt*10000;
  Serial.print(Dt); Serial.print(" ; ");  Serial.println(int(Vitesse));
  DtMesure = Dt ;  
  }
  Serial.flush();
  delay(100);
}
else
{
  if (OldState == 1){
  Serial.println("Fin des mesures (Appuyez sur le bouton Reset pour modifier la distance).");
  OldState = 0;}
}   
}
