# Importations des librairies et définition des fonctions

from PymataExpressDef import *
from ConnectToArduino import *
import time

async def Get_Dt(data):
    global Dt
    Dt = data[1]*56
       
def Set_Sonar_Pins(board, trigger_pin, echo_pin):
    loop.run_until_complete(board.set_pin_mode_sonar(trigger_pin, echo_pin, Get_Dt))
    
def Sonar_Read(board, trigger_pin):
    loop.run_until_complete(board.sonar_read(trigger_pin))


# Déclaration des constantes et variables

TRIGGER_PIN = 8 
ECHO_PIN = 9
PinButton = 7

ValButton=0
OldValButton=0
State = 0
OldState = 0

Distance = 0
Vitesse = 0
Dt = 0
DtMesure = 0
Distancechoisie = False


# Connexion à l'Arduino

PortComArduino = SelectPortCOM()
board = OpenPortCom(PortComArduino)

    
# Connexion à l'Arduino réussie - Déclaration des entrées et sorties
    
Set_Sonar_Pins(board, TRIGGER_PIN, ECHO_PIN)
Set_DigitalInput_Pin(board, PinButton) 

print("Connexion à l'arduino établie - Appuyez sur Ctrl-C pour quitter\n")
    

# Boucle principale du programme

print("Appuyez sur le bouton poussoir pour mesurer la durée de propagation de l'onde sonore.")

while True:
    try:
        ValButton = Digital_Read(board, PinButton)
        time.sleep(0.01)
        if ValButton == 1 and OldValButton==0:
            State = 1 - State
        OldValButton = ValButton
        if State==1:
            if OldState == 0:
                while Distancechoisie==False:
                    Distance = input("\nVeuillez entrer la distance en cm entre le capteur et l'obstacle:")
                    try:
                        Distance = int(Distance)

                        assert Distance >= 3 and Distance <= 200
                        Distancechoisie = True

                    except AssertionError:
                        print("La distance choisie n'est pas entre 3 et 200 cm!")
                        Distancechoisie = False
            
                    except:
                        print("vous n'avez pas saisi une distance entre 3 et 200 cm!")
                        Distancechoisie = False

                OldState=1
                print("\nMesure de la durée de propagation de l'onde sonore en cours.")
                print("\nDistance (cm) ; Dt (microS) ; Vitesse onde sonore (m/s) :\n")
                
            Sonar_Read(board,TRIGGER_PIN)
            if DtMesure != Dt:
                Vitesse=int(2*int(Distance) / Dt * 10000)
                print(Distance, " ; ", Dt , " ; ", Vitesse)
                DtMesure = Dt                
            time.sleep(.01)
        else:
            if OldState == 1:
                print("\nFin des mesures.")
                OldState = 0
                Distancechoisie = False
                           
    except KeyboardInterrupt:
        Arduino_Exit(board)
        sys.exit(0)
